/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.filter.TIFFFaxDecoder;
import com.plpdf.io.IOUtils;
import com.plpdf.io.ccitt.CCITTFaxG31DDecodeInputStream;
import com.plpdf.io.ccitt.FillOrderChangeInputStream;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CCITTFaxDecodeFilter
implements Filter {
    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        OMBase decodeP = options.getDictionaryObject(OMName.DECODE_PARMS, OMName.DP);
        OMDictionary decodeParms = null;
        if (decodeP instanceof OMDictionary) {
            decodeParms = (OMDictionary)decodeP;
        } else if (decodeP instanceof OMArray) {
            decodeParms = (OMDictionary)((OMArray)decodeP).getObject(filterIndex);
        }
        int length = options.getInt(OMName.LENGTH, -1);
        byte[] compressed = null;
        if (length != -1) {
            compressed = new byte[length];
            long written = IOUtils.populateBuffer(compressedData, compressed);
            int cfr_ignored_0 = compressed.length;
        } else {
            compressed = IOUtils.toByteArray(compressedData);
        }
        int cols = decodeParms.getInt(OMName.COLUMNS, 1728);
        int rows = decodeParms.getInt(OMName.ROWS, 0);
        int height = options.getInt(OMName.HEIGHT, OMName.H, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        int k = decodeParms.getInt(OMName.K, 0);
        int arraySize = (cols + 7) / 8 * rows;
        TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
        long tiffOptions = 0L;
        if (k == 0) {
            InputStream in = new CCITTFaxG31DDecodeInputStream(new ByteArrayInputStream(compressed), cols);
            in = new FillOrderChangeInputStream(in);
            IOUtils.copy(in, result);
            in.close();
        } else if (k > 0) {
            byte[] decompressed = new byte[arraySize];
            faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
            result.write(decompressed);
        } else if (k < 0) {
            byte[] decompressed = new byte[arraySize];
            faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions);
            result.write(decompressed);
        }
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
    }
}

