/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.io.ASCII85InputStream;
import com.plpdf.io.ASCII85OutputStream;
import com.plpdf.om.OMDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASCII85Filter
implements Filter {
    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        ASCII85InputStream is = null;
        try {
            is = new ASCII85InputStream(compressedData);
            byte[] buffer = new byte[1024];
            int amountRead = 0;
            while ((amountRead = is.read(buffer, 0, 1024)) != -1) {
                result.write(buffer, 0, amountRead);
            }
            result.flush();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        ASCII85OutputStream os = new ASCII85OutputStream(result);
        byte[] buffer = new byte[1024];
        int amountRead = 0;
        while ((amountRead = rawData.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, amountRead);
        }
        os.close();
        result.flush();
    }
}

