/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PlpdfException
extends Exception {
    private static final String RESOURCE_NAME = "plpdfMessages";
    private static ResourceBundle PLPDF_MESSAGES = null;
    private static Locale locale = null;
    private String module;
    private String message;
    private String[] args;

    static {
        try {
            PLPDF_MESSAGES = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException mre) {
            System.out.println("PlpdfException: No resource file found with name: plpdfMessages");
            throw mre;
        }
    }

    public PlpdfException(String module, String message) {
        this.module = module;
        this.message = message;
    }

    public PlpdfException(String module, String message, String[] args) {
        this.module = module;
        this.message = message;
        this.args = (String[])args.clone();
    }

    public PlpdfException(String module, String message, Throwable t) {
        super(t);
        this.module = module;
        this.message = message;
    }

    public PlpdfException(String module, String message, String[] args, Throwable t) {
        super(t);
        this.module = module;
        this.message = message;
        this.args = (String[])args.clone();
    }

    public PlpdfException(String message) {
        this.message = message;
    }

    public PlpdfException(String message, Throwable t) {
        super(t);
        this.message = message;
    }

    public PlpdfException(String message, String[] args) {
        this.message = message;
        this.args = (String[])args.clone();
    }

    public PlpdfException(String message, String[] args, Throwable t) {
        super(t);
        this.message = message;
        this.args = (String[])args.clone();
    }

    public PlpdfException(Throwable t) {
        super(t);
    }

    public String getMessage() {
        String returnMessage = null;
        String key = null;
        if (this.module != null && this.module.length() > 0) {
            key = this.module;
            if (this.message != null && this.message.length() > 0) {
                key = key.concat(".").concat(this.message);
            }
        }
        if (key != null) {
            try {
                returnMessage = PLPDF_MESSAGES.getString(key);
            }
            catch (Exception e) {
                String errorMessage = "PlpdfException.getMessage(): Message can not be retrieved from plpdfMessages" + (locale != null ? " for locale " + locale : "") + " with key: " + key;
                System.out.println(errorMessage);
                throw new RuntimeException(String.valueOf(errorMessage) + "\n" + e.toString());
            }
        }
        try {
            returnMessage = PLPDF_MESSAGES.getString(this.message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnMessage != null) {
            if (this.args != null) {
                returnMessage = MessageFormat.format(returnMessage, this.args);
            }
        } else {
            returnMessage = this.message;
        }
        if (returnMessage == null) {
            if (this.module != null || this.message != null) {
                returnMessage = "No message found for module: " + this.module + ", key/message: " + this.message;
            } else if (this.getCause() != null) {
                returnMessage = "Caused by: " + this.getCause().toString();
            }
        } else {
            if (this.module != null && this.module.length() > 0) {
                returnMessage = String.valueOf(this.module) + " - " + returnMessage;
            }
            if (this.getCause() != null) {
                returnMessage = String.valueOf(returnMessage) + "\nCaused by: " + this.getCause();
            }
        }
        return returnMessage;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        return sw.toString();
    }
}

