/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encryption;

import com.plpdf.encryption.PDFEncryption;
import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.InvalidPasswordException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.SMStandardEncryption;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentEncryption {
    private SMDocument pdDocument = null;
    private OMDocument document = null;
    private byte[] encryptionKey = null;
    private PDFEncryption encryption = new PDFEncryption();
    private Set objects = new HashSet();
    private Set potentialSignatures = new HashSet();

    public DocumentEncryption(SMDocument doc) {
        this.pdDocument = doc;
        this.document = doc.getDocument();
    }

    public DocumentEncryption(OMDocument doc) {
        this.pdDocument = new SMDocument(doc);
        this.document = doc;
    }

    public void initForEncryption() throws CryptographyException, IOException {
        String ownerPassword = this.pdDocument.getOwnerPasswordForEncryption();
        String userPassword = this.pdDocument.getUserPasswordForEncryption();
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        SMStandardEncryption encParameters = (SMStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissionInt = encParameters.getPermissions();
        int revision = encParameters.getRevision();
        int length = encParameters.getLength() / 8;
        OMArray idArray = this.document.getDocumentID();
        if (idArray == null || idArray.size() < 2) {
            idArray = new OMArray();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes("ISO-8859-1"));
                md.update(userPassword.getBytes("ISO-8859-1"));
                md.update(this.document.toString().getBytes());
                byte[] id = md.digest(this.toString().getBytes("ISO-8859-1"));
                OMString idString = new OMString();
                idString.append(id);
                idArray.add(idString);
                idArray.add(idString);
                this.document.setDocumentID(idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
        }
        OMString id = (OMString)idArray.getObject(0);
        this.encryption = new PDFEncryption();
        byte[] o = this.encryption.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), revision, length);
        byte[] u = this.encryption.computeUserPassword(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), revision, length);
        this.encryptionKey = this.encryption.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), revision, length);
        encParameters.setOwnerKey(o);
        encParameters.setUserKey(u);
        this.document.setEncryptionDictionary(encParameters.getOMDictionary());
    }

    public void decryptDocument(String password) throws CryptographyException, IOException, InvalidPasswordException {
        if (password == null) {
            password = "";
        }
        SMStandardEncryption encParameters = (SMStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissions = encParameters.getPermissions();
        int revision = encParameters.getRevision();
        int length = encParameters.getLength() / 8;
        OMString id = (OMString)this.document.getDocumentID().getObject(0);
        byte[] u = encParameters.getUserKey();
        byte[] o = encParameters.getOwnerKey();
        boolean isUserPassword = this.encryption.isUserPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id.getBytes(), revision, length);
        boolean isOwnerPassword = this.encryption.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o, permissions, id.getBytes(), revision, length);
        if (isUserPassword) {
            this.encryptionKey = this.encryption.computeEncryptedKey(password.getBytes("ISO-8859-1"), o, permissions, id.getBytes(), revision, length);
        } else if (isOwnerPassword) {
            byte[] computedUserPassword = this.encryption.getUserPassword(password.getBytes("ISO-8859-1"), o, revision, length);
            this.encryptionKey = this.encryption.computeEncryptedKey(computedUserPassword, o, permissions, id.getBytes(), revision, length);
        } else {
            throw new InvalidPasswordException("Error: The supplied password does not match either the owner or user password in the document.");
        }
        OMDictionary trailer = this.document.getTrailer();
        OMArray fields = (OMArray)trailer.getObjectFromPath("Root/AcroForm/Fields");
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                OMDictionary field = (OMDictionary)fields.getObject(i);
                this.addDictionaryAndSubDictionary(this.potentialSignatures, field);
                ++i;
            }
        }
        List<OMObject> allObjects = this.document.getObjects();
        Iterator<OMObject> objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject(objectIter.next());
        }
        this.document.setEncryptionDictionary(null);
    }

    private void addDictionaryAndSubDictionary(Set set, OMDictionary dic) {
        set.add(dic);
        OMArray kids = (OMArray)dic.getDictionaryObject(OMName.KIDS);
        int i = 0;
        while (kids != null && i < kids.size()) {
            this.addDictionaryAndSubDictionary(set, (OMDictionary)kids.getObject(i));
            ++i;
        }
        OMBase value = dic.getDictionaryObject(OMName.V);
        if (value instanceof OMDictionary) {
            this.addDictionaryAndSubDictionary(set, (OMDictionary)value);
        }
    }

    private void decryptObject(OMObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        OMBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    public void decrypt(Object obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof OMString) {
                this.decryptString((OMString)obj, objNum, genNum);
            } else if (obj instanceof OMStream) {
                this.decryptStream((OMStream)obj, objNum, genNum);
            } else if (obj instanceof OMDictionary) {
                this.decryptDictionary((OMDictionary)obj, objNum, genNum);
            } else if (obj instanceof OMArray) {
                this.decryptArray((OMArray)obj, objNum, genNum);
            }
        }
    }

    private void decryptStream(OMStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream, objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, encryptedStream, stream.createFilteredStream());
    }

    private void decryptDictionary(OMDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        for (Map.Entry<OMName, OMBase> entry : dictionary.entrySet()) {
            if (entry.getKey().getName().equals("Contents") && entry.getValue() instanceof OMString && this.potentialSignatures.contains(dictionary)) continue;
            this.decrypt(entry.getValue(), objNum, genNum);
        }
    }

    private void decryptString(OMString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, data, buffer);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(OMArray array, long objNum, long genNum) throws CryptographyException, IOException {
        int i = 0;
        while (i < array.size()) {
            this.decrypt(array.get(i), objNum, genNum);
            ++i;
        }
    }
}

