/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encoding.conversion;

import java.util.HashMap;
import java.util.Iterator;

class CJKEncodings {
    private static HashMap charsetMapping = new HashMap();

    static {
        charsetMapping.put("GB-EUC-H", "GB2312");
        charsetMapping.put("GB-EUC-V", "GB2312");
        charsetMapping.put("GBpc-EUC-H", "GB2312");
        charsetMapping.put("GBpc-EUC-V", "GB2312");
        charsetMapping.put("GBK-EUC-H", "GBK");
        charsetMapping.put("GBK-EUC-V", "GBK");
        charsetMapping.put("GBKp-EUC-H", "GBK");
        charsetMapping.put("GBKp-EUC-V", "GBK");
        charsetMapping.put("GBK2K-H", "GB18030");
        charsetMapping.put("GBK2K-V", "GB18030");
        charsetMapping.put("UniGB-UCS2-H", "ISO-10646-UCS-2");
        charsetMapping.put("UniGB-UCS2-V", "ISO-10646-UCS-2");
        charsetMapping.put("UniGB-UTF16-H", "UTF-16BE");
        charsetMapping.put("UniGB-UTF16-V", "UTF-16BE");
        charsetMapping.put("B5pc-H", "BIG5");
        charsetMapping.put("B5pc-V", "BIG5");
        charsetMapping.put("HKscs-B5-H", "Big5-HKSCS");
        charsetMapping.put("HKscs-B5-V", "Big5-HKSCS");
        charsetMapping.put("ETen-B5-H", "BIG5");
        charsetMapping.put("ETen-B5-V", "BIG5");
        charsetMapping.put("ETenms-B5-H", "BIG5");
        charsetMapping.put("ETenms-B5-V", "BIG5");
        charsetMapping.put("CNS-EUC-H", "HZ");
        charsetMapping.put("CNS-EUC-V", "HZ");
        charsetMapping.put("UniCNS-UCS2-H", "ISO-10646-UCS-2");
        charsetMapping.put("UniCNS-UCS2-V", "ISO-10646-UCS-2");
        charsetMapping.put("UniCNS-UTF16-H", "UTF-16BE");
        charsetMapping.put("UniCNS-UTF16-V", "UTF-16BE");
        charsetMapping.put("83pv-RKSJ-H", "JIS");
        charsetMapping.put("90ms-RKSJ-H", "JIS");
        charsetMapping.put("90ms-RKSJ-V", "JIS");
        charsetMapping.put("90msp-RKSJ-H", "JIS");
        charsetMapping.put("90msp-RKSJ-V", "JIS");
        charsetMapping.put("90pv-RKSJ-H", "JIS");
        charsetMapping.put("Add-RKSJ-H", "JIS");
        charsetMapping.put("Add-RKSJ-V", "JIS");
        charsetMapping.put("EUC-H", "JIS");
        charsetMapping.put("EUC-V", "JIS");
        charsetMapping.put("Ext-RKSJ-H", "JIS");
        charsetMapping.put("Ext-RKSJ-V", "JIS");
        charsetMapping.put("H", "JIS");
        charsetMapping.put("V", "JIS");
        charsetMapping.put("UniJIS-UCS2-H", "ISO-10646-UCS-2");
        charsetMapping.put("UniJIS-UCS2-V", "ISO-10646-UCS-2");
        charsetMapping.put("UniJIS-UCS2-HW-H", "ISO-10646-UCS-2");
        charsetMapping.put("UniJIS-UCS2-HW-V", "ISO-10646-UCS-2");
        charsetMapping.put("UniJIS-UTF16-H", "UTF-16BE");
        charsetMapping.put("UniJIS-UTF16-V", "UTF-16BE");
        charsetMapping.put("Identity-H", "JIS");
        charsetMapping.put("Identity-V", "JIS");
        charsetMapping.put("KSC-EUC-H", "KSC");
        charsetMapping.put("KSC-EUC-V", "KSC");
        charsetMapping.put("KSCms-UHC-H", "KSC");
        charsetMapping.put("KSCms-UHC-V", "KSC");
        charsetMapping.put("KSCms-UHC-HW-H", "KSC");
        charsetMapping.put("KSCms-UHC-HW-V", "KSC");
        charsetMapping.put("KSCpc-EUC-H", "KSC");
        charsetMapping.put("UniKS-UCS2-H", "ISO-10646-UCS-2");
        charsetMapping.put("UniKS-UCS2-V", "ISO-10646-UCS-2");
        charsetMapping.put("UniKS-UTF16-H", "UTF-16BE");
        charsetMapping.put("UniKS-UTF16-V", "UTF-16BE");
    }

    private CJKEncodings() {
    }

    public static final String getCharset(String encoding) {
        if (encoding.startsWith("OMName")) {
            encoding = encoding.substring(8, encoding.length() - 1);
        }
        return (String)charsetMapping.get(encoding);
    }

    public static final Iterator getEncodingIterator() {
        return charsetMapping.keySet().iterator();
    }
}

