/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encoding.conversion;

import com.plpdf.encoding.conversion.CJKEncodings;
import com.plpdf.encoding.conversion.EncodingConverter;
import com.plpdf.font.cmap.CMap;
import java.io.UnsupportedEncodingException;

public class CJKConverter
implements EncodingConverter {
    private String encodingName = null;
    private String charsetName = null;

    public CJKConverter(String encoding) {
        this.encodingName = encoding;
        this.charsetName = CJKEncodings.getCharset(encoding);
    }

    public String convertString(String s) {
        if (s.length() == 1) {
            return s;
        }
        if (this.charsetName.equalsIgnoreCase("UTF-16BE")) {
            return s;
        }
        try {
            return new String(s.getBytes("UTF-16BE"), this.charsetName);
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public String convertBytes(byte[] c, int offset, int length, CMap cmap) {
        if (cmap != null) {
            try {
                if (cmap.isInCodeSpaceRanges(c, offset, length)) {
                    return new String(c, offset, length, this.charsetName);
                }
                return null;
            }
            catch (UnsupportedEncodingException uee) {
                return new String(c, offset, length);
            }
        }
        return null;
    }
}

