/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encoding;

import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.MacRomanEncoding;
import com.plpdf.encoding.PdfDocEncoding;
import com.plpdf.encoding.StandardEncoding;
import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.om.OMName;
import java.io.IOException;

public class EncodingManager {
    public static final EncodingManager INSTANCE = new EncodingManager();

    public Encoding getStandardEncoding() {
        return StandardEncoding.INSTANCE;
    }

    public Encoding getEncoding(OMName name) throws IOException {
        if (OMName.STANDARD_ENCODING.equals(name)) {
            return StandardEncoding.INSTANCE;
        }
        if (OMName.WIN_ANSI_ENCODING.equals(name)) {
            return WinAnsiEncoding.INSTANCE;
        }
        if (OMName.MAC_ROMAN_ENCODING.equals(name)) {
            return MacRomanEncoding.INSTANCE;
        }
        if (OMName.PDF_DOC_ENCODING.equals(name)) {
            return PdfDocEncoding.INSTANCE;
        }
        throw new IOException("Unknown encoding for '" + name.getName() + "'");
    }
}

