/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encoding;

import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Encoding
implements OMObjectable {
    public static final String NOTDEF = ".notdef";
    protected final Map<Integer, String> codeToName = new HashMap<Integer, String>();
    protected final Map<String, Integer> nameToCode = new HashMap<String, Integer>();
    private static final Map<String, String> NAME_TO_CHARACTER;
    private static final Map<String, String> CHARACTER_TO_NAME;

    static {
        File external;
        NAME_TO_CHARACTER = new HashMap<String, String>();
        CHARACTER_TO_NAME = new HashMap<String, String>();
        Encoding.loadGlyphList("com/plpdf/res/glyphlist.txt");
        Encoding.loadGlyphList("com/plpdf/res/additional_glyphlist.txt");
        String location = System.getProperty("glyphlist_ext");
        if (location != null && (external = new File(location)).exists()) {
            Encoding.loadGlyphList(location);
        }
        NAME_TO_CHARACTER.put(NOTDEF, "");
        NAME_TO_CHARACTER.put("fi", "fi");
        NAME_TO_CHARACTER.put("fl", "fl");
        NAME_TO_CHARACTER.put("ffi", "ffi");
        NAME_TO_CHARACTER.put("ff", "ff");
        NAME_TO_CHARACTER.put("pi", "pi");
        for (Map.Entry<String, String> entry : NAME_TO_CHARACTER.entrySet()) {
            CHARACTER_TO_NAME.put(entry.getValue(), entry.getKey());
        }
    }

    private static void loadGlyphList(String location) {
        block17: {
            BufferedReader glyphStream = null;
            try {
                try {
                    InputStream resource = ResourceLoader.loadResource(location);
                    if (resource == null) {
                        throw new MissingResourceException("Glyphlist not found: " + location, Encoding.class.getName(), location);
                    }
                    glyphStream = new BufferedReader(new InputStreamReader(resource));
                    String line = null;
                    while ((line = glyphStream.readLine()) != null) {
                        int semicolonIndex;
                        if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                        String unicodeValue = null;
                        try {
                            String characterName = line.substring(0, semicolonIndex);
                            unicodeValue = line.substring(semicolonIndex + 1, line.length());
                            StringTokenizer tokenizer = new StringTokenizer(unicodeValue, " ", false);
                            StringBuilder value = new StringBuilder();
                            while (tokenizer.hasMoreTokens()) {
                                int characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                                value.append((char)characterCode);
                            }
                            if (NAME_TO_CHARACTER.containsKey(characterName)) continue;
                            NAME_TO_CHARACTER.put(characterName, value.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException iOException) {
                    if (glyphStream == null) break block17;
                    try {
                        glyphStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (glyphStream != null) {
                    try {
                        glyphStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public Map<Integer, String> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }

    public Map<String, Integer> getNameToCodeMap() {
        return Collections.unmodifiableMap(this.nameToCode);
    }

    public void addCharacterEncoding(int code, String name) {
        this.codeToName.put(code, name);
        this.nameToCode.put(name, code);
    }

    public int getCode(String name) throws IOException {
        Integer code = this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name + "'");
        }
        return code;
    }

    public String getName(int code) throws IOException {
        return this.codeToName.get(code);
    }

    public String getNameFromCharacter(char c) throws IOException {
        String name = CHARACTER_TO_NAME.get(Character.toString(c));
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String name = this.getName(code);
        if (name != null) {
            return this.getCharacter(this.getName(code));
        }
        return null;
    }

    public String getCharacter(String name) {
        String character = NAME_TO_CHARACTER.get(name);
        if (character == null) {
            if (name.indexOf(46) > 0) {
                character = this.getCharacter(name.substring(0, name.indexOf(46)));
            } else if (name.startsWith("uni")) {
                int nameLength = name.length();
                StringBuilder uniStr = new StringBuilder();
                try {
                    int chPos = 3;
                    while (chPos + 4 <= nameLength) {
                        int characterCode = Integer.parseInt(name.substring(chPos, chPos + 4), 16);
                        if (characterCode <= 55295 || characterCode >= 57344) {
                            uniStr.append((char)characterCode);
                        }
                        chPos += 4;
                    }
                    character = uniStr.toString();
                    NAME_TO_CHARACTER.put(name, character);
                }
                catch (NumberFormatException nfe) {
                    character = name;
                }
            } else if (name.startsWith("u")) {
                try {
                    int characterCode = Integer.parseInt(name.substring(1), 16);
                    if (characterCode <= 55295 || characterCode >= 57344) {
                        character = String.valueOf((char)characterCode);
                        NAME_TO_CHARACTER.put(name, character);
                    }
                }
                catch (NumberFormatException nfe) {
                    character = name;
                }
            } else if (this.nameToCode.containsKey(name)) {
                int code = this.nameToCode.get(name);
                character = Character.toString((char)code);
            } else {
                character = name;
            }
        }
        return character;
    }

    public static String getCharacterForName(String name) {
        if (NAME_TO_CHARACTER.containsKey(name)) {
            return NAME_TO_CHARACTER.get(name);
        }
        return null;
    }
}

