/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.encoding;

import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.EncodingManager;
import com.plpdf.encoding.StandardEncoding;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import java.io.IOException;

public class DictionaryEncoding
extends Encoding {
    private OMDictionary encoding = null;

    public DictionaryEncoding(OMDictionary fontEncoding) throws IOException {
        this.encoding = fontEncoding;
        Encoding baseEncoding = StandardEncoding.INSTANCE;
        OMName baseEncodingName = (OMName)this.encoding.getDictionaryObject(OMName.BASE_ENCODING);
        if (baseEncodingName != null) {
            baseEncoding = EncodingManager.INSTANCE.getEncoding(baseEncodingName);
        }
        this.nameToCode.putAll(baseEncoding.nameToCode);
        this.codeToName.putAll(baseEncoding.codeToName);
        OMArray differences = (OMArray)this.encoding.getDictionaryObject(OMName.DIFFERENCES);
        int currentIndex = -1;
        int i = 0;
        while (differences != null && i < differences.size()) {
            OMBase next = differences.getObject(i);
            if (next instanceof OMNumber) {
                currentIndex = ((OMNumber)next).intValue();
            } else if (next instanceof OMName) {
                OMName name = (OMName)next;
                this.addCharacterEncoding(currentIndex++, name.getName());
            }
            ++i;
        }
    }

    public OMBase getOMObject() {
        return this.encoding;
    }
}

