/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.charsets;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class ByteLookupCharset
extends Charset {
    int[] BYTE_TO_CHAR;
    int[][] CHAR_TO_BYTE;

    static boolean isJDK15() {
        float version;
        try {
            version = Float.parseFloat(System.getProperty("java.class.version"));
        }
        catch (Exception e) {
            version = 0.0f;
        }
        return (double)version >= 49.0;
    }

    protected static int[] mutate(int[] src, int[] ind, int[] val) {
        int[] mut = new int[src.length];
        System.arraycopy(src, 0, mut, 0, src.length);
        int i = 0;
        while (i < ind.length) {
            mut[ind[i]] = val[i];
            ++i;
        }
        return mut;
    }

    public static int[][] createInverseLookupTable(int[] chars) {
        int[][] tables = new int[256][];
        int i = 0;
        while (i < 256) {
            int c = chars[i];
            if (c > -1) {
                int high = c >>> 8 & 0xFF;
                int low = c & 0xFF;
                int[] table = tables[high];
                if (table == null) {
                    table = new int[256];
                    int j = 0;
                    while (j < table.length) {
                        table[j] = -1;
                        ++j;
                    }
                    tables[high] = table;
                }
                table[low] = i;
            }
            ++i;
        }
        return tables;
    }

    public static String createInverseLookupTableDefinition(int[] chars) {
        int[][] tables = ByteLookupCharset.createInverseLookupTable(chars);
        StringBuffer sb = new StringBuffer();
        int nulls = 0;
        sb.append("static final int[][] CHAR_TO_BYTE = {\n\t");
        int i = 0;
        while (i < tables.length) {
            int[] table = tables[i];
            if (table == null) {
                if (nulls++ % 8 == 0 && nulls > 1) {
                    sb.append("\n\t");
                }
                sb.append("null, ");
            } else {
                if (nulls > 0) {
                    sb.append("\n\t");
                }
                nulls = 0;
                sb.append("{ // high byte = 0x");
                if (i < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(i));
                sb.append("\n\t");
                int j = 0;
                while (j < table.length) {
                    if (table[j] == -1) {
                        sb.append("  -1, ");
                    } else {
                        sb.append("0x");
                        if (table[j] < 16) {
                            sb.append('0');
                        }
                        sb.append(Integer.toHexString(table[j])).append(", ");
                    }
                    if ((j + 1) % 8 == 0) {
                        sb.append("\n\t");
                    }
                    ++j;
                }
                sb.append("}, \n\t");
            }
            ++i;
        }
        sb.append("\n\t};");
        return sb.toString();
    }

    protected ByteLookupCharset(String canonicalName, String[] aliases, int[] byteToChar, int[][] charToByte) {
        super(canonicalName, aliases);
        this.BYTE_TO_CHAR = byteToChar;
        this.CHAR_TO_BYTE = charToByte;
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int[] lookup = ByteLookupCharset.this.BYTE_TO_CHAR;
            int remaining = in.remaining();
            while (remaining-- > 0) {
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                int c = lookup[in.get() & 0xFF];
                if (c == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put((char)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int[][] lookup = ByteLookupCharset.this.CHAR_TO_BYTE;
            int remaining = in.remaining();
            while (remaining-- > 0) {
                int b;
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int[] table = lookup[c >>> 8];
                int n = b = table == null ? -1 : table[c & 0xFF];
                if (b == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put((byte)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

