/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf;

import com.plpdf.toolkit.Decrypt;
import com.plpdf.toolkit.Encrypt;
import com.plpdf.toolkit.ExportFDF;
import com.plpdf.toolkit.ExportXFDF;
import com.plpdf.toolkit.ExtractFormXObjectText;
import com.plpdf.toolkit.ExtractPages;
import com.plpdf.toolkit.ExtractText;
import com.plpdf.toolkit.GetNumberOfPages;
import com.plpdf.toolkit.GetPDFACompliant;
import com.plpdf.toolkit.ImageStamp;
import com.plpdf.toolkit.ImageWaterMark;
import com.plpdf.toolkit.ImportFDF;
import com.plpdf.toolkit.ImportXFDF;
import com.plpdf.toolkit.MergeEncrypt;
import com.plpdf.toolkit.MetadataFromXML;
import com.plpdf.toolkit.MetadataToXML;
import com.plpdf.toolkit.Overlay2;
import com.plpdf.toolkit.PDFMerger;
import com.plpdf.toolkit.PDFMergerX;
import com.plpdf.toolkit.PrintURLs;
import com.plpdf.toolkit.PublicKeyDecrypt;
import com.plpdf.toolkit.PublicKeyEncrypt;
import com.plpdf.toolkit.Rebuild;
import com.plpdf.toolkit.ReplaceString;
import com.plpdf.toolkit.ReplaceURL;
import com.plpdf.toolkit.ReplaceUrlsXML;
import com.plpdf.toolkit.RubberStamp;
import com.plpdf.toolkit.SetImageCompress;
import com.plpdf.toolkit.SetOpenActionJS;
import com.plpdf.toolkit.TextStamp;
import com.plpdf.toolkit.TextWaterMark;
import com.plpdf.toolkit.VerifySignature;
import com.plpdf.toolkit.Version;
import com.plpdf.toolkit.setFieldsReadonly;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.NUMBER;

public class PlpdfToolkit {
    private PlpdfToolkit() {
    }

    public static String encrypt(BLOB inputFile, BLOB outputFile, CHAR ownerPassword, CHAR userPassword, NUMBER keyLength, CHAR canAssemble, CHAR canExtractContent, CHAR canExtractForAccessibility, CHAR canFillInForm, CHAR canModify, CHAR canModifyAnnotations, CHAR canPrint, CHAR canPrintDegraded, CHAR algorithm, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iOwnerPassword = ownerPassword != null ? ownerPassword.getString() : "";
            String iUserPassword = userPassword != null ? userPassword.getString() : "";
            NUMBER iKeyLength = keyLength != null ? keyLength : new NUMBER(0);
            String iCanAssemble = canAssemble != null ? canAssemble.getString() : "";
            String iCanExtractContent = canExtractContent != null ? canExtractContent.getString() : "";
            String iCanExtractForAccessibility = canExtractForAccessibility != null ? canExtractForAccessibility.getString() : "";
            String iCanFillInForm = canFillInForm != null ? canFillInForm.getString() : "";
            String iCanModify = canModify != null ? canModify.getString() : "";
            String iCanModifyAnnotations = canModifyAnnotations != null ? canModifyAnnotations.getString() : "";
            String iCanPrint = canPrint != null ? canPrint.getString() : "";
            String iCanPrintDegraded = canPrintDegraded != null ? canPrintDegraded.getString() : "";
            String ialgorithm = algorithm != null ? algorithm.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            Encrypt.encrypt(inputStream, outputStream, iOwnerPassword, iUserPassword, iKeyLength.intValue(), iCanAssemble, iCanExtractContent, iCanExtractForAccessibility, iCanFillInForm, iCanModify, iCanModifyAnnotations, iCanPrint, iCanPrintDegraded, ialgorithm, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String decrypt(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            Decrypt.decrypt(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String publicKeyEncrypt(BLOB inputFile, BLOB outputFile, BLOB certFile, NUMBER keyLength, CHAR canAssemble, CHAR canExtractContent, CHAR canExtractForAccessibility, CHAR canFillInForm, CHAR canModify, CHAR canModifyAnnotations, CHAR canPrint, CHAR canPrintDegraded, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream certStream = null;
            if (certFile != null) {
                certStream = certFile.getBinaryStream();
            }
            NUMBER iKeyLength = keyLength != null ? keyLength : new NUMBER(0);
            String iCanAssemble = canAssemble != null ? canAssemble.getString() : "";
            String iCanExtractContent = canExtractContent != null ? canExtractContent.getString() : "";
            String iCanExtractForAccessibility = canExtractForAccessibility != null ? canExtractForAccessibility.getString() : "";
            String iCanFillInForm = canFillInForm != null ? canFillInForm.getString() : "";
            String iCanModify = canModify != null ? canModify.getString() : "";
            String iCanModifyAnnotations = canModifyAnnotations != null ? canModifyAnnotations.getString() : "";
            String iCanPrint = canPrint != null ? canPrint.getString() : "";
            String iCanPrintDegraded = canPrintDegraded != null ? canPrintDegraded.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            PublicKeyEncrypt.publicKeyEncrypt(inputStream, outputStream, certStream, iKeyLength.intValue(), iCanAssemble, iCanExtractContent, iCanExtractForAccessibility, iCanFillInForm, iCanModify, iCanModifyAnnotations, iCanPrint, iCanPrintDegraded, "RC4", iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String publicKeyDecrypt(BLOB inputFile, BLOB outputFile, BLOB certFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream certStream = null;
            if (certFile != null) {
                certStream = certFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            PublicKeyDecrypt.publicKeyDecrypt(inputStream, outputStream, certStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String exportFDF(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ExportFDF.exportFDF(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String exportXFDF(BLOB inputFile, BLOB outputFile, CHAR exportnull, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            boolean iexportnull = exportnull.getString().equalsIgnoreCase("true");
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ExportXFDF.exportXFDF(inputStream, outputStream, iexportnull, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String extractText(BLOB inputFile, BLOB outputFile, CHAR encoding, NUMBER startPage, NUMBER endPage, CHAR html, CHAR sort, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iEncoding = encoding != null ? encoding.getString() : "";
            NUMBER iStartPage = startPage != null ? startPage : new NUMBER(1);
            NUMBER iEndPage = endPage != null ? endPage : new NUMBER(0);
            String iHtml = html != null ? html.getString() : "";
            String iSort = sort != null ? sort.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ExtractText.extractText(inputStream, outputStream, iEncoding, iStartPage.intValue(), iEndPage.intValue(), iHtml, iSort, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String ExtractFormXObjectText(BLOB inputFile, BLOB outputFile, CHAR encoding, NUMBER startPage, NUMBER endPage, CHAR html, CHAR sort, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iEncoding = encoding != null ? encoding.getString() : "";
            NUMBER iStartPage = startPage != null ? startPage : new NUMBER(1);
            NUMBER iEndPage = endPage != null ? endPage : new NUMBER(0);
            String iHtml = html != null ? html.getString() : "";
            String iSort = sort != null ? sort.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ExtractFormXObjectText.extractFormXObjectText(inputStream, outputStream, iEncoding, iStartPage.intValue(), iEndPage.intValue(), iHtml, iSort, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String importFDF(BLOB inputFile, BLOB fdfFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            InputStream fdfStream = null;
            if (fdfFile != null) {
                fdfStream = fdfFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ImportFDF.importFDF(inputStream, fdfStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String importXFDF(BLOB inputFile, BLOB xfdfFile, BLOB outputFile, CHAR password, CHAR needapp, CHAR encoding, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            InputStream xfdfStream = null;
            if (xfdfFile != null) {
                xfdfStream = xfdfFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            String iNeedapp = needapp != null ? needapp.getString() : "";
            String iEncoding = null;
            if (encoding != null) {
                iEncoding = encoding.stringValue();
            }
            ImportXFDF.importXFDF(inputStream, xfdfStream, outputStream, iPassword, iNeedapp, iEncoding, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String overlay(BLOB pdfInputFile, BLOB overlayInputFile, BLOB outputFile, CHAR overlayPassword, CHAR pdfPassword, CHAR certKey) {
        try {
            InputStream pdfInputStream = null;
            if (pdfInputFile != null) {
                pdfInputStream = pdfInputFile.getBinaryStream();
            }
            InputStream overlayInputStream = null;
            if (overlayInputFile != null) {
                overlayInputStream = overlayInputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iOverlayPassword = overlayPassword != null ? overlayPassword.getString() : "";
            String iPdfPassword = pdfPassword != null ? pdfPassword.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            Overlay2.overlay(pdfInputStream, overlayInputStream, outputStream, iOverlayPassword, iPdfPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String merge(BLOB inputFile1, BLOB inputFile2, CHAR password1, CHAR password2, BLOB outputFile, CHAR certKey) {
        try {
            InputStream inputStream1 = null;
            if (inputFile1 != null) {
                inputStream1 = inputFile1.getBinaryStream();
            }
            InputStream inputStream2 = null;
            if (inputFile2 != null) {
                inputStream2 = inputFile2.getBinaryStream();
            }
            String iPassword1 = password1 != null ? password1.getString() : "";
            String iPassword2 = password2 != null ? password2.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            PDFMerger.merge(inputStream1, inputStream2, iPassword1, iPassword2, outputStream, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String mergeX(NUMBER numPDF, BLOB inputFile1, BLOB inputFile2, BLOB inputFile3, BLOB inputFile4, BLOB inputFile5, BLOB inputFile6, BLOB inputFile7, BLOB inputFile8, BLOB inputFile9, BLOB inputFile10, CHAR password1, CHAR password2, CHAR password3, CHAR password4, CHAR password5, CHAR password6, CHAR password7, CHAR password8, CHAR password9, CHAR password10, NUMBER topLeftX1, NUMBER topLeftY1, NUMBER width1, NUMBER height1, NUMBER topLeftX2, NUMBER topLeftY2, NUMBER width2, NUMBER height2, NUMBER topLeftX3, NUMBER topLeftY3, NUMBER width3, NUMBER height3, NUMBER topLeftX4, NUMBER topLeftY4, NUMBER width4, NUMBER height4, NUMBER topLeftX5, NUMBER topLeftY5, NUMBER width5, NUMBER height5, NUMBER topLeftX6, NUMBER topLeftY6, NUMBER width6, NUMBER height6, NUMBER topLeftX7, NUMBER topLeftY7, NUMBER width7, NUMBER height7, NUMBER topLeftX8, NUMBER topLeftY8, NUMBER width8, NUMBER height8, NUMBER topLeftX9, NUMBER topLeftY9, NUMBER width9, NUMBER height9, NUMBER topLeftX10, NUMBER topLeftY10, NUMBER width10, NUMBER height10, NUMBER red1, NUMBER green1, NUMBER blue1, NUMBER red2, NUMBER green2, NUMBER blue2, NUMBER red3, NUMBER green3, NUMBER blue3, NUMBER red4, NUMBER green4, NUMBER blue4, NUMBER red5, NUMBER green5, NUMBER blue5, NUMBER red6, NUMBER green6, NUMBER blue6, NUMBER red7, NUMBER green7, NUMBER blue7, NUMBER red8, NUMBER green8, NUMBER blue8, NUMBER red9, NUMBER green9, NUMBER blue9, NUMBER red10, NUMBER green10, NUMBER blue10, NUMBER topLeftXn, NUMBER topLeftYn, CHAR font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, NUMBER startNumber, NUMBER beginNumber, CHAR nbAlias, CHAR cpAlias, CHAR format, BLOB outputFile, CHAR certKey) {
        try {
            NUMBER inumPDF = numPDF != null ? numPDF : new NUMBER(0);
            InputStream inputStream1 = null;
            if (inputFile1 != null) {
                inputStream1 = inputFile1.getBinaryStream();
            }
            InputStream inputStream2 = null;
            if (inputFile2 != null) {
                inputStream2 = inputFile2.getBinaryStream();
            }
            InputStream inputStream3 = null;
            if (inputFile3 != null) {
                inputStream3 = inputFile3.getBinaryStream();
            }
            InputStream inputStream4 = null;
            if (inputFile4 != null) {
                inputStream4 = inputFile4.getBinaryStream();
            }
            InputStream inputStream5 = null;
            if (inputFile5 != null) {
                inputStream5 = inputFile5.getBinaryStream();
            }
            InputStream inputStream6 = null;
            if (inputFile6 != null) {
                inputStream6 = inputFile6.getBinaryStream();
            }
            InputStream inputStream7 = null;
            if (inputFile7 != null) {
                inputStream7 = inputFile7.getBinaryStream();
            }
            InputStream inputStream8 = null;
            if (inputFile8 != null) {
                inputStream8 = inputFile8.getBinaryStream();
            }
            InputStream inputStream9 = null;
            if (inputFile9 != null) {
                inputStream9 = inputFile9.getBinaryStream();
            }
            InputStream inputStream10 = null;
            if (inputFile10 != null) {
                inputStream10 = inputFile10.getBinaryStream();
            }
            String iPassword1 = password1 != null ? password1.getString() : "";
            String iPassword2 = password2 != null ? password2.getString() : "";
            String iPassword3 = password3 != null ? password3.getString() : "";
            String iPassword4 = password4 != null ? password4.getString() : "";
            String iPassword5 = password5 != null ? password5.getString() : "";
            String iPassword6 = password6 != null ? password6.getString() : "";
            String iPassword7 = password7 != null ? password7.getString() : "";
            String iPassword8 = password8 != null ? password8.getString() : "";
            String iPassword9 = password9 != null ? password9.getString() : "";
            String iPassword10 = password10 != null ? password10.getString() : "";
            NUMBER iTopLeftX1 = topLeftX1 != null ? topLeftX1 : new NUMBER(0.0f);
            NUMBER iTopLeftY1 = topLeftY1 != null ? topLeftY1 : new NUMBER(0.0f);
            NUMBER iwidth1 = width1 != null ? width1 : new NUMBER(0.0f);
            NUMBER iheight1 = height1 != null ? height1 : new NUMBER(0.0f);
            NUMBER iTopLeftX2 = topLeftX2 != null ? topLeftX2 : new NUMBER(0.0f);
            NUMBER iTopLeftY2 = topLeftY2 != null ? topLeftY2 : new NUMBER(0.0f);
            NUMBER iwidth2 = width2 != null ? width2 : new NUMBER(0.0f);
            NUMBER iheight2 = height2 != null ? height2 : new NUMBER(0.0f);
            NUMBER iTopLeftX3 = topLeftX3 != null ? topLeftX3 : new NUMBER(0.0f);
            NUMBER iTopLeftY3 = topLeftY3 != null ? topLeftY3 : new NUMBER(0.0f);
            NUMBER iwidth3 = width3 != null ? width3 : new NUMBER(0.0f);
            NUMBER iheight3 = height3 != null ? height3 : new NUMBER(0.0f);
            NUMBER iTopLeftX4 = topLeftX4 != null ? topLeftX4 : new NUMBER(0.0f);
            NUMBER iTopLeftY4 = topLeftY4 != null ? topLeftY4 : new NUMBER(0.0f);
            NUMBER iwidth4 = width4 != null ? width4 : new NUMBER(0.0f);
            NUMBER iheight4 = height4 != null ? height4 : new NUMBER(0.0f);
            NUMBER iTopLeftX5 = topLeftX5 != null ? topLeftX5 : new NUMBER(0.0f);
            NUMBER iTopLeftY5 = topLeftY5 != null ? topLeftY5 : new NUMBER(0.0f);
            NUMBER iwidth5 = width5 != null ? width5 : new NUMBER(0.0f);
            NUMBER iheight5 = height5 != null ? height5 : new NUMBER(0.0f);
            NUMBER iTopLeftX6 = topLeftX6 != null ? topLeftX6 : new NUMBER(0.0f);
            NUMBER iTopLeftY6 = topLeftY6 != null ? topLeftY6 : new NUMBER(0.0f);
            NUMBER iwidth6 = width6 != null ? width6 : new NUMBER(0.0f);
            NUMBER iheight6 = height6 != null ? height6 : new NUMBER(0.0f);
            NUMBER iTopLeftX7 = topLeftX7 != null ? topLeftX7 : new NUMBER(0.0f);
            NUMBER iTopLeftY7 = topLeftY7 != null ? topLeftY7 : new NUMBER(0.0f);
            NUMBER iwidth7 = width7 != null ? width7 : new NUMBER(0.0f);
            NUMBER iheight7 = height7 != null ? height7 : new NUMBER(0.0f);
            NUMBER iTopLeftX8 = topLeftX8 != null ? topLeftX8 : new NUMBER(0.0f);
            NUMBER iTopLeftY8 = topLeftY8 != null ? topLeftY8 : new NUMBER(0.0f);
            NUMBER iwidth8 = width8 != null ? width8 : new NUMBER(0.0f);
            NUMBER iheight8 = height8 != null ? height8 : new NUMBER(0.0f);
            NUMBER iTopLeftX9 = topLeftX9 != null ? topLeftX9 : new NUMBER(0.0f);
            NUMBER iTopLeftY9 = topLeftY9 != null ? topLeftY9 : new NUMBER(0.0f);
            NUMBER iwidth9 = width9 != null ? width9 : new NUMBER(0.0f);
            NUMBER iheight9 = height9 != null ? height9 : new NUMBER(0.0f);
            NUMBER iTopLeftX10 = topLeftX10 != null ? topLeftX10 : new NUMBER(0.0f);
            NUMBER iTopLeftY10 = topLeftY10 != null ? topLeftY10 : new NUMBER(0.0f);
            NUMBER iwidth10 = width10 != null ? width10 : new NUMBER(0.0f);
            NUMBER iheight10 = height10 != null ? height10 : new NUMBER(0.0f);
            NUMBER ired1 = red1 != null ? red1 : new NUMBER(0);
            NUMBER igreen1 = green1 != null ? green1 : new NUMBER(0);
            NUMBER iblue1 = blue1 != null ? blue1 : new NUMBER(0);
            NUMBER ired2 = red2 != null ? red2 : new NUMBER(0);
            NUMBER igreen2 = green2 != null ? green2 : new NUMBER(0);
            NUMBER iblue2 = blue2 != null ? blue2 : new NUMBER(0);
            NUMBER ired3 = red3 != null ? red3 : new NUMBER(0);
            NUMBER igreen3 = green3 != null ? green3 : new NUMBER(0);
            NUMBER iblue3 = blue3 != null ? blue3 : new NUMBER(0);
            NUMBER ired4 = red4 != null ? red4 : new NUMBER(0);
            NUMBER igreen4 = green4 != null ? green4 : new NUMBER(0);
            NUMBER iblue4 = blue4 != null ? blue4 : new NUMBER(0);
            NUMBER ired5 = red5 != null ? red5 : new NUMBER(0);
            NUMBER igreen5 = green5 != null ? green5 : new NUMBER(0);
            NUMBER iblue5 = blue5 != null ? blue5 : new NUMBER(0);
            NUMBER ired6 = red6 != null ? red6 : new NUMBER(0);
            NUMBER igreen6 = green6 != null ? green6 : new NUMBER(0);
            NUMBER iblue6 = blue6 != null ? blue6 : new NUMBER(0);
            NUMBER ired7 = red7 != null ? red7 : new NUMBER(0);
            NUMBER igreen7 = green7 != null ? green7 : new NUMBER(0);
            NUMBER iblue7 = blue7 != null ? blue7 : new NUMBER(0);
            NUMBER ired8 = red8 != null ? red8 : new NUMBER(0);
            NUMBER igreen8 = green8 != null ? green8 : new NUMBER(0);
            NUMBER iblue8 = blue8 != null ? blue8 : new NUMBER(0);
            NUMBER ired9 = red9 != null ? red9 : new NUMBER(0);
            NUMBER igreen9 = green9 != null ? green9 : new NUMBER(0);
            NUMBER iblue9 = blue9 != null ? blue9 : new NUMBER(0);
            NUMBER ired10 = red10 != null ? red10 : new NUMBER(0);
            NUMBER igreen10 = green10 != null ? green10 : new NUMBER(0);
            NUMBER iblue10 = blue10 != null ? blue10 : new NUMBER(0);
            NUMBER iTopLeftXn = topLeftXn != null ? topLeftXn : new NUMBER(0.0f);
            NUMBER iTopLeftYn = topLeftYn != null ? topLeftYn : new NUMBER(0.0f);
            String iFont = font != null ? font.getString() : "";
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER ired = red != null ? red : new NUMBER(0);
            NUMBER igreen = green != null ? green : new NUMBER(0);
            NUMBER iblue = blue != null ? blue : new NUMBER(0);
            NUMBER istartNumber = startNumber != null ? startNumber : new NUMBER(0);
            NUMBER ibeginNumber = beginNumber != null ? beginNumber : new NUMBER(0);
            String inbAlias = nbAlias != null ? nbAlias.getString() : "";
            String icpAlias = cpAlias != null ? cpAlias.getString() : "";
            String iformat = format != null ? format.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            PDFMergerX.merge(inumPDF.intValue(), inputStream1, inputStream2, inputStream3, inputStream4, inputStream5, inputStream6, inputStream7, inputStream8, inputStream9, inputStream10, iPassword1, iPassword2, iPassword3, iPassword4, iPassword5, iPassword6, iPassword7, iPassword8, iPassword9, iPassword10, iTopLeftX1.floatValue(), iTopLeftY1.floatValue(), iwidth1.floatValue(), iheight1.floatValue(), iTopLeftX2.floatValue(), iTopLeftY2.floatValue(), iwidth2.floatValue(), iheight2.floatValue(), iTopLeftX3.floatValue(), iTopLeftY3.floatValue(), iwidth3.floatValue(), iheight3.floatValue(), iTopLeftX4.floatValue(), iTopLeftY4.floatValue(), iwidth4.floatValue(), iheight4.floatValue(), iTopLeftX5.floatValue(), iTopLeftY5.floatValue(), iwidth5.floatValue(), iheight5.floatValue(), iTopLeftX6.floatValue(), iTopLeftY6.floatValue(), iwidth6.floatValue(), iheight6.floatValue(), iTopLeftX7.floatValue(), iTopLeftY7.floatValue(), iwidth7.floatValue(), iheight7.floatValue(), iTopLeftX8.floatValue(), iTopLeftY8.floatValue(), iwidth8.floatValue(), iheight8.floatValue(), iTopLeftX9.floatValue(), iTopLeftY9.floatValue(), iwidth9.floatValue(), iheight9.floatValue(), iTopLeftX10.floatValue(), iTopLeftY10.floatValue(), iwidth10.floatValue(), iheight10.floatValue(), ired1.intValue(), igreen1.intValue(), iblue1.intValue(), ired2.intValue(), igreen2.intValue(), iblue2.intValue(), ired3.intValue(), igreen3.intValue(), iblue3.intValue(), ired4.intValue(), igreen4.intValue(), iblue4.intValue(), ired5.intValue(), igreen5.intValue(), iblue5.intValue(), ired6.intValue(), igreen6.intValue(), iblue6.intValue(), ired7.intValue(), igreen7.intValue(), iblue7.intValue(), ired8.intValue(), igreen8.intValue(), iblue8.intValue(), ired9.intValue(), igreen9.intValue(), iblue9.intValue(), ired10.intValue(), igreen10.intValue(), iblue10.intValue(), iTopLeftXn.floatValue(), iTopLeftYn.floatValue(), iFont, iFontSize.floatValue(), ired.intValue(), igreen.intValue(), iblue.intValue(), istartNumber.intValue(), ibeginNumber.intValue(), inbAlias, icpAlias, iformat, outputStream, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String merge2X(NUMBER tr_id, NUMBER topLeftXn, NUMBER topLeftYn, CHAR font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, NUMBER startNumber, NUMBER beginNumber, CHAR nbAlias, CHAR cpAlias, CHAR format, BLOB outputFile, CHAR certKey) {
        try {
            NUMBER itr_id = tr_id != null ? tr_id : new NUMBER(0);
            NUMBER iTopLeftXn = topLeftXn != null ? topLeftXn : new NUMBER(0.0f);
            NUMBER iTopLeftYn = topLeftYn != null ? topLeftYn : new NUMBER(0.0f);
            String iFont = font != null ? font.getString() : "";
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER ired = red != null ? red : new NUMBER(0);
            NUMBER igreen = green != null ? green : new NUMBER(0);
            NUMBER iblue = blue != null ? blue : new NUMBER(0);
            NUMBER istartNumber = startNumber != null ? startNumber : new NUMBER(0);
            NUMBER ibeginNumber = beginNumber != null ? beginNumber : new NUMBER(0);
            String inbAlias = nbAlias != null ? nbAlias.getString() : "";
            String icpAlias = cpAlias != null ? cpAlias.getString() : "";
            String iformat = format != null ? format.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            PDFMergerX.merge2(itr_id.intValue(), iTopLeftXn.floatValue(), iTopLeftYn.floatValue(), iFont, iFontSize.floatValue(), ired.intValue(), igreen.intValue(), iblue.intValue(), istartNumber.intValue(), ibeginNumber.intValue(), inbAlias, icpAlias, iformat, outputStream, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String merge3X(NUMBER tr_id, NUMBER pageNum, NUMBER x, NUMBER y, NUMBER tocItemHeight, NUMBER tocItemWidth, CHAR tocSeparator, CHAR font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, BLOB outputFile, CHAR certKey) {
        try {
            NUMBER itr_id = tr_id != null ? tr_id : new NUMBER(0);
            NUMBER iPageNum = pageNum != null ? pageNum : new NUMBER(0.0f);
            NUMBER iX = x != null ? x : new NUMBER(0.0f);
            NUMBER iY = y != null ? y : new NUMBER(0.0f);
            NUMBER iTocItemHeight = tocItemHeight != null ? tocItemHeight : new NUMBER(0.0f);
            NUMBER iTocItemWidth = tocItemWidth != null ? tocItemWidth : new NUMBER(0.0f);
            String iTocSeparator = tocSeparator != null ? tocSeparator.getString() : "";
            String iFont = font != null ? font.getString() : "";
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER ired = red != null ? red : new NUMBER(0);
            NUMBER igreen = green != null ? green : new NUMBER(0);
            NUMBER iblue = blue != null ? blue : new NUMBER(0);
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            PDFMergerX.merge3(itr_id.intValue(), iPageNum.intValue(), iX.floatValue(), iY.floatValue(), iTocItemHeight.floatValue(), iTocItemWidth.floatValue(), iTocSeparator, iFont, iFontSize.floatValue(), ired.intValue(), igreen.intValue(), iblue.intValue(), outputStream, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String rubberStamp(BLOB inputFile, BLOB outputFile, CHAR contents, NUMBER width, NUMBER height, NUMBER topLeftX, NUMBER topLeftY, CHAR rubberStampName, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iContents = contents != null ? contents.getString() : "";
            NUMBER iWidth = width != null ? width : new NUMBER(0);
            NUMBER iHeight = height != null ? height : new NUMBER(0);
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0);
            String iRubberStampName = rubberStampName != null ? rubberStampName.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            RubberStamp.rubberStamp(inputStream, outputStream, iContents, iWidth.intValue(), iHeight.intValue(), iTopLeftX.intValue(), iTopLeftY.intValue(), iRubberStampName, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String replaceUrl(BLOB inputFile, BLOB outputFile, CHAR oldURI, CHAR newURI, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iOldURI = oldURI != null ? oldURI.getString() : "";
            String iNewURI = newURI != null ? newURI.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ReplaceURL.replaceUrl(inputStream, outputStream, iOldURI, iNewURI, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String replaceUrlsXML(BLOB inputFile, BLOB outputFile, BLOB xmlInputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream xmlInputStream = null;
            if (xmlInputFile != null) {
                xmlInputStream = xmlInputFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ReplaceUrlsXML.replaceUrlsXml(inputStream, outputStream, xmlInputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String imageStamp(BLOB inputFile, BLOB outputFile, BLOB imageFile, NUMBER topLeftX, NUMBER topLeftY, NUMBER width, NUMBER height, NUMBER opacity, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream imageStream = null;
            if (imageFile != null) {
                imageStream = imageFile.getBinaryStream();
            }
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            NUMBER iWidth = width != null ? width : new NUMBER(0.0f);
            NUMBER iHeight = height != null ? height : new NUMBER(0.0f);
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ImageStamp.imageStamp(inputStream, outputStream, imageStream, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iWidth.floatValue(), iHeight.floatValue(), iOpacity.floatValue(), iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String imageStamp3(BLOB inputFile1, BLOB inputFile2, BLOB inputFile3, BLOB outputFile, BLOB imageFile1, BLOB imageFile2, BLOB imageFile3, NUMBER topLeftX, NUMBER topLeftY, NUMBER width, NUMBER height, NUMBER opacity, CHAR password1, CHAR password2, CHAR password3, CHAR certKey) {
        try {
            InputStream inputStream1 = null;
            if (inputFile1 != null) {
                inputStream1 = inputFile1.getBinaryStream();
            }
            InputStream inputStream2 = null;
            if (inputFile2 != null) {
                inputStream2 = inputFile2.getBinaryStream();
            }
            InputStream inputStream3 = null;
            if (inputFile3 != null) {
                inputStream3 = inputFile3.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream imageStream1 = null;
            if (imageFile1 != null) {
                imageStream1 = imageFile1.getBinaryStream();
            }
            InputStream imageStream2 = null;
            if (imageFile2 != null) {
                imageStream2 = imageFile2.getBinaryStream();
            }
            InputStream imageStream3 = null;
            if (imageFile3 != null) {
                imageStream3 = imageFile3.getBinaryStream();
            }
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            NUMBER iWidth = width != null ? width : new NUMBER(0.0f);
            NUMBER iHeight = height != null ? height : new NUMBER(0.0f);
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            String iPassword1 = password1 != null ? password1.getString() : "";
            String iPassword2 = password2 != null ? password2.getString() : "";
            String iPassword3 = password3 != null ? password3.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ImageStamp.imageStamp3(inputStream1, inputStream2, inputStream3, outputStream, imageStream1, imageStream2, imageStream3, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iWidth.floatValue(), iHeight.floatValue(), iOpacity.floatValue(), iPassword1, iPassword2, iPassword3, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String imageTextStamp(BLOB inputFile, BLOB outputFile, BLOB imageFile, NUMBER imageTopLeftX, NUMBER imageTopLeftY, NUMBER imageWidth, NUMBER imageHeight, NUMBER imageOpacity, CHAR textMessage, NUMBER textTopLeftX, NUMBER textTopLeftY, CHAR textFont, NUMBER textFontSize, NUMBER textRed, NUMBER textGreen, NUMBER textBlue, CHAR textEncoding, NUMBER textRotation, NUMBER textOpacity, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream imageStream = null;
            if (imageFile != null) {
                imageStream = imageFile.getBinaryStream();
            }
            NUMBER iTopLeftX = imageTopLeftX != null ? imageTopLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = imageTopLeftY != null ? imageTopLeftY : new NUMBER(0.0f);
            NUMBER iWidth = imageWidth != null ? imageWidth : new NUMBER(0.0f);
            NUMBER iHeight = imageHeight != null ? imageHeight : new NUMBER(0.0f);
            NUMBER iOpacity = imageOpacity != null ? imageOpacity : new NUMBER(1.0f);
            String xPassword = password != null ? password.getString() : "";
            String xCertKey = certKey != null ? certKey.getString() : "";
            String tMessage = textMessage != null ? textMessage.getString() : "";
            NUMBER tTopLeftX = textTopLeftX != null ? textTopLeftX : new NUMBER(0.0f);
            NUMBER tTopLeftY = textTopLeftY != null ? textTopLeftY : new NUMBER(0.0f);
            String tFont = textFont != null ? textFont.getString() : "";
            NUMBER tFontSize = textFontSize != null ? textFontSize : new NUMBER(0.0f);
            NUMBER tRed = textRed != null ? textRed : new NUMBER(0);
            NUMBER tGreen = textGreen != null ? textGreen : new NUMBER(0);
            NUMBER tBlue = textBlue != null ? textBlue : new NUMBER(0);
            String tEncoding = null;
            if (textEncoding != null) {
                tEncoding = textEncoding.stringValue();
            }
            NUMBER tRotation = textRotation != null ? textRotation : new NUMBER(0);
            NUMBER tOpacity = textOpacity != null ? textOpacity : new NUMBER(1.0f);
            ImageStamp.imageTextStamp(inputStream, outputStream, imageStream, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iWidth.floatValue(), iHeight.floatValue(), iOpacity.floatValue(), tMessage, tTopLeftX.floatValue(), tTopLeftY.floatValue(), "TYPE1", tFont, new ByteArrayInputStream("".getBytes()), tFontSize.floatValue(), tRed.intValue(), tGreen.intValue(), tBlue.intValue(), tEncoding, tRotation.intValue(), tOpacity.floatValue(), xPassword, xCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String imageWaterMark(BLOB inputFile, BLOB outputFile, BLOB imageFile, NUMBER topLeftX, NUMBER topLeftY, NUMBER width, NUMBER height, NUMBER opacity, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            InputStream imageStream = null;
            if (imageFile != null) {
                imageStream = imageFile.getBinaryStream();
            }
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            NUMBER iWidth = width != null ? width : new NUMBER(0.0f);
            NUMBER iHeight = height != null ? height : new NUMBER(0.0f);
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ImageWaterMark.imageWaterMark(inputStream, outputStream, imageStream, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iWidth.floatValue(), iHeight.floatValue(), iOpacity.floatValue(), iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String metadataFromXML(BLOB pdfInputFile, BLOB xmlInputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream pdfInputStream = null;
            if (pdfInputFile != null) {
                pdfInputStream = pdfInputFile.getBinaryStream();
            }
            InputStream xmlInputStream = null;
            if (xmlInputFile != null) {
                xmlInputStream = xmlInputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            MetadataFromXML.metadataFromXml(pdfInputStream, xmlInputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String metadataToXML(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            MetadataToXML.metadataToXml(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String replaceString(BLOB inputFile, BLOB outputFile, CHAR strToFind, CHAR newString, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iStrToFind = strToFind != null ? strToFind.getString() : "";
            String iNewString = newString != null ? newString.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ReplaceString.replaceString(inputStream, outputStream, iStrToFind, iNewString, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String textStamp(BLOB inputFile, BLOB outputFile, CHAR message, NUMBER topLeftX, NUMBER topLeftY, CHAR password, CHAR font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, CHAR encoding, NUMBER startPage, NUMBER endPage, NUMBER rotation, NUMBER opacity, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iMessage = message != null ? message.getString() : "";
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            String iPassword = password != null ? password.getString() : "";
            String iFont = font != null ? font.getString() : "";
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER iRed = red != null ? red : new NUMBER(0);
            NUMBER iGreen = green != null ? green : new NUMBER(0);
            NUMBER iBlue = blue != null ? blue : new NUMBER(0);
            String iEncoding = null;
            if (encoding != null) {
                iEncoding = encoding.stringValue();
            }
            NUMBER iStartPage = startPage != null ? startPage : new NUMBER(1);
            NUMBER iEndPage = endPage != null ? endPage : new NUMBER(0);
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            String iCertKey = certKey != null ? certKey.getString() : "";
            NUMBER iRotation = rotation != null ? rotation : new NUMBER(0);
            TextStamp.textStamp(inputStream, outputStream, iMessage, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iPassword, "TYPE1", iFont, new ByteArrayInputStream("".getBytes()), iFontSize.floatValue(), iRed.intValue(), iGreen.intValue(), iBlue.intValue(), iEncoding, iStartPage.intValue(), iEndPage.intValue(), iRotation.intValue(), iOpacity.floatValue(), iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String textStampTTF(BLOB inputFile, BLOB outputFile, CHAR message, NUMBER topLeftX, NUMBER topLeftY, CHAR password, BLOB font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, CHAR encoding, NUMBER startPage, NUMBER endPage, NUMBER rotation, NUMBER opacity, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iMessage = message != null ? message.getString() : "";
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            String iPassword = password != null ? password.getString() : "";
            InputStream ttfStream = null;
            if (font != null) {
                ttfStream = font.getBinaryStream();
            }
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER iRed = red != null ? red : new NUMBER(0);
            NUMBER iGreen = green != null ? green : new NUMBER(0);
            NUMBER iBlue = blue != null ? blue : new NUMBER(0);
            String iEncoding = null;
            if (encoding != null) {
                iEncoding = encoding.stringValue();
            }
            NUMBER iStartPage = startPage != null ? startPage : new NUMBER(1);
            NUMBER iEndPage = endPage != null ? endPage : new NUMBER(0);
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            String iCertKey = certKey != null ? certKey.getString() : "";
            NUMBER iRotation = rotation != null ? rotation : new NUMBER(0);
            TextStamp.textStamp(inputStream, outputStream, iMessage, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iPassword, "TRUETYPE", null, ttfStream, iFontSize.floatValue(), iRed.intValue(), iGreen.intValue(), iBlue.intValue(), iEncoding, iStartPage.intValue(), iEndPage.intValue(), iRotation.intValue(), iOpacity.floatValue(), iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String textWaterMark(BLOB inputFile, BLOB outputFile, CHAR message, NUMBER topLeftX, NUMBER topLeftY, CHAR password, CHAR font, NUMBER fontSize, NUMBER red, NUMBER green, NUMBER blue, CHAR encoding, NUMBER rotation, NUMBER opacity, CHAR reencrypt, CHAR certKey) {
        try {
            InputStream instream = null;
            if (inputFile != null) {
                instream = inputFile.getBinaryStream();
            }
            OutputStream outstream = null;
            if (outputFile != null) {
                outstream = outputFile.setBinaryStream(1L);
            }
            String iMessage = message != null ? message.getString() : "";
            NUMBER iTopLeftX = topLeftX != null ? topLeftX : new NUMBER(0.0f);
            NUMBER iTopLeftY = topLeftY != null ? topLeftY : new NUMBER(0.0f);
            String iPassword = password != null ? password.getString() : "";
            String iFont = font != null ? font.getString() : "";
            NUMBER iFontSize = fontSize != null ? fontSize : new NUMBER(0.0f);
            NUMBER iRed = red != null ? red : new NUMBER(0);
            NUMBER iGreen = green != null ? green : new NUMBER(0);
            NUMBER iBlue = blue != null ? blue : new NUMBER(0);
            String iEncoding = null;
            if (encoding != null) {
                iEncoding = encoding.stringValue();
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            NUMBER iOpacity = opacity != null ? opacity : new NUMBER(1.0f);
            NUMBER iRotation = rotation != null ? rotation : new NUMBER(0);
            String iReencrypt = reencrypt != null ? reencrypt.getString() : "";
            TextWaterMark.textWaterMark(instream, outstream, iMessage, iTopLeftX.floatValue(), iTopLeftY.floatValue(), iPassword, iFont, iFontSize.floatValue(), iRed.intValue(), iGreen.intValue(), iBlue.intValue(), iEncoding, iRotation.intValue(), iOpacity.floatValue(), iReencrypt, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String printURLs(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            PrintURLs.printURLs(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String extractPages(BLOB inputFile, BLOB outputFile, NUMBER startPage, NUMBER endPage, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            NUMBER iStartPage = startPage != null ? startPage : new NUMBER(1);
            NUMBER iEndPage = endPage != null ? endPage : new NUMBER(1);
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            ExtractPages.extractPages(inputStream, outputStream, iStartPage.intValue(), iEndPage.intValue(), iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String getNumberOfPages(BLOB inputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            int numberOfPages_int = GetNumberOfPages.getnop(inputStream, iPassword, iCertKey);
            return Integer.toString(numberOfPages_int);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
    }

    public static String OpenActionJS(BLOB inputFile, BLOB outputFile, CHAR jsstring, CHAR password, CHAR certKey) {
        try {
            InputStream instream = null;
            if (inputFile != null) {
                instream = inputFile.getBinaryStream();
            }
            OutputStream outstream = null;
            if (outputFile != null) {
                outstream = outputFile.setBinaryStream(1L);
            }
            String iJSstring = jsstring != null ? jsstring.getString() : "";
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            SetOpenActionJS.setJSString(instream, outstream, iJSstring, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String JPGCompress(BLOB inputFile, BLOB outputFile, NUMBER compress, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            NUMBER icompress = compress != null ? compress : new NUMBER(1);
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            SetImageCompress.setCompressionQuality(inputStream, outputStream, icompress.intValue(), iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String DigSign(BLOB inputFile, BLOB outputFile, BLOB keystoreFile, CHAR certAlias, CHAR keystorePassword, CHAR privkeyPassword, CHAR name, CHAR location, CHAR reason, CHAR contactInfo, NUMBER page, NUMBER width, NUMBER height, NUMBER topLeftX, NUMBER topLeftY, NUMBER accessPerms, CHAR password, CHAR certKey) {
        return null;
    }

    public static String DigSignEncrypt(BLOB inputFile, BLOB outputFile, BLOB keystoreFile, CHAR certAlias, CHAR keystorePassword, CHAR privkeyPassword, CHAR name, CHAR location, CHAR reason, CHAR contactInfo, NUMBER page, NUMBER width, NUMBER height, NUMBER topLeftX, NUMBER topLeftY, NUMBER accessPerms, CHAR password, CHAR ownerPassword, CHAR userPassword, NUMBER keyLength, CHAR canAssemble, CHAR canExtractContent, CHAR canExtractForAccessibility, CHAR canFillInForm, CHAR canModify, CHAR canModifyAnnotations, CHAR canPrint, CHAR canPrintDegraded, CHAR algorithm, CHAR certKey) {
        return null;
    }

    public static String rebuild(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            Rebuild.rebuild1(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String getVersion() {
        return Version.getVersion1();
    }

    public static String getVersionDate() {
        return Version.getVersionDate1();
    }

    public static String setFieldsReadonly(BLOB inputFile, BLOB outputFile, CHAR raise_noform, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            boolean iraise_noform = raise_noform.getString().equalsIgnoreCase("true");
            setFieldsReadonly.setReadonly(inputStream, outputStream, iraise_noform, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String getPDFACompliant(BLOB inputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            String comp = GetPDFACompliant.getpdfacomp(inputStream, iPassword, iCertKey);
            return comp;
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
    }

    public static String mergeencrypt(BLOB inputFile1, BLOB inputFile2, CHAR password1, CHAR password2, BLOB outputFile, CHAR ownerPassword, CHAR userPassword, NUMBER keyLength, CHAR canAssemble, CHAR canExtractContent, CHAR canExtractForAccessibility, CHAR canFillInForm, CHAR canModify, CHAR canModifyAnnotations, CHAR canPrint, CHAR canPrintDegraded, CHAR algorithm, CHAR certKey) {
        try {
            InputStream inputStream1 = null;
            if (inputFile1 != null) {
                inputStream1 = inputFile1.getBinaryStream();
            }
            InputStream inputStream2 = null;
            if (inputFile2 != null) {
                inputStream2 = inputFile2.getBinaryStream();
            }
            String iPassword1 = password1 != null ? password1.getString() : "";
            String iPassword2 = password2 != null ? password2.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iOwnerPassword = ownerPassword != null ? ownerPassword.getString() : "";
            String iUserPassword = userPassword != null ? userPassword.getString() : "";
            NUMBER iKeyLength = keyLength != null ? keyLength : new NUMBER(0);
            String iCanAssemble = canAssemble != null ? canAssemble.getString() : "";
            String iCanExtractContent = canExtractContent != null ? canExtractContent.getString() : "";
            String iCanExtractForAccessibility = canExtractForAccessibility != null ? canExtractForAccessibility.getString() : "";
            String iCanFillInForm = canFillInForm != null ? canFillInForm.getString() : "";
            String iCanModify = canModify != null ? canModify.getString() : "";
            String iCanModifyAnnotations = canModifyAnnotations != null ? canModifyAnnotations.getString() : "";
            String iCanPrint = canPrint != null ? canPrint.getString() : "";
            String iCanPrintDegraded = canPrintDegraded != null ? canPrintDegraded.getString() : "";
            String ialgorithm = algorithm != null ? algorithm.getString() : "";
            String iCertKey = certKey != null ? certKey.getString() : "";
            MergeEncrypt.mergeencrypt(inputStream1, inputStream2, iPassword1, iPassword2, outputStream, iOwnerPassword, iUserPassword, iKeyLength.intValue(), iCanAssemble, iCanExtractContent, iCanExtractForAccessibility, iCanFillInForm, iCanModify, iCanModifyAnnotations, iCanPrint, iCanPrintDegraded, ialgorithm, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String verifySignature(BLOB inputFile, BLOB outputFile, CHAR password, CHAR certKey) {
        try {
            InputStream inputStream = null;
            if (inputFile != null) {
                inputStream = inputFile.getBinaryStream();
            }
            String iPassword = password != null ? password.getString() : "";
            OutputStream outputStream = null;
            if (outputFile != null) {
                outputStream = outputFile.setBinaryStream(1L);
            }
            String iCertKey = certKey != null ? certKey.getString() : "";
            VerifySignature.verify1(inputStream, outputStream, iPassword, iCertKey);
        }
        catch (Throwable t) {
            return PlpdfToolkit.getStackTraceString(t);
        }
        return null;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

