create or replace procedure pie_chart_example is
  l_box plpdf3.t_box;
  l_blob blob;
begin
  /* Creating a box for the legend */
  l_box.background_color := plpdf_const.Light_salmon;
  l_box.padding.left := 0;
  l_box.border.top := plpdf3.crBorder1(plpdf_const.Black, 1, plpdf3.c_dashed);
  l_box.border.bottom := plpdf3.crBorder1(plpdf_const.Black, 1, plpdf3.c_dashed);
  l_box.border.left := plpdf3.crBorder1(plpdf_const.Black, 1, plpdf3.c_dotted);
  l_box.border.right := plpdf3.crBorder1(plpdf_const.Black, 1, plpdf3.c_dotted);
  plpdf.Init(p_unit => 'pt');
  plpdf.NewPage();
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style  => null,
    p_size   => 8
    );
  /* Initializing */
  plpdf3_chart.Init(
     p_type => plpdf3_chart.c_pie   -- Initializing the chart variables, and defining the type of the chart(Bar,Pie,Line)
     );              
  plpdf3_chart.setChartTitle(
     p_title => 'Sales',
     p_font => plpdf_const.Times_Roman,
     p_italic => true,
     p_bold => true,
     p_size => 14,
     p_text_color => plpdf_const.Green
     );
  /* Creating a Series for the data */
  plpdf3_chart.addDataSet(
     p_name => 'Series 1'        -- Name of the Series
     ); 
  plpdf3_chart.setDataSetLabel(   -- Data Label position in the pie
     p_position => plpdf3_chart.c_outEnd
     );
    /* Creating categories */
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 1, Stuff',
     p_color => plpdf_const.Black -- Color of the sector.
     );
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 2',
     p_color => plpdf_const.Dark_orange
     );
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 3',
     p_color => plpdf_const.Lavender_blush
     );
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 4',
     p_color => plpdf_const.Medium_sea_green
     );
  plpdf3_chart.AddValue(
     p_value => 8.2,              -- Value of the data
     p_idx => 1                     -- Index in the Series
     );
  plpdf3_chart.AddValue(
    p_value => 3.2,
    p_idx => 2
    );
  plpdf3_chart.AddValue(
    p_value => 1.4,
    p_idx => 3
    );
  plpdf3_chart.AddValue(
    p_value => 1.2,
    p_idx => 4
    );
  /* Legend */                          
  plpdf3_chart.AddLegend(          -- Creating a Legend to the chart
    p_position => plpdf3_chart.c_r,-- Position of the Legend
    p_box => l_box                 -- Properties of the legend
    );
  /* Drawing */
  plpdf3_chart.DrawChart(          -- Sets the dimensions of the chart
    p_x => 25 * plpdf_util.unit2factor('mm'),             -- X Position (Top left corner)
    p_y => 25 * plpdf_util.unit2factor('mm'),             -- Y Position (Top left corner)
    p_width => 160 * plpdf_util.unit2factor('mm'),        -- Width
    p_Height => 90 * plpdf_util.unit2factor('mm'));       -- Height
  plpdf.SendDoc(
    p_blob => l_blob
    );
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'pie_chart.pdf');
  commit;
end;
