create or replace package plx_sc
authid current_user is
--v5.9
--
  /* XML Simple Composer */
  --types
  subtype maxv2 is varchar2(32767 char);
  subtype normalv2 is varchar2(255 char);
  --v2.0.0
  type t_attr is record (
    name normalv2,
    value maxv2
    );
  --type type_attrs is table of maxv2 index by normalv2;
  type type_attrs is table of t_attr;
  type t_attrs is table of t_attr;
  --
  type type_xdoc is record(
    clobvar   clob,
    buffervar maxv2
    );
  type type_pck is table of type_xdoc index by pls_integer;

  -- variables
  v_newline varchar2(2 char) := chr(13) || chr(10);
  v_pck            type_pck;
  v_doc_index      pls_integer := 0;
  v_xml_version    normalv2 := '1.0';
  v_xml_encoding   normalv2 := 'UTF-8';
  v_xml_standalone normalv2 := null;

  -- constants
  c_ns_sep constant varchar2(1 char) := ':';
  c_xmlns  constant normalv2 := 'xmlns';
  --
  --v4.9.0
  c_preserve constant plx_sc.normalv2 := 'preserve';
  -- procedures
  procedure setNewLine(p_nl varchar2);
  --
  procedure setdefXmlVersion(p_version varchar2);
  --
  procedure setdefXmlEncoding(p_encoding varchar2);
  --
  procedure setdefXmlStandalone(p_standalone varchar2);
  --
  function getheadertext(p_version    varchar2,
                         p_encoding   varchar2,
                         p_standalone varchar2) return varchar2;
  --
  procedure addAttribute(p_attrs in out nocopy type_attrs,
                         p_name  varchar2,
                         p_value varchar2);
  --
  procedure addAttributewNS(p_attrs     in out nocopy type_attrs,
                            p_namespace varchar2,
                            p_name      varchar2,
                            p_value     varchar2);
  --
  procedure addNameSpace(p_attrs in out nocopy type_attrs,
                         p_name  varchar2 default null,
                         p_value varchar2);
  /**************************************************************/
  -- CLOB as XML container
  procedure addtext(p_doc in out nocopy clob, p_text varchar2);
  --
  procedure addline(p_doc in out nocopy clob, p_text varchar2);
  --
  procedure startDocument(p_doc in out nocopy clob);
  --
  procedure startDocumentwHeader(p_doc        in out nocopy clob,
                                 p_version    varchar2 default null,
                                 p_encoding   varchar2 default null,
                                 p_standalone varchar2 default null);
  --
  procedure endDocument(p_doc in out nocopy clob);
  --
  procedure startElement(p_doc   in out nocopy clob,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy clob,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_doc   in out nocopy clob,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy clob,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --startElement
  procedure endElement(p_doc in out nocopy clob, p_tag varchar2);
  --
  procedure endElementwNS(p_doc       in out nocopy clob,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_doc in out nocopy clob, p_chars varchar2);
  --
  function getXML(p_doc in out nocopy clob) return sys.xmltype;
  --
  procedure getXMLBLOB(p_doc     in out nocopy clob,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_doc     in out nocopy clob,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  --
  /**************************************************************/
  -- XDOC as XML container
  procedure addtext(p_doc in out nocopy type_xdoc, p_text varchar2);
  --
  --v3.6.0
  procedure addXdoc(p_doc in out nocopy type_xdoc, p_text in out nocopy type_xdoc);
  --
  procedure addline(p_doc in out nocopy type_xdoc, p_text varchar2);
  --
  procedure startDocument(p_doc in out nocopy type_xdoc);
  --
  procedure startDocumentwHeader(p_doc        in out nocopy type_xdoc,
                                 p_version    varchar2 default null,
                                 p_encoding   varchar2 default null,
                                 p_standalone varchar2 default null);
  --
  procedure endDocument(p_doc in out nocopy type_xdoc);
  --
  procedure startElement(p_doc   in out nocopy type_xdoc,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy type_xdoc,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_doc   in out nocopy type_xdoc,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy type_xdoc,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --
  procedure endElement(p_doc in out nocopy type_xdoc, p_tag varchar2);
  --
  procedure endElementwNS(p_doc       in out nocopy type_xdoc,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_doc in out nocopy type_xdoc, p_chars varchar2);
  --
  function getXML(p_doc in out nocopy type_xdoc) return sys.xmltype;
  --
  procedure getXMLBLOB(p_doc     in out nocopy type_xdoc,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_doc     in out nocopy type_xdoc,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  --
  /**************************************************************/
  -- PCK package as XML container
  procedure InitPackage;
  --
  procedure addtext(p_id pls_integer, p_text varchar2);
  --
  procedure addline(p_id pls_integer, p_text varchar2);
  --
  function startDocument return pls_integer;
  --
  function startDocumentwHeader(p_version    varchar2 default null,
                                p_encoding   varchar2 default null,
                                p_standalone varchar2 default null)
    return pls_integer;
  --
  procedure endDocument(p_id pls_integer);
  --
  procedure startElement(p_id    pls_integer,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_id        pls_integer,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_id    pls_integer,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_id        pls_integer,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --
  procedure endElement(p_id pls_integer, p_tag varchar2);
  --
  procedure endElementwNS(p_id        pls_integer,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_id pls_integer, p_chars varchar2);
  --
  function getXML(p_id pls_integer) return sys.xmltype;
  --
  procedure getXMLBLOB(p_id      pls_integer,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_id      pls_integer,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  /**************************************************************/
  -- utils
  function str2cp(p_str varchar2) return varchar2;
  --
  function replacetags(p_str varchar2) return varchar2;
  --
  function xmlascii(p_str varchar2) return varchar2;
  --
  function num2char(p_number number,
                    p_digits number default null,
                    p_round  boolean default false) return varchar2;
  -- xsd:dateTime: [-]CCYY-MM-DDThh:mm:ss[Z|(+|-)hh:mm]
  function date2dateTime2char(p_date date) return varchar2;
  -- xsd:long
  function num2long2char(p_number number) return varchar2;
  --
end plx_sc;
/

