create or replace package plpdf_w3_util
authid current_user is
--v5.9
--
subtype t_style_attr is plpdf_type.v2avg;

c_background_color constant t_style_attr := 'background-color';
c_border_bottom_color constant t_style_attr := 'border-bottom-color';
c_border_bottom_style constant t_style_attr := 'border-bottom-style';
c_border_bottom_width constant t_style_attr := 'border-bottom-width';
c_border_left_color constant t_style_attr := 'border-left-color';
c_border_left_style constant t_style_attr := 'border-left-style';
c_border_left_width constant t_style_attr := 'border-left-width';
c_border_right_color constant t_style_attr := 'border-right-color';
c_border_right_style constant t_style_attr := 'border-right-style';
c_border_right_width constant t_style_attr := 'border-right-width';
c_border_top_color constant t_style_attr := 'border-top-color';
c_border_top_style constant t_style_attr := 'border-top-style';
c_border_top_width constant t_style_attr := 'border-top-width';
--
c_border_color constant t_style_attr := 'border-color';
c_border_style constant t_style_attr := 'border-style';
c_border_width constant t_style_attr := 'border-width';
--
c_color constant t_style_attr := 'color'; --v4.8.2
c_direction constant t_style_attr := 'direction';
c_font_family constant t_style_attr := 'font-family';
c_font_size constant t_style_attr :='font-size';
c_font_style constant t_style_attr :='font-style';
c_font_weight constant t_style_attr := 'font-weight';
c_letter_spacing constant t_style_attr := 'letter-spacing';
c_line_height constant t_style_attr := 'line-height';
c_margin_bottom  constant t_style_attr := 'margin-bottom';
c_margin_left constant t_style_attr := 'margin-left';
c_margin_right constant t_style_attr := 'margin-right';
c_margin_top constant t_style_attr := 'margin-top';
c_padding_bottom constant t_style_attr := 'padding-bottom';
c_padding_left constant t_style_attr := 'padding-left';
c_padding_right constant t_style_attr := 'padding-right';
c_padding_top constant t_style_attr := 'padding-top';
c_text_align constant t_style_attr := 'text-align';
c_text_decoration constant t_style_attr := 'text-decoration';
c_text_indent constant t_style_attr := 'text-ident';
c_text_transform constant t_style_attr := 'text-transform';
c_text_shadow constant t_style_attr := 'text-shadow';
c_vertical_align constant t_style_attr :='vertical-align';
c_white_space constant t_style_attr := 'white-space';
c_word_spacing constant t_style_attr := 'word-spacing';
c_unicode_bidi constant t_style_attr := 'unicode-bidi';
c_height constant t_style_attr := 'height';
c_max_height constant t_style_attr := 'max-height';
c_max_width constant t_style_attr := 'max-width';
c_min_height constant t_style_attr := 'min-height';
c_min_width constant t_style_attr := 'min-width';
c_width constant t_style_attr := 'width';
c_list_style_type constant t_style_attr := 'list-style-type';
--
type t_style_element is record(name plpdf_type.v2avg, value plpdf_type.v2avg);
type t_style_elements is table of t_style_element index by pls_integer;
----
type t_w3_props is record (
  --FONT CSS props http://www.w3schools.com/css/css_font.asp
  --background-color http://www.w3schools.com/css/css_background.asp
  -- background  Sets all the background properties in one declaration
  -- background-attachment  Sets whether a background image is fixed or scrolls with the rest of the page
  background_color plpdf_type.v2avg, --  Sets the background color of an element
  -- background-image  Sets the background image for an element
  -- background-position  Sets the starting position of a background image
  -- background-repeat  Sets how a background image will be repeated
  --border http://www.w3schools.com/css/css_border.asp
  -- border  Sets all the border properties in one declaration
  -- border-bottom  Sets all the bottom border properties in one declaration
  border_bottom_color plpdf_type.v2avg, --Sets the color of the bottom border
  border_bottom_style plpdf_type.v2avg, --  Sets the style of the bottom border
  border_bottom_width plpdf_type.v2avg, --  Sets the width of the bottom border
  -- border-color  Sets the color of the four borders
  -- border-left  Sets all the left border properties in one declaration
  border_left_color plpdf_type.v2avg, --Sets the color of the left border
  border_left_style plpdf_type.v2avg, --  Sets the style of the left border
  border_left_width plpdf_type.v2avg, --  Sets the width of the left border
  -- border-right  Sets all the right border properties in one declaration
  border_right_color plpdf_type.v2avg, --Sets the color of the right border
  border_right_style plpdf_type.v2avg, --  Sets the style of the right border
  border_right_width plpdf_type.v2avg, --  Sets the width of the right border
  -- border-style  Sets the style of the four borders
  -- border-top  Sets all the top border properties in one declaration
  border_top_color plpdf_type.v2avg, --Sets the color of the top border
  border_top_style plpdf_type.v2avg, --  Sets the style of the top border
  border_top_width plpdf_type.v2avg, --  Sets the width of the top border
  -- border-width  Sets the width of the four borders
  color  plpdf_type.v2avg, --Sets the color of text
  -- direction  Specifies the text direction/writing direction
  -- font Sets all the font properties in one declaration
  font_family plpdf_type.v2avg, -- Specifies the font family for text
  font_size plpdf_type.v2avg, --  Specifies the font size of text: number or text!!!
  font_style plpdf_type.v2avg, --  Specifies the font style for text
  -- font-variant  Specifies whether or not a text should be displayed in a small-caps font
  font_weight plpdf_type.v2avg, --  Specifies the weight of a font
  --TEXT CSS props http://www.w3schools.com/css/css_text.asp
  -- letter-spacing  Increases or decreases the space between characters in a text
  line_height plpdf_type.v2avg, --  Sets the line height
  --CSS BOX MODEL http://www.w3schools.com/css/css_boxmodel.asp
  --margin http://www.w3schools.com/css/css_margin.asp
  -- margin  A shorthand property for setting the margin properties in one declaration
  margin_bottom  plpdf_type.v2avg, -- Sets the bottom margin of an element
  margin_left  plpdf_type.v2avg, -- Sets the left margin of an element
  margin_right plpdf_type.v2avg, --  Sets the right margin of an element
  margin_top plpdf_type.v2avg, --  Sets the top margin of an element
  --padding http://www.w3schools.com/css/css_padding.asp
  -- padding  A shorthand property for setting all the padding properties in one declaration
  padding_bottom plpdf_type.v2avg, --  Sets the bottom padding of an element
  padding_left plpdf_type.v2avg, --  Sets the left padding of an element
  padding_right plpdf_type.v2avg, --  Sets the right padding of an element
  padding_top plpdf_type.v2avg, --  Sets the top padding of an element
  --text
  text_align plpdf_type.v2avg, -- Specifies the horizontal alignment of text
  text_decoration plpdf_type.v2avg, -- Specifies the decoration added to text
  text_indent plpdf_type.v2avg, -- Specifies the indentation of the first line in a text-block
  -- text-shadow  Specifies the shadow effect added to text
  text_transform plpdf_type.v2avg, -- Controls the capitalization of text
  vertical_align plpdf_type.v2avg, -- Sets the vertical alignment of an element
  white_space plpdf_type.v2avg, --  Specifies how white-space inside an element is handled
  -- word-spacing  Increases or decreases the space between words in a text
  -- unicode-bidi  Used together with the direction property to set or return whether the text should be overridden to support multiple languages in the same document
  --DIMENSIONS http://www.w3schools.com/css/css_dimension.asp
  height plpdf_type.v2avg, --	Sets the height of an element
  max_height plpdf_type.v2avg, --	Sets the maximum height of an element
  max_width plpdf_type.v2avg, --	Sets the maximum width of an element
  min_height plpdf_type.v2avg, --	Sets the minimum height of an element
  min_width plpdf_type.v2avg, --	Sets the minimum width of an element
  width plpdf_type.v2avg, --	Sets the width of an element
  -- LIST http://www.w3schools.com/css/css_list.asp
  -- list-style	Sets all the properties for a list in one declaration
  -- list-style-image	Specifies an image as the list-item marker
  -- list-style-position	Specifies if the list-item markers should appear inside or outside the content flow
  list_style_type plpdf_type.v2avg, --Specifies the type of list-item marker
  start_ plpdf_type.v2avg, --OL list start
  --extras
  href plpdf_type.v2avg,
  id plpdf_type.v2avg,
  class plpdf_type.v2avg
  );
----
type t_styles is table of t_w3_props index by plpdf_type.v2avg; --index by tag
--
function to_num(
  p_str varchar2
  ) return number;
--
function multiUnit(
  p_str plpdf_type.v2long,
  p_multi number
  ) return varchar2;
--
function toSize(
  p_str plpdf_type.v2long,
  p_output_tpdf boolean
  ) return number;
--
function splitStyle(
  p_attr_str in out plpdf_type.v2avg
  ) return t_style_elements;
--
function getNamedColor(
  p_val varchar2
  ) return plpdf_type.t_color;
--
function getColorPdf(
  p_val varchar2
  ) return plpdf_type.t_color;
--v4.8.0
function getColorDocx(
  p_val varchar2
  ) return ploffx_document_type.ST_HexColor;
--
procedure addW3Props(
  p_props in out t_w3_props,
  p_props2 t_w3_props,
  p_all boolean default true
  );
--
function getCSSProps(
  p_val in out varchar2
  ) return t_w3_props;
--
function getRprPdf(
  p_props t_w3_props
  ) return plpdf3.t_RunProps;
--v4.8.0
function getRprDocx(
  p_props t_w3_props
  ) return ploffx_document_type.CT_rPr;
--
function getLocalProps(
  p_node dbms_xmldom.DOMNode
  ) return t_w3_props;
--
function getStylePdf(
  p_style varchar2
  ) return varchar2;
--v4.8.0
function getStyleDocx(
  p_style varchar2
  ) return varchar2;
--
function getPdfBox(
  p_props t_w3_props
  ) return plpdf3.t_box;
--v4.8.0
function getDocxParagraphBorder(
  p_props t_w3_props
  ) return ploffx_document_type.CT_PBdr;
--v4.8.0
function getDocxTableCellBorder(
  p_props t_w3_props
  ) return ploffx_document_type.CT_TcBorders;
--
function isPrevP(
  p_tag varchar2
  ) return boolean;
--
function TypetoListStyleType(
  p_type varchar2
  ) return varchar2;
--
function ListStyleType2NumFormat(
  p_liststyletype varchar2
  ) return varchar2;
--
function ListStyleType2LvlText(
  p_liststyletype varchar2
  ) return varchar2;
--
function ListStyleType2Font(
  p_liststyletype varchar2
  ) return varchar2;
--
end plpdf_w3_util;
/

