create or replace package plpdf_util
authid current_user is
--v5.9
--
function to_str(
  p_num number,
  p_length number
  ) return varchar2;
--v3.2.0
function is_numeric(
  p_string varchar2
  ) return boolean;
--
procedure exec_proc(
  p_proc_name varchar2
  );
--
procedure exec_proc5(
  p_proc_name varchar2,
  p_1 varchar2 default null,
  p_2 varchar2 default null,
  p_3 varchar2 default null,
  p_4 varchar2 default null,
  p_5 varchar2 default null
  );
--
function to_dec(
  p_str in varchar2,
  p_from_base in number/* default 16*/
  ) return number;
--
function to_dec(
  p_str in varchar2
  ) return number;
--
function to_hex(
  p_dec in number
  ) return varchar2;
--
function shiftraw(
  p_raw raw,
  p_shift number,
  p_orient varchar2
  ) return raw;
--
function minusraw(
  p_1 raw,
  p_2 raw
  ) return raw;
--
function raw_bitand(
  p_1 raw,
  p_2 raw
  ) return raw;
--
function raw_bitor(
  p_1 raw,
  p_2 raw
  ) return raw;
--
function raw_bitxor(
  p_1 raw,
  p_2 raw
  ) return raw;
--
function bitor(
  p_dec1 number,
  p_dec2 number
  ) return number;
--
function bitxor(
  p_dec1 number,
  p_dec2 number
  ) return number;
--
function substr_count(
  p_txt varchar2,
  p_char varchar2
  ) return number;
--
function set_pageformat(
  p_w number,
  p_h number
  ) return plpdf_type.t_pageformat;
--
function color_is_notnull(
  p_color plpdf_type.t_color
  ) return boolean;
--v4.3.0
function color_is_notnull_1(
  p_color plpdf_type.t_color
  ) return boolean;
--
function color_is_null(
  p_color plpdf_type.t_color
  ) return boolean;
--
function RemoveCRLF(
  p_text varchar2
  ) return varchar2;
--
function explode(
  p_text varchar2,
  p_sep varchar2 default ' '
  ) return plpdf_type.t_text_array;
--
function to_bin(
  p_dec in number
  ) return varchar2;
--
function boolean2switch(
  p_boolean boolean
  ) return varchar2;
--
function shiftleft(
  p_number number,
  p_pos number
  ) return number;
--
function shiftright(
  p_number number,
  p_pos number
  ) return number;
--v3.0.0
function xbitand(
 p_left pls_integer,
 p_right pls_integer
 ) return pls_integer;
--
function xbitor(
  p_left number,
  p_right number
  ) return number;
--
function reverse(
  p_string_in varchar2
  ) return varchar2;
--
function xshiftright(
  p_int pls_integer,
  p_shift pls_integer
  ) return pls_integer;
--
function xcomp2_2byte(
  p_int pls_integer
  ) return pls_integer;
--
function xshiftleft(
  p_int pls_integer,
  p_shift pls_integer
  ) return pls_integer;
--
function xcomp2_1byte(
  p_int pls_integer
  ) return pls_integer;
--
function colors_equal(
  p_color1 plpdf_type.t_color,
  p_color2 plpdf_type.t_color
  ) return boolean;
--
function color_nvl(
  p_color plpdf_type.t_color,
  p_nvl_color plpdf_type.t_color default null
  ) return plpdf_type.t_color;
--
function GetStrokingColorString(
  p_color plpdf_type.t_color
  ) return varchar2;
--
function GetNonStrokingColorString(
  p_color plpdf_type.t_color
  ) return varchar2;
--
function GetLinewidthString(
  p_linewidth number
  ) return varchar2;
--
function GetEllipseString(
  p_x number,
  p_y number,
  p_rx number,
  p_ry number,
  p_style varchar2 default 'D',
  p_h number,
  p_linewidth number,
  p_border_color plpdf_type.t_color default null,
  p_fill_color plpdf_type.t_color default null
  ) return varchar2;
--
function GetLineString(
  p_x1 number,
  p_y1 number,
  p_x2 number,
  p_y2 number,
  p_h number,
  p_linewidth number,
  p_color plpdf_type.t_color
  ) return varchar2;
--
function GetRect(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_box_h number
  ) return varchar2;
--
function GetRectString(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_style varchar2 default null,
  p_box_h number,
  p_linewidth number,
  p_border_color plpdf_type.t_color default null,
  p_fill_color plpdf_type.t_color default null
  ) return varchar2;
--
function GetRGBArrayString(
  p_color plpdf_type.t_color
  ) return varchar2;
--
function GetRectArrayString(
  p_1 number,
  p_2 number,
  p_3 number,
  p_4 number
  ) return varchar2;
--
function CurrFontIsJ( -- Japanese
  p_fontname varchar2
  ) return boolean;
--
function CurrFontIsCK( -- Chinese, Korean
  p_fontname varchar2
  ) return boolean;
--
function GetQuadding(
  p_justification varchar2
  ) return pls_integer;
--
function GetSubmitformFlags(
  p_IncludeNoValueFields boolean default false,
  p_ExportFormat boolean default false,
  p_GetMethod boolean default false,
  p_SubmitCoordinates boolean default false
  ) return number;
--
/* Escape sequences change to corresponding ASCII/UNICODE chars */
function escape_resolver(
  p_txt varchar2
  ) return varchar2;
--
function page2type(
  p_pageformat varchar2
  ) return plpdf_type.t_pageformat;
--
function unit2factor(
  p_unit varchar2
  ) return number;
--
function rawescape(
  p_raw raw
  ) return raw;
--
function md5raw(
  p_string raw
  ) return raw;
--
function objectkey(
  p_encryption_key raw,
  p_n number
  ) return raw;
--
function RC4crypto(
  p_key raw,
  p_text blob )
  return blob;
--
function getCW(
  p_cw in out nocopy plpdf_type.t_cw,
  p_num number
  ) return number;
--
function CharIsSep(
  p_c varchar2,
  p_fonttype varchar2,
  p_fontname varchar2
  ) return boolean;
--
function GetCharLength(
  p_c varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fonttype varchar2,
  p_fontname varchar2
  ) return number;
--
function JSline(
  p_js varchar2
  ) return varchar2;
--
function scale(
  p_num number
  ) return number;
--v4.7.0
function backscale(
  p_num number
  ) return number;
--
function scale2(
  p_num number
  ) return varchar2;
--
function scale3(
  p_num number
  ) return varchar2;
--
function scale4(
  p_num number
  ) return varchar2;
--
function getDrawOpt(
  p_style varchar2
  ) return varchar2;
--
function getDrawOpt(
  p_draw boolean,
  p_fill boolean
  ) return varchar2;
--
function getFontKey(
  p_family varchar2,
  p_style varchar2
  ) return plpdf_type.t_fk;
--
function createSubsetPrefix
  return varchar2;
--
function Acroform_getMatrix(
  p_rotate number,
  p_width number,
  p_height number
  ) return varchar2;
--
function crref(
  p_obj plpdf_type.t_objnum,
  p_gen plpdf_type.t_objgen default 0
  ) return varchar2;
--
function pageformat_is_not_null(
  p_pageformat plpdf_type.t_pageformat
  ) return boolean;
--
function crobj(
  p_obj plpdf_type.t_objnum,
  p_gen plpdf_type.t_objgen default 0
  ) return varchar2;
--
function code2glyph(
  p_code2glyph plpdf_type.t_integers,
  p_code pls_integer
  ) return pls_integer;
--
function cr_glyphsUsed(
  p_orig plpdf_type.t_integers
  ) return plpdf_type.t_integers;
--
function date2char(
  p_date date
  ) return varchar2;
--
--
--BLOB reader
procedure b_init(
  p_pblob in out nocopy plpdf_type.t_pblob,
  p_data in out nocopy blob
  );
--
function b_read1(
  p_pblob in out nocopy plpdf_type.t_pblob
  ) return raw;
--
function b_read(
  p_pblob in out nocopy plpdf_type.t_pblob,
  p_amount pls_integer
  ) return raw;
--
procedure b_skip(
  p_pblob in out nocopy plpdf_type.t_pblob,
  p_num pls_integer
  );
--
procedure b_free(
  p_pblob in out nocopy plpdf_type.t_pblob
  );
--
function b_getShort(
  p_pblob in out nocopy plpdf_type.t_pblob
  ) return pls_integer;
--
--
function b_getInt(
  p_pblob in out nocopy plpdf_type.t_pblob
  ) return pls_integer;
--
procedure lob_arraycopy(
                    p_src     in out nocopy blob,
                    p_srcPos  pls_integer,
                    p_dest    in out nocopy blob,
                    p_destPos pls_integer,
                    p_length  pls_integer);
--
procedure lob_copy(p_dest_lob in out nocopy blob,
                    p_src_lob  in out nocopy blob);
--
function lob_read1(
  p_src     in out nocopy blob,
  p_offset pls_integer
  ) return raw;
--
procedure lob_fill(
  p_b in out nocopy blob,
  p_len pls_integer
  );
--
--v3.0.1
function crColor(
  p_r pls_integer,
  p_g pls_integer,
  p_b pls_integer
  ) return plpdf_type.t_color;
--
--v3.0.1
function crFormat(
  p_w number,
  p_h number
  ) return plpdf_type.t_pageformat;
--
--3.0.2
function getHex32Id
  return varchar2;
--
--v4.3.0
function num2bool(
  p_num number
  ) return boolean;
--v4.4.0
function color_nvl_2(
  p_color_1 plpdf_type.t_color,
  p_color_2 plpdf_type.t_color
  ) return plpdf_type.t_color;
--
--v4.7.0
function num2upperalphabetic(
  p_num number
  ) return varchar2;
--v4.7.0
function num2ordinal(
  p_num number
  ) return varchar2;
--v4.7.0
function spell_number(
  p_num in number
  ) return varchar2;
--v4.7.0
function spell_number_ordinal(
  p_num in number
  ) return varchar2;
--v4.9.3
function get_image_size_factor(
  p_org_template_width number,
  p_org_template_height number,
  p_img_width number,
  p_img_height number
  ) return number;
--v4.9.5
function base64decode(
  p_clob clob
  ) return blob;
--v5.0
function adler32(p_src in blob)
  return varchar2;
--
end plpdf_util;
/

