create or replace package plpdf_type
authid current_user is
--v5.9
--
subtype v2max is varchar2(32767 char);
subtype v2long is varchar2(4000 char);
subtype v2avg is varchar2(255 char);
subtype v2one is varchar2(1 char);
--
subtype rawmax is raw(32767);
--
--plsql tables
type t_v2avgs is table of v2avg index by pls_integer;
type t_v2longs is table of v2long index by pls_integer;
type t_v2maxs is table of v2max index by pls_integer;
type t_numbers is table of number index by pls_integer;
type t_blobs is table of blob index by pls_integer;
type t_booleans is table of boolean index by pls_integer;
type t_integers is table of pls_integer index by pls_integer;
--
type t_raw1s is table of raw(1) index by pls_integer;
type t_rawmaxs is table of rawmax index by pls_integer;
---------------------------------------------------------------------------------------------------
subtype t_objnum is pls_integer;
subtype t_objgen is pls_integer;
---------------------------------------------------------------------------------------------------
--v3.0.1
type t_color is record (
  r pls_integer,
  g pls_integer,
  b pls_integer
  );
---------------------------------------------------------------------------------------------------
--row
type t_row_widths is table of number index by pls_integer;
type t_row_aligns is table of varchar2(10 char) index by pls_integer;
type t_row_datas is table of v2long index by pls_integer;
type t_row_maxlines is table of number index by pls_integer;
type t_row_borders is table of varchar2(10 char) index by pls_integer;
type t_row_styles is table of varchar2(10 char) index by pls_integer;
type t_row_links is table of v2avg index by pls_integer;
type t_row_filles is table of t_color index by pls_integer;
--
subtype t_font_style is varchar2(3 char);
--
type t_font is record (
  family v2avg,
  style t_font_style,
  fsize number
  );
--
type t_row_fonts is table of t_font index by pls_integer;
---------------------------------------------------------------------------------------------------
type t_cw is table of number index by pls_integer;
--
type t_fontbbox is record (
  v1 number,
  v2 number,
  v3 number,
  v4 number
  );
--
type t_fd is record (
  ascent number,
  descent number,
  capheight number,
  flags number,
  fontbbox t_fontbbox,
  italicangle number,
  stemv number,
  missingwidth number
  );
--
type t_diff is record (
  val v2long,
  objnum t_objnum
  );
--
type t_diffs is table of t_diff index by pls_integer;
--
type t_addfont is record (
  name v2avg,
  type v2avg,
  desc1 t_fd,
  up v2avg,
  ut v2avg,
  cw t_cw,
  enc v2avg,
  file v2avg,
  diff v2long, --t_diff
  file_data blob,
  originalsize number,
  ctg v2avg,
  ctg_data blob,
  tounicode_data blob,
  code2glyph t_integers --v3.0.0
  );
---------------------------------------------------------------------------------------------------
type t_charwidths is table of t_cw index by v2avg;
---------------------------------------------------------------------------------------------------
type t_imageprops is record (
  contentformat v2avg,
  mimetype v2avg,
  width number,
  height number
  );
---------------------------------------------------------------------------------------------------
type t_point is record (
  x number,
  y number
  );
--
type t_points is table of t_point index by pls_integer;
---------------------------------------------------------------------------------------------------
--v3.6.0
type t_path_operator is record (
  operator varchar2(2 char),
  x1 number,
  y1 number,
  x2 number,
  y2 number,
  x3 number,
  y3 number
  );
--
type t_path_operators is table of t_path_operator index by pls_integer;
---------------------------------------------------------------------------------------------------
type t_pageformat is record (
  w number,
  h number
  );
---------------------------------------------------------------------------------------------------
-- parsed image
type t_pdfimagemask is record (
  type             v2avg,
  subtype          v2avg,
  width            pls_integer,
  height           pls_integer,
  length           pls_integer,
  bitspercomponent pls_integer,
  filter           v2avg,
  colorspace       v2max,
  stream_data      blob
  );

type t_png_colorspace2 is record (
  cs v2avg,
  amt pls_integer,
  palette blob
  );

type t_pdfimage is record(
  name             v2avg,
  type             v2avg,
  subtype          v2avg,
  width            pls_integer,
  height           pls_integer,
  mask             v2avg,
  length           pls_integer,
  bitspercomponent pls_integer,
  filter           v2avg,
  decodeparms      v2avg,
  colorspace       v2max,
  png_colorspace2  t_png_colorspace2,
  decode           v2avg,
  stream_data      blob,
  dpiX             pls_integer,
  dpiY             pls_integer,
  intent           v2avg,
  profile          blob,
  imagemask        t_pdfimagemask
  );
--
type t_image_info is record (
  i pls_integer,
  objnum plpdf_type.t_objnum, --n
  smask_objnum plpdf_type.t_objnum, --smask
  img t_pdfimage
  );
---------------------------------------------------------------------------------------------------
type t_toc_item is record (
  text v2avg, -- label text
  level_num number, -- level
  y_pos number, -- Y position in the page
  link_id number, -- link id
  pagenum number, -- internal page number
  calc_pagenum number -- calculated page number
  );
--
type t_toc_items is table of t_toc_item index by pls_integer;
---------------------------------------------------------------------------------------------------
-- Template
type t_text_array is table of v2max index by pls_integer; --v3.1.0
--
type t_obj_ref is record (
  obj t_objnum,
  gen t_objgen
  );
--
type t_d_obj_refs is table of t_obj_ref index by pls_integer;
--
type t_obj_val is record (
  id pls_integer, 
  parent_id pls_integer,
  val_type varchar2(10 char), -- HEX, BOOLEAN, NUMBER, DICT, TEXT, OBJREF, NAME
  val_store v2one, -- C: char, R: raw, B: blob
  val_char  v2max,
  val_raw raw(32000),
  val_blob blob
  );
--
type t_obj_vals is table of t_obj_val index by pls_integer;
--
type t_obj_vals_g is table of t_obj_vals index by pls_integer;
--
type t_obj_vals_i is table of t_obj_vals_g index by pls_integer;
--
type tr_tpl_data is record (
    stream_filter v2avg,
    stream_blob blob,
    box_char v2avg,
    res number,
    stream_length number,
    x number,
    y number,
    w number,
    h number ,
    res_obj_obj number,
    res_obj_gen number,
    res_obj_id number,
    d_obj_refs t_d_obj_refs,
    obj_vals t_obj_vals_i
    );
---------------------------------------------------------------------------------------------------
--
type t_opt_array is table of v2avg index by pls_integer;

--v4.9.6
type t_opt2 is record (
  value v2avg,
  label v2avg
  );
type t_opt_array2 is table of t_opt2 index by pls_integer;

--
type t_radiobutton is record (
  value v2avg,
  label v2avg,
  x number,
  y number
  );
--
type t_radiobutton_array is table of t_radiobutton index by pls_integer;
--
type t_opt_val is record ( -- a value in a value set (radiobutton, choice)
  value v2long, -- original value
  value_conv v2long -- converted value if original is hexadecimal
  );
--
type t_opt_vals is table of t_opt_val index by pls_integer; -- values of a value set
--
type t_form_field is record ( -- properties of a field
    obj t_objnum, -- PDF object ID (for internal use)
    gen t_objgen, -- PDF object generation (for internal use)
    parent_obj t_objnum, -- parant object ID (for internal use)
    parent_gen t_objgen, -- parent object generation (for internal use)
    name v2avg, -- name of object
    field_subtype varchar2(20 char), -- type of field (text, radiobutton, checkbox, choice, pushbutton)
    value_type varchar2(10 char), -- type of value implementation (HEX, BOOLEAN, NUMBER, DICT, TEXT, OBJREF, NAME) (for internal use)
    value_char v2long, -- value of field
    value_conv v2long, -- if value_type = 'HEX' then converted to text
    value_exist boolean, -- does field have a value?
    tx_maxlen number, -- if field_subtype='text' then maximum length of field
    read_only boolean, -- is field read only?
    required boolean, -- is field required
    flag number, -- flag of field (for internal use)
    opt_vals t_opt_vals -- value set of field
    );
--
type t_form_fields is table of t_form_field index by pls_integer; -- fields of a PDF
---------------------------------------------------------------------------------------------------
-- prepared form
type t_prepform_obj is record (
  obj t_objnum,
  gen t_objgen,
  field_name v2avg,
  field_subtype varchar2(20 char),
  value_type varchar2(10 char),
  orig_value v2max,
  orig_read_only boolean,
  new_value v2max,
  new_read_only boolean,
  orig_flag number,
  value_ref number,
  flag_ref number
  );
--
type t_prepform_objs is table of t_prepform_obj index by pls_integer;
--
type t_prepform_xref is table of number index by pls_integer;
--
type t_prepform is record (
  pdf_blob blob,
  last_obj_end number,
  xref t_prepform_xref,
  objs t_prepform_objs,
  root_ref t_obj_ref,
  info_ref t_obj_ref
  );
---------------------------------------------------------------------------------------------------
-- font properties by fontkey
type t_font_info is record (
  font_type v2avg,
  font_name v2avg,
  cw t_cw
  );
---------------------------------------------------------------------------------------------------
type t_text_line is record(
  text v2long,
  text_width number
  );
--
type t_text_lines is table of t_text_line index by pls_integer;
---------------------------------------------------------------------------------------------------
--font and fontkey info
type t_fk is record (
  family v2avg,
  style v2avg,
  fontkey v2avg
  );
---------------------------------------------------------------------------------------------------
type t_javascript is record (
  name v2avg,
  text v2max,
  stream_objnum t_objnum,
  name_objnum t_objnum
  );
type t_js is table of t_javascript index by pls_integer;
---------------------------------------------------------------------------------------------------
type t_intlinkdest is record (
    page pls_integer, --page num: 1,2,3...
    y number --y position
    );
	type t_intlinkdests is table of t_intlinkdest index by pls_integer;

type t_link is record (
    x number,
    y number,
    w number,
    h number,
    internal_link pls_integer,
    text_link plpdf_type.v2avg,
    objnum t_objnum
    );
type t_links Is table of t_link index by pls_integer;

type t_pagenum is record (
     currpagenum pls_integer,
     numofpages pls_integer
     );

type t_page is record (
  orientation v2one,
  pageformat t_pageformat,
  page_objnum t_objnum,
  content_objnum t_objnum,
  content_hf_objnum t_objnum, --header, footer
  tpl_idx pls_integer,
  tpl_fittopage boolean,
  tpl_rotate90 boolean, --v4.9.2
  content_t_objnum t_objnum, --template
  content_wm_objnum t_objnum, --watermark
  content_s_objnum t_objnum, --stamp
  pagenum t_pagenum,
  print_header boolean, --v4.9.6
  print_footer boolean
  );
type t_pages is table of t_page index by pls_integer;

--BLOB reader
type t_pblob is record (
  data blob,
  pointer pls_integer,
  raw_buffer raw(32000),
  raw_start pls_integer
  );
---------------------------------------------------------------------------------------------------
end;
/

