CREATE TABLE PLPDF_TTF_FILE ( -- file
id NUMBER NOT NULL,
fontfile_name VARCHAR2(255 char) NOT NULL, 
fontfile_data BLOB, 
afmfile_data BLOB,
ufmfile_data   BLOB -- add:v1.2.0
);

ALTER TABLE PLPDF_TTF_FILE ADD CONSTRAINT plpdf_file_pk PRIMARY KEY (id);

CREATE TABLE PLPDF_TTF_AFM ( -- afm
file_id NUMBER NOT NULL,
line_num NUMBER NOT NULL, 
line_data VARCHAR2(2000 char) NOT NULL 
);

ALTER TABLE PLPDF_TTF_AFM ADD CONSTRAINT plpdf_afm_pk PRIMARY KEY (file_id, line_num);

ALTER TABLE PLPDF_TTF_AFM ADD CONSTRAINT plpdf_afm_file_fk FOREIGN KEY (file_id) REFERENCES PLPDF_TTF_FILE (id); 

CREATE TABLE PLPDF_TTF_ADD ( -- add
id NUMBER NOT NULL,
file_id NUMBER NOT NULL,
encoding VARCHAR2(255 char),
add_name VARCHAR2(255 char), 
add_TYPE VARCHAR2(255 char), 
add_desc1_Ascent NUMBER, 
add_desc1_Descent NUMBER, 
add_desc1_CapHeight NUMBER, 
add_desc1_Flags NUMBER, 
add_desc1_FontBBox_v1 NUMBER,
add_desc1_FontBBox_v2 NUMBER,
add_desc1_FontBBox_v3 NUMBER,
add_desc1_FontBBox_v4 NUMBER,
add_desc1_ItalicAngle NUMBER, 
add_desc1_StemV NUMBER, 
add_desc1_MissingWidth NUMBER,
add_up VARCHAR2(255 char), 
add_ut VARCHAR2(255 char), 
add_enc VARCHAR2(255 char), 
add_FILE VARCHAR2(255 char),
add_diff VARCHAR2(4000 char), 
add_file_data BLOB, 
add_originalsize NUMBER,
add_ctg      VARCHAR2(255 BYTE),
add_ctg_data BLOB                
);

ALTER TABLE PLPDF_TTF_ADD ADD CONSTRAINT plpdf_add_pk PRIMARY KEY (id);

ALTER TABLE PLPDF_TTF_ADD ADD CONSTRAINT plpdf_add_file_fk FOREIGN KEY (file_id) REFERENCES PLPDF_TTF_FILE (id);

CREATE TABLE PLPDF_TTF_ADD_CW ( -- cw
add_id NUMBER NOT NULL,
cw_char VARCHAR2(1 char), 
cw_width NUMBER NOT NULL,
cw_char_num  NUMBER
);

ALTER TABLE PLPDF_TTF_ADD_CW ADD CONSTRAINT plpdf_add_cw_pk PRIMARY KEY (add_id,cw_char_num); -- mod:v1.2.0

ALTER TABLE PLPDF_TTF_ADD_CW ADD CONSTRAINT plpdf_cw_add_fk FOREIGN KEY (add_id) REFERENCES PLPDF_TTF_ADD (id);

--CREATE SEQUENCE plpdf_ttf_s; --v4.2.0

create table plpdf_ttf_add_c2g
(
  add_id      number not null,
  code        number not null,
  glyph       number not null
);

alter table plpdf_ttf_add_c2g
  add constraint plpdf_ttf_add_c2g_fk foreign key (add_id)
  references plpdf_ttf_add (id);

--v3.0.0
create index PLPDF_CW_ADD_FK_I on PLPDF_TTF_ADD_CW (add_id);

create index PLPDF_ADD_FILE_FK_I on PLPDF_TTF_ADD (file_id);  