create or replace package plpdf_ttf_parser
authid current_user is
--v5.9
--
function makeFont1(
    p_fontfile_name varchar2,
    p_fontfile in out nocopy blob,
    p_enc varchar2 default 'cp1252',
    p_enc_subset boolean default false
    ) return plpdf_type.t_addfont;

--
function MakeFont_Utf16(
  p_fontfile_name varchar2,
  p_fontfile in out nocopy blob,
  p_enable_subset boolean default false --v3.0.1
  ) return Plpdf_Type.t_addfont;

--
procedure StoreTTF1(
  p_font_file_id number,
  p_enc varchar2 default 'cp1252',
  p_commit boolean default true,
  p_enc_subset boolean default false
  );

--
procedure StoreTTF_Utf16(
  p_font_file_id number,
  p_commit boolean default true,
  p_enable_subset boolean default false--v3.0.1
  );

--
procedure StoreTTF(
  p_font_file_id number,
  p_enc varchar2 default 'cp1252',
  p_commit boolean default true
  );

--v4.2.0
procedure delTTF(
  p_ttf_add_id number,
  p_commit boolean default true
  );

--v4.2.0
procedure copyTTF(
  p_ttf_add_id number,
  p_new_ttf_add_id number,
  p_commit boolean default true
  );

--v4.2.0
procedure moveTTF(
  p_ttf_add_id number,
  p_new_ttf_add_id number,
  p_commit boolean default true
  );
--
end plpdf_ttf_parser;
/

