create or replace package plpdf_toc
authid current_user is
--v5.9
--
function getTOCStart
  return pls_integer;
--
function getTOCEnd
  return pls_integer;
--
function getTOCStopFooter
  return boolean;
--
procedure TOCPrint;
--
function getTocPrint
  return boolean;
--
procedure init;

/**
 <newpage/>
 <h1>Table Of Contents Commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>AddTOCItem</name>
 <type>Procedure</type>
 <desc>
  Add Table of Contents item.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>label of TOC item</param-desc>
  </param>
  <param>
   <param-def>p_level number default 0</param-def>
   <param-desc>level, 0 is the highest level</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position on the page, if null then the current Y coordinate, if 0 then the top of the page</param-desc>
  </param>
  <param>
   <param-def>p_page number default null</param-def>
   <param-desc>Page number, if null then the current page</param-desc>
  </param>
  <param>
   <param-def>p_add_link boolean default true</param-def>
   <param-desc>create link from TOC item to page</param-desc>
  </param>
  <param>
   <param-def>p_add_bookmark boolean default false</param-def>
   <param-desc>create bookmark for TOC item</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTOCItem(
  p_txt varchar2,
  p_level number default 0,
  p_y number default null,
  p_page number default null,
  p_add_link boolean default true,
  p_add_bookmark boolean default false
  );

/**
 <name>AddTOC</name>
 <type>Procedure</type>
 <desc>
  Construct Table of Contents.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item_height number default null</param-def>
   <param-desc>height of TOC item cell</param-desc>
  </param>
  <param>
   <param-def>p_stop_footer boolean default true</param-def>
   <param-desc>do not print footer (by executing the footer procedure) in TOC</param-desc>
  </param>
  <param>
   <param-def>p_title_font_family varchar2 default null</param-def>
   <param-desc>font family of title text</param-desc>
  </param>
  <param>
   <param-def>p_title_font_style varchar2 default null</param-def>
   <param-desc>font style (bold, italic, etc.) of title text</param-desc>
  </param>
  <param>
   <param-def>p_title_font_size number default null</param-def>
   <param-desc>font size of title text</param-desc></param>
  <param>
   <param-def>p_title_height number default null</param-def><param-desc>height of title's cell</param-desc>
  </param>
  <param>
   <param-def>p_title_text varchar2  default null</param-def>
   <param-desc>title of TOC if title is null then no title will be printed</param-desc>
  </param>
  <param>
   <param-def>p_title_body_gap number default 0</param-def>
   <param-desc>gap between title and TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_family varchar2 default null</param-def>
   <param-desc>font family of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_style varchar2 default null</param-def>
   <param-desc>font style of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_size number default null</param-def>
   <param-desc>font size of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_level_indent number  default 0</param-def>
   <param-desc>indent size for levels</param-desc>
  </param>
  <param>
   <param-def>p_separator varchar2 default ' '</param-def>
   <param-desc>filler between TOC item and page number</param-desc>
  </param>
   <param><param-def>p_move_to pls_integer default null</param-def>
   <param-desc>move TOC pages to a new page number in PDF</param-desc>
  </param>
   <param><param-def>p_custom_proc varchar2 default null</param-def>
   <param-desc>if a custom procedure is used for creating TOC then it is the name of procedure</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTOC(
  p_item_height number default null,
  p_stop_footer boolean default true,
  p_title_font_family varchar2 default null,
  p_title_font_style varchar2 default null,
  p_title_font_size number default null,
  p_title_height number default null,
  p_title_text varchar2  default null,
  p_title_body_gap number default 0,
  p_item_font_family varchar2 default null,
  p_item_font_style varchar2 default null,
  p_item_font_size number default null,
  p_level_indent number  default 0,
  p_separator varchar2 default ' ',
  p_move_to pls_integer default null,
  p_custom_proc varchar2 default null
  );

/**
 <name>InTOC</name>
 <type>Function</type>
 <desc>
  Is current position inside TOC.
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>
  <return-def>boolean</return-def>
  <return-desc>Current positin</return-desc>
 </return>
*/
function InTOC
  return boolean;

/**
 <name>GetTOCPageNum</name>
 <type>Function</type>
 <desc>
  If actual position is inside TOC then returns page number (first page of TOC returns 1).
 </desc>
 <version>v1.4.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>actual position</return-desc>
 </return>
*/
function GetTOCPageNum
  return number;

/**
 <name>PrintTOCItem</name>
 <type>Procedure</type>
 <desc>
  Print a TOC Item into the PDF (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item plpdf_type.t_toc_item</param-def>
   <param-desc>TOC Item</param-desc>
  </param>
  <param>
   <param-def>p_toc_level_indent number default 0</param-def>
   <param-desc>indent size for levels</param-desc>
  </param>
  <param>
   <param-def>p_toc_item_height number</param-def>
   <param-desc>height of TOC item cell</param-desc>
  </param>
  <param>
   <param-def>p_toc_separator varchar2 default '' ''</param-def>
   <param-desc>filler between TOC item and page number</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCItem(
  p_item plpdf_type.t_toc_item,
  p_toc_level_indent number default 0,
  p_toc_item_height number,
  p_toc_separator varchar2 default ' '
  );

/**
 <name>PrintTOCItem1</name>
 <type>Procedure</type>
 <desc>
  Print a TOC Item into the PDF with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item plpdf_type.t_toc_item</param-def>
   <param-desc>TOC Item</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCItem1(
  p_item plpdf_type.t_toc_item
  );

/**
 <name>TOCInsertGap</name>
 <type>Procedure</type>
 <desc>
  Insert gap between title and items (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_toc_title_body_gap number</param-def>
   <param-desc>size of gap</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure TOCInsertGap(
  p_toc_title_body_gap number
  );

/**
 <name>TOCInsertGap1</name>
 <type>Procedure</type>
 <desc>
  Insert gap between title and items with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>-</return>
*/
procedure TOCInsertGap1;

/**
 <name>PrintTOCTitle</name>
 <type>Procedure</type>
 <desc>
  Insert title section in TOC (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_toc_title_text varchar2 default null</param-def>
   <param-desc>text of title</param-desc>
  </param>
  <param>
   <param-def>p_toc_title_height number default null</param-def>
   <param-desc>height of title's cell</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCTitle(
  p_toc_title_text varchar2 default null,
  p_toc_title_height number default null
  );

/**
 <name>PrintTOCTitle1</name>
 <type>Procedure</type>
 <desc>
  Insert title section in TOC with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>-</return>
*/
procedure PrintTOCTitle1;

/**
 <name>getTOCItems</name>
 <type>Function</type>
 <desc>
  Returns array of TOC items (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>
  <return-def>plpdf_type.t_toc_items</return-def>
 </return>
*/
function getTOCItems
  return plpdf_type.t_toc_items;

/**
 <name>InsMoveTOC</name>
 <type>Procedure</type>
 <desc>
  Move TOC to specified page number.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_move_to pls_integer</param-def>
   <param-desc>page number</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure InsMoveTOC(
  p_move_to pls_integer
  );

/**
 <name>InsMoveTOC1</name>
 <type>Procedure</type>
 <desc>
  Move TOC to specified page number using p_move_to parameter in AddTOC.
 </desc>
 <version>v1.4.0</version>
 <params>-</params>
 <return>-</return>

*/
procedure InsMoveTOC1;

---------------------------------------------------------------------------------------------------
end plpdf_toc;
/

