create or replace package plpdf_tk5_val
authid current_user is
--v5.9
------------------------------------------------------------
type t_obj_val is record (
  id pls_integer, 
  parent_id pls_integer,
  val_type varchar2(10 char), -- HEX, BOOLEAN, NUMBER, DICT, TEXT, OBJREF, NAME
  val_store plpdf_type.v2one, -- C: char, R: raw, B: blob
  val_char  plpdf_type.v2max,
  val_raw raw(32000),
  val_blob blob
  );
--
type t_obj_vals is table of t_obj_val index by pls_integer;
--
type t_obj_vals_g is table of t_obj_vals index by pls_integer;
--
type t_obj_vals_og is table of t_obj_vals_g index by pls_integer;
------------------------------------------------------------
function getNextId
  return pls_integer; 
--
procedure resetValueId;  
--
procedure setValueId(
  p_val pls_integer
  );
------------------------------------------------------------
procedure insHexVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_val varchar2
  );
--
procedure insNameVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id number,
  p_name varchar2
  );
--
function insDictVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id number
  ) return number;
--
function insArrayVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id number
  ) return pls_integer;
--
procedure insStreamVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_stream blob
  );
--
procedure insObjrefVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_objref varchar2
  );
--
procedure insTokenVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_token varchar2
  );
--
procedure insCharVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_txt varchar2
  );
--
procedure insNumVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_parent_id pls_integer,
  p_num varchar2
  );
--                  
function getNameVal(
  p_obj_vals t_obj_vals,
  p_name varchar2
  ) return t_obj_val;
------------------------------------------------------------
function getNameVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_name varchar2
  ) return t_obj_val;
--
function getNameVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj_ref plpdf_type.t_obj_ref,
  p_name varchar2
  ) return t_obj_val;  
------------------------------------------------------------
procedure setNameVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj number,
  p_gen number,
  p_name varchar2,
  p_value varchar2
  );
------------------------------------------------------------
function GetStreamVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj number,
  p_gen number
  ) return blob;
------------------------------------------------------------
procedure getObjVal(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj_vals in out t_obj_vals,
  p_obj pls_integer,
  p_gen pls_integer,
  p_id pls_integer
  );
------------------------------------------------------------
procedure delObjVal( --recursive
  p_obj_vals_og in out nocopy t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer,
  p_id pls_integer
  );
------------------------------------------------------------
function getText(
  p_obj_val t_obj_val
  ) return varchar2;
------------------------------------------------------------
function getMaxValId(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer
  ) return pls_integer;
--
procedure setIdMaxValId(
  p_obj_vals_og in out t_obj_vals_og,
  p_obj pls_integer,
  p_gen pls_integer
  );  
------------------------------------------------------------
procedure MergeAcroformDicts(
  p_obj_vals_1 in out t_obj_vals,
  p_obj_vals_2 in out t_obj_vals,
  p_obj_offset pls_integer,
  p_max_val_id in out pls_integer --start
  );
-------------------------------------------------------------  
end plpdf_tk5_val;
/

