create or replace package plpdf_tk5_lob
authid current_user is
--v5.9
--
--internal
--------------------------------------------------------------------------------------------------
function instr1(
  p_blob in out nocopy blob,
  p_text varchar2,
  p_offset pls_integer default 1
  ) return pls_integer;
--  
function instr1_last(
  p_blob in out nocopy blob,
  p_text varchar2,
  p_offset pls_integer default 1
  ) return pls_integer;  
--
function getLine( 
  p_blob in out nocopy blob,
  p_offset pls_integer default 1,
  p_next_pos in out pls_integer
  ) return varchar2;
--  
function getWord( 
  p_blob in out nocopy blob,
  p_offset pls_integer default 1,
  p_next_pos in out pls_integer
  ) return varchar2;
--
function getTextBetween( 
  p_blob in out nocopy blob,
  p_start_text varchar2, 
  p_end_text varchar2, 
  p_offset pls_integer default 1
  ) return varchar2;
--
function substr( 
  p_blob in out nocopy blob,
  p_amount pls_integer,
  p_offset pls_integer default 1
  ) return varchar2;  
--
function substr_raw(
  p_blob in out nocopy blob,
  p_amount pls_integer,
  p_offset pls_integer default 1
  ) return raw;
--
function getTextBetweenLast( 
  p_blob in out nocopy blob,
  p_start_text varchar2,
  p_end_text varchar2, 
  p_offset pls_integer default 1 
  ) return varchar2;
--
function getTextStart( 
  p_blob in out nocopy blob,
  p_start_text varchar2,
  p_length pls_integer,
  p_offset pls_integer default 1
  ) return varchar2;
--  
function getTextStart_pos(
  p_blob in out nocopy blob,
  p_start_text varchar2,
  p_length pls_integer,
  p_offset pls_integer default 1,
  p_pos out pls_integer
  ) return varchar2;
--
function getTextStartLast(
  p_blob in out nocopy blob,
  p_start_text varchar2,
  p_length pls_integer
  ) return varchar2;
--
function getTextEnd(
  p_blob in out nocopy blob,
  p_end_text varchar2,
  p_start pls_integer default 1
  ) return varchar2;  
--
function get1Char(
  p_blob in out nocopy blob,
  p_pos number
  ) return varchar2;
--
procedure strip_white(
  p_blob in out nocopy blob,
  p_start in out number
  );
--
function get_next_delimiter_pos(
  p_obj in out nocopy blob,
  p_start number
  ) return number;  
--
function getChar(
  p_blob in out nocopy blob,
  p_pos number,
  p_length number
  ) return varchar2;
--
function read_token(
  p_obj in out nocopy blob,
  p_start in out number
  ) return varchar2;
--
function get_next_textclose_pos(
  p_obj in out nocopy blob,
  p_start pls_integer
  ) return pls_integer;
--
procedure strip_crlf(
  p_blob in out nocopy blob,
  p_start in out number
  );
--
function getBlob(
  p_blob in out nocopy blob,
  p_start number,
  p_length number
  ) return blob;
--
end plpdf_tk5_lob;
/

