create or replace package plpdf_tk5
authid current_user is
--v5.9
--
  type t_obj is record (
    offset pls_integer,
    read boolean default false,
    type plpdf_type.v2avg --"/Type"
    );
  type t_xref_g is table of t_obj index by pls_integer; --gen num
  type t_xref is table of t_xref_g index by pls_integer; --obj num
  --
  type t_obj_val_ref_id is record (obj pls_integer, gen pls_integer, id pls_integer);

  type t_pages_ref is table of plpdf_type.t_obj_ref index by pls_integer; --(num,gen)

  type t_box is record (
    x number,
    y number,
    w number,
    h number
    );

  type t_stream_obj is record (
    obj pls_integer,
    amount pls_integer,
    offset pls_integer
    );

  type t_stream_objs is table of t_stream_obj index by pls_integer;

  type t_objStm_obj is record (
    obj pls_integer,
    numofobjs pls_integer,
    first_offset pls_integer,
    unfiltered_stream blob,
    stream_objs t_stream_objs
    );

  type t_objStm_objs is table of t_objStm_obj index by pls_integer;

  type t_info is record (
    Title plpdf_type.v2avg,
    Author plpdf_type.v2avg,
    Subject plpdf_type.v2avg,
    Keywords plpdf_type.v2avg,
    Creator plpdf_type.v2avg,
    Producer plpdf_type.v2avg,
    CreationDate plpdf_type.v2avg,
    ModDate plpdf_type.v2avg,
    Trapped plpdf_type.v2avg
    );

  --
  type t_formdata_field is record (
    name  plpdf_type.v2avg,
    value plpdf_type.v2max
    );
  
  type t_formdata is table of t_formdata_field index by pls_integer;

  --**--
  type t_pdf is record (
    PDFVersion varchar2(3 char),
    xref_location pls_integer,
    xref_type plpdf_type.v2avg, --'xref' or 'obj'
    xref_obj_ref plpdf_type.t_obj_ref, --if 'obj'
    objStm_objs t_objStm_objs, 
    min_obj pls_integer,
    max_obj pls_integer,
    root_obj_ref plpdf_type.t_obj_ref,
    info_obj_ref plpdf_type.t_obj_ref,
    pages_obj_ref plpdf_type.t_obj_ref,
    acroform_id pls_integer,
    xref t_xref,
    pages_ref t_pages_ref,
    --info t_info,
    obj_vals_og plpdf_tk5_val.t_obj_vals_og
    );
--
----------------------------------------------------------------------
--
procedure init;
--
procedure parse(
  p_file blob
  );
--
function parse(
  p_file blob
  ) return t_pdf;
--
function getParsedPDF
  return t_pdf;
--
function getInfo
  return t_info;
--
function getInfo(
  p_file blob
  ) return t_info;
--
procedure sendDoc(
  p_file out nocopy blob
  );
--
procedure sendDoc(
  p_pdf in out nocopy t_pdf,
  p_file out nocopy blob
  );
--
function merge2(
  p_file_1 blob,
  p_file_2 blob 
  ) return blob;
--
procedure addPDF(
  p_pdf_1 in out nocopy t_pdf,
  p_pdf_2 in out nocopy t_pdf 
  );
--
function getFormData(
  p_pdf in out nocopy t_pdf
  ) return t_formdata;
--
function getFormData(
  p_file blob
  ) return t_formdata;
--
--
--  
end plpdf_tk5;
/

