create or replace package plpdf_text
authid current_user is
--v5.9
--------------------------------------------------
  c_text_type varchar2(10 char) := 'SINGLE';
  c_se varchar2(1 char) := '('; -- start_encloser
  c_ee varchar2(1 char) := ')'; -- end_encloser
  v_encoding  varchar2(20 char);
---------------------------------------------------------------------------------------------------
function xescape_single(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function xescape(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v4.3.0
function unescape(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function tohex(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function tohex_false(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v3.7.0
function tohex_ZapfDingbatsSymbol(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function cast_to_varchar2(
  p_s raw
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function cast_to_raw(
  p_s varchar2
  ) return raw;
---------------------------------------------------------------------------------------------------
function ascii1(
  p_s varchar2
  ) return number;
---------------------------------------------------------------------------------------------------
function replace_blob(
  p_blob in out nocopy blob,
  p_from varchar2,
  p_to varchar2,
  p_from2 varchar2 default null,
  p_to2 varchar2 default null,
  p_from3 varchar2 default null,
  p_to3 varchar2 default null
  ) return blob;
---------------------------------------------------------------------------------------------------
procedure repl_init(
  p_enc varchar2 default 'cp1252'
  );
---------------------------------------------------------------------------------------------------
function GetTextWidth_J(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--
function GetTextWidth_KC(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--
function GetTextWidth_1(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--v4.9.8
function GetTextWidthTTF(
  p_id number,
  p_fontsize number,
  p_s varchar2
  ) return number;
--
function RemoveMissingChars_1(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw
  ) return varchar2;
--
function RemoveMissingChars_CJK(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw
  ) return varchar2;
--
function textstringASCII(
  p_s varchar2,
  p_n pls_integer
  ) return varchar2;
--
function textstringHEX(
  p_s varchar2,
  p_n pls_integer
  ) return varchar2;
--v4.1.0
function textstringHEXonlyASCII(
  p_s varchar2,
  p_n pls_integer
  ) return varchar2;
--
function TextSplit(
  p_txt varchar2,
  p_w number,
  p_indent number default 0,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;
--
function TextSplitFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2,
  p_w number,
  p_indent number default 0,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v3.0.0
/**
 <name>TextSplit</name>
 <type>function</type>
 <desc>
  Splits text to a number of lines based on the width given
 </desc>
 <version>v2.6.0</version>
 <params>
  <param>
  <param-def>p_txt varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
  <param-def>p_w number</param-def>
   <param-desc>Width of lines</param-desc>
  </param>
  <param>
  <param-def>p_indent number default null</param-def>
   <param-desc>First line Indent</param-desc>
  </param>
  <param>
  <param-def>p_use_cell_margins boolean default true</param-def>
   <param-desc>If true then calculates with cell margins</param-desc>
  </param>
  <param>
   <param-def>p_maxline number default 0</param-def>
   <param-desc>Maximum number of lines returned. If 0 then all lines will be returned.</param-desc>
  </param>
 </params>
 <return>
 <return-def>plpdf_type.t_text_lines</return-def>
  <return-desc>Text as an array</return-desc>
 </return>
*/
function TextSplit(
  p_txt varchar2,
  p_w number,
  p_indent number default 0,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

/**
 <name>TextSplitFont</name>
 <type>function</type>
 <desc>
  Splits text to a number of lines based on the width given, font is parameter
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font type, null means current font family</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current font size</param-desc>
  </param>
  <param>
  <param-def>p_txt varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
  <param-def>p_w number</param-def>
   <param-desc>Width of lines</param-desc>
  </param>
  <param>
  <param-def>p_indent number default null</param-def>
   <param-desc>First line Indent</param-desc>
  </param>
  <param>
  <param-def>p_use_cell_margins boolean default true</param-def>
   <param-desc>If true then calculates with cell margins</param-desc>
  </param>
  <param>
   <param-def>p_maxline number default 0</param-def>
   <param-desc>Maximum number of lines returned. If 0 then all lines will be returned.</param-desc>
  </param>
 </params>
 <return>
 <return-def>plpdf_type.t_text_lines</return-def>
  <return-desc>Text as an array</return-desc>
 </return>
*/
function TextSplitFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2,
  p_w number,
  p_indent number default 0,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--
function getText1Sep(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_text varchar2, --text
  p_max_width number, --max width
  p_max_width_2 number
  ) return plpdf_type.t_text_line;

--
function TextSplitFont3(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2, --text
  p_max_width number, --column width
  p_first_width number default null --first line width
  ) return plpdf_type.t_text_lines;

--
function TextSplit3(
  p_txt varchar2, --text
  p_max_width number, --column width
  p_first_width number default null --first line width
  ) return plpdf_type.t_text_lines;
--CLOB
--textSplit CLOB
function TextSplitClob(
  p_txt clob,
  p_w number,
  p_indent number default 0,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;
--
function TextSplitFontClob(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt clob,
  p_w number,
  p_indent number default 0,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;
--
function TextSplitClob(
  p_txt clob,
  p_w number,
  p_indent number default 0,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;
--
function TextSplitFontClob(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt clob,
  p_w number,
  p_indent number default 0,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;
--
end plpdf_text;
/

