create or replace package plpdf_row
authid current_user is

/**
 <config>
  <pck-name>PL/PDF Row</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v5.9</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>PL/PDF Row package</h1>
 <br/>
 <p>
 PL/PDF Row printing package.
 </p>
 <br/>

 <newpage/>
*/

/**
 <name>init</name>
 <type>Procedure</type>
 <desc>
  Initializes (reset) program variables.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure init;

/**
 <name>setMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setMargin(
  p_margin number
  );

/**
 <name>getMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Margin size</return-desc>
 </return>
*/
function getMargin
  return number;

/**
 <name>setLeftMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftMargin(
  p_margin number
  );

/**
 <name>setRightMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightMargin(
  p_margin number
  );

/**
 <name>setTopMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopMargin(
  p_margin number
  );

/**
 <name>setBottomMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomMargin(
  p_margin number
  );

/**
 <name>getLeftMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell left margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of left margin</return-desc>
 </return>
*/
function getLeftMargin
  return number;

/**
 <name>getRightMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell right margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of right margin</return-desc>
 </return>
*/
function getRightMargin
  return number;

/**
 <name>getTopMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell top margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of top margin</return-desc>
 </return>
*/
function getTopMargin
  return number;

/**
 <name>getBottomMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of bottom margin</return-desc>
 </return>
*/
function getBottomMargin
  return number;

/**
 <name>setBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBorderColor
  return plpdf_type.t_color;

/**
 <name>setLeftBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setRightBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setTopBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setBottomBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getLeftBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell left border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getLeftBorderColor
  return plpdf_type.t_color;

/**
 <name>getRightBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell right border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getRightBorderColor
  return plpdf_type.t_color;

/**
 <name>getTopBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell top border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getTopBorderColor
  return plpdf_type.t_color;

/**
 <name>getBottomBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBottomBorderColor
  return plpdf_type.t_color;

/**
 <name>setBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBorderWidth(
  p_width number
  );

/**
 <name>getBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBorderWidth
  return number;

/**
 <name>setLeftBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftBorderWidth(
  p_width number
  );

/**
 <name>setRightBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightBorderWidth(
  p_width number
  );

/**
 <name>setTopBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopBorderWidth(
  p_width number
  );

/**
 <name>setBottomBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomBorderWidth(
  p_width number
  );

/**
 <name>getLeftBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell left border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getLeftBorderWidth
  return number;

/**
 <name>getRightBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell right border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getRightBorderWidth
  return number;

/**
 <name>getTopBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell top border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getTopBorderWidth
  return number;

/**
 <name>getBottomBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getBottomBorderWidth
  return number;

/**
 <name>setPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPadding(
  p_padding number
  );

/**
 <name>getPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getPadding
  return number;

/**
 <name>setLeftPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftPadding(
  p_padding number
  );

/**
 <name>setRightPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightPadding(
  p_padding number
  );

/**
 <name>setTopPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopPadding(
  p_padding number
  );

/**
 <name>setBottomPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomPadding(
  p_padding number
  );

/**
 <name>getLeftPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell left padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getLeftPadding
  return number;

/**
 <name>getRightPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell right padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getRightPadding
  return number;

/**
 <name>getTopPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell top padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getTopPadding
  return number;

/**
 <name>getBottomPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getBottomPadding
  return number;

/**
 <name>setBackgroundColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell background color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Background color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBackgroundColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getBackgroundColor</name>
 <type>Function</type>
 <desc>
  Gets the cell background color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>plpdf_type.t_color</return-def>
  <return-desc>Background color</return-desc>
 </return>
*/
function getBackgroundColor
  return plpdf_type.t_color;


--v4.4.0
procedure setMaxline(
  p_maxline pls_integer
  );

--v4.4.0
function getMaxline
  return pls_integer;

/**
 <name>crRow</name>
 <type>Procedure</type>
 <desc>
  Create an empty row.
 </desc>
 <version>v3.0.0</version>
 <params>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Set the row width.</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default null</param-def>
   <param-desc>Set the row minimum height.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure crRow(
  p_width number default null,
  p_min_height number default null
  );


/**
 <name>AddCell</name>
 <type>Procedure</type>
 <desc>
  Add cell to the row.
 </desc>
 <version>v3.0.0</version>
 <params>
 <param>
   <param-def>p_cell plpdf_cell.t_cell.</param-def>
   <param-desc>Table cell</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddCell(
  p_cell plpdf_cell.t_cell
  );
--

/**
 <name>printRow</name>
 <type>Procedure</type>
 <desc>
  Print row to the document.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure printRow;

--v4.3.0
procedure ParseRow;

--v4.3.0
function getParsedRowHeight
  return number;

--v4.3.0
function getParsedRow
  return plpdf3.t_parsed_row;

--v4.3.0
procedure printParsedRow;
--
end plpdf_row;
/

