create or replace package plpdf_reporter_types
authid current_user is
--v5.9
--
/* STRUCTURES */
-- t_param
type t_param is record(
  paramName plpdf_type.v2avg,
  paramValue plpdf_type.v2max,
  isText boolean
  );

-- t_params
type t_params is table of t_param;
v_params_empty t_params := t_params();

-- t_variable
type t_variable is record(
  variableName plpdf_type.v2avg,
  paramList t_params,
  section varchar2(6 char) --HEADER, FOOTER, BODY
);
type t_varList is table of t_variable;
v_varList_empty t_varList := t_varList();

-- t_codeblock
type t_codeblock is record(
  variable_name clob,
  variable_type clob,
  code clob,  -- ?
  params t_params default v_params_empty,
  caller_name clob
  );

-- t_codeblocks
type t_codeblocks is table of t_codeblock;
v_codeblocks_empty t_codeblocks := t_codeblocks();

--v4.9.6
subtype t_section is clob;

-- t_codeUnit
type t_codeUnit is record(
  headerSection t_section,
  bodySection t_section
  );

-- t_font_item
type t_font_item is record (
  family plpdf_type.v2avg,
  b boolean,
  i boolean
  );

-- t_font_map_item
type t_font_map_item is record (
    orig_font t_font_item,
    new_font t_font_item,
    id pls_integer,
    addok boolean --v4.2.0
    );

-- t_font_map
type t_font_map is table of t_font_map_item index by pls_integer; --index by original name

-- t_font_std_map
type t_font_std_map is table of plpdf_type.v2avg index by plpdf_type.v2avg;

-- t_internalLink
type t_internalLink is record(
    linkName plpdf_type.v2avg,
    linkId plpdf_type.v2avg
    );

-- t_linkStore_
type t_linkStore_ is table of t_internalLink;
v_linkStore_empty t_linkStore_ := t_linkStore_();

-- t_insideBorders
type t_insideBorders is record(
    insideV ploffx_document_type.CT_Border,
    insideH ploffx_document_type.CT_Border
    );
--
end plpdf_reporter_types;
/

