create or replace package plpdf_pattern
authid current_user is
--v5.9
--
--v3.6.0
type t_pattern is record (
  n pls_integer,
  stream_blob blob, --v3.6.0
  w number,
  h number,
  objnum plpdf_type.t_objnum
  );
  --
type t_patterns is table of t_pattern index by plpdf_type.v2avg;
--
v_patterns t_patterns;
v_cs1_objnum plpdf_type.t_objnum;
v_pattern_name plpdf_type.v2avg;
v_pattern_color plpdf_type.t_color;

procedure init;

/**
 <name>startTillingPattern</name>
 <type>function</type>
 <desc>
  Starts of define a "Tilling Pattern". Tiling patterns consist of a small graphical figure (called a pattern cell) that is
  replicated at fixed horizontal and vertical intervals to fill the area to be painted.
  <br/>
  Add "graphical figure" to pattern:
  <param-ul>
   <param-li>Line: add a line to pattern</param-li>
   <param-li>Rect: add a rectangle to pattern</param-li>
   <param-li>Ellipse: add a ellipse to pattern</param-li>
   <param-li>Circle: add a circle to pattern</param-li>
   <param-li>Polygon: add a polygon to pattern</param-li>
  </param-ul>
 </desc>
 <version>v3.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>width of pattern cell</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>height of pattern cell</param-desc>
  </param>
 </params>
 <return>
 <return-def>pls_integer</return-def>
  <return-desc>Pattern ID</return-desc>
 </return>
*/
function startTillingPattern(
  p_name varchar2,
  p_width number,
  p_height number
  ) return pls_integer;

procedure startTillingPattern(
  p_name varchar2,
  p_width number,
  p_height number
  );

/**
 <name>endTillingPattern</name>
 <type>procedure</type>
 <desc>
  Ends of define a "Tilling Pattern". Tiling patterns consist of a small graphical figure (called a pattern cell) that is
  replicated at fixed horizontal and vertical intervals to fill the area to be painted.
 </desc>
 <version>v3.6.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure endTillingPattern;

/**
 <name>setTillingPattern</name>
 <type>Procedure</type>
 <desc>
  Sets the fill pattern for objects inserted after this statement.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern, see <link>CrTillingPattern</link></param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>color of "graphical figures"</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTillingPattern(
  p_name varchar2,
  p_color plpdf_type.t_color default null
  );

/**
 <name>getTillingPatternColor</name>
 <type>Function</type>
 <desc>
  Gets the color of filling pattern for objects.
 </desc>
 <version>v1.1.7</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Pattern filling color</return-desc>
 </return>
*/
function getTillingPatternColor
  return plpdf_type.t_color;

/**
 <name>getTillingPatternName</name>
 <type>Function</type>
 <desc>
  Gets the name of filling pattern for objects.
 </desc>
 <version>v1.1.7</version>
 <params>- </params>
 <return>
  <return-def>varchar2</return-def>
 </return>
*/
function getTillingPatternName
  return varchar2;

/**
 <name>setDashPattern</name>
 <type>Procedure</type>
 <desc>
  Sets the dash pattern for lines inserted after this statement. Call the procedure without parameter to restore normal drawing.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_line number default null</param-def>
   <param-desc> length of dashes</param-desc>
  </param>
  <param>
   <param-def>p_noline number default null</param-def>
   <param-desc> length of gaps</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDashPattern(
  p_line number default null,
  p_noline number default null
  );

---------------------------------------------------------------------------------------------------------
--INTERNAL
procedure tillingpattern(
  p_name varchar2,
  p_color plpdf_type.t_color  default null
  );

end plpdf_pattern;
/

