-- Template v2.5.0
create table PLPDF_TEMPLATE
(
  ID            NUMBER not null,
  orig_pdf      blob,
  page_id       number,
  descr         VARCHAR2(255 CHAR),
  crd           date,
  lmd           date,
  STREAM_FILTER VARCHAR2(255 CHAR),
  STREAM_BLOB   BLOB,
  BOX_CHAR      VARCHAR2(255 CHAR),
  RES           NUMBER,
  STREAM_LENGTH NUMBER,
  X             NUMBER,
  Y             NUMBER,
  W             NUMBER,
  H             NUMBER,
  RES_OBJ_OBJ   NUMBER,
  RES_OBJ_GEN   NUMBER,
  RES_OBJ_ID    NUMBER
);

alter table PLPDF_TEMPLATE
  add constraint PLPDF_TPL_PK primary key (ID);
  
-- Template detail objects
create table PLPDF_TEMPLATE_D_OBJ_REFS
(
  TPL_ID NUMBER not null,
  D_ID   NUMBER,
  OBJ    NUMBER,
  GEN    NUMBER
);

alter table PLPDF_TEMPLATE_D_OBJ_REFS
  add constraint PLPDF_DOR_TPL_FK foreign key (TPL_ID)
  references PLPDF_TEMPLATE (ID);
  
create index PLPDF_DOR_TPL_FK_I 
  on PLPDF_TEMPLATE_D_OBJ_REFS (TPL_ID);
  
-- Template Objectum values
create table PLPDF_TEMPLATE_OBJ_VALS
(
  TPL_ID    NUMBER not null,
  S_ID      NUMBER,
  G_ID      NUMBER,
  I_ID      NUMBER,
  ID        NUMBER,
  PARENT_ID NUMBER,
  VAL_TYPE  VARCHAR2(10 CHAR),
  VAL_STORE VARCHAR2(1 CHAR),
  VAL_CHAR  CLOB,
  VAL_RAW   RAW(2000),
  VAL_BLOB  BLOB
);

alter table PLPDF_TEMPLATE_OBJ_VALS
  add constraint PLPDF_OV_TPL_FK foreign key (TPL_ID)
  references PLPDF_TEMPLATE (ID);

create index PLPDF_OV_TPL_FK_I 
  on PLPDF_TEMPLATE_OBJ_VALS (TPL_ID);
  
--v4.2.0
--create sequence PLPDF_TEMPLATE_S;
  
  