create or replace package plpdf_cell
authid current_user is
/**
 <config>
  <pck-name>PL/PDF Cell</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v5.9</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>PL/PDF Cell package</h1>
 <br/>
 <p>
 PL/PDF Cell printing package.
 </p>
 <br/>

 <newpage/>
*/


type t_cell is record (
  cell plpdf3.t_TableCell,
  width number,
  height number
  );

/**
 <name>init</name>
 <type>Procedure</type>
 <desc>
  Initializes (reset) program variables.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure init;

--v4.2.0
procedure init(
  p_cell_settings plpdf3.t_box
  );


/**
 <name>setLastCellHeight</name>
 <type>Procedure</type>
 <desc>
  Set last cell height global variable.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Height of the line break.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLastCellHeight(
  p_height number default null
  );

/**
 <name>getLastCellHeight</name>
 <type>Function</type>
 <desc>
  Get last cell height global variable.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Height of line break</return-desc>
 </return>
*/
function getLastCellHeight
  return number;

procedure NewLine;

/**
 <name>setMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setMargin(
  p_margin number
  );

/**
 <name>getMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Margin size</return-desc>
 </return>
*/
function getMargin
  return number;

/**
 <name>setLeftMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftMargin(
  p_margin number
  );

/**
 <name>setRightMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightMargin(
  p_margin number
  );

/**
 <name>setTopMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopMargin(
  p_margin number
  );

/**
 <name>setBottomMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom margin size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomMargin(
  p_margin number
  );

/**
 <name>getLeftMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell left margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of left margin</return-desc>
 </return>
*/
function getLeftMargin
  return number;

/**
 <name>getRightMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell right margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of right margin</return-desc>
 </return>
*/
function getRightMargin
  return number;

/**
 <name>getTopMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell top margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of top margin</return-desc>
 </return>
*/
function getTopMargin
  return number;

/**
 <name>getBottomMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom margin size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of bottom margin</return-desc>
 </return>
*/
function getBottomMargin
  return number;

/**
 <name>setBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBorderColor
  return plpdf_type.t_color;

/**
 <name>setLeftBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setRightBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setTopBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>setBottomBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom border color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Border color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomBorderColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getLeftBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell left border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getLeftBorderColor
  return plpdf_type.t_color;

/**
 <name>getRightBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell right border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getRightBorderColor
  return plpdf_type.t_color;

/**
 <name>getTopBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell top border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getTopBorderColor
  return plpdf_type.t_color;

/**
 <name>getBottomBorderColor</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom border color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBottomBorderColor
  return plpdf_type.t_color;

/**
 <name>setBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBorderWidth(
  p_width number
  );

/**
 <name>getBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Border color</return-desc>
 </return>
*/
function getBorderWidth
  return number;

/**
 <name>setLeftBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftBorderWidth(
  p_width number
  );

/**
 <name>setRightBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightBorderWidth(
  p_width number
  );

/**
 <name>setTopBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopBorderWidth(
  p_width number
  );

/**
 <name>setBottomBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom border width.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Border width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomBorderWidth(
  p_width number
  );

/**
 <name>getLeftBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell left border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getLeftBorderWidth
  return number;

/**
 <name>getRightBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell right border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getRightBorderWidth
  return number;

/**
 <name>getTopBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell top border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getTopBorderWidth
  return number;

/**
 <name>getBottomBorderWidth</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom border width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Border width</return-desc>
 </return>
*/
function getBottomBorderWidth
  return number;

/**
 <name>setPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPadding(
  p_padding number
  );

/**
 <name>getPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getPadding
  return number;

/**
 <name>setLeftPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftPadding(
  p_padding number
  );

/**
 <name>setRightPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightPadding(
  p_padding number
  );

/**
 <name>setTopPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopPadding(
  p_padding number
  );

/**
 <name>setBottomPadding</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom padding.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_padding number</param-def>
   <param-desc>Padding width</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBottomPadding(
  p_padding number
  );

/**
 <name>getLeftPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell left padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getLeftPadding
  return number;

/**
 <name>getRightPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell right padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getRightPadding
  return number;

/**
 <name>getTopPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell top padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getTopPadding
  return number;

/**
 <name>getBottomPadding</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom padding width.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Padding width</return-desc>
 </return>
*/
function getBottomPadding
  return number;

/**
 <name>setBackgroundColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell background color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Background color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBackgroundColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getBackgroundColor</name>
 <type>Function</type>
 <desc>
  Gets the cell background color.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>plpdf_type.t_color</return-def>
  <return-desc>Background color</return-desc>
 </return>
*/
function getBackgroundColor
  return plpdf_type.t_color;

/**
 <name>setFontName</name>
 <type>Procedure</type>
 <desc>
  Sets the cell font name.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_fontname varchar2</param-def>
   <param-desc>Font Name, see PL/PDF fonts</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFontName(
  p_fontname varchar2
  );

/**
 <name>setFontSize</name>
 <type>Procedure</type>
 <desc>
  Sets the cell font size.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_size number</param-def>
   <param-desc>Font Size, see PL/PDF fonts</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFontSize(
  p_size number
  );

/**
 <name>setFontBold</name>
 <type>Procedure</type>
 <desc>
  Sets the cell font bold property.
 </desc>
 <version>v4.2.0</version>
 <params>
 <param>
   <param-def>p_bold boolean default true</param-def>
   <param-desc>Bold or not bold</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFontBold(
  p_bold boolean default true
  );

/**
 <name>setFontItalic</name>
 <type>Procedure</type>
 <desc>
  Sets the cell font italic property.
 </desc>
 <version>v4.2.0</version>
 <params>
 <param>
   <param-def>p_italic boolean default true</param-def>
   <param-desc>Italic or not italic</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFontItalic(
  p_italic boolean default true
  );

/**
 <name>setFontUnderline</name>
 <type>Procedure</type>
 <desc>
  Sets the cell font underline property.
 </desc>
 <version>v4.2.0</version>
 <params>
 <param>
   <param-def>p_underline boolean default true</param-def>
   <param-desc>Underline or not underline</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFontUnderline(
  p_underline boolean default true
  );

/**
 <name>getFontName</name>
 <type>Function</type>
 <desc>
  Gets the cell font name.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>varchar2</return-def>
  <return-desc>Font name</return-desc>
 </return>
*/
function getFontName
  return varchar2;

/**
 <name>getFontSize</name>
 <type>Function</type>
 <desc>
  Gets the cell font size.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>number</return-def>
  <return-desc>Font size</return-desc>
 </return>
*/
function getFontSize
  return number;

/**
 <name>getFontBold</name>
 <type>Function</type>
 <desc>
  Gets the cell font bold property.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>boolean</return-def>
  <return-desc>Font is bold or not</return-desc>
 </return>
*/
function getFontBold
  return boolean;

/**
 <name>getFontItalic</name>
 <type>Function</type>
 <desc>
  Gets the cell font italic property.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>boolean</return-def>
  <return-desc>Font is italic or not</return-desc>
 </return>
*/
function getFontItalic
  return boolean;

/**
 <name>getFontUnderline</name>
 <type>Function</type>
 <desc>
  Gets the cell font underline property.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>boolean</return-def>
  <return-desc>Font is underlined or not</return-desc>
 </return>
*/
function getFontUnderline
  return varchar2;

/**
 <name>setTextColor</name>
 <type>Procedure</type>
 <desc>
  Sets the cell text color.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Text color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTextColor(
  p_color plpdf_type.t_color
  );

/**
 <name>getTextColor</name>
 <type>Function</type>
 <desc>
  Gets the cell text color property.
 </desc>
 <version>v3.0.0</version>
 <params>-</params>
 <return>
 <return-def>plpdf_type.t_color</return-def>
  <return-desc>The text color</return-desc>
 </return>
*/
function getTextColor
  return plpdf_type.t_color;

--v4.4.0
procedure setMaxline(
  p_maxline pls_integer
  );

--v4.4.0
function getMaxline
  return pls_integer;

--v4.4.0
procedure setLineSpacing(
  p_linespacing number
  );

--v4.4.0
function getLineSpacing
  return number;

--v4.4.0
procedure setLineHeight(
  p_lineheight number
  );

--v4.4.0
function getLineHeight
  return number;


--v4.2.0
function getCellSettings
  return plpdf3.t_box;

/**
 <name>PrintCell</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle cell with text inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Text of the cell</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_justified:justified</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_indent number default 0</param-def>
   <param-desc>Indentation of the text</param-desc>
  </param>
  <param>
   <param-def>p_ln number default plpdf_const.beside</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>plpdf_const.beside: Beside the cell</param-li>
    <param-li>plpdf_const.newline: New line</param-li>
    <param-li>plpdf_const.under: Under the cell</param-li>
   </param-ul>
  </param>
  </params>
 <return>-</return>
 */
procedure printCell(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center,
  p_indent number default 0,
  p_ln number default plpdf_const.beside
  );

--v4.4.0
procedure printCell(
  p_cell t_cell,
  p_ln number default plpdf_const.beside
  );

--v3.6.0
procedure printCellXhtml(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_vert_align varchar2 default plpdf3.c_center,
  p_ln number default plpdf_const.beside
  );

/**
 <name>printMultilineCell</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle cell with multiline text inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Text of the cell</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_indent number default 0</param-def>
   <param-desc>First line indent</param-desc>
  </param>
  <param>
   <param-def>p_ln number default plpdf_const.beside</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>plpdf_const.beside: Beside the cell</param-li>
    <param-li>plpdf_const.newline: New line</param-li>
    <param-li>plpdf_const.under: Under the cell</param-li>
   </param-ul>
  </param>
  </params>
 <return>-</return>
 */
procedure printMultilineCell(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center,
  p_indent number default 0,
  p_ln number default plpdf_const.beside
  );

--v3.6.0
procedure printMultilineCellXhtml(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_vert_align varchar2 default plpdf3.c_center,
  p_ln number default plpdf_const.beside
  );

/**
 <name>printImageCell</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle cell with image inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of image</param-desc>
  </param>
  <param>
   <param-def>p_data blob</param-def>
   <param-desc>image</param-desc>
  </param>
  <param>
   <param-def>p_img_width number default null</param-def>
   <param-desc>Image width, null: uses original image width</param-desc>
  </param>
  <param>
   <param-def>p_img_height number default null</param-def>
   <param-desc>Image height, null: uses original image height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_ln number default plpdf_const.beside</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>plpdf_const.beside: Beside the cell</param-li>
    <param-li>plpdf_const.newline: New line</param-li>
    <param-li>plpdf_const.under: Under the cell</param-li>
   </param-ul>
  </param>
  </params>
 <return>-</return>
 */
procedure printImageCell(
  p_width number default null,
  p_height number  default null,
  p_name varchar2,
  p_data in out nocopy blob,
  p_img_width number default null,
  p_img_height number default null,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center,
  p_ln number default plpdf_const.beside
  );


/**
 <name>crCell</name>
 <type>Function</type>
 <desc>
  Creates cell for plpdf_row.addCell procedure.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Text of the cell</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_justified:justified</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_ln number default plpdf_const.beside</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>plpdf_const.beside: Beside the cell</param-li>
    <param-li>plpdf_const.newline: New line</param-li>
    <param-li>plpdf_const.under: Under the cell</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_indent number default 0</param-def>
   <param-desc>Indentation of the text</param-desc>
  </param>
  </params>
 <return>
   <return-def>plpdf_cell.t_cell</return-def>
   <return-desc>Returns the created cell</return-desc>
 </return>
 */
function crCell(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center,
  p_indent number default 0
  ) return t_cell;

/**
 <name>crCellXhtml</name>
 <type>Function</type>
 <desc>
  Create XHTML formatted cell. You can use XHTML tag in the text. Like b - bold,i - italic,
 </desc>
 <version>v3.6.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Text of the cell</param-desc>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  </params>
 <return>
   <return-def>plpdf_cell.t_cell</return-def>
   <return-desc>Returns the created cell</return-desc>
 </return>
 */
function crCellXhtml(
  p_width number default null,
  p_height number  default null,
  p_text varchar2,
  p_vert_align varchar2 default plpdf3.c_center
  ) return t_cell;

/**
 <name>crImageCell</name>
 <type>Function</type>
 <desc>
  Creates a rectangle cell with image inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.0.1</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of image</param-desc>
  </param>
  <param>
   <param-def>p_data blob</param-def>
   <param-desc>image</param-desc>
  </param>
  <param>
   <param-def>p_img_width number default null</param-def>
   <param-desc>Image width, null: uses original image width</param-desc>
  </param>
  <param>
   <param-def>p_img_height number default null</param-def>
   <param-desc>Image height, null: uses original image height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  </params>
 <return>
   <return-def>plpdf_cell.t_cell</return-def>
   <return-desc>Returns the created cell</return-desc>
 </return>
 */
function crImageCell(
  p_width number default null,
  p_height number  default null,
  p_name varchar2,
  p_data in out nocopy blob,
  p_img_width number default null,
  p_img_height number default null,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center
  ) return t_cell;


/**
 <name>printCode39BarcodeCell</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle cell with Code39 barcode inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.4.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_data varchar2</param-def>
   <param-desc>value of the barcode</param-desc>
  </param>
  <param>
   <param-def>p_gap number default null</param-def>
   <param-desc>gap between barcode and text. null = no print text</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf3.t_font default null</param-def>
   <param-desc>print text of font type</param-desc>
  </param>
  <param>
   <param-def>p_barc_width number default null</param-def>
   <param-desc>Barcode width, null: uses cell width</param-desc>
  </param>
  <param>
   <param-def>p_barc_height number default null</param-def>
   <param-desc>Barcode height, null: uses cell height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_ln number default plpdf_const.beside</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>plpdf_const.beside: Beside the cell</param-li>
    <param-li>plpdf_const.newline: New line</param-li>
    <param-li>plpdf_const.under: Under the cell</param-li>
   </param-ul>
  </param>
  </params>
 <return>-</return>
 */
procedure printCode39BarcodeCell(
  p_width number default null,
  p_height number  default null,
  p_data varchar2,
  p_gap number default null,
  p_font plpdf3.t_font default null,
  p_barc_width number default null,
  p_barc_height number default null,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center,
  p_ln number default plpdf_const.beside
  );

/**
 <name>crCode39BarcodeCell</name>
 <type>Function</type>
 <desc>
  Creates a rectangle cell with Code39 barcode inside. The rectangle is simlar as CSS box model.
 </desc>
 <version>v3.4.0</version>
 <params>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Rectangle width, null: uses minimum cell width</param-desc>
  </param>
  <param>
   <param-def>p_height number  default null</param-def>
   <param-desc>Rectangle height, null: uses minimum cell height</param-desc>
  </param>
  <param>
   <param-def>p_data varchar2</param-def>
   <param-desc>value of the barcode</param-desc>
  </param>
  <param>
      <param-def>p_gap number default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font plpdf3.t_font default null</param-def>
      <param-desc>print text of font type</param-desc>
    </param>
  <param>
   <param-def>p_barc_width number default null</param-def>
   <param-desc>Barcode width, null: uses cell width</param-desc>
  </param>
  <param>
   <param-def>p_barc_height number default null</param-def>
   <param-desc>Barcode height, null: uses cell height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>Hyperlink or internal link of the cell</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default plpdf3.c_left</param-def>
   <param-desc>Text alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_left: left</param-li>
    <param-li>plpdf3.c_right: right</param-li>
    <param-li>plpdf3.c_center: center</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default plpdf3.c_center</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>plpdf3.c_center: center</param-li>
    <param-li>plpdf3.c_top: top</param-li>
    <param-li>plpdf3.c_bottom: bottom</param-li>
   </param-ul>
  </param>
  </params>
 <return>
   <return-def>plpdf_cell.t_cell</return-def>
   <return-desc>Returns the created cell</return-desc>
 </return>
 */
function crCode39BarcodeCell(
  p_width number default null,
  p_height number  default null,
  p_data varchar2,
  p_gap number default null,
  p_font plpdf3.t_font default null,
  p_barc_width number default null,
  p_barc_height number default null,
  p_link varchar2 default null,
  p_align varchar2 default plpdf3.c_left,
  p_vert_align varchar2 default plpdf3.c_center
  ) return t_cell;

end plpdf_cell;
/

