create or replace package plpdf_barcode
authid current_user is

/**
  <config>
    <pck-name>PL/PDF Barcode</pck-name>
    <pck-title>User's Guide</pck-title>
    <pck-version>v5.9</pck-version>
    <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
    <header-size>10</header-size>
    <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
    <footer-size>10</footer-size>
  </config>
*/

/**
  <h2>code39</h2>
  <type>Procedure</type>
  <desc>
    Create "Code39" barcodes.
  </desc>
  <version>v3.4.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>p
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>Value of the barcode.</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>Width of a bar.</param-desc>
    </param>
    <param>
      <param-def>p_barheight number</param-def>
      <param-desc>Height of a bar.</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font_type plpdf_type.t_row_font record default null</param-def>
      <param-desc>Font type of printed text</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure code39(
    p_x         number,
    p_y         number,
    p_code      varchar2,
    p_basewidth number,
    p_barheight    number,
    p_gap       number  default null,
    p_font_type plpdf_type.t_font default null
  );

/**
  <h2>code39</h2>
  <type>Procedure</type>
  <desc>
    Create "Code39" barcodes.
  </desc>
  <version>v3.4.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_width number</param-def>
      <param-desc>width of draw frame</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font_type plpdf_type.t_row_font record default null</param-def>
      <param-desc>Font type of printed text.</param-desc>
    </param>
  </params>
  <return>-</return>
*/

  procedure code39(
    p_x         number,
    p_y         number,
    p_width     number,
    p_height    number,
    p_code      varchar2,
    p_gap       number  default null,
    p_font_type plpdf_type.t_font default null
  );
/**
  <h2>ean13</h2>
  <type>Procedure</type>
  <desc>
    Create "EAN13" barcodes.
  </desc>
  <version>v4.6.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number</param-def>
      <param-desc>gap between barcode and text. 0 = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font_type plpdf_type.t_row_font record default null</param-def>
      <param-desc>Font type of printed text.</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure ean13(
    p_x         number,
    p_y         number,
    p_code      varchar2,
    p_basewidth number,
    p_height    number,
    p_gap       number  default null,
    p_font_type plpdf_type.t_font default null
  );

/**
  <h2>upc_a</h2>
  <type>Procedure</type>
  <desc>
    Create "UPC-A" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font_type plpdf_type.t_row_font record default null</param-def>
      <param-desc>Font type of printed text.</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure upc_a(
    p_x         number,
    p_y         number,
    p_code      varchar2,
    p_basewidth number,
    p_height    number,
    p_gap       number  default null,
    p_font_type plpdf_type.t_font default null
  );

/**
  <h2>b2of5</h2>
  <type>Procedure</type>
  <desc>
    Create "2 of 5 interleaved code" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
    <param>
      <param-def>p_font_type plpdf_type.t_row_font record default null</param-def>
      <param-desc>Font type of printed text.</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure b2of5(
    p_x number,
    p_y number,
    p_code varchar2,
    p_basewidth number,
    p_height number,
    p_gap number  default null,
    p_font_type plpdf_type.t_font default null
  );

/**
  <h2>pdf417</h2>
  <type>Procedure</type>
  <desc>
    Create "PDF417" barcodes.
  </desc>
  <version>v2.3.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_secu number default -1</param-def>
      <param-desc>The hoped security level, -1 = automatic</param-desc>
    </param>
    <param>
      <param-def>p_nbcol number default -1</param-def>
      <param-desc>The hoped number of data MC columns, -1 = automatic</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure pdf417(
    p_x number,
    p_y number,
    p_code varchar2,
    p_basewidth number,
    p_height number,
    p_secu number default -1,
    p_nbcol number default -1
  );

/**
  <h2>postnet</h2>
  <type>Procedure</type>
  <desc>
    Create "PostNet" barcodes.
  </desc>
  <version>v1.3.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>The code is a zipcode for barcode. Zipcode form is "99999" or "99999-9999"</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure postnet(
    p_x number,
    p_y number,
    p_code varchar2
  );

/**
  <h2>code128</h2>
  <type>Procedure</type>
  <desc>
    Create "Code128" barcodes. see <link>http://www.adams1.com/pub/russadam/128code.html</link>
  </desc>
  <version>v2.1.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure code128(
    p_x         number,
    p_y         number,
    p_code      varchar2,
    p_basewidth number,
    p_height    number,
    p_w_mode    boolean default false
  );

  --v4.8.3
  procedure code128(
    p_x         number,
    p_y         number,
    p_code      varchar2,
    p_width     number,
    p_height    number,
    p_w_mode    boolean default false
  );

/**
  <h2>code128w</h2>
  <type>Procedure</type>
  <desc>
    Create "Code128" barcodes. see <link>http://www.adams1.com/pub/russadam/128code.html</link>
  </desc>
  <version>v2.0.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_width number</param-def>
      <param-desc>width of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
  </params>
  <return>-</return>
*/
  procedure code128w(
    p_x number,
    p_y number,
    p_code varchar2,
    p_width number,
    p_height number
  );

/**
  <h2>code128ABC</h2>
  <type>Procedure</type>
  <desc>
    Create "Code128" barcodes. This procedure handles Code 128 barcodes (A, B and C). All the 128 ASCII characters are available. A, B and C character sets are automatically selected according to the value to print.
  </desc>
  <version>v3.0.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_width number</param-def>
      <param-desc>width of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure code128ABC(
  p_x         number,
  p_y         number,
  p_code      varchar2,
  p_width     number,
  p_height    number
  );

--v4.2.0
procedure GS1_128(
  p_x         number,
  p_y         number,
  p_code      varchar2,
  p_width     number,
  p_height    number
  );

/**
  <h2>qrsize</h2>
  <type>Function</type>
  <desc>
    Calculates the size of the QR code from a text input.
  </desc>
  <version>v3.2.0</version>
  <params>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode</param-desc>
    </param>
    <param>
      <param-def>p_level varchar2</param-def>
      <param-desc>error-correction level of the barcode
      L - 7% data recovery
      M - 15% data recovery
      Q - 25% data recovery
      H - 30% data recovery
      </param-desc>
    </param>
    <param>
      <param-def>p_micro boolean</param-def>
      <param-desc>generates microQR, if the text fits into its size</param-desc>
    </param>
  </params>
  <return>Size of the QRCode barcode</return>
*/
function qrsize(
  p_text      varchar2,
  p_level     varchar2,
  p_micro     boolean default false
  ) return number;

/**
  <h2>qrcode</h2>
  <type>Procedure</type>
  <desc>
    Create "QR-code" barcodes. All the letters, numbers and special characters are available. Algorithm automatically selects the type and size of the barcode
    depending on its characters and error-correction level.
  </desc>
  <version>v3.2.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode</param-desc>
    </param>
    <param>
      <param-def>p_level varchar2</param-def>
      <param-desc>error-correction level of the barcode
      L - 7% data recovery
      M - 15% data recovery
      Q - 25% data recovery
      H - 30% data recovery
      </param-desc>
    </param>
    <param>
      <param-def>p_scale number</param-def>
      <param-desc>The scale to enlarge the barcode</param-desc>
    </param>
    <param>
      <param-def>p_micro boolean</param-def>
      <param-desc>generates microQR, if the text fits into its size</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure qrcode(
  p_x         number,
  p_y         number,
  p_text      varchar2,
  p_level     varchar2,
  p_scale     number default 1,
  p_micro     boolean default false
  );

/**
  <h2>datamatrixsize</h2>
  <type>Function</type>
  <desc>
    Calculate the size of the datamatrix from a text input.
  </desc>
  <version>v3.2.0</version>
  <params>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode. Maximum length of alphanumeric text: 1304, numeric text: 2608</param-desc>
    </param>
  </params>
  <return>-</return>
*/
function datamatrixsize(
  p_text      varchar2
  ) return number;
/**
  <h2>qrcode</h2>
  <type>Procedure</type>
  <desc>
    Create "Datamatrix" barcodes. All the letters, numbers and special characters are available. Algorithm automatically selects the size of the barcode
    depending on its characters.
  </desc>
  <version>v3.2.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode</param-desc>
    </param>
    <param>
      <param-def>p_scale number</param-def>
      <param-desc>The scale to enlarge the barcode greater than 1</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure datamatrix(
  p_x         number,
  p_y         number,
  p_text      varchar2,
  p_scale     number default 1
  );

/**
  <h2>aztecsize</h2>
  <type>Procedure</type>
  <desc>
    Calculates the size of the Aztec Code code from a text and error correction input.
  </desc>
  <version>v3.5.0</version>
  <params>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode</param-desc>
    </param>
    <param>
      <param-def>p_sec number</param-def>
      <param-desc>The security level of correction in percent. 2-90</param-desc>
    </param>
  </params>
  <return>-</return>
*/
function aztecsize(
  p_text            varchar2,
  p_sec             number
  ) return number;

/**
  <h2>azteccode</h2>
  <type>Procedure</type>
  <desc>
    Create "Aztec Code" barcodes. All the letters, numbers and special characters are available. Algorithm automatically selects the size of the barcode
    depending on its characters.
  </desc>
  <version>v3.5.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_text varchar2</param-def>
      <param-desc>the text to convert into barcode</param-desc>
    </param>
    <param>
      <param-def>p_sec number</param-def>
      <param-desc>The error correction level. 2-90</param-desc>
    </param>
    <param>
      <param-def>p_scale number</param-def>
      <param-desc>The scale to enlarge the barcode, greater than 1</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure azteccode(
  p_x               number,
  p_y               number,
  p_text            varchar2,
  p_sec             number,
  p_scale           number default 1
  );

end plpdf_barcode;
/

