create or replace package plpdf_annot
authid current_user is
--v5.9
--
type t_annot is record (
     annot_type plpdf_type.v2avg,
     x number,
     y number,
     w number,
     h number,
     name plpdf_type.v2avg,
     label plpdf_type.v2avg,
     contents plpdf_type.v2long,
     color plpdf_type.t_color,
     filename plpdf_type.v2long,
     fileblob blob,
     popup_x number,
     popup_y number,
     popup_w number,
     popup_h number,
     open boolean,
     url plpdf_type.v2long,
     mime plpdf_type.v2avg,
     --tech
     aa plpdf_type.v2avg,
     objnum plpdf_type.t_objnum,
     popup_objnum plpdf_type.t_objnum,
     file_objnum plpdf_type.t_objnum,
     embeddedfile_objnum plpdf_type.t_objnum,
     a_objnum plpdf_type.t_objnum, --action
     aa_objnum plpdf_type.t_objnum --additional action
     );

type t_annots is table of t_annot index by pls_integer;
v_annots t_annots;

type t_pageannots is table of plpdf_type.t_integers index by pls_integer;
v_PageAnnots t_pageannots;

/**
 <name>AddFileAnnot</name>
 <type>Procedure</type>
 <desc>
 Add File annotation to the current page
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2 default 'PushPin'</param-def>
   <param-desc>The name of an icon to be used in displaying the annotation.</param-desc>
   <param-ul>
    <param-li>PushPin</param-li>
    <param-li>Graph</param-li>
    <param-li>Paperclip</param-li>
    <param-li>Tag</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_filename varchar2</param-def>
   <param-desc>name of file</param-desc>
  </param>
  <param>
   <param-def>p_fileblob blob</param-def>
   <param-desc>file</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddFileAnnot(
  p_name varchar2 default 'PushPin', -- has defined types</param-def><param-desc>PushPin Graph Paperclip Tag
  p_contents varchar2,
  p_x number,
  p_y number,
  p_filename varchar2,
  p_fileblob blob,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null
  );

/**
 <name>AddHighLightAnnot</name>
 <type>Procedure</type>
 <desc>
  Add HighLight annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc> This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddHighLightAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddTextAnnot</name>
 <type>Procedure</type>
 <desc>
  Add Text annotation to the current page
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2 default 'Note'</param-def>
   <param-desc>The name of an icon to be used in displaying the annotation.</param-desc>
   <param-ul>
    <param-li>Comment</param-li>
    <param-li>Key</param-li>
    <param-li>Note</param-li>
    <param-li>Help</param-li>
    <param-li>NewParagraph</param-li>
    <param-li>Paragraph</param-li>
    <param-li>Insert</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTextAnnot(
  p_name varchar2 default 'Note',
  p_contents varchar2,
  p_x number,
  p_y number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddStrikeOutAnnot</name>
 <type>Procedure</type>
 <desc>
  Add StrikeOut annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddStrikeOutAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddUnderlineAnnot</name>
 <type>Procedure</type>
 <desc>
  Add Underline annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddUnderlineAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddScreenAnnotURL</name>
 <type>Procedure</type>
 <desc>
  A screen annotation specifies a region of a page upon which media clips may be played.
  Source of the media is an URL.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the media clip.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_url varchar2</param-def>
   <param-desc>URL of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_mime varchar2</param-def>
   <param-desc>MIME type of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_event varchar2 default null</param-def>
   <param-desc>Additional action when play annotation</param-desc>
   <param-ul>
    <param-li>null: play clip when click/activate annotation only</param-li>
    <param-li>PV: An action to be performed when the page containing the annotation becomes visible in the viewer application?s user interface. </param-li>
    <param-li>PO: An action to be performed when the page containing the annotation is opened.</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddScreenAnnotURL(
  p_name varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_url varchar2,
  p_mime varchar2,
  p_event varchar2 default null
  );

/**
 <name>AddScreenAnnotFile</name>
 <type>Procedure</type>
 <desc>
  A screen annotation specifies a region of a page upon which media clips may be played.
  Source of the media is an BLOB.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the media clip.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_fileblob blob</param-def>
   <param-desc>File of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_mime varchar2</param-def>
   <param-desc>MIME type of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_event varchar2 default null</param-def>
   <param-desc>Additional action when play annotation</param-desc>
   <param-ul>
    <param-li>null: play clip when click/activate annotation only</param-li>
    <param-li>PV: An action to be performed when the page containing the annotation becomes visible in the viewer application?s user interface. </param-li>
    <param-li>PO: An action to be performed when the page containing the annotation is opened.</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddScreenAnnotFile(
  p_name varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_fileblob blob,
  p_mime varchar2,
  p_event varchar2 default null
  );

--internal
procedure init;

procedure addAnnot(
  p_page pls_integer,
  p_annot t_annot
  );

end plpdf_annot;
/

