create or replace package plpdf_acroform
authid current_user is

/**
 <config>
  <pck-name>PL/PDF Acroform</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v5.9</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/
type t_field_flags is record (
  read_only boolean,
  required boolean,
  noexport boolean,
  multiline boolean,
  password boolean,
  NoToggleToOff boolean,
  radiobutton boolean,
  pushbutton boolean,
  combo boolean,
  edit boolean,
  sort boolean
  );

type t_annot_flags is record (
  invisible boolean, --1
  hidden boolean, --2
  print boolean, -- 3
  nozoom boolean, --4
  norotate boolean, --5
  noview boolean, --6
  read_only boolean, --7
  locked boolean, --8
  togglenoview boolean --9
  );

type t_radiobutton_obj is record (
  value plpdf_type.v2avg,
  label plpdf_type.v2avg,
  x number,
  y number,
  objnum plpdf_type.t_objnum,
  off_objnum plpdf_type.t_objnum,
  on_objnum plpdf_type.t_objnum
  );
--
type t_radiobutton_obj_array is table of t_radiobutton_obj index by pls_integer;

type t_acroform_field is record (
    type plpdf_type.v2avg,
    subtype plpdf_type.v2avg,
    name plpdf_type.v2avg,
    value plpdf_type.v2long,
    default_value plpdf_type.v2long,
    field_flag pls_integer,
    field_flags t_field_flags,
    annot_flag pls_integer,
    annot_flags t_annot_flags,
    PageNum pls_integer,
    x number,
    y number,
    width number,
    height number,
    maxlength pls_integer, --text
    label plpdf_type.v2avg, --Pushbutton
    opt_type pls_integer, --1 or 2
    opt_array plpdf_type.t_opt_array, --ChoiceField
    opt_array2 plpdf_type.t_opt_array2, --ChoiceField
    radiobutton_array t_radiobutton_obj_array, --radiobutton
    action plpdf_type.v2avg, --button
    url plpdf_type.v2max, --button
    javascript plpdf_type.v2max, --button
    fill_color plpdf_type.t_color, --BG
    border_width number,
    border_color plpdf_type.t_color,
    border_style plpdf_type.v2one,
    font_family plpdf_type.v2avg,
    font_size number,
    font_size_auto boolean, --=0
    font_style plpdf_type.v2avg,
    text_color plpdf_type.t_color,
    hint plpdf_type.v2avg,
    rotate pls_integer, --0,90,180,270
    sign_value_objnum plpdf_type.t_objnum, --signature value
    --tech
    objnum plpdf_type.t_objnum,
    ap_n_objnum plpdf_type.t_objnum, -- /AP /N
    cb_off_objnum plpdf_type.t_objnum,
    cb_yes_objnum plpdf_type.t_objnum,
    page_objnum plpdf_type.t_objnum,
    rb_off_objnum plpdf_type.t_objnum,
    rb_on_objnum plpdf_type.t_objnum,
    font_index pls_integer,
    submitform_flag number, --button
    quadding pls_integer --text
    );

type t_acroform_fields is table of t_acroform_field index by pls_integer;
v_acroform_fields t_acroform_fields;

type t_pagefields is table of plpdf_type.t_integers index by pls_integer;
v_PageFields t_pagefields;
--
--v3.0.0
procedure init;
------------------------------------------------------------------------------
/**
 <name>addCheckBoxField</name>
 <type>Procedure</type>
 <desc>
  Add CheckBoxField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_pagenum pls_integer default null</param-def>
   <param-desc>Number of the page</param-desc>
  </param>
  <param>
   <param-def>p_checked boolean default false</param-def>
   <param-desc>If set, the checkbox is checked</param-desc>
  </param>
  <param>
   <param-def>p_default_checked boolean default false</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_locked boolean default false</param-def>
   <param-desc>If set, the field will be locked</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_hidden boolean default false</param-def>
   <param-desc>If set, the field will be hidden</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>Color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default null</param-def>
   <param-desc>Width of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>Color of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_style varchar2 default plpdf_const.solid</param-def>
   <param-desc>Style of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_text_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>Color of the text</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addCheckBoxField(
  p_name varchar2,
  p_pagenum pls_integer default null, --current page
  p_checked boolean default false,
  p_default_checked boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_read_only boolean default false,
  p_required boolean default false,
  p_locked boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_hidden boolean default false,
  p_hint varchar2 default null,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default null,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  p_text_color plpdf_type.t_color default plpdf_const.Black
  );

/**
 <name>AddChoiceField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add ChoiceField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_values plpdf_type.t_opt_array</param-def>
   <param-desc>value set of field</param-desc>
  </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_combo boolean default false</param-def>
   <param-desc>If set, the field is a combo box; if clear, the field is a list box</param-desc>
  </param>
  <param>
   <param-def>p_edit boolean default false</param-def>
   <param-desc>If set, the combo box includes an editable text box as well as a drop list</param-desc>
  </param>
  <param>
   <param-def>p_short boolean default false</param-def>
   <param-desc>If set, the field's option items should be sorted alphabetically</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_border_style varchar2 default plpdf_const.solid</param-def>
   <param-desc>The border style:S (Solid), D (Dashed), B (Beveled), I (Inset), U (Underline)</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
  <param>
   <param-def>p_rotate number default 0</param-def>
   <param-desc>The number of degrees by which the widget annotation is rotated counterclockwise relative to the page. The value must be a multiple of 90.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddChoiceField(
  p_name varchar2,
  p_values plpdf_type.t_opt_array,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_combo boolean default false,
  p_edit boolean default false,
  p_sort boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid,
  p_font_size_auto boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0
  );

--v4.9.6
procedure addChoiceField2(
  p_name varchar2,
  p_values plpdf_type.t_opt_array2,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_combo boolean default false,
  p_edit boolean default false,
  p_sort boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid,
  p_font_size_auto boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0
  );

/**
 <name>AddPushbutton</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add Push button
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>Caption of button</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_action varchar2 default null</param-def>
   <param-desc>supported actions</param-desc>
   <param-ul>
    <param-li>plpdf_const.button_action_submitform: A submit-form action transmits the names and values of selected interactive form
     fields to a specified uniform resource locator (URL), presumably the address of a
     World Wide Web server that will process them and send back a response.</param-li>
    <param-li>plpdf_const.button_action_resetform: A reset-form action resets selected interactive form fields to their default values.</param-li>
    <param-li>plpdf_const.button_action_javascript: A JavaScript action causes a script to be compiled and executed by the JavaScript interpreter.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_url varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitformA URL specification giving the uniform resource
    locator (URL) of the script at the Web server that will process the submission.</param-desc>
  </param>
  <param>
   <param-def>p_submitformat varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform format of submitted data</param-desc>
   <param-ul>
    <param-li>plpdf_const.submit_format_html: HTML Form format</param-li>
    <param-li>plpdf_const.submit_format_fdf: Forms Data Format (FDF)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_request varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform: form of request</param-desc>
   <param-ul>
    <param-li>plpdf_const.submit_request_post: using an HTTP POST request</param-li>
    <param-li>plpdf_const.submit_request_get: using an HTTP GET request</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_IncludeNoValueFields boolean default false</param-def>
   <param-desc>If clear, fields without a value are not submitted.</param-desc>
  </param>
  <param>
   <param-def>p_SubmitCoordinates boolean default false</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform: If set, the coordinates of the mouse click
    that caused the submit-form action are transmitted as part of the form data.</param-desc>
  </param>
  <param>
   <param-def>p_javascript varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_javascript: A string containing the JavaScript script to be executed.</param-desc>
  </param>
  <param>
  <param-def>p_print boolean default false</param-def>
  <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
  <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
  <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_border_style varchar2 default plpdf_const.solid</param-def>
   <param-desc>The border style:S (Solid), D (Dashed), B (Beveled), I (Inset), U (Underline)</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
  <param>
   <param-def>p_rotate number default 0</param-def>
   <param-desc>The number of degrees by which the widget annotation is rotated counterclockwise relative to the page. The value must be a multiple of 90.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddPushbutton(
  p_name varchar2,
  p_label varchar2 default null,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_action varchar2 default null,
  p_url varchar2 default null,
  p_submitformat varchar2 default null,
  p_request varchar2 default null,
  p_IncludeNoValueFields boolean default false,
  p_SubmitCoordinates boolean default false,
  p_javascript varchar2 default null,
  p_print boolean default false,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  p_font_size_auto boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0
  );

/**
 <name>AddRadiobuttonField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add RadiobuttonField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_values plpdf_type.t_radiobutton_array</param-def>
   <param-desc>value set of field</param-desc>
  </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_NoToggleToOff  boolean default false</param-def>
   <param-desc>If set, exactly one radio button must be selected at all times</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_gap number default 0</param-def>
   <param-desc>gap bettween graphical symbol and text</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddRadiobuttonField(
  p_name varchar2,
  p_values plpdf_type.t_radiobutton_array,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_read_only boolean default false,
  p_required boolean default false,
  p_NoToggleToOff  boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_height number,
  p_gap number default 0,
  p_fill_color plpdf_type.t_color default plpdf_const.Black,
  p_hint varchar2 default null
  );

/**
 <name>AddTextField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add TextField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
   </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_maxlength number default 0</param-def>
   <param-desc>The maximum length of the field's text, in characters</param-desc>
  </param>
  <param>
   <param-def>p_multiline boolean default false</param-def>
   <param-desc>If set, the field may contain multiple lines of text</param-desc>
  </param>
  <param>
   <param-def>p_password boolean default false</param-def>
   <param-desc>If set, the field is intended for entering a secure password that should not be echoed visibly to the screen</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
   </param>
   <param>
    <param-def>p_width number</param-def>
    <param-desc>The width of the field</param-desc>
   </param>
   <param>
    <param-def>p_height number</param-def>
    <param-desc>The height of the field</param-desc>
   </param>
   <param>
    <param-def>p_align varchar2 default null</param-def>
    <param-desc>Text alignment</param-desc>
    <param-ul>
     <param-li>L: left (default)</param-li>
     <param-li>R: right</param-li>
     <param-li>C: center</param-li>
    </param-ul>
   </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_border_style varchar2 default plpdf_const.solid</param-def>
   <param-desc>The border style:S (Solid), D (Dashed), B (Beveled), I (Inset), U (Underline)</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
  <param>
   <param-def>p_rotate number default 0</param-def>
   <param-desc>The number of degrees by which the widget annotation is rotated counterclockwise relative to the page. The value must be a multiple of 90.</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure AddTextField(
  p_name varchar2,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_maxlength number default 0,
  p_multiline boolean default false,
  p_password boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_align varchar2 default null,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  p_font_size_auto boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0
  );
--
--------------------------------------------------------------------------------------------------------
function AddSignatureField(
  p_name varchar2,
  p_pagenum pls_integer default null, --current page
  p_x number default 0,
  p_y number default 0,
  p_width number default 0,
  p_height number default 0,
  p_read_only boolean default false,
  p_locked boolean default false,
  p_print boolean default false,
  p_hidden boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0,
  --borders and color
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  --text
  p_font_family varchar2 default null, --current
  p_font_style varchar2 default null, --current
  p_text_color plpdf_type.t_color default plpdf_const.Black
  ) return pls_integer;
--
/**
 <name>AddSignatureField</name>
 <type>Procedure</type>
 <desc>
  Add Signature Field
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_pagenum pls_integer default null</param-def>
   <param-desc>Number of the page</param-desc>
  </param>
  <param>
   <param-def>p_x number default 0</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number default 0</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_locked boolean default false</param-def>
   <param-desc>If set, the field will be locked</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_hidden boolean default false</param-def>
   <param-desc>If set, the field will be hidden</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
  <param>
   <param-def>p_rotate number default 0</param-def>
   <param-desc>The rotation of the field</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>Color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default null</param-def>
   <param-desc>Width of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>Color of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_style varchar2 default plpdf_const.solid</param-def>
   <param-desc>Style of the border of the field</param-desc>
  </param>
  <param>
   <param-def>p_font_family varchar2 default null</param-def>
   <param-desc>Font family of the text</param-desc>
  </param>
  <param>
   <param-def>p_font_style varchar2 default null</param-def>
   <param-desc>Font style of the text</param-desc>
  </param>
  <param>
   <param-def>p_text_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>Color of the text</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddSignatureField(
  p_name varchar2,
  p_pagenum pls_integer default null, --current page
  p_x number default 0,
  p_y number default 0,
  p_width number default 0,
  p_height number default 0,
  p_read_only boolean default false,
  p_locked boolean default false,
  p_print boolean default false,
  p_hidden boolean default false,
  p_hint varchar2 default null,
  p_rotate number default 0,
  --borders and color
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  --text
  p_font_family varchar2 default null, --current
  p_font_style varchar2 default null, --current
  p_text_color plpdf_type.t_color default plpdf_const.Black
  );

--------------------------------------------------------------------------------------------------------
--INTERNAL
function crAPStream(
  p_field plpdf_acroform.t_acroform_field
  ) return varchar2;
--
function getOptValueIndex(
  p_opt_array plpdf_type.t_opt_array,
  p_val varchar2
  ) return pls_integer;
--
function GetRBOffStream(
  p_height number,
  p_border_color plpdf_type.t_color default null,
  p_fill_color plpdf_type.t_color default null
  ) return varchar2;
--
function GetRBOnStream(
  p_height number,
  p_border_color plpdf_type.t_color default null,
  p_fill_color plpdf_type.t_color default null
  ) return varchar2;
--
function GetCBOffStream(
  p_width number,
  p_height number,
  p_border_width number,
  p_border_color plpdf_type.t_color default null,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  p_fill_color plpdf_type.t_color default null
  ) return varchar2;
--
function GetCBYesStream(
  p_width number,
  p_height number,
  p_border_width number,
  p_border_color plpdf_type.t_color default null,
  p_border_style varchar2 default plpdf_const.solid, --'S'
  p_fill_color plpdf_type.t_color default null,
  p_text_color plpdf_type.t_color default null
  ) return varchar2;
--
function crFieldFlag( --Ff
  p_read_only boolean default false, -- 1
  p_required boolean default false, -- 2
  p_noexport boolean default false, -- 3
  p_multiline boolean default false, -- 13
  p_password boolean default false, -- 14
  p_NoToggleToOff boolean default false, -- 15
  p_radiobutton boolean default false, -- 16
  p_pushbutton boolean default false, -- 17
  p_combo boolean default false, -- 18
  p_edit boolean default false, -- 19
  p_sort boolean default false -- 20
  ) return pls_integer;
--
function crAnnotFlag( --F
  p_invisible boolean default false, --1
  p_hidden boolean default false, --2
  p_print boolean default false, -- 3
  p_nozoom boolean default false, --4
  p_norotate boolean default false, --5
  p_noview boolean default false, --6
  p_read_only boolean default false, --7
  p_locked boolean default false, --8
  p_togglenoview boolean default false --9
  ) return pls_integer;
--
end plpdf_acroform;
/

