create or replace package plpdf3
authid current_user is
--
--v5.9
--
--w3c css box model, see http://www.w3schools.com/css/css_boxmodel.asp
--size of box margin
type t_Margin is record (
  top number,
  left number,
  bottom number,
  right number
  );
--
--border/line styles
subtype t_border_style is plpdf_type.v2avg;
c_none         constant t_border_style :='none';
c_single       constant t_border_style :='single';
c_double       constant t_border_style :='double';
c_dotted       constant t_border_style :='dotted';
c_dashed       constant t_border_style :='dashed';
c_dotDash      constant t_border_style :='dotDash';
c_dotDotDash   constant t_border_style :='dotDotDash';
c_triple       constant t_border_style :='triple';
c_dashSmallGap constant t_border_style :='dashSmallGap';
--... TODO
--
--border of one side
type t_Border1 is record (
  color plpdf_type.t_color, --color of the line
  width number, --Border Width
  style t_border_style --ST_Border single/dotted
  );
--
--border values
type t_Border is record (
  top t_Border1,
  left t_Border1,
  bottom t_Border1,
  right t_Border1
  );
--
--padding widths
type t_Padding is record (
  top number,
  left number,
  bottom number,
  right number
  );
--
--t_hAlign
subtype t_hAlign is plpdf_type.v2avg;
c_left constant t_hAlign := 'left';
c_center constant t_hAlign := 'center';
c_right constant t_hAlign := 'right';
--
--t_vAlign
subtype t_vAlign is plpdf_type.v2avg;
c_top constant t_vAlign := 'top';
-- c_center constant t_vAlign := 'center'; --duplicated constant
c_bottom constant t_vAlign := 'bottom';
--
--box of content
type t_box is record (
  margin t_Margin, -- margins:left/right/top/bottom colored frame
  border t_Border, -- border:left/right/top/bottom colored frame
  padding t_Padding, --padding:left/right/top/bottom Clears an area around the content.
  background_color plpdf_type.t_color, --content color
  internallink_id pls_integer --v4.1.0
  );
--
--underline styles
subtype t_underline is plpdf_type.v2avg;
--c_single constant t_underline := 'single'; --only one declaration
--c_words constant t_underline := 'words';
--c_double constant t_underline := 'double'; --only one declaration
c_thick constant t_underline := 'thick';
--c_dotted constant t_underline := 'dotted'; --only one declaration
c_dottedHeavy constant t_underline := 'dottedHeavy';
c_dash constant t_underline := 'dash';
c_dashedHeavy constant t_underline := 'dashedHeavy';
c_dashLong constant t_underline := 'dashLong';
c_dashLongHeavy constant t_underline := 'dashLongHeavy';
--c_dotDash constant t_underline := 'dotDash'; --only one declaration
c_dashDotHeavy constant t_underline := 'dashDotHeavy';
--c_dotDotDash constant t_underline := 'dotDotDash'; --only one declaration
c_dashDotDotHeavy constant t_underline := 'dashDotDotHeavy';
--c_wave constant t_underline := 'wave';
--c_wavyHeavy constant t_underline := 'wavyHeavy';
--c_wavyDouble constant t_underline := 'wavyDouble';
--c_none constant t_underline := 'none'; --only one declaration
--
--used font seting for a text
type t_font is record (
  fontname plpdf_type.v2avg, --font family
  sz number, --Font Size
  b boolean, --Bold
  i boolean, --Italics
  u t_underline --Underline none=false
  );
--
subtype t_VerticalAlignRun is plpdf_type.v2avg;
c_baseline constant t_VerticalAlignRun := 'baseline';
c_subscript constant t_VerticalAlignRun := 'subscript';
c_superscript constant t_VerticalAlignRun := 'superscript';
--
subtype t_caps is plpdf_type.v2avg;
--c_none constant t_caps := 'none';
c_smallcaps constant t_caps := 'smallcaps';
c_allcaps constant t_caps := 'allcaps';
--
--run properties
type t_RunProps is record (
  box t_box,
  caps t_caps, --none/'small'/'all'
  fitText number, --Manual Run Width
  font t_font,
  link plpdf_type.v2max, --hyperlink or internal link
  rtl boolean, --run shall be right to left
  text_color plpdf_type.t_color, --color Text Highlighting
  textScalePct number, --%, Expanded/Compressed Text
  vertAlign t_VerticalAlignRun,
  Vposition number, --Vertically Raised or Lowered Text
  --spacing --Character Spacing Adjustment TODO
  minw number, --custom: minimum width of the run
  height number, --custom: exact height v4.4.0
  islvlText boolean, --is List level text?
  styleId plpdf_type.v2avg
  );
--
--image in paragraph
type t_InlineImage is record (
  name plpdf_type.v2avg,
  data blob,
  width number,
  height number,
  resize number,
  --tech
  pdfimage plpdf_type.t_pdfimage
  );
--
--types of supported barcodes
subtype t_barcode_type is plpdf_type.v2avg;
c_code39 constant t_barcode_type :='CODE39';
c_code128 constant t_barcode_type :='CODE128';
c_qrcode constant t_barcode_type :='QRCODE';
--
--barcode in paragraph
type t_InlineBarcode is record (
  type plpdf_type.v2avg, --code39,...
  data plpdf_type.v2long, --text
  gap number,
  font t_font,
  width number,
  height number
  );
--
--v4.9.2
type t_InlineChart is record (
  width number,
  height number
  );
--
--v5.0
--types of supported form fields
subtype t_formfield_type is plpdf_type.v2avg;
c_textfield constant t_formfield_type :='TEXTFIELD';

--v5.0
type t_InlineFormField is record (
  type plpdf_type.v2avg, --textfield
  name plpdf_type.v2avg,
  value  plpdf_type.v2avg,
  width number,
  height number
  );
--
--types of parts in a paragraph
subtype t_run_type is plpdf_type.v2avg;
c_text constant t_run_type :='text';
c_image constant t_run_type :='image';
c_br constant t_run_type :='br'; --break, newline
c_barcode constant t_run_type := 'barcode';
c_expression constant t_run_type := 'expression';
c_chart constant t_run_type := 'chart';
c_tab constant t_run_type := 'tab';
c_formfield constant t_run_type := 'formfield'; --v5.0
--
--text/image run: part of paragraph
type t_Run is record (
  props t_RunProps,
  run_type t_run_type, --br, image, text,barcode,expression,chart,tab,formfield
  image t_InlineImage, --image
  text plpdf_type.v2max, --text
  barcode t_InlineBarcode,
  expression plpdf_type.v2max,
  chart t_InlineChart,
  formfield t_InlineFormField --v5.0
  );
--
type t_Indentation is record ( --CT_Ind
  left number,
  right number,
  hanging number,
  firstLine number
  );
--
subtype t_TextAlignment is plpdf_type.v2avg;
-- c_top constant t_TextAlignment := 'top'; --duplicated constant
-- c_center constant t_TextAlignment := 'center'; --duplicated constant
-- c_baseline constant t_TextAlignment := 'baseline';
-- c_bottom constant t_TextAlignment := 'bottom'; --duplicated constant
--auto
--
subtype t_ParagraphAlignment is plpdf_type.v2avg;
-- c_left constant t_ParagraphAlignment := 'left'; --duplicated constant
-- c_center constant t_ParagraphAlignment := 'center'; --duplicated constant
-- c_right constant t_ParagraphAlignment := 'right'; --duplicated constant
c_justified constant t_ParagraphAlignment := 'justified'; --both
c_justify constant t_ParagraphAlignment := 'justify'; --v4.8.3 --CSS support
--
subtype t_Jc is plpdf_type.v2avg;
-- c_left constant t_Jc := 'left'; --duplicate
-- c_center constant t_Jc := 'center'; --duplicate
-- c_right constant t_Jc := 'right'; --duplicate
--
--v4.9.1
subtype t_LineSpacingRule is plpdf_type.v2avg;
c_atLeast constant t_LineSpacingRule := 'atLeast';
c_auto constant t_LineSpacingRule := 'auto';
c_exact constant t_LineSpacingRule := 'exact';
--
type t_ParagraphProps_list is record (
  bidi boolean, --shall be presented using a right to left
  box t_box,
  ind t_Indentation, --Paragraph Indentation
  alignment t_ParagraphAlignment, --Paragraph Alignment, ST_Jc
  keepLines boolean, --Keep All Lines On One Page
  --list t_List, --list item reference
  LineSpacing number,
  BeforeSpacing number,
  AfterSpacing number,
  pageBreakBefore boolean, --paragraph are rendered on the start of a new page
  textVAlign t_TextAlignment, --Vertical Character Alignment on Line: ST_TextAlignment (auto, baseline, bottom, center, top)
  widowControl boolean, --Allow First/Last Line to Display on a Separate Page
  LineRule t_LineSpacingRule
  );
--
--list instance
type t_List is record (
  lvlJc t_Jc, --level Justification: level text position
  lvlText plpdf_type.v2avg, --1-2... chars
  --ind t_Indentation, --Paragraph Indentation overwrite
  pPr t_ParagraphProps_list,
  rPr t_RunProps --symbol props: font, color,...
  );
--
type t_ParagraphProps is record (
  bidi boolean, --shall be presented using a right to left
  box t_box,
  ind t_Indentation, --Paragraph Indentation
  alignment t_ParagraphAlignment, --Paragraph Alignment, ST_Jc
  keepLines boolean, --Keep All Lines On One Page
  list t_List, --list instance reference
  LineSpacing number,
  BeforeSpacing number,
  AfterSpacing number,
  pageBreakBefore boolean, --paragraph are rendered on the start of a new page
  textVAlign t_TextAlignment, --Vertical Character Alignment on Line: ST_TextAlignment (auto, baseline, bottom, center, top)
  widowControl boolean, --Allow First/Last Line to Display on a Separate Page
  maxline pls_integer,
  styleId plpdf_type.v2avg,
  LineRule t_LineSpacingRule,
  linerule_auto_multi number
  );
--
type t_pcontents is table of t_Run;
v_pcontents_empty t_pcontents := t_pcontents();
--
type t_Paragraph is record (
  props t_ParagraphProps,
  pcontent t_pcontents
  );
--
subtype t_textdirection is plpdf_type.v2avg;
c_btLr constant t_textdirection :='btLr'; --Bottom to Top, Left to Right
c_lrTb constant t_textdirection :='lrTb'; --Left to Right, Top to Bottom
--
--table cell prooperties
type t_TableCellProps is record (
  box t_box,
  width number,
  gridSpan pls_integer,
  noWrap boolean,
  fittext boolean, --Fit Text Within Cell
  VAlign t_vAlign, -- ST_VerticalJc
  textDirection t_textdirection
  );
--
type t_blocks is table of t_Paragraph;
v_blocks_empty t_blocks := t_blocks();
--
type t_TableCell is record (
  props t_TableCellProps,
  blocks t_blocks --block indexes
  );
--
type t_cells is table of t_TableCell;
v_cells_empty t_cells := t_cells();
--
--v3.2.0
subtype t_row_print is plpdf_type.v2avg;
c_all constant t_row_print := 'all';
c_first constant t_row_print :='first';
c_last constant t_row_print :='last';
c_each constant t_row_print :='each';
--
type t_TableRowProps is record (
  box t_box,
  cantSplit boolean, --Table Row Cannot Break Across Pages
  min_height number, --prefered minimum height
  --?? exact height handling
  hf_print t_row_print --header/footer print: header:first/all, footer: all/last
  );
--
type t_TableRow is record (
  props t_TableRowProps,
  cells t_cells
  );
--
type t_rows is table of t_TableRow;
v_rows_empty t_rows := t_rows();
--
type t_TableGrid is table of number; --widths
v_TableGrid_empty t_TableGrid := t_TableGrid();
--
--ST_TblLayoutType
subtype t_tablelayout is plpdf_type.v2avg;
c_fixed constant t_tablelayout :='fixed';
c_autofit constant t_tablelayout :='autofit';
--
--table properties
type t_TableProps is record (
  bidiVisual boolean,
  box t_box,
  width number,
  alignment t_hAlign, --Table Alignment, ST_Jc
  -- tblLayout t_tablelayout --ST_TblLayoutType not supported yet TODO
  styleId plpdf_type.v2avg,
  cell_box t_box
  );
--
subtype t_NumberFormat is plpdf_type.v2avg;
c_decimal constant t_NumberFormat := 'decimal'; --decimal: 1,2,3,...
c_upperRoman constant t_NumberFormat := 'upperRoman'; --I,II,III,IV,V,...
c_lowerRoman constant t_NumberFormat := 'lowerRoman'; --i,ii,iii,iv,v,..
c_upperLetter constant t_NumberFormat := 'upperLetter'; --uppercase: A,B,C,...Z,AA,BB,CC,...,ZZ,AAA,...
c_lowerLetter constant t_NumberFormat := 'lowerLetter'; --lowercase: a,b,c,...z,aa,bb,cc,...,zz,aaa,...
-- ordinal
-- cardinalText
-- ordinalText
-- hex
-- chicago
-- ideographDigital
-- japaneseCounting
-- aiueo
-- iroha
-- decimalFullWidth
-- decimalHalfWidth
-- japaneseLegal
-- japaneseDigitalTenThousand
-- decimalEnclosedCircle
-- decimalFullWidth2
-- aiueoFullWidth
-- irohaFullWidth
-- decimalZero
c_bullet constant t_NumberFormat := 'bullet'; --bullet
-- ganada
-- chosung
-- decimalEnclosedFullstop
-- decimalEnclosedParen
-- decimalEnclosedCircleChinese
-- ideographEnclosedCircle
-- ideographTraditional
-- ideographZodiac
-- ideographZodiacTraditional
-- taiwaneseCounting
-- ideographLegalTraditional
-- taiwaneseCountingThousand
-- taiwaneseDigital
-- chineseCounting
-- chineseLegalSimplified
-- chineseCountingThousand
-- koreanDigital
-- koreanCounting
-- koreanLegal
-- koreanDigital2
-- vietnameseCounting
-- russianLower
-- russianUpper
-- none
-- numberInDash
-- hebrew1
-- hebrew2
-- arabicAlpha
-- arabicAbjad
-- hindiVowels
-- hindiConsonants
-- hindiNumbers
-- hindiCounting
-- thaiLetters
-- thaiNumbers
-- thaiCounting
-- bahtText
-- dollarText
-- custom
--
--list
type t_ListLevel is record (
  numFmt t_NumberFormat,
  ilvl pls_integer, --level: 0,1,....9
  lvlJc t_Jc, --level Justification
  lvlText plpdf_type.v2avg, --1-2... chars
  pPr t_ParagraphProps_list, --paragraph props: indent,...
  rPr t_RunProps, --symbol props: font, color,...
  start_ pls_integer
  );
--
type t_ListLevels is table of t_ListLevel index by pls_integer; --iLvl
--
type t_ListAbstractNum is record (
  abstractNumId pls_integer,
  levels t_ListLevels
  );
--
type t_absnums is table of t_ListAbstractNum index by pls_integer;
--
type t_numdef is record (
  numId pls_integer,
  abstractNumId pls_integer
  );
--
type t_numberingDefinition is table of t_numdef index by pls_integer;
--
type t_numbering is record (
  absnums t_absnums,
  numberingDefinition t_numberingDefinition
  );
--
--v4.7.0
type t_style is record (
  styleId plpdf_type.v2avg,
  default_ boolean, --v4.9.1
  type plpdf_type.v2avg, --paragraph, character, table, numbering
  pPr t_ParagraphProps, --paragraph
  rPr t_RunProps, --character
  tblPr t_TableProps, --table
  basedOn plpdf_type.v2avg --Parent Style ID
  --numbering ? TODO
  );
--
type t_styles is table of t_style index by pls_integer;
--
type t_dims is record (
  content_width number, --calculated
  content_height number, --calculated
  full_width number, --calculated
  full_height number --calculated
  );
--
--part of line one or part of one run
type t_pp_line_part is record (
  props t_RunProps, --run props
  run_type plpdf_type.v2avg, -- image, text,barcode
  image t_InlineImage, --image
  text plpdf_type.v2max, --text
  barcode t_InlineBarcode,
  chart t_InlineChart,
  formfield t_InlineFormField, --formfield
  baseline number, --calculated
  text_width number, --if text JUSTIFIED then cwidth <> text width
  y_adjust number, --calculated
  calc_dims t_dims --calculated
  );
--
type t_pp_parts is table of t_pp_line_part;
--
type t_pp_line is record (
  linenum pls_integer,
  parts t_pp_parts,
  calc_dims t_dims,
  baseline number, --calculated common Y added pos in line
  x_adjust number
  );
--
type t_pp_lines is table of  t_pp_line;
v_pp_lines_empty t_pp_lines := t_pp_lines();
--
type t_calc_list_item is record (
  lvlText_width number
  );
--
--parsed paragraph
type t_parsed_paragraph is record (
  props t_ParagraphProps,
  lines t_pp_lines, --lines of paragraph
  calc_dims t_dims, --calculated
  reparse boolean
  );
--
type t_parsed_blocks is table of t_parsed_paragraph;
v_parsed_blocks_empty t_parsed_blocks := t_parsed_blocks();
--
type t_parsed_cell is record (
  props t_TableCellProps, --calculate and fill all missing property
  blocks t_parsed_blocks, --parsed paragraphs
  calc_dims t_dims, --calculated
  reparse boolean, --v4.7.0
  max_text_line_num pls_integer
  );
--
type t_parsed_cells is table of t_parsed_cell;
v_parsed_cell_empty t_parsed_cells := t_parsed_cells();
--
type t_parsed_row is record (
  props t_TableRowProps,
  cells t_parsed_cells,
  calc_dims t_dims, --calculated
  rownum pls_integer,
  is_first boolean,
  is_last boolean,
  reparse boolean,
  max_text_line_num pls_integer
  );
--
type t_parsed_rows is table of t_parsed_row;
v_parsed_rows_empty t_parsed_rows := t_parsed_rows();
--
--v4.9.5
type t_parsed_master_table is record (
  props t_TableProps,
  grid t_TableGrid, --column widths, original
  header_rows t_parsed_rows,
  body_rows t_parsed_rows, --possible NULL
  footer_rows t_parsed_rows,
  --
  orig_header_rows t_rows,
  orig_footer_rows t_rows,
  --
  header_all_height number, --calculated
  header_first_height number, --calculated
  header_each_height number, --calculated
  footer_all_height number, --calculated
  footer_last_height number, --calculated
  movex number, --
  row_box t_box,
  header_rows_reparse boolean,
  footer_rows_reparse boolean
  );
--
type t_Table is record (
  props t_TableProps,
  grid t_TableGrid, --column widths
  header_rows t_rows,
  body_rows t_rows,
  footer_rows t_rows,
  master_table t_parsed_master_table
  );
--
type t_parsed_table is record (
  props t_TableProps,
  grid t_TableGrid, --column widths, original
  header_rows t_parsed_rows,
  body_rows t_parsed_rows, --possible NULL
  footer_rows t_parsed_rows,
  --
  orig_header_rows t_rows,
  orig_footer_rows t_rows,
  --
  header_all_height number, --calculated
  header_first_height number, --calculated
  header_each_height number, --calculated
  footer_all_height number, --calculated
  footer_last_height number, --calculated
  movex number, --
  row_box t_box,
  header_rows_reparse boolean,
  footer_rows_reparse boolean,
  master_table t_parsed_master_table
  );
---------------------------------------------------------------------------------------------------
--v3.6.0
function getDefaultFontName
  return varchar2;
--
--v3.6.0
procedure setDefaultFontName(
  p_font_name varchar2
  );
--v3.6.0
function getDefaultFontStyle
  return varchar2;
--
--v3.6.0
procedure setDefaultFontStyle(
  p_font_style varchar2
  );
--
--v3.6.0
function getDefaultFontSize
  return number;
--
--v3.6.0
procedure setDefaultFontSize(
  p_font_size number
  );

--v3.6.0
procedure setDefaultPrintFont;

--v4.2.0
procedure setDefaultRunProps(
  p_props t_RunProps
  );

--v4.2.0
procedure setDefaultRunProps(
  p_fontname varchar2 default null,
  p_sz number default null,
  p_b boolean default null,
  p_i boolean default null,
  p_u varchar2  default null
  );

--v4.2.0
function getDefaultRunProps
  return t_RunProps;

--v4.2.0
procedure setDefaultParagraphProps(
  p_props t_ParagraphProps
  );

--v4.2.0
procedure setDefaultParagraphProps_m(
  p_bidi boolean default null,
  p_margin_top number default null,
  p_margin_bottom number default null,
  p_margin_left number default null,
  p_margin_right number  default null
  );

--v4.9.1
procedure setDefaultParagraphProps(
  p_bidi boolean default null,
  p_box t_box default null,
  p_ind t_Indentation default null,
  p_alignment t_ParagraphAlignment default null,
  p_keepLines boolean default null,
  p_spacing number default null, --line
  p_before_spacing number default null, --v5.0
  p_after_spacing number default null, --v5.0
  p_pageBreakBefore boolean default null,
  p_textVAlign t_TextAlignment default null,
  p_widowControl boolean default null,
  p_maxline pls_integer default null,
  p_linerule varchar2 default null,
  p_linerule_auto_multi number default null
  );

--v4.2.0
function getDefaultParagraphProps
  return t_ParagraphProps;

--v4.9.6
function getDefaultTabStop
  return number;

--v4.9.6
procedure setDefaultTabStop(
  p_tabstop number
  );

--v4.9.7
function getListTypePcs
  return number;
--v4.9.7
procedure setListTypePcs(
  p_pcs number
  );

--box

--create margin
function crMargin(
  p_top number default null,
  p_left number default null,
  p_bottom number default null,
  p_right number default null
  ) return t_Margin;

--create Border1
function crBorder1(
  p_color plpdf_type.t_color default null, --color of the line
  p_width number default null, --Border Width
  p_style t_border_style default null
  ) return t_Border1;

--create Border
function crBorder(
  p_top t_Border1 default null,
  p_left t_Border1 default null,
  p_bottom t_Border1 default null,
  p_right t_Border1 default null
  ) return t_Border;

--create padding
function crPadding(
  p_top number default null,
  p_left number default null,
  p_bottom number default null,
  p_right number default null
  ) return t_Padding;

--create box
function crBox(
  p_margin t_Margin default null, -- margins:left/right/top/bottom colored frame
  p_border t_Border default null, -- border:left/right/top/bottom colored frame
  p_padding t_Padding default null, --padding:left/right/top/bottom Clears an area around the content.
  p_background_color plpdf_type.t_color default null, --content color
  p_internallink_id pls_integer default null
  ) return t_box;

--create indentation
function crIndentation(
  p_left number default null,
  p_right number default null,
  p_hanging number default null,
  p_firstLine number default null
  ) return t_Indentation;

--create paragraph
function crParagraph(
  p_bidi boolean default null,
  p_box t_box default null, --box properties
  p_ind t_Indentation default null, --Paragraph Indentation
  p_alignment t_ParagraphAlignment default null,
  p_keepLines boolean default null, --Keep All Lines On One Page
  p_spacing number default null, --Spacing Between Lines
  p_before_spacing number default null, --after p
  p_after_spacing number default null, --after p
  p_pageBreakBefore boolean default null,
  p_textVAlign t_TextAlignment default null,
  p_widowControl boolean default null, --Allow First/Last Line to Display on a Separate Page
  p_maxline pls_integer default null,
  p_styleId varchar2 default null,
  p_lineRule varchar2 default null
  ) return t_Paragraph;

function crParagraph(
  p_props t_ParagraphProps
  ) return t_Paragraph;

--v4.8.0
function crXhtmlParagraph(
  p_xhtml varchar2
  ) return t_Paragraph;

--create font
function crFont(
  p_fontname varchar2 default null, --font family
  p_sz number default null, --Font Size
  p_b boolean default null, --Bold
  p_i boolean default null, --Italics
  p_u varchar2 default null
  ) return t_font;


--v4.7.0
function crParagraphProps(
  p_bidi boolean default null,
  p_box t_box default null,
  p_ind t_Indentation default null,
  p_alignment varchar2 default null,
  p_keepLines boolean default null,
  p_list t_List default null,
  p_spacing number default null,
  p_before_spacing number default null,
  p_after_spacing number default null,
  p_pageBreakBefore boolean default null,
  p_textVAlign varchar2 default null,
  p_widowControl boolean default null,
  p_maxline number default null,
  p_styleId varchar2 default null,
  p_lineRule varchar2 default null
  ) return t_ParagraphProps;

--v3.5.0
function crRunProps(
  p_box t_box default null,
  p_caps varchar2 default null, --none/'small'/'all'
  p_fitText number default null, --Manual Run Width
  p_font t_font default null,
  p_link varchar2 default null, --hyperlink or internal link
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null, --color Text Highlighting
  p_textScalePct number default null, --%, Expanded/Compressed Text
  p_vertAlign varchar2 default null,
  p_Vposition number default null,
  p_styleId varchar2 default null
  ) return t_RunProps;

--v3.4.0
function crTextRun(
  p_props t_RunProps,
  p_text varchar2
  ) return t_Run;

function addRun(
  p_paragraph in out t_Paragraph,
  p_run t_run
  ) return pls_integer;

procedure addRun(
  p_paragraph in out t_Paragraph,
  p_run t_run
  );

--add text to paragraph
function addText(
  p_paragraph in out t_Paragraph,
  p_text varchar2,
  --Run properties
  p_box t_box default null,
  p_caps t_caps default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign t_VerticalAlignRun default null,
  p_Vposition number default null,
  p_height number default null,
  p_styleId varchar2 default null
  ) return pls_integer;

--v3.5.0
procedure addText(
  p_paragraph in out t_Paragraph,
  p_text varchar2,
  --Run properties
  p_box t_box default null,
  p_caps t_caps default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign t_VerticalAlignRun default null,
  p_Vposition number default null,
  p_styleId varchar2 default null
  );

--v4.7.0
function addExpression(
  p_paragraph in out t_Paragraph,
  p_expression varchar2,
  p_default_text varchar2 default null,
  --Run properties
  p_box t_box default null,
  p_caps t_caps default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign t_VerticalAlignRun default null,
  p_Vposition number default null,
  p_height number default null,
  p_styleId varchar2 default null
  ) return pls_integer;

--v4.7.0
procedure addExpression(
  p_paragraph in out t_Paragraph,
  p_expression varchar2,
  p_default_text varchar2 default null,
  --Run properties
  p_box t_box default null,
  p_caps t_caps default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign t_VerticalAlignRun default null,
  p_Vposition number default null,
  p_styleId varchar2 default null
  );

--add image to paragraph
function addInlineImage(
  p_paragraph in out t_Paragraph,
  p_name plpdf_type.v2avg default null,
  p_data in out nocopy blob,
  p_width number default null,
  p_height number default null,
  p_resize number default null,
  --Run properties
  p_box t_box default null,
  p_link varchar2 default null,
  p_Vposition number default null
  ) return pls_integer;

--v4.2.0
function addInlineImage2(
  p_paragraph in out t_Paragraph,
  p_name plpdf_type.v2avg default null,
  p_data blob,
  p_width number default null,
  p_height number default null,
  p_resize number default null,
  --Run properties
  p_box t_box default null,
  p_link varchar2 default null,
  p_Vposition number default null
  ) return pls_integer;

--v3.4.0
function addInline1DBarcode(
  p_paragraph in out t_Paragraph,
  p_type plpdf_type.v2avg, --code39,...
  p_data plpdf_type.v2long, --text
  p_gap number default null,
  p_font t_font default null,
  p_width number,
  p_height number,
  --Run properties
  p_box t_box default null,
  p_link varchar2 default null,
  p_Vposition number default null
  ) return pls_integer;

--v3.4.0
function addInlineCode39Barcode(
  p_paragraph in out t_Paragraph,
  p_data plpdf_type.v2long, --text
  p_gap number default null,
  p_font t_font default null,
  p_width number,
  p_height number,
  --Run properties
  p_box t_box default null,
  p_link varchar2 default null,
  p_Vposition number default null
  ) return pls_integer;

--v5.9
function addInlineQRCode(
  p_paragraph in out t_Paragraph,
  p_data plpdf_type.v2long, --text
  --Run properties
  p_box t_box default null,
  p_link varchar2 default null,
  p_Vposition number default null
  ) return pls_integer;

--v4.9.2
function addInlineChart(
  p_paragraph in out t_Paragraph,
  p_width number,
  p_height number
  ) return pls_integer;

--add line break to paragraph
function addLineBreak(
  p_paragraph in out t_Paragraph,
  p_count number default 1
  ) return pls_integer;

--v3.6.0
procedure addLineBreak(
  p_paragraph in out t_Paragraph,
  p_count number default 1
  );

--v4.9.6
function addTabStop(
  p_paragraph in out t_Paragraph
  ) return pls_integer;

--v4.9.6
procedure addTabStop(
  p_paragraph in out t_Paragraph
  );

--v5.0
function addInlineTextField(
  p_paragraph in out t_Paragraph,
  p_name plpdf_type.v2avg default null,
  p_value plpdf_type.v2avg default null,
  p_width number default null,
  p_height number default null
  ) return pls_integer;

--v5.0
procedure addInlineTextField(
  p_paragraph in out t_Paragraph,
  p_name plpdf_type.v2avg default null,
  p_value plpdf_type.v2avg default null,
  p_width number default null,
  p_height number default null
  );

--set List format
procedure setList(
  p_paragraph in out t_Paragraph,
  p_list t_List
  );
--
procedure setList(
  p_paragraph in out t_Paragraph,
  p_justification t_Jc default null, --level Justification: level text position
  p_lvlText varchar2, --1-2... chars
  p_ind_left number default null, --indent
  p_ind_hanging number default null, --indent
  p_font t_font default null, --run props
  p_text_color plpdf_type.t_color default null --run props
  );

--v3.5.0
procedure setNumbering(
  p_paragraph in out t_Paragraph,
  p_numId pls_integer,
  p_level pls_integer
  );

--v3.6.1
function paragraphParser(
  p_p t_Paragraph,
  p_table_part varchar2 default null, --'header','footer','body'
  p_width number default null,
  p_noWrap boolean default null, --false
  p_bidiVisual boolean default null,
  p_table_style_ppr t_ParagraphProps default null,
  p_table_style_rpr t_RunProps default null,
  p_tr_min_height number default null
  ) return t_parsed_paragraph;

--v3.6.0
procedure PrintParsedParagraph1(
  p_pp t_parsed_paragraph,
  p_x number,
  p_y number
  );
---------------------------------------------------------------------------------------------------
procedure printParagraph1(
  p_Paragraph t_Paragraph,
  p_x number, --fix position
  p_y number,
  p_width number --fix width
  );

procedure printParagraph(
  p_Paragraph t_Paragraph,
  p_width number default null, --fix width
  p_ln number default plpdf_const.under --Beside,new line, under, no action = null
  );

/**************************************************************************************************
-- Table functions and procedure.
**************************************************************************************************/
--add one width to grid
procedure addGridCol(
  p_TableGrid in out t_TableGrid,
  p_width number
  );

--create grid max 10 parameter
function crGrid(
  p_width_1 number default null,
  p_width_2 number default null,
  p_width_3 number default null,
  p_width_4 number default null,
  p_width_5 number default null,
  p_width_6 number default null,
  p_width_7 number default null,
  p_width_8 number default null,
  p_width_9 number default null,
  p_width_10 number default null
  ) return t_TableGrid;
---------------------------------------------------------------------------------------------------
--create table
function crTable(
  p_bidiVisual boolean default null,
  p_box t_box default null, --box properties
  p_width number default null,
  p_grid t_TableGrid default null,
  p_alignment t_hAlign default null, --Table Alignment, ST_Jc
  p_master_table t_parsed_table default null,
  p_styleId varchar2 default null,
  p_cell_box t_box default null --cell default box props
  ) return t_Table;
---------------------------------------------------------------------------------------------------
--create row
function crRow(
  p_box t_box default null, --box properties
  p_cantSplit boolean default null,
  p_min_height number default null
  ) return t_TableRow;
---------------------------------------------------------------------------------------------------
--create cell
function crCell(
  p_box t_box default null,
  p_width number default null,
  p_gridSpan pls_integer default null,
  p_noWrap boolean default null,
  p_fittext boolean default null,
  p_Valign t_vAlign default null,
  p_textDirection t_textDirection default null
  ) return t_TableCell;
---------------------------------------------------------------------------------------------------
--add paragraph to cell
function addParagraph(
  p_TableCell in out t_TableCell,
  p_Paragraph t_Paragraph
  )return pls_integer;

procedure addParagraph(
  p_TableCell in out t_TableCell,
  p_Paragraph t_Paragraph
  );
--v4.9.1
function cellParser(
  p_cell t_TableCell,
  p_table_part varchar2 default null, --'header','footer','body'
  p_grid_width number default null, --grid
  p_bidiVisual boolean default null,
  p_table_style_ppr t_ParagraphProps default null,
  p_table_style_rpr t_RunProps default null,
  p_table_style_cell_box t_box default null,
  p_tr_min_height number default null --v5.0
  ) return t_parsed_cell;
--v4.1.0
procedure PrintParsedCell( --PrintParsedCell1Page
  p_x number,
  p_y number,
  p_parsed_cell t_parsed_cell
  );
---------------------------------------------------------------------------------------------------
--add cell to row
function addCell(
  p_TableRow in out t_TableRow,
  p_TableCell t_TableCell
  ) return pls_integer;
--
procedure addCell(
  p_TableRow in out t_TableRow,
  p_TableCell t_TableCell
  );
---------------------------------------------------------------------------------------------------
--add row to table
--header
function addHeaderRow(
  p_table in out t_Table,
  p_TableRow t_TableRow,
  p_print t_row_print default null --all(page)/first(page)/each(row)
  ) return pls_integer;
--footer
function addFooterRow(
  p_Table in out t_Table,
  p_TableRow t_TableRow,
  p_print t_row_print default null --all(page)/last(page)
  ) return pls_integer;
--body
function addBodyRow(
  p_Table in out t_Table,
  p_TableRow t_TableRow
  ) return pls_integer;
--
procedure addBodyRow(
  p_Table in out t_Table,
  p_TableRow t_TableRow
  );
---------------------------------------------------------------------------------------------------
--internal
function table_parser(
  p_table t_table
  ) return t_parsed_table;
--internal
function splitParsedRow(
  p_parsed_row in out t_parsed_row,
  p_h number
  ) return t_parsed_row;
--internal
procedure PrintParsedFooter1Page(
  p_parsed_table t_parsed_table,
  p_is_last_page boolean
  );
--internal
procedure PrintParsedHeader1Page(
  p_parsed_table t_parsed_table,
  p_is_first_page boolean,
  p_is_new_page boolean
  );
--internal
--v4.9.3
procedure PrintParsedEachHeader1Page(
  p_parsed_table t_parsed_table
  );
--internal
--v4.9.5
procedure PrintParsedHeader1PageMaster(
  p_parsed_master_table t_parsed_master_table,
  p_is_first_page boolean,
  p_is_new_page boolean
  );
---------------------------------------------------------------------------------------------------
--parse init
function InitParseTable(
  p_table t_table
  ) return t_parsed_table;
---------------------------------------------------------------------------------------------------
--print table
procedure printTable(
  p_table t_Table
  );
---------------------------------------------------------------------------------------------------
procedure startTable(
  p_parsed_table t_parsed_table
  );
---------------------------------------------------------------------------------------------------
procedure endTable(
  p_parsed_table t_parsed_table
  );
---------------------------------------------------------------------------------------------------
--add and print a row direct
procedure printBodyRow(
  p_parsed_table t_parsed_table,
  p_TableRow t_TableRow
  );
---------------------------------------------------------------------------------------------------
--Utils
function getRunPropsFontStyle(
  p_b boolean,
  p_i boolean,
  p_u t_underline
  ) return varchar2;
--
function getBoxFrameLeftWidth(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------------
function getBoxFrameRightWidth(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------------
function getBoxFrameWidth(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------------
function getBoxFrameTopHeight(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------------
function getBoxFrameBottomHeight(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------------
function getBoxFrameHeight(
  p_box t_box
  ) return number;
---------------------------------------------------------------------------------------------------
function row_parser(
  p_row t_TableRow,
  p_table_part varchar2 default null, --'header','footer','body'
  p_width number default null, --table width
  p_grid t_TableGrid default null, --column widths
  p_bidiVisual boolean default null,
  p_table_style_ppr t_ParagraphProps default null,
  p_table_style_rpr t_RunProps default null,
  p_table_style_cell_box t_box default null
  ) return t_parsed_row;
--
procedure PrintParsedRow1Page(
  p_parsed_row t_parsed_row,
  p_table_box t_box default null,
  p_x number default null,
  p_y number default null
  );
--
function fonts_equal(
  p_font1 t_font,
  p_font2 t_font
  ) return boolean;
--
function getRun(
  p_paragraph t_Paragraph,
  p_idx pls_integer
  ) return t_Run;
--
procedure setRun(
  p_paragraph in out t_Paragraph,
  p_idx pls_integer,
  p_run t_Run
  );
--
procedure delRuns(
  p_paragraph in out t_Paragraph
  );
--
--v3.5.0
function getLevelText(
  p_num pls_integer,
  p_NumberFormat varchar2
  ) return varchar2;
--
--v4.2.0
function crListLevel(
  p_numFmt varchar2 default null,
  p_ilvl pls_integer default null, --level: 0,1,....9
  p_lvlJc varchar2 default null, --level Justification
  p_lvlText varchar2 default null, --1-2... chars
  p_pPr_ind_left number default null,
  p_pPr_ind_hanging number default null,
  --Run properties
  p_rtl boolean default null,
  p_box t_box default null,
  p_caps t_caps default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign t_VerticalAlignRun default null,
  p_Vposition number default null,
  --
  p_start pls_integer default null
  ) return t_ListLevel;
--
--v3.5.0
procedure initNum;
--v3.5.0
procedure addListLevel(
  p_abstractNumId pls_integer,
  p_ListLevel t_ListLevel
  );
--v3.5.0
procedure addNumbering(
  p_numId pls_integer,
  p_abstractNumId pls_integer
  );
--v4.1.0
procedure PrintImageBox(
  p_x number, --X of top-left corner
  p_y number, --Y of top-left corner
  p_w number,
  p_h number,
  p_name varchar2,
  p_data in out nocopy blob,
  p_props t_RunProps
  );
--v4.7.0
procedure initStyles;
--v4.9.1
procedure addParagraphStyle(
  p_styleId varchar2,
  p_bidi boolean default null,
  p_box t_box default null,
  p_ind t_Indentation default null,
  p_alignment t_ParagraphAlignment default null,
  p_keepLines boolean default null,
  p_spacing number default null,
  p_before_spacing number default null,
  p_after_spacing number default null,
  p_pageBreakBefore boolean default null,
  p_textVAlign t_TextAlignment default null,
  p_widowControl boolean default null,
  p_maxline pls_integer default null,
  p_rPr t_RunProps default null,
  p_default boolean default null
  );
--v4.9.1
procedure addRunStyle(
  p_styleId varchar2,
  p_box t_box default null,
  p_caps varchar2 default null,
  p_fitText number default null,
  p_font t_font default null,
  p_link varchar2 default null,
  p_rtl boolean default null,
  p_text_color plpdf_type.t_color default null,
  p_textScalePct number default null,
  p_vertAlign varchar2 default null,
  p_Vposition number default null,
  p_default boolean default null
  );
--v4.9.1
procedure addTableStyle(
  p_styleId varchar2,
  p_pPr t_ParagraphProps default null,
  p_rPr t_RunProps default null,
  p_bidiVisual boolean default null,
  p_box t_box default null,
  p_width number default null,
  p_alignment t_hAlign default null,
  p_cell_box t_box default null,
  p_default boolean default null,
  p_basedOn varchar2 default null --v4.9.8
  );
--v4.7.0
function formatPageNumber(
  p_number number,
  p_format varchar2
  ) return varchar2;
--v4.8.0
procedure setScriptFontSizeMultiple(
  p_num number
  );
--v4.8.0
procedure setSuperscriptRaisePcs(
  p_num number
  );
--
--
end plpdf3;
/

