create or replace package plpdf3_chart
authid current_user is
--v5.9
--
subtype t_common_pos is plpdf_type.v2avg;
c_b constant t_common_pos := 'b'; -- bottom
c_l constant t_common_pos := 'l'; -- left
c_r constant t_common_pos := 'r'; -- right
c_t constant t_common_pos := 't'; -- top
c_tr constant t_common_pos := 'tr'; -- top-right
c_ctr constant t_common_pos := 'ctr'; -- center
c_ot constant t_common_pos := 'ot'; -- on top
c_in constant t_common_pos := 'in'; -- inner
c_out constant t_common_pos := 'out'; -- outer
c_inEnd constant t_common_pos := 'inEnd';
c_outEnd constant t_common_pos := 'outEnd';
c_inBase constant t_common_pos := 'inBase'; -- base of the bar
--
subtype t_axisPos is plpdf_type.v2avg;
/*c_onSubdivisions constant t_axisPos := 'onSubdivisions';
c_betweenSubdivis         ions constant t_axisPos := 'betweenSubdivisions';*/
--dupli
--c_b constant t_common_pos := 'b'; -- bottom
--c_l constant t_common_pos := 'l'; -- left
--c_r constant t_common_pos := 'r'; -- right
--c_t constant t_common_pos := 't'; -- top
--
subtype t_dataMark is plpdf_type.v2avg;
c_emptyCircle constant t_dataMark := 'emptyCircle';
c_filledCircle constant t_dataMark := 'filledCircle';
c_emptyRectangle constant t_dataMark := 'emptyRectangle';
c_filledRectangle constant t_dataMark := 'filledRectangle';
--
subtype t_chart_type is plpdf_type.v2avg;
c_bar constant t_chart_type := 'barChart'; -- bar chart
c_line constant t_chart_type := 'lineChart'; -- line chart
c_pie constant t_chart_type := 'pieChart'; -- pie chart
--
subtype t_bar_direction is plpdf_type.v2avg;
c_column constant t_bar_direction := 'col'; -- standing bars
c_row constant t_bar_direction := 'bar'; -- lying bars
--
subtype t_outline_type is plpdf_type.v2avg;
c_dbl constant t_outline_type := 'dbl';
c_sng constant t_outline_type := 'sng';
c_thickThin constant t_outline_type := 'thickThin';
c_thinThick constant t_outline_type := 'thinThick';
c_tri constant t_outline_type := 'tri';
c_noLine constant t_outline_type := 'noLine';
--
subtype t_dashType is plpdf_type.v2avg;
c_dash constant t_dashType := 'dash';
c_dashDot constant t_dashType := 'dashDot';
--
subtype t_tickMark is plpdf_type.v2avg;
c_cross constant t_tickMark := 'cross';
--c_in constant t_tickMark := 'in';  -- duplicate
c_none constant t_tickMark := 'none';
--c_out constant t_tickMark := 'out';  -- duplicate
--
subtype t_tickLblPos is plpdf_type.v2avg;
c_high constant t_tickLblPos := 'high';
c_low constant t_tickLblPos := 'low';
c_nextTo constant t_tickLblPos := 'nextTo';
c_noLabel constant t_tickLblPos := 'none';
--
subtype t_crosses is plpdf_type.v2avg;
c_autoZero constant t_crosses := 'autoZero';
c_max constant t_crosses := 'max';
c_min constant t_crosses := 'min';
--
subtype t_orientation is plpdf_type.v2avg;
c_maxMin constant t_orientation := 'maxMin';
c_minMax constant t_orientation := 'minMax';
--
subtype t_layoutMode is plpdf_type.v2avg;
c_edge constant t_layoutMode := 'edge';
c_factor constant t_layoutMode := 'factor';
--
type t_lineProps is record(
  lineType t_outline_type, -- line styel: single, double,
  color plpdf_type.t_color, -- color
  dashType t_dashType, -- dash type,
  alpha pls_integer, -- transparent
  width number -- line width
  );
--
type t_spPr is record(
  ln t_lineProps
  );
--
type t_dataLabelProps is record(
  dLblPos plpdf_type.v2avg, -- CT_DLblPos
  dLblRot number default 0,
  dLblXOff number default 0,
  dLblYOff number default 0,
  dLblFont plpdf3.t_font default null,
  dLblColor plpdf_type.t_color default plpdf_const.Black
  );
--
type t_plot is record(
  x number null, -- left
  y number null, -- top
  w number null, -- width
  h number null, -- height
  xMode t_layoutMode, -- This element specifies how to interpret the Left element for this manual layout.
  yMode t_layoutMode -- This element specifies how to interpret the Top element for this manual layout.
  );
--
type t_title is record(
  plot t_plot,
  box plpdf3.t_box,
  angle number,  -- 0-90, 270.
  p plpdf3.t_Paragraph
  );
--
type t_point is record(
  idx pls_integer,
  textValue plpdf_type.v2avg,
  color plpdf_type.t_color
  );
--
type t_num_point is record(
  formatCode plpdf_type.v2avg,
  idx pls_integer,
  value number,
  color plpdf_type.t_color
  );
--
type t_points is table of t_point index by pls_integer;
type t_num_points is table of t_num_point index by pls_integer;
--
type t_ValueSerie is record (
  serieName plpdf3.t_Paragraph,
  dataLabelsProps t_dataLabelProps,
  dataValues t_num_points,
  color plpdf_type.t_color,
  mark t_dataMark,
  markSize number
  );
--
type t_Series is table of t_ValueSerie index by pls_integer; -- CT_Ser
--
type t_DataSeries is record (
  series t_Series,
  categories t_points
  );
--
type t_Chart is record(
  -- box plpdf3.t_box,
  chart_type t_chart_type, --bar, pie,...
  -- common
  dataSeries t_DataSeries,
  dataLabels t_dataLabelProps, -- CT_DLbls
  -- barChart
  barDir t_bar_direction, -- direction
  gapWidth number, --default 219 0-500
  overlap number, -- default -27 -100-100
  grouping_ plpdf_type.v2avg
  );
--
type t_Scaling is record(
  min_ number,
  max_ number,
  orientation t_orientation -- default c_minMax
  );
--
type t_Axis is record(
  box plpdf3.t_box,
  scaling t_Scaling,
  title t_title,
  axisPosition t_axisPos default c_b, --bottom /*???c_betweenSubdivisions*/
  majorGridlines t_spPr,
  majorTickMark t_tickMark default c_out,
  minorGridlines t_spPr,
  minorTickMark t_tickMark,
  numFmt plpdf_type.v2avg,
  tickLblPos t_tickLblPos,
  spPr t_spPr,
  crosses t_crosses,
  showAxis boolean,
  labelAlign t_common_pos default c_l,
  labelOffset_pct pls_integer default 100,
  labelProps plpdf3.t_RunProps,
  labelRotation number default 0,
  majorUnit number default null,
  minorUnit number default null,
  majorUnitPcs number default null, --v4.7.0
  minorUnitPcs number default null  --v.4.7.0
  );
--
type t_PlotArea is record(
  box plpdf3.t_box,
  plot t_plot,
  chart t_Chart,  -- barchart, pieChart...
  categoryAxis t_Axis, -- CT_CatAx,
  valueAxis t_Axis -- CT_ValAx
  );
--
type t_View3D is record(
  depthPercent pls_integer, -- 20 - 2000
  hPercent pls_integer, -- 5 - 500
  perspective pls_integer, -- 0-100
  rotX pls_integer, -- -90 - 90
  rotY pls_integer -- 0 - 360
  --floor_ , --
  --backWall, -- 3D
  --sideWall, -- 3D
  );--
--
type t_legend is record(
  plot t_plot,
  cell plpdf3.t_TableCell,
  position t_common_pos,
  font plpdf3.t_font default null,
  color plpdf_type.t_color default plpdf_const.Black
  );
--
type t_series_colors is table of plpdf_type.t_color index by pls_integer;
--
type t_ChartArea is record(
  box plpdf3.t_box,
  legend t_Legend,
  title t_title,
  plotArea t_PlotArea,
  view3D t_View3D,
  --tech
  SerieCount pls_integer,
  CategoryCount pls_integer,
  NextCategory pls_integer,
  FormatString plpdf_type.v2avg,
  LegendExists boolean,
  series_colors t_series_colors,
  mainframe_color plpdf_type.t_color
  );

--
-----------------------------------------------------------------------------------------
/**
 <config>
  <pck-name>PLPDF3_CHART</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v5.9</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/
/**
 <name>init</name>
 <type>Procedure</type>
 <desc>
  Initializes the variables used to create charts.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_type t_chart_type</param-def>
   <param-desc>The type of the chart.</param-desc>
  </param>
  <param>
   <param-def>p_format_string varchar2 default null</param-def>
   <param-desc>Format string for number to character conversion</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure init(
  p_type t_chart_type,
  p_format_string varchar2 default null
  );
/**
 <name>setChartTitle</name>
 <type>Procedure</type>
 <desc>
  Sets the text and properties of the Chart Title.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_x number default null</param-def>
   <param-desc>X position of the Chart Title.</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position of the Chart Title.</param-desc>
  </param>
  <param>
   <param-def>p_title varchar2</param-def>
   <param-desc>The title of the chart.</param-desc>
  </param>
  <param>
   <param-def>p_angle number default 0</param-def>
   <param-desc>Rotation of the chart title.</param-desc>
  </param>
  <param>
   <param-def>p_caps plpdf3.t_caps default plpdf3.c_smallcaps</param-def>
   <param-desc>Sets the capital settings of the title.</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.v2avg default null</param-def>
   <param-desc>Font type</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Italic</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Bold</param-desc>
  </param>
  <param>
   <param-def>p_size number default 14</param-def>
   <param-desc>Font Size</param-desc>
  </param>
  <param>
   <param-def>p_rtl boolean default false</param-def>
   <param-desc>Right to Left text</param-desc>
  </param>
  <param>
   <param-def>p_text_color plpdf_type.t_color default null</param-def>
   <param-desc>Font Color</param-desc>
  </param>
  <param>
   <param-def>p_box plpdf3.t_box default null</param-def>
   <param-desc>Box of the title.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setChartTitle(
  p_x     number default null,
  p_y     number default null,
  p_xMode t_LayoutMode default c_edge,
  p_yMode t_LayoutMode default c_edge,
  p_title  varchar2,
  p_angle number default 0,
  -- properties
  p_caps plpdf3.t_caps default null, -- c_smallcaps, c_allcaps
  p_font plpdf_type.v2avg default null,
  p_italic boolean default false,
  p_bold boolean default false,
  p_size number default 14,
  p_text_color plpdf_type.t_color default null, --plpdf_const.Black
  p_box plpdf3.t_box default null
  );

--v4.7.0
function addCategory(
  p_textValue varchar2,
  p_color plpdf_type.t_color default null
  ) return pls_integer;

/**
 <name>addCategory</name>
 <type>Procedure</type>
 <desc>
   Adds a category to the chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_textValue varchar2</param-def>
   <param-desc>Name of the category</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Color of the category's sector in pie chart</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addCategory(
  p_textValue varchar2,
  p_color plpdf_type.t_color default null
  );

--v4.7.0
function addDataSet(
  p_name varchar2,
  p_color plpdf_type.t_color default null,
  p_mark t_dataMark default null,
  p_markSize number default null
  ) return pls_integer;

/**
 <name>addDataSet</name>
 <type>Procedure</type>
 <desc>
   Adds a DataSet to the chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the DataSet</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Color of the DataSet</param-desc>
  </param>
  <param>
   <param-def>p_mark plpdf3_chart.t_dataMark default null</param-def>
   <param-desc>Type of the marks on the Dataset</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Size of the marks on the Dataset</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addDataSet(
  p_name varchar2,
  p_color plpdf_type.t_color default null,
  p_mark t_dataMark default null,
  p_markSize number default null
  );

/**
 <name>setDatasetLabel</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the data set labels.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_position t_common_pos</param-def>
   <param-desc>Position of the data labels.</param-desc>
  </param>
  <param>
   <param-def>p_fontname plpdf_type.v2avg default null</param-def>
   <param-desc>Font type of the data labels.</param-desc>
  </param>
  <param>
   <param-def>p_fontsize number default null</param-def>
   <param-desc>Font size of the data labels.</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Defines if the data labels are bold.</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Defines if the data labels are italic.</param-desc>
  </param>
  <param>
   <param-def>p_underline plpdf3.t_underline default pldpf3.c_none</param-def>
   <param-desc>Underline of the labels.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>Color of the data labels.</param-desc>
  </param>
  <param>
   <param-def>p_rotation number default 0</param-def>
   <param-desc>Rotation of the data labels.</param-desc>
  </param>
  <param>
   <param-def>p_x_offset number default 0</param-def>
   <param-desc>X offset of the data labels. Positive for right offset, negative for left.</param-desc>
  </param>
  <param>
   <param-def>p_y_offset number default 0</param-def>
   <param-desc>Y offset of the data labels.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDatasetLabel(
  p_position t_common_pos,
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black,
  p_rotation number default 0,
  p_x_offset number default 0,
  p_y_offset number default 0
  );
/**
 <name>addValue</name>
 <type>Procedure</type>
 <desc>
   Adds a value to the chart.
 </desc>
 <version>v4.7.0</version>
 <params>
  <param>
   <param-def>p_category_id pls_integer</param-def>
   <param-desc>Index in the Category.</param-desc>
  </param>
  <param>
   <param-def>p_serie_id pls_integer</param-def>
   <param-desc>Index in the Data Set.</param-desc>
  </param>
  <param>
   <param-def>p_value number</param-def>
   <param-desc>Value.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addValue(
  p_category_id pls_integer,
  p_serie_id pls_integer,
  p_value number
  );

--v4.7.0
procedure addNextCategoryValue(
  p_value number
  );

/**
 <name>setBarProperties</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the bars in the column or row chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_direction t_bar_direction</param-def>
   <param-desc>Direction of the bars.</param-desc>
  </param>
  <param>
   <param-def>p_gap number default null</param-def>
   <param-desc>Gap between the bars.</param-desc>
  </param>
  <param>
   <param-def>p_overlap number default null</param-def>
   <param-desc>Overlap of the bars.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setBarProperties(
  p_direction t_bar_direction,
  p_gap number default null,
  p_overlap number default null
  );
/**
 <name>setEntireChartDataLabels</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the data labels for the entire chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_position t_common_pos</param-def>
   <param-desc>Position</param-desc>
  </param>
  <param>
   <param-def>p_rotation number default 0</param-def>
   <param-desc>Rotation</param-desc>
  </param>
  <param>
   <param-def>p_x_offset number default 0</param-def>
   <param-desc>X offset of the data labels. Positive for right offset, negative for left.</param-desc>
  </param>
  <param>
   <param-def>p_y_offset number default 0</param-def>
   <param-desc>Y offset of the data labels.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setEntireChartDataLabels(
   p_position t_common_pos,
   p_fontname plpdf_type.v2avg default null,
   p_fontsize number default null,
   p_bold boolean default false,
   p_italic boolean default false,
   p_underline plpdf3.t_underline default plpdf3.c_none,
   p_color plpdf_type.t_color default plpdf_const.Black,
   p_rotation number default 0,
   p_x_offset number default 0,
   p_y_offset number default 0
   );
/**
 <name>setXAxisTitle</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the Horizontal Axis Title.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_x number defaul null</param-def>
   <param-desc>X position</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position</param-desc>
  </param>
  <param>
   <param-def>p_title varchar2</param-def>
   <param-desc>The title of the axis.</param-desc>
  </param>
  <param>
   <param-def>p_angle number default 0</param-def>
   <param-desc>Rotation of the axis title.</param-desc>
  </param>
  <param>
   <param-def>p_caps plpdf3.t_caps default plpdf3.c_smallcaps</param-def>
   <param-desc>Sets the capital settings of the title.</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.v2avg default null</param-def>
   <param-desc>Font type</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Italic</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Bold</param-desc>
  </param>
  <param>
   <param-def>p_size number default 14</param-def>
   <param-desc>Font Size</param-desc>
  </param>
  <param>
   <param-def>p_text_color plpdf_type.t_color default null</param-def>
   <param-desc>Font Color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXAxisTitle(
  p_x     number default null,
  p_y     number default null,
  p_xMode t_LayoutMode default c_edge,
  p_yMode t_LayoutMode default c_edge,
  p_title  varchar2,
  p_angle number default 0,
  -- properties
  p_caps plpdf3.t_caps default plpdf3.c_smallcaps,
  p_font plpdf_type.v2avg default null,
  p_italic boolean default false,
  p_bold boolean default false,
  p_size number default null,
  p_text_color plpdf_type.t_color default plpdf_const.Black
  );
/**
 <name>setYAxisTitle</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the Vertical Axis Title.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_x number defaul null</param-def>
   <param-desc>X position</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position</param-desc>
  </param>
  <param>
   <param-def>p_title varchar2</param-def>
   <param-desc>The title of the axis.</param-desc>
  </param>
  <param>
   <param-def>p_angle number default 270</param-def>
   <param-desc>Rotation of the axis title.</param-desc>
  </param>
  <param>
   <param-def>p_caps plpdf3.t_caps default plpdf3.c_smallcaps</param-def>
   <param-desc>Sets the capital settings of the title.</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.v2avg default null</param-def>
   <param-desc>Font type</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Italic</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Bold</param-desc>
  </param>
  <param>
   <param-def>p_size number default 14</param-def>
   <param-desc>Font Size</param-desc>
  </param>
  <param>
   <param-def>p_text_color plpdf_type.t_color default null</param-def>
   <param-desc>Font Color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYAxisTitle(
  p_x     number default null,
  p_y     number default null,
  p_xMode t_LayoutMode default c_edge,
  p_yMode t_LayoutMode default c_edge,
  p_title  varchar2,
  p_angle number default 270,
  -- properties
  p_caps plpdf3.t_caps default plpdf3.c_smallcaps,
  p_font plpdf_type.v2avg default null,
  p_italic boolean default false,
  p_bold boolean default false,
  p_size number default null,
  p_text_color plpdf_type.t_color default null
  );
/**
 <name>setXAxisScaling</name>
 <type>Procedure</type>
 <desc>
   Sets the minimum and maximum value of the X axis (in the case of Row chart).
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_min number default null</param-def>
   <param-desc>Minimum value.</param-desc>
  </param>
  <param>
   <param-def>p_max number default null</param-def>
   <param-desc>Maximum value.</param-desc>
  </param>
  <param>
   <param-def>p_orientation t_orientation default c_minMax</param-def>
   <param-desc>Orientation of the values.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXAxisScaling(
  p_min number default null,
  p_max number default null,
  p_orientation t_orientation default c_minMax
  );
/**
 <name>setYAxisScaling</name>
 <type>Procedure</type>
 <desc>
   Sets the minimum and maximum values of the Y axis.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_min number default null</param-def>
   <param-desc>Minimum value.</param-desc>
  </param>
  <param>
   <param-def>p_max number default null</param-def>
   <param-desc>Maximum value.</param-desc>
  </param>
  <param>
   <param-def>p_orientation t_orientation default c_minMax</param-def>
   <param-desc>Orientation of the values.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYAxisScaling(
  p_min number default null,
  p_max number default null,
  p_orientation t_orientation default c_minMax
  );
/**
 <name>setXAxisPosition</name>
 <type>Procedure</type>
 <desc>
   Sets the X label positions related to the divisions.
 </desc>
 <version>v4.3.0</version>
 <params>
  <param>
   <param-def>p_position t_axisPos</param-def>
   <param-desc>Position</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXAxisPosition(
  p_position t_axisPos
  );
/**
 <name>setYAxisPosition</name>
 <type>Procedure</type>
 <desc>
   Sets the Y label positions related to the divisions.
 </desc>
 <version>v4.3.0</version>
 <params>
  <param>
   <param-def>p_position t_axisPos</param-def>
   <param-desc>Position</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYAxisPosition(
  p_position t_axisPos
  );

/**
 <name>setXMajorGridLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the horizontal major grid lines.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Color of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXMajorGridLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75
  );
/**
 <name>setYMajorGridLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the vertical major grid lines.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Color of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYMajorGridLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75
  );
/**
 <name>setXMinorGridLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the horizontal minor grid lines.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Color of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXMinorGridLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75
  );
/**
 <name>setYMinorGridLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the vertical minor grid lines.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>Color of the lines.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYMinorGridLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75
  );

/**
 <name>setXTickMarks</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the tick marks on the horizontal axis.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_major t_tickMark default c_out</param-def>
   <param-desc>Type of the major tick mark.</param-desc>
  </param>
  <param>
   <param-def>p_minor t_tickMark default null</param-def>
   <param-desc>Type of the minor tick marks.</param-desc>
  </param>
  <param>
   <param-def>p_labelPosition t_tickLblPos</param-def>
   <param-desc>Tick label positions.</param-desc>
  </param>
  <param>
   <param-def>p_labelFormat</param-def>
   <param-desc>Format of the tick labels.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXTickMarks(
  p_major t_tickMark default c_out,
  p_minor t_tickMark default null,
  p_labelPosition t_tickLblPos,
  p_labelFormat varchar2 default null
  );

/**
 <name>setYTickMarks</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the tick marks on the vertical axis.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_major t_tickMark default c_out</param-def>
   <param-desc>Type of the major tick mark.</param-desc>
  </param>
  <param>
   <param-def>p_minor t_tickMark default null</param-def>
   <param-desc>Type of the minor tick marks.</param-desc>
  </param>
  <param>
   <param-def>p_labelPosition t_tickLblPos</param-def>
   <param-desc>Tick label positions.</param-desc>
  </param>
  <param>
   <param-def>p_labelFormat</param-def>
   <param-desc>Format of the tick labels.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYTickMarks(
  p_major t_tickMark default c_out,
  p_minor t_tickMark default null,
  p_labelPosition t_tickLblPos default null,
  p_labelFormat varchar2 default null
  );

/**
 <name>setXAxisLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the horizontal axis line.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the line.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Color of the line.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
  <param>
   <param-def>p_crosses t_crosses default c_autoZero</param-def>
   <param-desc>Defines where does the two axis meet each other.</param-desc>
  </param>
  <param>
   <param-def>p_showAxis boolean default true</param-def>
   <param-desc>Visibility of the axis.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXAxisLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75,
  p_crosses t_crosses default c_autoZero,
  p_showAxis boolean default true
  );
/**
 <name>setYAxisLine</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the vertical axis line.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_lineType t_outline_type default c_sng</param-def>
   <param-desc>Type of the line.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Color of the line.</param-desc>
  </param>
  <param>
   <param-def>p_dashType t_dashType default c_dash</param-def>
   <param-desc>Dashing style.</param-desc>
  </param>
  <param>
   <param-def>p_alpha pls_integer default 0</param-def>
   <param-desc>Transparency percent.</param-desc>
  </param>
  <param>
   <param-def>p_width number default 0.75</param-def>
   <param-desc>Line width.</param-desc>
  </param>
  <param>
   <param-def>p_crosses t_crosses default c_autoZero</param-def>
   <param-desc>Defines where does the two axis meet each other.</param-desc>
  </param>
  <param>
   <param-def>p_showAxis boolean default true</param-def>
   <param-desc>Visibility of the axis.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYAxisLine(
  p_lineType t_outline_type default c_sng,
  p_color plpdf_type.t_color default null,
  p_dashType t_dashType default c_dash,
  p_alpha pls_integer default 0,
  p_width number default 0.75,
  p_crosses t_crosses default c_autoZero,
  p_showAxis boolean default true
  );
/**
 <name>setXLabels</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the labels on the horizontal axis.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_align t_common_pos default c_b</param-def>
   <param-desc>Position of the labels.</param-desc>
  </param>
  <param>
   <param-def>p_offset pls_integer default 0</param-def>
   <param-desc>The offset between the labels and the axis.</param-desc>
  </param>
  <param>
   <param-def>p_rotation number default 100</param-def>
   <param-desc>The rotation of the labels in degree, percentage of default value.</param-desc>
  </param>
  <param>
   <param-def>p_fontname plpdf_type.v2avg default null</param-def>
   <param-desc>Font type</param-desc>
  </param>
  <param>
   <param-def>p_fontsize number default null</param-def>
   <param-desc>Font Size</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Bold</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Italic</param-desc>
  </param>
  <param>
   <param-def>p_underline plpdf3.t_underline default plpdf3.c_none</param-def>
   <param-desc>Underline</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Font Color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXLabels(
  p_align t_common_pos default c_b,
  p_offset pls_integer default 100, --pct
  p_rotation number default 0,
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black
  );

--v4.9.8
procedure setXLabels2(
  p_align t_common_pos default c_b,
  p_offset number default null, --value
  p_rotation number default 0,
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black
  );

/**
 <name>setYLabels</name>
 <type>Procedure</type>
 <desc>
   Sets the properties of the labels on the vertical axis.
 </desc>
 <version>v4.9.3</version>
 <params>
  <param>
   <param-def>p_align t_common_pos default c_r</param-def>
   <param-desc>Position of the labels.</param-desc>
  </param>
  <param>
   <param-def>p_offset pls_integer default 100</param-def>
   <param-desc>The offset between the labels and the axis, percentage of default value.</param-desc>
  </param>
  <param>
   <param-def>p_fontname plpdf_type.v2avg default null</param-def>
   <param-desc>Font type</param-desc>
  </param>
  <param>
   <param-def>p_fontsize number default null</param-def>
   <param-desc>Font Size</param-desc>
  </param>
  <param>
   <param-def>p_bold boolean default false</param-def>
   <param-desc>Bold</param-desc>
  </param>
  <param>
   <param-def>p_italic boolean default false</param-def>
   <param-desc>Italic</param-desc>
  </param>
  <param>
   <param-def>p_underline plpdf3.t_underline default plpdf3.c_none</param-def>
   <param-desc>Underline</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>Font Color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYLabels(
  p_align t_common_pos default c_r, --v4.9.3
  p_offset pls_integer default 100, --pct
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black
  );

--v4.9.8
procedure setYLabels2(
  p_align t_common_pos default c_r,
  p_offset number default null, --value
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black
  );

/**
 <name>setXUnitShift</name>
 <type>Procedure</type>
 <desc>
   Sets the value steps on the horizontal axis (Row chart).
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_major number</param-def>
   <param-desc>Major steps</param-desc>
  </param>
  <param>
   <param-def>p_minor number</param-def>
   <param-desc>Minor steps</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setXUnitShift(
  p_major number,
  p_minor number
  );
/**
 <name>setYUnitShift</name>
 <type>Procedure</type>
 <desc>
   Sets the value steps on the vertical axis.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_major number</param-def>
   <param-desc>Major steps</param-desc>
  </param>
  <param>
   <param-def>p_minor number</param-def>
   <param-desc>Minor steps</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setYUnitShift(
  p_major number,
  p_minor number
  );
--
procedure setPlotAreaPosition(
  p_x     number default null,
  p_y     number default null,
  p_width     number default null,
  p_height     number default null,
  p_xMode t_LayoutMode default null,
  p_yMode t_LayoutMode default null
  );

/**
 <name>addLegend</name>
 <type>Procedure</type>
 <desc>
   Adds a legend to the chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_x number defaul null</param-def>
   <param-desc>X position</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position</param-desc>
  </param>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>The width of the legend.</param-desc>
  </param>
  <param>
   <param-def>p_height number default null</param-def>
   <param-desc>The height of the legend.</param-desc>
  </param>
  <param>
   <param-def>p_position t_common_pos default c_r</param-def>
   <param-desc>The position of the legend.</param-desc>
  </param>
  <param>
   <param-def>p_box plpdf3.t_box default null</param-def>
   <param-desc>The box of the legend.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addLegend(
  p_x     number default null,
  p_y     number default null,
  p_width number default null,
  p_height number default null,
  p_xMode t_LayoutMode default c_edge,
  p_yMode t_LayoutMode default c_edge,
  p_position t_common_pos default c_r,
  p_box plpdf3.t_box default null,
  -- Font properties
  p_fontname plpdf_type.v2avg default null,
  p_fontsize number default 10,
  p_bold boolean default false,
  p_italic boolean default false,
  p_underline plpdf3.t_underline default plpdf3.c_none,
  p_color plpdf_type.t_color default plpdf_const.Black
  );

/**
 <name>setMainFrameColor</name>
 <type>Procedure</type>
 <desc>
   Sets color of the main frame.
 </desc>
 <version>v4.9.1</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>The color of the frame, null means no frame.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setMainFrameColor(
  p_color plpdf_type.t_color default null
  );

/**
 <name>DrawChart</name>
 <type>Procedure</type>
 <desc>
   Draws the chart.
 </desc>
 <version>v4.0.0</version>
 <params>
  <param>
   <param-def>p_x number defaul null</param-def>
   <param-desc>X position</param-desc>
  </param>
  <param>
   <param-def>p_y number default null</param-def>
   <param-desc>Y position</param-desc>
  </param>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>The width of the chart.</param-desc>
  </param>
  <param>
   <param-def>p_height number default null</param-def>
   <param-desc>The height of the chart.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawChart(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null
  );

--v4.9.2
procedure DrawChartArea(
  p_chartArea  t_ChartArea,
  p_x          number default null,
  p_y          number default null,
  p_width      number default null,
  p_height     number default null
  );

--v4.9.2
function getChartArea
   return t_ChartArea;

--v4.9.2
procedure setChartArea(
  p_chartArea  t_ChartArea
  );

--v4.9.3
function getbasicDistance
  return number;
--v4.9.3
procedure setbasicDistance(
  p_value number
  );
--v4.9.3
function getchartTitleDistance
  return number;
--v4.9.3
procedure setchartTitleDistance(
  p_value number
  );
--v4.9.3
function getfontSizeCoefficient
  return number;
--v4.9.3
procedure setfontSizeCoefficient(
  p_value number
  );
--v4.9.3
function getXTitleSpace
  return number;
--v4.9.3
procedure setXTitleSpace(
  p_value number
  );
--v4.9.3
function getXTitleDistance
  return number;
--v4.9.3
procedure setXTitleDistance(
  p_value number
  );
--v4.9.3
function getYTitleSpace
  return number;
--v4.9.3
procedure setYTitleSpace(
  p_value number
  );
--v4.9.3
function getYTitleDistance
  return number;
--v4.9.3
procedure setYTitleDistance(
  p_value number
  );
--v4.9.3
function getXLabelOffset
  return number;
--v4.9.3
procedure setXLabelOffset(
  p_value number
  );
--v4.9.3
function getYLabelOffset
  return number;
--v4.9.3
procedure setYLabelOffset(
  p_value number
  );
--v4.9.3
function getYLabelSlideBack
  return number;
--v4.9.3
procedure setYLabelSlideBack(
  p_value number
  );
--v4.9.3
function getDefaultFontSize
  return number;
--v4.9.3
procedure setDefaultFontSize(
  p_value number
  );
--v4.9.3
function getTitlePadding
  return number;
--v4.9.3
procedure setTitlePadding(
  p_value number
  );
--v4.9.3
function getLegendSpacePieSide
  return number;
--v4.9.3
procedure setLegendSpacePieSide(
  p_value number
  );
--v4.9.3
function getLegendSpaceBarSide
  return number;
--v4.9.3
procedure setLegendSpaceBarSide(
  p_value number
  );
--v4.9.3
function getLegendIconSize
  return number;
--v4.9.3
procedure setLegendIconSize(
  p_value number
  );
--
end;
/

