create or replace package ploffx_xlsx_styles
authid current_user is
--v5.9
--
-- Namespaces
c_full_ns constant plx_sc.normalv2 := 'xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"';
ns_ssml constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/spreadsheetml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
-- Prefixes
ns_r_pref constant varchar(2 char) := 'r';
ns_mc_pref constant varchar2(2 char) := 'mc';
--
c_filename constant plx_sc.normalv2 := 'xl/styles.xml';

-- Tag
t_styleSheet   constant plx_sc.normalv2 := 'styleSheet';
t_numFmts      constant plx_sc.normalv2 := 'numFmts';
t_numFmt       constant plx_sc.normalv2 := 'numFmt';
t_fonts        constant plx_sc.normalv2 := 'fonts';
t_font         constant plx_sc.normalv2 := 'font';
t_colors       constant plx_sc.normalv2 := 'colors';
t_fills        constant plx_sc.normalv2 := 'fills';
t_fill         constant plx_sc.normalv2 := 'fill';
t_patternFill  constant plx_sc.normalv2 := 'patternFill';
t_fgColor      constant plx_sc.normalv2 := 'fgColor';
t_bgColor      constant plx_sc.normalv2 := 'bgColor';
t_borders      constant plx_sc.normalv2 := 'borders';
t_border       constant plx_sc.normalv2 := 'border';
t_cellStyleXfs constant plx_sc.normalv2 := 'cellStyleXfs';
t_xf           constant plx_sc.normalv2 := 'xf';
t_cellXfs      constant plx_sc.normalv2 := 'cellXfs';
t_alignment    constant plx_sc.normalv2 := 'alignment';
t_protection   constant plx_sc.normalv2 := 'protection';
t_cellStyles   constant plx_sc.normalv2 := 'cellStyles';
t_cellStyle    constant plx_sc.normalv2 := 'cellStyle';
t_dxfs         constant plx_sc.normalv2 := 'dxfs';
t_dxf          constant plx_sc.normalv2 := 'dxf';
t_tableStyles  constant plx_sc.normalv2 := 'tableStyles';
t_mruColors    constant plx_sc.normalv2 := 'mruColors';
--
t_color        constant plx_sc.normalv2 := 'color';
--
t_b            constant plx_sc.normalv2 := 'b';
t_charset      constant plx_sc.normalv2 := 'charset';
t_condense     constant plx_sc.normalv2 := 'condense';
t_extend       constant plx_sc.normalv2 := 'extend';
t_family       constant plx_sc.normalv2 := 'family';
t_i            constant plx_sc.normalv2 := 'i';
t_name         constant plx_sc.normalv2 := 'name';
t_outline      constant plx_sc.normalv2 := 'outline';
t_scheme       constant plx_sc.normalv2 := 'scheme';
t_shadow       constant plx_sc.normalv2 := 'shadow';
t_strike       constant plx_sc.normalv2 := 'strike';
t_sz           constant plx_sc.normalv2 := 'sz';
t_u            constant plx_sc.normalv2 := 'u';
t_vertAlign    constant plx_sc.normalv2 := 'vertAlign';
--
t_left         constant plx_sc.normalv2 := 'left';
t_right        constant plx_sc.normalv2 := 'right';
t_top          constant plx_sc.normalv2 := 'top';
t_bottom       constant plx_sc.normalv2 := 'bottom';
t_diagonal     constant plx_sc.normalv2 := 'diagonal';
t_vertical     constant plx_sc.normalv2 := 'vertical';
t_horizontal   constant plx_sc.normalv2 := 'horizontal';
--

-- XML
g_xml plx_sc.type_xdoc;

/******************************************************************/
--Structures

-- ST_TableStyleType
subtype ST_TableStyleType is ploffx_util.t_string;
c_wholeTable constant ST_TableStyleType :='wholeTable';
c_headerRow constant ST_TableStyleType :='headerRow';
c_totalRow constant ST_TableStyleType :='totalRow';
c_firstColumn constant ST_TableStyleType :='firstColumn';
c_lastColumn constant ST_TableStyleType :='lastColumn';
c_firstRowStripe constant ST_TableStyleType :='firstRowStripe';
c_secondRowStripe constant ST_TableStyleType :='secondRowStripe';
c_firstColumnStripe constant ST_TableStyleType :='firstColumnStripe';
c_secondColumnStripe constant ST_TableStyleType :='secondColumnStripe';
c_firstHeaderCell constant ST_TableStyleType :='firstHeaderCell';
c_lastHeaderCell constant ST_TableStyleType :='lastHeaderCell';
c_firstTotalCell constant ST_TableStyleType :='firstTotalCell';
c_lastTotalCell constant ST_TableStyleType :='lastTotalCell';
c_firstSubtotalColumn constant ST_TableStyleType :='firstSubtotalColumn';
c_secondSubtotalColumn constant ST_TableStyleType :='secondSubtotalColumn';
c_thirdSubtotalColumn constant ST_TableStyleType :='thirdSubtotalColumn';
c_firstSubtotalRow constant ST_TableStyleType :='firstSubtotalRow';
c_secondSubtotalRow constant ST_TableStyleType :='secondSubtotalRow';
c_thirdSubtotalRow constant ST_TableStyleType :='thirdSubtotalRow';
c_blankRow constant ST_TableStyleType :='blankRow';
c_firstColumnSubheading constant ST_TableStyleType :='firstColumnSubheading';
c_secondColumnSubheading constant ST_TableStyleType :='secondColumnSubheading';
c_thirdColumnSubheading constant ST_TableStyleType :='thirdColumnSubheading';
c_firstRowSubheading constant ST_TableStyleType :='firstRowSubheading';
c_secondRowSubheading constant ST_TableStyleType :='secondRowSubheading';
c_thirdRowSubheading constant ST_TableStyleType :='thirdRowSubheading';
c_pageFieldLabels constant ST_TableStyleType :='pageFieldLabels';
c_pageFieldValues constant ST_TableStyleType :='pageFieldValues';

-- ST_BorderStyle
subtype ST_BorderStyle is varchar2(20 char); -- Border Line Styles
c_none constant ST_BorderStyle := 'none';
c_thin constant ST_BorderStyle := 'thin'; --Thin Border
c_medium constant ST_BorderStyle := 'medium';
c_dashed constant ST_BorderStyle := 'dashed';
c_dotted constant ST_BorderStyle := 'dotted';
c_thick constant ST_BorderStyle := 'thick';
c_double constant ST_BorderStyle := 'double';
c_hair constant ST_BorderStyle := 'hair';
c_mediumDashed constant ST_BorderStyle := 'mediumDashed';
c_dashDot constant ST_BorderStyle := 'dashDot';
c_mediumDashDot constant ST_BorderStyle := 'mediumDashDot';
c_dashDotDot constant ST_BorderStyle := 'dashDotDot';
c_mediumDashDotDot constant ST_BorderStyle := 'mediumDashDotDot';
c_slantDashDot constant ST_BorderStyle := 'slantDashDot';
--
subtype ST_UnsignedIntHex is varchar2(8 char); --argb
c_Black constant ST_UnsignedIntHex := '000000';
c_Navy constant ST_UnsignedIntHex := '000080';
c_Dark_blue constant ST_UnsignedIntHex := '00008B';
c_Medium_blue constant ST_UnsignedIntHex := '0000CD';
c_Blue constant ST_UnsignedIntHex := '0000FF';
c_Dark_green constant ST_UnsignedIntHex := '006400';
c_Green constant ST_UnsignedIntHex := '008000';
c_Teal constant ST_UnsignedIntHex := '008080';
c_Dark_cyan constant ST_UnsignedIntHex := '008B8B';
c_Deep_sky_blue constant ST_UnsignedIntHex := '00BFFF';
c_Dark_turquoise constant ST_UnsignedIntHex := '00DED1';
c_Medium_spring_green constant ST_UnsignedIntHex := '00FA9A';
c_Lime constant ST_UnsignedIntHex := '00FF00';
c_Spring_green constant ST_UnsignedIntHex := '00FF7F';
c_Cyan constant ST_UnsignedIntHex := '00FFFF';
c_Midnight_blue constant ST_UnsignedIntHex := '191970';
c_Dodger_blue constant ST_UnsignedIntHex := '1E90FF';
c_Light_seagreen constant ST_UnsignedIntHex := '20B2AA';
c_Forest_green constant ST_UnsignedIntHex := '228B22';
c_Sea_green constant ST_UnsignedIntHex := '2E8B57';
c_Dark_slate_gray constant ST_UnsignedIntHex := '2F4F4F';
c_Lime_green constant ST_UnsignedIntHex := '32CD32';
c_Medium_sea_green constant ST_UnsignedIntHex := '3CB371';
c_Turquoise constant ST_UnsignedIntHex := '40E0D0';
c_Royal_blue constant ST_UnsignedIntHex := '4169E1';
c_Steelblue constant ST_UnsignedIntHex := '4682B4';
c_Dark_slate_blue constant ST_UnsignedIntHex := '483D8B';
c_Medium_turquoise constant ST_UnsignedIntHex := '48D1CC';
c_Indigo constant ST_UnsignedIntHex := '4B0082';
c_Dark_olive_green constant ST_UnsignedIntHex := '556B2F';
c_Cadet_blue constant ST_UnsignedIntHex := '5F9EA0';
c_Cornflower_blue constant ST_UnsignedIntHex := '6495ED';
c_Medium_aquamarine constant ST_UnsignedIntHex := '66CDAA';
c_Dim_gray constant ST_UnsignedIntHex := '696969';
c_Slate_blue constant ST_UnsignedIntHex := '6A5ACD';
c_Olive_drab constant ST_UnsignedIntHex := '6B8E23';
c_Light_slate_gray constant ST_UnsignedIntHex := '778899';
c_Medium_slate_blue constant ST_UnsignedIntHex := '7B68EE';
c_Lawngreen constant ST_UnsignedIntHex := '7CFC00';
c_Chartreuse constant ST_UnsignedIntHex := '7FFF00';
c_Aquamarine constant ST_UnsignedIntHex := '7FFFD4';
c_Maroon constant ST_UnsignedIntHex := '800000';
c_Purple constant ST_UnsignedIntHex := '800080';
c_Gray constant ST_UnsignedIntHex := '808080';
c_Sky_blue constant ST_UnsignedIntHex := '87CEEB';
c_Light_sky_blue constant ST_UnsignedIntHex := '87CEFA';
c_Blue_violet constant ST_UnsignedIntHex := '8A2BE2';
c_Dark_red constant ST_UnsignedIntHex := '8B0000';
c_Dark_magenta constant ST_UnsignedIntHex := '8B008B';
c_Saddle_brown constant ST_UnsignedIntHex := '8B4513';
c_Dark_seagreen constant ST_UnsignedIntHex := '8DBC8F';
c_Light_green constant ST_UnsignedIntHex := '90EE90';
c_Medium_purple constant ST_UnsignedIntHex := '9370DB';
c_Dark_violet constant ST_UnsignedIntHex := '9400D3';
c_Pale_green constant ST_UnsignedIntHex := '98FB98';
c_Dark_orchid constant ST_UnsignedIntHex := '9932CC';
c_Yellow_green constant ST_UnsignedIntHex := '9ACD32';
c_Sienna constant ST_UnsignedIntHex := 'A0522D';
c_Brown constant ST_UnsignedIntHex := 'A52A2A';
c_Dark_gray constant ST_UnsignedIntHex := 'A9A9A9';
c_Light_blue constant ST_UnsignedIntHex := 'ADD8E6';
c_Green_yellow constant ST_UnsignedIntHex := 'ADFF2F';
c_Pale_turquoise constant ST_UnsignedIntHex := 'AFEEEE';
c_Light_steel_blue constant ST_UnsignedIntHex := 'B0C4DE';
c_Powder_blue constant ST_UnsignedIntHex := 'B0E0E6';
c_Firebrick constant ST_UnsignedIntHex := 'B22222';
c_Dark_goldenrod constant ST_UnsignedIntHex := 'B8860B';
c_Medium_orchid constant ST_UnsignedIntHex := 'BA55D3';
c_Rosy_brown constant ST_UnsignedIntHex := 'BC8F8F';
c_Dark_khaki constant ST_UnsignedIntHex := 'BDB76B';
c_Silver constant ST_UnsignedIntHex := 'C0C0C0';
c_Medium_violet_red constant ST_UnsignedIntHex := 'C71585';
c_Indian_red constant ST_UnsignedIntHex := 'CD5C5C';
c_Peru constant ST_UnsignedIntHex := 'CD853F';
c_Chocolate constant ST_UnsignedIntHex := 'D2691E';
c_Tan constant ST_UnsignedIntHex := 'D2B48C';
c_Light_grey constant ST_UnsignedIntHex := 'D3D3D3';
c_Thistle constant ST_UnsignedIntHex := 'D8BFD8';
c_Orchid constant ST_UnsignedIntHex := 'DA70D6';
c_Goldenrod constant ST_UnsignedIntHex := 'DAA520';
c_Pale_violet_red constant ST_UnsignedIntHex := 'DB7093';
c_Crimson constant ST_UnsignedIntHex := 'DC143C';
c_Gainsboro constant ST_UnsignedIntHex := 'DCDCDC';
c_Plum constant ST_UnsignedIntHex := 'DDA0DD';
c_Burlywood constant ST_UnsignedIntHex := 'DEB887';
c_Mauve constant ST_UnsignedIntHex := 'E0B0FF';
c_Light_cyan constant ST_UnsignedIntHex := 'E0FFFF';
c_Lavender constant ST_UnsignedIntHex := 'E6E6FA';
c_Dark_salmon constant ST_UnsignedIntHex := 'E9967A';
c_Violet constant ST_UnsignedIntHex := 'EE82EE';
c_Pale_goldenrod constant ST_UnsignedIntHex := 'EEE8AA';
c_Light_coral constant ST_UnsignedIntHex := 'F08080';
c_Khaki constant ST_UnsignedIntHex := 'F0E68C';
c_Alice_blue constant ST_UnsignedIntHex := 'F0F8FF';
c_Honeydew constant ST_UnsignedIntHex := 'F0FFF0';
c_Azure constant ST_UnsignedIntHex := 'F0FFFF';
c_Sandy_brown constant ST_UnsignedIntHex := 'F4A460';
c_Wheat constant ST_UnsignedIntHex := 'F5DEB3';
c_Beige constant ST_UnsignedIntHex := 'F5F5DC';
c_Whitesmoke constant ST_UnsignedIntHex := 'F5F5F5';
c_Mint_cream constant ST_UnsignedIntHex := 'F5FFFA';
c_Ghost_white constant ST_UnsignedIntHex := 'F8F8FF';
c_Salmon constant ST_UnsignedIntHex := 'FA8072';
c_Antique_white constant ST_UnsignedIntHex := 'FAEBD7';
c_Linen constant ST_UnsignedIntHex := 'FAF0E6';
c_Light_goldenrod_yellow constant ST_UnsignedIntHex := 'FAFAD2';
c_Old_lace constant ST_UnsignedIntHex := 'FDF5E6';
c_Red constant ST_UnsignedIntHex := 'FF0000';
c_Magenta constant ST_UnsignedIntHex := 'FF00FF';
c_Deep_pink constant ST_UnsignedIntHex := 'FF1493';
c_Orange_red constant ST_UnsignedIntHex := 'FF4500';
c_Tomato constant ST_UnsignedIntHex := 'FF6347';
c_Hot_pink constant ST_UnsignedIntHex := 'FF69B4';
c_Coral constant ST_UnsignedIntHex := 'FF7F50';
c_Dark_orange constant ST_UnsignedIntHex := 'FF8C00';
c_Light_salmon constant ST_UnsignedIntHex := 'FFA07A';
c_Orange constant ST_UnsignedIntHex := 'FFA500';
c_Light_pink constant ST_UnsignedIntHex := 'FFB6C1';
c_Pink constant ST_UnsignedIntHex := 'FFC8CB';
c_Gold constant ST_UnsignedIntHex := 'FFD700';
c_Peach_puff constant ST_UnsignedIntHex := 'FFDAB9';
c_Navajo_white constant ST_UnsignedIntHex := 'FFDEAD';
c_Moccasin constant ST_UnsignedIntHex := 'FFE4B5';
c_Bisque constant ST_UnsignedIntHex := 'FFE4C4';
c_Misty_rose constant ST_UnsignedIntHex := 'FFE4E1';
c_Blanched_almond constant ST_UnsignedIntHex := 'FFEBCD';
c_Papaya_whip constant ST_UnsignedIntHex := 'FFEFD5';
c_Lavender_blush constant ST_UnsignedIntHex := 'FFF0F5';
c_Sea_shell constant ST_UnsignedIntHex := 'FFF5EE';
c_Cornsilk constant ST_UnsignedIntHex := 'FFF8DC';
c_Lemon_chiffon constant ST_UnsignedIntHex := 'FFFACD';
c_Floral_white constant ST_UnsignedIntHex := 'FFFAF0';
c_Snow constant ST_UnsignedIntHex := 'FFFAFA';
c_Yellow constant ST_UnsignedIntHex := 'FFFF00';
c_Light_yellow constant ST_UnsignedIntHex := 'FFFFE0';
c_Ivory constant ST_UnsignedIntHex := 'FFFFF0';
c_White constant ST_UnsignedIntHex := 'FFFFFF';
--
--ST_HorizontalAlignment
subtype ST_HorizontalAlignment is varchar2(20 char);
c_general constant ST_HorizontalAlignment := 'general';
c_left constant ST_HorizontalAlignment := 'left';
c_center constant ST_HorizontalAlignment := 'center';
c_right constant ST_HorizontalAlignment := 'right';
c_fill constant ST_HorizontalAlignment := 'fill';
c_justify constant ST_HorizontalAlignment := 'justify';
c_centerContinuous constant ST_HorizontalAlignment := 'centerContinuous';
c_distributed constant ST_HorizontalAlignment := 'distributed';

-- ST_VerticalAlignment
subtype ST_VerticalAlignment is varchar2(20 char);
c_top constant ST_VerticalAlignment := 'top';
-- c_center constant ST_VerticalAlignment := 'center';
c_bottom constant ST_VerticalAlignment := 'bottom';
c_justify constant ST_VerticalAlignment := 'justify';
c_distributed constant ST_VerticalAlignment := 'distributed';

--ST_UnderlineValues
subtype ST_UnderlineValues is ploffx_util.t_string;
c_single constant ST_UnderlineValues := 'single';
-- c_double constant ST_UnderlineValues := 'double';
c_singleAccounting constant ST_UnderlineValues := 'singleAccounting';
c_doubleAccounting constant ST_UnderlineValues := 'doubleAccounting';
-- c_none ST_UnderlineValues := 'none';

-- ST_VerticalAlignRun
subtype ST_VerticalAlignRun is ploffx_util.t_string;
c_baseline constant ST_VerticalAlignRun := 'baseline';
c_superscript constant ST_VerticalAlignRun := 'superscript';
c_subscript constant ST_VerticalAlignRun := 'subscript';

--ST_FontScheme
subtype ST_FontScheme is ploffx_util.t_string;
-- c_none constant ST_FontScheme := 'none';
c_major constant ST_FontScheme := 'major';
c_minor constant ST_FontScheme := 'minor';

-- ST_PatternType
subtype ST_PatternType is ploffx_util.t_string;
-- c_none constant ST_PatternType := 'none';
c_solid constant ST_PatternType := 'solid';
c_mediumGray constant ST_PatternType := 'mediumGray';
c_darkGray constant ST_PatternType := 'darkGray';
c_lightGray constant ST_PatternType := 'lightGray';
c_darkHorizontal constant ST_PatternType := 'darkHorizontal';
c_darkVertical constant ST_PatternType := 'darkVertical';
c_darkDown constant ST_PatternType := 'darkDown';
c_darkUp constant ST_PatternType := 'darkUp';
c_darkGrid constant ST_PatternType := 'darkGrid';
c_darkTrellis constant ST_PatternType := 'darkTrellis';
c_lightHorizontal constant ST_PatternType := 'lightHorizontal';
c_lightVertical constant ST_PatternType := 'lightVertical';
c_lightDown constant ST_PatternType := 'lightDown';
c_lightUp constant ST_PatternType := 'lightUp';
c_lightGrid constant ST_PatternType := 'lightGrid';
c_lightTrellis constant ST_PatternType := 'lightTrellis';
c_gray125 constant ST_PatternType := 'gray125';
c_gray0625 constant ST_PatternType := 'gray0625';

-- CT_FontName
type CT_FontName is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

-- CT_IntProperty
type CT_IntProperty is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

-- CT_BooleanProperty
type CT_BooleanProperty is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- xsd:boolean
  );

-- CT_FontSize
type CT_FontSize is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2 --xsd:double
  );

-- CT_UnderlineProperty
type CT_UnderlineProperty is record (
  tag plx_sc.normalv2,
  val ST_UnderlineValues
  );

-- CT_VerticalAlignFontProperty
type CT_VerticalAlignFontProperty is record (
  tag plx_sc.normalv2,
  val ST_VerticalAlignRun
  );

-- CT_FontScheme
type CT_FontScheme is record (
  tag plx_sc.normalv2,
  val ST_FontScheme
  );

-- CT_Color
type CT_Color is record( /*t_color_*/
  tag plx_sc.normalv2,
  auto plx_sc.normalv2, -- xsd:boolean
  indexed plx_sc.normalv2, -- pls_integer
  rgb ST_UnsignedIntHex,
  theme plx_sc.normalv2, -- pls_integer
  tint plx_sc.normalv2 -- number
  );
--
type t_color_ is table of CT_Color;
v_color_empty t_color_ := t_color_();

-- CT_MRUColors
type CT_MRUColors is record(
  tag plx_sc.normalv2,
  color t_color_
  );

-- CT_Colors
type CT_Colors is record(
  tag plx_sc.normalv2,
  -- indexedColors CT_IndexedColors
  mruColors CT_MRUColors
  );

-- CT_TableStyleElement
type CT_TableStyleElement is record(
  tag plx_sc.normalv2,
  type_ ST_TableStyleType,
  size_ plx_sc.normalv2, --xsd:unsignedInt
  dxfId plx_sc.normalv2 -- ST_DxfId (unsignedInt)
  );
--
type t_tableStyleElement_ is table of CT_TableStyleElement;
v_tableStyleElement_empty t_tableStyleElement_ := t_tableStyleElement_();

-- CT_TableStyle
type CT_TableStyle is record(
  tag plx_sc.normalv2,
  name_ plx_sc.normalv2,
  pivot plx_sc.normalv2,
  table_ plx_sc.normalv2,
  count_ plx_sc.normalv2,
  tableStyleElement t_tableStyleElement_
  );
--
type t_tableStyle_ is table of CT_TableStyle;
v_tableStyle_empty t_tableStyle_ := t_tableStyle_();

-- CT_TableStyles
type CT_TableStyles is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2, -- xsd:unsignedInt
  defaultTableStyle plx_sc.normalv2,
  defaultPivotStyle plx_sc.normalv2,
  tableStyle t_tableStyle_
  );

-- CT_CellStyle
type CT_CellStyle is record(
  tag plx_sc.normalv2,
  name plx_sc.normalv2, -- xsd:Xstring
  xfId plx_sc.normalv2, -- ST_CellStyleXfId (unsignedInt)
  builtinId plx_sc.normalv2, -- xsd:unsignedInt
  iLevel plx_sc.normalv2, -- xsd:unsignedInt
  hidden plx_sc.normalv2, -- xsd:boolean
  customBuiltin plx_sc.normalv2 -- xsd:boolean
  --extLst CT_ExtensionList not implemented
  );
--
type t_cellStyle_ is table of CT_CellStyle;
v_cellStyle_empty t_cellStyle_ := t_cellStyle_();

-- CT_CellStyles
type CT_CellStyles is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  cellStyle t_cellStyle_
  );

-- CT_CellAlignment
type CT_CellAlignment is record (
  tag plx_sc.normalv2,
  horizontal ST_HorizontalAlignment,
  vertical ST_VerticalAlignment,
  textRotation plx_sc.normalv2, -- xsd:unsignedInt
  wrapText plx_sc.normalv2, -- xsd:boolean
  indent plx_sc.normalv2, -- xsd:unsignedInt
  relativeIndent plx_sc.normalv2, -- xsd:unsignedInt
  justifyLastLine plx_sc.normalv2, -- xsd:boolean
  shrinkToFit plx_sc.normalv2, -- xsd:boolean
  readingOrder plx_sc.normalv2 -- xsd:unsignedInt
  );

-- CT_CellProtection
type CT_CellProtection is record (
  tag plx_sc.normalv2,
  locked plx_sc.normalv2, -- xsd:boolean
  hidden plx_sc.normalv2 -- xsd:boolean
  );

-- CT_Xf format
type CT_Xf is record(
  tag plx_sc.normalv2,
  numFmtId plx_sc.normalv2, -- ST_NumFmtId (unsignedInt)
  fontId plx_sc.normalv2, -- ST_FontId (unsignedInt)
  fillId plx_sc.normalv2, -- ST_FillId (unsignedInt)
  borderId plx_sc.normalv2, -- ST_BorderId (unsignedInt)
  xfId plx_sc.normalv2, -- ST_CellStyleXfId (unsignedInt)
  quotePrefix plx_sc.normalv2, -- xsd:boolean
  pivotButton plx_sc.normalv2, -- xsd:boolean
  applyNumberFormat plx_sc.normalv2, -- xsd:boolean
  applyFont plx_sc.normalv2, -- xsd:boolean
  applyFill plx_sc.normalv2, -- xsd:boolean
  applyBorder plx_sc.normalv2, -- xsd:boolean
  applyAlignment plx_sc.normalv2, -- xsd:boolean
  applyProtection plx_sc.normalv2, -- xsd:boolean
  alignment CT_CellAlignment,
  protection CT_CellProtection
  -- extLst exntension list
  );
--
type t_xf_ is table of CT_Xf;
v_xf_empty t_xf_ := t_xf_();


-- CT_CellXfs
type CT_CellXfs is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  xf t_xf_
  );

-- CT_CellStyleXfs
type CT_CellStyleXfs is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  xf t_xf_
  );

-- CT_BorderPr
type CT_BorderPr is record(
  tag plx_sc.normalv2,
  style ST_BorderStyle,
  color CT_Color
  );

-- CT_Border
type CT_Border is record(
  tag plx_sc.normalv2,
  diagonalUp plx_sc.normalv2, -- xsd:boolean
  diagonalDown plx_sc.normalv2, -- xsd:boolean
  outline plx_sc.normalv2, -- xsd:boolean
  left CT_BorderPr,
  right CT_BorderPr,
  top CT_BorderPr,
  bottom CT_BorderPr,
  diagonal CT_BorderPr,
  vertical CT_BorderPr,
  horizontal CT_BorderPr
  );
--
type t_border_ is table of CT_Border;
v_border_empty t_border_ := t_border_();

-- CT_Borders
type CT_Borders is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  border t_border_
  );

-- CT_PatternFill
type CT_PatternFill is record(
  tag plx_sc.normalv2,
  patternType ST_PatternType,
  bgColor CT_Color,
  fgColor CT_Color
  );

-- CT_Fill
type CT_Fill is record(
  tag plx_sc.normalv2,
  --gradientFill CT_GradientFill
  patternFill CT_PatternFill
  );
--
type t_fill_ is table of CT_Fill;
v_fill_empty t_fill_ := t_fill_();

-- CT_Fills
type CT_Fills is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  fill t_fill_
  );

-- CT_Font
type CT_Font is record(
  tag plx_sc.normalv2,
  name CT_fontName,
  charset CT_IntProperty,
  family CT_IntProperty,
  b CT_BooleanProperty,
  i CT_BooleanProperty,
  strike CT_BooleanProperty,
  outline CT_BooleanProperty,
  shadow CT_BooleanProperty,
  condense CT_BooleanProperty,
  extend_ CT_BooleanProperty,
  color CT_Color,
  sz CT_FontSize,
  u CT_UnderlineProperty,
  vertAlign CT_VerticalAlignFontProperty,
  scheme CT_FontScheme
  );
--
type t_font_ is table of CT_Font;
v_font_empty t_font_ := t_font_();

-- CT_Fonts
type CT_Fonts is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  font t_font_
  );

-- CT_NumFmt
type CT_NumFmt is record(
  tag plx_sc.normalv2,
  numFmtId plx_sc.normalv2, -- ST_NumFmtId (unsignedInt)
  formatCode plx_sc.normalv2
  );
--
type t_numFmt_ is table of CT_NumFmt;
v_numFmt_empty t_numFmt_ := t_numFmt_();

-- CT_NumFmts
type CT_NumFmts is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2, -- xsd:unsignedInt
  numFmt t_numFmt_
  );

-- CT_Dxf
type CT_Dxf is record(
  tag plx_sc.normalv2,
  font CT_Font,
  numFmt CT_NumFmt,
  fill CT_Fill,
  alignment CT_CellAlignment,
  border CT_Border,
  protection CT_CellProtection
  --extLst extension list
  );
--
type t_dxf_ is table of CT_Dxf;
v_dxf_empty t_dxf_ := t_dxf_();

-- CT_Dxfs
type CT_Dxfs is record(
  tag plx_sc.normalv2,
  count_ plx_sc.normalv2,
  dxf t_dxf_
  );

-- CT_Stylesheet
type CT_Stylesheet is record(
  tag plx_sc.normalv2,
  numFmts CT_NumFmts, --Number Formats
  fonts CT_Fonts, --Fonts
  fills CT_Fills, --Fills
  borders CT_Borders, --Borders
  cellStyleXfs CT_CellStyleXfs, --Formatting Records: combination of formattings (numberformat, fill,...)
  cellXfs CT_CellXfs, --Cell Format: master formating records for cell formating
  cellStyles CT_CellStyles, --Cell Styles: collection of named styles, used CT_CellStyleXfs
  dxfs CT_Dxfs, --Formats: formatting for all non-cell formatting
  tableStyles CT_TableStyles, --Table Styles
  colors CT_Colors --Colors
  -- extLst extension list
  );

/******************************************************************/
-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );

-- styleSheet
procedure startstyleSheet(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_styleSheet
  );
--
procedure endstyleSheet(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_styleSheet
  );

-- numFmts
procedure startnumFmts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numFmts,
  p_count varchar2 default null
  );
--
procedure endnumFmts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numFmts
  );

-- numFmt
procedure numFmt(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numFmt,
  p_numFmtId varchar2,
  p_formatCode varchar2
  );

-- fonts
procedure startfonts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fonts,
  p_count varchar2 default null
  );
--
procedure endfonts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fonts
  );

-- font
procedure startfont(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_font
  );
--
procedure endfont(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_font
  );

-- color
procedure color(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_color,
  p_auto varchar2 default null,
  p_indexed varchar2 default null,
  p_rgb varchar2 default null,
  p_theme varchar2 default null,
  p_tint varchar2 default null
  );

-- font
procedure font(
  p_name varchar2 default null,
  p_charset varchar2 default null,
  p_family varchar2 default null,
  p_b varchar2 default null,
  p_i varchar2 default null,
  p_strike varchar2 default null,
  p_outline varchar2 default null,
  p_shadow varchar2 default null,
  p_condense varchar2 default null,
  p_extend varchar2 default null,
  p_color varchar2 default null,
  p_sz varchar2 default null,
  p_u varchar2 default null,
  p_vertAlign varchar2 default null,
  p_scheme varchar2 default null
  );

-- fills
procedure startfills(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fills,
  p_count varchar2 default null
  );
--
procedure endfills(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fills
  );

-- fill
procedure startfill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fill
  );
--
procedure endfill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fill
  );

-- patternFill
procedure startpatternFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_patternFill,
  p_patternType varchar2 default null
  );
--
procedure endpatternFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_patternFill
  );

-- fgColor
procedure fgColor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fgColor,
  p_auto varchar2 default null,
  p_indexed varchar2 default null,
  p_rgb varchar2 default null,
  p_theme varchar2 default null,
  p_tint varchar2 default null
  );

-- bgColor
procedure bgColor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bgColor,
  p_auto varchar2 default null,
  p_indexed varchar2 default null,
  p_rgb varchar2 default null,
  p_theme varchar2 default null,
  p_tint varchar2 default null
  );

-- borders
procedure startborders(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_borders,
  p_count varchar2 default null
  );
--
procedure endborders(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_borders
  );

-- border
procedure startborder(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_border,
  p_diagonalUp varchar2 default null, -- xsd:boolean use=optional
  p_diagonalDown varchar2 default null, --xsd:boolean use=optional
  p_outline varchar2 default null  --xsd:boolean use=optional
  );
--
procedure endborder(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_border
  );
--
procedure border_( --simple solution
  p_tag   varchar2,
  p_style varchar2 default null,
  p_color varchar2 default null
  );
--
procedure border_no( --simple solution
  p_tag   varchar2
  );

-- left
procedure startleft(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_left,
  p_style varchar2 default null
  );
--
procedure endleft(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_left
  );

-- right
procedure startright(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_right,
  p_style varchar2 default null
  );
--
procedure endright(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_right
  );

-- top
procedure starttop(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_top,
  p_style varchar2 default null
  );
--
procedure endtop(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_top
  );

-- bottom
procedure startbottom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bottom,
  p_style varchar2 default null
  );
--
procedure endbottom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bottom
  );

-- diagonal
procedure startdiagonal(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_diagonal,
  p_style varchar2 default null
  );
--
procedure enddiagonal(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_diagonal
  );

-- vertical
procedure startvertical(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_vertical,
  p_style varchar2 default null
  );
--
procedure endvertical(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_vertical
  );

-- horizontal
procedure starthorizontal(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_horizontal,
  p_style varchar2 default null
  );
--
procedure endhorizontal(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_horizontal
  );

-- cellStyleXfs
procedure startcellStyleXfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyleXfs,
  p_count varchar2 default null
  );
--
procedure endcellStyleXfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyleXfs
  );

-- xf
procedure startxf(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xf,
  p_numFmtId varchar2 default null,
  p_fontId varchar2 default null,
  p_fillId varchar2 default null,
  p_borderId varchar2 default null,
  p_xfId varchar2 default null,
  p_quotePrefix varchar2 default null,
  p_pivotButton varchar2 default null,
  p_applyNumberFormat varchar2 default null,
  p_applyFont varchar2 default null,
  p_applyFill varchar2 default null,
  p_applyBorder varchar2 default null,
  p_applyAlignment varchar2 default null,
  p_applyProtection varchar2 default null
  );
--
procedure endxf(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xf
  );

-- cellXfs
procedure startcellXfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellXfs,
  p_count varchar2 default null
  );
--
procedure endcellXfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellXfs
  );

-- alignment
procedure alignment(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_alignment,
  p_horizontal varchar2 default null,
  p_vertical varchar2 default null,
  p_textRotation varchar2 default null,
  p_wrapText varchar2 default null,
  p_indent varchar2 default null,
  p_relativeIndent varchar2 default null,
  p_justifyLastLine varchar2 default null,
  p_shrinkToFit varchar2 default null,
  p_readingOrder varchar2 default null
  );

-- protection
procedure protection(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_protection,
  p_hidden varchar2 default null,
  p_locked varchar2 default null
  );

-- cellStyles
procedure startcellStyles(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyles,
  p_count varchar2 default null
  );
--
procedure endcellStyles(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyles
  );

-- cellStyle
procedure startcellStyle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyle,
  p_name varchar2 default null,
  p_xfId varchar2 default null,
  p_builtinId varchar2 default null,
  p_iLevel varchar2 default null,
  p_hidden varchar2 default null,
  p_customBuiltin varchar2 default null
  );
--
procedure endcellStyle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cellStyle
  );

-- dxfs
procedure startdxfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dxfs,
  p_count varchar2 default null
  );
--
procedure enddxfs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dxfs
  );

-- tableStyles
procedure starttableStyles(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tableStyles,
  p_count varchar2 default null,
  p_defaultTableStyle varchar2 default null,
  p_defaultPivotStyle varchar2 default null
  );
--
procedure endtableStyles(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tableStyles
  );

-- colors
procedure startcolors(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_colors
  );
--
procedure endcolors(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_colors
  );

-- mruColors
procedure startmruColors(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_mruColors
  );
--
procedure endmruColors(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_mruColors
  );

-- b
procedure b(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_b,
  p_val varchar2 default null
  );

-- charset
procedure charset(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_charset,
  p_val varchar2 -- xsd:int
  );

-- condense
procedure condense(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_condense,
  p_val varchar2 default null
  );

-- extend
procedure extend_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_extend,
  p_val varchar default null
  );

-- family
procedure family(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_family,
  p_val varchar2 -- xds:int
  );

-- i
procedure i(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_i,
  p_val varchar2 default null
  );

-- name
procedure name_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_name,
  p_val varchar2 default null
  );

-- outline
procedure outline(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_outline,
  p_val varchar2 default null
  );

-- scheme
procedure scheme(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_scheme,
  p_val varchar2
  );

-- shadow
procedure shadow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shadow,
  p_val varchar2 default null
  );

-- strike
procedure strike(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_strike,
  p_val varchar2 default null
  );

-- sz
procedure sz(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_sz,
  p_val varchar2 -- xsd:double
  );

-- u
procedure u(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_u,
  p_val varchar2 default null -- ST_UnderlineValues
  );

-- vertalign
procedure vertAlign(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_vertAlign,
  p_val varchar2 -- ST_VerticalAlignRun
  );


/******************************************************************/
-- Create structure

------------------------------------------
-- styleSheet: CT_Stylesheet
function cr_styleSheet(
  p_tag plx_sc.normalv2 default t_styleSheet,
  p_numFmts CT_NumFmts default null,
  p_fonts CT_Fonts default null,
  p_fills CT_Fills default null,
  p_borders CT_Borders default null,
  p_cellStyleXfs CT_CellStyleXfs default null,
  p_cellXfs CT_CellXfs default null,
  p_cellStyles CT_CellStyles default null,
  p_dxfs CT_Dxfs default null,
  p_tableStyles CT_TableStyles default null,
  p_colors CT_Colors default null
  -- extLst extension list
  ) return CT_Stylesheet;

------------------------------------------
-- dxfs: CT_Dxfs
function cr_dxfs(
  p_tag plx_sc.normalv2 default t_dxfs,
  p_count_ plx_sc.normalv2 default null,
  p_dxf t_dxf_ default null
  ) return CT_Dxfs;

------------------------------------------
-- dxf: CT_Dxf
function cr_dxf(
  p_tag plx_sc.normalv2 default t_dxf,
  p_font CT_Font default null,
  p_numFmt CT_NumFmt default null,
  p_fill CT_Fill default null,
  p_alignment CT_CellAlignment default null,
  p_border CT_Border default null,
  p_protection CT_CellProtection default null
  --extLst extension list
  ) return CT_Dxf;
-- dxf : t_dxf_
procedure add_dxf(
  p_table in out t_dxf_,
  p_dxf CT_Dxf
  );

------------------------------------------
-- numFmts: CT_NumFmts
function cr_numFmts(
  p_tag plx_sc.normalv2 default t_numFmts,
  p_count_ plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_numFmt t_numFmt_ default null
  ) return CT_NumFmts;

------------------------------------------
-- numfmt: CT_NumFmt
function cr_numFmt(
  p_tag plx_sc.normalv2 default t_numFmt,
  p_numFmtId plx_sc.normalv2 default null, -- ST_NumFmtId (unsignedInt)
  p_formatCode plx_sc.normalv2 default null
  ) return CT_NumFmt;
-- numfmt: t_numFmt_
procedure add_numFmt(
  p_table in out t_numFmt_,
  p_numFmt CT_NumFmt
  );

------------------------------------------
-- fonts: CT_Fonts
function cr_fonts(
  p_tag plx_sc.normalv2 default t_fonts,
  p_count_ plx_sc.normalv2 default null,
  p_font t_font_ default null
  ) return CT_Fonts;

------------------------------------------
-- font: CT_Font
function cr_font(
  p_tag plx_sc.normalv2 default t_font,
  p_name CT_fontName default null,
  p_charset CT_IntProperty default null,
  p_family CT_IntProperty default null,
  p_b CT_BooleanProperty default null,
  p_i CT_BooleanProperty default null,
  p_strike CT_BooleanProperty default null,
  p_outline CT_BooleanProperty default null,
  p_shadow CT_BooleanProperty default null,
  p_condense CT_BooleanProperty default null,
  p_extend_ CT_BooleanProperty default null,
  p_color CT_Color default null,
  p_sz CT_FontSize default null,
  p_u CT_UnderlineProperty default null,
  p_vertAlign CT_VerticalAlignFontProperty default null,
  p_scheme CT_FontScheme default null
  ) return CT_Font;
-- font: t_font_
procedure add_font(
  p_table in out t_font_,
  p_font CT_Font
  );

------------------------------------------
-- fills: CT_Fills
function cr_fills(
  p_tag plx_sc.normalv2 default t_fills,
  p_count_ plx_sc.normalv2 default null,
  p_fill t_fill_ default null
  ) return CT_Fills;

------------------------------------------
-- fill: CT_Fill
function cr_fill(
  p_tag plx_sc.normalv2 default t_fill,
  p_patternFill CT_PatternFill default null
  --gradientFill CT_GradientFill
  ) return CT_Fill;
-- fill: t_fill_
procedure add_fill(
  p_table in out t_fill_,
  p_fill CT_Fill
  );

------------------------------------------
-- patternFill: CT_PatternFill
function cr_patternFill(
  p_tag plx_sc.normalv2 default t_patternFill,
  p_patternType ST_PatternType default null,
  p_bgColor CT_Color default null,
  p_fgColor CT_Color default null
  ) return CT_PatternFill;

------------------------------------------
-- bgColor: CT_Color
function cr_bgColor(
  p_tag plx_sc.normalv2 default t_bgColor,
  p_auto plx_sc.normalv2 default null,
  p_indexed plx_sc.normalv2 default null,
  p_rgb ST_UnsignedIntHex default null,
  p_theme plx_sc.normalv2 default null,
  p_tint plx_sc.normalv2 default null
  ) return CT_Color;

------------------------------------------
-- fgColor: CT_Color
function cr_fgColor(
  p_tag plx_sc.normalv2 default t_fgColor,
  p_auto plx_sc.normalv2 default null,
  p_indexed plx_sc.normalv2 default null,
  p_rgb ST_UnsignedIntHex default null,
  p_theme plx_sc.normalv2 default null,
  p_tint plx_sc.normalv2 default null
  ) return CT_Color;

------------------------------------------
-- borders: CT_Borders
function cr_borders(
  p_tag plx_sc.normalv2 default t_borders,
  p_count_ plx_sc.normalv2 default null,
  p_border t_border_ default null
  ) return CT_Borders;

------------------------------------------
-- border: CT_Border
function cr_border(
  p_tag plx_sc.normalv2 default t_border,
  p_diagonalUp plx_sc.normalv2 default null, -- xsd:boolean
  p_diagonalDown plx_sc.normalv2 default null, -- xsd:boolean
  p_outline plx_sc.normalv2 default null, -- xsd:boolean
  p_left CT_BorderPr default null,
  p_right CT_BorderPr default null,
  p_top CT_BorderPr default null,
  p_bottom CT_BorderPr default null,
  p_diagonal CT_BorderPr default null,
  p_vertical CT_BorderPr default null,
  p_horizontal CT_BorderPr default null
  ) return CT_Border;
-- border: t_border_
procedure add_border(
  p_table in out t_border_,
  p_border CT_Border
  );

------------------------------------------
-- left: CT_BorderPr
function cr_left(
  p_tag plx_sc.normalv2 default t_left,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- right: CT_BorderPr
function cr_right(
  p_tag plx_sc.normalv2 default t_right,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- top: CT_BorderPr
function cr_top(
  p_tag plx_sc.normalv2 default t_top,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- bottom: CT_BorderPr
function cr_bottom(
  p_tag plx_sc.normalv2 default t_bottom,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- diagonal: CT_BorderPr
function cr_diagonal(
  p_tag plx_sc.normalv2 default t_diagonal,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- vertical: CT_BorderPr
function cr_vertical(
  p_tag plx_sc.normalv2 default t_vertical,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- horizontal: CT_BorderPr
function cr_horizontal(
  p_tag plx_sc.normalv2 default t_horizontal,
  p_style ST_BorderStyle default null,
  p_color CT_Color default null
  ) return CT_BorderPr;

------------------------------------------
-- cellStyleXfs: CT_CellStyleXfs
function cr_cellStyleXfs(
  p_tag plx_sc.normalv2 default t_cellStyleXfs,
  p_count_ plx_sc.normalv2 default null,
  p_xf t_xf_ default null
  ) return CT_CellStyleXfs;

------------------------------------------
-- cellXfs CT_CellXfs
function cr_cellXfs(
  p_tag plx_sc.normalv2 default t_cellXfs,
  p_count_ plx_sc.normalv2 default null,
  p_xf t_xf_ default null
  ) return CT_CellXfs;

------------------------------------------
-- xf: CT_Xf
function cr_xf(
  p_tag plx_sc.normalv2 default t_xf,
  p_numFmtId plx_sc.normalv2 default null, -- ST_NumFmtId (unsignedInt)
  p_fontId plx_sc.normalv2 default null, -- ST_FontId (unsignedInt)
  p_fillId plx_sc.normalv2 default null, -- ST_FillId (unsignedInt)
  p_borderId plx_sc.normalv2 default null, -- ST_BorderId (unsignedInt)
  p_xfId plx_sc.normalv2 default null, -- ST_CellStyleXfId (unsignedInt)
  p_quotePrefix plx_sc.normalv2 default null, -- xsd:boolean
  p_pivotButton plx_sc.normalv2 default null, -- xsd:boolean
  p_applyNumberFormat plx_sc.normalv2 default null, -- xsd:boolean
  p_applyFont plx_sc.normalv2 default null, -- xsd:boolean
  p_applyFill plx_sc.normalv2 default null, -- xsd:boolean
  p_applyBorder plx_sc.normalv2 default null, -- xsd:boolean
  p_applyAlignment plx_sc.normalv2 default null, -- xsd:boolean
  p_applyProtection plx_sc.normalv2 default null, -- xsd:boolean
  p_alignment CT_CellAlignment default null,
  p_protection CT_CellProtection default null
  -- extLst exntension list
  ) return CT_Xf;
-- xf: t_xf_
procedure add_xf(
  p_table in out t_xf_,
  p_xf CT_Xf
  );

------------------------------------------
-- protection: CT_CellProtection
function cr_protection(
  p_tag plx_sc.normalv2 default t_protection,
  p_locked plx_sc.normalv2 default null, -- xsd:boolean
  p_hidden plx_sc.normalv2 default null -- xsd:boolean
  ) return CT_CellProtection;

------------------------------------------
-- alignment: CT_CellAlignment
function cr_alignment(
  p_tag plx_sc.normalv2 default t_alignment,
  p_horizontal ST_HorizontalAlignment default null,
  p_vertical ST_VerticalAlignment default null,
  p_textRotation plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_wrapText plx_sc.normalv2 default null, -- xsd:boolean
  p_indent plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_relativeIndent plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_justifyLastLine plx_sc.normalv2 default null, -- xsd:boolean
  p_shrinkToFit plx_sc.normalv2 default null, -- xsd:boolean
  p_readingOrder plx_sc.normalv2 default null -- xsd:unsignedInt
  ) return CT_CellAlignment;

------------------------------------------
-- cellStyles: CT_CellStyles
function cr_cellStyles(
  p_tag plx_sc.normalv2 default t_cellStyles,
  p_count_ plx_sc.normalv2 default null,
  p_cellStyle t_cellStyle_ default null
  ) return CT_CellStyles;

------------------------------------------
-- cellStyle: CT_CellStyle
function cr_cellStyle(
  p_tag plx_sc.normalv2 default t_cellStyle,
  p_name plx_sc.normalv2 default null, -- xsd:Xstring
  p_xfId plx_sc.normalv2 default null, -- ST_CellStyleXfId (unsignedInt)
  p_builtinId plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_iLevel plx_sc.normalv2  default null, -- xsd:unsignedInt
  p_hidden plx_sc.normalv2 default null, -- xsd:boolean
  p_customBuiltin plx_sc.normalv2 default null -- xsd:boolean
  --extLst CT_ExtensionList not implemented
  ) return CT_CellStyle;
-- cellStyle: t_cellStyle_
procedure add_cellStyle(
  p_table in out t_cellStyle_,
  p_cellStyle CT_CellStyle
  );

------------------------------------------
-- tableStyles: CT_TableStyles
function cr_tableStyles(
  p_tag plx_sc.normalv2 default t_tableStyles,
  p_count_ plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_defaultTableStyle plx_sc.normalv2 default null,
  p_defaultPivotStyle plx_sc.normalv2 default null
  --tableStyle t_tableStyle_
  ) return CT_TableStyles;

------------------------------------------
-- colors: CT_Colors
function cr_colors(
  p_tag plx_sc.normalv2 default t_colors,
  -- indexedColors CT_IndexedColors
  p_mruColors CT_MRUColors default null
  ) return CT_Colors;

------------------------------------------
-- mruColors: CT_MRUColors
function cr_mruColors(
  p_tag plx_sc.normalv2 default t_mruColors,
  p_color t_color_ default null
  ) return CT_MRUColors;

------------------------------------------
-- charset: CT_IntProperty
function cr_charset(
  p_tag plx_sc.normalv2 default t_charset,
  p_val plx_sc.normalv2 default null
  ) return CT_IntProperty;

------------------------------------------
-- family: CT_IntProperty
function cr_family(
  p_tag plx_sc.normalv2 default t_family,
  p_val plx_sc.normalv2 default null
  ) return CT_IntProperty;

------------------------------------------
-- b: CT_BooleanProperty
function cr_b(
  p_tag plx_sc.normalv2 default t_b,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- i: CT_BooleanProperty
function cr_i(
  p_tag plx_sc.normalv2 default t_i,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- name: CT_FontName
function cr_name(
  p_tag plx_sc.normalv2 default t_name,
  p_val plx_sc.normalv2 default null
  ) return CT_FontName;

------------------------------------------
-- strike: CT_BooleanProperty
function cr_strike(
  p_tag plx_sc.normalv2 default t_strike,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- outline: CT_BooleanProperty
function cr_outline(
  p_tag plx_sc.normalv2 default t_outline,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- shadow: CT_BooleanProperty
function cr_shadow(
  p_tag plx_sc.normalv2 default t_shadow,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- condense: CT_BooleanProperty
function cr_condense(
  p_tag plx_sc.normalv2 default t_condense,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- extend: CT_BooleanProperty
function cr_extend(
  p_tag plx_sc.normalv2 default t_extend,
  p_val plx_sc.normalv2 default null
  ) return CT_BooleanProperty;

------------------------------------------
-- color: CT_Color
function cr_color(
  p_tag plx_sc.normalv2 default t_color,
  p_auto plx_sc.normalv2 default null,
  p_indexed plx_sc.normalv2 default null,
  p_rgb ST_UnsignedIntHex default null,
  p_theme plx_sc.normalv2 default null,
  p_tint plx_sc.normalv2 default null
  ) return CT_Color;
------------------------------------------
-- color: t_color
procedure add_color(
  p_table in out t_color_,
  p_color CT_Color
  );
------------------------------------------
-- sz: CT_FontSize
function cr_sz(
  p_tag plx_sc.normalv2 default t_sz,
  p_val plx_sc.normalv2
  ) return CT_FontSize;

------------------------------------------
-- u: CT_UnderlineProperty
function cr_u(
  p_tag plx_sc.normalv2 default t_u,
  p_val ST_UnderlineValues
  ) return CT_UnderlineProperty;

------------------------------------------
-- scheme: CT_FontScheme
function cr_scheme(
  p_tag plx_sc.normalv2 default t_scheme,
  p_val ST_FontScheme
  ) return CT_FontScheme;

------------------------------------------
-- vertAlign: CT_VerticalAlignFontProperty
function cr_vertAlign(
  p_tag plx_sc.normalv2 default t_vertAlign,
  p_val ST_VerticalAlignRun
  ) return CT_VerticalAlignFontProperty;

/******************************************************************/
-- Generate XML part

---------------------------------------
-- charset: CT_IntProperty
procedure gen_charset(
  p_xml in out plx_sc.type_xdoc ,
  p_charset CT_IntProperty
  );

------------------------------------------
-- family: CT_IntProperty
procedure gen_family(
  p_xml in out plx_sc.type_xdoc ,
  p_family CT_IntProperty
  );

------------------------------------------
-- b: CT_BooleanProperty
procedure gen_b(
  p_xml in out plx_sc.type_xdoc ,
  p_b CT_BooleanProperty
  );

------------------------------------------
-- i: CT_BooleanProperty
procedure gen_i(
  p_xml in out plx_sc.type_xdoc ,
  p_i CT_BooleanProperty
  );

------------------------------------------
-- strike: CT_BooleanProperty
procedure gen_strike(
  p_xml in out plx_sc.type_xdoc ,
  p_strike CT_BooleanProperty
  );

------------------------------------------
-- outline: CT_BooleanProperty
procedure gen_outline(
  p_xml in out plx_sc.type_xdoc ,
  p_outline CT_BooleanProperty
  );

------------------------------------------
-- shadow: CT_BooleanProperty
procedure gen_shadow(
  p_xml in out plx_sc.type_xdoc ,
  p_shadow CT_BooleanProperty
  );

------------------------------------------
-- condense: CT_BooleanProperty
procedure gen_condense(
  p_xml in out plx_sc.type_xdoc ,
  p_condense CT_BooleanProperty
  );

------------------------------------------
-- extend: CT_BooleanProperty
procedure gen_extend(
  p_xml in out plx_sc.type_xdoc ,
  p_extend CT_BooleanProperty
  );

------------------------------------------
-- color: CT_Color
procedure gen_color(
  p_xml in out plx_sc.type_xdoc ,
  p_color ploffx_xlsx_styles.CT_Color
  );

------------------------------------------
-- sz: CT_FontSize
procedure gen_sz(
  p_xml in out plx_sc.type_xdoc ,
  p_Sz CT_FontSize
  );

------------------------------------------
-- u: CT_UnderlineProperty
procedure gen_u(
  p_xml in out plx_sc.type_xdoc ,
  p_u CT_UnderlineProperty
  );

------------------------------------------
-- scheme: CT_FontScheme
procedure gen_scheme(
  p_xml in out plx_sc.type_xdoc ,
  p_scheme CT_FontScheme
  );

------------------------------------------
-- vertAlign: CT_VerticalAlignFontProperty
procedure gen_vertAlign(
  p_xml in out plx_sc.type_xdoc ,
  p_vertAlign CT_VerticalAlignFontProperty
  );

------------------------------------------
-- mruColors: CT_MRUColors
procedure gen_mruColors(
  p_xml in out plx_sc.type_xdoc,
  p_mruColors CT_MRUColors
  );

------------------------------------------
-- colors: CT_Colors
procedure gen_colors(
  p_xml in out plx_sc.type_xdoc,
  p_colors CT_Colors
  );

------------------------------------------
-- tableStyles: CT_TableStyles
procedure gen_tableStyles(
  p_xml in out plx_sc.type_xdoc,
  p_tableStyles CT_TableStyles
  );

------------------------------------------
-- cellStyle: CT_CellStyle
procedure gen_cellStyle(
  p_xml in out plx_sc.type_xdoc,
  p_cellStyle CT_CellStyle
  );

------------------------------------------
-- cellStyles: CT_CellStyles
procedure gen_cellStyles(
  p_xml in out plx_sc.type_xdoc,
  p_cellStyles CT_CellStyles
  );

------------------------------------------
-- protection: CT_CellProtection
procedure gen_protection(
  p_xml in out plx_sc.type_xdoc,
  p_protection CT_CellProtection
  );

------------------------------------------
-- alignment: CT_CellAlignment
procedure gen_alignment(
  p_xml in out plx_sc.type_xdoc,
  p_alignment CT_CellAlignment
  );

------------------------------------------
-- xf: CT_Xf
procedure gen_xf(
  p_xml in out plx_sc.type_xdoc,
  p_xf CT_Xf
  );

------------------------------------------
-- cellXfs: CT_CellXfs
procedure gen_cellXfs(
  p_xml in out plx_sc.type_xdoc,
  p_cellXfs CT_CellXfs
  );

------------------------------------------
-- cellStyleXfs: CT_CellStyleXfs
procedure gen_cellStyleXfs(
  p_xml in out plx_sc.type_xdoc,
  p_cellStyleXfs CT_CellStyleXfs
  );

------------------------------------------
-- left: CT_BorderPr
procedure gen_left(
  p_xml in out plx_sc.type_xdoc,
  p_left CT_BorderPr
  );

------------------------------------------
-- right: CT_BorderPr
procedure gen_right(
  p_xml in out plx_sc.type_xdoc,
  p_right CT_BorderPr
  );

------------------------------------------
-- top: CT_BorderPr
procedure gen_top(
  p_xml in out plx_sc.type_xdoc,
  p_top CT_BorderPr
  );

------------------------------------------
-- bottom: CT_BorderPr
procedure gen_bottom(
  p_xml in out plx_sc.type_xdoc,
  p_bottom CT_BorderPr
  );

------------------------------------------
-- diagonal: CT_BorderPr
procedure gen_diagonal(
  p_xml in out plx_sc.type_xdoc,
  p_diagonal CT_BorderPr
  );

------------------------------------------
-- vertical: CT_BorderPr
procedure gen_vertical(
  p_xml in out plx_sc.type_xdoc,
  p_vertical CT_BorderPr
  );

------------------------------------------
-- horizontal: CT_BorderPr
procedure gen_horizontal(
  p_xml in out plx_sc.type_xdoc,
  p_horizontal CT_BorderPr
  );

------------------------------------------
-- border: CT_Border
procedure gen_border(
  p_xml in out plx_sc.type_xdoc,
  p_border CT_Border
  );

------------------------------------------
-- borders: CT_Borders
procedure gen_borders(
  p_xml in out plx_sc.type_xdoc,
  p_borders CT_Borders
  );

------------------------------------------
-- fgColor: CT_Color
procedure gen_fgColor(
  p_xml in out plx_sc.type_xdoc,
  p_fgColor CT_Color
  );

------------------------------------------
-- bgColor: CT_Color
procedure gen_bgColor(
  p_xml in out plx_sc.type_xdoc,
  p_bgColor CT_Color
  );

------------------------------------------
-- patternFill: CT_PatternFill
procedure gen_patternFill(
  p_xml in out plx_sc.type_xdoc,
  p_patternFill CT_PatternFill
  );

------------------------------------------
-- fill: CT_Fill
procedure gen_fill(
  p_xml in out plx_sc.type_xdoc,
  p_fill CT_Fill
  );

------------------------------------------
-- fills: CT_Fills
procedure gen_fills(
  p_xml in out plx_sc.type_xdoc,
  p_fills CT_Fills
  );

------------------------------------------
-- font: CT_font
procedure gen_font(
  p_xml in out plx_sc.type_xdoc,
  p_font CT_Font
  );

------------------------------------------
-- fonts: CT_Fonts
procedure gen_fonts(
  p_xml in out plx_sc.type_xdoc,
  p_fonts CT_Fonts
  );

------------------------------------------
-- numFmt: CT_numFmt
procedure gen_numFmt(
  p_xml in out plx_sc.type_xdoc,
  p_numFmt CT_NumFmt
  );

------------------------------------------
-- numFmts: CT_NumFmts
procedure gen_numFmts(
  p_xml in out plx_sc.type_xdoc,
  p_numFmts CT_NumFmts
  );

------------------------------------------
-- dxf: CT_Dxf
procedure gen_dxf(
  p_xml in out plx_sc.type_xdoc,
  p_dxf CT_Dxf
  );

------------------------------------------
-- dxfs: CT_Dxfs
procedure gen_dxfs(
  p_xml in out plx_sc.type_xdoc,
  p_dxfs CT_Dxfs
  );

------------------------------------------
-- styleSheet: CT_Stylesheet
procedure gen_styleSheet(
  p_xml in out plx_sc.type_xdoc,
  p_styleSheet CT_Stylesheet
  );

------------------------------------------
-- GEN_XML
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_styleSheet CT_Stylesheet
  );

------------------------------------------
-- PARSE_XML
function parse(
  p_file clob
  ) return CT_Stylesheet;
--
--
function getFormatmaskbyID(
  p_table t_numFmt_,
  p_id pls_integer
  ) return varchar2;
--
function getDefFormatmaskID(
  p_format_mask varchar2
  ) return pls_integer;
--
function isDateFormat(
  p_format_mask varchar2
  ) return boolean;
--
function equal_fill(
  p_1 CT_Fill,
  p_2 CT_Fill
  ) return boolean;
--
function equal_border(
  p_1 CT_Border,
  p_2 CT_Border
  ) return boolean;
--
function equal_xf(
  p_1 CT_Xf,
  p_2 CT_Xf
  ) return boolean;
--
end ploffx_xlsx_styles;
/

