create or replace package ploffx_websettings
authid current_user is
--v5.9
--
-- Namespaces
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';

-- Prefixes
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_w_pref constant varchar2(1 char) := 'w';
ns_r_pref constant varchar2(1 char) := 'r';
ns_mc_pref constant varchar2(2 char) := 'mc';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_allowPNG constant plx_sc.normalv2 := 'allowPNG'; --v1.3.0
t_blockQuote constant plx_sc.normalv2 := 'blockQuote'; --v1.3.0
t_bodyDiv constant plx_sc.normalv2 := 'bodyDiv'; --v1.3.0
t_color constant plx_sc.normalv2 := 'color'; -- v1.3.0
t_divBdr constant plx_sc.normalv2 := 'divBdr'; --v1.3.0
t_divs constant plx_sc.normalv2 := 'divs'; --v1.3.0
t_divsChild constant plx_sc.normalv2 := 'divsChild'; --v1.3.0
t_div constant plx_sc.normalv2 := 'div'; --v1.3.0
t_doNotOrganizeInFolder constant plx_sc.normalv2 := 'doNotOrganizeInFolder'; --v1.3.0
t_doNotRelyOnCSS constant plx_sc.normalv2 := 'doNotRelyOnCSS'; --v1.3.0
t_doNotSaveAsSingleFile constant plx_sc.normalv2 := 'doNotSaveAsSingleFile'; --v1.3.0
t_doNotUseLongFileNames constant plx_sc.normalv2 := 'doNotUseLongFileNames'; --v1.3.0
t_encoding constant plx_sc.normalv2 := 'encoding'; --v1.3.0
t_flatBorders constant plx_sc.normalv2 := 'flatBorders'; -- v1.3.0
t_frame constant plx_sc.normalv2 := 'frame'; --v1.3.0
t_frameLayout constant plx_sc.normalv2 := 'frameLayout'; --v1.3.0
t_frameset constant plx_sc.normalv2 := 'frameset'; --v1.3.0
t_framesetSplitbar constant plx_sc.normalv2 := 'framesetSplitbar'; --v1.3.0
t_linkedToFile constant plx_sc.normalv2 := 'linkedToFile'; --v1.3.0
t_marBottom constant plx_sc.normalv2 := 'marBottom'; --v1.3.0
t_marH constant plx_sc.normalv2 := 'marH'; --v1.3.0
t_marLeft constant plx_sc.normalv2 := 'marLeft'; --v1.3.0
t_marRight constant plx_sc.normalv2 := 'marRight'; --v1.3.0
t_marTop constant plx_sc.normalv2 := 'marTop'; --v1.3.0
t_marW constant plx_sc.normalv2 := 'marW'; --v1.3.0
t_name constant plx_sc.normalv2 := 'name'; --v1.3.0
t_noBorder constant plx_sc.normalv2 := 'noBorder'; --v1.3.0
t_noResizeAllowed constant plx_sc.normalv2 := 'noResizeAllowed'; --v1.3.0
t_optimizeForBrowser constant plx_sc.normalv2 := 'optimizeForBrowser';
t_pixelsPerInch constant plx_sc.normalv2 := 'pixelsPerInch'; --v1.3.0
t_relyOnVML constant plx_sc.normalv2 := 'relyOnVML'; --v1.3.0
t_scrollbar constant plx_sc.normalv2 := 'scrollbar'; --v1.3.0
t_sourceFileName constant plx_sc.normalv2 := 'sourceFileName'; --v1.3.0
t_saveSmartTagsAsXml constant plx_sc.normalv2 := 'saveSmartTagsAsXml'; --v1.3.0
t_sz constant plx_sc.normalv2 := 'sz';
t_targetScreenSz constant plx_sc.normalv2 := 'targetScreenSz'; --v1.3.0
t_w constant plx_sc.normalv2 := 'w'; -- v1.3.0
t_websettings constant plx_sc.normalv2 := 'webSettings'; --v1.3.0

-- Constants
c_filename constant plx_sc.normalv2 := 'word/webSettings.xml';

/******************************************************************/
--Structures

-- CT_DivBdr
--v1.3.0
type CT_DivBdr is record(
     tag plx_sc.normalv2,
     top ploffx_document_type.CT_Border,
     left_ ploffx_document_type.CT_Border,
     right_ ploffx_document_type.CT_Border,
     bottom ploffx_document_type.CT_Border
);

-- CT_SignedTwipsMeasure
--v1.3.0
type CT_SignedTwipsMeasure is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2
);

-- CT_Div
--v1.3.0
type CT_Div is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2,
     blockQuote ploffx_document_type.CT_OnOff,
     bodyDiv ploffx_document_type.CT_OnOff,
     divBdr CT_DivBdr,
     -- divsChild CT_Divs,
     marBottom CT_SignedTwipsMeasure,
     marLeft CT_SignedTwipsMeasure,
     marRight CT_SignedTwipsMeasure,
     marTop CT_SignedTwipsMeasure
);
-- t_div_
type t_div_ is table of CT_Div;
v_div_empty t_div_ := t_div_();

-- CT_Divs
--v1.3.0
type CT_Divs is record (
     tag plx_sc.normalv2,
     div t_div_
);

-- CT_PixelsMeasure
--v1.3.0
type CT_PixelsMeasure is record (
     tag plx_sc.normalv2,
     val plx_sc.normalv2
);

-- ST_FrameScrollbar
--v1.3.0
subtype ST_FrameScrollbar is ploffx_util.t_string;
c_auto constant ST_FrameScrollbar:= 'auto';
c_on constant ST_FrameScrollbar := 'on';
c_off constant ST_FrameScrollbar := 'off';

--v1.3.0
-- CT_FrameScrollbar
type CT_FrameScrollbar is record (
     tag plx_sc.normalv2,
     val ST_FrameScrollbar
);

-- CT_Rel
--v1.3.0
type CT_Rel is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2 -- r:id
);

-- CT_Frame
--v1.3.0
type CT_Frame is record(
     tag plx_sc.normalv2,
     linkedToFile ploffx_document_type.CT_OnOff,
     marH CT_PixelsMeasure,
     marW CT_PixelsMeasure,
     name_ ploffx_document_type.CT_String,
     noResizeAllowed ploffx_document_type.CT_OnOff,
     scrollbar CT_FrameScrollbar,
     sourceFileName CT_Rel,
     sz ploffx_document_type.CT_String
);
-- t_frame_
type t_frame_ is table of CT_Frame;
v_frame_empty t_frame_ := t_frame_();

-- ST_FrameLayout
--v1.3.0
subtype ST_FrameLayout is ploffx_util.t_string;
c_cols constant ST_FrameLayout := 'cols';
c_none constant ST_FrameLayout := 'none';
c_rows constant ST_FrameLayout := 'rows';

--v1.3.0
-- CT_FrameLayout
type CT_FrameLayout is record(
     tag plx_sc.normalv2,
     val ST_FrameLayout
);

--v1.3.0
-- CT_TwipsMeasure
type CT_TwipsMeasure is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2  -- ST_TwipsMeasure
);

-- CT_FramesetSplitbar
--v1.3.0
type CT_FramesetSplitbar is record(
     tag plx_sc.normalv2,
     color ploffx_document_type.CT_Color,
     flatBorders ploffx_document_type.CT_OnOff,
     noBorder ploffx_document_type.CT_OnOff,
     w CT_TwipsMeasure
);

-- CT_Frameset
--v1.3.0
type CT_Frameset is record (
     tag plx_sc.normalv2,
     frame t_frame_,
     frameLayout CT_FrameLayout,
     --frameset CT_Frameset
     framesetSplitbar CT_FramesetSplitbar,
     sz ploffx_document_type.CT_String
);
-- t_frameset_
type t_frameset_ is table of CT_Frameset;
v_frameset_empty t_frameset_ := t_frameset_();

-- ST_TargetScreenSz
--v1.3.0
subtype ST_TargetScreenSz is ploffx_util.t_string;
c_1024x768 constant ST_TargetScreenSz := '1024x768';
c_1152x882 constant ST_TargetScreenSz := '1152x882';
c_1152x900 constant ST_TargetScreenSz := '1152x900';
c_1280x1024 constant ST_TargetScreenSz := '1280x1024';
c_1600x1200 constant ST_TargetScreenSz := '1600x1200';
c_1800x1440 constant ST_TargetScreenSz := '1800x1440';
c_1920x1200 constant ST_TargetScreenSz := '1920x1200';
c_544x376 constant ST_TargetScreenSz := '544x376';
c_640x480 constant ST_TargetScreenSz := '640x480';
c_720x512 constant ST_TargetScreenSz := '720x512';
c_800x600 constant ST_TargetScreenSz := '800x600';

-- CT_TargetScreenSz
--v1.3.0
type CT_TargetScreenSz is record (
     tag plx_sc.normalv2,
     val ST_TargetScreenSz
);

-- CT_WebSettings
--v1.3.0
type CT_WebSettings is record (
     tag plx_sc.normalv2,
     allowPNG ploffx_document_type.CT_OnOff,
     divs CT_Divs,
     doNotOrganizeInFolder ploffx_document_type.CT_OnOff,
     doNotRelyOnCSS ploffx_document_type.CT_OnOff,
     doNotSaveAsSingleFile ploffx_document_type.CT_OnOff,
     doNotUseLongFileNames ploffx_document_type.CT_OnOff,
     encoding ploffx_document_type.CT_String,
     frameset CT_Frameset,
     optimizeForBrowser ploffx_document_type.CT_OnOff,
     pixelsPerInch ploffx_document_type.CT_DecimalNumber,
     relyOnVML ploffx_document_type.CT_OnOff,
     saveSmartTagsAsXml ploffx_document_type.CT_OnOff,
     targetScreenSz CT_TargetScreenSz
);

/******************************************************************/

-- start
procedure start_;
-- end
procedure end_;

-- allowPNG
-- v1.3.0
procedure allowPNG(
  p_tag varchar2 default t_allowPNG,
  p_val varchar2 default null
  );

-- blockQuote
-- v1.3.0
procedure blockQuote(
  p_tag varchar2 default t_blockQuote,
  p_val varchar2 default null
  );

-- bodyDiv
-- v1.3.0
procedure bodyDiv(
  p_tag varchar2 default t_bodyDiv,
  p_val varchar2 default null
  );

-- color
procedure color(
  p_tag varchar2 default t_color,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null,
  p_val varchar2
  );

-- divBdr
-- v1.3.0
procedure startdivBdr(
    p_tag varchar2 default t_divBdr
    );
--
procedure enddivBdr;

-- divs
-- v1.3.0
procedure startdivs(
    p_tag varchar2 default t_divs
    );
--
procedure enddivs;

-- divsChild
-- v1.3.0
procedure startdivsChild(
    p_tag varchar2 default t_divsChild
    );
--
procedure enddivsChild;

-- div
-- v1.3.0
procedure startdiv(
  p_tag varchar2 default t_div,
  p_id varchar2
  );
--
procedure enddiv;

-- doNotOrganizeInFolder
-- v1.3.0
procedure doNotOrganizeInFolder(
  p_tag varchar2 default t_doNotOrganizeInFolder,
  p_val varchar2 default null
  );

-- doNotRelyOnCSS
-- v1.3.0
procedure doNotRelyOnCSS(
  p_tag varchar2 default t_doNotRelyOnCSS,
  p_val varchar2 default null
  );

-- doNotSaveAsSingleFile
-- v1.3.0
procedure doNotSaveAsSingleFile(
  p_tag varchar2 default t_doNotSaveAsSingleFile,
  p_val varchar2 default null
  );

-- doNotUseLongFileNames
-- v1.3.0
procedure doNotUseLongFileNames(
  p_tag varchar2 default t_doNotUseLongFileNames,
  p_val varchar2 default null
  );

-- encoding
-- v1.3.0
procedure encoding(
  p_tag varchar2 default t_encoding,
  p_val varchar2 default null
  );

-- flatBorders
-- v1.3.0
procedure flatBorders(
  p_tag varchar2 default t_flatBorders,
  p_val varchar2 default null
  );

-- frame
-- v1.3.0
procedure startframe(
  p_tag varchar2 default t_frame
  );
--
procedure endframe;

-- frameLayout
-- v1.3.0
procedure frameLayout(
  p_tag varchar2 default t_frameLayout,
  p_val varchar2 default null
  );

-- frameset
-- v1.3.0
procedure startframeset(
  p_tag varchar2 default t_frameset
  );
--
procedure endframeset;

-- framesetSplitbar
-- v1.3.0
procedure startframesetSplitbar(
  p_tag varchar2 default t_framesetSplitbar
  );
--
procedure endframesetSplitbar;

-- linkedToFile
-- v1.3.0
procedure linkedToFile(
  p_tag varchar2 default t_linkedToFile,
  p_val varchar2 default null
  );

-- marBottom
-- v1.3.0
procedure marBottom(
  p_tag varchar2 default t_marBottom,
  p_val varchar2
  );

-- marH
-- v1.3.0
procedure marH(
  p_tag varchar2 default t_marH,
  p_val varchar2
  );

-- marLeft
-- v1.3.0
procedure marLeft(
  p_tag varchar2 default t_marLeft,
  p_val varchar2
  );

-- marRight
-- v1.3.0
procedure marRight(
  p_tag varchar2 default t_marRight,
  p_val varchar2
  );

-- marTop
-- v1.3.0
procedure marTop(
  p_tag varchar2 default t_marTop,
  p_val varchar2
  );

-- marW
-- v1.3.0
procedure marW(
  p_tag varchar2 default t_marW,
  p_val varchar2
  );

-- name
-- v1.3.0
procedure name_(
  p_tag varchar2 default t_name,
  p_val varchar2
  );

-- noBorder
-- v1.3.0
procedure noBorder(
  p_tag varchar2 default t_noBorder,
  p_val varchar2
  );

-- noResizeAllowed
-- v1.3.0
procedure noResizeAllowed(
  p_tag varchar2 default t_noResizeAllowed,
  p_val varchar2 default null
  );

-- optimizeForBrowser
-- v1.3.0
procedure optimizeForBrowser(
  p_tag varchar2 default t_optimizeForBrowser,
  p_val varchar2 default null
  );

-- pixelsPerInch
-- v.1.3.0
procedure pixelsPerInch(
  p_tag varchar2 default t_pixelsPerInch,
  p_val varchar2
  );

-- relyOnVML
-- v1.3.0
procedure relyOnVML(
  p_tag varchar2 default t_relyOnVML,
  p_val varchar2 default null
  );

-- scrollbar
-- v1.3.0
procedure scrollbar(
  p_tag varchar2 default t_scrollbar,
  p_val varchar2
  );

-- sourceFileName
-- v1.3.0
procedure sourceFileName(
  p_tag varchar2 default t_sourceFileName,
  p_id varchar2 -- r:id
  );

-- saveSmartTagsAsXml
-- v1.3.0
procedure saveSmartTagsAsXml(
  p_tag varchar2 default t_saveSmartTagsAsXml,
  p_val varchar2 default null
  );

-- sz
-- v1.3.0
procedure sz(
  p_tag varchar2 default t_sz,
  p_val varchar2
  );

-- targetScreenSz
-- v1.3.0
procedure targetScreenSz(
  p_tag varchar2 default t_targetScreenSz,
  p_val varchar2 default null
  );

-- w
-- v1.3.0
procedure w(
  p_tag varchar2 default t_w,
  p_val varchar2
  );

-- webSettings
-- v1.3.0
procedure startwebSettings(
  p_tag varchar2 default t_websettings
  );
--
procedure endwebSettings;

/************************************************************/
-- Create structure

---------------------------------------------
--divBdr:CT_DivBdr
--v1.3.0
function cr_divBdr(
  p_tag varchar2 default t_divBdr,
  p_top ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border default null,
  p_bottom ploffx_document_type.CT_Border default null
  ) return CT_DivBdr;

---------------------------------------------
--marBottom:CT_SignedTwipsMeasure
--v1.3.0
function cr_marBottom(
  p_tag varchar2 default t_marBottom,
  p_val plx_sc.normalv2 default null
  ) return CT_SignedTwipsMeasure;


---------------------------------------------
--marLeft:CT_SignedTwipsMeasure
--v1.3.0
function cr_marLeft(
  p_tag varchar2 default t_marLeft,
  p_val plx_sc.normalv2 default null
  ) return CT_SignedTwipsMeasure;

---------------------------------------------
--marRight:CT_SignedTwipsMeasure
--v1.3.0
function cr_marRight(
  p_tag varchar2 default t_marRight,
  p_val plx_sc.normalv2 default null
  ) return CT_SignedTwipsMeasure;

---------------------------------------------
--marTop:CT_SignedTwipsMeasure
--v1.3.0
function cr_marTop(
  p_tag varchar2 default t_marTop,
  p_val plx_sc.normalv2 default null
  ) return CT_SignedTwipsMeasure;

---------------------------------------------
--blockQuote:CT_OnOff
--v1.3.0
function cr_blockQuote(
  p_tag varchar2 default t_blockQuote,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--bodyDiv:CT_OnOff
--v1.3.0
function cr_bodyDiv(
  p_tag varchar2 default t_bodyDiv,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--div:CT_Div
--v1.3.0
function cr_div(
  p_tag varchar2 default t_div,
   p_id plx_sc.normalv2  default null,
   p_blockQuote ploffx_document_type.CT_OnOff default null,
   p_bodyDiv ploffx_document_type.CT_OnOff default null,
   p_divBdr CT_DivBdr default null,
   --divsChild CT_Divs,
   p_marBottom CT_SignedTwipsMeasure default null,
   p_marLeft CT_SignedTwipsMeasure default null,
   p_marRight CT_SignedTwipsMeasure default null,
   p_marTop CT_SignedTwipsMeasure default null
  ) return CT_Div;

---------------------------------------------
--divs CT_Divs
--v1.3.0
function cr_divs(
  p_tag varchar2 default t_divs,
  p_div t_div_ default null
  ) return CT_Divs;

---------------------------------------------
--doNotOrganizeInFolder:CT_OnOff
--v1.3.0
function cr_doNotOrganizeInFolder(
  p_tag varchar2 default t_doNotOrganizeInFolder,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotRelyOnCSS:CT_OnOff
--v1.3.0
function cr_doNotRelyOnCSS(
  p_tag varchar2 default t_doNotRelyOnCSS,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotSaveAsSingleFile:CT_OnOff
--v1.3.0
function cr_doNotSaveAsSingleFile(
  p_tag varchar2 default t_doNotSaveAsSingleFile,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotUseLongFileNames:CT_OnOff
--v1.3.0
function cr_doNotUseLongFileNames(
  p_tag varchar2 default t_doNotUseLongFileNames,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--encoding:CT_String
--v1.3.0
function cr_encoding(
  p_tag varchar2 default t_encoding,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--linkedToFile:CT_OnOff
--v1.3.0
function cr_linkedToFile(
  p_tag varchar2 default t_linkedToFile,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--marH CT_PixelsMeasure
--v1.3.0
function cr_marH(
  p_tag varchar2 default t_marH,
  p_val varchar2 default null
  ) return CT_PixelsMeasure;

---------------------------------------------
--marW CT_PixelsMeasure
--v1.3.0
function cr_marW(
  p_tag varchar2 default t_marW,
  p_val varchar2 default null
  ) return CT_PixelsMeasure;

---------------------------------------------
--name ploffx_document_type.CT_String
--v1.3.0
function cr_name(
  p_tag varchar2 default t_name,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;


---------------------------------------------
--noResizeAllowed ploffx_document_type.CT_OnOff
--v1.3.0
function cr_noResizeAllowed(
  p_tag varchar2 default t_noResizeAllowed,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--scrollbar CT_FrameScrollbar
--v1.3.0
function cr_scrollbar(
  p_tag varchar2 default t_scrollbar,
  p_val varchar2 default null
  ) return CT_FrameScrollbar;

---------------------------------------------
--sourceFileName CT_Rel
--v1.3.0
function cr_sourceFileName(
  p_tag varchar2 default t_sourceFileName,
  p_id varchar2 default null
  ) return CT_Rel;

---------------------------------------------
--sz ploffx_document_type.CT_String
--v1.3.0
function cr_sz(
  p_tag varchar2 default t_sz,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--frame CT_Frame
--v1.3.0
function cr_frame(
  p_tag varchar2 default t_frame,
   p_linkedToFile ploffx_document_type.CT_OnOff default null,
   p_marH CT_PixelsMeasure default null,
   p_marW CT_PixelsMeasure default null,
   p_name_ ploffx_document_type.CT_String default null,
   p_noResizeAllowed ploffx_document_type.CT_OnOff default null,
   p_scrollbar CT_FrameScrollbar default null,
   p_sourceFileName CT_Rel default null,
   p_sz ploffx_document_type.CT_String default null
  ) return CT_Frame;

---------------------------------------------
--frameLayout CT_FrameLayout
--v1.3.0
function cr_frameLayout(
  p_tag varchar2 default t_frameLayout,
  p_val ST_FrameLayout default null
  ) return CT_FrameLayout;

---------------------------------------------
--w:CT_TwipsMeasure
--v1.3.0
function cr_w(
  p_tag varchar2 default t_w,
   p_val plx_sc.normalv2 default null
  ) return CT_TwipsMeasure;

---------------------------------------------
--noBorder:CT_OnOff
--v1.3.0
function cr_noBorder(
  p_tag varchar2 default t_noBorder,
   p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--flatBorders:CT_OnOff
--v1.3.0
function cr_flatBorders(
  p_tag varchar2 default t_flatBorders,
   p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--framesetSplitbar:CT_FramesetSplitbar
--v1.3.0
function cr_framesetSplitbar(
  p_tag varchar2 default t_framesetSplitbar,
   p_color ploffx_document_type.CT_Color default null,
   p_flatBorders ploffx_document_type.CT_OnOff default null,
   p_noBorder ploffx_document_type.CT_OnOff default null,
   p_w CT_TwipsMeasure default null
  ) return CT_FramesetSplitbar;

---------------------------------------------
--frameset CT_Frameset
--v1.3.0
function cr_frameset(
  p_tag varchar2 default t_frameset,
  p_frame t_frame_ default null,
  p_frameLayout CT_FrameLayout default null,
  -- frameset CT_Frameset
  p_framesetSplitbar CT_FramesetSplitbar,
  p_sz ploffx_document_type.CT_String
  ) return CT_Frameset;

---------------------------------------------
--optimizeForBrowser:CT_OnOff
--v1.3.0
function cr_optimizeForBrowser(
  p_tag varchar2 default t_optimizeForBrowser,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--allowPNG:CT_OnOff
--v1.3.0
function cr_allowPNG(
  p_tag varchar2 default t_allowPNG,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--pixelsPerInch:CT_DecimalNumber
--v1.3.0
function cr_pixelsPerInch(
  p_tag varchar2 default t_pixelsPerInch,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--relyOnVML ploffx_document_type.CT_OnOff
--v1.3.0
function cr_relyOnVML(
  p_tag varchar2 default t_relyOnVML,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--saveSmartTagsAsXml:CT_OnOff
--v1.3.0
function cr_saveSmartTagsAsXml(
  p_tag varchar2 default t_saveSmartTagsAsXml,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--targetScreenSz CT_TargetScreenSz
--v1.3.0
function cr_targetScreenSz(
  p_tag varchar2 default t_targetScreenSz,
  p_val varchar2 default null
  ) return CT_TargetScreenSz;

---------------------------------------------
--webSettings CT_WebSettings
--v1.3.0
function cr_webSettings(
  p_tag varchar2 default t_webSettings,
  p_frameset CT_Frameset default null,
  p_divs CT_Divs default null,
  p_encoding ploffx_document_type.CT_String default null,
  p_optimizeForBrowser ploffx_document_type.CT_OnOff default null,
  p_relyOnVML ploffx_document_type.CT_OnOff default null,
  p_allowPNG ploffx_document_type.CT_OnOff default null,
  p_doNotRelyOnCSS ploffx_document_type.CT_OnOff default null,
  p_doNotSaveAsSingleFile ploffx_document_type.CT_OnOff default null,
  p_doNotOrganizeInFolder ploffx_document_type.CT_OnOff default null,
  p_doNotUseLongFileNames ploffx_document_type.CT_OnOff default null,
  p_pixelsPerInch ploffx_document_type.CT_DecimalNumber default null,
  p_targetScreenSz CT_TargetScreenSz default null,
  p_saveSmartTagsAsXml ploffx_document_type.CT_OnOff default null
  ) return CT_WebSettings;

/************************************************************/
-- Generate XML parts

---------------------------------------------
--divBdr:CT_DivBdr
--v1.3.0
procedure gen_divBdr(
  p_divBdr CT_DivBdr
  );

---------------------------------------------
--divBdr:CT_DivBdr
--v1.3.0
procedure gen_marBottom(
  p_marBottom CT_SignedTwipsMeasure
  );

---------------------------------------------
--marLeft:CT_SignedTwipsMeasure
--v1.3.0
procedure gen_marLeft(
  p_marLeft CT_SignedTwipsMeasure
  );

---------------------------------------------
--marRight:CT_SignedTwipsMeasure
--v1.3.0
procedure gen_marRight(
  p_marRight CT_SignedTwipsMeasure
  );

---------------------------------------------
--marTop:CT_SignedTwipsMeasure
--v1.3.0
procedure gen_marTop(
  p_marTop CT_SignedTwipsMeasure
  );

---------------------------------------------
--blockQuote:CT_OnOff
--v1.3.0
procedure gen_blockQuote(
  p_blockQuote ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--bodyDiv:CT_OnOff
--v1.3.0
procedure gen_bodyDiv(
  p_bodyDiv ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--div:CT_Div
--v1.3.0
procedure gen_div(
  p_div CT_Div
  );
-- t_div_
procedure add_div(
  p_table in out t_div_,
  p_div CT_Div
  );

---------------------------------------------
--divs CT_Divs
--v1.3.0
procedure gen_divs(
  p_divs CT_Divs
  );

---------------------------------------------
--doNotOrganizeInFolder:CT_OnOff
--v1.3.0
procedure gen_doNotOrganizeInFolder(
  p_doNotOrganizeInFolder ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotRelyOnCSS:CT_OnOff
--v1.3.0
procedure gen_doNotRelyOnCSS(
  p_doNotRelyOnCSS ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotSaveAsSingleFile:CT_OnOff
--v1.3.0
procedure gen_doNotSaveAsSingleFile(
  p_doNotSaveAsSingleFile ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotUseLongFileNames:CT_OnOff
--v1.3.0
procedure gen_doNotUseLongFileNames(
  p_doNotUseLongFileNames ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--encoding:CT_String
--v1.3.0
procedure gen_encoding(
  p_encoding ploffx_document_type.CT_String
  );

---------------------------------------------
--linkedToFile:CT_OnOff
--v1.3.0
procedure gen_linkedToFile(
  p_linkedToFile ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--marH:CT_PixelsMeasure
--v1.3.0
procedure gen_marH(
  p_marH CT_PixelsMeasure
  );

---------------------------------------------
--marW:CT_PixelsMeasure
--v1.3.0
procedure gen_marW(
  p_marW CT_PixelsMeasure
  );

---------------------------------------------
--name:CT_String
--v1.3.0
procedure gen_name(
  p_name ploffx_document_type.CT_String
  );

---------------------------------------------
--noResizeAllowed:CT_OnOff
--v1.3.0
procedure gen_noResizeAllowed(
  p_noResizeAllowed ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--scrollbar:CT_FrameScrollbar
--v1.3.0
procedure gen_scrollbar(
  p_scrollbar CT_FrameScrollbar
  );

---------------------------------------------
--sourceFileName:CT_Rel
--v1.3.0
procedure gen_sourceFileName(
  p_sourceFileName CT_Rel
  );

---------------------------------------------
--sz:CT_String
--v1.3.0
procedure gen_sz(
  p_sz ploffx_document_type.CT_String
  );

---------------------------------------------
--frame:CT_Frame
--v1.3.0
procedure gen_frame(
  p_frame CT_Frame
  );
--t_frame_
procedure add_frame(
  p_table in out t_frame_,
  p_frame CT_Frame
  );

---------------------------------------------
--frameLayout:CT_FrameLayout
--v1.3.0
procedure gen_frameLayout(
  p_frameLayout CT_FrameLayout
  );

---------------------------------------------
--w:CT_TwipsMeasure
--v1.3.0
procedure gen_w(
  p_w CT_TwipsMeasure
  );

---------------------------------------------
--noBorder:CT_OnOff
--v1.3.0
procedure gen_noBorder(
  p_noBorder ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--flatBorders:CT_OnOff
--v1.3.0
procedure gen_flatBorders(
  p_flatBorders ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--framesetSplitbar:CT_FramesetSplitbar
--v1.3.0
procedure gen_framesetSplitbar(
  p_framesetSplitbar CT_FramesetSplitbar
  );

---------------------------------------------
--frameset:CT_Frameset
--v1.3.0
procedure gen_frameset(
  p_frameset CT_Frameset
  );

---------------------------------------------
--optimizeForBrowser:CT_OnOff
--v1.3.0
procedure gen_optimizeForBrowser(
  p_optimizeForBrowser ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--allowPNG:CT_OnOff
--v1.3.0
procedure gen_allowPNG(
  p_allowPNG ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--pixelsPerInch:CT_DecimalNumber
--v1.3.0
procedure gen_pixelsPerInch(
  p_pixelsPerInch ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--relyOnVML:CT_OnOff
--v1.3.0
procedure gen_relyOnVML(
  p_relyOnVML ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--saveSmartTagsAsXml:CT_OnOff
--v1.3.0
procedure gen_saveSmartTagsAsXml(
  p_saveSmartTagsAsXml ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--targetScreenSz CT_TargetScreenSz
--v1.3.0
procedure gen_targetScreenSz(
  p_targetScreenSz CT_TargetScreenSz
  );

---------------------------------------------
--webSettings CT_WebSettings
--v1.3.0
procedure gen_webSettings(
  p_webSettings CT_WebSettings
  );

-- GEN_XML
procedure gen_xml(
  p_webSettings CT_WebSettings
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse
--v1.3.0
function parse(
  p_file clob
  ) return ploffx_websettings.CT_WebSettings;

--v1.3.0
procedure docx_webSettings_init(
  p_webSettings in out CT_WebSettings
  );

--
end ploffx_websettings;
/

