create or replace package ploffx_vmlDrawing
authid current_user is
--v5.9
--
-- Namespace
ns_v constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:vml';
ns_o constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:office';
ns_x constant plx_Sc.normalv2 := 'urn:schemas-microsoft-com:office:excel';

-- Prefixes
ns_v_pref constant varchar2(1 char) := 'v';
ns_o_pref constant varchar2(1 char) := 'o';
ns_x_pref constant varchar2(1 char) := 'x';
ns_r_pref constant varchar2(1 char) := 'r';

-- VML
g_vml plx_sc.type_xdoc;

-- Tag
t_Anchor constant plx_sc.normalv2 := 'Anchor';
t_AutoFill constant plx_sc.normalv2 := 'AutoFill';
t_ClientData constant plx_sc.normalv2 := 'ClientData';
t_Column constant plx_sc.normalv2 := 'Column';
t_div constant plx_sc.normalv2 := 'div';
t_fill constant plx_sc.normalv2 := 'fill';
t_idmap constant plx_sc.normalv2 := 'idmap';
t_MoveWithCells constant plx_sc.normalv2 := 'MoveWithCells';
t_path constant plx_sc.normalv2 := 'path';
t_Row constant plx_sc.normalv2 := 'Row';
t_shape constant plx_sc.normalv2 := 'shape';
t_shadow constant plx_sc.normalv2 := 'shadow';
t_shapelayout constant plx_sc.normalv2 := 'shapelayout';
t_shapetype constant plx_sc.normalv2 := 'shapetype';
t_SizeWithCells constant plx_sc.normalv2 := 'SizeWithCells';
t_stroke constant plx_sc.normalv2 := 'stroke';
t_textbox constant plx_sc.normalv2 := 'textbox';
t_textpath constant plx_sc.normalv2 := 'textpath';
t_xml constant plx_sc.normalv2 := 'xml';


/******************************************************************/
--Structures

-- ST_ConnectType
subtype ST_ConnectType is ploffx_util.t_string;
c_none constant ST_ConnectType := 'none';
c_rect constant ST_ConnectType := 'rect';
c_segments constant ST_ConnectType := 'segments';
c_custom constant ST_ConnectType := 'custom';


-- ST_StrokeLineStyle
subtype ST_StrokeLineStyle is ploffx_util.t_string;
c_single constant ST_StrokeLineStyle := 'single';
c_thinThin constant ST_StrokeLineStyle := 'thinThin';
c_thinThick constant ST_StrokeLineStyle := 'thinThick';
c_thickThin constant ST_StrokeLineStyle := 'thickThin';
c_thickBetweenThin constant ST_StrokeLineStyle := 'thickBetweenThin';


-- ST_StrokeJoinStyle
subtype ST_StrokeJoinStyle is ploffx_util.t_string;
c_round constant ST_StrokeJoinStyle := 'round';
c_bevel constant ST_StrokeJoinStyle := 'bevel';
c_miter constant ST_StrokeJoinStyle := 'miter';


-- ST_StrokeEndCap
subtype ST_StrokeEndCap is ploffx_util.t_string;
c_flat constant ST_StrokeEndCap := 'flat';
c_square constant ST_StrokeEndCap := 'square';
c_round constant ST_StrokeEndCap := 'round';


-- ST_FillType
subtype ST_FillType is ploffx_util.t_string;
c_solid constant ST_FillType := 'solid';
c_gradient constant ST_FillType := 'gradient';
c_gradientRadial constant ST_FillType := 'gradientRadial';
c_tile constant ST_FillType := 'tile';
c_pattern constant ST_FillType := 'pattern';
c_frame constant ST_FillType := 'frame';

-- ST_ImageAspect
subtype ST_ImageAspect is ploffx_util.t_string;
c_ignore constant ST_ImageAspect := 'ignore';
c_atMost constant ST_ImageAspect := 'atMost';
c_atLeast constant ST_ImageAspect := 'atLeast';


-- ST_StrokeArrowType
subtype ST_StrokeArrowType is ploffx_util.t_string;

-- ST_StrokeArrowWidth
subtype ST_StrokeArrowWidth is ploffx_util.t_string;

-- ST_StrokeArrowLength
subtype ST_StrokeArrowLength is ploffx_util.t_string;

-- ST_HrAlign
subtype ST_HrAlign is ploffx_util.t_string;

-- ST_InsetMode
subtype ST_InsetMode is ploffx_util.t_string;

-- ST_BWMode
subtype ST_BWMode is ploffx_util.t_string;

-- ST_FillMethod
subtype ST_FillMethod is ploffx_util.t_string;

-- ST_ShadowType
subtype ST_ShadowType is ploffx_util.t_string;

-- ST_TrueFalseBlank
subtype ST_TrueFalseBlank is ploffx_util.t_string;

-- ST_ObjectType
subtype ST_ObjectType is ploffx_util.t_string;

-- ST_Ext
subtype ST_Ext is ploffx_util.t_string;

subtype ST_TrueFalse is ploffx_util.t_string;
  trueFalse_f constant ST_TrueFalse := 'f';
  trueFalse_false constant ST_TrueFalse := 'false';
  trueFalse_t constant ST_TrueFalse := 't';
  trueFalse_true constant ST_TrueFalse := 'true';

-- CT_IdMap
type CT_IdMap is record(
     tag plx_sc.normalv2,
     ext ST_Ext,
     data plx_sc.normalv2 -- xsd:string
     );

-- CT_ShapeLayout
type CT_ShapeLayout is record(
     tag plx_sc.normalv2,
     ext ST_Ext,
     idmap CT_IdMap
     --
     );

-- CT_Stroke
type CT_Stroke is record(
     tag plx_sc.normalv2,
     --id plx_sc.normalv2, -- xsd:string
     --on_ ST_TrueFalse,
     --weight plx_sc.normalv2, -- xsd:string
     --color plx_sc.normalv2, -- ST_ColorType
     --opacity plx_sc.normalv2, -- xsd:string
     --linestyle ST_StrokeLineStyle,
     --miterlimit  plx_sc.normalv2, -- xsd:decimal
     joinstyle ST_StrokeJoinStyle
     --endcap ST_StrokeEndCap,
     --dashstyle plx_sc.normalv2, -- xsd:string
     --filltype ST_FillType,
     --src plx_sc.normalv2, -- xsd:string
     --imageaspect ST_ImageAspect,
     --imagesize plx_sc.normalv2, -- xsd:string
     --imagealignshape ST_TrueFalse,
     --color2  plx_sc.normalv2, -- ST_ColorType
     --startarrow ST_StrokeArrowType,
     --startarrowwidth ST_StrokeArrowWidth,
     --startarrowlength ST_StrokeArrowLength,
     --endarrow ST_StrokeArrowType,
     --endarrowwidth ST_StrokeArrowWidth,
     --endarrowlength ST_StrokeArrowLength,
     --href plx_sc.normalv2, -- xsd:string
     --althref plx_sc.normalv2, -- xsd:string
     --title plx_sc.normalv2, -- xsd:string
     --forcedash ST_TrueFalse,
     --r_id plx_sc.normalv2, -- ST_RelationshipId
     --insetpen ST_TrueFalse,
     --relid plx_sc.normalv2 -- ST_RelationshipId
     );
-- t_stroke_: CT_Stroke
--type t_stroke_ is table of CT_Stroke;
--v_stroke_empty t_stroke_ := t_stroke_();

-- CT_Path
type CT_Path is record(
     tag plx_sc.normalv2,
     --id plx_sc.normalv2, -- xsd:string
     --limo plx_sc.normalv2, -- xsd:string
     --textboxrect plx_sc.normalv2, -- xsd:string
     --fillok ST_TrueFalse,
     --strokeok ST_TrueFalse,
     --shadowok  ST_TrueFalse,
     --arrowok ST_TrueFalse,
     gradientshapeok ST_TrueFalse,
     --textpathok ST_TrueFalse,
     --insetpenok ST_TrueFalse,
     connecttype ST_ConnectType
     --connectlocs plx_sc.normalv2, -- xsd:string
     --connectangles plx_sc.normalv2, -- xsd:string
     --extrusionok ST_TrueFalse
     -- left
     -- top
     -- right
     -- bottom
     -- column
     );

-- t_path_: CT_Path
--type t_path_ is table of CT_Path;
--v_path_empty t_path_ := t_path_();

-- CT_ShapeType
type CT_ShapeType is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2, -- xsd:string
     --style plx_sc.normalv2, -- xsd:string
     --href plx_sc.normalv2, -- xsd:string
     --target plx_sc.normalv2, -- xsd:string
     --class_ plx_sc.normalv2, -- xsd:string
     --title plx_sc.normalv2, -- xsd:string
     --alt plx_sc.normalv2, -- xsd:string
     coordsize plx_sc.normalv2, -- xsd:string
     --coordorigin plx_sc.normalv2, -- xsd:string
     --wrapcoords plx_sc.normalv2, -- xsd:string
     --print ST_TrueFalse,
     --spid plx_sc.normalv2, -- xsd:string
     --oned ST_TrueFalse,
     --regroupid plx_sc.normalv2, -- xsd:integer
     --doubleclicknotify ST_TrueFalse,
     --button ST_TrueFalse,
     --userhidden ST_TrueFalse,
     --bullet ST_TrueFalse,
     --hr ST_TrueFalse,
     --hrstd ST_TrueFalse,
     --hrnoshade ST_TrueFalse,
     --hrpct plx_sc.normalv2, -- xsd:float
     --hralign ST_HrAlign,
     --allowincell ST_TrueFalse,
     --allowoverlap ST_TrueFalse,
     --userdrawn ST_TrueFalse,
     --bordertopcolor plx_sc.normalv2, -- xsd:string
     --borderleftcolor plx_sc.normalv2, -- xsd:string
     --borderbottomcolor plx_sc.normalv2, -- xsd:string
     --borderrightcolor plx_sc.normalv2, -- xsd:string
     --dgmlayout plx_sc.normalv2, -- xsd:integer
     --dgmnodekind plx_sc.normalv2, -- xsd:integer
     --dgmlayoutmru plx_sc.normalv2, -- xsd:integer
     --insetmode ST_InsetMode,
     --chromakey plx_sc.normalv2, -- ST_ColorType
     --filled ST_TrueFalse,
     --fillcolor plx_sc.normalv2, -- ST_ColorType
     --opacity plx_sc.normalv2, -- xsd:string
     --stroked ST_TrueFalse,
     --strokecolor plx_sc.normalv2, -- ST_ColorType
     --strokeweigth plx_sc.normalv2, -- xsd:string
     --insetpen ST_TrueFalse,
     spt plx_sc.normalv2, -- xsd:float
     --connectortype ST_ConnectType,
     --bwmode ST_BWMode,
     --bwpure ST_BWMode,
     --bwnormal ST_BWMode,
     --forcedash ST_TrueFalse,
     --oleicon ST_TrueFalse,
     --ole plx_sc.normalv2, -- ST_TrueFalseBlank
     --preferrelaitve ST_TrueFalse,
     --cliptowrap ST_TrueFalse,
     --clip ST_TrueFalse,
     --adj plx_sc.normalv2, -- xsd:string
     path plx_sc.normalv2, -- xsd:string
     --master plx_sc.normalv2, -- xsd:string
     stroke CT_Stroke,
     path_ CT_Path
     );

-- CT_Fill
type CT_Fill is record(
     tag plx_sc.normalv2,
     --id plx_sc.normalv2, -- xsd:string
     --type_ ST_FillType,
     --on_ ST_TrueFalse,
     --color plx_sc.normalv2, -- ST_ColorType
     opacity plx_sc.normalv2, -- xsd:string
     color2 plx_sc.normalv2 -- ST_ColorType
     --src plx_sc.normalv2, -- xsd:string
     --href plx_sc.normalv2, -- xsd:string
     --althref plx_sc.normalv2, -- xsd:string
     --size_ plx_sc.normalv2, -- xsd:string
     --origin plx_sc.normalv2, -- xsd:string
     --position plx_sc.normalv2, -- xsd:string
     --aspect ST_ImageAspect,
     --colors plx_sc.normalv2, -- xsd:string
     --angle plx_sc.normalv2, -- xsd:decimal
     --alignshape ST_TrueFalse,
     --focus  plx_sc.normalv2, -- xsd:string
     --focoussize plx_sc.normalv2, -- xsd:string
     --focusposition plx_sc.normalv2, -- xsd:string
     --method ST_FillMethod,
     --detectmouseclick ST_TrueFalse,
     --title plx_sc.normalv2, -- xsd:string
     --opacity2 plx_sc.normalv2, -- xsd:string
     --recolor ST_TrueFalse,
     --rotate ST_TrueFalse,
     --r_id  plx_sc.normalv2, -- ST_RelationshipId
     --relid plx_sc.normalv2 -- ST_RelationshipId
     -- fill -> child element
     );
-- fill: t_fill_
--type t_fill_ is table of CT_Fill;
--v_fill_empty t_fill_ := t_fill_();

-- CT_Shadow
type CT_Shadow is record(
     tag plx_Sc.normalv2,
     id plx_sc.normalv2, -- xsd:string
     on_ ST_TrueFalse,
     type_ ST_ShadowType,
     obscured ST_TrueFalse,
     color plx_sc.normalv2, -- ST_ColorType
     opacity plx_sc.normalv2, -- xsd:string
     offset plx_sc.normalv2, -- xsd:string
     color2 plx_sc.normalv2, -- ST_ColorType
     offset2 plx_sc.normalv2, -- xsd:string
     origin plx_sc.normalv2, -- xsd:string
     matrix plx_sc.normalv2 -- xsd:string
     );
-- t_shadow_: CT_Shadow
--type t_shadow_ is table of CT_Shadow;
--v_shadow_empty t_shadow_ := t_shadow_();

-- CT_Div
type CT_Div is record(
     tag plx_sc.normalv2,
     style plx_sc.normalv2 -- xsd:string
     );

-- CT_TextBox
type CT_TextBox is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2, -- xsd:string
     style plx_sc.normalv2, -- xsd:string
     inset plx_sc.normalv2, -- xsd:string
     singleclick ST_TrueFalse,
     insetmode ST_InsetMode,
     --
     div CT_Div
     );
-- t_textbox_: CT_TextBox
--type t_textbox_ is table of CT_TextBox;
--v_textbox_empty t_textbox_ := t_textbox_();

-- CT_TrueFalseBlank (Custom type)
type CT_TrueFalseBlank is record(
     tag plx_sc.normalv2,
     val ST_TrueFalseBlank -- xsd:string
     );

-- CT_String (Custom type)
type CT_String is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2
     );

-- CT_ClientData
type CT_ClientData is record(
     tag plx_sc.normalv2,
     objectType ST_ObjectType,
     --
     moveWithCells CT_TrueFalseBlank,
     sizeWithCells CT_TrueFalseBlank,
     anchor CT_String, -- xsd:string
     autoFill CT_TrueFalseBlank,
     row_ CT_String, -- xsd:integer
     column CT_String -- xsd:integer
     );

--v5.8
type ct_shape_styling_props is record (
  flip plx_sc.normalv2,
  height plx_sc.normalv2, --
  left plx_sc.normalv2,
  margin_bottom plx_sc.normalv2,
  margin_left plx_sc.normalv2, --
  margin_right plx_sc.normalv2,
  margin_top plx_sc.normalv2, --
  mso_position_horizontal plx_sc.normalv2, --
  mso_position_horizont_rel plx_sc.normalv2, --v5.11
  mso_position_vertical plx_sc.normalv2, --
  mso_position_vertical_relative plx_sc.normalv2, --
  mso_wrap_distance_bottom plx_sc.normalv2,
  mso_wrap_distance_left plx_sc.normalv2,
  mso_wrap_distance_right plx_sc.normalv2,
  mso_wrap_distance_top plx_sc.normalv2,
  mso_wrap_edited plx_sc.normalv2,
  mso_wrap_style plx_sc.normalv2,
  position plx_sc.normalv2, --
  rotaion plx_sc.normalv2, --
  top plx_sc.normalv2,
  visibility plx_sc.normalv2,
  width plx_sc.normalv2, --
  z_index plx_sc.normalv2 --
  );  
--v5.8
type CT_TextPath is record (
  tag plx_sc.normalv2,
  style plx_sc.normalv2, --ct_shape_styling_props
  on_ ST_TrueFalse,
  fitshape ST_TrueFalse,
  fitpath ST_TrueFalse,
  trim ST_TrueFalse,
  xscale ST_TrueFalse,
  string plx_sc.maxv2
  );  


-- CT_Shape
type CT_Shape is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2, -- xsd:string
     type_ plx_sc.normalv2, -- xsd:string
     style plx_sc.normalv2, --ct_shape_styling_props, -- xsd:string
     allowincell ST_TrueFalse, --v5.8
     fillcolor plx_sc.normalv2, -- ST_ColorType
     stroked ST_TrueFalse, --v5.8
     insetmode ST_InsetMode,
     path plx_sc.normalv2, -- xsd:string
     fill CT_Fill, --v5.8
     shadow CT_Shadow, --v5.8
     path_ CT_Path, --v5.8
     textbox CT_TextBox, --v5.8
     textpath CT_TextPath, --v5.8
     clientData CT_ClientData
     --
     );
-- t_shape_: CT_Shape
/*type t_shape_ is table of CT_Shape;
v_shape_empty t_shape_ := t_shape_();*/

-- CT_VML (root element of the vml file)
type CT_VML is record(
     tag plx_sc.normalv2,
     shapelayout CT_ShapeLayout,
     shapetype CT_Shapetype,
     shape CT_Shape --v5.8
     );

v_vml_empty CT_VML;

/******************************************************************/
-- start
procedure start_(
    p_xml in out plx_sc.type_xdoc
    );
-- end
procedure end_(
    p_xml in out plx_sc.type_xdoc
    );

-- Anchor
procedure startAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Anchor
  );
--
procedure endAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Anchor
  );

-- AutoFill
procedure startAutoFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_AutoFill
  );
--
procedure endAutoFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_AutoFill
  );
-- ClientData
procedure startClientData(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ClientData,
  p_ObjectType varchar2
  );
--
procedure endClientData(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ClientData
  );
-- Column
procedure startColumn(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Column
  );
--
procedure endColumn(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Column
  );
-- div
procedure startdiv(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_div,
  p_style varchar2
  );
--
procedure enddiv(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_div
  );
-- fill
procedure fill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fill,
  p_alignshape varchar2 default null,
  p_althref varchar2 default null,
  p_angle varchar2 default null,
  p_aspect varchar2 default null,
  p_color varchar2 default null,
  p_color2 varchar2 default null,
  p_colors varchar2 default null,
  p_detectmouseclick varchar2 default null,
  p_focus varchar2 default null,
  p_focusposition varchar2 default null,
  p_focussize varchar2 default null,
  p_href varchar2 default null,
  p_id varchar2 default null,
  p_rid varchar2 default null,
  p_method varchar2 default null,
  p_on varchar2 default null,
  p_opacity varchar2 default null,
  p_opacity2 varchar2 default null,
  p_origin varchar2 default null,
  p_position varchar2 default null,
  p_recolor varchar2 default null,
  p_relid varchar2 default null,
  p_rotate varchar2 default null,
  p_size varchar2 default null,
  p_src varchar2 default null,
  p_title varchar2 default null,
  p_type varchar2 default null
  );
-- idmap
procedure idmap(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_idMap,
  p_ext varchar2 default null,
  p_data varchar2 default null
  );
-- MoveWidthCells
procedure startMoveWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_MoveWithCells
  );
--
procedure endMoveWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_MoveWithCells
  );
-- path
procedure path(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_path,
  p_arrowok varchar2 default null,
  p_connectangles varchar2 default null,
  p_connectlocs varchar2 default null,
  p_connecttype varchar2 default null,
  p_extrusionok varchar2 default null,
  p_fillok varchar2 default null,
  p_gradientshapeok varchar2 default null,
  p_id varchar2 default null,
  p_insetpenok varchar2 default null,
  p_limo varchar2 default null,
  p_shadowok varchar2 default null,
  p_strokeok varchar2 default null,
  p_textboxrect varchar2 default null,
  p_textpathok varchar2 default null,
  p_v varchar2 default null
  );
-- row
procedure startRow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_row
  );
--
procedure endRow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Row
  );
-- shape
procedure startshape(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shape,
  p_adj varchar2 default null,
  p_allowincell varchar2 default null,
  p_allowoverlap varchar2 default null,
  p_alt varchar2 default null,
  p_borderbottomcolor varchar2 default null,
  p_borderleftcolor varchar2 default null,
  p_borderrightcolor varchar2 default null,
  p_bordertopcolor varchar2 default null,
  p_bullet varchar2 default null,
  p_button varchar2 default null,
  p_bwmode varchar2 default null,
  p_bwnormal varchar2 default null,
  p_bwpure varchar2 default null,
  p_chromakey varchar2 default null,
  p_class varchar2 default null,
  p_clip varchar2 default null,
  p_cliptowrap varchar2 default null,
  p_connectortype varchar2 default null,
  p_coordorigin varchar2 default null,
  p_coordsize varchar2 default null,
  p_dgmlayout varchar2 default null,
  p_dgmlayoutmru varchar2 default null,
  p_dgmmodekind varchar2 default null,
  p_doubleclicknotify varchar2 default null,
  p_equationxml varchar2 default null,
  p_fillcolor varchar2 default null,
  p_filled varchar2 default null,
  p_forcedash varchar2 default null,
  p_gfxdata varchar2 default null,
  p_hr varchar2 default null,
  p_hralign varchar2 default null,
  p_href varchar2 default null,
  p_hrnoshade varchar2 default null,
  p_hrpct varchar2 default null,
  p_hrstd varchar2 default null,
  p_id varchar2 default null,
  p_insetmode varchar2 default null,
  p_insetpen varchar2 default null,
  p_ole varchar2 default null,
  p_oleicon varchar2 default null,
  p_oned varchar2 default null,
  p_opacity varchar2 default null,
  p_path varchar2 default null,
  p_preferrelative varchar2 default null,
  p_print varchar2 default null,
  p_regroupid varchar2 default null,
  p_spid varchar2 default null,
  p_spt varchar2 default null,
  p_strokecolor varchar2 default null,
  p_stroked varchar2 default null,
  p_strokeweight varchar2 default null,
  p_style varchar2 default null,
  p_target varchar2 default null,
  p_title varchar2 default null,
  p_type varchar2 default null,
  p_userdrawn varchar2 default null,
  p_userhidden varchar2 default null,
  p_wrapcoords varchar2 default null
  );
--
procedure endshape(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shape
  );
-- shadow
procedure shadow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shadow,
  p_color varchar2 default null,
  p_color2 varchar2 default null,
  p_id varchar2 default null,
  p_matrix varchar2 default null,
  p_obscured varchar2 default null,
  p_offset varchar2 default null,
  p_offset2 varchar2 default null,
  p_on varchar2 default null,
  p_opacity varchar2 default null,
  p_origin varchar2 default null,
  p_type varchar2 default null
  );
-- shapelayout
procedure startshapelayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shapelayout,
  p_ext varchar2 default null
  );
--
procedure endshapelayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shapelayout
  );
-- shapetype
procedure startshapetype(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shapetype,
  p_adj varchar2 default null,
  p_allowincell varchar2 default null,
  p_allowoverlap varchar2 default null,
  p_alt varchar2 default null,
  p_borderbottomcolor varchar2 default null,
  p_borderleftcolor varchar2 default null,
  p_borderrightcolor varchar2 default null,
  p_bordertopcolor varchar2 default null,
  p_bullet varchar2 default null,
  p_button varchar2 default null,
  p_bwmode varchar2 default null,
  p_bwnormal varchar2 default null,
  p_bwpure varchar2 default null,
  p_chromakey varchar2 default null,
  p_class varchar2 default null,
  p_clip varchar2 default null,
  p_cliptowrap varchar2 default null,
  p_connectortype varchar2 default null,
  p_coordorigin varchar2 default null,
  p_coordsize varchar2 default null,
  p_dgmlayout varchar2 default null,
  p_dgmlayoutmru varchar2 default null,
  p_dgmmodekind varchar2 default null,
  p_doubleclicknotify varchar2 default null,
  p_equationxml varchar2 default null,
  p_fillcolor varchar2 default null,
  p_filled varchar2 default null,
  p_forcedash varchar2 default null,
  p_gfxdata varchar2 default null,
  p_hr varchar2 default null,
  p_hralign varchar2 default null,
  p_href varchar2 default null,
  p_hrnoshade varchar2 default null,
  p_hrpct varchar2 default null,
  p_hrstd varchar2 default null,
  p_id varchar2 default null,
  p_insetmode varchar2 default null,
  p_insetpen varchar2 default null,
  p_master varchar2 default null,
  p_ole varchar2 default null,
  p_oleicon varchar2 default null,
  p_oned varchar2 default null,
  p_opacity varchar2 default null,
  p_path varchar2 default null,
  p_preferrelative varchar2 default null,
  p_print varchar2 default null,
  p_regroupid varchar2 default null,
  p_spid varchar2 default null,
  p_spt varchar2 default null,
  p_strokecolor varchar2 default null,
  p_stroked varchar2 default null,
  p_strokeweight varchar2 default null,
  p_style varchar2 default null,
  p_target varchar2 default null,
  p_title varchar2 default null,
  p_userdrawn varchar2 default null,
  p_userhidden varchar2 default null,
  p_wrapcoords varchar2 default null
  );
--
procedure endshapetype(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shapetype
  );
-- SizeWidthCells
procedure startSizeWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_SizeWithCells
  );
--
procedure endSizeWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_SizeWithCells
  );
-- stroke
procedure stroke(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_stroke,
  p_althref varchar2 default null,
  p_color varchar2 default null,
  p_color2 varchar2 default null,
  p_dashstyle varchar2 default null,
  p_endarrow varchar2 default null,
  p_endarrowlength varchar2 default null,
  p_endarrowwidth varchar2 default null,
  p_endcap varchar2 default null,
  p_filltype varchar2 default null,
  p_forcedash varchar2 default null,
  p_href varchar2 default null,
  p_id varchar2 default null,
  p_rid varchar2 default null,
  p_imagealignshape varchar2 default null,
  p_imageaspect varchar2 default null,
  p_imagesize varchar2 default null,
  p_insetpen varchar2 default null,
  p_joinstyle varchar2 default null,
  p_linestyle varchar2 default null,
  p_miterlimit varchar2 default null,
  p_on varchar2 default null,
  p_opacity varchar2 default null,
  p_relid varchar2 default null,
  p_src varchar2 default null,
  p_startarrow varchar2 default null,
  p_startarrowlength varchar2 default null,
  p_startarrowwidth varchar2 default null,
  p_title varchar2 default null,
  p_weight varchar2 default null
  );
--v5.8
procedure textpath(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_textpath,
  p_style varchar2 default null, 
  p_on varchar2 default null,
  p_fitshape varchar2 default null,
  p_fitpath varchar2 default null,
  p_trim varchar2 default null,
  p_xscale varchar2 default null,
  p_string varchar2 default null
  );  
-- textbox
procedure starttextbox(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_textbox,
  p_id varchar2 default null,
  p_inset varchar2 default null,
  p_insetmode varchar2 default null,
  p_singleclick varchar2 default null,
  p_style varchar2 default null
  );
--
procedure endtextbox(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_textbox
  );
-- xml
procedure startxml(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xml
  );
--
procedure endxml(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xml
  );

-- Addtext
procedure addtext(
  p_xml in out plx_sc.type_xdoc,
  p_text varchar2
  );

/******************************************************************/
-- Create structure

------------------------------------------
-- column: CT_String
function cr_column(
  p_tag plx_sc.normalv2 default t_Column,
  p_val plx_sc.normalv2 default null
  ) return CT_String;

------------------------------------------
-- row: CT_String
function cr_row(
  p_tag plx_sc.normalv2 default t_Row,
  p_val plx_sc.normalv2 default null
  ) return CT_String;

------------------------------------------
-- autoFill: CT_TrueFalseBlank
function cr_autoFill(
  p_tag plx_sc.normalv2 default t_AutoFill,
  p_val ST_TrueFalseBlank default null
  ) return CT_TrueFalseBlank;

------------------------------------------
-- anchor: CT_String
function cr_anchor(
  p_tag plx_sc.normalv2 default t_Anchor,
  p_val plx_sc.normalv2 default null
  ) return CT_String;

------------------------------------------
-- sizeWithCells: CT_TrueFalseBlank
function cr_sizeWithCells(
  p_tag plx_sc.normalv2 default t_SizeWithCells,
  p_val ST_TrueFalseBlank default null
  ) return CT_TrueFalseBlank;

------------------------------------------
-- moveWithCells: CT_TrueFalseBlank
function cr_moveWithCells(
  p_tag plx_sc.normalv2 default t_MoveWithCells,
  p_val ST_TrueFalseBlank default null
  ) return CT_TrueFalseBlank;

------------------------------------------
-- clientData: CT_ClientData
function cr_clientData(
  p_tag plx_sc.normalv2 default t_ClientData,
  p_objectType ST_ObjectType default null,
  p_moveWithCells CT_TrueFalseBlank default null,
  p_sizeWithCells CT_TrueFalseBlank default null,
  p_anchor CT_String default null, -- xsd:string
  p_autoFill CT_TrueFalseBlank default null,
  p_row_ CT_String default null, -- xsd:integer
  p_column CT_String default null -- xsd:integer
  ) return CT_ClientData;

------------------------------------------
-- div: CT_Div
function cr_div(
  p_tag plx_sc.normalv2 default t_div,
  p_style plx_sc.normalv2 default null
  ) return CT_Div;

------------------------------------------
-- textbox: CT_TextBox
function cr_textbox(
  p_tag plx_sc.normalv2 default t_textbox,
  p_id plx_sc.normalv2 default null, -- xsd:string
  p_style plx_sc.normalv2 default null, -- xsd:string
  p_inset plx_sc.normalv2 default null, -- xsd:string
  p_singleclick ST_TrueFalse default null,
  p_insetmode ST_InsetMode default null,
  p_div CT_Div default null
  ) return CT_TextBox;
-- textbox: t_textbox_
/*procedure add_textbox(
  p_table in out t_textbox_,
  p_textbox CT_TextBox
  );*/

------------------------------------------
-- path: CT_Path
function cr_path(
  p_tag plx_sc.normalv2 default t_path,
  --id plx_sc.normalv2, -- xsd:string
  --limo plx_sc.normalv2, -- xsd:string
  --textboxrect plx_sc.normalv2, -- xsd:string
  --fillok ST_TrueFalse,
  --strokeok ST_TrueFalse,
  --shadowok  ST_TrueFalse,
  --arrowok ST_TrueFalse,
  p_gradientshapeok ST_TrueFalse default null,
  --textpathok ST_TrueFalse,
  --insetpenok ST_TrueFalse,
  p_connecttype ST_ConnectType default null
  --connectlocs plx_sc.normalv2, -- xsd:string
  --connectangles plx_sc.normalv2, -- xsd:string
  --extrusionok ST_TrueFalse
  -- left
  -- top
  -- right
  -- bottom
  -- column
  ) return CT_Path;
-- path: t_path_
/*procedure add_path(
  p_table in out t_path_,
  p_path CT_Path
  );*/

------------------------------------------
-- shadow: CT_Shadow
function cr_shadow(
  p_tag plx_sc.normalv2 default t_Shadow,
  p_id plx_sc.normalv2 default null, -- xsd:string
  p_on_ ST_TrueFalse default null,
  p_type_ ST_ShadowType default null,
  p_obscured ST_TrueFalse default null,
  p_color plx_sc.normalv2 default null, -- ST_ColorType
  p_opacity plx_sc.normalv2 default null, -- xsd:string
  p_offset plx_sc.normalv2 default null, -- xsd:string
  p_color2 plx_sc.normalv2 default null, -- ST_ColorType
  p_offset2 plx_sc.normalv2 default null, -- xsd:string
  p_origin plx_sc.normalv2 default null, -- xsd:string
  p_matrix plx_sc.normalv2 default null -- xsd:string
  ) return CT_Shadow;
-- shadow: t_shadow_
/*procedure add_shadow(
  p_table in out t_shadow_,
  p_shadow CT_Shadow
  );*/

------------------------------------------
-- fill: CT_Fill
function cr_fill(
  p_tag plx_sc.normalv2 default t_Fill,
  --id plx_sc.normalv2, -- xsd:string
  --type_ ST_FillType,
  --on_ ST_TrueFalse,
  --color plx_sc.normalv2, -- ST_ColorType
  p_opacity plx_sc.normalv2 default null, -- xsd:string
  p_color2 plx_sc.normalv2 default null -- ST_ColorType
  --src plx_sc.normalv2, -- xsd:string
  --href plx_sc.normalv2, -- xsd:string
  --althref plx_sc.normalv2, -- xsd:string
  --size_ plx_sc.normalv2, -- xsd:string
  --origin plx_sc.normalv2, -- xsd:string
  --position plx_sc.normalv2, -- xsd:string
  --aspect ST_ImageAspect,
  --colors plx_sc.normalv2, -- xsd:string
  --angle plx_sc.normalv2, -- xsd:decimal
  --alignshape ST_TrueFalse,
  --focus  plx_sc.normalv2, -- xsd:string
  --focoussize plx_sc.normalv2, -- xsd:string
  --focusposition plx_sc.normalv2, -- xsd:string
  --method ST_FillMethod,
  --detectmouseclick ST_TrueFalse,
  --title plx_sc.normalv2, -- xsd:string
  --opacity2 plx_sc.normalv2, -- xsd:string
  --recolor ST_TrueFalse,
  --rotate ST_TrueFalse,
  --r_id  plx_sc.normalv2, -- ST_RelationshipId
  --relid plx_sc.normalv2 -- ST_RelationshipId
  -- fill -> child element
  ) return CT_Fill;
-- Fill: t_fill_
/*procedure add_Fill(
  p_table in out t_fill_,
  p_Fill CT_Fill
  );*/

------------------------------------------
-- stroke: CT_Stroke
function cr_stroke(
  p_tag plx_sc.normalv2 default t_Stroke,
  --id plx_sc.normalv2, -- xsd:string
  --on_ ST_TrueFalse,
  --weight plx_sc.normalv2, -- xsd:string
  --color plx_sc.normalv2, -- ST_ColorType
  --opacity plx_sc.normalv2, -- xsd:string
  --linestyle ST_StrokeLineStyle,
  --miterlimit  plx_sc.normalv2, -- xsd:decimal
  p_joinstyle ST_StrokeJoinStyle default null
  --endcap ST_StrokeEndCap,
  --dashstyle plx_sc.normalv2, -- xsd:string
  --filltype ST_FillType,
  --src plx_sc.normalv2, -- xsd:string
  --imageaspect ST_ImageAspect,
  --imagesize plx_sc.normalv2, -- xsd:string
  --imagealignshape ST_TrueFalse,
  --color2  plx_sc.normalv2, -- ST_ColorType
  --startarrow ST_StrokeArrowType,
  --startarrowwidth ST_StrokeArrowWidth,
  --startarrowlength ST_StrokeArrowLength,
  --endarrow ST_StrokeArrowType,
  --endarrowwidth ST_StrokeArrowWidth,
  --endarrowlength ST_StrokeArrowLength,
  --href plx_sc.normalv2, -- xsd:string
  --althref plx_sc.normalv2, -- xsd:string
  --title plx_sc.normalv2, -- xsd:string
  --forcedash ST_TrueFalse,
  --r_id plx_sc.normalv2, -- ST_RelationshipId
  --insetpen ST_TrueFalse,
  --relid plx_sc.normalv2 -- ST_RelationshipId
  ) return CT_Stroke;
-- Stroke: t_stroke_
/*procedure add_Stroke(
  p_table in out t_stroke_,
  p_Stroke CT_Stroke
  );*/

--v5.8
function cr_textpath(
  p_tag plx_sc.normalv2 default t_Textpath,
  p_style plx_sc.normalv2 default null,
  p_on ST_TrueFalse default null,
  p_fitshape ST_TrueFalse default null,
  p_fitpath ST_TrueFalse default null,
  p_trim ST_TrueFalse default null,
  p_xscale ST_TrueFalse default null,
  p_string plx_sc.maxv2 default null
  ) return CT_Textpath;
------------------------------------------
-- IdMap: CT_IdMap
function cr_idMap(
  p_tag plx_sc.normalv2 default t_IdMap,
  p_ext ST_Ext default null,
  p_data plx_sc.normalv2 default null -- xsd:string
  ) return CT_IdMap;

------------------------------------------
-- Shape: CT_Shape
function cr_shape(
  p_tag plx_sc.normalv2 default t_Shape,
  p_id plx_sc.normalv2 default null, -- xsd:string
  p_style plx_sc.normalv2 default null, -- xsd:string
  p_insetmode ST_InsetMode default null,
  p_fillcolor plx_sc.normalv2 default null, -- ST_ColorType
  p_type plx_sc.normalv2 default null, -- xsd:string
  p_path plx_sc.normalv2 default null, -- xsd:string
  --
  p_fill CT_Fill default null,
  p_shadow CT_Shadow default null,
  p_path_ CT_Path default null,
  p_textbox CT_Textbox default null,
  p_textpath CT_TextPath default null, 
  p_clientData CT_ClientData default null
  ) return CT_Shape;
-- Shape: t_shape_
/*procedure add_Shape(
  p_table in out t_shape_,
  p_Shape CT_Shape
  );*/

------------------------------------------
-- ShapeType: CT_ShapeType
function cr_shapeType(
  p_tag plx_sc.normalv2 default t_shapetype,
  p_id plx_sc.normalv2 default null, -- xsd:string
  --style plx_sc.normalv2, -- xsd:string
  --href plx_sc.normalv2, -- xsd:string
  --target plx_sc.normalv2, -- xsd:string
  --class_ plx_sc.normalv2, -- xsd:string
  --title plx_sc.normalv2, -- xsd:string
  --alt plx_sc.normalv2, -- xsd:string
  p_coordsize plx_sc.normalv2 default null, -- xsd:string
  --coordorigin plx_sc.normalv2, -- xsd:string
  --wrapcoords plx_sc.normalv2, -- xsd:string
  --print ST_TrueFalse,
  --spid plx_sc.normalv2, -- xsd:string
  --oned ST_TrueFalse,
  --regroupid plx_sc.normalv2, -- xsd:integer
  --doubleclicknotify ST_TrueFalse,
  --button ST_TrueFalse,
  --userhidden ST_TrueFalse,
  --bullet ST_TrueFalse,
  --hr ST_TrueFalse,
  --hrstd ST_TrueFalse,
  --hrnoshade ST_TrueFalse,
  --hrpct plx_sc.normalv2, -- xsd:float
  --hralign ST_HrAlign,
  --allowincell ST_TrueFalse,
  --allowoverlap ST_TrueFalse,
  --userdrawn ST_TrueFalse,
  --bordertopcolor plx_sc.normalv2, -- xsd:string
  --borderleftcolor plx_sc.normalv2, -- xsd:string
  --borderbottomcolor plx_sc.normalv2, -- xsd:string
  --borderrightcolor plx_sc.normalv2, -- xsd:string
  --dgmlayout plx_sc.normalv2, -- xsd:integer
  --dgmnodekind plx_sc.normalv2, -- xsd:integer
  --dgmlayoutmru plx_sc.normalv2, -- xsd:integer
  --insetmode ST_InsetMode,
  --chromakey plx_sc.normalv2, -- ST_ColorType
  --filled ST_TrueFalse,
  --fillcolor plx_sc.normalv2, -- ST_ColorType
  --opacity plx_sc.normalv2, -- xsd:string
  --stroked ST_TrueFalse,
  --strokecolor plx_sc.normalv2, -- ST_ColorType
  --strokeweigth plx_sc.normalv2, -- xsd:string
  --insetpen ST_TrueFalse,
  p_spt plx_sc.normalv2 default null, -- xsd:float
  --connectortype ST_ConnectType,
  --bwmode ST_BWMode,
  --bwpure ST_BWMode,
  --bwnormal ST_BWMode,
  --forcedash ST_TrueFalse,
  --oleicon ST_TrueFalse,
  --ole plx_sc.normalv2, -- ST_TrueFalseBlank
  --preferrelaitve ST_TrueFalse,
  --cliptowrap ST_TrueFalse,
  --clip ST_TrueFalse,
  --adj plx_sc.normalv2, -- xsd:string
  p_path plx_sc.normalv2 default null, -- xsd:string
  --master plx_sc.normalv2, -- xsd:string
  p_stroke CT_Stroke default null,
  p_path_ CT_Path default null
  ) return CT_ShapeType;

------------------------------------------
-- ShapeLayout: CT_ShapeLayout
function cr_shapeLayout(
  p_tag plx_sc.normalv2 default t_shapelayout,
  p_ext ST_Ext default null,
  p_idmap CT_IdMap default null
  ) return CT_ShapeLayout;

------------------------------------------
-- XML: CT_VML
function cr_xml(
  p_tag plx_sc.normalv2 default t_shapelayout,
  p_shapelayout CT_ShapeLayout default null,
  p_shapetype CT_Shapetype default null,
  p_shape CT_Shape default null
  ) return CT_VML;

/******************************************************************/
-- Generate XML part

---------------------------------------
-- column: CT_String
procedure gen_column(
  p_xml in out plx_sc.type_xdoc,
  p_column CT_String
  );

---------------------------------------
-- row: CT_String
procedure gen_row(
  p_xml in out plx_sc.type_xdoc,
  p_row CT_String
  );

---------------------------------------
-- autoFill: CT_TrueFalseBlank
procedure gen_autoFill(
  p_xml in out plx_sc.type_xdoc,
  p_autoFill CT_TrueFalseBlank
  );

---------------------------------------
-- anchor: CT_String
procedure gen_anchor(
  p_xml in out plx_sc.type_xdoc,
  p_anchor CT_String
  );

---------------------------------------
-- sizeWithCells: CT_TrueFalseBlank
procedure gen_sizeWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_sizeWithCells CT_TrueFalseBlank
  );

---------------------------------------
-- moveWithCells: CT_TrueFalseBlank
procedure gen_moveWithCells(
  p_xml in out plx_sc.type_xdoc,
  p_moveWithCells CT_TrueFalseBlank
  );

---------------------------------------
-- clientData: CT_ClientData
procedure gen_clientData(
  p_xml in out plx_sc.type_xdoc,
  p_clientData CT_ClientData
  );

---------------------------------------
-- div: CT_Div
procedure gen_div(
  p_xml in out plx_sc.type_xdoc,
  p_div CT_Div
  );

---------------------------------------
-- textbox: CT_TextBox
procedure gen_textbox(
  p_xml in out plx_sc.type_xdoc,
  p_textbox CT_TextBox
  );

---------------------------------------
-- path: CT_Path
procedure gen_path(
  p_xml in out plx_sc.type_xdoc,
  p_path CT_Path
  );

---------------------------------------
-- shadow: CT_Shadow
procedure gen_shadow(
  p_xml in out plx_sc.type_xdoc,
  p_shadow CT_Shadow
  );

---------------------------------------
-- fill: CT_Fill
procedure gen_fill(
  p_xml in out plx_sc.type_xdoc,
  p_fill CT_Fill
  );

---------------------------------------
-- stroke: CT_Stroke
procedure gen_stroke(
  p_xml in out plx_sc.type_xdoc,
  p_stroke CT_Stroke
  );

---------------------------------------
-- idMap: CT_IdMap
procedure gen_idMap(
  p_xml in out plx_sc.type_xdoc,
  p_idMap CT_IdMap
  );

---------------------------------------
-- shape: CT_Shape
procedure gen_shape(
  p_xml in out plx_sc.type_xdoc,
  p_shape CT_Shape
  );

---------------------------------------
-- shapeType: CT_ShapeType
procedure gen_shapeType(
  p_xml in out plx_sc.type_xdoc,
  p_shapeType CT_ShapeType
  );


---------------------------------------
-- shapeLayout: CT_ShapeLayout
procedure gen_shapeLayout(
  p_xml in out plx_sc.type_xdoc,
  p_shapeLayout CT_ShapeLayout
  );

---------------------------------------
-- XML: CT_VML
procedure gen_VML(
  p_xml in out plx_sc.type_xdoc,
  p_vml CT_VML
  );

------------------------------------------
-- GEN_XML
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_vml CT_VML
  );

------------------------------------------
-- PARSE_XML
function parse(
  p_file clob
  ) return CT_VML;

------------------------------------------
-- INIT_VML
procedure init_VML(
  p_vml in out CT_VML
  );
--
end ploffx_vmlDrawing;
/

