create or replace package ploffx_util
authid current_user is
--v5.14
--
--v1.1.0
--XML Schema Primitive datatypes
subtype t_string is plx_sc.maxv2;
subtype t_boolean is varchar2(5 char);  --xsd:boolean
c_true constant t_boolean := 'true';
c_false constant t_boolean := 'false';
c_true1 constant t_boolean := '1';
c_false0 constant t_boolean := '0';
subtype t_num is varchar2(32 char);
subtype t_decimal is t_num;
subtype t_float is t_num;
subtype t_double is t_num; -- xsd:double
subtype t_duration is t_num;
subtype t_int is t_num; -- xsd:int
subtype t_unsignedInt is t_num;  -- xsd:unsignedInt
--
type t_filenames is table of plx_sc.maxv2;
--
type t_file is record (
  filename     plx_sc.maxv2,
  filedata     blob
  );
type t_files is table of t_file;
--
v_files_empty t_files := t_files();
--
type t_cellrange is record (
  first_column     pls_integer,
  first_row        pls_integer,
  last_column      pls_integer,
  last_row         pls_integer
  );
--v4.11
type t_cellranges is table of t_cellrange index by pls_integer;
--
type t_definedNameValue is record(
  ws_name plpdf_type.v2avg,
  from_row  pls_integer,
  from_cell  plpdf_type.v2avg,
  to_row  pls_integer,
  to_cell  plpdf_type.v2avg
  );
--
procedure raise_error(
  p_proc varchar2,
  p_msg varchar2
  );
--
function date2char(
  p_date date,
  p_date1904 boolean
  ) return varchar2;
--
function char2date(
  p_string varchar2,
  p_date1904 boolean
  ) return date;
--
function is_string(
  p_string varchar2
  ) return boolean;
--
function is_integer(
  p_string varchar2
  ) return boolean;
--
function to_str(
  p_num number,
  p_length number
  ) return varchar2;
--
function to_num(
  p_str varchar2
  ) return number;
-- 'true'/'false'
function boolean2char(
  p_boolean boolean
  ) return varchar2;
-- '1'/'0'
function boolean2numchar(
  p_boolean boolean
  ) return varchar2;
-- '1'/'0'/'true'/'false'
function char2boolean(
  p_char varchar2
  ) return boolean;
--
function escape_string(
  p_string varchar2
  ) return varchar2;
--
function num2col(
  p_col pls_integer
  ) return varchar2;
--
function col2num(
  p_col varchar2
  ) return pls_integer;
--
function r2cell(
  p_r varchar2 --A1 style cell ref
  ) return varchar2; --non num part of cell, "A"
--v4.9.0
function r2row(
  p_r varchar2 --A1 style cell ref
  ) return pls_integer; -- num part of cell, "1"
--
function rowcell2r(
  p_row pls_integer,
  p_cell varchar2
  ) return varchar2;
--
--
function nvl_color(
  p_color varchar2
  ) return varchar2;
--
procedure addBlob(
  p_zipped_file in out nocopy blob,
  p_filename        varchar2,
  p_filedata in out nocopy blob
  );
--
procedure addClob(
  p_zipped_file in out nocopy blob,
  p_filename varchar2,
  p_filedata  in out nocopy clob
  );
--
procedure finish_zip(
  p_zipped_file in out nocopy blob
  );
--
--unzip
function getFileNames(
  p_zipped_file in out nocopy blob,
  p_encoding    in varchar2 default null
  ) return t_filenames;
--
function getFiles(
  p_zipped_file in out nocopy blob,
  p_encoding    in varchar2 default null
  ) return t_files;
--
function blob2clob(
  p_blob in out nocopy blob
  ) return clob;
--
function point2EMU(
  p_value number
  ) return number;
--
function EMU2point(
  p_value number
  ) return number;
--
function unit2factor(
  p_unit varchar2
  ) return number;
--
function eight2point(
  p_unit number
  ) return number;
--
function point2eight(
  p_unit number
  ) return number;
--v4.7.0
function twips2point(
  p_unit number
  ) return number;
--v4.7.0
function point2twips(
  p_unit number
  ) return number;
--
function getNumpos(
  p_text varchar2
  ) return pls_integer;
--
function getRefArray(
  p_text varchar2
  ) return t_cellrange;
--
function degreeToSixtyT(
  p_value number
  ) return number;

function sixtyTToDegree(
  p_value number
  ) return number;

function fontPointToXMl(
  p_value number
  ) return number;

function XMLToFontPoint(
  p_value number
  ) return number;

function isExponential(
  p_string varchar2
  ) return boolean;
--v4.9.0
function splitDefinedName(
  p_value varchar2
  ) return t_definedNameValue;
--v4.9.1
function getNumofCellRefs(
  p_formula varchar2
  ) return pls_integer;
--v4.9.1
function getBeginofCellRef(
  p_formula varchar2,
  p_occurence pls_integer default 1
  ) return pls_integer;
--v4.9.1
function getCellRef(
  p_formula varchar2,
  p_occurence pls_integer default 1
  ) return varchar2;
--v5.4
function getCellfromCellRef(
  p_cellref varchar2
  ) return varchar2;
--v5.4
function getRowfromCellRef(
  p_cellref varchar2
  ) return varchar2;
--v4.9.7
function point2Hps(
  p_point number
  ) return number;
--
end ploffx_util;
/

