create or replace package ploffx_theme
authid current_user is
--v5.9
--
-- Namespaces
ns_a constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/main';

-- Prefixes
ns_a_pref constant varchar2(1 char) := 'a';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_theme constant plx_sc.normalv2 := 'theme';
t_themeElements constant plx_sc.normalv2 := 'themeElements';
t_clrScheme constant plx_sc.normalv2 := 'clrScheme';
t_dk1 constant plx_sc.normalv2 := 'dk1';
t_lt1 constant plx_sc.normalv2 := 'lt1';
t_dk2 constant plx_sc.normalv2 := 'dk2';
t_lt2 constant plx_sc.normalv2 := 'lt2';
t_accent1 constant plx_sc.normalv2 := 'accent1';
t_accent2 constant plx_sc.normalv2 := 'accent2';
t_accent3 constant plx_sc.normalv2 := 'accent3';
t_accent4 constant plx_sc.normalv2 := 'accent4';
t_accent5 constant plx_sc.normalv2 := 'accent5';
t_accent6 constant plx_sc.normalv2 := 'accent6';
t_hlink constant plx_sc.normalv2 := 'hlink';
t_folHlink constant plx_sc.normalv2 := 'folHlink';
t_schemeClr constant plx_sc.normalv2 := 'schemeClr';
t_srgbClr constant plx_sc.normalv2 := 'srgbClr';
t_sysClr constant plx_sc.normalv2 := 'sysClr';
t_alpha constant plx_sc.normalv2 := 'alpha';
t_satMod constant plx_sc.normalv2 := 'satMod';
t_shade constant plx_sc.normalv2 := 'shade';
t_tint constant plx_sc.normalv2 := 'tint';
t_fontScheme constant plx_sc.normalv2 := 'fontScheme';
t_majorFont constant plx_sc.normalv2 := 'majorFont';
t_minorFont constant plx_sc.normalv2 := 'minorFont';
t_latin constant plx_sc.normalv2 := 'latin';
t_ea constant plx_sc.normalv2 := 'ea';
t_cs constant plx_sc.normalv2 := 'cs';
t_font constant plx_sc.normalv2 := 'font';
t_fmtScheme constant plx_sc.normalv2 := 'fmtScheme';
t_fillStyleLst constant plx_sc.normalv2 := 'fillStyleLst';
t_solidFill constant plx_sc.normalv2 := 'solidFill';
t_gradFill constant plx_sc.normalv2 := 'gradFill';
t_gsLst constant plx_sc.normalv2 := 'gsLst';
t_gs constant plx_sc.normalv2 := 'gs';
t_lin constant plx_sc.normalv2 := 'lin';
t_path constant plx_sc.normalv2 := 'path';
t_fillToRect constant plx_sc.normalv2 := 'fillToRect';
t_lnStyleLst constant plx_sc.normalv2 := 'lnStyleLst';
t_ln constant plx_sc.normalv2 := 'ln';
t_prstDash constant plx_sc.normalv2 := 'prstDash';
t_effectStyleLst constant plx_sc.normalv2 := 'effectStyleLst';
t_effectStyle constant plx_sc.normalv2 := 'effectStyle';
t_effectLst constant plx_sc.normalv2 := 'effectLst';
t_outerShdw constant plx_sc.normalv2 := 'outerShdw';
t_scene3d constant plx_sc.normalv2 := 'scene3d';
t_camera constant plx_sc.normalv2 := 'camera';
t_rot constant plx_sc.normalv2 := 'rot';
t_lightRig constant plx_sc.normalv2 := 'lightRig';
t_sp3d constant plx_sc.normalv2 := 'sp3d';
t_bevelT constant plx_sc.normalv2 := 'bevelT';
t_bgFillStyleLst constant plx_sc.normalv2 := 'bgFillStyleLst';
t_objectDefaults constant plx_sc.normalv2 := 'objectDefaults';
t_extraClrSchemeLst constant plx_sc.normalv2 := 'extraClrSchemeLst';
--t_rotWithShape constant plx_sc.normalv2 := 'rotWidthShape';

-- Constants
c_filename constant plx_sc.normalv2 := 'word/theme/theme1.xml';

/******************************************************************/
--Structures

-- ST_SchemeColorVal
subtype ST_SchemeColorVal is ploffx_util.t_string;
c_accent1 constant ST_SchemeColorVal := 'accent1';
c_accent2 constant ST_SchemeColorVal := 'accent2';
c_accent3 constant ST_SchemeColorVal := 'accent3';
c_accent4 constant ST_SchemeColorVal := 'accent4';
c_accent5 constant ST_SchemeColorVal := 'accent5';
c_accent6 constant ST_SchemeColorVal := 'accent6';
c_bg1 constant ST_SchemeColorVal := 'bg1';
c_bg2 constant ST_SchemeColorVal := 'bg2';
c_dk1 constant ST_SchemeColorVal := 'dk1';
c_dk2 constant ST_SchemeColorVal := 'dk2';
c_folHlink constant ST_SchemeColorVal := 'folHlink';
c_hlink constant ST_SchemeColorVal := 'hlink';
c_lt1 constant ST_SchemeColorVal := 'lt1';
c_lt2 constant ST_SchemeColorVal := 'lt2';
c_phClr constant ST_SchemeColorVal := 'phClr';
c_tx1 constant ST_SchemeColorVal := 'tx1';
c_tx2 constant ST_SchemeColorVal := 'tx2';

-- ST_PathShadeType
subtype ST_PathShadeType is ploffx_util.t_string;
c_circle constant ST_PathShadeType := 'circle';
c_rect constant ST_PathShadeType := 'rect';
c_shape constant ST_PathShadeType := 'shape';

-- ST_TileFlipMode
subtype ST_TileFlipMode is ploffx_util.t_string;
c_none constant ST_TileFlipMode := 'none';
c_x constant ST_TileFlipMode := 'x';
c_y constant ST_TileFlipMode := 'y';
c_xy constant ST_TileFlipMode := 'xy';

-- ST_PresetLineDashVal
subtype ST_PresetLineDashVal is ploffx_util.t_string;
c_solid constant ST_PresetLineDashVal := 'solid';
c_dot constant ST_PresetLineDashVal := 'dot';
c_dash constant ST_PresetLineDashVal := 'dash';
c_lgDash constant ST_PresetLineDashVal := 'lgDash';
c_dashDot constant ST_PresetLineDashVal := 'dashDot';
c_lgDashDot constant ST_PresetLineDashVal := 'lgDashDot';
c_lgDashDotDot constant ST_PresetLineDashVal := 'lgDashDotDot';
c_sysDash constant ST_PresetLineDashVal := 'sysDash';
c_sysDot constant ST_PresetLineDashVal := 'sysDot';
c_sysDashDot constant ST_PresetLineDashVal := 'sysDashDot';
c_sysDashDotDot constant ST_PresetLineDashVal := 'sysDashDotDot';

-- ST_LineCap
subtype ST_LineCap is ploffx_util.t_string;
c_rnd constant ST_LineCap := 'rnd';
c_sq constant ST_LineCap := 'sq';
c_flat constant ST_LineCap := 'flat';

-- ST_CompoundLine
subtype ST_CompoundLine is ploffx_util.t_string;
c_sng constant ST_CompoundLine := 'sng';
c_dbl constant ST_CompoundLine := 'dbl';
c_thickThin constant ST_CompoundLine := 'thickThin';
c_thinThick constant ST_CompoundLine := 'thinThick';
c_tri constant ST_CompoundLine := 'tri';

-- ST_PenAlignment
subtype ST_PenAlignment is ploffx_util.t_string;
c_ctr constant ST_PenAlignment := 'ctr';
c_in constant ST_PenAlignment := 'in';

-- ST_RectAlignment
subtype ST_RectAlignment is ploffx_util.t_string;
c_tl constant ST_RectAlignment := 'tl';
c_t constant ST_RectAlignment := 't';
c_tr constant ST_RectAlignment := 'tr';
c_l constant ST_RectAlignment := 'tl';
c_ctr constant ST_RectAlignment := 'ctr';
c_r constant ST_RectAlignment := 'r';
c_bl constant ST_RectAlignment := 'bl';
c_b constant ST_RectAlignment := 'b';
c_br constant ST_RectAlignment := 'br';

-- ST_PresetCameraType
subtype ST_PresetCameraType is ploffx_util.t_string;
c_legacyObliqueTopLeft constant ST_PresetCameraType := 'legacyObliqueTopLeft';
c_legacyObliqueTop constant ST_PresetCameraType := 'legacyObliqueTop';
c_legacyObliqueTopRight constant ST_PresetCameraType := 'legacyObliqueTopRight';
c_legacyObliqueLeft constant ST_PresetCameraType := 'legacyObliqueLeft';
c_legacyObliqueFront constant ST_PresetCameraType := 'legacyObliqueFront';
c_legacyObliqueRight constant ST_PresetCameraType := 'legacyObliqueRight';
c_legacyObliqueBottomLeft constant ST_PresetCameraType := 'legacyObliqueBottomLeft';
c_legacyObliqueBottom constant ST_PresetCameraType := 'legacyObliqueBottom';
c_legacyObliqueBottomRight constant ST_PresetCameraType := 'legacyObliqueBottomRight';
c_legacyPerspectiveTopLeft constant ST_PresetCameraType := 'legacyPerspectiveTopLeft';
c_legacyPerspectiveTop constant ST_PresetCameraType := 'legacyPerspectiveTop';
c_legacyPerspectiveTopRight constant ST_PresetCameraType := 'legacyPerspectiveTopRight';
c_legacyPerspectiveLeft constant ST_PresetCameraType := 'legacyPerspectiveLeft';
c_legacyPerspectiveFront constant ST_PresetCameraType := 'legacyPerspectiveFront';
c_legacyPerspectiveRight constant ST_PresetCameraType := 'legacyPerspectiveRight';
c_legacyPerspectiveBottomLeft constant ST_PresetCameraType := 'legacyPerspectiveBottomLeft';
c_legacyPerspectiveBottom constant ST_PresetCameraType := 'legacyPerspectiveBottom';
c_legacyPerspectiveBottomRight constant ST_PresetCameraType := 'legacyPerspectiveBottomRight';
c_orthographicFront constant ST_PresetCameraType := 'orthographicFront';
c_isometricTopUp constant ST_PresetCameraType := 'isometricTopUp';
c_isometricTopDown constant ST_PresetCameraType := 'isometricTopDown';
c_isometricBottomUp constant ST_PresetCameraType := 'isometricBottomUp';
c_isometricBottomDown constant ST_PresetCameraType := 'isometricBottomDown';
c_isometricLeftUp constant ST_PresetCameraType := 'isometricLeftUp';
c_isometricLeftDown constant ST_PresetCameraType := 'isometricLeftDown';
c_isometricRightUp constant ST_PresetCameraType := 'isometricRightUp';
c_isometricRightDown constant ST_PresetCameraType := 'isometricRightDown';
c_isometricOffAxis1Left constant ST_PresetCameraType := 'isometricOffAxis1Left';
c_isometricOffAxis1Right constant ST_PresetCameraType := 'isometricOffAxis1Right';
c_isometricOffAxis1Top constant ST_PresetCameraType := 'isometricOffAxis1Top';
c_isometricOffAxis2Left constant ST_PresetCameraType := 'isometricOffAxis2Left';
c_isometricOffAxis2Right constant ST_PresetCameraType := 'isometricOffAxis2Right';
c_isometricOffAxis2Top constant ST_PresetCameraType := 'isometricOffAxis2Top';
c_isometricOffAxis3Left constant ST_PresetCameraType := 'isometricOffAxis3Left';
c_isometricOffAxis3Right constant ST_PresetCameraType := 'isometricOffAxis3Right';
c_isometricOffAxis3Bottom constant ST_PresetCameraType := 'isometricOffAxis3Bottom';
c_isometricOffAxis4Left constant ST_PresetCameraType := 'isometricOffAxis4Left';
c_isometricOffAxis4Right constant ST_PresetCameraType := 'isometricOffAxis4Right';
c_isometricOffAxis4Bottom constant ST_PresetCameraType := 'isometricOffAxis4Bottom';
c_obliqueTopLeft constant ST_PresetCameraType := 'obliqueTopLeft';
c_obliqueTop constant ST_PresetCameraType := 'obliqueTop';
c_obliqueTopRight constant ST_PresetCameraType := 'obliqueTopRight';
c_obliqueLeft constant ST_PresetCameraType := 'obliqueLeft';
c_obliqueRight constant ST_PresetCameraType := 'obliqueRight';
c_obliqueBottomLeft constant ST_PresetCameraType := 'obliqueBottomLeft';
c_obliqueBottom constant ST_PresetCameraType := 'obliqueBottom';
c_obliqueBottomRight constant ST_PresetCameraType := 'obliqueBottomRight';
c_perspectiveFront constant ST_PresetCameraType := 'perspectiveFront';
c_perspectiveLeft constant ST_PresetCameraType := 'perspectiveLeft';
c_perspectiveRight constant ST_PresetCameraType := 'perspectiveRight';
c_perspectiveAbove constant ST_PresetCameraType := 'perspectiveAbove';
c_perspectiveBelow constant ST_PresetCameraType := 'perspectiveBelow';
c_perspectiveAboveLeftFacing constant ST_PresetCameraType := 'perspectiveAboveLeftFacing';
c_perspectiveAboveRightFacing constant ST_PresetCameraType := 'perspectiveAboveRightFacing';
c_perspectiveContrastLeftFac constant ST_PresetCameraType := 'perspectiveContrastingLeftFacing';
c_perspectiveContrastRightFac constant ST_PresetCameraType := 'perspectiveContrastingRightFacing';
c_perspectiveHeroicLeftFacing constant ST_PresetCameraType := 'perspectiveHeroicLeftFacing';
c_perspectiveHeroicRightFacing constant ST_PresetCameraType := 'perspectiveHeroicRightFacing';
c_perspectiveHeroicExtrLeftFac constant ST_PresetCameraType := 'perspectiveHeroicExtremeLeftFacing';
c_perspectiveHeroicExtRightFac constant ST_PresetCameraType := 'perspectiveHeroicExtremeRightFacing';
c_perspectiveRelaxed constant ST_PresetCameraType := 'perspectiveRelaxed';
c_perspectiveRelaxedModerately constant ST_PresetCameraType := 'perspectiveRelaxedModerately';

-- ST_LightRigType
subtype ST_LightRigType is ploffx_util.t_string;
c_legacyFlat1 constant ST_LightRigType := 'legacyFlat1';
c_legacyFlat2 constant ST_LightRigType := 'legacyFlat2';
c_legacyFlat3 constant ST_LightRigType := 'legacyFlat3';
c_legacyFlat4 constant ST_LightRigType := 'legacyFlat4';
c_legacyNormal1 constant ST_LightRigType := 'legacyNormal1';
c_legacyNormal2 constant ST_LightRigType := 'legacyNormal2';
c_legacyNormal3 constant ST_LightRigType := 'legacyNormal3';
c_legacyNormal4 constant ST_LightRigType := 'legacyNormal4';
c_legacyHarsh1 constant ST_LightRigType := 'legacyHarsh1';
c_legacyHarsh2 constant ST_LightRigType := 'legacyHarsh2';
c_legacyHarsh3 constant ST_LightRigType := 'legacyHarsh3';
c_legacyHarsh4 constant ST_LightRigType := 'legacyHarsh4';
c_threePt constant ST_LightRigType := 'threePt';
c_balanced constant ST_LightRigType := 'balanced';
c_soft constant ST_LightRigType := 'soft';
c_harsh constant ST_LightRigType := 'harsh';
c_flood constant ST_LightRigType := 'flood';
c_contrasting constant ST_LightRigType := 'contrasting';
c_morning constant ST_LightRigType := 'morning';
c_sunrise constant ST_LightRigType := 'sunrise';
c_sunset constant ST_LightRigType := 'sunset';
c_chilly constant ST_LightRigType := 'chilly';
c_freezing constant ST_LightRigType := 'freezing';
c_flat constant ST_LightRigType := 'flat';
c_twoPt constant ST_LightRigType := 'twoPt';
c_glow constant ST_LightRigType := 'glow';
c_brightRoom constant ST_LightRigType := 'brightRoom';

-- ST_LightRigDirection
subtype ST_LightRigDirection is ploffx_util.t_string;
c_tl constant ST_LightRigDirection := 'tl';
c_t constant ST_LightRigDirection := 't';
c_tr constant ST_LightRigDirection := 'tr';
c_l constant ST_LightRigDirection := 'tl';
c_ctr constant ST_LightRigDirection := 'ctr';
c_r constant ST_LightRigDirection := 'r';
c_bl constant ST_LightRigDirection := 'bl';
c_b constant ST_LightRigDirection := 'b';
c_br constant ST_LightRigDirection := 'br';

-- ST_BevelPresetType
subtype ST_BevelPresetType is ploffx_util.t_string;
c_relaxedInset constant ST_BevelPresetType := 'relaxedInset';
c_circle constant ST_BevelPresetType := 'circle';
c_slope constant ST_BevelPresetType := 'slope';
c_cross constant ST_BevelPresetType := 'cross';
c_angle constant ST_BevelPresetType := 'angle';
c_softRound constant ST_BevelPresetType := 'softRound';
c_convex constant ST_BevelPresetType := 'convex';
c_coolSlant constant ST_BevelPresetType := 'coolSlant';
c_divot constant ST_BevelPresetType := 'divot';
c_riblet constant ST_BevelPresetType := 'riblet';
c_hardEdge constant ST_BevelPresetType := 'hardEdge';
c_artDeco constant ST_BevelPresetType := 'artDeco';

-- ST_PresetMaterialType
subtype ST_PresetMaterialType is ploffx_util.t_string;
c_legacyMatte constant ST_PresetMaterialType := 'legacyMatte';
c_legacyPlastic constant ST_PresetMaterialType := 'legacyPlastic';
c_legacyMetal constant ST_PresetMaterialType := 'legacyMetal';
c_legacyWireframe constant ST_PresetMaterialType := 'legacyWireframe';
c_matte constant ST_PresetMaterialType := 'matte';
c_plastic constant ST_PresetMaterialType := 'plastic';
c_metal constant ST_PresetMaterialType := 'metal';
c_warmMatte constant ST_PresetMaterialType := 'warmMatte';
c_translucentPowder constant ST_PresetMaterialType := 'translucentPowder';
c_powder constant ST_PresetMaterialType := 'powder';
c_dkEdge constant ST_PresetMaterialType := 'dkEdge';
c_softEdge constant ST_PresetMaterialType := 'softEdge';
c_clear constant ST_PresetMaterialType := 'clear';
c_flat constant ST_PresetMaterialType := 'flat';
c_softmetal constant ST_PresetMaterialType := 'softmetal';

-- ST_SystemColorVal
subtype ST_SystemColorVal is ploffx_util.t_string;
c_scrollBar constant ST_SystemColorVal := 'scrollBar';
c_background constant ST_SystemColorVal := 'background';
c_activeCaption constant ST_SystemColorVal := 'activeCaption';
c_inactiveCaption constant ST_SystemColorVal := 'inactiveCaption';
c_menu constant ST_SystemColorVal := 'menu';
c_window constant ST_SystemColorVal := 'window';
c_windowFrame constant ST_SystemColorVal := 'windowFrame';
c_menuText constant ST_SystemColorVal := 'menuText';
c_windowText constant ST_SystemColorVal := 'windowText';
c_captionText constant ST_SystemColorVal := 'captionText';
c_activeBorder constant ST_SystemColorVal := 'activeBorder';
c_inactiveBorder constant ST_SystemColorVal := 'inactiveBorder';
c_appWorkspace constant ST_SystemColorVal := 'appWorkspace';
c_highlight constant ST_SystemColorVal := 'highlight';
c_highlightText constant ST_SystemColorVal := 'highlightText';
c_btnFace constant ST_SystemColorVal := 'btnFace';
c_btnShadow constant ST_SystemColorVal := 'btnShadow';
c_grayText constant ST_SystemColorVal := 'grayText';
c_btnText constant ST_SystemColorVal := 'btnText';
c_inactiveCaptionText constant ST_SystemColorVal := 'inactiveCaptionText';
c_btnHighlight constant ST_SystemColorVal := 'btnHighlight';
c_3dDkShadow constant ST_SystemColorVal := '3dDkShadow';
c_3dLight constant ST_SystemColorVal := '3dLight';
c_infoText constant ST_SystemColorVal := 'infoText';
c_infoBk constant ST_SystemColorVal := 'infoBk';
c_hotLight constant ST_SystemColorVal := 'hotLight';
c_gradientActiveCaption constant ST_SystemColorVal := 'gradientActiveCaption';
c_gradientInactiveCaption constant ST_SystemColorVal := 'gradientInactiveCaption';
c_menuHighlight constant ST_SystemColorVal := 'menuHighlight';
c_menuBar constant ST_SystemColorVal := 'menuBar';

-- CT_Percentage
type CT_Percentage is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2 -- ST_Percentage xsd:int
     );

-- CT_PositiveFixedPercentage
type CT_PositiveFixedPercentage is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2 -- ST_PositiveFixedPercentage xsd:int
     );

-- CT_SchemeColor
type CT_SchemeColor is record(
     tag plx_sc.normalv2,
     tint CT_PositiveFixedPercentage,
     shade CT_PositiveFixedPercentage,
     alpha CT_PositiveFixedPercentage,
     -- hueMod
     -- sat
     -- satOff
     satMod CT_Percentage,
     -- lum
     -- lumOff
     -- lumMod
     val ST_SchemeColorVal
     );

-- CT_SystemColor
type CT_SystemColor is record(
     tag plx_sc.normalv2,
     tint CT_PositiveFixedPercentage,
     shade CT_PositiveFixedPercentage,
     alpha CT_PositiveFixedPercentage,
     -- hueMod
     -- sat
     -- satOff
     satMod CT_Percentage,
     -- lum
     -- lumOff
     -- lumMod
     val ST_SystemColorVal,
     lastClr plx_sc.normalv2 -- ST_HexColorRGB
     );

-- CT_SRgbColor
type CT_SRgbColor is record(
     tag plx_sc.normalv2,
     tint CT_PositiveFixedPercentage,
     shade CT_PositiveFixedPercentage,
     alpha CT_PositiveFixedPercentage,
     -- hueMod
     -- sat
     -- satOff
     satMod CT_Percentage,
     -- lum
     -- lumOff
     -- lumMod
     val plx_sc.normalv2 -- ST_HexColorRGB
     );

-- CT_Color
type CT_Color is record(
     tag plx_sc.normalv2,
     -- scrgbClr
     srgbClr CT_SRgbColor,
     -- hslClr
     sysClr CT_SystemColor,
     schemeClr CT_SchemeColor
     -- prstClr
     );
type t_colors_ is table of CT_Color;
v_colors_empty t_colors_ := t_colors_();

-- CT_ColorScheme
type CT_ColorScheme is record(
     tag plx_sc.normalv2,
     dk1 CT_Color,
     lt1 CT_Color,
     dk2 CT_Color,
     lt2 CT_Color,
     accent1 CT_Color,
     accent2 CT_Color,
     accent3 CT_Color,
     accent4 CT_Color,
     accent5 CT_Color,
     accent6 CT_Color,
     hlink CT_Color,
     folHlink CT_Color,
     -- extLst Extension list
     name_ plx_sc.normalv2 -- xsd:string
     );

-- CT_TextFont
type CT_TextFont is record(
     tag plx_sc.normalv2,
     typeface plx_sc.normalv2, -- ST_TextTypeface
     panose plx_sc.normalv2, -- ST_Panose
     pitchFamily plx_sc.normalv2, -- xsd:byte
     charset plx_sc.normalv2 -- xsd:byte
     );

-- CT_SupplementalFont
type CT_SupplementalFont is record(
     tag plx_sc.normalv2,
     script plx_sc.normalv2, -- xsd:string
     typeface plx_sc.normalv2 -- ST_TextTypeface
     );
-- t_fonts_
type t_fonts_ is table of CT_SupplementalFont;
v_fonts_empty t_fonts_ := t_fonts_();

-- CT_FontCollection
type CT_FontCollection is record(
     tag plx_sc.normalv2,
     latin CT_TextFont,
     ea CT_TextFont,
     cs CT_TextFont,
     font t_fonts_
     -- extLst Extension list
     );

-- CT_FontScheme
type CT_FontScheme is record(
     tag plx_sc.normalv2,
     majorFont CT_FontCollection,
     minorFont CT_FontCollection,
     -- extLst Extension list
     name_ plx_sc.normalv2
     );

-- CT_LinearShadeProperties
type CT_LinearShadeProperties is record(
     tag plx_sc.normalv2,
     ang plx_sc.normalv2, -- ST_PositiveFixedAngle
     scaled plx_sc.normalv2 --xsd:boolean
     );

-- CT_RelativeRect
type CT_RelativeRect is record(
     tag plx_sc.normalv2,
     l plx_sc.normalv2, -- ST_Percentage xsd:int
     t plx_sc.normalv2, -- ST_Percentage xsd:int
     r plx_sc.normalv2, -- ST_Percentage xsd:int
     b plx_sc.normalv2 -- ST_Percentage xsd:int
     );

-- CT_PathShadeProperties
type CT_PathShadeProperties is record(
     tag plx_sc.normalv2,
     fillToRect CT_RelativeRect,
     path ST_PathShadeType
     );

-- CT_GradientStop
type CT_GradientStop is record(
     tag plx_sc.normalv2,
     -- scrgbClr
     srgbClr CT_SRgbColor,
     -- hslClr
     sysClr CT_SystemColor,
     schemeClr CT_SchemeColor,
     -- prstClr
     pos plx_sc.normalv2 -- ST_PositiveFixedPercentage xsd:int
     );
--
type t_gs_ is table of CT_GradientStop;
v_gs_empty t_gs_ := t_gs_();

-- CT_GradientStopLsit
type CT_GradientStopLsit is record(
     tag plx_sc.normalv2,
     gs t_gs_
     );

-- CT_GradientFillProperties
type CT_GradientFillProperties is record(
     tag plx_sc.normalv2,
     gsLst CT_GradientStopLsit,
     lin CT_LinearShadeProperties,
     path CT_PathShadeProperties,
     -- tileRect CT_RelativeRect,
     flip ST_TileFlipMode,
     rotWithShape plx_sc.normalv2 -- xsd:boolean
     );
--
type t_gradFill_ is table of CT_GradientFillProperties;
v_gradFill_empty t_gradFill_ := t_gradFill_();

-- CT_FillStyleList
type CT_FillStyleList is record(
     tag plx_sc.normalv2,
     --noFill CT_NoFillProperties,
     solidFill t_colors_, -- CT_SolidColorFillProperties
     gradFill t_gradFill_
     --blipFill CT_BlipFillProperties,
     --pattFill CT_PatternFillProperties,
     --grpFill CT_GroupFillProperties
     );

-- CT_PresetLineDashProperties
type CT_PresetLineDashProperties is record(
     tag plx_sc.normalv2,
     val ST_PresetLineDashVal
     );

-- CT_LineProperties
type CT_LineProperties is record(
     tag plx_sc.normalv2,
     prstDash CT_PresetLineDashProperties,
     solidFill CT_Color, -- CT_SolidColorFillProperties
     -- bevel
     -- custDash
     -- gradFill
     -- headEnd
     -- miter
     -- noFill
     -- pattFill
     -- round
     -- tailEnd
     -- extLst
     w plx_sc.normalv2, -- ST_LineWidth
     cap ST_LineCap,
     cmpd ST_CompoundLine,
     algn ST_PenAlignment
     );
--
type t_ln_ is table of CT_LineProperties;
v_ln_empty t_ln_ := t_ln_();

-- CT_LineStyleList
type CT_LineStyleList is record(
     tag plx_sc.normalv2,
     ln t_ln_
     );

-- CT_OuterShadowEffect
type CT_OuterShadowEffect is record(
     tag plx_sc.normalv2,
     srgbClr CT_SRgbColor,
     blurRad plx_sc.normalv2, -- ST_PositiveCoordinate
     dist plx_sc.normalv2, -- ST_PositiveCoordinate
     dir plx_sc.normalv2, -- ST_PositiveFixedAngle
     sx plx_sc.normalv2, -- ST_Percentage xsd:int
     sy plx_sc.normalv2, -- ST_Percentage xsd:int
     kx plx_sc.normalv2, -- ST_Percentage xsd:int
     ky plx_sc.normalv2, -- ST_Percentage xsd:int
     algn ST_RectAlignment,
     rotWithShape plx_sc.normalv2 -- xsd:boolean
     );

-- CT_EffectList
type CT_EffectList is record(
     tag plx_sc.normalv2,
     outerShdw CT_OuterShadowEffect
     -- blur
     -- fillOverlay
     -- glow
     -- inneShdw
     -- prstShdw
     -- reflection
     -- softEdge
     );

-- CT_SphereCoords
type CT_SphereCoords is record(
     tag plx_sc.normalv2,
     lat plx_sc.normalv2, -- ST_PositiveFixedAngle
     lon plx_sc.normalv2, -- ST_PositiveFixedAngle
     rev plx_sc.normalv2 -- ST_PositiveFixedAngle
     );

-- CT_Camera
type CT_Camera is record(
     tag plx_sc.normalv2,
     rot CT_SphereCoords,
     prst ST_PresetCameraType,
     fov plx_sc.normalv2, -- ST_FOVAngle
     zoom plx_sc.normalv2 --ST_PositivePercentage
     );

-- CT_LightRig
type CT_LightRig is record(
     tag plx_sc.normalv2,
     rot CT_SphereCoords,
     rig ST_LightRigType,
     dir ST_LightRigDirection
     );

-- CT_Scene3D
type CT_Scene3D is record(
     tag plx_sc.normalv2,
     camera CT_Camera,
     lightRig CT_LightRig
     -- backdrop
     -- extLst Extension list
     );

-- CT_Bevel
type CT_Bevel is record(
     tag plx_sc.normalv2,
     w plx_sc.normalv2, -- ST_PositiveCoordinate
     h plx_sc.normalv2, -- ST_PositiveCoordinate
     prst ST_BevelPresetType
     );

-- CT_Shape3D
type CT_Shape3D is record(
     tag plx_sc.normalv2,
     bevelT CT_Bevel,
     -- bevelB
     -- extrusionClr
     -- contourClr
     -- extLst Extension list
     z plx_sc.normalv2, -- ST_Coordinate
     extrusionH plx_sc.normalv2, -- ST_PositiveCoordinate
     contourW plx_sc.normalv2, -- ST_PositiveCoordinate
     prstMaterial ST_PresetMaterialType
     );

-- CT_EffectStyleItem
type CT_EffectStyleItem is record(
     tag plx_sc.normalv2,
     effectLst CT_EffectList,
     -- effectDag
     scene3d CT_Scene3D,
     sp3D CT_Shape3D
     );
--
type t_effectStyle_ is table of CT_EffectStyleItem;
v_effectStyle_empty t_effectStyle_ := t_effectStyle_();

-- CT_EffectStyleList
type CT_EffectStyleList is record(
     tag plx_sc.normalv2,
     effectStyle t_effectStyle_
     );

-- CT_BackgroundFillStyleList
type CT_BackgroundFillStyleList is record(
     tag plx_sc.normalv2,
     -- noFill
     solidFill t_colors_, -- CT_SolidColorFillProperties,
     gradFill t_gradFill_
     -- blipFill
     -- pattFill
     -- grpFill
     );

-- CT_StyleMatrix (fmtScheme)
type CT_StyleMatrix is record(
     tag plx_sc.normalv2,
     fillStyleLst CT_FillStyleList,
     lnStyleLst CT_LineStyleList,
     effectStyleLst CT_EffectStyleList,
     bgFillStyleLst CT_FillStyleList, -- CT_BackgroundFillStyleList
     name_ plx_sc.normalv2
     );

-- CT_BaseStyles (theme elements)
type CT_BaseStyles is record(
     tag plx_sc.normalv2,
     clrScheme CT_ColorScheme,
     fontScheme CT_FontScheme,
     fmtScheme CT_StyleMatrix
     -- extLst Extension list
     );

-- CT_ObjectStyleDefaults
type CT_ObjectStyleDefaults is record(
     tag plx_sc.normalv2
     -- spDef
     -- lnDef
     -- txDef
     -- extLst Extension list
     );

-- CT_ColorSchemeList
type CT_ColorSchemeList is record(
     tag plx_sc.normalv2
     -- extraClrScheme
     );

-- CT_OfficeStyleSheet (theme)
type CT_OfficeStyleSheet is record(
     tag plx_sc.normalv2,
     themeElements CT_BaseStyles,
     objectDefaults CT_ObjectStyleDefaults,
     extraClrSchemeLst CT_ColorSchemeList,
     -- custClrLst CT_CustomColorList
     -- extLst Extension list
     name_ plx_sc.normalv2 -- xsd:string
     );

/******************************************************************/

-- start
procedure start_;
-- end
procedure end_;

-- accent1
procedure startaccent1(
  p_tag varchar2 default t_accent1
  );
--
procedure endaccent1(
  p_tag varchar2 default t_accent1
  );

-- accent2
procedure startaccent2(
  p_tag varchar2 default t_accent2
  );
--
procedure endaccent2(
  p_tag varchar2 default t_accent2
  );

-- accent3
procedure startaccent3(
  p_tag varchar2 default t_accent3
  );
--
procedure endaccent3(
  p_tag varchar2 default t_accent3
  );

-- accent4
procedure startaccent4(
  p_tag varchar2 default t_accent4
  );
--
procedure endaccent4(
  p_tag varchar2 default t_accent4
  );

-- accent5
procedure startaccent5(
  p_tag varchar2 default t_accent5
  );
--
procedure endaccent5(
  p_tag varchar2 default t_accent5
  );

-- accent6
procedure startaccent6(
  p_tag varchar2 default t_accent6
  );
--
procedure endaccent6(
  p_tag varchar2 default t_accent6
  );

-- alpha
procedure alpha(
  p_tag varchar2 default t_alpha,
  p_val varchar2
  );

-- bevelT
procedure bevelT(
  p_tag varchar2 default t_bevelT,
  p_w varchar2 default null,
  p_h varchar2 default null,
  p_prst varchar2 default null
  );

-- bgFillStyleLst
procedure startbgFillStyleLst(
  p_tag varchar2 default t_bgFillStyleLst
  );
--
procedure endbgFillStyleLst(
  p_tag varchar2 default t_bgFillStyleLst
  );

-- camera
procedure startcamera(
  p_tag varchar2 default t_camera,
  p_prst varchar2,
  p_fov varchar2 default null,
  p_zoom varchar2 default null
  );
--
procedure endcamera(
  p_tag varchar2 default t_camera
  );

-- clrScheme
procedure startclrScheme(
  p_tag varchar2 default t_clrScheme,
  p_name varchar2
  );
--
procedure endclrScheme(
  p_tag varchar2 default t_clrScheme
  );

-- cs
procedure cs(
  p_tag varchar2 default t_cs,
  p_charset varchar2 default null,
  p_panose varchar2 default null,
  p_pitchFamily varchar2 default null,
  p_typeface varchar2 default null
  );

-- dk1
procedure startdk1(
  p_tag varchar2 default t_dk1
  );
--
procedure enddk1(
  p_tag varchar2 default t_dk1
  );

-- dk2
procedure startdk2(
  p_tag varchar2 default t_dk2
  );
--
procedure enddk2(
  p_tag varchar2 default t_dk2
  );

-- ea
procedure ea(
  p_tag varchar2 default t_ea,
  p_charset varchar2 default null,
  p_panose varchar2 default null,
  p_pitchFamily varchar2 default null,
  p_typeface varchar2 default null
  );

-- effectLst
procedure starteffectLst(
  p_tag varchar2 default t_effectLst
  );
--
procedure endeffectLst(
  p_tag varchar2 default t_effectLst
  );

-- effectStyle
procedure starteffectStyle(
  p_tag varchar2 default t_effectStyle
  );
--
procedure endeffectStyle(
  p_tag varchar2 default t_effectStyle
  );

-- effectStyleLst
procedure starteffectStyleLst(
  p_tag varchar2 default t_effectStyleLst
  );
--
procedure endeffectStyleLst(
  p_tag varchar2 default t_effectStyleLst
  );

-- extraClrSchemeLst
procedure startextraClrSchemeLst(
  p_tag varchar2 default t_extraClrSchemeLst
  );
--
procedure endextraClrSchemeLst(
  p_tag varchar2 default t_extraClrSchemeLst
  );

-- fillStyleLst
procedure startfillStyleLst(
  p_tag varchar2 default t_fillStyleLst
  );
--
procedure endfillStyleLst(
  p_tag varchar2 default t_fillStyleLst
  );

-- fillToRect
procedure fillToRect(
  p_tag varchar2 default t_fillToRect,
  p_b varchar2 default null,
  p_l varchar2 default null,
  p_r varchar2 default null,
  p_t varchar2 default null
  );

-- fmtScheme
procedure startfmtScheme(
  p_tag varchar2 default t_fmtScheme,
  p_name varchar2 default null
  );
--
procedure endfmtScheme(
  p_tag varchar2 default t_fmtScheme
  );

-- folHlink
procedure startfolHlink(
  p_tag varchar2 default t_folHlink
  );
--
procedure endfolHlink(
  p_tag varchar2 default t_folHlink
  );

-- font
procedure font(
  p_tag varchar2 default t_font,
  p_typeface varchar2,
  p_script varchar2
  );

-- fontScheme
procedure startfontScheme(
  p_tag varchar2 default t_fontScheme,
  p_name varchar2
  );
--
procedure endfontScheme(
  p_tag varchar2 default t_fontScheme
  );

-- gs
procedure startgs(
  p_tag varchar2 default t_gs,
  p_pos varchar2
  );
--
procedure endgs(
  p_tag varchar2 default t_gs
  );

-- gsLst
procedure startgsLst(
  p_tag varchar2 default t_gsLst
  );
--
procedure endgsLst(
  p_tag varchar2 default t_gsLst
  );

-- gradFill
procedure startgradFill(
  p_tag varchar2 default t_gradFill,
  p_flip varchar2 default null,
  p_rotWithShape varchar2 default null
  );
--
procedure endgradFill(
  p_tag varchar2 default t_gradFill
  );

-- hlink
procedure starthlink(
  p_tag varchar2 default t_hlink
  );
--
procedure endhlink(
  p_tag varchar2 default t_hlink
  );

-- latin
procedure latin(
  p_tag varchar2 default t_latin,
  p_charset varchar2 default null,
  p_panose varchar2 default null,
  p_pitchFamily varchar2 default null,
  p_typeface varchar2 default null
  );

-- lightRig
procedure startlightRig(
  p_tag varchar2 default t_lightRig,
  p_dir varchar2,
  p_rig varchar2
  );
--
procedure endlightRig(
  p_tag varchar2 default t_lightRig
  );

-- lin
procedure lin(
  p_tag varchar2 default t_lin,
  p_scaled varchar2 default null,
  p_ang varchar2 default null
  );

-- ln
procedure startln(
  p_tag varchar2 default t_ln,
  p_w varchar2 default null,
  p_cap varchar2 default null,
  p_cmpd varchar2 default null,
  p_algn varchar2 default null
  );
--
procedure endln(
  p_tag varchar2 default t_ln
  );

-- lnStyleLst
procedure startlnStyleLst(
  p_tag varchar2 default t_lnStyleLst
  );
--
procedure endlnStyleLst(
  p_tag varchar2 default t_lnStyleLst
  );

-- lt1
procedure startlt1(
  p_tag varchar2 default t_lt1
  );
--
procedure endlt1(
  p_tag varchar2 default t_lt1
  );

-- lt2
procedure startlt2(
  p_tag varchar2 default t_lt2
  );
--
procedure endlt2(
  p_tag varchar2 default t_lt2
  );

-- majorFont
procedure startmajorFont(
  p_tag varchar2 default t_majorFont
  );
--
procedure endmajorFont(
  p_tag varchar2 default t_majorFont
  );

-- minorFont
procedure startminorFont(
  p_tag varchar2 default t_minorFont
  );
--
procedure endminorFont(
  p_tag varchar2 default t_minorFont
  );

-- objectDefaults
procedure startobjectDefaults(
  p_tag varchar2 default t_objectDefaults
  );
--
procedure endobjectDefaults(
  p_tag varchar2 default t_objectDefaults
  );

-- outerShdw
procedure startouterShdw(
  p_tag varchar2 default t_outerShdw,
  p_algn varchar2 default null,
  p_blurRad varchar2 default null,
  p_dir varchar2 default null,
  p_dist varchar2 default null,
  p_kx varchar2 default null,
  p_ky varchar2 default null,
  p_rotWithShape varchar2 default null,
  p_sx varchar2 default null,
  p_sy varchar2 default null
  );
--
procedure endouterShdw(
  p_tag varchar2 default t_outerShdw
  );

-- path
procedure startpath(
  p_tag varchar2 default t_path,
  p_path varchar2 default null
  );
--
procedure endpath(
  p_tag varchar2 default t_path
  );

-- prstDash
procedure prstDash(
  p_tag varchar2 default t_prstDash,
  p_val varchar2 default null
  );

-- rot
procedure rot(
  p_tag varchar2 default t_rot,
  p_lat varchar2 default null,
  p_lon varchar2 default null,
  p_rev varchar2 default null
  );

-- satMod
procedure satMod(
  p_tag varchar2 default t_satMod,
  p_val varchar2
  );

-- schemeClr
procedure schemeClr(
  p_tag varchar2 default t_schemeClr,
  p_val varchar2
  );

-- schemeClr
procedure startschemeClr(
  p_tag varchar2 default t_schemeClr,
  p_val varchar2
  );
--
procedure endschemeClr(
  p_tag varchar2 default t_schemeClr
  );

-- scene3d
procedure startscene3d(
  p_tag varchar2 default t_scene3d
  );
--
procedure endscene3d(
  p_tag varchar2 default t_scene3d
  );

-- shade
procedure shade(
  p_tag varchar2 default t_shade,
  p_val varchar2
  );

-- solidFill
procedure startsolidFill(
  p_tag varchar2 default t_solidFill
  );
--
procedure endsolidFill(
  p_tag varchar2 default t_solidFill
  );

-- sp3d
procedure startsp3d(
  p_tag varchar2 default t_sp3d,
  p_contourW varchar2 default null,
  p_extrusionH varchar2 default null,
  p_prstMaterial varchar2 default null,
  p_z varchar2 default null
  );
--
procedure endsp3d(
  p_tag varchar2 default t_sp3d
  );

-- srgbClr
procedure srgbClr(
  p_tag varchar2 default t_srgbClr,
  p_val varchar2
  );

-- srgbClr
procedure startsrgbClr(
  p_tag varchar2 default t_srgbClr,
  p_val varchar2
  );
--
procedure endsrgbClr(
  p_tag varchar2 default t_srgbClr
  );

-- sysClr
procedure sysClr(
  p_tag varchar2 default t_sysClr,
  p_lastClr varchar2 default null,
  p_val varchar2
  );

-- theme
procedure starttheme(
  p_tag varchar2 default t_theme,
  p_name varchar2 default null
  );
--
procedure endtheme(
  p_tag varchar2 default t_theme
  );

-- themeElements
procedure startthemeElements(
  p_tag varchar2 default t_themeElements
  );
--
procedure endthemeElements(
  p_tag varchar2 default t_themeElements
  );

-- tint
procedure tint(
  p_tag varchar2 default t_tint,
  p_val varchar2
  );

/******************************************************************/
-- Create structure

------------------------------------------
-- theme: CT_OfficeStyleSheet
function cr_theme(
  p_tag plx_sc.normalv2 default t_theme,
  p_themeElements CT_BaseStyles default null,
  p_objectDefaults CT_ObjectStyleDefaults default null,
  p_extraClrSchemeLst CT_ColorSchemeList default null,
  -- custClrLst CT_CustomColorList
  -- extLst Extension list
  p_name_ plx_sc.normalv2 default null -- xsd:string
  ) return CT_OfficeStyleSheet;

------------------------------------------
-- objectDefaults : CT_ObjectStyleDefaults
function cr_objectDefaults(
  p_tag plx_sc.normalv2 default t_objectDefaults
  -- spDef
  -- lnDef
  -- txDef
  -- extLst Extension list
  ) return CT_ObjectStyleDefaults;

------------------------------------------
-- extraClrSchemeLst : CT_ColorSchemeList
function cr_extraClrSchemeLst(
  p_tag plx_sc.normalv2 default t_extraClrSchemeLst
  -- extraClrScheme
  ) return CT_ColorSchemeList;


------------------------------------------
-- themeElements: CT_BaseStyles
function cr_themeElements(
  p_tag plx_sc.normalv2 default t_themeElements,
  p_clrScheme CT_ColorScheme default null,
  p_fontScheme CT_FontScheme default null,
  p_fmtScheme CT_StyleMatrix default null
  ) return CT_BaseStyles;

------------------------------------------
-- clrScheme: CT_ColorScheme
function cr_clrScheme(
  p_tag plx_sc.normalv2 default t_clrScheme,
  p_dk1 CT_Color default null,
  p_lt1 CT_Color default null,
  p_dk2 CT_Color default null,
  p_lt2 CT_Color default null,
  p_accent1 CT_Color default null,
  p_accent2 CT_Color default null,
  p_accent3 CT_Color default null,
  p_accent4 CT_Color default null,
  p_accent5 CT_Color default null,
  p_accent6 CT_Color default null,
  p_hlink CT_Color default null,
  p_folHlink CT_Color default null,
  -- extLst Extension list
  p_name plx_sc.normalv2 default null
  ) return CT_ColorScheme;

------------------------------------------
-- dk1: CT_Color
function cr_dk1(
  p_tag plx_sc.normalv2 default t_dk1,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- lt1: CT_Color
function cr_lt1(
  p_tag plx_sc.normalv2 default t_lt1,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- dk2: CT_Color
function cr_dk2(
  p_tag plx_sc.normalv2 default t_dk2,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- lt2: CT_Color
function cr_lt2(
  p_tag plx_sc.normalv2 default t_lt2,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent1: CT_Color
function cr_accent1(
  p_tag plx_sc.normalv2 default t_accent1,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent2: CT_Color
function cr_accent2(
  p_tag plx_sc.normalv2 default t_accent2,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent3: CT_Color
function cr_accent3(
  p_tag plx_sc.normalv2 default t_accent3,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent4: CT_Color
function cr_accent4(
  p_tag plx_sc.normalv2 default t_accent4,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent5: CT_Color
function cr_accent5(
  p_tag plx_sc.normalv2 default t_accent5,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- accent6: CT_Color
function cr_accent6(
  p_tag plx_sc.normalv2 default t_accent6,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- hlink: CT_Color
function cr_hlink(
  p_tag plx_sc.normalv2 default t_hlink,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- folHlink: CT_Color
function cr_folHlink(
  p_tag plx_sc.normalv2 default t_folHlink,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;

------------------------------------------
-- srgbClr: CT_SRgbColor
function cr_srgbClr(
  p_tag plx_sc.normalv2 default t_srgbClr,
  p_tint CT_PositiveFixedPercentage default null,
  p_shade CT_PositiveFixedPercentage default null,
  p_alpha CT_PositiveFixedPercentage default null,
  -- hueMod
  -- sat
  -- satOff
  p_satMod CT_Percentage default null,
  -- lum
  -- lumOff
  -- lumMod
  p_val plx_sc.normalv2 default null -- ST_HexColorRGB
  ) return CT_SRgbColor;

------------------------------------------
-- sysClr: CT_SystemColor
function cr_sysClr(
  p_tag plx_sc.normalv2 default t_sysClr,
  p_tint CT_PositiveFixedPercentage default null,
  p_shade CT_PositiveFixedPercentage default null,
  p_alpha CT_PositiveFixedPercentage default null,
  -- hueMod
  -- sat
  -- satOff
  p_satMod CT_Percentage default null,
  -- lum
  -- lumOff
  -- lumMod
  p_val ST_SystemColorVal default null,
  p_lastClr plx_sc.normalv2 default null -- ST_HexColorRGB
  ) return CT_SystemColor;

------------------------------------------
-- schemeClr: CT_SchemeColor
function cr_schemeClr(
  p_tag plx_sc.normalv2 default t_schemeClr,
  p_tint CT_PositiveFixedPercentage default null,
  p_shade CT_PositiveFixedPercentage default null,
  p_alpha CT_PositiveFixedPercentage default null,
  -- hueMod
  -- sat
  -- satOff
  p_satMod CT_Percentage default null,
  -- lum
  -- lumOff
  -- lumMod
  p_val ST_SystemColorVal default null
  ) return CT_SchemeColor;


------------------------------------------
-- tint: CT_PositiveFixedPercentage
function cr_tint(
  p_tag plx_sc.normalv2 default t_tint,
  p_val plx_sc.normalv2 default null
  ) return CT_PositiveFixedPercentage;

------------------------------------------
-- alpha: CT_PositiveFixedPercentage
function cr_alpha(
  p_tag plx_sc.normalv2 default t_alpha,
  p_val plx_sc.normalv2 default null
  ) return CT_PositiveFixedPercentage;

------------------------------------------
-- shade: CT_PositiveFixedPercentage
function cr_shade(
  p_tag plx_sc.normalv2 default t_shade,
  p_val plx_sc.normalv2 default null
  ) return CT_PositiveFixedPercentage;

------------------------------------------
-- satMod: CT_Percentage
function cr_satMod(
  p_tag plx_sc.normalv2 default t_satMod,
  p_val plx_sc.normalv2 default null
  ) return CT_Percentage;

------------------------------------------
-- fontScheme: CT_FontScheme
function cr_fontScheme(
  p_tag plx_sc.normalv2 default t_fontScheme,
  p_majorFont CT_FontCollection default null,
  p_minorFont CT_FontCollection default null,
  -- extLst Extension list
  p_name_ plx_sc.normalv2 default null
  ) return CT_FontScheme;

------------------------------------------
-- majorFont: CT_FontCollection
function cr_majorFont(
  p_tag plx_sc.normalv2 default t_majorFont,
  p_latin CT_TextFont default null,
  p_ea CT_TextFont default null,
  p_cs CT_TextFont default null,
  p_font t_fonts_ default null
  -- extLst Extension list
  ) return CT_FontCollection;

------------------------------------------
-- minorFont: CT_FontCollection
function cr_minorFont(
  p_tag plx_sc.normalv2 default t_minorFont,
  p_latin CT_TextFont default null,
  p_ea CT_TextFont default null,
  p_cs CT_TextFont default null,
  p_font t_fonts_ default null
  ) return CT_FontCollection;

------------------------------------------
-- latin: CT_TextFont
function cr_latin(
  p_tag plx_sc.normalv2 default t_latin,
  p_typeface plx_sc.normalv2 default null, -- ST_TextTypeface
  p_panose plx_sc.normalv2 default null, -- ST_Panose
  p_pitchFamily plx_sc.normalv2 default null, -- xsd:byte
  p_charset plx_sc.normalv2 default null -- xsd:byte
  ) return CT_TextFont;

------------------------------------------
-- ea: CT_TextFont
function cr_ea(
  p_tag plx_sc.normalv2 default t_ea,
  p_typeface plx_sc.normalv2 default null, -- ST_TextTypeface
  p_panose plx_sc.normalv2 default null, -- ST_Panose
  p_pitchFamily plx_sc.normalv2 default null, -- xsd:byte
  p_charset plx_sc.normalv2 default null -- xsd:byte
  ) return CT_TextFont;

------------------------------------------
-- cs: CT_TextFont
function cr_cs(
  p_tag plx_sc.normalv2 default t_cs,
  p_typeface plx_sc.normalv2 default null, -- ST_TextTypeface
  p_panose plx_sc.normalv2 default null, -- ST_Panose
  p_pitchFamily plx_sc.normalv2 default null, -- xsd:byte
  p_charset plx_sc.normalv2 default null -- xsd:byte
  ) return CT_TextFont;

------------------------------------------
-- font: CT_SupplementalFont
function cr_font(
  p_tag plx_sc.normalv2 default t_font,
  p_script plx_sc.normalv2 default null, -- xsd:string
  p_typeface plx_sc.normalv2 default null -- ST_TextTypeface
  ) return CT_SupplementalFont;
-- font: t_font_
procedure add_font(
  p_table in out t_fonts_,
  p_font CT_SupplementalFont
  );

------------------------------------------
-- fmtScheme: CT_StyleMatrix
function cr_fmtScheme(
  p_tag plx_sc.normalv2 default t_fmtScheme,
  p_fillStyleLst CT_FillStyleList default null,
  p_lnStyleLst CT_LineStyleList default null,
  p_effectStyleLst CT_EffectStyleList default null,
  p_bgFillStyleLst CT_FillStyleList default null,
  p_name_ plx_sc.normalv2 default null
  ) return CT_StyleMatrix;

------------------------------------------
-- fillStyleLst: CT_FillStyleList
function cr_fillStyleLst(
  p_tag plx_sc.normalv2 default t_fillStyleLst,
  --noFill CT_NoFillProperties,
  p_solidFill t_colors_ default null, -- CT_SolidColorFillProperties
  p_gradFill t_gradFill_ default null
  --blipFill CT_BlipFillProperties,
  --pattFill CT_PatternFillProperties,
  --grpFill CT_GroupFillProperties
  ) return CT_FillStyleList;

------------------------------------------
-- lnStyleLst: CT_LineStyleList
function cr_lnStyleLst(
  p_tag plx_sc.normalv2 default t_lnStyleLst,
  p_ln t_ln_ default null
  ) return CT_LineStyleList;

------------------------------------------
-- effectStyleLst: CT_EffectStyleList
function cr_effectStyleLst(
  p_tag plx_sc.normalv2 default t_effectStyleLst,
  p_effectStyle t_effectStyle_ default null
  ) return CT_EffectStyleList;

------------------------------------------
-- bgFillStyleLst: CT_BackgroundFillStyleList
function cr_bgFillStyleLst(
  p_tag plx_sc.normalv2 default t_bgFillStyleLst,
  --noFill CT_NoFillProperties,
  p_solidFill t_colors_ default null, -- CT_SolidColorFillProperties
  p_gradFill t_gradFill_ default null
  --blipFill CT_BlipFillProperties,
  --pattFill CT_PatternFillProperties,
  --grpFill CT_GroupFillProperties
  ) return CT_FillStyleList;


------------------------------------------
-- solidFill: CT_Color
function cr_solidFill(
  p_tag plx_sc.normalv2 default t_solidFill,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  -- prstClr
  ) return CT_Color;
-- solidFill : t_colors_
procedure add_solidFill(
  p_table in out t_colors_,
  p_solidFill CT_Color
  );

------------------------------------------
-- gradFill: CT_GradientFillProperties
function cr_gradFill(
  p_tag plx_sc.normalv2 default t_gradFill,
  p_gsLst CT_GradientStopLsit default null,
  p_lin CT_LinearShadeProperties default null,
  p_path CT_PathShadeProperties default null,
  -- tileRect CT_RelativeRect,
  p_flip ST_TileFlipMode default null,
  p_rotWithShape plx_sc.normalv2 default null -- xsd:boolean
  ) return CT_GradientFillProperties;
-- gradFill : CT_GradientFillProperties
procedure add_gradFill(
  p_table in out t_gradFill_,
  p_gradFill CT_GradientFillProperties
  );

------------------------------------------
-- gsLst: CT_GradientStopLsit
function cr_gsLst(
  p_tag plx_sc.normalv2 default t_gsLst,
  p_gs t_gs_ default null
  ) return CT_GradientStopLsit;

------------------------------------------
-- lin: CT_LinearShadeProperties
function cr_lin(
  p_tag plx_sc.normalv2 default t_lin,
  p_ang plx_sc.normalv2 default null,
  p_scaled plx_sc.normalv2 default null
  ) return CT_LinearShadeProperties;

------------------------------------------
-- path: CT_PathShadeProperties
function cr_path(
  p_tag plx_sc.normalv2 default t_path,
  p_fillToRect CT_RelativeRect default null,
  p_path ST_PathShadeType default null
  ) return CT_PathShadeProperties;

------------------------------------------
-- gs: CT_GradientStop
function cr_gs(
  p_tag plx_sc.normalv2 default t_gs,
  -- scrgbClr
  p_srgbClr CT_SRgbColor default null,
  -- hslClr
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null,
  -- prstClr
  p_pos plx_sc.normalv2 default null -- ST_PositiveFixedPercentage xsd:int
  ) return CT_GradientStop;
-- gs: t_gs_
procedure add_gs(
  p_table in out t_gs_,
  p_gs CT_GradientStop
  );

------------------------------------------
-- fillToRect: CT_RelativeRect
function cr_fillToRect(
  p_tag plx_sc.normalv2 default t_fillToRect,
  p_l plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_t plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_r plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_b plx_sc.normalv2 default null -- ST_Percentage xsd:int
  ) return CT_RelativeRect;

------------------------------------------
-- ln: CT_LineProperties
function cr_ln(
  p_tag plx_sc.normalv2 default t_ln,
  p_prstDash CT_PresetLineDashProperties default null,
  p_solidFill CT_Color default null, -- CT_SolidColorFillProperties
  -- bevel
  -- custDash
  -- gradFill
  -- headEnd
  -- miter
  -- noFill
  -- pattFill
  -- round
  -- tailEnd
  -- extLst
  p_w plx_sc.normalv2  default null, -- ST_LineWidth
  p_cap ST_LineCap default null,
  p_cmpd ST_CompoundLine default null,
  p_algn ST_PenAlignment default null
  ) return CT_LineProperties;
-- ln: t_ln_
procedure add_ln(
  p_table in out t_ln_,
  p_ln CT_LineProperties
  );

------------------------------------------
-- prstDash: CT_PresetLineDashProperties
function cr_prstDash(
  p_tag plx_sc.normalv2 default t_prstDash,
  p_val ST_PresetLineDashVal default null
  ) return CT_PresetLineDashProperties;

------------------------------------------
-- effectStyle: CT_EffectStyleItem
function cr_effectStyle(
  p_tag plx_sc.normalv2 default t_effectStyle,
  p_effectLst CT_EffectList default null,
  -- effectDag
  p_scene3d CT_Scene3D default null,
  p_sp3D CT_Shape3D default null
  ) return CT_EffectStyleItem;
-- effectStyle: t_effectStyle_
procedure add_effectStyle(
  p_table in out t_effectStyle_,
  p_effectStyle CT_EffectStyleItem
  );

------------------------------------------
-- effectLst: CT_EffectList
function cr_effectLst(
  p_tag plx_sc.normalv2 default t_effectLst,
  p_outerShdw CT_OuterShadowEffect default null
  -- blur
  -- fillOverlay
  -- glow
  -- inneShdw
  -- prstShdw
  -- reflection
  -- softEdge
  ) return CT_EffectList;

------------------------------------------
-- scene3d: CT_Scene3D
function cr_scene3d(
  p_tag plx_sc.normalv2 default t_scene3d,
  p_camera CT_Camera default null,
  p_lightRig CT_LightRig default null
  -- backdrop
  -- extLst Extension list
  ) return CT_Scene3D;

------------------------------------------
-- sp3D: CT_Shape3D
function cr_sp3D(
  p_tag plx_sc.normalv2 default t_sp3D,
  p_bevelT CT_Bevel default null,
  -- bevelB
  -- extrusionClr
  -- contourClr
  -- extLst Extension list
  p_z plx_sc.normalv2 default null, -- ST_Coordinate
  p_extrusionH plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_contourW plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_prstMaterial ST_PresetMaterialType default null
  ) return CT_Shape3D;


------------------------------------------
-- outerShdw: CT_OuterShadowEffect
function cr_outerShdw(
  p_tag plx_sc.normalv2 default t_outerShdw,
  p_srgbClr CT_SRgbColor default null,
  p_blurRad plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_dist plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_dir plx_sc.normalv2 default null, -- ST_PositiveFixedAngle
  p_sx plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_sy plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_kx plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_ky plx_sc.normalv2 default null, -- ST_Percentage xsd:int
  p_algn ST_RectAlignment default null,
  p_rotWithShape plx_sc.normalv2 default null -- xsd:boolean
  ) return CT_OuterShadowEffect;

------------------------------------------
-- camera: CT_Camera
function cr_camera(
  p_tag plx_sc.normalv2 default t_camera,
  p_rot CT_SphereCoords default null,
  p_prst ST_PresetCameraType default null,
  p_fov plx_sc.normalv2 default null, -- ST_FOVAngle
  p_zoom plx_sc.normalv2 default null --ST_PositivePercentage
  ) return CT_Camera;


------------------------------------------
-- lightRig: CT_LightRig
function cr_lightRig(
  p_tag plx_sc.normalv2 default t_lightRig,
  p_rot CT_SphereCoords default null,
  p_rig ST_LightRigType default null,
  p_dir ST_LightRigDirection default null
  ) return CT_LightRig;

------------------------------------------
-- bevelT: CT_Bevel
function cr_bevelT(
  p_tag plx_sc.normalv2 default t_bevelT,
  p_w plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_h plx_sc.normalv2 default null, -- ST_PositiveCoordinate
  p_prst ST_BevelPresetType default null
  ) return CT_Bevel;

------------------------------------------
-- rot: CT_SphereCoords
function cr_rot(
  p_tag plx_sc.normalv2 default t_rot,
  p_lat plx_sc.normalv2, -- ST_PositiveFixedAngle
  p_lon plx_sc.normalv2, -- ST_PositiveFixedAngle
  p_rev plx_sc.normalv2 -- ST_PositiveFixedAngle
  ) return CT_SphereCoords;


/******************************************************************/
-- Generate XML part

---------------------------------------
-- theme: CT_OfficeStyleSheet
procedure gen_theme(
  p_theme CT_OfficeStyleSheet
  );

---------------------------------------
-- objectDefaults: CT_ObjectStyleDefaults
procedure gen_objectDefaults(
  p_objectDefaults CT_ObjectStyleDefaults
  );

---------------------------------------
-- extraClrSchemeLst: CT_ColorSchemeList
procedure gen_extraClrSchemeLst(
  p_extraClrSchemeLst CT_ColorSchemeList
  );

---------------------------------------
-- themeElements: CT_BaseStyles
procedure gen_themeElements(
  p_themeElements CT_BaseStyles
  );

---------------------------------------
-- clrScheme: CT_ColorScheme
procedure gen_clrScheme(
  p_clrScheme CT_ColorScheme
  );

---------------------------------------
-- dk1: CT_Color
procedure gen_dk1(
  p_dk1 CT_Color
  );

---------------------------------------
-- lt1: CT_Color
procedure gen_lt1(
  p_lt1 CT_Color
  );

---------------------------------------
-- dk2: CT_Color
procedure gen_dk2(
  p_dk2 CT_Color
  );

---------------------------------------
-- lt2: CT_Color
procedure gen_lt2(
  p_lt2 CT_Color
  );

---------------------------------------
-- accent1: CT_Color
procedure gen_accent1(
  p_accent1 CT_Color
  );

---------------------------------------
-- accent2: CT_Color
procedure gen_accent2(
  p_accent2 CT_Color
  );

---------------------------------------
-- accent3: CT_Color
procedure gen_accent3(
  p_accent3 CT_Color
  );

---------------------------------------
-- accent4: CT_Color
procedure gen_accent4(
  p_accent4 CT_Color
  );

---------------------------------------
-- accent5: CT_Color
procedure gen_accent5(
  p_accent5 CT_Color
  );

---------------------------------------
-- accent6: CT_Color
procedure gen_accent6(
  p_accent6 CT_Color
  );

---------------------------------------
-- hlink: CT_Color
procedure gen_hlink(
  p_hlink CT_Color
  );

---------------------------------------
-- folHlink: CT_Color
procedure gen_folHlink(
  p_folHlink CT_Color
  );

---------------------------------------
-- srgbClr: CT_SRgbColor
procedure gen_srgbClr(
  p_srgbClr CT_SRgbColor
  );

---------------------------------------
-- sysClr: CT_SystemColor
procedure gen_sysClr(
  p_sysClr CT_SystemColor
  );

---------------------------------------
-- schemeClr: CT_SchemeColor
procedure gen_schemeClr(
  p_schemeClr CT_SchemeColor
  );

------------------------------------------
-- tint: CT_PositiveFixedPercentage
procedure gen_tint(
  p_tint CT_PositiveFixedPercentage
  );

------------------------------------------
-- alpha: CT_PositiveFixedPercentage
procedure gen_alpha(
  p_alpha CT_PositiveFixedPercentage
  );

------------------------------------------
-- shade: CT_PositiveFixedPercentage
procedure gen_shade(
  p_shade CT_PositiveFixedPercentage
  );

------------------------------------------
-- satMod: CT_Percentage
procedure gen_satMod(
  p_satMod CT_Percentage
  );

------------------------------------------
-- fontScheme: CT_FontScheme
procedure gen_fontScheme(
  p_fontScheme CT_FontScheme
  );

------------------------------------------
-- majorFont: CT_FontCollection
procedure gen_majorFont(
  p_majorFont CT_FontCollection
  );

------------------------------------------
-- minorFont: CT_FontCollection
procedure gen_minorFont(
  p_minorFont CT_FontCollection
  );

------------------------------------------
-- latin: CT_TextFont
procedure gen_latin(
  p_latin CT_TextFont
  );

------------------------------------------
-- ea: CT_TextFont
procedure gen_ea(
  p_ea CT_TextFont
  );

------------------------------------------
-- cs: CT_TextFont
procedure gen_cs(
  p_cs CT_TextFont
  );

------------------------------------------
-- font: CT_SupplementalFont
procedure gen_font(
  p_font CT_SupplementalFont
  );

------------------------------------------
-- fmtScheme: CT_StyleMatrix
procedure gen_fmtScheme(
  p_fmtScheme CT_StyleMatrix
  );

------------------------------------------
-- fillStyleLst: CT_FillStyleList
procedure gen_fillStyleLst(
  p_fillStyleLst CT_FillStyleList
  );

------------------------------------------
-- lnStyleLst: CT_LineStyleList
procedure gen_lnStyleLst(
  p_lnStyleLst CT_LineStyleList
  );

------------------------------------------
-- effectStyleLst: CT_EffectStyleList
procedure gen_effectStyleLst(
  p_effectStyleLst CT_EffectStyleList
  );

------------------------------------------
-- bgFillStyleLst: CT_BackgroundFillStyleList
procedure gen_bgFillStyleLst(
  p_bgFillStyleLst CT_FillStyleList
  );

------------------------------------------
-- solidFill: CT_Color
procedure gen_solidFill(
  p_solidFill CT_Color
  );

------------------------------------------
-- gradFill: CT_GradientFillProperties
procedure gen_gradFill(
  p_gradFill CT_GradientFillProperties
  );

------------------------------------------
-- gsLst: CT_GradientStopLsit
procedure gen_gsLst(
  p_gsLst CT_GradientStopLsit
  );

------------------------------------------
-- lin: CT_LinearShadeProperties
procedure gen_lin(
  p_lin CT_LinearShadeProperties
  );

------------------------------------------
-- path: CT_PathShadeProperties
procedure gen_path(
  p_path CT_PathShadeProperties
  );

------------------------------------------
-- gs: CT_GradientStop
procedure gen_gs(
  p_gs CT_GradientStop
  );

------------------------------------------
-- fillToRect: CT_RelativeRect
procedure gen_fillToRect(
  p_fillToRect CT_RelativeRect
  );

------------------------------------------
-- ln: CT_LineProperties
procedure gen_ln(
  p_ln CT_LineProperties
  );

------------------------------------------
-- prstDash: CT_PresetLineDashProperties
procedure gen_prstDash(
  p_prstDash CT_PresetLineDashProperties
  );

------------------------------------------
-- effectStyle: CT_EffectStyleItem
procedure gen_effectStyle(
  p_effectStyle CT_EffectStyleItem
  );

------------------------------------------
-- effectLst: CT_EffectList
procedure gen_effectLst(
  p_effectLst CT_EffectList
  );

------------------------------------------
-- scene3d: CT_Scene3D
procedure gen_scene3d(
  p_scene3d CT_Scene3D
  );

------------------------------------------
-- sp3D: CT_Shape3D
procedure gen_sp3D(
  p_sp3D CT_Shape3D
  );

------------------------------------------
-- outerShdw: CT_OuterShadowEffect
procedure gen_outerShdw(
  p_outerShdw CT_OuterShadowEffect
  );

------------------------------------------
-- camera: CT_Camera
procedure gen_camera(
  p_camera CT_Camera
  );

------------------------------------------
-- lightRig: CT_LightRig
procedure gen_lightRig(
  p_lightRig CT_LightRig
  );

------------------------------------------
-- bevelT: CT_Bevel
procedure gen_bevelT(
  p_bevelT CT_Bevel
  );

------------------------------------------
-- rot: CT_SphereCoords
procedure gen_rot(
  p_rot CT_SphereCoords
  );

------------------------------------------
-- GEN_XML
procedure gen_xml(
  p_theme CT_OfficeStyleSheet
  );


/************************************************************/
-- Parse and preprocessed parts

------------------------------------------
-- PARSE_XML
function parse(
  p_file clob
  ) return CT_OfficeStyleSheet;

-- v1.3.0
procedure get1;

-- v2.0.0
-- procedure docx_theme_init;

procedure docx_theme_init(
  p_theme in out CT_OfficeStyleSheet
  );

--
end ploffx_theme;
/

