create or replace package ploffx_sheet
authid current_user is
--v5.9
--
-- XT PaperSize -- custom simple type
subtype XT_PaperSize is ploffx_util.t_string;
  paperSize_A5 constant XT_PaperSize := 'A5';
  paperSize_A4 constant XT_PaperSize := 'A4';
  paperSize_A3 constant XT_PaperSize := 'A3';
--v2.0.0
subtype ST_CellType is plx_sc.normalv2;
c_b constant ST_CellType := 'b'; --boolean
c_e constant ST_CellType := 'e'; --error
c_inlineStr constant ST_CellType := 'inlineStr'; --inline string
c_n constant ST_CellType := 'n'; --number
c_s constant ST_CellType := 's'; --shared string
c_str constant ST_CellType := 'str'; --string
--v4.9.0
subtype ST_CellFormulaType is plx_sc.normalv2;
c_normal constant ST_CellType := 'normal';
c_array constant ST_CellType := 'array';
c_dataTable constant ST_CellType := 'dataTable';
c_shared constant ST_CellType := 'shared';
--
-----------------------------------------------------------------------------------------------------
--v2.0.0
type CT_CellFormula is record (
  tag plx_sc.normalv2,
  formula plx_sc.maxv2, --ST_Xstring
  t ST_CellFormulaType, --v4.9.0
  -- aca xsd:boolean
  ref plx_sc.maxv2, --v4.9.0
  -- dt2D xsd:boolean
  -- dtr xsd:boolean
  -- del1 xsd:boolean
  -- del2 xsd:boolean
  -- r1 ST_CellRef
  -- r2 ST_CellRef
  -- ca xsd:boolean
  si plx_sc.normalv2 --v4.9.0
  -- bx xsd:boolean
  );

--v4.9.4
type CT_Rst is record (
  tag plx_sc.normalv2,
  t plx_sc.maxv2 --text
  --r -- rich text run
  --rPh --phonetic run
  --phoneticPr --phonetic properties
  );

type CT_Cell is record (
  tag plx_sc.normalv2,
  f CT_CellFormula, --formula
  v plx_sc.maxv2, -- value
  is_ CT_Rst, --reach text inline
  --extLst CT_ExtensionList
  r plx_sc.maxv2, -- An A1 style reference to the location of this cell
  s plx_sc.normalv2, --style index
  t ST_CellType --data type
  -- cm xsd:unsignedInt
  -- vm xsd:unsignedInt
  -- ph xsd:boolean
  --technical fields
  --name                plx_sc.normalv2,
  --ref                 plx_sc.normalv2,
  --data_type           varchar2(1 char), --N, S, D
  --format_num_fmt_id   pls_integer default 0,
  --format_font_id      pls_integer default 0,
  --format_fill_id      pls_integer default 0,
  --format_border_id    pls_integer default 0,
  --format_xf_id        pls_integer default 0,
  --bold                boolean default false,
  --italic              boolean default false,
  --underline           boolean default false,
  --color               ploffx_xlsx_styles.ST_UnsignedIntHex,
  --bg_color            ploffx_xlsx_styles.ST_UnsignedIntHex,
  --horizontal_align    ploffx_xlsx_styles.ST_HorizontalAlignment,
  --vertical_align      ploffx_xlsx_styles.ST_VerticalAlignment,
  --null_value          boolean default false,
  --border              ploffx_xlsx_styles.CT_Border,
  --textrotation        pls_integer default 0,
  --wrap_text           boolean default false,
  -- merge_cells         pls_integer,
  -- merge_rows          pls_integer,
  --merge_rows_first    boolean,
  -- hyperlink_id        pls_integer default 0
  );

type t_cells is table of CT_Cell index by pls_integer;

type t_index_cells is table of pls_integer index by plx_sc.normalv2; --v4.9.3

type CT_row is record (
  tag plx_sc.normalv2,
  cells t_cells, --cells
  -- extLst CT_ExtensionList
  r plx_sc.normalv2, -- Row Index xsd:unsignedInt
  spans plx_sc.normalv2, -- ST_CellSpans
  s plx_sc.normalv2,-- Style Index xsd:unsignedInt
  customFormat plx_sc.normalv2, -- xsd:boolean
  ht plx_sc.normalv2, --Row Height xsd:double
  hidden plx_sc.normalv2, -- xsd:boolean
  customHeight plx_sc.normalv2, -- xsd:boolean
  outlineLevel plx_sc.normalv2, --xsd:unsignedByte
  collapsed plx_sc.normalv2, --xsd:boolean
  -- thickTop xsd:boolean
  -- thickBot xsd:boolean
  -- ph xsd:boolean
  --technical fields
  last_cell pls_integer := 0, --v3.3.0
  --format_id number -- not row format, use for all cell,
  --technical
  index_cells t_index_cells, -- cell indexed table, example A, B, C
  merge_cells ploffx_util.t_cellranges --v4.11
  );

type CT_SheetData is table of CT_row index by pls_integer; --rows

--v4.9.1
type CT_PageSetUpPr is record(
  tag plx_sc.normalv2,
  autoPageBreaks plx_sc.normalv2, --xsd:boolean
  fitToPage plx_sc.normalv2 --xsd:boolean
  );

type CT_SheetPr is record (
  tag plx_sc.normalv2,
  -- tabColor CT_Color
  -- outlinePr CT_OutlinePr
  pageSetUpPr CT_PageSetUpPr, --v4.9.1
  -- syncHorizontal xsd:boolean
  -- syncVertical xsd:boolean
  -- syncRef ST_Ref
  -- transitionEvaluation xsd:boolean
  -- transitionEntry xsd:boolean
  -- published xsd:boolean
  codeName plx_sc.normalv2 --stable name of the sheet
  -- filterMode xsd:boolean
  -- enableFormatConditionsCalculation xsd:boolean
  );

--ST_Pane
subtype ST_Pane is plx_sc.normalv2;
c_bottomRight constant ST_Pane := 'bottomRight';
c_topRight constant ST_Pane := 'topRight';
c_bottomLeft constant ST_Pane := 'bottomLeft';
c_topLeft constant ST_Pane := 'topLeft';

type CT_Selection is record (
  tag plx_sc.normalv2,
  pane ST_Pane,
  activeCell plx_sc.normalv2, --ST_CellRef
  activeCellId plx_sc.normalv2, --xsd:unsignedInt
  sqref plx_sc.maxv2 --ST_Sqref --v4.8.3
  );

type CT_Selection_4 is table of CT_Selection; --max 4
v_selections_empty CT_Selection_4 := CT_Selection_4();

--ST_PaneState
subtype ST_PaneState is plx_sc.normalv2;
c_split constant ST_PaneState := 'split';
c_frozen constant ST_PaneState := 'frozen';
c_frozenSplit constant ST_PaneState := 'frozenSplit';

type CT_Pane is record (
  tag plx_sc.normalv2,
  xSplit plx_sc.normalv2, --xsd:double
  ySplit plx_sc.normalv2, --xsd:double
  topLeftCell plx_sc.normalv2, --ST_CellRef
  activePane ST_Pane,
  state ST_PaneState
  );

type CT_SheetView is record (
    tag plx_sc.normalv2,
    pane CT_Pane,
    selection CT_Selection_4, -- maxOccurs="4"
    -- pivotSelection CT_PivotSelection maxOccurs="4"
    -- extLst CT_ExtensionList
    -- windowProtection xsd:boolean
    -- showFormulas xsd:boolean
    showGridLines plx_sc.normalv2, --  xsd:boolean
    -- showRowColHeaders xsd:boolean
    -- showZeros xsd:boolean
    -- rightToLeft xsd:boolean
    tabSelected plx_sc.normalv2, -- xsd:boolean
    -- showRuler xsd:boolean
    -- showOutlineSymbols xsd:boolean
    -- defaultGridColor xsd:boolean
    -- showWhiteSpace xsd:boolean
    -- view ST_SheetViewType
    -- topLeftCell ST_CellRef
    -- colorId xsd:unsignedInt
    zoomScale plx_sc.normalv2, --xsd:unsignedInt
    zoomScaleNormal plx_sc.normalv2, --xsd:unsignedInt
    -- zoomScaleSheetLayoutView xsd:unsignedInt
    -- zoomScalePageLayoutView xsd:unsignedInt
    workbookViewId plx_sc.normalv2 -- xsd:unsignedInt
  );

type CT_SheetViews is table of CT_SheetView;
v_sheetViews_empty CT_SheetViews := CT_SheetViews();

--CT_ExtensionList

type CT_SheetFormatPr is record (
  tag plx_sc.normalv2,
  -- baseColWidth xsd:unsignedInt
  defaultColWidth plx_sc.normalv2, -- xsd:double
  defaultRowHeight plx_sc.normalv2, -- xsd:double
  customHeight plx_sc.normalv2, -- xsd:boolean
  zeroHeight plx_sc.normalv2, -- xsd:boolean
  thickTop plx_sc.normalv2, -- xsd:boolean
  thickBottom plx_sc.normalv2 --xsd:boolean
  -- outlineLevelRow xsd:unsignedByte
  -- outlineLevelCol xsd:unsignedByte
  );

type CT_Col is record (
  tag plx_sc.normalv2,
  min plx_sc.normalv2, -- xsd:unsignedInt
  max plx_sc.normalv2, -- xsd:unsignedInt
  width plx_sc.normalv2, -- xsd:double
  style plx_sc.normalv2, --xsd:unsignedInt
  hidden plx_sc.normalv2, -- xsd:boolean
  bestFit plx_sc.normalv2, --xsd:boolean
  customWidth plx_sc.normalv2, -- xsd:boolean
  -- phonetic xsd:boolean
  outlineLevel plx_sc.normalv2, --xsd:unsignedByte
  collapsed plx_sc.normalv2 --xsd:boolean
  );

type CT_Cols is table of CT_Col;
v_cols_empty CT_Cols := CT_Cols();

/*type CT_SheetProtection (
  algorithmName s:ST_Xstring
  hashValue xsd:base64Binary
  saltValue xsd:base64Binary
  spinCount xsd:unsignedInt
  sheet xsd:boolean
  objects xsd:boolean
  scenarios xsd:boolean
  formatCells xsd:boolean
  formatColumns xsd:boolean
  formatRows xsd:boolean
  insertColumns xsd:boolean
  insertRows xsd:boolean
  insertHyperlinks xsd:boolean
  deleteColumns xsd:boolean
  deleteRows xsd:boolean
  selectLockedCells xsd:boolean
  sort xsd:boolean
  autoFilter xsd:boolean
  pivotTables xsd:boolean
  selectUnlockedCells xsd:boolean
  );*/

type CT_ProtectedRange is record (
  tag plx_sc.normalv2,
  --securityDescriptor
  sqref plx_sc.maxv2, -- ST_Sqref
  name plx_sc.normalv2 -- s:ST_Xstring
  -- algorithmName s:ST_Xstring
  -- hashValue xsd:base64Binary
  -- saltValue xsd:base64Binary
  -- spinCount xsd:unsignedInt
  );

type CT_ProtectedRanges is table of CT_ProtectedRange;
v_protectedRanges_empty CT_ProtectedRanges := CT_ProtectedRanges();

/*type CT_FilterColumn is record (
  -- filters CT_Filters
  -- top10 CT_Top10
  -- customFilters CT_CustomFilters
  -- dynamicFilter CT_DynamicFilter
  -- colorFilter CT_ColorFilter
  -- iconFilter CT_IconFilter
  --extLst CT_ExtensionList
  );*/

-- type t_FilterColumns is table of CT_FilterColumn;

type CT_AutoFilter is record (
  tag plx_sc.normalv2,
  -- filterColumn t_FilterColumns,
  -- sortState CT_SortState
  -- extLst CT_ExtensionList
  ref plx_sc.maxv2 --ST_Ref
  --technical fields
  --column_start plx_sc.normalv2,
  --column_end   plx_sc.normalv2,
  --row_start pls_integer,
  --row_end pls_integer
  );

type CT_MergeCell is record (
  tag plx_sc.normalv2,
  ref plx_sc.maxv2, --ST_Ref
  cellrange ploffx_util.t_cellrange --technical
  );

type CT_MergeCells is table of CT_MergeCell;
v_MergeCells_empty CT_MergeCells := CT_MergeCells();

subtype ST_DataValidationType is plx_sc.normalv2;
c_none constant ST_DataValidationType := 'none';
c_whole constant ST_DataValidationType := 'whole';
c_decimal constant ST_DataValidationType := 'decimal';
c_list constant ST_DataValidationType := 'list';
c_date constant ST_DataValidationType := 'date';
c_time constant ST_DataValidationType := 'time';
c_textLength constant ST_DataValidationType := 'textLength';
c_custom constant ST_DataValidationType := 'custom';

subtype ST_DataValidationErrorStyle is plx_sc.normalv2;
c_stop constant ST_DataValidationErrorStyle := 'stop';
c_warning constant ST_DataValidationErrorStyle := 'warning';
c_information constant ST_DataValidationErrorStyle := 'information';

subtype ST_DataValidationImeMode is plx_sc.normalv2;
c_noControl constant ST_DataValidationImeMode := 'noControl';
c_off constant ST_DataValidationImeMode := 'off';
c_on constant ST_DataValidationImeMode := 'on';
c_disabled constant ST_DataValidationImeMode := 'disabled';
c_hiragana constant ST_DataValidationImeMode := 'hiragana';
c_fullKatakana constant ST_DataValidationImeMode := 'fullKatakana';
c_halfKatakana constant ST_DataValidationImeMode := 'halfKatakana';
c_fullAlpha constant ST_DataValidationImeMode := 'fullAlpha';
c_halfAlpha constant ST_DataValidationImeMode := 'halfAlpha';
c_fullHangul constant ST_DataValidationImeMode := 'fullHangul';
c_halfHangul constant ST_DataValidationImeMode := 'halfHangul';

subtype ST_DataValidationOperator is plx_sc.normalv2;
c_between constant ST_DataValidationOperator := 'between';
c_notBetween constant ST_DataValidationOperator := 'notBetween';
c_equal constant ST_DataValidationOperator := 'equal';
c_notEqual constant ST_DataValidationOperator := 'notEqual';
c_lessThan constant ST_DataValidationOperator := 'lessThan';
c_lessThanOrEqual constant ST_DataValidationOperator := 'lessThanOrEqual';
c_greaterThan constant ST_DataValidationOperator := 'greaterThan';
c_greaterThanOrEqual constant ST_DataValidationOperator := 'greaterThanOrEqual';

type CT_DataValidation is record (
  tag plx_sc.normalv2,
  formula1 plx_sc.maxv2,
  formula2 plx_sc.maxv2,
  type_ ST_DataValidationType,
  errorStyle ST_DataValidationErrorStyle,
  imeMode ST_DataValidationImeMode,
  operator ST_DataValidationOperator,
  allowBlank plx_sc.normalv2, --xsd:boolean
  showDropDown plx_sc.normalv2, --xsd:boolean
  showInputMessage plx_sc.normalv2, --xsd:boolean
  showErrorMessage plx_sc.normalv2, --xsd:boolean
  errorTitle plx_sc.maxv2, --s:ST_Xstring
  error plx_sc.maxv2, --s:ST_Xstring
  promptTitle plx_sc.maxv2, --s:ST_Xstring
  prompt plx_sc.maxv2, --s:ST_Xstring
  sqref plx_sc.maxv2 --ST_Sqref
  );

type t_DataValidations_ is table of CT_DataValidation;
v_datavalidations_empty t_DataValidations_ := t_DataValidations_();

type CT_DataValidations is record (
  tag plx_sc.normalv2,
  dataValidation t_DataValidations_,
  -- disablePrompts xsd:boolean
  -- xWindow xsd:unsignedInt
  -- yWindow xsd:unsignedInt
  count_ plx_sc.normalv2 -- xsd:unsignedInt
  );

type CT_Hyperlink is record (
  tag plx_sc.normalv2,
  ref plx_sc.maxv2, --ST_Ref
  id  plx_sc.normalv2,
  location plx_sc.maxv2, -- s:ST_Xstring
  tooltip  plx_sc.maxv2, -- s:ST_Xstring
  display plx_sc.maxv2 -- s:ST_Xstring
  --technical fields
  --hyperlink plx_sc.normalv2
  );

type CT_Hyperlinks is table of CT_Hyperlink;
v_Hyperlinks_empty CT_Hyperlinks := CT_Hyperlinks();

type CT_PrintOptions is record (
  tag plx_sc.normalv2,
  horizontalCentered plx_sc.normalv2, -- xsd:boolean
  verticalCentered plx_sc.normalv2, -- xsd:boolean
  headings plx_sc.normalv2, -- xsd:boolean
  gridLines plx_sc.normalv2, -- xsd:boolean
  gridLinesSet plx_sc.normalv2 --xsd:boolean
  );

type CT_PageMargins is record (
  tag plx_sc.normalv2,
  left plx_sc.normalv2, -- xsd:double
  right plx_sc.normalv2, --xsd:double
  top plx_sc.normalv2, --xsd:double
  bottom plx_sc.normalv2, --xsd:double
  header plx_sc.normalv2, --xsd:double
  footer plx_sc.normalv2 --xsd:double
  );

subtype ST_Orientation is plx_sc.normalv2;
c_default constant ST_Orientation := 'default';
c_portrait constant ST_Orientation := 'portrait';
c_landscape constant ST_Orientation := 'landscape';

subtype ST_PageOrder is plx_sc.normalv2;
c_downThenOver constant ST_PageOrder := 'downThenOver';
c_overThenDown constant ST_PageOrder := 'overThenDown';

subtype ST_CellComments is plx_sc.normalv2;
c_none constant ST_CellComments := 'none';
c_asDisplayed constant ST_CellComments := 'asDisplayed';
c_atEnd constant ST_CellComments := 'atEnd';

subtype ST_PrintError is plx_sc.normalv2;
c_displayed constant ST_PrintError := 'displayed';
c_blank constant ST_PrintError := 'blank';
c_dash constant ST_PrintError := 'dash';
c_NA constant ST_PrintError := 'NA';

type CT_PageSetup is record (
  tag plx_sc.normalv2,
  paperSize plx_sc.normalv2, --xsd:unsignedInt
  paperHeight plx_sc.normalv2, --s:ST_PositiveUniversalMeasure
  paperWidth plx_sc.normalv2, --s:ST_PositiveUniversalMeasure
  scale plx_sc.normalv2, --xsd:unsignedInt
  firstPageNumber plx_sc.normalv2, --xsd:unsignedInt
  fitToWidth plx_sc.normalv2, --xsd:unsignedInt
  fitToHeight plx_sc.normalv2, --xsd:unsignedInt
  pageOrder ST_PageOrder,
  orientation ST_Orientation,
  usePrinterDefaults plx_sc.normalv2, --xsd:boolean
  blackAndWhite plx_sc.normalv2, --xsd:boolean
  draft plx_sc.normalv2, --xsd:boolean
  cellComments ST_CellComments,
  useFirstPageNumber plx_sc.normalv2, --xsd:boolean
  errors ST_PrintError,
  horizontalDpi plx_sc.normalv2, --xsd:unsignedInt
  verticalDpi plx_sc.normalv2, --xsd:unsignedInt
  copies plx_sc.normalv2, --xsd:unsignedInt
  id plx_sc.normalv2 --plx_sc.normalv2
  );

type CT_HeaderFooter is record (
  tag plx_sc.normalv2,
  oddHeader plx_sc.maxv2, --s:ST_Xstring
  oddFooter plx_sc.maxv2, --s:ST_Xstring
  evenHeader plx_sc.maxv2, --s:ST_Xstring
  evenFooter plx_sc.maxv2, --s:ST_Xstring
  firstHeader plx_sc.maxv2, --s:ST_Xstring
  firstFooter plx_sc.maxv2, --s:ST_Xstring
  differentOddEven plx_sc.normalv2, --xsd:boolean
  differentFirst plx_sc.normalv2, --xsd:boolean
  scaleWithDoc plx_sc.normalv2, --xsd:boolean
  alignWithMargins plx_sc.normalv2 --xsd:boolean
  );

type CT_Drawing is record (
  tag plx_sc.normalv2,
  id plx_sc.normalv2
  );

type CT_SheetBackgroundPicture is record (
  tag plx_sc.normalv2,
  id plx_sc.normalv2
  );

type CT_SheetDimension is record (
  tag plx_sc.normalv2,
  ref plx_sc.normalv2
  );

--legacyDrawing legacyDrawingHF
type CT_LegacyDrawing is record (
  tag plx_sc.normalv2, --
  id plx_sc.normalv2
  );

type t_formula_temp is record (
  row pls_integer,
  cell pls_integer,
  formula plpdf_type.v2max,
  si pls_integer,
  ref plpdf_type.v2max
  );

type t_formulas_temp is table of t_formula_temp index by pls_integer;

--v4.9.4
type t_cfrule_formulas is table of plx_sc.maxv2; --max 3 pcs
v_cfrule_formulas_empty t_cfrule_formulas := t_cfrule_formulas();

--v4.9.4
subtype ST_CfType is plx_sc.normalv2;
c_expression constant ST_CfType := 'expression';
c_cellIs constant ST_CfType := 'cellIs';
c_colorScale constant ST_CfType := 'colorScale';
c_dataBar constant ST_CfType := 'dataBar';
c_iconSet constant ST_CfType := 'iconSet';
c_top10 constant ST_CfType := 'top10';
c_uniqueValues constant ST_CfType := 'uniqueValues';
c_duplicateValues constant ST_CfType := 'duplicateValues';
c_containsText constant ST_CfType := 'containsText';
c_notContainsText constant ST_CfType := 'notContainsText';
c_beginsWith constant ST_CfType := 'beginsWith';
c_endsWith constant ST_CfType := 'endsWith';
c_containsBlanks constant ST_CfType := 'containsBlanks';
c_notContainsBlanks constant ST_CfType := 'notContainsBlanks';
c_containsErrors constant ST_CfType := 'containsErrors';
c_notContainsErrors constant ST_CfType := 'notContainsErrors';
c_timePeriod constant ST_CfType := 'timePeriod';
c_aboveAverage constant ST_CfType := 'aboveAverage';

--v4.9.4
subtype ST_ConditionalFormattingOp is plx_sc.normalv2;
c_lessThan constant ST_ConditionalFormattingOp := 'lessThan';
c_lessThanOrEqual constant ST_ConditionalFormattingOp := 'lessThanOrEqual';
c_equal constant ST_ConditionalFormattingOp := 'equal';
c_notEqual constant ST_ConditionalFormattingOp := 'notEqual';
c_greaterThanOrEqual constant ST_ConditionalFormattingOp := 'greaterThanOrEqual';
c_greaterThan constant ST_ConditionalFormattingOp := 'greaterThan';
c_between constant ST_ConditionalFormattingOp := 'between';
c_notBetween constant ST_ConditionalFormattingOp := 'notBetween';
c_containsText constant ST_ConditionalFormattingOp := 'containsText';
c_notContains constant ST_ConditionalFormattingOp := 'notContains';
c_beginsWith constant ST_ConditionalFormattingOp := 'beginsWith';
c_endsWith constant ST_ConditionalFormattingOp := 'endsWith';

--v4.9.4
subtype ST_TimePeriod is plx_sc.normalv2;
c_today constant ST_TimePeriod := 'today';
c_yesterday constant ST_TimePeriod := 'yesterday';
c_tomorrow constant ST_TimePeriod := 'tomorrow';
c_last7Days constant ST_TimePeriod := 'last7Days';
c_thisMonth constant ST_TimePeriod := 'thisMonth';
c_lastMonth constant ST_TimePeriod := 'lastMonth';
c_nextMonth constant ST_TimePeriod := 'nextMonth';
c_thisWeek constant ST_TimePeriod := 'thisWeek';
c_lastWeek constant ST_TimePeriod := 'lastWeek';
c_nextWeek constant ST_TimePeriod := 'nextWeek';

--v4.9.4
subtype ST_CfvoType is plx_sc.normalv2;
c_num constant ST_CfvoType := 'num';
c_percent constant ST_CfvoType := 'percent';
c_max constant ST_CfvoType := 'max';
c_min constant ST_CfvoType := 'min';
c_formula constant ST_CfvoType := 'formula';
c_percentile constant ST_CfvoType := 'percentile';

--v4.9.4
type CT_Cfvo is record (
  tag plx_sc.normalv2,
  --extLst CT_ExtensionList
  type ST_CfvoType,
  val plx_sc.maxv2,
  gte plx_sc.normalv2
  );

--v4.9.4
type CT_Cfvos is table of CT_Cfvo;
v_CT_Cfvos_empty CT_Cfvos := CT_Cfvos();

--v4.9.4
type CT_Color is record(
  tag plx_sc.normalv2,
  auto plx_sc.normalv2,
  indexed plx_sc.normalv2,
  rgb plx_sc.normalv2, --ploffx_xlsx_styles.ST_UnsignedIntHex
  theme plx_sc.normalv2,
  tint plx_sc.normalv2
  );

--v4.9.4
type CT_Colors is table of CT_Color;
v_CT_Colors_empty CT_Colors := CT_Colors();

--v4.9.4
subtype ST_IconSetType is plx_sc.normalv2;
c_3Arrows constant ST_IconSetType := '3Arrows';
c_3ArrowsGray constant ST_IconSetType := '3ArrowsGray';
c_3Flags constant ST_IconSetType := '3Flags';
c_3TrafficLights1 constant ST_IconSetType := '3TrafficLights1';
c_3TrafficLights2 constant ST_IconSetType := '3TrafficLights2';
c_3Signs constant ST_IconSetType := '3Signs';
c_3Symbols constant ST_IconSetType := '3Symbols';
c_3Symbols2 constant ST_IconSetType := '3Symbols2';
c_4Arrows constant ST_IconSetType := '4Arrows';
c_4ArrowsGray constant ST_IconSetType := '4ArrowsGray';
c_4RedToBlack constant ST_IconSetType := '4RedToBlack';
c_4Rating constant ST_IconSetType := '4Rating';
c_4TrafficLights constant ST_IconSetType := '4TrafficLights';
c_5Arrows constant ST_IconSetType := '5Arrows';
c_5ArrowsGray constant ST_IconSetType := '5ArrowsGray';
c_5Rating constant ST_IconSetType := '5Rating';
c_5Quarters constant ST_IconSetType := '5Quarters';

--v4.9.4
type CT_IconSet is record (
  tag plx_sc.normalv2,
  iconSet ST_IconSetType,
  showValue plx_sc.normalv2,
  percent plx_sc.normalv2,
  reverse plx_sc.normalv2,
  cfvos CT_Cfvos
  );

--v4.9.4
type CT_DataBar is record (
  tag plx_sc.normalv2,
  minLength plx_sc.normalv2,
  maxLength plx_sc.normalv2,
  showValue plx_sc.normalv2,
  cfvos CT_Cfvos,
  colors CT_Colors
  );

--v4.9.4
type CT_ColorScale is record (
  tag plx_sc.normalv2,
  cfvos CT_Cfvos,
  colors CT_Colors
  );

--v4.9.4
type CT_CfRule is record (
  tag plx_sc.normalv2,
  type ST_CfType,
  dxfId plx_sc.normalv2,
  priority plx_sc.normalv2,
  stopIfTrue plx_sc.normalv2,
  aboveAverage plx_sc.normalv2,
  percent plx_sc.normalv2,
  bottom plx_sc.normalv2,
  operator ST_ConditionalFormattingOp,
  text plx_sc.maxv2,
  timePeriod ST_TimePeriod,
  rank plx_sc.normalv2,
  stdDev plx_sc.normalv2,
  equalAverage plx_sc.normalv2,
  formulas t_cfrule_formulas,  -- max 3 pcs
  colorScale CT_ColorScale,
  dataBar CT_DataBar,
  iconSet CT_IconSet
  --extLst CT_ExtensionLists
  );

--v4.9.4
type ct_cfrules is table of CT_CfRule;
v_cfrules_empty ct_cfrules := ct_cfrules();

--v4.9.4
type CT_ConditionalFormatting is record (
  tag plx_sc.normalv2,
  pivot plx_sc.normalv2,
  sqref plx_sc.maxv2,
  cfrules ct_cfrules,
  --extLsts CT_ExtensionLists
  cellrange ploffx_util.t_cellrange --technical sqref
  );

type CT_ConditionalFormattings is table of CT_ConditionalFormatting;
v_CT_ConditionalFors_empty CT_ConditionalFormattings := CT_ConditionalFormattings();
--
type CT_Worksheet is record (
  tag plx_sc.normalv2,
  sheetPr CT_SheetPr, --Sheet Properties
  dimension CT_SheetDimension, --Worksheet Dimensions --REF
  sheetViews CT_SheetViews, --Sheet Views
  sheetFormatPr CT_SheetFormatPr, --Sheet Format Properties
  cols CT_Cols, --Column Information
  sheetData CT_SheetData, --AutoFilter Settings
  --sheetCalcPr CT_SheetCalcPr
  --sheetProtection CT_SheetProtection --Sheet Protection Options
  protectedRanges CT_ProtectedRanges, --Protected Ranges
  --scenarios CT_Scenarios
  autoFilter CT_AutoFilter,
  --sortState CT_SortState
  --dataConsolidate CT_DataConsolidate
  --customSheetViews CT_CustomSheetViews
  mergeCells CT_MergeCells, --Merge Cells
  --phoneticPr CT_PhoneticPr
  conditionalFormattings CT_ConditionalFormattings, --Conditional Formatting
  dataValidations CT_DataValidations, --Data Validations
  hyperlinks CT_Hyperlinks, --Hyperlinks
  printOptions CT_PrintOptions, --Print Options
  pageMargins CT_PageMargins,
  pageSetup CT_PageSetup,
  headerFooter CT_HeaderFooter,
  --rowBreaks CT_PageBreak
  --colBreaks CT_PageBreak
  --customProperties CT_CustomProperties
  --cellWatches CT_CellWatches
  --ignoredErrors CT_IgnoredErrors
  --smartTags CT_SmartTags
  drawing CT_Drawing, -- Drawing
  --drawingHF CT_DrawingHF
  picture CT_SheetBackgroundPicture, --Background Image
  --oleObjects CT_OleObjects
  --controls CT_Controls
  --webPublishItems CT_WebPublishItems
  --tableParts CT_TableParts
  --extLst CT_ExtensionList
  legacyDrawing CT_LegacyDrawing,
  legacyDrawingHF CT_LegacyDrawing,
  comments         ploffx_comments.CT_Comments,
  vmldrawing       ploffx_vmldrawing.CT_VML,
  drawings         ploffx_drawing.CT_drawing,
  last_row pls_integer := 0
  );

type t_sheets is table of CT_Worksheet;
v_sheets_empty t_sheets := t_sheets();
-----------------------------------------------------------------------------------------------------
--
--
ns_rel constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_rel_pref constant varchar2(2 char) := 'r';
--
c_full_ns constant plx_sc.normalv2 := 'xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"';
--
t_worksheet    constant plx_sc.normalv2 := 'worksheet';
t_dimension    constant plx_sc.normalv2 := 'dimension';
t_sheetViews   constant plx_sc.normalv2 := 'sheetViews';
t_sheetView    constant plx_sc.normalv2 := 'sheetView';
t_selection    constant plx_sc.normalv2 := 'selection';
t_sheetFormatPr constant plx_sc.normalv2 := 'sheetFormatPr';
t_cols         constant plx_sc.normalv2 := 'cols';
t_col          constant plx_sc.normalv2 := 'col';
t_sheetData    constant plx_sc.normalv2 := 'sheetData';
t_row          constant plx_sc.normalv2 := 'row';
t_c            constant plx_sc.normalv2 := 'c';
t_v            constant plx_sc.normalv2 := 'v';
t_mergeCells   constant plx_sc.normalv2 := 'mergeCells';
t_mergeCell    constant plx_sc.normalv2 := 'mergeCell';
t_pageMargins  constant plx_sc.normalv2 := 'pageMargins';
t_Relationships constant plx_sc.normalv2 := 'Relationships';
t_Relationship constant plx_sc.normalv2 := 'Relationship';
t_hyperlinks   constant plx_sc.normalv2 := 'hyperlinks';
t_hyperlink    constant plx_sc.normalv2 := 'hyperlink';
t_pane         constant plx_sc.normalv2 := 'pane';
t_autoFilter   constant plx_sc.normalv2 := 'autoFilter';
t_legacyDrawing constant plx_sc.normalv2 := 'legacyDrawing';
t_legacyDrawingHF constant plx_sc.normalv2 := 'legacyDrawingHF'; --v4.9.5
t_drawing constant plx_sc.normalv2 := 'drawing';
t_f constant plx_sc.normalv2 := 'f';
t_dataValidations constant plx_sc.normalv2 := 'dataValidations';
t_dataValidation constant plx_sc.normalv2 := 'dataValidation';
t_formula1 constant plx_sc.normalv2 := 'formula1';
t_formula2 constant plx_sc.normalv2 := 'formula2';
t_pageSetUpPr constant plx_sc.normalv2 := 'pageSetUpPr'; --v4.9.1
t_sheetPr constant plx_sc.normalv2 := 'sheetPr';
t_protectedRanges constant plx_sc.normalv2 := 'protectedRanges';
t_protectedRange constant plx_sc.normalv2 := 'protectedRange';
t_printOptions constant plx_sc.normalv2 := 'printOptions';
t_pageSetup constant plx_sc.normalv2 := 'pageSetup';
t_picture constant plx_sc.normalv2 := 'picture';
t_headerFooter constant plx_sc.normalv2 := 'headerFooter';
--v4.9.4
t_is constant plx_sc.normalv2 := 'is';
t_t constant plx_sc.normalv2 := 't';
t_conditionalFormatting constant plx_sc.normalv2 := 'conditionalFormatting';
t_CfRule constant plx_sc.normalv2 := 'cfRule';
t_ColorScale constant plx_sc.normalv2 := 'colorScale';
t_IconSet constant plx_sc.normalv2 := 'iconSet';
t_cfvo constant plx_sc.normalv2 := 'cfvo';
t_color constant plx_sc.normalv2 := 'color';
t_DataBar constant plx_sc.normalv2 := 'dataBar';
t_formula constant plx_sc.normalv2 := 'formula';
--v4.9.5
t_evenFooter constant plx_sc.normalv2 := 'evenFooter';
t_evenHeader constant plx_sc.normalv2 := 'evenHeader';
t_firstFooter constant plx_sc.normalv2 := 'firstFooter';
t_firstHeader constant plx_sc.normalv2 := 'firstHeader';
t_oddFooter constant plx_sc.normalv2 := 'oddFooter';
t_oddHeader constant plx_sc.normalv2 := 'oddHeader';
--
g_xml plx_sc.type_xdoc;
--

procedure start_;
--
procedure end_;
-- worksheet
procedure startworksheet(
  p_tag plx_sc.normalv2 default t_worksheet
  );
--
procedure endworksheet(
  p_tag plx_sc.normalv2 default t_worksheet
  );
-- dimension
procedure dimension(
  p_tag plx_sc.normalv2 default t_dimension,
  p_ref varchar2 default null
  );
-- sheetViews
procedure startsheetViews(
  p_tag plx_sc.normalv2 default t_sheetViews
  );
--
procedure endsheetViews(
  p_tag plx_sc.normalv2 default t_sheetViews
  );
-- sheetView
procedure startsheetView(
  p_tag plx_sc.normalv2 default t_sheetView,
  p_windowProtection varchar2 default null, --xsd:boolean use=optional default=false
  p_showFormulas varchar2 default null, --xsd:boolean use=optional default=false
  p_showGridLines varchar2 default null, --xsd:boolean use=optional default=true
  p_showRowColHeaders varchar2 default null, --xsd:boolean use=optional default=true
  p_showZeros varchar2 default null, --xsd:boolean use=optional default=true
  p_rightToLeft varchar2 default null, --xsd:boolean use=optional default=false
  p_tabSelected varchar2 default null, --xsd:boolean use=optional default=false
  p_showRuler varchar2 default null, --xsd:boolean use=optional default=true
  p_showOutlineSymbols varchar2 default null, --xsd:boolean use=optional default=true
  p_defaultGridColor varchar2 default null, --xsd:boolean use=optional default=true
  p_showWhiteSpace varchar2 default null, --xsd:boolean use=optional default=true
  p_view varchar2 default null, --ST_SheetViewType use=optional default=normal
  p_topLeftCell varchar2 default null, --ST_CellRef use=optional
  p_colorId varchar2 default null, --xsd:unsignedInt use=optional default=64
  p_zoomScale varchar2 default null, --xsd:unsignedInt use=optional default=100
  p_zoomScaleNormal varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_zoomScaleSheetLayoutView varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_zoomScalePageLayoutView varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_workbookViewId varchar2 --xsd:unsignedInt use=required
  );
-- pane
procedure pane(
  p_tag plx_sc.normalv2 default t_pane,
  p_xSplit varchar2 default null,
  p_ySplit varchar2 default null,
  p_topLeftCell varchar2 default null,
  p_activePane varchar2 default null,
  p_state varchar2 default null
  );
--
procedure endsheetView(
  p_tag plx_sc.normalv2 default t_sheetView
  );
-- selection
procedure selection(
  p_tag plx_sc.normalv2 default t_selection,
  p_pane varchar2 default null, --ST_Pane use=optional default=topLeft
  p_activeCell varchar2 default null, --ST_CellRef use=optional
  p_activeCellId varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_sqref varchar2 default null --ST_Sqref use=optional default=A1
  );
-- sheetFormatPr
procedure sheetFormatPr(
  p_tag plx_sc.normalv2 default t_sheetFormatPr,
  p_defaultColWidth varchar2 default null, --xsd:double use=optional
  p_defaultRowHeight varchar2, --xsd:double use=required
  p_customHeight varchar2 default null, --xsd:boolean use=optional default=false
  p_zeroHeight varchar2 default null, --xsd:boolean use=optional default=false
  p_thickTop varchar2 default null, --xsd:boolean use=optional default=false
  p_thickBottom varchar2 default null, --xsd:boolean use=optional default=false
  p_outlineLevelRow varchar2 default null, --xsd:unsignedByte use=optional default=0
  p_outlineLevelCol varchar2 default null --xsd:unsignedByte use=optional default=0
  );
-- cols
procedure startcols(
  p_tag plx_sc.normalv2 default t_cols
  );
--
procedure endcols(
  p_tag plx_sc.normalv2 default t_cols
  );
-- col
procedure col(
  p_tag plx_sc.normalv2 default t_col,
  p_min varchar2 default null, --xsd:unsignedInt use=required
  p_max varchar2 default null, --xsd:unsignedInt use=required
  p_width varchar2 default null, --xsd:double use=optional
  p_style varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_hidden varchar2 default null, --xsd:boolean use=optional default=false
  p_bestFit varchar2 default null, --xsd:boolean use=optional default=false
  p_customWidth varchar2 default null, --xsd:boolean use=optional default=false
  p_phonetic varchar2 default null, --xsd:boolean use=optional default=false
  p_outlineLevel varchar2 default null, --xsd:unsignedByte use=optional default=0
  p_collapsed varchar2 default null --xsd:boolean use=optional default=false
  );
-- sheetData
procedure startsheetData(
  p_tag plx_sc.normalv2 default t_sheetData
  );
--
procedure endsheetData(
  p_tag plx_sc.normalv2 default t_sheetData
  );
-- row
procedure startrow(
  p_tag plx_sc.normalv2 default t_row,
  p_r varchar2 default null, --xsd:unsignedInt use=optional
  p_spans varchar2 default null, --ST_CellSpans use=optional
  p_s varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_customFormat varchar2 default null, --xsd:boolean use=optional default=false
  p_ht varchar2 default null, --xsd:double use=optional
  p_hidden varchar2 default null, --xsd:boolean use=optional default=false
  p_customHeight varchar2 default null, --xsd:boolean use=optional default=false
  p_outlineLevel varchar2 default null, --xsd:unsignedByte use=optional default=0
  p_collapsed varchar2 default null, --xsd:boolean use=optional default=false
  p_thickTop varchar2 default null, --xsd:boolean use=optional default=false
  p_thickBot varchar2 default null, --xsd:boolean use=optional default=false
  p_ph varchar2 default null --xsd:boolean use=optional default=false
  );
--
procedure endrow(
    p_tag plx_sc.normalv2 default t_row
    );
-- c
procedure startc(
  p_tag plx_sc.normalv2 default t_c,
  p_r varchar2 default null, --ST_CellRef use=optional
  p_s varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_t varchar2 default null, --ST_CellType use=optional default=n
  p_cm varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_vm varchar2 default null, --xsd:unsignedInt use=optional default=0
  p_ph varchar2 default null --xsd:boolean use=optional default=false
  );
--
procedure endc(
  p_tag plx_sc.normalv2 default t_c
  );
-- v
procedure startv(
  p_tag plx_sc.normalv2 default t_v
  );
--
procedure endv(
  p_tag plx_sc.normalv2 default t_v
  );
-- mergeCells
procedure startmergeCells(
  p_tag plx_sc.normalv2 default t_mergeCells,
  p_count varchar2 default null
  );
--
procedure endmergeCells(
  p_tag plx_sc.normalv2 default t_mergeCells
  );
-- autoFilter
procedure startautoFilter(
  p_tag plx_sc.normalv2 default t_autoFilter,
  p_ref varchar2
  );
--
procedure endautoFilter(
  p_tag plx_sc.normalv2 default t_autoFilter
  );
-- mergeCell
procedure mergeCell(
  p_tag plx_sc.normalv2 default t_mergeCell,
  p_ref varchar2 -- ST_Ref use=required
  );
-- pageMargins
procedure pageMargins(
  p_tag plx_sc.normalv2 default t_pageMargins,
  p_left varchar2, --xsd:double use=required
  p_right varchar2, --xsd:double use=required
  p_top varchar2, --xsd:double use=required
  p_bottom varchar2, --xsd:double use=required
  p_header varchar2, --xsd:double use=required
  p_footer varchar2 --xsd:double use=required
  );
-- legacyDrawing
procedure legacyDrawing(
  p_tag plx_sc.normalv2 default t_legacyDrawing,
  p_id varchar2
  );
--v4.9.5
procedure legacyDrawingHF(
  p_tag plx_sc.normalv2 default t_legacyDrawingHF,
  p_id varchar2
  );
-- hyperlinks
procedure starthyperlinks(
  p_tag plx_sc.normalv2 default t_hyperlinks
  );
--
procedure endhyperlinks(
  p_tag plx_sc.normalv2 default t_hyperlinks
  );
-- hyperlink
procedure hyperlink(
  p_tag plx_sc.normalv2 default t_hyperlink,
  p_ref varchar2 default null, --ST_Ref required
  p_id varchar2 default null, -- optional
  p_location varchar2 default null, --ST_Xstring optional
  p_tooltip varchar2 default null, --ST_Xstring optional
  p_display varchar2 default null --ST_Xstring optional
  );
--
-- f
procedure startf(
  p_tag plx_sc.normalv2 default t_f,
  p_t varchar2 default null,
  p_aca varchar2 default null,
  p_ref varchar2 default null,
  p_dt2D varchar2 default null,
  p_dtr varchar2 default null,
  p_del1 varchar2 default null,
  p_del2 varchar2 default null,
  p_r1 varchar2 default null,
  p_r2 varchar2 default null,
  p_ca varchar2 default null,
  p_si varchar2 default null,
  p_bx varchar2 default null
  );
--
procedure endf(
  p_tag plx_sc.normalv2 default t_f
  );
--------------------------------------------------------
--v4.9.4
procedure color(
  p_tag varchar2 default t_color,
  p_auto varchar2 default null,
  p_indexed varchar2 default null,
  p_rgb varchar2 default null,
  p_theme varchar2 default null,
  p_tint varchar2 default null
  );
--------------------------------------------------------
--v4.9.4
procedure Cfvo(
  p_tag plx_sc.normalv2 default t_Cfvo,
  p_type varchar2 default null,
  p_val varchar2 default null,
  p_gte varchar2 default null
  );
--------------------------------------------------------
--v4.9.4
procedure startColorScale(
  p_tag plx_sc.normalv2 default t_ColorScale
  );
--v4.9.4
procedure endColorScale(
  p_tag plx_sc.normalv2 default t_ColorScale
  );
--------------------------------------------------------
--v4.9.4
procedure startIconSet(
  p_tag plx_sc.normalv2 default t_IconSet,
  p_iconSet varchar2 default null,
  p_showValue varchar2 default null,
  p_percent varchar2 default null,
  p_reverse varchar2 default null
  );
--v4.9.4
procedure endIconset(
  p_tag plx_sc.normalv2 default t_Iconset
  );
--------------------------------------------------------
--v4.9.4
procedure startDataBar(
  p_tag plx_sc.normalv2 default t_DataBar,
  p_minLength varchar2 default null,
  p_maxLength varchar2 default null,
  p_showValue varchar2 default null
  );
--v4.9.4
procedure endDataBar(
  p_tag plx_sc.normalv2 default t_DataBar
  );
--------------------------------------------------------
--v4.9.4
procedure formula(
  p_tag plx_sc.normalv2 default t_formula,
  p_text varchar2
  );
--------------------------------------------------------
--v4.9.4
procedure startCfRule(
  p_tag plx_sc.normalv2 default t_CfRule,
  p_type varchar2 default null,
  p_dxfId varchar2 default null,
  p_priority varchar2 default null,
  p_stopIfTrue varchar2 default null,
  p_aboveAverage varchar2 default null,
  p_percent varchar2 default null,
  p_bottom varchar2 default null,
  p_operator varchar2 default null,
  p_text varchar2 default null,
  p_timePeriod varchar2 default null,
  p_rank varchar2 default null,
  p_stdDev varchar2 default null,
  p_equalAverage varchar2 default null
  );
--v4.9.4
procedure endCfRule(
  p_tag plx_sc.normalv2 default t_CfRule
  );
--v4.9.4
procedure startconditionalFormatting(
  p_tag plx_sc.normalv2 default t_conditionalFormatting,
  p_pivot varchar2 default null,
  p_sqref varchar2 default null
  );
--v4.9.4
procedure endconditionalFormatting(
  p_tag plx_sc.normalv2 default t_conditionalFormatting
  );
--------------------------------------------------------
-- dataValidations
procedure startdataValidations(
  p_tag plx_sc.normalv2 default t_dataValidations,
  p_count varchar2 default null
  );
--
procedure enddataValidations(
  p_tag plx_sc.normalv2 default t_dataValidations
  );
--
-- dataValidation
procedure startdataValidation(
  p_tag plx_sc.normalv2 default t_dataValidation,
  p_type varchar2 default null,
  p_errorStyle varchar2 default null,
  p_imeMode varchar2 default null,
  p_operator varchar2 default null,
  p_allowBlank varchar2 default null,
  p_showDropDown varchar2 default null,
  p_showInputMessage varchar2 default null,
  p_showErrorMessage varchar2 default null,
  p_errorTitle varchar2 default null,
  p_error varchar2 default null,
  p_promptTitle varchar2 default null,
  p_prompt varchar2 default null,
  p_sqref varchar2 default null
  );
--
procedure enddataValidation(
  p_tag plx_sc.normalv2 default t_dataValidation
  );
-- formula1
procedure startformula1(
  p_tag plx_sc.normalv2 default t_formula1
  );
--
procedure endformula1(
  p_tag plx_sc.normalv2 default t_formula1
  );
-- formula1
procedure formula1(
  p_tag plx_sc.normalv2 default t_formula1,
  p_text varchar2
  );
-- formula2
procedure startformula2(
  p_tag plx_sc.normalv2 default t_formula2
  );
--
procedure endformula2(
  p_tag plx_sc.normalv2 default t_formula2
  );
-- formula2
procedure formula2(
  p_tag plx_sc.normalv2 default t_formula2,
  p_text varchar2
  );
--
procedure startSheetPr(
  p_tag plx_sc.normalv2 default t_sheetPr,
  p_syncHorizontal varchar2 default null, --xsd:boolean
  p_syncVertical varchar2 default null, --xsd:boolean
  p_syncRef varchar2 default null, --xsd:ST_Ref
  p_transitionEvaluation varchar2 default null, --xsd:boolean
  p_transitionEntry varchar2 default null, --xsd:boolean
  p_published varchar2 default null, --xsd:boolean
  p_codeName varchar2 default null, --xsd:string
  p_filterMode varchar2 default null, --xsd:boolean
  p_enableFormatConditionsCalc varchar2 default null --xsd:boolean
  );
--
procedure endSheetPr(
  p_tag plx_sc.normalv2 default t_sheetPr
  );
-- protectedRanges
procedure startprotectedRanges(
  p_tag plx_sc.normalv2 default t_protectedRanges
  );
--
procedure endprotectedRanges(
  p_tag plx_sc.normalv2 default t_protectedRanges
  );
-- protectedRange
procedure startprotectedRange(
  p_tag plx_sc.normalv2 default t_protectedRange,
  p_sqref varchar2,
  p_name varchar2,
  p_algorithmName varchar2 default null,
  p_hashValue varchar2 default null,
  p_saltValue varchar2 default null,
  p_spinCount varchar2 default null
  );
--
procedure endprotectedRange(
  p_tag plx_sc.normalv2 default t_protectedRange
  );
-- printOptions
procedure printOptions(
  p_tag plx_sc.normalv2 default t_printOptions,
  p_horizontalCentered  varchar2 default null,
  p_verticalCentered varchar2 default null,
  p_headings varchar2 default null,
  p_gridLines varchar2 default null,
  p_gridLinesSet varchar2 default null
  );
-- pageSetup
procedure pageSetup(
  p_tag plx_sc.normalv2 default t_pageSetup,
  p_paperSize varchar2 default null, --xsd:unsignedInt
  p_paperHeight varchar2 default null, --s:ST_PositiveUniversalMeasure
  p_paperWidth varchar2 default null, --s:ST_PositiveUniversalMeasure
  p_scale varchar2 default null, --xsd:unsignedInt
  p_firstPageNumber varchar2 default null, --xsd:unsignedInt
  p_fitToWidth varchar2 default null, --xsd:unsignedInt
  p_fitToHeight varchar2 default null, --xsd:unsignedInt
  p_pageOrder varchar2 default null,
  p_orientation varchar2 default null,
  p_usePrinterDefaults varchar2 default null, --xsd:boolean
  p_blackAndWhite varchar2 default null, --xsd:boolean
  p_draft varchar2 default null, --xsd:boolean
  p_cellComments varchar2 default null,
  p_useFirstPageNumber varchar2 default null, --xsd:boolean
  p_errors varchar2 default null,
  p_horizontalDpi varchar2 default null, --xsd:unsignedInt
  p_verticalDpi varchar2 default null, --xsd:unsignedInt
  p_copies varchar2 default null, --xsd:unsignedInt
  p_id varchar2 default null --varchar2 default null
  );
-- headerFooter
procedure startheaderFooter(
  p_tag plx_sc.normalv2 default t_headerFooter,
  p_oddHeader varchar2 default null, --s:ST_Xstring
  p_oddFooter varchar2 default null, --s:ST_Xstring
  p_evenHeader varchar2 default null, --s:ST_Xstring
  p_evenFooter varchar2 default null, --s:ST_Xstring
  p_firstHeader varchar2 default null, --s:ST_Xstring
  p_firstFooter varchar2 default null, --s:ST_Xstring
  p_differentOddEven varchar2 default null, --xsd:boolean
  p_differentFirst varchar2 default null, --xsd:boolean
  p_scaleWithDoc varchar2 default null, --xsd:boolean
  p_alignWithMargins varchar2 default null --xsd:boolean
  );
--
procedure endheaderFooter(
  p_tag plx_sc.normalv2 default t_headerFooter
  );
-- drawing
procedure drawing(
  p_tag plx_sc.normalv2 default t_drawing,
  p_id varchar2
  );
--
procedure picture(
  p_tag plx_sc.normalv2 default t_picture,
  p_id varchar2
  );



------------------------------------------
-- CREATE STRUCTURES
------------------------------------------
-- f: CT_CellFormula
function cr_f(
  p_tag varchar2 default t_f,
  p_formula plx_sc.maxv2 default null,
  p_t ST_CellFormulaType default null,
  -- aca xsd:boolean
  p_ref plx_sc.maxv2 default null,
  -- dt2D xsd:boolean
  -- dtr xsd:boolean
  -- del1 xsd:boolean
  -- del2 xsd:boolean
  -- r1 ST_CellRef
  -- r2 ST_CellRef
  -- ca xsd:boolean
  p_si plx_sc.normalv2 default null
  -- bx xsd:boolean
  ) return CT_CellFormula;

------------------------------------------
-- c: CT_Cell
function cr_c(
  p_tag varchar2 default t_c,
  p_f CT_CellFormula default null, --formula
  p_v plx_sc.maxv2 default null, -- value
  -- is CT_Rst --reach text inline
  --extLst CT_ExtensionList
  p_r plx_sc.maxv2 default null, -- style reference
  p_s plx_sc.normalv2 default null, --style index
  p_t ST_CellType default null --data type
  -- cm xsd:unsignedInt
  -- vm xsd:unsignedInt
  -- ph xsd:boolean
  ) return CT_Cell;
-- c:t_cells
--v5.8
function add_c(
  p_table in out t_cells,
  p_c CT_Cell
  ) return pls_integer;

------------------------------------------
-- row: CT_row
function cr_row(
  p_tag varchar2 default t_row,
  p_cells t_cells , --cells
  -- extLst CT_ExtensionList
  p_r plx_sc.normalv2 default null, -- Row Index xsd:unsignedInt
  p_spans plx_sc.normalv2 default null, -- ST_CellSpans
  p_s plx_sc.normalv2 default null,-- Style Index xsd:unsignedInt
  p_customFormat plx_sc.normalv2 default null, -- xsd:boolean
  p_ht plx_sc.normalv2 default null, --Row Height xsd:double
  p_hidden plx_sc.normalv2 default null, -- xsd:boolean
  p_customHeight plx_sc.normalv2 default null, -- xsd:boolean
  p_outlineLevel plx_sc.normalv2 default null, --xsd:unsignedByte
  p_collapsed plx_sc.normalv2 default null --xsd:boolean
  -- thickTop xsd:boolean
  -- thickBot xsd:boolean
  -- ph xsd:boolean
  ) return CT_row;

-- sheetdata: CT_SheetData
procedure add_row(
  p_table in out CT_SheetData,
  p_row CT_row
  );

------------------------------------------
-- sheetPr: CT_SheetPr
function cr_sheetPr(
  p_tag varchar2 default t_sheetPr,
  -- tabColor CT_Color
  -- outlinePr CT_OutlinePr
  p_pageSetUpPr CT_PageSetUpPr, --v4.9.1
  -- syncHorizontal xsd:boolean
  -- syncVertical xsd:boolean
  -- syncRef ST_Ref
  -- transitionEvaluation xsd:boolean
  -- transitionEntry xsd:boolean
  -- published xsd:boolean
  p_codeName plx_sc.normalv2 default null --stable name of the sheet
  -- filterMode xsd:boolean
  -- enableFormatConditionsCalculation xsd:boolean
  ) return CT_SheetPr;

------------------------------------------
-- selection: CT_Selection
function cr_selection(
  p_tag varchar2 default t_selection,
  p_pane ST_Pane default null,
  p_activeCell plx_sc.normalv2 default null, --ST_CellRef
  p_activeCellId plx_sc.normalv2 default null, --xsd:unsignedInt
  p_sqref plx_sc.maxv2 default null --ST_Sqref v4.8.3
  ) return CT_Selection;
-- selection_4: CT_Selection_4
procedure add_selection(
  p_table in out CT_Selection_4,
  p_selection CT_Selection
  );

------------------------------------------
-- pane: CT_Pane
function cr_pane(
  p_tag varchar2 default t_pane,
  p_xSplit plx_sc.normalv2 default null, --xsd:double
  p_ySplit plx_sc.normalv2 default null, --xsd:double
  p_topLeftCell plx_sc.normalv2 default null, --ST_CellRef
  p_activePane ST_Pane default null,
  p_state ST_PaneState default null
  ) return CT_Pane;

------------------------------------------
-- sheetView: CT_SheetView
function cr_sheetView(
  p_tag varchar2 default t_sheetView,
  p_pane CT_Pane default null,
  p_selection CT_Selection_4 default null, -- maxOccurs="4"
    -- pivotSelection CT_PivotSelection maxOccurs="4"
    -- extLst CT_ExtensionList
    -- windowProtection xsd:boolean
    -- showFormulas xsd:boolean
  p_showGridLines plx_sc.normalv2, --  xsd:boolean
    -- showRowColHeaders xsd:boolean
    -- showZeros xsd:boolean
    -- rightToLeft xsd:boolean
  p_tabSelected plx_sc.normalv2 default null, -- xsd:boolean
    -- showRuler xsd:boolean
    -- showOutlineSymbols xsd:boolean
    -- defaultGridColor xsd:boolean
    -- showWhiteSpace xsd:boolean
    -- view ST_SheetViewType
    -- topLeftCell ST_CellRef
    -- colorId xsd:unsignedInt
    -- zoomScale xsd:unsignedInt
    -- zoomScaleNormal xsd:unsignedInt
    -- zoomScaleSheetLayoutView xsd:unsignedInt
    -- zoomScalePageLayoutView xsd:unsignedInt
  p_workbookViewId plx_sc.normalv2 default null -- xsd:unsignedInt
  ) return CT_SheetView;
-- sheetViews : CT_SheetViews
procedure add_sheetView(
  p_table in out CT_SheetViews,
  p_sheetView CT_SheetView
  );

------------------------------------------
-- sheetFormatPr: CT_SheetFormatPr
function cr_sheetFormatPr(
  p_tag varchar2 default t_sheetFormatPr,
  -- baseColWidth xsd:unsignedInt
  p_defaultColWidth plx_sc.normalv2 default null, -- xsd:double
  p_defaultRowHeight plx_sc.normalv2 default null, -- xsd:double
  p_customHeight plx_sc.normalv2 default null, -- xsd:boolean
  p_zeroHeight plx_sc.normalv2 default null, -- xsd:boolean
  p_thickTop plx_sc.normalv2 default null, -- xsd:boolean
  p_thickBottom plx_sc.normalv2 default null --xsd:boolean
  -- outlineLevelRow xsd:unsignedByte
  -- outlineLevelCol xsd:unsignedByte
  ) return CT_SheetFormatPr;

------------------------------------------
-- col: CT_Col
function cr_col(
  p_tag varchar2 default t_col,
  p_min plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_max plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_width plx_sc.normalv2 default null, -- xsd:double
  p_style plx_sc.normalv2 default null, -- xsd:unsignedInt
  p_hidden plx_sc.normalv2 default null, -- xsd:boolean
  p_bestFit plx_sc.normalv2 default null, --xsd:boolean
  p_customWidth plx_sc.normalv2 default null, -- xsd:boolean
  -- phonetic xsd:boolean
  p_outlineLevel plx_sc.normalv2 default null, --xsd:unsignedByte
  p_collapsed plx_sc.normalv2 default null --xsd:boolean
  ) return CT_Col;
-- cols : CT_Cols
procedure add_col(
  p_table in out CT_Cols,
  p_col CT_Col
  );

------------------------------------------
-- protectedRange: CT_ProtectedRange
function cr_protectedRange(
  p_tag varchar2 default t_protectedRange,
  --securityDescriptor
  p_sqref plx_sc.maxv2 default null, -- ST_Sqref
  p_name plx_sc.normalv2 default null -- s:ST_Xstring
  -- algorithmName s:ST_Xstring
  -- hashValue xsd:base64Binary
  -- saltValue xsd:base64Binary
  -- spinCount xsd:unsignedInt
  ) return CT_ProtectedRange;
-- CT_ProtectedRanges : CT_ProtectedRange
procedure add_protectedRanges(
  p_table in out CT_ProtectedRanges,
  p_protectedRange CT_ProtectedRange
  );

------------------------------------------
-- autofilter: CT_AutoFilter
function cr_autofilter(
  p_tag varchar2 default t_autoFilter,
  -- filterColumn t_FilterColumns,
  -- sortState CT_SortState
  -- extLst CT_ExtensionList
  p_ref plx_sc.maxv2 default null --ST_Ref
  ) return CT_AutoFilter;

------------------------------------------
-- mergeCell: CT_MergeCell
function cr_mergeCell(
  p_tag varchar2 default t_mergeCell,
  p_ref plx_sc.maxv2 default null --ST_Ref
  -- cellrange t_cellrange --technical
  ) return CT_MergeCell;
-- mergeCells : CT_MergeCElls();
procedure add_mergeCell(
  p_table in out CT_MergeCells,
  p_mergeCell CT_MergeCell
  );
------------------------------------------
--v4.9.4
function cr_conditionalFormatting(
  p_tag varchar2 default t_conditionalFormatting,
  p_pivot plx_sc.normalv2 default null,
  p_sqref plx_sc.maxv2,
  p_cfrules ct_cfrules
  ) return CT_conditionalFormatting;
--v4.9.4
procedure add_conditionalFormatting(
  p_table in out CT_conditionalFormattings,
  p_conditionalFormatting CT_conditionalFormatting
  );
------------------------------------------
-- dataValidation: CT_DataValidation
function cr_dataValidation(
  p_tag varchar2 default t_dataValidation,
  p_formula1 plx_sc.maxv2 default null,
  p_formula2 plx_sc.maxv2 default null,
  p_type ST_DataValidationType default null,
  p_errorStyle ST_DataValidationErrorStyle default null,
  p_imeMode ST_DataValidationImeMode default null,
  p_operator ST_DataValidationOperator default null,
  p_allowBlank plx_sc.normalv2 default null, --xsd:boolean
  p_showDropDown plx_sc.normalv2 default null, --xsd:boolean
  p_showInputMessage plx_sc.normalv2 default null, --xsd:boolean
  p_showErrorMessage plx_sc.normalv2 default null, --xsd:boolean
  p_errorTitle plx_sc.maxv2 default null, --s:ST_Xstring
  p_error plx_sc.maxv2 default null, --s:ST_Xstring
  p_promptTitle plx_sc.maxv2 default null, --s:ST_Xstring
  p_prompt plx_sc.maxv2 default null, --s:ST_Xstring
  p_sqref plx_sc.maxv2 default null --ST_Sqref
  ) return CT_DataValidation;
-- dataValidations: t_DataValidations_
procedure add_dataValidation(
  p_table in out t_DataValidations_,
  p_dataValidation CT_DataValidation
  );

------------------------------------------
-- dataValidations: CT_DataValidations
function cr_dataValidations(
  p_tag varchar2 default t_dataValidations,
  p_dataValidation t_DataValidations_ default null,
  -- disablePrompts xsd:boolean
  -- xWindow xsd:unsignedInt
  -- yWindow xsd:unsignedInt
  p_count varchar2 default null -- xsd:unsignedInt
  ) return CT_DataValidations;

------------------------------------------
-- hyperlink: CT_Hyperlink
function cr_hyperlink(
  p_tag varchar2 default t_hyperlink,
  p_ref plx_sc.maxv2 default null, --ST_Ref
  p_id  plx_sc.normalv2 default null,
  p_location plx_sc.maxv2 default null, -- s:ST_Xstring
  p_tooltip  plx_sc.maxv2 default null, -- s:ST_Xstring
  p_display plx_sc.maxv2 default null -- s:ST_Xstring
  ) return CT_Hyperlink;
-- hyperlinks: CT_Hyperlinks
procedure add_hyperlink(
  p_table in out CT_Hyperlinks,
  p_hyperlink CT_Hyperlink
  );

------------------------------------------
-- printOptions: CT_PrintOptions
function cr_printOptions(
  p_tag varchar2 default t_printOptions,
  p_horizontalCentered plx_sc.normalv2 default null, -- xsd:boolean
  p_verticalCentered plx_sc.normalv2 default null, -- xsd:boolean
  p_headings plx_sc.normalv2 default null, -- xsd:boolean
  p_gridLines plx_sc.normalv2 default null, -- xsd:boolean
  p_gridLinesSet plx_sc.normalv2 default null --xsd:boolean
  ) return CT_PrintOptions;

------------------------------------------
-- pageMargins: CT_PageMargins
function cr_pageMargins(
  p_tag varchar2 default t_pageMargins,
  p_left plx_sc.normalv2 default null, -- xsd:double
  p_right plx_sc.normalv2 default null, --xsd:double
  p_top plx_sc.normalv2 default null, --xsd:double
  p_bottom plx_sc.normalv2 default null, --xsd:double
  p_header plx_sc.normalv2 default null, --xsd:double
  p_footer plx_sc.normalv2 default null --xsd:double
  ) return CT_PageMargins;

------------------------------------------
-- pageSetup: CT_PageSetup
function cr_pageSetup(
  p_tag varchar2 default t_pageSetup,
  p_paperSize plx_sc.normalv2 default null, --xsd:unsignedInt
  p_paperHeight plx_sc.normalv2 default null, --s:ST_PositiveUniversalMeasure
  p_paperWidth plx_sc.normalv2 default null, --s:ST_PositiveUniversalMeasure
  p_scale plx_sc.normalv2 default null, --xsd:unsignedInt
  p_firstPageNumber plx_sc.normalv2 default null, --xsd:unsignedInt
  p_fitToWidth plx_sc.normalv2 default null, --xsd:unsignedInt
  p_fitToHeight plx_sc.normalv2 default null, --xsd:unsignedInt
  p_pageOrder ST_PageOrder default null,
  p_orientation ST_Orientation default null,
  p_usePrinterDefaults plx_sc.normalv2 default null, --xsd:boolean
  p_blackAndWhite plx_sc.normalv2 default null, --xsd:boolean
  p_draft plx_sc.normalv2 default null, --xsd:boolean
  p_cellComments ST_CellComments default null,
  p_useFirstPageNumber plx_sc.normalv2 default null, --xsd:boolean
  p_errors ST_PrintError default null,
  p_horizontalDpi plx_sc.normalv2 default null, --xsd:unsignedInt
  p_verticalDpi plx_sc.normalv2 default null, --xsd:unsignedInt
  p_copies plx_sc.normalv2 default null, --xsd:unsignedInt
  p_id plx_sc.normalv2 default null --plx_sc.normalv2
  ) return CT_PageSetup;
--v4.9.0
function cr_pageSetUpPr(
  p_tag varchar2 default t_pageSetUpPr,
  p_autoPageBreaks plx_sc.normalv2 default null, --xsd:boolean
  p_fitToPage plx_sc.normalv2 default null --xsd:boolean
  ) return CT_pageSetUpPr;
------------------------------------------
-- headerFooter: CT_HeaderFooter
function cr_headerFooter(
  p_tag varchar2 default t_pageSetup,
  p_oddHeader plx_sc.maxv2 default null, --s:ST_Xstring
  p_oddFooter plx_sc.maxv2 default null, --s:ST_Xstring
  p_evenHeader plx_sc.maxv2 default null, --s:ST_Xstring
  p_evenFooter plx_sc.maxv2 default null, --s:ST_Xstring
  p_firstHeader plx_sc.maxv2 default null, --s:ST_Xstring
  p_firstFooter plx_sc.maxv2 default null, --s:ST_Xstring
  p_differentOddEven plx_sc.normalv2 default null, --xsd:boolean
  p_differentFirst plx_sc.normalv2 default null, --xsd:boolean
  p_scaleWithDoc plx_sc.normalv2 default null, --xsd:boolean
  p_alignWithMargins plx_sc.normalv2 default null --xsd:boolean
  ) return CT_HeaderFooter;

------------------------------------------
-- drawing: CT_Drawing
function cr_drawing(
  p_tag varchar2 default t_drawing,
  p_id plx_sc.normalv2 default null
  ) return CT_Drawing;

------------------------------------------
-- picture: CT_SheetBackgroundPicture
function cr_picture(
  p_tag varchar2 default t_picture,
  p_id plx_sc.normalv2 default null
  ) return CT_SheetBackgroundPicture;

------------------------------------------
-- worksheet: CT_Worksheet
function cr_worksheet(
  p_tag varchar2 default t_worksheet,
  p_sheetPr CT_SheetPr default null, --Sheet Properties
  p_dimension CT_SheetDimension default null, --Worksheet Dimensions --REF
  p_sheetViews CT_SheetViews default null, --Sheet Views
  p_sheetFormatPr CT_SheetFormatPr default null, --Sheet Format Properties
  p_cols CT_Cols default null, --Column Information
  p_sheetData CT_SheetData, --AutoFilter Settings
  --sheetCalcPr CT_SheetCalcPr
  --sheetProtection CT_SheetProtection --Sheet Protection Options
  p_protectedRanges CT_ProtectedRanges default null, --Protected Ranges
  --scenarios CT_Scenarios
  p_autoFilter CT_AutoFilter default null,
  --sortState CT_SortState
  --dataConsolidate CT_DataConsolidate
  --customSheetViews CT_CustomSheetViews
  p_mergeCells CT_MergeCells default null, --Merge Cells
  --phoneticPr CT_PhoneticPr
  p_conditionalFormattings CT_ConditionalFormattings, --Conditional Formatting
  p_dataValidations CT_DataValidations default null, --Data Validations
  p_hyperlinks CT_Hyperlinks default null, --Hyperlinks
  p_printOptions CT_PrintOptions default null, --Print Options
  p_pageMargins CT_PageMargins default null,
  p_pageSetup CT_PageSetup default null,
  p_headerFooter CT_HeaderFooter default null,
  --rowBreaks CT_PageBreak
  --colBreaks CT_PageBreak
  --customProperties CT_CustomProperties
  --cellWatches CT_CellWatches
  --ignoredErrors CT_IgnoredErrors
  --smartTags CT_SmartTags
  p_drawing CT_Drawing default null, -- Drawing
  --drawingHF CT_DrawingHF
  p_picture CT_SheetBackgroundPicture default null, --Background Image
  --oleObjects CT_OleObjects
  --controls CT_Controls
  --webPublishItems CT_WebPublishItems
  --tableParts CT_TableParts
  --extLst CT_ExtensionList
  p_LegacyDrawing CT_LegacyDrawing default null,
  p_LegacyDrawingHF CT_LegacyDrawing default null
  ) return CT_Worksheet;

------------------------------------------
-- GENERATE XML PARTS
------------------------------------------
-- f: CT_CellFormula
procedure gen_f(
  p_f CT_CellFormula
  );
------------------------------------------
-- v: ST_XString
procedure gen_v(
  p_v plx_sc.maxv2
  );

------------------------------------------
-- c: CT_Cell
procedure gen_c(
  p_c CT_Cell
  );

------------------------------------------
-- row: CT_row
procedure gen_row(
  p_row CT_row,
  p_ws_id pls_integer, --v3.3.0
  p_row_id pls_integer --v3.3.0
  );

------------------------------------------
-- sheetData: CT_SheetData
procedure gen_sheetData(
  p_sheetData CT_SheetData,
  p_ws_id pls_integer --v3.3.0
  );

------------------------------------------
-- sheetPr: CT_SheetPr
procedure gen_sheetPr(
  p_sheetPr CT_SheetPr
  );

------------------------------------------
-- selection: CT_Selection
procedure gen_selection(
  p_selection CT_Selection
  );

------------------------------------------
-- pane: CT_Pane
procedure gen_pane(
  p_pane CT_Pane
  );

------------------------------------------
-- sheetViews: CT_sheetViews
procedure gen_sheetViews(
  p_sheetViews CT_SheetViews
  );

------------------------------------------
-- sheetView: CT_sheetView
procedure gen_sheetView(
  p_sheetView CT_SheetView
  );

------------------------------------------
-- sheetFormatPr: CT_SheetFormatPr
procedure gen_sheetFormatPr(
  p_sheetFormatPr CT_SheetFormatPr
  );

------------------------------------------
-- col: CT_Col
procedure gen_col(
  p_col CT_Col
  );

------------------------------------------
-- cols: CT_Cols
procedure gen_cols(
  p_cols CT_Cols
  );

------------------------------------------
-- protectedRanges: CT_ProtectedRanges
procedure gen_protectedRanges(
  p_protectedRanges CT_ProtectedRanges
  );

------------------------------------------
-- protectedRange: CT_ProtectedRange
procedure gen_protectedRange(
  p_protectedRange CT_ProtectedRange
  );

------------------------------------------
-- autoFilter: CT_AutoFilter
procedure gen_autofilter(
  p_autofilter CT_AutoFilter
  );

------------------------------------------
-- mergeCell: CT_MergeCell
procedure gen_mergeCell(
  p_mergeCell CT_MergeCell
  );

------------------------------------------
-- mergeCells: CT_MergeCells
procedure gen_mergeCells(
  p_mergeCells CT_MergeCells
  );

------------------------------------------
-- dataValidation: CT_DataValidation
procedure gen_dataValidation(
  p_dataValidation CT_DataValidation
  );

------------------------------------------
-- dataValidations: CT_DataValidations
procedure gen_dataValidations(
  p_dataValidations CT_DataValidations
  );

------------------------------------------
-- hyperlink: CT_Hyperlink
procedure gen_hyperlink(
  p_hyperlink CT_Hyperlink
  );

------------------------------------------
-- hyperlinks: CT_Hyperlinks
procedure gen_hyperlinks(
  p_hyperlinks CT_Hyperlinks
  );

------------------------------------------
-- printOptions: CT_PrintOptions
procedure gen_printOptions(
  p_printOptions CT_PrintOptions
  );

------------------------------------------
-- pageMargins: CT_PageMargins
procedure gen_pageMargins(
  p_pageMargins CT_PageMargins
  );

------------------------------------------
-- pageSetup: CT_PageSetup
procedure gen_pageSetup(
  p_pageSetup CT_PageSetup
  );

------------------------------------------
-- headerFooter: CT_HeaderFooter
procedure gen_headerFooter(
  p_headerFooter CT_HeaderFooter
  );

------------------------------------------
-- drawing: CT_Drawing
procedure gen_drawing(
  p_drawing CT_Drawing
  );

------------------------------------------
-- picture: CT_SheetBackgroundPicture
procedure gen_picture(
  p_picture CT_SheetBackgroundPicture
  );

------------------------------------------
-- worksheet: CT_Worksheet
procedure gen_worksheet(
  p_worksheet CT_Worksheet,
  p_ws_id pls_integer --v3.3.0
  );

------------------------------------------
-- XML:
procedure gen_xml(
  p_worksheet CT_Worksheet,
  p_ws_id pls_integer --v3.3.0
  );
--------------------------------------------------------
--parse
-- parse
function getSheetID(
  p_filename varchar2
  ) return pls_integer;
--
function parse(
  p_file clob
  ) return CT_Worksheet;
--
--
function getDrawingX(
  p_column_widths CT_Cols, -- ploffx_sheet.t_column_widths,
  p_column ploffx_drawing.CT_Marker -- col varchar2(10), colOff number
 ) return number;
--
function getDrawingY(
  p_rows CT_SheetData, --ploffx_sheet.t_rows,
  p_row ploffx_drawing.CT_Marker -- row pls_integer, rowOff number
  ) return number;
--
function getDrawingXEnd(
  p_column_widths CT_Cols, -- ploffx_sheet.t_column_widths,
  p_width number,
  p_column_start ploffx_drawing.CT_Marker, -- col varchar2(10), colOff number
  p_calc_start number default null
 ) return ploffx_drawing.CT_Marker;
--
function getDrawingYEnd(
  p_rows CT_SheetData, --ploffx_sheet.t_rows,
  p_height number,
  p_row_start ploffx_drawing.CT_Marker, -- row pls_integer, rowOff number
  p_calc_start number default null
  ) return ploffx_drawing.CT_Marker; -- row pls_integer, rowOff number
--
end ploffx_sheet;
/

