create or replace package ploffx_sharedStrings
authid current_user is
--v5.9
--
-- Namespace
ns constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/spreadsheetml/2006/main';
-- XML
g_xml plx_sc.type_xdoc;
-- Tag
t_sst constant plx_sc.normalv2 := 'sst';
t_si  constant plx_sc.normalv2 := 'si';
t_t   constant plx_sc.normalv2 := 't'; --text
t_r   constant plx_sc.normalv2 := 'r'; --reach text
t_rPr constant plx_sc.normalv2 := 'rPr'; --run properties
t_rFont constant plx_sc.normalv2 := 'rFont';
t_charset constant plx_sc.normalv2 := 'charset';
t_family constant plx_sc.normalv2 := 'family';
t_b constant plx_sc.normalv2 := 'b';
t_i constant plx_sc.normalv2 := 'i';
t_strike constant plx_sc.normalv2 := 'strike';
t_outline constant plx_sc.normalv2 := 'outline';
t_shadow constant plx_sc.normalv2 := 'shadow';
t_condense constant plx_sc.normalv2 := 'condense';
t_extend constant plx_sc.normalv2 := 'extend';
t_color constant plx_sc.normalv2 := 'color';
t_sz constant plx_sc.normalv2 := 'sz';
t_u constant plx_sc.normalv2 := 'u';
t_vertAlign constant plx_sc.normalv2 := 'vertAlign';
t_scheme constant plx_sc.normalv2 := 'scheme';
t_phoneticPr constant plx_sc.normalv2 := 'phoneticPr';
t_rPh constant plx_sc.normalv2 := 'rPh';
-- Constant
c_count constant plx_sc.normalv2 := 'count';
c_uniqueCount constant plx_sc.normalv2 := 'uniqueCount';
--
c_filename constant plx_sc.normalv2 := 'xl/sharedStrings.xml';
-----------------------------------------------------------------------------------------------
-- Structure
type CT_FontName is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

type CT_IntProperty is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

type CT_BooleanProperty is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

type CT_FontSize is record (
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

type CT_UnderlineProperty is record (
  tag plx_sc.normalv2,
  val ploffx_xlsx_styles.ST_UnderlineValues
  );

type CT_VerticalAlignFontProperty is record (
  tag plx_sc.normalv2,
  val ploffx_xlsx_styles.ST_VerticalAlignRun
  );

type CT_FontScheme is record (
  tag plx_sc.normalv2,
  val ploffx_xlsx_styles.ST_FontScheme
  );

type CT_RPrElt is record (
  tag plx_sc.normalv2,
  rFont CT_FontName,
  charset CT_IntProperty,
  family CT_IntProperty,
  b CT_BooleanProperty,
  i CT_BooleanProperty,
  strike CT_BooleanProperty,
  outline CT_BooleanProperty,
  shadow CT_BooleanProperty,
  condense CT_BooleanProperty,
  extend_ CT_BooleanProperty,
  color ploffx_xlsx_styles.CT_Color,
  sz CT_FontSize,
  u CT_UnderlineProperty,
  vertAlign CT_VerticalAlignFontProperty,
  scheme CT_FontScheme
  );

type CT_RElt is record (
  tag plx_sc.normalv2,
  rPr CT_RPrElt, --Run Properties
  t plx_sc.maxv2
  );

type t_richtextruns is table of CT_RElt;
v_richtextruns_empty t_richtextruns := t_richtextruns();

type CT_PhoneticRun is record(
  tag plx_sc.normalv2,
  eb plx_sc.normalv2,
  sb plx_sc.normalv2,
  t plx_sc.maxv2
  );

type t_phoneticruns is table of CT_PhoneticRun;
v_phoneticruns_empty t_phoneticruns := t_phoneticruns();

subtype ST_PhoneticType is ploffx_util.t_string;
c_fullwidthKatakana constant ST_PhoneticType := 'fullwidthKatakana';
c_halfwidthKatakana constant ST_PhoneticType := 'halfwidthKatakana';
c_Hiragana constant ST_PhoneticType := 'Hiragana';
c_noConversion constant ST_PhoneticType := 'noConversion';

subtype ST_PhoneticAlignment is ploffx_util.t_string;
c_center constant ST_PhoneticAlignment := 'center';
c_ditributed constant ST_PhoneticAlignment := 'distributed';
c_left constant ST_PhoneticAlignment := 'left';
c_noControl constant ST_PhoneticAlignment := 'noControl';

type CT_PhoneticPr is record(
  tag plx_sc.normalv2,
  fontId plx_sc.normalv2, -- ST_FontId, xsd:unsignedInt
  type_ ST_PhoneticType,
  alignment ST_PhoneticAlignment
  );

type CT_Rst is record (
  tag plx_sc.normalv2,
  t plx_sc.maxv2, --text
  r t_richtextruns, --rich texts
  rPh t_phoneticruns, --
  phoneticPr CT_PhoneticPr -- Phonetic Properties
  );

type t_stringitems is table of CT_Rst index by pls_integer;

type CT_Sst is record (
  tag plx_sc.normalv2,
  si t_stringitems,
  -- extLst TODO
  count_ plx_sc.normalv2, --pls_integer, --xsd:unsignedInt
  uniqueCount plx_sc.normalv2, --pls_integer --xsd:unsignedInt
  last_si pls_integer := 0
  );
v_sst_empty CT_Sst;
-----------------------------------------------------------------------------------------------
--
--v3.6.0
procedure initCstore;
--v3.6.0
procedure addCline(
  p_string varchar2
  );
--v3.6.0
procedure setClobMode;
--v3.6.0
function getStructMode
  return boolean;
--
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
--
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );
-- sst
procedure startsst(
  p_tag varchar2 default t_sst,
  p_xml in out plx_sc.type_xdoc,
  p_count varchar2 default null,
  p_uniqueCount varchar2 default null
  );
--
procedure endsst(
  p_tag varchar2 default t_sst,
  p_xml in out plx_sc.type_xdoc
  );
-- si
procedure startsi(
  p_tag varchar2 default t_si,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endsi(
  p_tag varchar2 default t_si,
  p_xml in out plx_sc.type_xdoc
  );
-- t
procedure startt(
  p_tag varchar2 default t_t,
  p_xml in out plx_sc.type_xdoc,
  p_xml_space varchar2 default null --v4.9.0
  );
--
procedure endt(
  p_tag varchar2 default t_t,
  p_xml in out plx_sc.type_xdoc
  );
-- phoneticPr
procedure phoneticPr(
  p_tag varchar2 default t_phoneticPr,
  p_xml in out plx_sc.type_xdoc,
  p_fontId varchar2,
  p_type varchar2 default null,
  p_alignment varchar2 default null
  );
-- rPh
procedure startrPh(
  p_tag varchar2 default t_rPh,
  p_xml in out plx_sc.type_xdoc,
  p_sb varchar2, --xsd:unsignedInt
  p_eb varchar2 --xsd:unsignedInt
  );
--
procedure endrPh(
  p_tag varchar2 default t_rPh,
  p_xml in out plx_sc.type_xdoc
  );
-- r
procedure startr(
  p_tag varchar2 default t_r,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endr(
  p_tag varchar2 default t_r,
  p_xml in out plx_sc.type_xdoc
  );
-- rPr
procedure startrPr(
  p_tag varchar2 default t_rPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endrPr(
  p_tag varchar2 default t_rPh,
  p_xml in out plx_sc.type_xdoc
  );
-- b
procedure b(
  p_tag varchar2 default t_b,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- charset
procedure charset(
  p_tag varchar2 default t_charset,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 -- xsd:int
  );
-- color
procedure color(
  p_tag varchar2 default t_color,
  p_xml in out plx_sc.type_xdoc,
  p_auto varchar2 default null, --boolean
  p_indexed varchar2 default null, -- ST_UsingedInt
  p_rgb varchar2 default null, -- ST_UsingedIntHex
  p_theme varchar2 default null, -- ST_UsingedInt
  p_tint varchar2 default null -- xsd:double
  );
-- condense
procedure condense(
  p_tag varchar2 default t_condense,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- extend
procedure extend_(
  p_tag varchar2 default t_extend,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- family
procedure family(
  p_tag varchar2 default t_family,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 -- xds:int
  );
-- i
procedure i(
  p_tag varchar2 default t_i,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- outline
procedure outline(
  p_tag varchar2 default t_outline,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- rFont
procedure rFont(
  p_tag varchar2 default t_rFont,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 -- ST_Xstring
  );
-- scheme
procedure scheme(
  p_tag varchar2 default t_scheme,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- shadow
procedure shadow(
  p_tag varchar2 default t_shadow,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- strike
procedure strike(
  p_tag varchar2 default t_strike,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_util.c_true
  );
-- sz
procedure sz(
  p_tag varchar2 default t_sz,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 -- xsd:double
  );
-- u
procedure u(
  p_tag varchar2 default t_u,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default ploffx_xlsx_styles.c_single -- ST_UnderlineValues
  );
-- vertalign
procedure vertAlign(
  p_tag varchar2 default t_vertAlign,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 -- ST_VerticalAlignRun
  );

-- CREATE STRUCTURES
------------------------------------------
-- si: CT_Rst
function cr_sst(
  p_tag varchar2 default t_sst,
  p_si t_stringitems,
  p_count varchar2 default null,
  p_uniqueCount varchar2 default null
  ) return CT_Sst;

------------------------------------------
-- si: CT_Rst
function cr_si(
  p_tag varchar2 default t_si,
  p_t plx_sc.maxv2 default null, -- text
  p_r t_richtextruns default null,
  p_rPh t_phoneticruns default null,
  p_phoneticPr CT_PhoneticPr default null
  ) return CT_Rst;

-- si:t_stringitems
procedure add_si(
  p_table in out t_stringitems,
  p_si CT_Rst
  );


------------------------------------------
-- phoneticPr: CT_PhoneticPr
function cr_phoneticPr(
  p_tag varchar2 default t_phoneticPr,
  p_fontId varchar2 default null,
  p_type ST_PhoneticType default null,
  p_alignment ST_PhoneticAlignment default null
  ) return CT_PhoneticPr;

------------------------------------------
-- rPh: CT_PhoneticRun
function cr_rPh(
  p_tag varchar2 default t_phoneticPr,
  p_eb plx_sc.normalv2 default null,
  p_sb plx_sc.normalv2 default null,
  p_t plx_sc.maxv2 default null
  ) return CT_PhoneticRun;

-- rph:t_phoneticruns
procedure add_rPh(
  p_table in out t_phoneticruns,
  p_rPh CT_PhoneticRun
  );

------------------------------------------
-- r: CT_RElt
function cr_r(
  p_tag varchar2 default t_r,
  p_rPr CT_RPrElt default null,
  p_t plx_sc.maxv2 default null
  ) return CT_RElt;

-- r:t_richtextruns
procedure add_r(
  p_table in out t_richtextruns,
  p_r CT_RElt
  );

------------------------------------------
-- rPr: CT_RElt
function cr_rPr(
  p_tag varchar2 default t_rPr,
  p_rFont CT_FontName default null,
  p_charset CT_IntProperty default null,
  p_family CT_IntProperty default null,
  p_b CT_BooleanProperty default null,
  p_i CT_BooleanProperty default null,
  p_strike CT_BooleanProperty default null,
  p_outline CT_BooleanProperty default null,
  p_shadow CT_BooleanProperty default null,
  p_condense CT_BooleanProperty default null,
  p_extend CT_BooleanProperty default null,
  p_color ploffx_xlsx_styles.CT_Color default null,
  p_sz CT_FontSize default null,
  p_u CT_UnderlineProperty default null,
  p_vertAlign CT_VerticalAlignFontProperty default null,
  p_scheme CT_FontScheme default null
  ) return CT_RPrElt;

------------------------------------------
-- rFont: CT_FontName
function cr_rFont(
  p_tag varchar2 default t_rFont,
  p_val plx_sc.normalv2 default null
  ) return CT_FontName;

------------------------------------------
-- charset: CT_IntProperty
function cr_charset(
  p_tag varchar2 default t_charset,
  p_val varchar2 default null
  ) return CT_IntProperty;

------------------------------------------
-- family: CT_IntProperty
function cr_family(
  p_tag varchar2 default t_family,
  p_val varchar2 default null
  ) return CT_IntProperty;

------------------------------------------
-- b: CT_BooleanProperty
function cr_b(
  p_tag varchar2 default t_b,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- i: CT_BooleanProperty
function cr_i(
  p_tag varchar2 default t_i,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- strike: CT_BooleanProperty
function cr_strike(
  p_tag varchar2 default t_strike,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- outline: CT_BooleanProperty
function cr_outline(
  p_tag varchar2 default t_outline,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- shadow: CT_BooleanProperty
function cr_shadow(
  p_tag varchar2 default t_shadow,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- condense: CT_BooleanProperty
function cr_condense(
  p_tag varchar2 default t_condense,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- extend: CT_BooleanProperty
function cr_extend(
  p_tag varchar2 default t_extend,
  p_val varchar2 default ploffx_util.c_true
  ) return CT_BooleanProperty;

------------------------------------------
-- color: ploffx_xlsx_styles.CT_Color
function cr_color(
  p_tag varchar2 default t_color,
  p_auto varchar2 default ploffx_util.c_true,
  p_indexed pls_integer default null,
  p_rgb ploffx_xlsx_styles.ST_UnsignedIntHex default null,
  p_theme pls_integer default null,
  p_tint number default null
  ) return ploffx_xlsx_styles.CT_Color;

------------------------------------------
-- sz: CT_FontSize
function cr_sz(
  p_tag varchar2 default t_sz,
  p_val plx_sc.normalv2
  ) return CT_FontSize;

------------------------------------------
-- u: CT_UnderlineProperty
function cr_u(
  p_tag varchar2 default t_u,
  p_val ploffx_xlsx_styles.ST_UnderlineValues
  ) return CT_UnderlineProperty;

------------------------------------------
-- scheme: CT_FontScheme
function cr_scheme(
  p_tag varchar2 default t_scheme,
  p_val ploffx_xlsx_styles.ST_FontScheme
  ) return CT_FontScheme;

------------------------------------------
-- vertAlign: CT_VerticalAlignFontProperty
function cr_vertAlign(
  p_tag varchar2 default t_vertAlign,
  p_val ploffx_xlsx_styles.ST_VerticalAlignRun
  ) return CT_VerticalAlignFontProperty;

------------------------------------------
-- Generate xml parts
------------------------------------------
-- sst: CT_Sst
procedure gen_sst(
  p_xml in out plx_sc.type_xdoc,
  p_sst CT_Sst
  );

------------------------------------------
-- si: CT_Rst
procedure gen_si(
  p_xml in out plx_sc.type_xdoc,
  p_si CT_Rst,
  p_iid number default null --v3.3.0
  );

------------------------------------------
-- phoneticPr: CT_PhoneticPr
procedure gen_phoneticPr(
  p_xml in out plx_sc.type_xdoc,
  p_phoneticPr CT_PhoneticPr
  );

------------------------------------------
-- rPh: CT_PhoneticRun
procedure gen_rPh(
  p_xml in out plx_sc.type_xdoc,
  p_rPh CT_PhoneticRun
  );

------------------------------------------
-- r: CT_RElt
procedure gen_r(
  p_xml in out plx_sc.type_xdoc,
  p_r CT_RElt
  );

------------------------------------------
-- rPr: CT_RElt
procedure gen_rPr(
  p_xml in out plx_sc.type_xdoc ,
  p_rPr CT_RPrElt
  );

------------------------------------------
-- rFont: CT_FontName
procedure gen_rFont(
  p_xml in out plx_sc.type_xdoc ,
  p_rFont CT_FontName
  );

------------------------------------------
-- charset: CT_IntProperty
procedure gen_charset(
  p_xml in out plx_sc.type_xdoc ,
  p_charset CT_IntProperty
  );

------------------------------------------
-- family: CT_IntProperty
procedure gen_family(
  p_xml in out plx_sc.type_xdoc ,
  p_family CT_IntProperty
  );

------------------------------------------
-- b: CT_BooleanProperty
procedure gen_b(
  p_xml in out plx_sc.type_xdoc ,
  p_b CT_BooleanProperty
  );

------------------------------------------
-- i: CT_BooleanProperty
procedure gen_i(
  p_xml in out plx_sc.type_xdoc ,
  p_i CT_BooleanProperty
  );

------------------------------------------
-- strike: CT_BooleanProperty
procedure gen_strike(
  p_xml in out plx_sc.type_xdoc ,
  p_strike CT_BooleanProperty
  );

------------------------------------------
-- outline: CT_BooleanProperty
procedure gen_outline(
  p_xml in out plx_sc.type_xdoc ,
  p_outline CT_BooleanProperty
  );

------------------------------------------
-- shadow: CT_BooleanProperty
procedure gen_shadow(
  p_xml in out plx_sc.type_xdoc ,
  p_shadow CT_BooleanProperty
  );

------------------------------------------
-- condense: CT_BooleanProperty
procedure gen_condense(
  p_xml in out plx_sc.type_xdoc ,
  p_condense CT_BooleanProperty
  );

------------------------------------------
-- extend: CT_BooleanProperty
procedure gen_extend(
  p_xml in out plx_sc.type_xdoc ,
  p_extend CT_BooleanProperty
  );

------------------------------------------
-- color: ploffx_xlsx_styles.CT_Color
procedure gen_color(
  p_xml in out plx_sc.type_xdoc ,
  p_color ploffx_xlsx_styles.CT_Color
  );

------------------------------------------
-- sz: CT_FontSize
procedure gen_sz(
  p_xml in out plx_sc.type_xdoc ,
  p_Sz CT_FontSize
  );

------------------------------------------
-- u: CT_UnderlineProperty
procedure gen_u(
  p_xml in out plx_sc.type_xdoc ,
  p_u CT_UnderlineProperty
  );

------------------------------------------
-- scheme: CT_FontScheme
procedure gen_scheme(
  p_xml in out plx_sc.type_xdoc ,
  p_scheme CT_FontScheme
  );

------------------------------------------
-- vertAlign: CT_VerticalAlignFontProperty
procedure gen_vertAlign(
  p_xml in out plx_sc.type_xdoc ,
  p_vertAlign CT_VerticalAlignFontProperty
  );

------------------------------------------
-- t: plx_sc.maxv2 -- XString
procedure gen_t(
  p_xml in out plx_sc.type_xdoc,
  p_t plx_sc.maxv2,
  p_xml_space varchar2 default null --v4.9.0
  );
--

-- GEN_XML
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_Sst CT_Sst
  );
-- PARSE
function parse(
  p_file clob
  ) return CT_Sst;
--
end ploffx_sharedStrings;
/

