create or replace package ploffx_settings
authid current_user is
--v5.9
--
-- Namespace
ns_sl constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/schemaLibrary/2006/main';
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_w10 constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:word';
ns_v constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:vml';
ns_m constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/math';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_o constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:office';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';

-- Prefixes
ns_sl_pref constant varchar2(2 char) := 'sl';
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_w_pref constant varchar2(1 char) := 'w';
ns_w10_pref constant varchar2(3 char) := 'w10';
ns_v_pref constant varchar2(1 char) := 'v';
ns_m_pref constant varchar2(1 char) := 'm';
ns_r_pref constant varchar2(1 char) := 'r';
ns_o_pref constant varchar2(1 char) := 'o';
ns_mc_pref constant varchar2(2 char) := 'mc';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_activeRecord constant plx_sc.normalv2 := 'activeRecord';
t_activeWritingStyle constant plx_sc.normalv2 := 'activeWritingStyle';
t_addressFieldName constant plx_sc.normalv2 := 'addressFieldName';
t_alignBordersAndEdges constant plx_sc.normalv2 := 'alignBordersAndEdges';
t_alwaysMergeEmptyNamespace constant plx_sc.normalv2 := 'alwaysMergeEmptyNamespace';
t_alwaysShowPlaceholderText constant plx_sc.normalv2 := 'alwaysShowPlaceholderText';
t_attachedSchema constant plx_sc.normalv2 := 'attachedSchema';
t_attachedTemplate constant plx_sc.normalv2 := 'attachedTemplate';
t_autoCaption constant plx_sc.normalv2 := 'autoCaption';
t_autoCaptions constant plx_sc.normalv2 := 'autoCaptions';
t_autoFormatOverride constant plx_sc.normalv2 := 'autoFormatOverride';
t_autoHyphenation constant plx_sc.normalv2 := 'autoHyphenation';
t_bookFoldPrinting constant plx_sc.normalv2 := 'bookFoldPrinting';
t_bookFoldPrintingSheets constant plx_sc.normalv2 := 'bookFoldPrintingSheets';
t_bookFoldRevPrinting constant plx_sc.normalv2 := 'bookFoldRevPrinting';
t_bordersDoNotSurroundFooter constant plx_sc.normalv2 := 'bordersDoNotSurroundFooter';
t_bordersDoNotSurroundHeader constant plx_sc.normalv2 := 'bordersDoNotSurroundHeader';
t_brkBin constant plx_sc.normalv2 := 'brkBin';
t_brkBinSub constant plx_sc.normalv2 := 'brkBinSub';
t_caption constant plx_sc.normalv2 := 'caption';
t_captions constant plx_sc.normalv2 := 'captions';
t_characterSpacingControl constant plx_sc.normalv2 := 'characterSpacingControl';
t_checkErrors constant plx_sc.normalv2 := 'checkErrors';
t_clickAndTypeStyle constant plx_sc.normalv2 := 'clickAndTypeStyle';
t_clrSchemeMapping constant plx_sc.normalv2 := 'clrSchemeMapping';
t_colDelim constant plx_sc.normalv2 := 'colDelim';
t_column constant plx_sc.normalv2 := 'column';
t_compat constant plx_sc.normalv2 := 'compat';
t_compatSetting constant plx_sc.normalv2 := 'compatSetting';
t_connectString constant plx_sc.normalv2 := 'connectString';
t_consecutiveHyphenLimit constant plx_sc.normalv2 := 'consecutiveHyphenLimit';
t_dataSource constant plx_sc.normalv2 := 'dataSource';
t_dataType constant plx_sc.normalv2 := 'dataType';
t_decimalSymbol constant plx_sc.normalv2 := 'decimalSymbol';
t_defaultTableStyle constant plx_sc.normalv2 := 'defaultTableStyle';
t_defaultTabStop constant plx_sc.normalv2 := 'defaultTabStop';
t_defJc constant plx_sc.normalv2 := 'defJc';
t_destination constant plx_sc.normalv2 := 'destination';
t_dispDef constant plx_sc.normalv2 := 'dispDef';
t_displayBackgroundShape constant plx_sc.normalv2 := 'displayBackgroundShape';
t_dispHorizDrawingGridEvery constant plx_sc.normalv2 := 'displayHorizontalDrawingGridEvery';
t_dispVerticDrawingGridEvery constant plx_sc.normalv2 := 'displyaVertivalDrawingGridEvery';
t_documentProtection constant plx_sc.normalv2 := 'documentProtection';
t_documentType constant plx_sc.normalv2 := 'documentType';
t_docVar constant plx_sc.normalv2 := 'docVar';
t_docVars constant plx_sc.normalv2 := 'docVars';
t_doNotAutoCompressPictures constant plx_sc.normalv2 := 'doNotAutoCompressPictures';
t_doNotDemarcateInvalidXml constant plx_sc.normalv2 := 'doNotDemarcateInvalidXml';
t_doNotDisplayPageBoundaries constant plx_sc.normalv2 := 'doNotDisplayPageBoundaries';
t_doNotEmbedSmartTags constant plx_sc.normalv2 := 'doNotEmbedSmartTags';
t_doNotHyphenateCaps constant plx_sc.normalv2 := 'doNotHyphenateCaps';
t_doNotIncludeSubdocsInStats constant plx_sc.normalv2 := 'doNotIncludeSubdocsInStats';
t_doNotShadeFormData constant plx_sc.normalv2 := 'doNotShadeFormData';
t_doNotSuppressBlankLines constant plx_sc.normalv2 := 'doNotSupressBlankLines';
t_doNotTrackFormatting constant plx_sc.normalv2 := 'doNotTrackFormatting';
t_doNotTrackMoves constant plx_sc.normalv2 := 'doNotTrackMoves';
t_doNotUseMargForDrawGridOrig constant plx_sc.normalv2 := 'doNotUseMarginsForDrawingGridOrigin';
t_doNotValidateAgainstSchema constant plx_sc.normalv2 := 'doNotValidateAgainstSchema';
t_drawingGridHorizontalOrigin constant plx_sc.normalv2 := 'drawingGridHorizontalOrigin';
t_drawingGridHorizontalSpacing constant plx_sc.normalv2 := 'drawingGridHorizontalSpacing';
t_drawingGridVerticalOrigin constant plx_sc.normalv2 := 'drawingGridVertivalOrigin';
t_drawingGridVerticalSpacing constant plx_sc.normalv2 := 'drawingGridVerticalSpacing';
t_dynamicAddress constant plx_sc.normalv2 := 'dynamicAddress';
t_embedSystemFonts constant plx_sc.normalv2 := 'embedSystemFonts';
t_embedTrueTypeFonts constant plx_sc.normalv2 := 'embedTrueTypeFonts';
t_endnote constant plx_sc.normalv2 := 'endnote';
t_endnotePr constant plx_sc.normalv2 := 'endnotePr';
t_evenAndOddHeaders constant plx_sc.normalv2 := 'evenAndOddHeaders';
t_fHdr constant plx_sc.normalv2 := 'fHdr';
t_fieldMapData constant plx_sc.normalv2 := 'fieldMapData';
t_footnote constant plx_sc.normalv2 := 'footnote'; -- v.1.3.0
t_footnotePr constant plx_sc.normalv2 := 'footnotePr';
t_forceUpgrade constant plx_sc.normalv2 := 'forceUpgrade';
t_formsDesign constant plx_sc.normalv2 := 'formsDesign';
t_gutterAtTop constant plx_sc.normalv2 := 'gutterAtTop';
t_hdrShapeDefaults constant plx_sc.normalv2 := 'hdrShapeDefaults';
t_headerSource constant plx_sc.normalv2 := 'headerSource';
t_hideGrammaticalErrors constant plx_sc.normalv2 := 'hideGrammaticalErrors';
t_hideSpellingErrors constant plx_sc.normalv2 := 'hideSpellingErrors';
t_hyphenationZone constant plx_sc.normalv2 := 'hyphenationZone';
t_idmap constant plx_sc.normalv2 := 'idmap';
t_ignoreMixedContent constant plx_sc.normalv2 := 'ignoreMixedContent';
t_interSp constant plx_sc.normalv2 := 'interSp';
t_intraSp constant plx_sc.normalv2 := 'intraSp';
t_intLim constant plx_sc.normalv2 := 'intLim';
t_lid constant plx_sc.normalv2 := 'lid';
t_linkStyles constant plx_sc.normalv2 := 'linkStyles';
t_listSeparator constant plx_sc.normalv2 := 'listSeparator';
t_linkToQuery constant plx_sc.normalv2 := 'linkToQuery';
t_lMargin constant plx_sc.normalv2 := 'lMargin';
t_mailAsAttachment constant plx_sc.normalv2 := 'mailAsAttachment';
t_mailMerge constant plx_sc.normalv2 := 'mailMerge';
t_mailSubject constant plx_sc.normalv2 := 'mailSubject';
t_mainDocumentType constant plx_sc.normalv2 := 'mainDocumentType';
t_mappedName constant plx_sc.normalv2 := 'mappedName';
t_mathFont constant plx_sc.normalv2 := 'mathFont';
t_mathPr constant plx_sc.normalv2 := 'mathPr';
t_mirrorMargins constant plx_sc.normalv2 := 'mirrorMargins';
t_name constant plx_sc.normalv2 := 'name';
t_naryLim constant plx_sc.normalv2 := 'naryLim';
t_noLineBreaksAfter constant plx_sc.normalv2 := 'noLineBreaksAfter';
t_noLineBreaksBefore constant plx_sc.normalv2 := 'noLineBreaksBefore';
t_noPunctuationKerning constant plx_sc.normalv2 := 'noPunctuationKerning';
t_numFmt constant plx_sc.normalv2 := 'numFmt';
t_numRestart constant plx_sc.normalv2 := 'numRestart';
t_numStart constant plx_sc.normalv2 := 'numStart';
t_odso constant plx_sc.normalv2 := 'odso';
t_pos constant plx_sc.normalv2 := 'pos';
t_postSp constant plx_sc.normalv2 := 'postSp';
t_preSp constant plx_sc.normalv2 := 'preSp';
t_printFormsData constant plx_sc.normalv2 := 'printFormsData';
t_printFractionalCharWidth constant plx_sc.normalv2 := 'printFractionalCharacterWidth';
t_printPostScriptOverText constant plx_sc.normalv2 := 'printPostScriptOverText';
t_printTwoOnOne constant plx_sc.normalv2 := 'printTwoOnOne';
t_proofState constant plx_sc.normalv2 := 'proofState';
t_query constant plx_sc.normalv2 := 'query';
t_readModeInkLockDown constant plx_sc.normalv2 := 'readModeInkLockDown';
t_recipientData constant plx_sc.normalv2 := 'recipientData';
t_removeDateAndTime constant plx_sc.normalv2 := 'removeDateAndTime';
t_removePersonalInformation constant plx_sc.normalv2 := 'removePersonalInformation';
t_revisionView constant plx_sc.normalv2 := 'revisionView';
t_rMargin constant plx_sc.normalv2 := 'rMargin';
t_rsidRoot constant plx_sc.normalv2 := 'rsidRoot';
t_rsid constant plx_sc.normalv2 := 'rsid';
t_rsids constant plx_sc.normalv2 := 'rsids';
t_saveFormsData constant plx_sc.normalv2 := 'saveFormsData';
t_saveInvalidXml constant plx_sc.normalv2 := 'saveInvalidXml';
t_savePreviewPicture constant plx_sc.normalv2 := 'savePreviewPicture';
t_saveSubsetFonts constant plx_sc.normalv2 := 'saveSubsetFonts';
t_saveThroughXslt constant plx_sc.normalv2 := 'saveThroughXslt';
t_saveXmlDataOnly constant plx_sc.normalv2 := 'saveXmlDataOnly';
t_schema constant plx_sc.normalv2 := 'schema';
t_schemaLibrary constant plx_sc.normalv2 := 'schemaLibrary';
t_settings constant plx_sc.normalv2 := 'settings';
t_shapeDefaults constant plx_sc.normalv2 := 'shapeDefaults';
t_showEnvelope constant plx_sc.normalv2 := 'showEnvelope';
t_showXMLTags constant plx_sc.normalv2 := 'showXMLTags';
t_o_shapedefaults constant plx_sc.normalv2 := 'shapedefaults';
t_shapelayout constant plx_sc.normalv2 := 'shapelayout';
t_smallFrac constant plx_sc.normalv2 := 'smallFrac';
t_smartTagType constant plx_sc.normalv2 := 'smarTagType';
t_src constant plx_sc.normalv2 := 'src';
t_strictFirstAndLastChars constant plx_sc.normalv2 := 'strictFirstAndLastChars';
t_styleLockQFSet constant plx_sc.normalv2 := 'styleLockQFSet';
t_styleLockTheme constant plx_sc.normalv2 := 'styleLockTheme';
t_stylePaneFormatFilter constant plx_sc.normalv2 := 'stylePaneFormatFilter';
t_stylePaneShortMethod constant plx_sc.normalv2 := 'stylePaneShortMethod';
t_summaryLength constant plx_sc.normalv2 := 'summaryLength';
t_table constant plx_sc.normalv2 := 'table';
t_themeFontLang constant plx_sc.normalv2 := 'themeFontLang';
t_trackRevisions constant plx_sc.normalv2 := 'trackRevisions';
t_type constant plx_sc.normalv2 := 'type';
t_udl constant plx_sc.normalv2 := 'udl';
t_uiCompat97To2003 constant plx_sc.normalv2 := 'uiCompat97To2003';
t_updateFields constant plx_sc.normalv2 := 'updateFields';
t_useXSLTWhenSaving constant plx_sc.normalv2 := 'useXSLTWhenSaving';
t_view constant plx_sc.normalv2 := 'view';
t_viewMergedData plx_sc.normalv2 := 'viewMergedData';
t_wrapIndent constant plx_sc.normalv2 := 'wrapIndent';
t_wrapRight constant plx_sc.normalv2 := 'wrapRight';
t_writeProtection constant plx_sc.normalv2 := 'writeProtection';
t_zoom constant plx_sc.normalv2 := 'zoom';

-- Constants
c_full_ns constant plx_sc.normalv2 := 'xmlns=http://schemas.openxmlformats.org/wordprocessingml/2006/main';
c_filename constant plx_sc.normalv2 := 'word/settings.xml';

/******************************************************************/
--Structures
--v1.3.0

-- ST_Zoom
subtype ST_Zoom is ploffx_util.t_string;
c_none constant ST_Zoom := 'none'; --No Preset Magnification
c_fullPage constant ST_Zoom := 'fullPage'; --Display One Full Page
c_bestFit constant ST_Zoom := 'bestFit'; --Display Page Width
c_textFit constant ST_Zoom := 'textFit'; --Display Text Width

-- CT_Zoom
type CT_Zoom is record (
  tag plx_sc.normalv2,
  val ST_Zoom,
  percent plx_sc.normalv2
  );


-- CT_WritingStyle
type CT_WritingStyle is record(
  tag plx_sc.normalv2,
  appName plx_sc.normalv2,
  checkStyle plx_sc.normalv2,
  dllVersion plx_sc.normalv2,
  lang plx_sc.normalv2,
  nlCheck plx_sc.normalv2,
  vendorID plx_sc.normalv2
  );


-- ST_CaptionPos
subtype ST_CaptionPos is ploffx_util.t_string;
c_above constant ST_CaptionPos := 'above';
c_below constant ST_CaptionPos := 'below';
c_left constant ST_CaptionPos := 'left';
c_right constant ST_CaptionPos := 'right';


-- ST_ChapterSep
subtype ST_ChapterSep is ploffx_util.t_string;
c_colon constant ST_ChapterSep := 'colon';
c_emDash constant ST_ChapterSep := 'emDash';
c_enDash constant ST_ChapterSep := 'enDash';
c_hyphen constant ST_ChapterSep := 'hyphen';
c_period constant ST_ChapterSep := 'period';


-- CT_Caption
type CT_Caption is record(
  tag plx_sc.normalv2,
  name_ plx_sc.normalv2,
  pos ST_CaptionPos,
  chapNum plx_sc.normalv2,
  heading plx_sc.normalv2,
  noLable plx_sc.normalv2,
  numFmt plx_sc.normalv2,
  sep ST_ChapterSep
);
--
type t_caption_ is table of CT_Caption;
v_captions_empty t_caption_ := t_caption_();


-- CT_AutoCaption
type CT_AutoCaption is record(
  tag plx_sc.normalv2,
  name_ plx_sc.normalv2,
  caption plx_sc.normalv2
  );
--
type t_autoCaption_ is table of CT_AutoCaption;
v_autoCaption_empty t_autoCaption_ := t_autoCaption_();


-- CT_AutoCaptions
type CT_AutoCaptions is record(
  tag plx_sc.normalv2,
  autocaption t_autoCaption_
  );


-- CT_Captions
type CT_Captions is record(
  tag plx_sc.normalv2,
  caption t_caption_,
  autoCaptions CT_AutoCaptions
  );


-- ST_CharacterSpacing
subtype ST_CharacterSpacing is ploffx_util.t_string;
c_compressPunctuation constant ST_CharacterSpacing := 'compressPunctuation';
c_compressPunctAndJapaneseKana constant ST_CharacterSpacing := 'compressPunctuationAndJapaneseKana';
c_doNotCompress constant ST_CharacterSpacing := 'doNotCompress';


-- ST_CharacterSpacing
type CT_CharacterSpacing is record(
  tag plx_sc.normalv2,
  val ST_CharacterSpacing
  );

subtype ST_ColorSchemeIndex is ploffx_util.t_string;
c_accent1 constant ST_ColorSchemeIndex := 'accent1';
c_accent2 constant ST_ColorSchemeIndex := 'accent2';
c_accent3 constant ST_ColorSchemeIndex := 'accent3';
c_accent4 constant ST_ColorSchemeIndex := 'accent4';
c_accent5 constant ST_ColorSchemeIndex := 'accent5';
c_accent6 constant ST_ColorSchemeIndex := 'accent6';
c_dark1 constant ST_ColorSchemeIndex := 'dark1';
c_dark2 constant ST_ColorSchemeIndex := 'dark2';
c_followedHyperlink constant ST_ColorSchemeIndex := 'followedHyperlink';
c_hyperlink constant ST_ColorSchemeIndex := 'hyperlink';
c_light1 constant ST_ColorSchemeIndex := 'light1';
c_light2 constant ST_ColorSchemeIndex := 'light2';


-- CT_ColorSchemeMapping
type CT_ColorSchemeMapping is record(
  tag plx_sc.normalv2,
  accent1 ST_ColorSchemeIndex default null,
  accent2 ST_ColorSchemeIndex default null,
  accent3 ST_ColorSchemeIndex default null,
  accent4 ST_ColorSchemeIndex default null,
  accent5 ST_ColorSchemeIndex default null,
  accent6 ST_ColorSchemeIndex default null,
  bg1 ST_ColorSchemeIndex default null,
  bg2 ST_ColorSchemeIndex default null,
  followedHyperlink ST_ColorSchemeIndex default null,
  hyperlink ST_ColorSchemeIndex default null,
  t1 ST_ColorSchemeIndex default null,
  t2 ST_ColorSchemeIndex default null
  );


-- CT_DocProtect
type CT_DocProtect is record(
  tag plx_sc.normalv2,
  algIdExt plx_sc.normalv2,
  algIdSource plx_sc.normalv2,
  cryptAlogrithmClass plx_sc.normalv2,
  cryptAlgorithmSid plx_sc.normalv2,
  cryptAlgorithmType plx_sc.normalv2,
  cryptProvider plx_sc.normalv2,
  cryptProviderType plx_sc.normalv2,
  cryptProviderTypeExt plx_sc.normalv2,
  cryptProviderTypeExtSource plx_sc.normalv2,
  cryptSpinCount plx_sc.normalv2,
  edit plx_sc.normalv2,
  enforcement plx_sc.normalv2,
  formatting plx_sc.normalv2,
  hash_ plx_sc.normalv2,
  salt plx_sc.normalv2
  );


-- ST_DocType
subtype ST_DocType is ploffx_util.t_string;
c_eMail constant ST_DocType := 'eMail';
c_letter constant ST_DocType := 'letter';
c_notSpecified constant ST_DocType := 'notSpecified';


-- CT_DocType
type CT_DocType is record(
  tag plx_sc.normalv2,
  val ST_DocType
  );


-- CT_DocVar
type CT_DocVar is record(
  tag plx_sc.normalv2,
  name_ plx_sc.normalv2,
  val plx_sc.normalv2
  );

type t_docVars_ is table of CT_DocVar;
v_docVars_empty t_docVars_ := t_docVars_();


-- CT_DocVars
type CT_DocVars is record(
     tag plx_sc.normalv2,
     docVar t_docVars_
     );


-- CT_FtnEdnSepRef
type CT_FtnEdnSepRef is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2
     );

type t_endnote_ is table of CT_FtnEdnSepRef;
v_endnote_empty t_endnote_ := t_endnote_();


-- ST_RestartNumber
subtype ST_RestartNumber is ploffx_util.t_string;
c_continuous constant ST_RestartNumber := 'continuous';
c_eachPage constant ST_RestartNumber := 'eachPage';
c_eachSect constant ST_RestartNumber := 'eachSect';


-- CT_RestartNumber
type CT_RestartNumber is record(
     tag plx_sc.normalv2,
     val ST_RestartNumber
     );


-- ST_EdnPos
subtype ST_EdnPos is ploffx_util.t_string;
c_docEnd constant ST_EdnPos := 'docEnd';
c_sectEnd constant ST_EdnPos := 'secEnd';


-- CT_EdnPos
type CT_EdnPos is record(
     tag plx_sc.normalv2,
     val ST_EdnPos
     );


-- CT_EdnDocProps
type CT_EdnDocProps is record(
     tag plx_sc.normalv2,
     endnote t_endnote_,
     numFmt ploffx_numbering.CT_NumFmt,
     numRestart CT_RestartNumber,
     numStart ploffx_document_type.CT_DecimalNumber,
     pos CT_EdnPos
     );

type t_footnote_ is table of CT_FtnEdnSepRef;
v_footnote_empty t_footnote_ := t_footnote_();


-- CT_FtnDocProps
type CT_FtnDocProps is record(
     tag plx_sc.normalv2,
     footnote t_footnote_,
     numFmt ploffx_numbering.CT_NumFmt,
     numRestart CT_RestartNumber,
     numStart ploffx_document_type.CT_DecimalNumber,
     pos CT_EdnPos
     );


-- CT_Empty
type CT_Empty is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2 -- (TRUE OR FALSE?)
     );


-- CT_Kinsoku
type CT_Kinsoku is record(
     tag plx_sc.normalv2,
     lang plx_sc.normalv2, -- ST_Lang
     val plx_sc.normalv2
     );


-- ST_Proof
subtype ST_Proof is ploffx_util.t_string;
c_clean constant ST_Proof := 'clean';
c_dirty constant ST_Proof := 'dirty';


-- CT_Proof
type CT_Proof is recorD(
     tag plx_sc.normalv2,
     spelling ST_Proof,
     grammar ST_Proof
     );


-- CT_ReadingModeInkLockDown
type CT_ReadingModeInkLockDown is record(
     tag plx_sc.normalv2,
     actualPg plx_sc.normalv2,
     fontSz plx_sc.normalv2,
     h plx_sc.normalv2,
     w plx_sc.normalv2
     );


-- CT_TrackChangesView
type CT_TrackChangesView is record(
     tag plx_sc.normalv2,
     comments ploffx_document_type.ST_OnOff default null,
     formatting ploffx_document_type.ST_OnOff default null,
     inkAnnotations ploffx_document_type.ST_OnOff default null,
     insDel ploffx_document_type.ST_OnOff default null,
     markup ploffx_document_type.ST_OnOff default null
     );


-- t_rsid_
type t_rsid_ is table of ploffx_document_type.CT_LongHexNumber;
v_rsid_empty t_rsid_ := t_rsid_();


-- CT_DocRsids
type CT_DocRsids is record(
     tag plx_sc.normalv2,
     rsidRoot ploffx_document_type.CT_LongHexNumber,
     rsid t_rsid_
     );


-- CT_SaveThroughXslt
type CT_SaveThroughXslt is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2,
     solutionID plx_sc.normalv2
     );


-- CT_Schema
type CT_Schema is record(
     tag plx_sc.normalv2,
     manifestLocation plx_sc.normalv2,
     schemaLocation plx_sc.normalv2,
     uri plx_sc.normalv2
     );


-- t_schema_
type t_schema_ is table of CT_Schema;
v_schema_empty t_schema_ := t_schema_();


-- CT_SchemaLibrary
type CT_SchemaLibrary is record(
     tag plx_sc.normalv2,
     schema_ t_schema_
     );


-- CT_SmartTagType
type CT_SmartTagType is record(
     tag plx_sc.normalv2,
     name_ plx_sc.normalv2,
     namespaceuri plx_sc.normalv2,
     url plx_sc.normalv2
     );

subtype ST_View is ploffx_util.t_string;
c_masterPages constant ST_View := 'masterPages';
c_none constant ST_View := 'none';
c_normal constant ST_View := 'normal';
c_outline constant ST_View := 'outline';
c_print constant ST_View := 'print';
c_web constant ST_View := 'web';


-- CT_View
type CT_View is record(
     tag plx_sc.normalv2,
     val ST_View
     );


-- CT_WriteProtection
type CT_WriteProtection is record(
     tag plx_sc.normalv2,
     algIdExt plx_sc.normalv2 default null,
     algIdExtSource plx_sc.normalv2 default null,
     cryptAlgorithmClass plx_sc.normalv2 default null,
     cryptAlgorithmSid plx_sc.normalv2 default null,
     cryptAlgorithmType plx_sc.normalv2 default null,
     cryptProvider plx_sc.normalv2 default null,
     cryptProviderType plx_sc.normalv2 default null,
     cryptProviderTypeExt plx_sc.normalv2 default null,
     cryptProviderTypeExtSource plx_sc.normalv2 default null,
     cryptSpinCount plx_sc.normalv2 default null,
     hash_ plx_sc.normalv2 default null,
     recommended plx_sc.normalv2 default null,
     salt plx_sc.normalv2 default null
     );


-- ST_MailMergeDataType
subtype ST_MailMergeDataType is ploffx_util.t_string;
c_database constant ST_MailMergeDataType := 'database';
c_native constant ST_MailMergeDataType := 'native';
c_odbc constant ST_MailMergeDataType := 'odbc';
c_query constant ST_MailMergeDataType := 'query';
c_spreadsheet constant ST_MailMergeDataType := 'spreadsheet';
c_textFile constant ST_MailMergeDataType := 'textFile';


-- CT_MailMergeDataType
type CT_MailMergeDataType is record(
     tag plx_sc.normalv2,
     val ST_MailMergeDataType
     );


-- ST_MailMergeDest
subtype ST_MailMergeDest is ploffx_util.t_string;
c_email constant ST_MailMergeDest := 'email';
c_fax constant ST_MailMergeDest := 'fax';
c_newDocument constant ST_MailMergeDest := 'newDocument';
c_printer constant ST_MailMergeDest := 'printer';


-- CT_MailMergeDest
type CT_MailMergeDest is record(
     tag plx_sc.normalv2,
     val ST_MailMergeDest
     );


-- ST_MailMergeDocType
subtype ST_MailMergeDocType is ploffx_util.t_string;
c_catalog constant ST_MailMergeDocType := 'catalog';
c_email constant ST_MailMergeDocType := 'email';
c_envelopes constant ST_MailMergeDocType := 'envelopes';
c_fax constant ST_MailMergeDocType := 'fax';
c_formLetters constant ST_MailMergeDocType := 'formLetters';
c_mailingLabels constant ST_MailMergeDocType := 'mailingLabels';


-- CT_MailMergeDocType
type CT_MailMergeDocType is record(
     tag plx_sc.normalv2,
     val ST_MailMergeDocType
     );


-- t_recipientData_
type t_recipientData_ is table of ploffx_document_type.CT_Rel;
v_recipientData_empty t_recipientData_ := t_recipientData_();


-- ST_MailMergeSourceType
subtype ST_MailMergeSourceType is ploffx_util.t_string;
c_addressBook constant ST_MailMergeSourceType := 'addressBook';
c_database constant ST_MailMergeSourceType := 'database';
c_document1 constant ST_MailMergeSourceType := 'document1';
c_document2 constant ST_MailMergeSourceType := 'document2';
c_email constant ST_MailMergeSourceType := 'email';
c_legacy constant ST_MailMergeSourceType := 'legacy';
c_master constant ST_MailMergeSourceType := 'master';
c_native constant ST_MailMergeSourceType := 'native';
c_text constant ST_MailMergeSourceType := 'text';


-- CT_MailMergeSourceType
type CT_MailMergeSourceType is record(
     tag plx_sc.normalv2,
     val ST_MailMergeSourceType
     );


-- ST_MailMergeOdsoFMDFieldType
subtype ST_MailMergeOdsoFMDFieldType is ploffx_util.t_string;
c_dbColumn constant ST_MailMergeOdsoFMDFieldType := 'dbColumn';
c_null constant ST_MailMergeOdsoFMDFieldType := 'null';


-- CT_MailMergeOdsoFMDFieldType
type CT_MailMergeOdsoFMDFieldType is record(
     tag plx_sc.normalv2,
     val ST_MailMergeOdsoFMDFieldType
     );


-- ST_Lang
subtype ST_Lang is ploffx_util.t_string;


-- CT_Lang
type CT_Lang is record(
     tag plx_sc.normalv2,
     val ST_Lang
     );


-- CT_OdsoFieldMapData
type CT_OdsoFieldMapData is record(
     tag plx_sc.normalv2,
     column ploffx_document_type.CT_DecimalNumber,
     dynamicAddress ploffx_document_type.CT_OnOff,
     lid CT_Lang,
     mappedName ploffx_document_type.CT_String,
     name_ ploffx_document_type.CT_String,
     type_ CT_MailMergeOdsoFMDFieldType
     );


-- t_odsoFieldMapData_
type t_odsoFieldMapData_ is table of CT_OdsoFieldMapData;
v_odsoFieldMapData_empty t_odsoFieldMapData_ := t_odsoFieldMapData_();


-- CT_Odso
type CT_Odso is record(
     tag plx_sc.normalv2,
     colDelim ploffx_document_type.CT_DecimalNumber,
     fHdr ploffx_document_type.CT_OnOff,
     fieldMapData t_odsoFieldMapData_,
     recipientData t_recipientData_,
     src ploffx_document_type.CT_Rel,
     table_ ploffx_document_type.CT_String,
     type_ CT_MailMergeSourceType,
     udl ploffx_document_type.CT_String
     );


-- CT_MailMerge
type CT_MailMerge is record(
     tag plx_sc.normalv2,
     activeRecord  ploffx_document_type.CT_DecimalNumber,
     addressFieldName  ploffx_document_type.CT_String,
     checkErrors  ploffx_document_type.CT_DecimalNumber,
     connectString ploffx_document_type.CT_String,
     dataSource ploffx_document_type.CT_Rel,
     dataType CT_MailMergeDataType,
     destination CT_MailMergeDest,
     doNotSupressBlankLines ploffx_document_type.CT_OnOff,
     headerSource ploffx_document_type.CT_Rel,
     linkToQuery ploffx_document_type.CT_OnOff,
     mailAsAttachment ploffx_document_type.CT_OnOff,
     mailSubject ploffx_document_type.CT_String,
     mainDocumentType CT_MailMergeDocType,
     odso CT_Odso,
     query ploffx_document_type.CT_String,
     viewMergedData ploffx_document_type.CT_OnOff
     );


-- ST_BreakBin
subtype ST_BreakBin is ploffx_util.t_string;
c_after constant ST_BreakBin := 'after';
c_before constant ST_BreakBin := 'before';
c_repeat constant ST_BreakBin := 'repeat';


-- CT_BreakBing
type CT_BreakBin is record(
     tag plx_sc.normalv2,
     val ST_BreakBin
     );


-- ST_BreakBinSub
subtype ST_BreakBinSub is ploffx_util.t_string;
c_minmin constant ST_BreakBinSub := '--';
c_minplus constant ST_BreakBinSub := '-+';
c_plusplus constant ST_BreakBinSub := '++';



-- CT_BreakBinSub
type CT_BreakBinSub is record(
     tag plx_sc.normalv2,
     val ST_BreakBinSub
     );


-- CT_OMathJc
type CT_OMathJc is record(
     tag plx_sc.normalv2,
     val ploffx_document_type.ST_Jc
     );


-- ST_LimLoc
subtype ST_LimLoc is ploffx_util.t_string;
c_subSup constant ST_LimLoc := 'subSup';
c_undOvr constant ST_LimLoc := 'undOvr';


-- CT_LimLoc
type CT_LimLoc is record(
     tag plx_sc.normalv2,
     val ST_LimLoc
     );


-- CT_MathPr
type CT_MathPr is record(
     tag plx_sc.normalv2,
     brkBin CT_BreakBin,
     brkBinSub CT_BreakBinSub,
     defJc CT_OMathJc,
     dispDef ploffx_document_type.CT_OnOff,
     interSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     intLim CT_LimLoc,
     intraSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     lMargin ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     mathFont ploffx_document_type.CT_String,
     naryLim CT_LimLoc,
     postSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     preSP ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     rMargin ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     smallFrac ploffx_document_type.CT_OnOff,
     wrapIndent ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
     wrapRight ploffx_document_type.CT_OnOff
     );


-- CT_CompatSetting
type CT_CompatSetting is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2,
     uri plx_sc.normalv2,
     name_ plx_sc.normalv2
     );


-- t_compatSetting_
type t_compatSetting_ is table of CT_CompatSetting;
v_compatSetting_empty t_compatSetting_ := t_compatSetting_();



-- CT_Compat
type CT_Compat is record(
     tag plx_sc.normalv2,
     compatSetting t_compatSetting_
     );


-- CT_O_ShapeDefaults
type CT_O_ShapeDefaults is record(
     tag plx_sc.normalv2,
     allowincell plx_sc.normalv2 default null,
     ext plx_sc.normalv2 default null,
     fill plx_sc.normalv2 default null,
     fillcolor plx_sc.normalv2 default null,
     spidmax plx_sc.normalv2 default null,
     stroke plx_sc.normalv2 default null,
     strokecolor plx_sc.normalv2 default null,
     stlye plx_sc.normalv2 default null
     );


-- CT_Idmap
type CT_Idmap is record(
     tag plx_sc.normalv2,
     data plx_sc.normalv2 default null,
     ext plx_sc.normalv2 default null
     );


-- CT_O_ShapeLayout
type CT_O_ShapeLayout is record(
     tag plx_sc.normalv2,
     ext plx_sc.normalv2 default null,
     idmap CT_Idmap
     );


-- CT_ShapeDefaults
type CT_ShapeDefaults is record(
     tag plx_sc.normalv2,
     o_shapedefaults CT_O_ShapeDefaults,
     shapeLayout CT_O_ShapeLayout
     );


--settings (Document Settings)
type CT_Settings is record (
  tag plx_sc.normalv2,
  activeWritingStyle CT_WritingStyle,
  alignBorderAndEdges ploffx_document_type.CT_OnOff,
  alwaysMergeEmptyNamespace ploffx_document_type.CT_OnOff,
  alwaysShowPlaceholderText ploffx_document_type.CT_OnOff,
  attachedSchema ploffx_document_type.CT_String,
  attachedTemplate ploffx_document_type.CT_Rel,
  autoFormatOverride ploffx_document_type.CT_OnOff, --v1.3.0
  autoHyphenation ploffx_document_type.CT_OnOff,
  bookFoldPrinting ploffx_document_type.CT_OnOff,
  bookFoldPrintingSheets ploffx_document_type.CT_DecimalNumber,
  bookFoldRevPrinting ploffx_document_type.CT_OnOff,
  bordersDoNotSurroundFooter ploffx_document_type.CT_OnOff,
  bordersDoNotSurroundHeader ploffx_document_type.CT_OnOff,
  captions CT_Captions,
  characterSpacingControl CT_CharacterSpacing,
  clickAndTypeStyle ploffx_document_type.CT_String,
  clrSchemeMapping CT_ColorSchemeMapping,
  compat CT_Compat,
  consecutiveHyphenLimit ploffx_document_type.CT_DecimalNumber,
  decimalSymbol ploffx_document_type.CT_String,
  defaultTableStyle ploffx_document_type.CT_String,
  defaultTabStop ploffx_document_type.CT_DecimalNumber,
  displayBackgroundShape ploffx_document_type.CT_OnOff,
  dispHorizDrawingGridEvery ploffx_document_type.CT_DecimalNumber,
  dispVerticDrawingGridEvery ploffx_document_type.CT_DecimalNumber,
  documentProtection CT_DocProtect,
  documentType CT_DocType,
  docVars CT_DocVars,
  donotAutoCompressPictures ploffx_document_type.CT_OnOff,
  doNotDemarcateInvalidXml ploffx_document_type.CT_OnOff,
  doNotDisplayPageBoundaries ploffx_document_type.CT_OnOff,
  doNotEmbedSmartTags ploffx_document_type.CT_OnOff,
  doNotHyphenateCaps ploffx_document_type.CT_OnOff,
  doNotIncludeSubdocsInStats ploffx_document_type.CT_OnOff,
  doNotShadeFormData ploffx_document_type.CT_OnOff,
  doNotTrackFormatting ploffx_document_type.CT_OnOff,
  doNotTrackMoves ploffx_document_type.CT_OnOff,
  doNotUseMargForDrawGridOrig ploffx_document_type.CT_OnOff,
  doNotValidateAgainstSchema ploffx_document_type.CT_OnOff,
  drawingGridHorizontalOrigin ploffx_document_type.CT_DecimalNumber,
  drawingGridHorizontalSpacing ploffx_document_type.CT_DecimalNumber,
  drawingGridVerticalOrigin ploffx_document_type.CT_DecimalNumber,
  drawingGridVerticalSpacing ploffx_document_type.CT_DecimalNumber,
  embedSystemFonts ploffx_document_type.CT_OnOff,
  embedTrueTypeFonts ploffx_document_type.CT_OnOff,
  endnotePr CT_EdnDocProps,
  evenAndOddHeaders ploffx_document_type.CT_OnOff,
  footnotePr CT_FtnDocProps,
  forceUpgrade CT_Empty,
  formsDesign ploffx_document_type.CT_OnOff,
  gutterAtTop ploffx_document_type.CT_OnOff,
  -- TODO hdrShapeDefaults
  hideGrammaticalErrors ploffx_document_type.CT_OnOff,
  hideSpellingErrors ploffx_document_type.CT_OnOff,
  hyphenationZone ploffx_document_type.CT_DecimalNumber,
  ignoreMixedContent ploffx_document_type.CT_OnOff,
  linkStyles ploffx_document_type.CT_OnOff,
  listSeparator ploffx_document_type.CT_String,
  mailMerge CT_MailMerge,
  mathPr CT_MathPr,
  mirrorMargins ploffx_document_type.CT_OnOff,
  noLineBreaksAfter CT_Kinsoku,
  noLineBreaksBefore CT_Kinsoku,
  noPunctuationKerning ploffx_document_type.CT_OnOff,
  printFormsData ploffx_document_type.CT_OnOff,
  printFractionalCharWidth ploffx_document_type.CT_OnOff,
  printPostScriptOverText ploffx_document_type.CT_OnOff,
  printTwoOnOne ploffx_document_type.CT_OnOff,
  proofState CT_Proof,
  readModeInkLockDown CT_ReadingModeInkLockDown,
  removeDateAndTime ploffx_document_type.CT_OnOff,
  removePersonalInformation ploffx_document_type.CT_OnOff,
  revisionView CT_TrackChangesView,
  rsids CT_DocRsids,
  saveFormsData ploffx_document_type.CT_OnOff,
  saveInvalidXml ploffx_document_type.CT_OnOff,
  savePreviewPicture ploffx_document_type.CT_OnOff,
  saveSubsetFonts ploffx_document_type.CT_OnOff,
  saveThroughXslt CT_SaveThroughXslt,
  saveXmlDataOnly ploffx_document_type.CT_OnOff,
  schemaLibrary CT_SchemaLibrary,
  shapeDefaults CT_ShapeDefaults,
  showEnvelope ploffx_document_type.CT_OnOff,
  showXMLTags ploffx_document_type.CT_OnOff,
  smartTagType CT_SmartTagType,
  strictFirstAndLastChars ploffx_document_type.CT_OnOff,
  styleLockQFSet ploffx_document_type.CT_OnOff,
  styleLockTheme ploffx_document_type.CT_OnOff,
  stylePaneFormatFilter ploffx_document_type.CT_LongHexNumber, -- ShortHexNumber v1.3.0
  stylePaneShortMethod ploffx_document_type.CT_LongHexNumber, -- ShortHexNumber v1.3.0
  summaryLength ploffx_document_type.CT_DecimalNumber,
  themeFontLang ploffx_document_type.CT_Language,
  trackRevisions ploffx_document_type.CT_OnOff,
  uiCompat97To2003 ploffx_document_type.CT_OnOff,
  updateFields ploffx_document_type.CT_OnOff,
  useXSLTWhenSaving ploffx_document_type.CT_OnOff,
  view_ CT_View,
  writeProtection CT_WriteProtection,
  zoom CT_Zoom --Magnification Setting
  );

/******************************************************************/

-- start
procedure start_;
-- end
procedure end_;


-- activeRecord
procedure activeRecord(
  p_tag varchar2 default t_activeRecord,
  p_val varchar2
  );


-- activeWritingStyle
procedure activeWritingStyle(
  p_tag varchar2 default t_activeWritingStyle,
  p_appName varchar2,
  p_checkStyle varchar2,
  p_dllVersion varchar2 default null,
  p_lang varchar2,
  p_nlCheck varchar2 default null,
  p_vendorID varchar2
  );


-- addressFieldName
procedure addressFieldName(
  p_tag varchar2 default t_addressFieldName,
  p_val varchar2
  );



-- alignBordersAndEdges
procedure alignBorderAndEdges(
  p_tag varchar2 default t_alignBordersAndEdges,
  p_val varchar2 default null
  );


-- alwaysMergeEmptyNamespace
procedure alwaysMergeEmptyNamespace(
  p_tag varchar2 default t_alwaysMergeEmptyNamespace,
  p_val varchar2 default null
  );


-- alwaysShowPlaceholderText
procedure alwaysShowPlaceholderText(
  p_tag varchar2 default t_alwaysShowPlaceholderText,
  p_val varchar2 default null
  );


-- attachedSchema
procedure attachedSchema(
  p_tag varchar2 default t_attachedSchema,
  p_val varchar2
  );


-- attachedTemplate
procedure attachedTemplate(
  p_tag varchar2 default t_attachedTemplate,
  p_id varchar2
  );


-- autoCaption
procedure autoCaption(
  p_tag varchar2 default t_autoCaption,
  p_name varchar2,
  p_caption varchar2
  );


-- autoCaptions
procedure startautoCaptions(
  p_tag varchar2 default t_autoCaptions
  );
--
procedure endautoCaptions;


-- autoFormatOverride
procedure autoFormatOverride(
  p_tag varchar2 default t_autoFormatOverride,
  p_val varchar2 default null
  );


-- autoHyphenation
procedure autoHyphenation(
  p_tag varchar2 default t_autoHyphenation,
  p_val varchar2 default null
  );


-- bookFoldPrinting
procedure bookFoldPrinting(
  p_tag varchar2 default t_bookFoldPrinting,
  p_val varchar2 default null
  );


-- bookFoldPrintingSheets
procedure bookFoldPrintingSheets(
  p_tag varchar2 default t_bookFoldPrintingSheets,
  p_val varchar2 default null
  );


-- bookFoldRevPrinting
procedure bookFoldRevPrinting(
  p_tag varchar2 default t_bookFoldRevPrinting,
  p_val varchar2 default null
  );


-- bordersDoNotSurroundFooter
procedure bordersDoNotSurroundFooter(
  p_tag varchar2 default t_bordersDoNotSurroundFooter,
  p_val varchar2 default null
  );


-- bordersDoNotSurroundHeader
procedure bordersDoNotSurroundHeader(
  p_tag varchar2 default t_bordersDoNotSurroundHeader,
  p_val varchar2 default null
  );

-- brkBin
procedure brkBin(
  p_tag varchar2 default t_brkBin,
  p_val varchar2 default null
  );

-- brkBinSub
procedure brkBinSub(
  p_tag varchar2 default t_brkBinSub,
  p_val varchar2 default null
  );


-- caption
procedure caption(
  p_tag varchar2 default t_caption,
  p_name varchar2,
  p_pos varchar2 default null,
  p_chapNum varchar2 default null,
  p_heading varchar2 default null,
  p_noLabel varchar2 default null,
  p_numFmt varchar2 default null,
  p_sep varchar2 default null
  );


-- captions
procedure startcaptions(
  p_tag varchar2 default t_captions
  );
--
procedure endcaptions;


-- characterSpacingControl
procedure characterSpacingControl(
  p_tag varchar2 default t_characterSpacingControl,
  p_val varchar2
  );


-- checkErrors
procedure checkErrors(
  p_tag varchar2 default t_checkErrors,
  p_val varchar2
  );


-- clickAndTypeStyle
procedure clickAndTypeStyle(
  p_tag varchar2 default t_clickAndTypeStyle,
  p_val varchar2
  );

-- clrSchemeMapping
procedure clrSchemeMapping(
  p_tag varchar2 default t_clrSchemeMapping,
  p_accent1 varchar2 default null,
  p_accent2 varchar2 default null,
  p_accent3 varchar2 default null,
  p_accent4 varchar2 default null,
  p_accent5 varchar2 default null,
  p_accent6 varchar2 default null,
  p_bg1 varchar2 default null,
  p_bg2 varchar2 default null,
  p_followedHyperlink varchar2 default null,
  p_hyperlink varchar2 default null,
  p_t1 varchar2 default null,
  p_t2 varchar2 default null
  );


-- colDelim
procedure colDelim(
  p_tag varchar2 default t_colDelim,
  p_val varchar2
  );



-- column
procedure column_(
  p_tag varchar2 default t_column,
  p_val varchar2
  );

-- compat
procedure startcompat(
  p_tag varchar2 default t_compat
  );
--
procedure endcompat;

-- compatSetting
procedure compatSetting(
  p_tag varchar2 default t_compatSetting,
  p_val varchar2,
  p_uri varchar2,
  p_name varchar2
  );


-- connectString
procedure connectString(
  p_tag varchar2 default t_connectString,
  p_val varchar2
  );


-- consecutiveHyphenLimit
procedure consecutiveHyphenLimit(
  p_tag varchar2 default t_consecutiveHyphenLimit,
  p_val varchar2
  );



-- dataSource
procedure dataSource(
  p_tag varchar2 default t_dataSource,
  p_id varchar2
  );


-- dataType
procedure dataType(
  p_tag varchar2 default t_dataType,
  p_val varchar2
  );

-- decimalSymbol
procedure decimalSymbol(
  p_tag varchar2 default t_decimalSymbol,
  p_val varchar2
  );


-- defaultTableStyle
procedure defaultTableStyle(
  p_tag varchar2 default t_defaultTableStyle,
  p_val varchar2
  );

-- defaultTabStop
procedure defaultTabStop(
  p_tag varchar2 default t_defaultTabStop,
  p_val varchar2
  );

-- defJc
procedure defJc(
  p_tag varchar2 default t_defJc,
  p_val varchar2 default null
  );


-- destination
procedure destination(
  p_tag varchar2 default t_destination,
  p_val varchar2
  );

-- dispDef
procedure dispDef(
  p_tag varchar2 default t_dispDef,
  p_val varchar2 default null
  );


-- displayBackgroundShape
procedure displayBackgroundShape(
  p_tag varchar2 default t_displayBackgroundShape,
  p_val varchar2 default null
  );


-- displayHorizontalDrawingGridEvery
procedure dispHorizDrawingGridEvery(
  p_tag varchar2 default t_dispHorizDrawingGridEvery,
  p_val varchar2
  );


-- dispVerticDrawingGridEvery
procedure dispVerticDrawingGridEvery(
  p_tag varchar2 default t_dispVerticDrawingGridEvery,
  p_val varchar2
  );


-- documentProtection
procedure documentProtection(
  p_tag varchar2 default t_documentProtection,
  p_algIdExt varchar2,
  p_algIdSource varchar2,
  p_cryptAlogrithmClass varchar2,
  p_cryptAlgorithmSid varchar2,
  p_cryptAlgorithmType varchar2,
  p_cryptProvider varchar2,
  p_cryptProviderType varchar2,
  p_cryptProviderTypeExt varchar2,
  p_cryptProviderTypeExtSource varchar2,
  p_cryptSpinCount varchar2,
  p_edit varchar2,
  p_enforcement varchar2,
  p_formatting varchar2,
  p_hash varchar2,
  p_salt varchar2
  );


-- documentType
procedure documentType(
  p_tag varchar2 default t_documentType,
  p_val varchar2
  );


-- docVar
procedure docVar(
  p_tag varchar2 default t_docVar,
  p_name varchar2,
  p_val varchar2
  );


-- docVars
procedure startdocVars(
  p_tag varchar2 default t_docVars
  );
--
procedure enddocVars;


-- doNotAutoCompressPictures
procedure donotAutoCompressPictures(
  p_tag varchar2 default t_doNotAutoCompressPictures,
  p_val varchar2 default null
  );


-- doNotDemarcateInvalidXml
procedure doNotDemarcateInvalidXml(
  p_tag varchar2 default t_doNotDemarcateInvalidXml,
  p_val varchar2 default null
  );


-- doNotDisplayPageBoundaries
procedure doNotDisplayPageBoundaries(
  p_tag varchar2 default t_doNotDisplayPageBoundaries,
  p_val varchar2 default null
  );


-- doNotEmbedSmartTags
procedure doNotEmbedSmartTags(
  p_tag varchar2 default t_doNotEmbedSmartTags,
  p_val varchar2 default null
  );


-- doNotHyphenateCaps
procedure doNotHyphenateCaps(
  p_tag varchar2 default t_doNotHyphenateCaps,
  p_val varchar2 default null
  );


-- doNotIncludeSubdocsInStats
procedure doNotIncludeSubdocsInStats(
  p_tag varchar2 default t_doNotIncludeSubdocsInStats,
  p_val varchar2 default null
  );


-- doNotShadeFormData
procedure doNotShadeFormData(
  p_tag varchar2 default t_doNotShadeFormData,
  p_val varchar2 default null
  );


-- doNotSuppressBlankLines
procedure doNotSuppressBlankLines(
  p_tag varchar2 default t_doNotSuppressBlankLines,
  p_val varchar2 default null
  );


-- doNotTrackFormatting
procedure doNotTrackFormatting(
  p_tag varchar2 default t_doNotTrackFormatting,
  p_val varchar2 default null
  );


-- doNotTrackMoves
procedure doNotTrackMoves(
  p_tag varchar2 default t_doNotTrackMoves,
  p_val varchar2 default null
  );


-- doNotUseMargForDrawGridOrig
procedure doNotUseMargForDrawGridOrig(
  p_tag varchar2 default t_doNotUseMargForDrawGridOrig,
  p_val varchar2 default null
  );


-- doNotValidateAgainstSchema
procedure doNotValidateAgainstSchema(
  p_tag varchar2 default t_doNotValidateAgainstSchema,
  p_val varchar2 default null
  );


-- drawingGridHorizontalOrigin
procedure drawingGridHorizontalOrigin(
  p_tag varchar2 default t_drawingGridHorizontalOrigin,
  p_val varchar2
  );


-- drawingGridHorizontalSpacing
procedure drawingGridHorizontalSpacing(
  p_tag varchar2 default t_drawingGridHorizontalSpacing,
  p_val varchar2
  );


-- drawingGridVerticalOrigin
procedure drawingGridVerticalOrigin(
  p_tag varchar2 default t_drawingGridVerticalOrigin,
  p_val varchar2
  );


-- drawingGridVerticalSpacing
procedure drawingGridVerticalSpacing(
  p_tag varchar2 default t_drawingGridVerticalSpacing,
  p_val varchar2
  );

--v1.3.0
-- dynamicAddress
procedure dynamicAddress(
  p_tag varchar2 default t_dynamicAddress,
  p_val varchar2
  );


-- embedSystemFonts
procedure embedSystemFonts(
  p_tag varchar2 default t_embedSystemFonts,
  p_val varchar2 default null
  );


-- embedTrueTypeFonts
procedure embedTrueTypeFonts(
  p_tag varchar2 default t_embedTrueTypeFonts,
  p_val varchar2 default null
  );


-- endnote
procedure endnote(
  p_tag varchar2 default t_endnote,
  p_id varchar2
  );


-- endnotePr
procedure startendnotePr(
  p_tag varchar2 default t_endnotePr
  );
--
procedure endendnotePr;


-- evenAndOddHeaders
procedure evenAndOddHeaders(
  p_tag varchar2 default t_evenAndOddHeaders,
  p_val varchar2 default null
  );


-- fHdr
procedure fHdr(
  p_tag varchar2 default t_fHdr,
  p_val varchar2 default null
  );


-- fieldMapData
procedure startfieldMapData(
  p_tag varchar2 default t_fieldMapData
  );
--
procedure endfieldMapData;


-- footnotePr
procedure startfootnotePr(
  p_tag varchar2 default t_footnotePr
  );
--
procedure endfootnotePr;


-- forceUpgrade
procedure forceUpgrade(
  p_tag varchar2 default t_forceUpgrade,
  p_val varchar2 default null
  );


-- formsDesign
procedure formsDesign(
  p_tag varchar2 default t_formsDesign,
  p_val varchar2 default null
  );


-- gutterAtTop
procedure gutterAtTop(
  p_tag varchar2 default t_gutterAtTop,
  p_val varchar2 default null
  );


-- headerSource
procedure headerSource(
  p_tag varchar2 default t_headerSource,
  p_id varchar2
  );



-- hideGrammaticalErrors
procedure hideGrammaticalErrors(
  p_tag varchar2 default t_hideGrammaticalErrors,
  p_val varchar2 default null
  );


-- hideSpellingErrors
procedure hideSpellingErrors(
  p_tag varchar2 default t_hideSpellingErrors,
  p_val varchar2 default null
  );


-- hyphenationZone
procedure hyphenationZone(
  p_tag varchar2 default t_hyphenationZone,
  p_val varchar2
  );

-- idmap
procedure idmap(
  p_tag varchar2 default t_idmap,
  p_data varchar2 default null,
  p_ext varchar2 default null
  );


-- ignoreMixedContent
procedure ignoreMixedContent(
  p_tag varchar2 default t_ignoreMixedContent,
  p_val varchar2 default null
  );


-- interSp
procedure interSp(
  p_tag varchar2 default t_interSp,
  p_val varchar2
  );


-- intraSp
procedure intraSp(
  p_tag varchar2 default t_intraSp,
  p_val varchar2
  );


-- lid
procedure lid(
  p_tag varchar2 default t_lid,
  p_val varchar2
  );


-- name
procedure name_(
  p_tag varchar2 default t_name,
  p_val varchar2
  );


-- mappedName
procedure mappedName(
  p_tag varchar2 default t_mappedName,
  p_val varchar2
  );


-- postSp
procedure postSp(
  p_tag varchar2 default t_postSp,
  p_val varchar2
  );


-- preSp
procedure preSp(
  p_tag varchar2 default t_preSp,
  p_val varchar2
  );


-- wrapRight
procedure wrapRight(
  p_tag varchar2 default t_wrapRight,
  p_val varchar2 default null
  );

-- intLim
procedure intLim(
  p_tag varchar2 default t_intLim,
  p_val varchar2
  );


-- linkStyles
procedure linkStyles(
  p_tag varchar2 default t_linkStyles,
  p_val varchar2 default null
  );


-- linkToQuery
procedure linkToQuery(
  p_tag varchar2 default t_linkToQuery,
  p_val varchar2 default null
  );

-- listSeparator
procedure listSeparator(
  p_tag varchar2 default t_listSeparator,
  p_val varchar2
  );

-- lMargin
procedure lMargin(
  p_tag varchar2 default t_lMargin,
  p_val varchar2 default null
  );


-- mailAsAttachment
procedure mailAsAttachment(
  p_tag varchar2 default t_mailAsAttachment,
  p_val varchar2 default null
  );



-- mailMerge
procedure startmailMerge(
  p_tag varchar2 default t_mailMerge
  );
--
procedure endmailMerge;


-- mailSubject
procedure mailSubject(
  p_tag varchar2 default t_mailSubject,
  p_val varchar2
  );


-- mainDocumentType
procedure mainDocumentType(
  p_tag varchar2 default t_mainDocumentType,
  p_val varchar2
  );

-- mathFont
procedure mathFont(
  p_tag varchar2 default t_mathFont,
  p_val varchar2 default null
  );

-- mathPr
procedure startmathPr(
  p_tag varchar2 default t_mathPr
  );
--
procedure endmathPr;


-- mirrorMargins
procedure mirrorMargins(
  p_tag varchar2 default t_mirrorMargins,
  p_val varchar2 default null
  );

-- naryLim
procedure naryLim(
  p_tag varchar2 default t_naryLim,
  p_val varchar2
  );


-- noLineBreaksAfter
procedure noLineBreaksAfter(
  p_tag varchar2 default t_noLineBreaksAfter,
  p_lang varchar2,
  p_val varchar2
  );


-- noLineBreaksBefore
procedure noLineBreaksBefore(
  p_tag varchar2 default t_noLineBreaksBefore,
  p_lang varchar2,
  p_val varchar2
  );


-- noPunctuationKerning
procedure noPunctuationKerning(
  p_tag varchar2 default t_noPunctuationKerning,
  p_val varchar2
  );


-- numRestart
procedure numRestart(
  p_tag varchar2 default t_numRestart,
  p_val varchar2
  );


-- numStart
procedure numStart(
  p_tag varchar2 default t_numStart,
  p_val varchar2
  );


-- odso
procedure startodso(
  p_tag varchar2 default t_odso
  );
--
procedure endodso;


-- query
procedure query(
  p_tag varchar2 default t_query,
  p_val varchar2
  );


-- pos
procedure pos(
  p_tag varchar2 default t_pos,
  p_val varchar2
  );


-- printFormsData
procedure printFormsData(
  p_tag varchar2 default t_printFormsData,
  p_val varchar2
  );


-- printFractionalCharacterWidth
procedure printFractionalCharWidth(
  p_tag varchar2 default t_printFractionalCharWidth,
  p_val varchar2
  );


-- printPostScriptOverText
procedure printPostScriptOverText(
  p_tag varchar2 default t_printPostScriptOverText,
  p_val varchar2
  );


-- printTwoOnOne
procedure printTwoOnOne(
  p_tag varchar2 default t_printTwoOnOne,
  p_val varchar2 default null
  );


-- proofState
procedure proofState(
  p_tag varchar2 default t_proofState,
  p_spelling varchar2 default null,
  p_grammar varchar2 default null
  );


-- readModeInkLockDown
procedure readModeInkLockDown(
  p_tag varchar2 default t_readModeInkLockDown,
  p_actualPg varchar2,
  p_fontSz varchar2,
  p_h varchar2,
  p_w varchar2
  );


-- recipientData
procedure recipientData(
  p_tag varchar2 default t_recipientData,
  p_id varchar2
  );


-- removeDateAndTime
procedure removeDateAndTime(
  p_tag varchar2 default t_removeDateAndTime,
  p_val varchar2 default null
  );


-- removePersonalInformation
procedure removePersonalInformation(
  p_tag varchar2 default t_removePersonalInformation,
  p_val varchar2 default null
  );


-- revisionView
procedure revisionView(
  p_tag varchar2 default t_revisionView,
  p_comments varchar2 default null,
  p_formatting varchar2 default null,
  p_inkAnnotations varchar2 default null,
  p_insDel varchar2 default null,
  p_markup varchar2 default null
  );

-- rMargin
procedure rMargin(
  p_tag varchar2 default t_rMargin,
  p_val varchar2 default null
  );

-- rsid
procedure rsid(
  p_tag varchar2 default t_rsid,
  p_val varchar2
  );

-- rsidRoot
procedure rsidRoot(
  p_tag varchar2 default t_rsidRoot,
  p_val varchar2
  );

-- rsids
procedure startrsids(
  p_tag varchar2 default t_rsids
  );
--
procedure endrsids;


-- saveFormsData
procedure saveFormsData(
  p_tag varchar2 default t_saveFormsData,
  p_val varchar2 default null
  );


-- saveInvalidXml
procedure saveInvalidXml(
  p_tag varchar2 default t_saveInvalidXml,
  p_val varchar2 default null
  );


-- savePreviewPicture
procedure savePreviewPicture(
  p_tag varchar2 default t_savePreviewPicture,
  p_val varchar2 default null
  );


-- saveSubsetFonts
procedure saveSubsetFonts(
  p_tag varchar2 default t_saveSubsetFonts,
  p_val varchar2 default null
  );


-- saveThroughXslt
procedure saveThroughXslt(
  p_tag varchar2 default t_saveThroughXslt,
  p_id varchar2 default null,
  p_solutionID varchar2 default null
  );


-- saveXmlDataOnly
procedure saveXmlDataOnly(
  p_tag varchar2 default t_saveXmlDataOnly,
  p_val varchar2 default null
  );


-- schema
procedure schema_(
  p_tag varchar2 default t_schema,
  p_manifestLocation varchar2 default null,
  p_schemaLocation varchar2 default null,
  p_uri varchar2 default null
  );


-- schemaLibrary
procedure startschemaLibrary(
  p_tag varchar2 default t_schemaLibrary
  );
--
procedure endschemaLibrary;

-- settings
procedure startsettings(
  p_tag varchar2 default t_settings
  );
--
procedure endsettings;

-- shapeDefaults
procedure startshapeDefaults(
  p_tag varchar2 default t_shapeDefaults
  );
--
procedure endshapeDefaults;

-- o_shapedefaults
procedure o_shapedefaults(
  p_tag varchar2 default t_o_shapedefaults,
  p_allowincell varchar2 default null,
  p_ext varchar2 default null,
  p_fill varchar2 default null,
  p_fillcolor varchar2 default null,
  p_spidmax varchar2 default null,
  p_stroke varchar2 default null,
  p_strokecolor varchar2 default null,
  p_stlye varchar2 default null
  );

-- shapelayout
procedure startshapelayout(
  p_tag varchar2 default t_shapelayout,
  p_ext varchar2 default null
  );
--
procedure endshapelayout;


-- showEnvelope
procedure showEnvelope(
  p_tag varchar2 default t_showEnvelope,
  p_val varchar2 default null
  );


-- showXMLTags
procedure showXMLTags(
  p_tag varchar2 default t_showXMLTags,
  p_val varchar2 default null
  );


-- smartTagType
procedure smartTagType(
  p_tag varchar2 default t_smartTagType,
  p_name varchar2 default null,
  p_namespaceuri varchar2 default null,
  p_url varchar2 default null
  );


-- src
procedure src(
  p_tag varchar2 default t_src,
  p_id varchar2
  );


-- strictFirstAndLastChars
procedure strictFirstAndLastChars(
  p_tag varchar2 default t_strictFirstAndLastChars,
  p_val varchar2 default null
  );


-- styleLockQFSet
procedure styleLockQFSet(
  p_tag varchar2 default t_styleLockQFSet,
  p_val varchar2 default null
  );

-- smallFrac
procedure smallFrac(
  p_tag varchar2 default t_smallFrac,
  p_val varchar2 default null
  );


-- styleLockTheme
procedure styleLockTheme(
  p_tag varchar2 default t_styleLockTheme,
  p_val varchar2 default null
  );


-- stylePaneFormatFilter
procedure stylePaneFormatFilter(
  p_tag varchar2 default t_stylePaneFormatFilter,
  p_val varchar2 default null
  );


-- stylePaneShortMethod
procedure stylePaneShortMethod(
  p_tag varchar2 default t_stylePaneShortMethod,
  p_val varchar2 default null
  );


-- summaryLength
procedure summaryLength(
  p_tag varchar2 default t_summaryLength,
  p_val varchar2 default null
  );


-- table
procedure table_(
  p_tag varchar2 default t_table,
  p_val varchar2
  );

-- themeFontLang
procedure themeFontLang(
  p_tag varchar2 default t_themeFontLang,
  p_val varchar2 default null,
  p_eastAsia varchar2 default null,
  p_bidi varchar2 default null
  );


-- trackRevisions
procedure trackRevisions(
  p_tag varchar2 default t_trackRevisions,
  p_val varchar2 default null
  );


-- type
procedure type_(
  p_tag varchar2 default t_type,
  p_val varchar2
  );


-- udl
procedure udl(
  p_tag varchar2 default t_udl,
  p_val varchar2
  );


-- uiCompat97To2003
procedure uiCompat97To2003(
  p_tag varchar2 default t_uiCompat97To2003,
  p_val varchar2 default null
  );


-- updateFields
procedure updateFields(
  p_tag varchar2 default t_updateFields,
  p_val varchar2 default null
  );


-- useXSLTWhenSaving
procedure useXSLTWhenSaving(
  p_tag varchar2 default t_useXSLTWhenSaving,
  p_val varchar2 default null
  );


-- view
procedure view_(
  p_tag varchar2 default t_view,
  p_val varchar2
  );


-- viewMergedData
procedure viewMergedData(
  p_tag varchar2 default t_viewMergedData,
  p_val varchar2
  );

-- wrapIndent
procedure wrapIndent(
  p_tag varchar2 default t_wrapIndent,
  p_val varchar2
  );


-- writeProtection
procedure writeProtections(
  p_tag varchar2 default t_writeProtection,
  p_algIdExt varchar2 default null,
  p_algIdExtSource varchar2 default null,
  p_cryptAlgorithmClass varchar2 default null,
  p_cryptAlgorithmSid varchar2 default null,
  p_cryptAlgorithmType varchar2 default null,
  p_cryptProvider varchar2 default null,
  p_cryptProviderType varchar2 default null,
  p_cryptProviderTypeExt varchar2 default null,
  p_cryptProviderTypeExtSource varchar2,
  p_cryptSpinCount varchar2 default null,
  p_hash varchar2 default null,
  p_recommended varchar2 default null,
  p_salt varchar2 default null
  );

-- zoom
procedure zoom(
  p_tag varchar2 default t_zoom,
  p_val varchar2 default null,
  p_percent varchar2
  );


/************************************************************/
-- Create structure

---------------------------------------------
--zoom CT_Zoom

function cr_zoom(
  p_tag varchar2 default t_zoom,
  p_val varchar2 default null,
  p_percent varchar2 default null
  ) return CT_Zoom;

---------------------------------------------
--activeWritingStyle CT_WritingStyle

function cr_activeWritingStyle(
  p_tag varchar2 default t_activeWritingStyle,
  p_appName varchar2,
  p_checkStyle varchar2,
  p_dllVersion varchar2,
  p_lang varchar2,
  p_nlCheck varchar2,
  p_vendorID varchar2
  ) return CT_WritingStyle;

---------------------------------------------
--alignBordersAndEdges CT_OnOff

function cr_alignBordersAndEdges(
  p_tag varchar2 default t_alignBordersAndEdges,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--alwaysMergeEmptyNamespace CT_OnOff

function cr_alwaysMergeEmptyNamespace(
  p_tag varchar2 default t_alwaysMergeEmptyNamespace,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--alwaysShowPlaceHolderText CT_OnOff

function cr_alwaysShowPlaceHolderText(
  p_tag varchar2 default t_alwaysShowPlaceholderText,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--attachedSchema CT_String

function cr_attachedSchema(
  p_tag varchar2 default t_attachedSchema,
  p_val varchar2
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--attachedTemplate CT_Rel

function cr_attachedTemplate(
  p_tag varchar2 default t_attachedTemplate,
  p_id varchar2
  ) return ploffx_document_type.CT_Rel;

---------------------------------------------
--autoFormatOverride CT_OnOff

function cr_autoFormatOverride(
  p_tag varchar2 default t_autoFormatOverride,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--autoHyphenation CT_OnOff

function cr_autoHyphenation(
  p_tag varchar2 default t_autoHyphenation,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--bookFoldPrinting CT_OnOff

function cr_bookFoldPrinting(
  p_tag varchar2 default t_bookFoldPrinting,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--bookFoldPrintingSheets CT_DecimalNumber

function cr_bookFoldPrintingSheets(
  p_tag varchar2 default t_bookFoldPrintingSheets,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--bookFoldRevPrinting CT_OnOff

function cr_bookFoldRevPrinting(
  p_tag varchar2 default t_bookFoldRevPrinting,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--bordersDoNotSurroundFooter CT_OnOff

function cr_bordersDoNotSurroundFooter(
  p_tag varchar2 default t_bordersDoNotSurroundFooter,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--bordersDoNotSurroundHeader CT_OnOff

function cr_bordersDoNotSurroundHeader(
  p_tag varchar2 default t_bordersDoNotSurroundHeader,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--caption CT_Caption

function cr_caption(
  p_tag varchar2 default t_caption,
  p_name plx_sc.normalv2,
  p_pos ST_CaptionPos,
  p_chapNum plx_sc.normalv2,
  p_heading plx_sc.normalv2,
  p_noLabel plx_sc.normalv2,
  p_numFmt plx_sc.normalv2,
  p_sep ST_ChapterSep
  ) return CT_Caption;

---------------------------------------------
--autoCaption CT_AutoCaption

function cr_autoCaption(
  p_tag varchar2 default t_autoCaption,
  p_name plx_sc.normalv2,
  p_caption plx_sc.normalv2
  ) return CT_AutoCaption;

---------------------------------------------
--autoCaptions CT_AutoCaptions

function cr_autoCaptions(
  p_tag varchar2 default t_autoCaptions,
  p_autoCaption t_autoCaption_
  ) return CT_AutoCaptions;

---------------------------------------------
--captions CT_Captions

function cr_captions(
  p_tag varchar2 default t_captions,
  p_caption t_caption_,
  p_autCaptions CT_AutoCaptions
  ) return CT_Captions;

---------------------------------------------
--characterSpacingControl CT_CharacterSpacing

function cr_characterSpacingControl(
  p_tag varchar2 default t_characterSpacingControl,
  p_val varchar2
  ) return CT_CharacterSpacing;

---------------------------------------------
--clickAndTypeStyle CT_OnOff

function cr_clickAndTypeStyle(
  p_tag varchar2 default t_clickAndTypeStyle,
  p_val varchar2
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--clrSchemeMapping CT_ColorSchemeMapping

function cr_clrSchemeMapping(
  p_tag varchar2 default t_clrSchemeMapping,
  p_accent1 ST_ColorSchemeIndex default null,
  p_accent2 ST_ColorSchemeIndex default null,
  p_accent3 ST_ColorSchemeIndex default null,
  p_accent4 ST_ColorSchemeIndex default null,
  p_accent5 ST_ColorSchemeIndex default null,
  p_accent6 ST_ColorSchemeIndex default null,
  p_bg1 ST_ColorSchemeIndex default null,
  p_bg2 ST_ColorSchemeIndex default null,
  p_followedHyperlink ST_ColorSchemeIndex default null,
  p_hyperlink ST_ColorSchemeIndex default null,
  p_t1 ST_ColorSchemeIndex default null,
  p_t2 ST_ColorSchemeIndex default null
  ) return CT_ColorSchemeMapping;

---------------------------------------------
--compatSetting CT_CompatSetting

function cr_compatSetting(
  p_tag varchar2 default t_compatSetting,
  p_val plx_sc.normalv2 default null,
  p_uri plx_sc.normalv2 default null,
  p_name plx_sc.normalv2 default null
  ) return CT_CompatSetting;

---------------------------------------------
--compat CT_Compat

function cr_compat(
  p_tag varchar2 default t_compat,
  p_compatSetting t_compatSetting_
  ) return CT_Compat;

---------------------------------------------
--consecutiveHyphenLimit CT_DecimalNumber

function cr_consecutiveHyphenLimit(
  p_tag varchar2 default t_consecutiveHyphenLimit,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--defaultTableStyle CT_String

function cr_defaultTableStyle(
  p_tag varchar2 default t_defaultTableStyle,
  p_val varchar2
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--defaultTabStop CT_DecimalNumber : CT_TwipsMeasure

function cr_defaultTabStop(
  p_tag varchar2 default t_defaultTabStop,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--displayBackgorundShape CT_OnOff

function cr_displayBackgorundShape(
  p_tag varchar2 default t_displayBackgroundShape,
  p_val varchar2
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--dispHorizDrawingGridEvery CT_DecimalNumber

function cr_dispHorizDrawingGridEvery(
  p_tag varchar2 default t_dispHorizDrawingGridEvery,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--dispVerticDrawingGridEvery CT_DecimalNumber

function cr_dispVerticDrawingGridEvery(
  p_tag varchar2 default t_dispVerticDrawingGridEvery,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--documentProtection CT_DocProtect

function cr_documentProtection(
  p_tag varchar2 default t_documentProtection,
  p_algIdExt plx_sc.normalv2 default null,
  p_algIdSource plx_sc.normalv2 default null,
  p_cryptAlogrithmClass plx_sc.normalv2 default null,
  p_cryptAlgorithmSid plx_sc.normalv2 default null,
  p_cryptAlgorithmType plx_sc.normalv2 default null,
  p_cryptProvider plx_sc.normalv2 default null,
  p_cryptProviderType plx_sc.normalv2 default null,
  p_cryptProviderTypeExt plx_sc.normalv2 default null,
  p_cryptProviderTypeExtSource plx_sc.normalv2 default null,
  p_cryptSpinCount plx_sc.normalv2 default null,
  p_edit plx_sc.normalv2 default null,
  p_enforcement plx_sc.normalv2 default null,
  p_formatting plx_sc.normalv2 default null,
  p_hash_ plx_sc.normalv2 default null,
  p_salt plx_sc.normalv2 default null
  ) return CT_DocProtect;


---------------------------------------------
--documentType CT_DocType

function cr_documentType(
  p_tag varchar2 default t_documentType,
  p_val varchar2
  ) return CT_DocType;

---------------------------------------------
--docVar CT_DocVar

function cr_docVar(
  p_tag varchar2 default t_docVar,
  p_name plx_sc.normalv2,
  p_val plx_sc.normalv2
  ) return CT_DocVar;

---------------------------------------------
--docVars CT_DocVars

function cr_docVars(
  p_tag varchar2 default t_docVars,
  p_docVar t_docVars_
  ) return CT_DocVars;

---------------------------------------------
--doNotAutoCompressPictures CT_OnOff

function cr_doNotAutoCompressPictures(
  p_tag varchar2 default t_doNotAutoCompressPictures,
  p_val varchar2
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotDemarcateInvalidXml CT_OnOff

function cr_doNotDemarcateInvalidXml(
  p_tag varchar2 default t_doNotDemarcateInvalidXml,
  p_val varchar2
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotDisplayPageBoundaries CT_OnOff

function cr_doNotDisplayPageBoundaries(
  p_tag varchar2 default t_doNotDisplayPageBoundaries,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotEmbedSmartTags CT_OnOff

function cr_doNotEmbedSmartTags(
  p_tag varchar2 default t_doNotEmbedSmartTags,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotHyphenateCaps CT_OnOff

function cr_doNotHyphenateCaps(
  p_tag varchar2 default t_doNotHyphenateCaps,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotIncludeSubdocsInStats CT_OnOff

function cr_doNotIncludeSubdocsInStats(
  p_tag varchar2 default t_doNotIncludeSubdocsInStats,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotShadeFormData CT_OnOff

function cr_doNotShadeFormData(
  p_tag varchar2 default t_doNotShadeFormData,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotTrackFormatting CT_OnOff

function cr_doNotTrackFormatting(
  p_tag varchar2 default t_doNotTrackFormatting,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotTrackMoves CT_OnOff

function cr_doNotTrackMoves(
  p_tag varchar2 default t_doNotTrackMoves,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotUseMargForDrawGridOrig CT_OnOff

function cr_doNotUseMargForDrawGridOrig(
  p_tag varchar2 default t_doNotUseMargForDrawGridOrig,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--doNotValidateAgainstSchema CT_OnOff

function cr_doNotValidateAgainstSchema(
  p_tag varchar2 default t_doNotValidateAgainstSchema,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--drawingGridhorizontalOrigin CT_DecimalNumber : CT_TwipsMeasure

function cr_drawingGridhorizontalOrigin(
  p_tag varchar2 default t_drawingGridHorizontalOrigin,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--drawingGridhorizontalSpacing CT_DecimalNumber : CT_TwipsMeasure

function cr_drawGridHorizontalSpacing(
  p_tag varchar2 default t_drawingGridHorizontalSpacing,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--drawingGridVerticalOrigin CT_DecimalNumber : CT_TwipsMeasure

function cr_drawingGridVerticalOrigin(
  p_tag varchar2 default t_drawingGridVerticalOrigin,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--drawingGridVerticalSpacing CT_DecimalNumber : CT_TwipsMeasure

function cr_drawingGridVerticalSpacing(
  p_tag varchar2 default t_drawingGridVerticalSpacing,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--embedSystemFonts CT_OnOff

function cr_embedSystemFonts(
  p_tag varchar2 default t_embedSystemFonts,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--embedTrueTypeFonts CT_OnOff

function cr_embedTrueTypeFonts(
  p_tag varchar2 default t_embedTrueTypeFonts,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--endnote CT_OnOff

function cr_endnote(
  p_tag varchar2 default t_endnote,
  p_id varchar2 default null
  ) return CT_FtnEdnSepRef;

---------------------------------------------
--numStart CT_DecimalNumber

function cr_numStart(
  p_tag varchar2 default t_numStart,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--numRestart CT_NumRestart

function cr_numRestart(
  p_tag varchar2 default t_numRestart,
  p_val varchar2 default null
  ) return CT_RestartNumber;

---------------------------------------------
--pos CT_EdnPos

function cr_pos(
  p_tag varchar2 default t_pos,
  p_val varchar2 default null
  ) return CT_EdnPos;

---------------------------------------------
--endnotePr CT_EdnDocProps

function cr_endnotePr(
  p_tag varchar2 default t_endnotePr,
  p_endnote t_endnote_ default null ,
  p_numFmt ploffx_numbering.CT_NumFmt default null,
  p_numRestart CT_RestartNumber default null,
  p_numStart ploffx_document_type.CT_DecimalNumber default null,
  p_pos CT_EdnPos default null
  ) return CT_EdnDocProps;

---------------------------------------------
--evenAndOddHeaders CT_OnOff

function cr_evenAndOddHeaders(
  p_tag varchar2 default t_evenAndOddHeaders,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--footnote CT_FtnEdnSepRef

function cr_footnote(
  p_tag varchar2 default t_footnote,
  p_id varchar2 default null
  ) return CT_FtnEdnSepRef;

---------------------------------------------
--footnotePr CT_FtnDocProps

function cr_footnotePr(
  p_tag varchar2 default t_footnotePr,
  p_footnote t_footnote_ default null ,
  p_numFmt ploffx_numbering.CT_NumFmt default null,
  p_numRestart CT_RestartNumber default null,
  p_numStart ploffx_document_type.CT_DecimalNumber default null,
  p_pos CT_EdnPos default null
  ) return CT_FtnDocProps;

---------------------------------------------
--forceUpgrade CT_Empty

function cr_forceUpgrade(
  p_tag varchar2 default t_forceUpgrade,
  p_val varchar2 default null
  ) return CT_Empty;

---------------------------------------------
--formsDesign CT_OnOff

function cr_formsDesign(
  p_tag varchar2 default t_formsDesign,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--gutterAtTop CT_OnOff

function cr_gutterAtTop(
  p_tag varchar2 default t_gutterAtTop,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--hideGrammaticalErrors CT_OnOff

function cr_hideGrammaticalErrors(
  p_tag varchar2 default t_hideGrammaticalErrors,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--hideSpellingErrors CT_OnOff

function cr_hideSpellingErrors(
  p_tag varchar2 default t_hideSpellingErrors,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--hyphenationZone CT_DecimalNumber : CT_TwipsMeasure

function cr_hyphenationZone(
  p_tag varchar2 default t_hyphenationZone,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--ignoreMixedContent CT_OnOff

function cr_ignoreMixedContent(
  p_tag varchar2 default t_ignoreMixedContent,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--linkStyles CT_OnOff

function cr_linkStyles(
  p_tag varchar2 default t_linkStyles,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--listSeparator CT_String

function cr_listSeparator(
  p_tag varchar2 default t_listSeparator,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--activeRecord CT_DecimalNumber

function cr_activeRecord(
  p_tag varchar2 default t_activeRecord,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--addressFieldName CT_String

function cr_addressFieldName(
  p_tag varchar2 default t_addressFieldName,
  p_val varchar2
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--checkErrors CT_DecimalNumber

function cr_checkErrors(
  p_tag varchar2 default t_checkErrors,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--connectString CT_String

function cr_connectString(
  p_tag varchar2 default t_connectString,
  p_val varchar2
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--dataSource CT_Rel

function cr_dataSource(
  p_tag varchar2 default t_dataSource,
  p_id varchar2
  ) return ploffx_document_type.CT_Rel;

---------------------------------------------
--dataType CT_MailMergeDataType

function cr_dataType(
  p_tag varchar2 default t_dataType,
  p_val varchar2
  ) return CT_MailMergeDataType;

---------------------------------------------
--destination CT_MailMergeDest

function cr_destination(
  p_tag varchar2 default t_destination,
  p_val varchar2
  ) return CT_MailMergeDest;

---------------------------------------------
--doNotSupressBlankLines CT_OnOff;

function cr_doNotSupressBlankLines(
  p_tag varchar2 default t_doNotSuppressBlankLines,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--headerSource CT_Rel;

function cr_headerSource(
  p_tag varchar2 default t_headerSource,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_Rel;

---------------------------------------------
--linkToQuery CT_OnOff;

function cr_linkToQuery(
  p_tag varchar2 default t_linkToQuery,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--mailAsAttachment CT_OnOff;

function cr_mailAsAttachment(
  p_tag varchar2 default t_mailAsAttachment,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--mailSubject CT_String;

function cr_mailSubject(
  p_tag varchar2 default t_mailSubject,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--mainDocumentType CT_String;

function cr_mainDocumentType(
  p_tag varchar2 default t_mainDocumentType,
  p_val varchar2 default null
  ) return CT_MailMergeDocType;

---------------------------------------------
--colDelim CT_DecimalNumber;

function cr_colDelim(
  p_tag varchar2 default t_colDelim,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--fHdr CT_OnOff;

function cr_fHdr(
  p_tag varchar2 default t_fHdr,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--column CT_DecimalNumber;

function cr_column(
  p_tag varchar2 default t_column,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--dynamicAddress CT_OnOff;

function cr_dynamicAddress(
  p_tag varchar2 default t_dynamicAddress,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--lid CT_Lang;

function cr_lid(
  p_tag varchar2 default t_lid,
  p_val varchar2 default null
  ) return CT_Lang;

---------------------------------------------
--mappedName CT_String;

function cr_mappedName(
  p_tag varchar2 default t_mappedName,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--name CT_String;

function cr_name(
  p_tag varchar2 default t_name,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--type CT_MailMergeOdsoFMDFieldType

function cr_type1(
  p_tag varchar2 default t_type,
  p_val varchar2 default null
  ) return CT_MailMergeOdsoFMDFieldType;

---------------------------------------------
--fieldMapData CT_Odso;

function cr_fieldMapData(
  p_tag varchar2 default t_fieldMapData,
  p_column ploffx_document_type.CT_DecimalNumber,
  p_dynamicAddress ploffx_document_type.CT_OnOff,
  p_lid CT_Lang,
  p_mappedName ploffx_document_type.CT_String,
  p_name_ ploffx_document_type.CT_String,
  p_type_ CT_MailMergeOdsoFMDFieldType
  ) return CT_OdsoFieldMapData;

---------------------------------------------
--recipientData CT_Rel;

function cr_recipientData(
  p_tag varchar2 default t_recipientData,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_Rel;

---------------------------------------------
--src CT_Rel;

function cr_src(
  p_tag varchar2 default t_src,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_Rel;

---------------------------------------------
--table CT_String;

function cr_table(
  p_tag varchar2 default t_table,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--type CT_MailMergeSourceType

function cr_type(
  p_tag varchar2 default t_type,
  p_val varchar2 default null
  ) return CT_MailMergeSourceType;

---------------------------------------------
--udl CT_String;

function cr_udl(
  p_tag varchar2 default t_udl,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--odso CT_Odso;

function cr_odso(
  p_tag varchar2 default t_odso,
  p_colDelim ploffx_document_type.CT_DecimalNumber,
  p_fHdr ploffx_document_type.CT_OnOff,
  p_fieldMapData t_odsoFieldMapData_,
  p_recipientData t_recipientData_,
  p_src ploffx_document_type.CT_Rel,
  p_table_ ploffx_document_type.CT_String,
  p_type_ CT_MailMergeSourceType,
  p_udl ploffx_document_type.CT_String
  ) return CT_Odso;

---------------------------------------------
--query CT_String;

function cr_query(
  p_tag varchar2 default t_query,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--viewMergedData CT_OnOff;

function cr_viewMergedData(
  p_tag varchar2 default t_viewMergedData,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--mailMerge CT_MailMerge

function cr_mailMerge(
  p_tag varchar2 default t_mailMerge,
  p_activeRecord  ploffx_document_type.CT_DecimalNumber default null,
  p_addressFieldName  ploffx_document_type.CT_String default null,
  p_checkErrors  ploffx_document_type.CT_DecimalNumber default null,
  p_connectString ploffx_document_type.CT_String default null,
  p_dataSource ploffx_document_type.CT_Rel default null,
  p_dataType CT_MailMergeDataType default null,
  p_destination CT_MailMergeDest default null,
  p_doNotSupressBlankLines ploffx_document_type.CT_OnOff default null,
  p_headerSource ploffx_document_type.CT_Rel default null,
  p_linkToQuery ploffx_document_type.CT_OnOff default null,
  p_mailAsAttachment ploffx_document_type.CT_OnOff default null,
  p_mailSubject ploffx_document_type.CT_String default null,
  p_mainDocumentType CT_MailMergeDocType default null,
  p_odso CT_Odso default null,
  p_query ploffx_document_type.CT_String default null,
  p_viewMergedData ploffx_document_type.CT_OnOff default null
  ) return CT_MailMerge;

---------------------------------------------
--brkBin CT_BreakBin

function cr_brkBin(
  p_tag varchar2 default t_brkBin,
  p_val varchar2 default null
  ) return CT_BreakBin;

---------------------------------------------
--brkBinSub CT_BreakBinSub

function cr_brkBinSub(
  p_tag varchar2 default t_brkBinSub,
  p_val varchar2 default null
  ) return CT_BreakBinSub;

---------------------------------------------
--defJc CT_OMathJc

function cr_defJc(
  p_tag varchar2 default t_defJc,
  p_val varchar2 default null
  ) return CT_OMathJc;

---------------------------------------------
--dispDef CT_OMathJc

function cr_dispDef(
  p_tag varchar2 default t_dispDef,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--interSP CT_OMathJc

function cr_interSP(
  p_tag varchar2 default t_interSp,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--intLim CT_OMathJc

function cr_intLim(
  p_tag varchar2 default t_intLim,
  p_val varchar2 default null
  ) return CT_LimLoc;

---------------------------------------------
--intraSp CT_DecimalNumber

function cr_intraSp(
  p_tag varchar2 default t_intraSp,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--lMargin CT_DecimalNumber

function cr_lMargin(
  p_tag varchar2 default t_lMargin,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--mathFont CT_String

function cr_mathFont(
  p_tag varchar2 default t_mathFont,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;

---------------------------------------------
--naryLim CT_LimLoc

function cr_naryLim(
  p_tag varchar2 default t_naryLim,
  p_val varchar2 default null
  ) return CT_LimLoc;

---------------------------------------------
--postSp CT_DecimalNumber

function cr_postSp(
  p_tag varchar2 default t_postSp,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--preSp CT_DecimalNumber

function cr_preSp(
  p_tag varchar2 default t_preSp,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--rMargin CT_DecimalNumber

function cr_rMargin(
  p_tag varchar2 default t_rMargin,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--smallFrac CT_OnOff

function cr_smallFrac(
  p_tag varchar2 default t_smallFrac,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--wrapIndent CT_DecimalNumber

function cr_wrapIndent(
  p_tag varchar2 default t_wrapIndent,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--wrapRight CT_OnOff

function cr_wrapRight(
  p_tag varchar2 default t_wrapRight,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--mathPr CT_MathPr

function cr_mathPr(
  p_tag varchar2 default t_mathPr,
  p_brkBin CT_BreakBin,
  p_brkBinSub CT_BreakBinSub,
  p_defJc CT_OMathJc,
  p_dispDef ploffx_document_type.CT_OnOff,
  p_interSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_intLim CT_LimLoc,
  p_intraSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_lMargin ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_mathFont ploffx_document_type.CT_String,
  p_naryLim CT_LimLoc,
  p_postSp ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_preSP ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_rMargin ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_smallFrac ploffx_document_type.CT_OnOff,
  p_wrapIndent ploffx_document_type.CT_DecimalNumber, -- CT_TwipsMeasure
  p_wrapRight ploffx_document_type.CT_OnOff
  ) return CT_MathPr;

---------------------------------------------
--mirrorMargins CT_OnOff

function cr_mirrorMargins(
  p_tag varchar2 default t_mirrorMargins,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--noLineBreaksAfter CT_Kinsoku

function cr_noLineBreaksAfter(
  p_tag varchar2 default t_noLineBreaksAfter,
  p_lang ploffx_document_type.ST_Lang,
  p_val plx_sc.normalv2
  ) return CT_Kinsoku;

---------------------------------------------
--noLineBreaksBefore CT_Kinsoku

function cr_noLineBreaksBefore(
  p_tag varchar2 default t_noLineBreaksBefore,
  p_lang ploffx_document_type.ST_Lang,
  p_val plx_sc.normalv2
  ) return CT_Kinsoku;

---------------------------------------------
--noPunctuationKerning CT_OnOff

function cr_noPunctuationKerning(
  p_tag varchar2 default t_noPunctuationKerning,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--printFormsData CT_OnOff

function cr_printFormsData(
  p_tag varchar2 default t_printFormsData,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--printFractionalCharacterWidth CT_OnOff

function cr_printFractionalCharWidth(
  p_tag varchar2 default t_printFractionalCharWidth,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--printPostScriptOverText CT_OnOff

function cr_printPostScriptOverText(
  p_tag varchar2 default t_printPostScriptOverText,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--printTwoOnOne CT_OnOff

function cr_printTwoOnOne(
  p_tag varchar2 default t_printTwoOnOne,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--proofState CT_Proof

function cr_proofState(
  p_tag varchar2 default t_proofState,
  p_grammar ST_Proof,
  p_spelling ST_Proof
  ) return CT_Proof;

---------------------------------------------
--readModeInkLockDown CT_ReadingModeInkLockDown

function cr_readModeInkLockDown(
   p_tag varchar2 default t_readModeInkLockDown,
   p_actualPg plx_sc.normalv2,
   p_fontSz plx_sc.normalv2,
   p_h plx_sc.normalv2,
   p_w plx_sc.normalv2
  ) return CT_ReadingModeInkLockDown;

---------------------------------------------
--removeDateAndTime CT_OnOff

function cr_removeDateAndTime(
  p_tag varchar2 default t_removeDateAndTime,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--removePersonalInformation CT_OnOff

function cr_removePersonalInformation(
  p_tag varchar2 default t_removePersonalInformation,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--revisionView CT_OnOff

function cr_revisionView(
  p_tag varchar2 default t_revisionView,
  p_comments ploffx_document_type.ST_OnOff default null,
  p_formatting ploffx_document_type.ST_OnOff default null,
  p_inkAnnotations ploffx_document_type.ST_OnOff default null,
  p_insDel ploffx_document_type.ST_OnOff default null,
  p_markup ploffx_document_type.ST_OnOff default null
  ) return CT_TrackChangesView;

---------------------------------------------
--rsidRoot CT_LongHexNumber

function cr_rsidRoot(
  p_tag varchar2 default t_rsidRoot,
  p_val varchar2
  ) return ploffx_document_type.CT_LongHexNumber;

---------------------------------------------
--rsids CT_DocRsids

function cr_rsids(
  p_tag varchar2 default t_rsids,
  p_rsidRoot ploffx_document_type.CT_LongHexNumber default null,
  p_rsid t_rsid_
  ) return CT_DocRsids;

---------------------------------------------
--saveFormsData CT_OnOff

function cr_saveFormsData(
  p_tag varchar2 default t_saveFormsData,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--saveInvalidXml CT_OnOff

function cr_saveInvalidXml(
  p_tag varchar2 default t_saveInvalidXml,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;


---------------------------------------------
--savePreviewPicture CT_OnOff

function cr_savePreviewPicture(
  p_tag varchar2 default t_savePreviewPicture,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--saveSubSetFonts CT_OnOff

function cr_saveSubSetFonts(
  p_tag varchar2 default t_saveSubsetFonts,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--saveThroughXslt CT_OnOff

function cr_saveThroughXslt(
  p_tag varchar2 default t_saveThroughXslt,
  p_id plx_sc.normalv2 default null,
  p_solutionID plx_sc.normalv2 default null
  ) return CT_SaveThroughXslt;

---------------------------------------------
--saveXmlDataOnly CT_OnOff

function cr_saveXmlDataOnly(
  p_tag varchar2 default t_saveXmlDataOnly,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--schema CT_Schema

function cr_schema(
  p_tag varchar2 default t_schema,
  p_manifestLocation plx_sc.normalv2,
  p_schemaLocation plx_sc.normalv2,
  p_uri plx_sc.normalv2
  ) return CT_Schema;

---------------------------------------------
--schemaLibrary CT_SchemaLibrary

function cr_schemaLibrary(
  p_tag varchar2 default t_schemaLibrary,
  p_schema t_schema_
  ) return CT_SchemaLibrary;

---------------------------------------------
--showEnvelope CT_OnOff

function cr_showEnvelope(
  p_tag varchar2 default t_showEnvelope,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--showXMLTags CT_OnOff

function cr_showXMLTags(
  p_tag varchar2 default t_showXMLTags,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--smartTagType CT_OnOff

function cr_smartTagType(
  p_tag varchar2 default t_smartTagType,
  p_name plx_sc.normalv2 default null,
  p_namespaceuri plx_sc.normalv2 default null,
  p_url plx_sc.normalv2 default null
  ) return CT_SmartTagType;

---------------------------------------------
--strictFirstAndLastChars CT_OnOff

function cr_strictFirstAndLastChars(
  p_tag varchar2 default t_strictFirstAndLastChars,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--styleLockQFSet CT_OnOff

function cr_styleLockQFSet(
  p_tag varchar2 default t_styleLockQFSet,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--styleLockTheme CT_OnOff

function cr_styleLockTheme(
  p_tag varchar2 default t_styleLockTheme,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--stylePaneFormatFilter CT_LongHexNumber : ShortHexNumber

function cr_stylePaneFormatFilter(
  p_tag varchar2 default t_stylePaneFormatFilter,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_LongHexNumber;


---------------------------------------------
--stylePaneSortMethod CT_LongHexNumber : ShortHexNumber

function cr_stylePaneShortMethod(
  p_tag varchar2 default t_stylePaneShortMethod,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_LongHexNumber;

---------------------------------------------
--summaryLength CT_DecimalNumber

function cr_summaryLength(
  p_tag varchar2 default t_summaryLength,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;

---------------------------------------------
--themeFontLang CT_Language

function cr_themeFontLang(
  p_tag varchar2 default t_themeFontLang,
  p_val ploffx_document_type.ST_Lang,
  p_eastAsia ploffx_document_type.ST_Lang,
  p_bidi ploffx_document_type.ST_Lang
  ) return ploffx_document_type.CT_Language;

---------------------------------------------
--trackRevisions CT_OnOff

function cr_trackRevisions(
  p_tag varchar2 default t_trackRevisions,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--uiCompat97To2003 CT_OnOff

function cr_uiCompat97To2003(
  p_tag varchar2 default t_uiCompat97To2003,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--updateFields CT_OnOff

function cr_updateFields(
  p_tag varchar2 default t_updateFields,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--useXSLTWhenSaving CT_OnOff

function cr_useXSLTWhenSaving(
  p_tag varchar2 default t_useXSLTWhenSaving,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--view CT_View

function cr_view(
  p_tag varchar2 default t_view,
  p_val varchar2
  ) return CT_View;

---------------------------------------------
--writeProtection CT_WriteProtection

function cr_writeProtection(
  p_tag varchar2 default t_writeProtection,
  p_algIdExt plx_sc.normalv2 default null,
  p_algIdExtSource plx_sc.normalv2 default null,
  p_cryptAlgorithmClass plx_sc.normalv2 default null,
  p_cryptAlgorithmSid plx_sc.normalv2 default null,
  p_cryptAlgorithmType plx_sc.normalv2 default null,
  p_cryptProvider plx_sc.normalv2 default null,
  p_cryptProviderType plx_sc.normalv2 default null,
  p_cryptProviderTypeExt plx_sc.normalv2 default null,
  p_cryptProviderTypeExtSource plx_sc.normalv2 default null,
  p_cryptSpinCount plx_sc.normalv2 default null,
  p_hash_ plx_sc.normalv2 default null,
  p_recommended plx_sc.normalv2 default null,
  p_salt plx_sc.normalv2 default null
  ) return CT_WriteProtection;

---------------------------------------------
--o_shapeDefaults CT_Idmap

function cr_o_shapeDefaults(
  p_tag varchar2 default t_o_shapedefaults,
  p_allowincell plx_sc.normalv2 default null,
  p_ext plx_sc.normalv2 default null,
  p_fill plx_sc.normalv2 default null,
  p_fillcolor plx_sc.normalv2 default null,
  p_spidmax plx_sc.normalv2 default null,
  p_stroke plx_sc.normalv2 default null,
  p_strokecolor plx_sc.normalv2 default null,
  p_stlye plx_sc.normalv2 default null
  ) return CT_O_ShapeDefaults;

---------------------------------------------
--idmap CT_Idmap

function cr_idmap(
  p_tag varchar2 default t_idmap,
  p_data plx_sc.normalv2 default null,
  p_ext plx_sc.normalv2 default null
  ) return CT_Idmap;

---------------------------------------------
--o_shapeDefaults CT_O_ShapeLayout

function cr_o_shapeLayout(
  p_tag varchar2 default t_shapelayout,
  p_ext plx_sc.normalv2 default null,
  p_idmap CT_Idmap
  ) return CT_O_ShapeLayout;

---------------------------------------------
--shapeDefaults CT_ShapeDefaults

function cr_shapeDefaults(
  p_tag varchar2 default t_shapeDefaults,
  p_o_shapedefaults CT_O_ShapeDefaults,
  p_shapeLayout CT_O_ShapeLayout
  ) return CT_ShapeDefaults;

---------------------------------------------
--settings CT_Settings

function cr_settings(
  p_tag varchar2 default t_settings,
  p_activeWritingStyle CT_WritingStyle default null,
  p_alignBorderAndEdges ploffx_document_type.CT_OnOff default null,
  p_alwaysMergeEmptyNamespace ploffx_document_type.CT_OnOff default null,
  p_alwaysShowPlaceholderText ploffx_document_type.CT_OnOff default null,
  p_attachedSchema ploffx_document_type.CT_String default null,
  p_attachedTemplate ploffx_document_type.CT_Rel default null,
  p_autoFormatOverride ploffx_document_type.CT_OnOff default null, ---------------------------------------------
  p_autoHyphenation ploffx_document_type.CT_OnOff default null,
  p_bookFoldPrinting ploffx_document_type.CT_OnOff default null,
  p_bookFoldPrintingSheets ploffx_document_type.CT_DecimalNumber default null,
  p_bookFoldRevPrinting ploffx_document_type.CT_OnOff default null,
  p_bordersDoNotSurroundFooter ploffx_document_type.CT_OnOff default null,
  p_bordersDoNotSurroundHeader ploffx_document_type.CT_OnOff default null,
  p_captions CT_Captions default null,
  p_characterSpacingControl CT_CharacterSpacing default null,
  p_clickAndTypeStyle ploffx_document_type.CT_String default null,
  p_clrSchemeMapping CT_ColorSchemeMapping default null,
  -- TODO compat
  p_consecutiveHyphenLimit ploffx_document_type.CT_DecimalNumber default null,
  p_decimalSymbol ploffx_document_type.CT_String default null,
  p_defaultTableStyle ploffx_document_type.CT_String default null,
  p_defaultTabStop ploffx_document_type.CT_DecimalNumber default null,
  p_displayBackgroundShape ploffx_document_type.CT_OnOff default null,
  p_dispHorizDrawingGridEvery ploffx_document_type.CT_DecimalNumber default null,
  p_dispVerticDrawingGridEvery ploffx_document_type.CT_DecimalNumber default null,
  p_documentProtection CT_DocProtect default null,
  p_documentType CT_DocType default null,
  p_docVars CT_DocVars default null,
  p_donotAutoCompressPictures ploffx_document_type.CT_OnOff default null,
  p_doNotDemarcateInvalidXml ploffx_document_type.CT_OnOff default null,
  p_doNotDisplayPageBoundaries ploffx_document_type.CT_OnOff default null,
  p_doNotEmbedSmartTags ploffx_document_type.CT_OnOff default null,
  p_doNotHyphenateCaps ploffx_document_type.CT_OnOff default null,
  p_doNotIncludeSubdocsInStats ploffx_document_type.CT_OnOff default null,
  p_doNotShadeFormData ploffx_document_type.CT_OnOff default null,
  p_doNotTrackFormatting ploffx_document_type.CT_OnOff default null,
  p_doNotTrackMoves ploffx_document_type.CT_OnOff default null,
  p_doNotUseMargForDrawGridOrig ploffx_document_type.CT_OnOff default null,
  p_doNotValidateAgainstSchema ploffx_document_type.CT_OnOff default null,
  p_drawingGridHorizontalOrigin ploffx_document_type.CT_DecimalNumber default null,
  p_drawingGridHorizontalSpacing ploffx_document_type.CT_DecimalNumber default null,
  p_drawingGridVerticalOrigin ploffx_document_type.CT_DecimalNumber default null,
  p_drawingGridVerticalSpacing ploffx_document_type.CT_DecimalNumber default null,
  p_embedSystemFonts ploffx_document_type.CT_OnOff default null,
  p_embedTrueTypeFonts ploffx_document_type.CT_OnOff default null,
  p_endnotePr CT_EdnDocProps default null,
  p_evenAndOddHeaders ploffx_document_type.CT_OnOff default null,
  p_footnotePr CT_FtnDocProps default null,
  p_forceUpgrade CT_Empty default null,
  p_formsDesign ploffx_document_type.CT_OnOff default null,
  p_gutterAtTop ploffx_document_type.CT_OnOff default null,
  -- TODO hdrShapeDefaults
  p_hideGrammaticalErrors ploffx_document_type.CT_OnOff default null,
  p_hideSpellingErrors ploffx_document_type.CT_OnOff default null,
  p_hyphenationZone ploffx_document_type.CT_DecimalNumber default null,
  p_ignoreMixedContent ploffx_document_type.CT_OnOff default null,
  p_linkStyles ploffx_document_type.CT_OnOff default null,
  p_listSeparator ploffx_document_type.CT_String default null,
  p_mailMerge CT_MailMerge default null,
  p_mathPr CT_MathPr default null,
  p_mirrorMargins ploffx_document_type.CT_OnOff default null,
  p_noLineBreaksAfter CT_Kinsoku default null,
  p_noLineBreaksBefore CT_Kinsoku default null,
  p_noPunctuationKerning ploffx_document_type.CT_OnOff default null,
  p_printFormsData ploffx_document_type.CT_OnOff default null,
  p_printFractionalCharWidth ploffx_document_type.CT_OnOff default null,
  p_printPostScriptOverText ploffx_document_type.CT_OnOff default null,
  p_printTwoOnOne ploffx_document_type.CT_OnOff default null,
  p_proofState CT_Proof default null,
  p_readModeInkLockDown CT_ReadingModeInkLockDown default null,
  p_removeDateAndTime ploffx_document_type.CT_OnOff default null,
  p_removePersonalInformation ploffx_document_type.CT_OnOff default null,
  p_revisionView CT_TrackChangesView default null,
  p_rsids CT_DocRsids default null,
  p_saveFormsData ploffx_document_type.CT_OnOff default null,
  p_saveInvalidXml ploffx_document_type.CT_OnOff default null,
  p_savePreviewPicture ploffx_document_type.CT_OnOff default null,
  p_saveSubsetFonts ploffx_document_type.CT_OnOff default null,
  p_saveThroughXslt CT_SaveThroughXslt default null,
  p_saveXmlDataOnly ploffx_document_type.CT_OnOff default null,
  p_schemaLibrary CT_SchemaLibrary default null,
  p_shapeDefaults CT_ShapeDefaults default null,
  p_showEnvelope ploffx_document_type.CT_OnOff default null,
  p_showXMLTags ploffx_document_type.CT_OnOff default null,
  p_smartTagType CT_SmartTagType default null,
  p_strictFirstAndLastChars ploffx_document_type.CT_OnOff default null,
  p_styleLockQFSet ploffx_document_type.CT_OnOff default null,
  p_styleLockTheme ploffx_document_type.CT_OnOff default null,
  p_stylePaneFormatFilter ploffx_document_type.CT_LongHexNumber default null, -- ShortHexNumber v1.3.0
  p_stylePaneShortMethod ploffx_document_type.CT_LongHexNumber default null, -- ShortHexNumber v1.3.0
  p_summaryLength ploffx_document_type.CT_DecimalNumber default null,
  p_themeFontLang ploffx_document_type.CT_Language default null,
  p_trackRevisions ploffx_document_type.CT_OnOff default null,
  p_uiCompat97To2003 ploffx_document_type.CT_OnOff default null,
  p_updateFields ploffx_document_type.CT_OnOff default null,
  p_useXSLTWhenSaving ploffx_document_type.CT_OnOff default null,
  p_view_ CT_View default null,
  p_writeProtection CT_WriteProtection default null,
  p_zoom CT_Zoom default null --Magnification Setting
  ) return CT_Settings;




/************************************************************/
-- Generate XML parts

---------------------------------------------
--zoom CT_Zoom

procedure gen_zoom(
  p_zoom CT_Zoom
  );

---------------------------------------------
--activeWritingStyle CT_WritingStyle

procedure gen_activeWritingStyle(
  p_activeWritingStyle CT_WritingStyle
  );

---------------------------------------------
--alignBordersAndEdges CT_OnOff

procedure gen_alignBordersAndEdges(
  p_alignBordersAndEdges ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--alwaysMergeEmptyNamespace CT_OnOff

procedure gen_alwaysMergeEmptyNamespace(
  p_alwaysMergeEmptyNamespace ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--alwaysShowPlaceHolderText CT_OnOff

procedure gen_alwaysShowPlaceHolderText(
  p_alwaysShowPlaceHolderText ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--attachedSchema CT_String

procedure gen_attachedSchema(
  p_attachedSchema ploffx_document_type.CT_String
  );

---------------------------------------------
--attachedTemplate CT_Rel

procedure gen_attachedTemplate(
  p_attachedTemplate ploffx_document_type.CT_Rel
  );

---------------------------------------------
--autoFormatOverride CT_OnOff

procedure gen_autoFormatOverride(
  p_autoFormatOverride ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--autoHyphenation CT_OnOff

procedure gen_autoHyphenation(
  p_autoHyphenation ploffx_document_type.CT_OnOff
  );


---------------------------------------------
--bookFoldPrinting CT_OnOff

procedure gen_bookFoldPrinting(
  p_bookFoldPrinting ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--bookFoldPrintingSheets CT_DecimalNumber

procedure gen_bookFoldPrintingSheets(
  p_bookFoldPrintingSheets ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--bookFoldRevPrinting CT_OnOff

procedure gen_bookFoldRevPrinting(
  p_bookFoldRevPrinting ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--bordersDoNotSurroundFooter CT_OnOff

procedure gen_bordersDoNotSurroundFooter(
  p_bordersDoNotSurroundFooter ploffx_document_type.CT_OnOff
  );


---------------------------------------------
--bordersDoNotSurroundHeader CT_OnOff

procedure gen_bordersDoNotSurroundHeader(
  p_bordersDoNotSurroundHeader ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--caption CT_Caption

procedure gen_caption(
  p_caption CT_Caption
  );

--caption:t_caption_
procedure add_Caption(
  p_table in out t_caption_,
  p_caption CT_Caption
  );

---------------------------------------------
--autoCaption CT_AutoCaption

procedure gen_autoCaption(
  p_autoCaption CT_AutoCaption
  );

--autoCaption:t_autoCaption_
procedure add_autoCaption(
  p_table in out t_autoCaption_,
  p_autoCaption CT_AutoCaption
  );

---------------------------------------------
--autoCaptions CT_AutoCaptions

procedure gen_autoCaptions(
  p_autoCaptions CT_AutoCaptions
  );

---------------------------------------------
--captions CT_Captions

procedure gen_captions(
  p_captions CT_Captions
  );

---------------------------------------------
--characterSpacingControl CT_CharacterSpacing

procedure gen_characterSpacingControl(
  p_characterSpacingControl CT_CharacterSpacing
  );

---------------------------------------------
--clickAndTypeStyle CT_OnOff

procedure gen_clickAndTypeStyle(
  p_clickAndTypeStyle ploffx_document_type.CT_String
  );

---------------------------------------------
--clrSchemeMapping CT_ColorSchemeMapping

procedure gen_clrSchemeMapping(
  p_clrSchemeMapping CT_ColorSchemeMapping
  );

---------------------------------------------
--compatSetting CT_CompatSetting

procedure gen_compatSetting(
  p_compatSetting CT_CompatSetting
  );
-- compat: t_compatSetting_
procedure add_compatSetting(
  p_table in out t_compatSetting_,
  p_compatSetting CT_CompatSetting
  );

---------------------------------------------
--compat CT_Compat

procedure gen_compat(
  p_compat CT_Compat
  );

---------------------------------------------
--consecutiveHyphenLimit CT_DecimalNumber

procedure gen_consecutiveHyphenLimit(
  p_consecutiveHyphenLimit ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--decimalSymbol CT_String

procedure gen_decimalSymbol(
  p_decimalSymbol ploffx_document_type.CT_String
  );

---------------------------------------------
--defaultTableStyle CT_String

procedure gen_defaultTableStyle(
  p_defaultTableStyle ploffx_document_type.CT_String
  );


---------------------------------------------
--defaultTabStop CT_DecimalNumber : CT_TwipsMeasure

procedure gen_defaultTabStop(
  p_defaultTabStop ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--displayBackgorundShape CT_OnOff

procedure gen_displayBackgorundShape(
  p_displayBackgorundShape ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--dispHorizDrawingGridEvery CT_DecimalNumber

procedure gen_dispHorizDrawingGridEvery(
  p_dispHorizDrawingGridEvery ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--dispVerticDrawingGridEvery CT_DecimalNumber

procedure gen_dispVerticDrawingGridEvery(
  p_dispVerticDrawingGridEvery ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--documentProtection CT_DocProtect

procedure gen_documentProtection(
  p_documentProtection CT_DocProtect
  );

---------------------------------------------
--documentType CT_DocType

procedure gen_documentType(
  p_documentType CT_DocType
  );

---------------------------------------------
--docVar CT_DocVar

procedure gen_docVar(
  p_docVar CT_DocVar
  );
-- docVar:t_docVar_
procedure add_docVar(
  p_table in out t_docVars_,
  p_docVar CT_DocVar
  );

---------------------------------------------
--docVars CT_DocVars

procedure gen_docVars(
  p_docVars CT_DocVars
  );

---------------------------------------------
--doNotAutoCompressPictures CT_OnOff

procedure gen_doNotAutoCompressPictures(
  p_doNotAutoCompressPictures ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotDemarcateInvalidXml CT_OnOff

procedure gen_doNotDemarcateInvalidXml(
  p_doNotDemarcateInvalidXml ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotDemarcateInvalidXml CT_OnOff

procedure gen_doNotDisplayPageBoundaries(
  p_doNotDisplayPageBoundaries ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotEmbedSmartTags CT_OnOff

procedure gen_doNotEmbedSmartTags(
  p_doNotEmbedSmartTags ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotHyphenateCaps CT_OnOff

procedure gen_doNotHyphenateCaps(
  p_doNotHyphenateCaps ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotIncludeSubdocsInStats CT_OnOff

procedure gen_doNotIncludeSubdocsInStats(
  p_doNotIncludeSubdocsInStats ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotShadeFormData CT_OnOff

procedure gen_doNotShadeFormData(
  p_doNotShadeFormData ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotTrackFormatting CT_OnOff

procedure gen_doNotTrackFormatting(
  p_doNotTrackFormatting ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotTrackMoves CT_OnOff

procedure gen_doNotTrackMoves(
  p_doNotTrackMoves ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotUseMargForDrawGridOrig CT_OnOff

procedure gen_doNotUseMarForDrawGridOrig(
  p_doNotUseMargForDrawGridOrig ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--doNotValidateAgainstSchema CT_OnOff

procedure gen_doNotValidateAgainstSchema(
  p_doNotValidateAgainstSchema ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--drawingGridhorizontalOrigin CT_DecimalNumber : CT_TwipsMeasure

procedure gen_drawinGridhorizontalOrigin(
  p_drawingGridhorizontalOrigin ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--drawingGridhorizontalSpacing CT_DecimalNumber : CT_TwipsMeasure

procedure gen_drawGridhorizontalSpacing(
  p_drawingGridhorizontalSpacing ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--drawingGridVerticalOrigin CT_DecimalNumber : CT_TwipsMeasure

procedure gen_drawingGridVerticalOrigin(
  p_drawingGridVerticalOrigin ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--drawingGridVerticalSpacing CT_DecimalNumber : CT_TwipsMeasure

procedure gen_drawingGridVerticalSpacing(
  p_drawingGridVerticalSpacing ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--embedSystemFonts CT_OnOff

procedure gen_embedSystemFonts(
  p_embedSystemFonts ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--embedTrueTypeFonts CT_OnOff

procedure gen_embedTrueTypeFonts(
  p_embedTrueTypeFonts ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--endnote CT_OnOff

procedure gen_endnote(
  p_endnote CT_FtnEdnSepRef
  );
-- CT_FtnEdnSepRef: t_endnote_
procedure add_endnote(
   p_table in out t_endnote_,
   p_endnote CT_FtnEdnSepRef
   );

---------------------------------------------
--numStart CT_DecimalNumber

procedure gen_numStart(
  p_numStart ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--numRestart CT_NumRestart

procedure gen_numRestart(
  p_numRestart CT_RestartNumber
  );

---------------------------------------------
--pos CT_EdnPos

procedure gen_pos(
  p_pos CT_EdnPos
  );

---------------------------------------------
--endnotePr CT_EdnDocProps

procedure gen_endnotePr(
  p_endnotePr CT_EdnDocProps
  );

---------------------------------------------
--evenAndOddHeaders CT_OnOff

procedure gen_evenAndOddHeaders(
  p_evenAndOddHeaders ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--footnote CT_FtnEdnSepRef

procedure gen_footnote(
  p_footnote CT_FtnEdnSepRef
  );
-- CT_FtnEdnSepRef: t_endnote_
procedure add_footnote(
   p_table in out t_endnote_,
   p_endnote CT_FtnEdnSepRef
   );

---------------------------------------------
--footnotePr CT_FtnDocProps

procedure gen_footnotePr(
  p_footnotePr CT_FtnDocProps
  );

---------------------------------------------
--forceUpgrade CT_Empty

procedure gen_forceUpgrade(
  p_forceUpgrade CT_Empty
  );

---------------------------------------------
--formsDesign CT_OnOff

procedure gen_formsDesign(
  p_formsDesign ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--gutterAtTop CT_OnOff

procedure gen_gutterAtTop(
  p_gutterAtTop ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--hideGrammaticalErrors CT_OnOff

procedure gen_hideGrammaticalErrors(
  p_hideGrammaticalErrors ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--hideSpellingErrors CT_OnOff

procedure gen_hideSpellingErrors(
  p_hideSpellingErrors ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--hyphenationZone CT_DecimalNumber : CT_TwipsMeasure

procedure gen_hyphenationZone(
  p_hyphenationZone ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--ignoreMixedContent CT_OnOff

procedure gen_ignoreMixedContent(
  p_ignoreMixedContent ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--linkStyles CT_OnOff

procedure gen_linkStyles(
  p_linkStyles ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--listSeparator CT_String

procedure gen_listSeparator(
  p_listSeparator ploffx_document_type.CT_String
  );

---------------------------------------------
--activeRecord CT_DecimalNumber

procedure gen_activeRecord(
  p_activeRecord ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--addressFieldName CT_String

procedure gen_addressFieldName(
  p_addressFieldName ploffx_document_type.CT_String
  );

---------------------------------------------
--checkErrors CT_DecimalNumber

procedure gen_checkErrors(
  p_checkErrors ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--connectString CT_String

procedure gen_connectString(
  p_connectString ploffx_document_type.CT_String
  );

---------------------------------------------
--dataSource CT_Rel

procedure gen_dataSource(
  p_dataSource ploffx_document_type.CT_Rel
  );

---------------------------------------------
--dataType CT_MailMergeDataType

procedure gen_dataType(
  p_dataType CT_MailMergeDataType
  );

---------------------------------------------
--destination CT_MailMergeDest

procedure gen_destination(
  p_destination CT_MailMergeDest
  );

---------------------------------------------
--doNotSupressBlankLines CT_OnOff;

procedure gen_doNotSupressBlankLines(
  p_doNotSupressBlankLines ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--headerSource CT_Rel;

procedure gen_headerSource(
  p_headerSource ploffx_document_type.CT_Rel
  );

---------------------------------------------
--linkToQuery CT_OnOff;

procedure gen_linkToQuery(
  p_linkToQuery ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--mailAsAttachment CT_OnOff;

procedure gen_mailAsAttachment(
  p_mailAsAttachment ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--mailSubject CT_String;

procedure gen_mailSubject(
  p_mailSubject ploffx_document_type.CT_String
  );

---------------------------------------------
--mainDocumentType CT_String;

procedure gen_mainDocumentType(
  p_mainDocumentType CT_MailMergeDocType
  );

---------------------------------------------
--colDelim CT_DecimalNumber;

procedure gen_colDelim(
  p_colDelim ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--fHdr CT_OnOff;

procedure gen_fHdr(
  p_fHdr ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--column CT_DecimalNumber;

procedure gen_column(
  p_column ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--dynamicAddress CT_OnOff;

procedure gen_dynamicAddress(
  p_dynamicAddress ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--lid CT_Lang;

procedure gen_lid(
  p_lid CT_Lang
  );

---------------------------------------------
--mappedName CT_String;

procedure gen_mappedName(
  p_mappedName ploffx_document_type.CT_String
  );

---------------------------------------------
--name CT_String;

procedure gen_name(
  p_name ploffx_document_type.CT_String
  );

---------------------------------------------
--type CT_MailMergeOdsoFMDFieldType

procedure gen_type1(
  p_type CT_MailMergeOdsoFMDFieldType
  );

---------------------------------------------
--fieldMapData CT_Odso;

procedure gen_fieldMapData(
  p_fieldMapData CT_OdsoFieldMapData
  );

---------------------------------------------
--recipientData CT_Rel;

procedure gen_recipientData(
  p_recipientData ploffx_document_type.CT_Rel
  );

---------------------------------------------
--src CT_Rel;

procedure gen_src(
  p_src ploffx_document_type.CT_Rel
  );

---------------------------------------------
--table CT_String;

procedure gen_table(
  p_table ploffx_document_type.CT_String
  );

---------------------------------------------
--type CT_MailMergeSourceType

procedure gen_type(
  p_type CT_MailMergeSourceType
  );

---------------------------------------------
--udl CT_String;

procedure gen_udl(
  p_udl ploffx_document_type.CT_String
  );

---------------------------------------------
--odso CT_Odso;

procedure gen_odso(
  p_odso CT_Odso
  );

---------------------------------------------
--query CT_String;

procedure gen_query(
  p_query ploffx_document_type.CT_String
  );

---------------------------------------------
--viewMergedData CT_OnOff;

procedure gen_viewMergedData(
  p_viewMergedData ploffx_document_type.CT_OnOff
  );


---------------------------------------------
--mailMerge CT_MailMerge

procedure gen_mailMerge(
  p_mailMerge CT_MailMerge
  );

---------------------------------------------
--brkBin CT_BreakBin

procedure gen_brkBin(
  p_brkBin CT_BreakBin
  );

---------------------------------------------
--brkBinSub CT_BreakBinSub

procedure gen_brkBinSub(
  p_brkBinSub CT_BreakBinSub
  );

---------------------------------------------
--defJc CT_OMathJc

procedure gen_defJc(
  p_defJc CT_OMathJc
  );

---------------------------------------------
--dispDef CT_OMathJc

procedure gen_dispDef(
  p_dispDef ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--interSP CT_OMathJc

procedure gen_interSP(
  p_interSP ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--intLim CT_OMathJc

procedure gen_intLim(
  p_intLim CT_LimLoc
  );

---------------------------------------------
--intraSp CT_DecimalNumber

procedure gen_intraSp(
  p_intraSp ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--lMargin CT_DecimalNumber

procedure gen_lMargin(
  p_lMargin ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--mathFont CT_String

procedure gen_mathFont(
  p_mathFont ploffx_document_type.CT_String
  );

---------------------------------------------
--naryLim CT_LimLoc

procedure gen_naryLim(
  p_naryLim CT_LimLoc
  );

---------------------------------------------
--postSp CT_DecimalNumber

procedure gen_postSp(
  p_postSp ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--preSp CT_DecimalNumber

procedure gen_preSp(
  p_preSp ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--rMargin CT_DecimalNumber

procedure gen_rMargin(
  p_rMargin ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--smallFrac CT_OnOff

procedure gen_smallFrac(
  p_smallFrac ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--wrapIndent CT_DecimalNumber

procedure gen_wrapIndent(
  p_wrapIndent ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--wrapRight CT_OnOff

procedure gen_wrapRight(
  p_wrapRight ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--mathPr CT_MathPr

procedure gen_mathPr(
  p_mathPr CT_MathPr
  );

---------------------------------------------
--mirrorMargins CT_OnOff

procedure gen_mirrorMargins(
  p_mirrorMargins ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--noLineBreaksAfter CT_Kinsoku

procedure gen_noLineBreaksAfter(
  p_noLineBreaksAfter CT_Kinsoku
  );

---------------------------------------------
--noLineBreaksBefore CT_Kinsoku

procedure gen_noLineBreaksBefore(
  p_noLineBreaksBefore CT_Kinsoku
  );

---------------------------------------------
--noPunctuationKerning CT_OnOff

procedure gen_noPunctuationKerning(
  p_noPunctuationKerning ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--printFormsData CT_OnOff

procedure gen_printFormsData(
  p_printFormsData ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--printFractionalCharacterWidth CT_OnOff

procedure gen_printFractionalCharWidth(
  p_printFractionalCharWidth ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--printPostScriptOverText CT_OnOff

procedure gen_printPostScriptOverText(
  p_printPostScriptOverText ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--printTwoOnOne CT_OnOff

procedure gen_printTwoOnOne(
  p_printTwoOnOne ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--proofState CT_Proof

procedure gen_proofState(
  p_proofState CT_Proof
  );

---------------------------------------------
--readModeInkLockDown CT_ReadingModeInkLockDown

procedure gen_readModeInkLockDown(
  p_readModeInkLockDown CT_ReadingModeInkLockDown
  );

---------------------------------------------
--removeDateAndTime CT_OnOff

procedure gen_removeDateAndTime(
  p_removeDateAndTime ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--removePersonalInformation CT_OnOff

procedure gen_removePersonalInformation(
  p_removePersonalInformation ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--revisionView CT_OnOff

procedure gen_revisionView(
  p_revisionView CT_TrackChangesView
  );

---------------------------------------------
--rsidRoot CT_LongHexNumber

procedure gen_rsidRoot(
  p_rsidRoot ploffx_document_type.CT_LongHexNumber
  );

--rsid:t_rsid_
procedure add_rsid(
  p_table in out t_rsid_,
  p_rsid ploffx_document_type.CT_LongHexNumber
  );

---------------------------------------------
--rsids CT_DocRsids

procedure gen_rsids(
  p_rsids CT_DocRsids
  );

---------------------------------------------
--saveFormsData CT_OnOff

procedure gen_saveFormsData(
  p_saveFormsData ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--saveInvalidXml CT_OnOff

procedure gen_saveInvalidXml(
  p_saveInvalidXml ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--savePreviewPicture CT_OnOff

procedure gen_savePreviewPicture(
  p_savePreviewPicture ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--saveSubSetFonts CT_OnOff

procedure gen_saveSubSetFonts(
  p_saveSubSetFonts ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--saveThroughXslt CT_OnOff

procedure gen_saveThroughXslt(
  p_saveThroughXslt CT_SaveThroughXslt
  );

---------------------------------------------
--saveXmlDataOnly CT_OnOff

procedure gen_saveXmlDataOnly(
  p_saveXmlDataOnly ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--schema CT_Schema

procedure gen_schema(
  p_schema CT_Schema
  );
--schema:t_schema_
procedure add_schema(
  p_table in out t_schema_,
  p_schema CT_Schema
  );

---------------------------------------------
--schemaLibrary CT_SchemaLibrary

procedure gen_schemaLibrary(
  p_schemaLibrary CT_SchemaLibrary
  );

---------------------------------------------
--showEnvelope CT_OnOff

procedure gen_showEnvelope(
  p_showEnvelope ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--showXMLTags CT_OnOff

procedure gen_showXMLTags(
  p_showXMLTags ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--smartTagType CT_OnOff

procedure gen_smartTagType(
  p_smartTagType CT_SmartTagType
  );

---------------------------------------------
--strictFirstAndLastChars CT_OnOff

procedure gen_strictFirstAndLastChars(
  p_strictFirstAndLastChars ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--styleLockQFSet CT_OnOff

procedure gen_styleLockQFSet(
  p_styleLockQFSet ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--styleLockTheme CT_OnOff

procedure gen_styleLockTheme(
  p_styleLockTheme ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--stylePaneFormatFilter CT_LongHexNumber : ShortHexNumber

procedure gen_stylePaneFormatFilter(
  p_stylePaneFormatFilter ploffx_document_type.CT_LongHexNumber
  );

---------------------------------------------
--stylePaneSortMethod CT_LongHexNumber : ShortHexNumber

procedure gen_stylePaneSortMethod(
  p_stylePaneSortMethod ploffx_document_type.CT_LongHexNumber
  );

---------------------------------------------
--summaryLength CT_DecimalNumber

procedure gen_summaryLength(
  p_summaryLength ploffx_document_type.CT_DecimalNumber
  );

---------------------------------------------
--themeFontLang CT_Language

procedure gen_themeFontLang(
  p_themeFontLang ploffx_document_type.CT_Language
  );

---------------------------------------------
--trackRevisions CT_OnOff

procedure gen_trackRevisions(
  p_trackRevisions ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--uiCompat97To2003 CT_OnOff

procedure gen_uiCompat97To2003(
  p_uiCompat97To2003 ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--updateFields CT_OnOff

procedure gen_updateFields(
  p_updateFields ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--useXSLTWhenSaving CT_OnOff

procedure gen_useXSLTWhenSaving(
  p_useXSLTWhenSaving ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--view CT_View

procedure gen_view(
  p_view CT_View
  );

--------------------------------------------
--writeProtection CT_WriteProtection

procedure gen_writeProtection(
  p_writeProtection CT_WriteProtection
  );

---------------------------------------------
--o_shapeDefaults CT_Idmap

procedure gen_o_shapeDefaults(
  p_o_shapeDefaults CT_O_ShapeDefaults
  );

---------------------------------------------
--idmap CT_Idmap

procedure gen_idmap(
  p_idmap CT_Idmap
  );

---------------------------------------------
--o_shapeDefaults CT_O_ShapeLayout

procedure gen_o_shapeLayout(
  p_o_shapeLayout CT_O_ShapeLayout
  );

---------------------------------------------
--shapeDefaults CT_ShapeDefaults

procedure gen_shapeDefaults(
  p_shapeDefaults CT_ShapeDefaults
  );

---------------------------------------------
--settings CT_Settings

procedure gen_settings(
  p_settings CT_Settings
  );

-- GEN_XML
procedure gen_xml(
  p_settings CT_Settings
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse

function parse(
  	p_file clob
    ) return ploffx_settings.CT_Settings;

--v1.3.0
procedure docx_settings_init(
  p_settings in out CT_Settings
  );

--
end ploffx_settings;
/

