create or replace package ploffx_prels
authid current_user is
--v5.0
--
-- Namespace
ns_prels constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/package/2006/relationships';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_Relationships constant plx_sc.normalv2 := 'Relationships';
t_Relationship constant plx_sc.normalv2 := 'Relationship';
--v5.9
-- Constants
c_full_ns constant plx_sc.normalv2 := 'xmlns="http://schemas.openxmlformats.org/package/2006/relationships';
--
c_filename constant plx_sc.normalv2 := 'xl/_rels/workbook.xml.rels';
c_doc_filename constant plx_sc.normalv2 := '_rels/.rels';
c_document_rels_filename constant plx_sc.normalv2 := 'word/_rels/document.xml.rels';

/************************************************************/
--Structures
-- v1.3.0

-- ST_TargetMode
subtype ST_TargetMode is plx_sc.normalv2;
c_External constant ST_TargetMode := 'External';
c_Internal constant ST_TargetMode := 'Internal';

-- CT_Relationship
type CT_Relationship is record(
  tag plx_sc.normalv2,
  TargetMode ST_TargetMode,
  Target plx_sc.maxv2, --v5.0
  Type_ plx_sc.normalv2,
  Id plx_sc.normalv2
  );
-- t_Relationships
type t_Relationships_ is table of CT_Relationship;
v_relationships_empty t_Relationships_ := t_Relationships_();

-- CT_Relationships
type CT_Relationships is record(
  tag plx_sc.normalv2,
  relationship t_Relationships_
  );

-- CT_HFRelationship
type CT_HFRelationship is record(
  filename plx_sc.normalv2 default null,
  rels CT_Relationships
  );

-- CT_HFRelationships
type CT_HFRelationships is table of CT_HFRelationship index by pls_integer; --v4.4.0

/************************************************************/

-- start
procedure start_;
-- end
procedure end_;

-- Relationships
procedure startRelationships(
  p_tag varchar2 default t_Relationships
  );
--
procedure endRelationships(
  p_tag varchar2 default t_Relationships
  );

-- Relationship
procedure Relationship(
  p_tag varchar2 default t_Relationship,
  p_Id varchar2,
  p_Type varchar2,
  p_Target varchar2,
  p_TargetMode varchar2 default null
  );

/************************************************************/
-- Create structure

---------------------------------------------
--Relationship:CT_Relationship
--v1.3.0
function cr_Relationship(
  p_tag varchar2 default t_Relationship,
  p_Id varchar2,
  p_Type varchar2,
  p_Target varchar2,
  p_TargetMode varchar2 default null
  ) return CT_Relationship;

---------------------------------------------
--Relationships:CT_Relationships
--v3.0.0
function cr_Relationships(
  p_tag varchar2 default t_Relationships,
  p_relationship t_Relationships_
  ) return CT_Relationships;

/************************************************************/
-- Generate XML parts

---------------------------------------------
--Relationship:CT_Relationship
--v1.3.0
procedure gen_Relationship(
  p_Relationship CT_Relationship
  );

---------------------------------------------
--Relationships:CT_Relationships
--v3.0.0
procedure gen_RelationShips(
  p_RelationShips CT_Relationships
  );

-- v3.0.0
procedure add_relationship(
  p_rels in out t_relationships_,
  p_rel CT_Relationship
  );

--v1.3.0
function add_relationship(
  p_rels in out t_relationships_,
  p_rel CT_Relationship
  ) return pls_integer;

-- GEN_XML
-- v3.0.0
procedure gen_xml(
  p_relationships CT_Relationships
  );


/************************************************************/
-- Parse and preprocessed parts

-- Parse
--v3.0.0
function parse(
  p_file clob
  ) return CT_Relationships;

--v1.3.0
procedure docx_rels_init(
  p_rels in out ploffx_prels.CT_Relationships
  );

--v1.3.0
procedure docx_word_relsdocumentxmlrels(
   p_header_default boolean default false,
   p_header_even boolean default false,
   p_header_first boolean default false,
   p_footer_default boolean default false,
   p_footer_even boolean default false,
   p_footer_first boolean default false
   );

--v3.0.0
procedure docx_documentxml_init(
   p_rels in out CT_Relationships,
   p_header_default boolean default false,
   p_header_even boolean default false,
   p_header_first boolean default false,
   p_footer_default boolean default false,
   p_footer_even boolean default false,
   p_footer_first boolean default false
   );
--
end ploffx_prels;
/

