create or replace package ploffx_picture
authid current_user is
--v5.9
--
--Namespace
ns_pic constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/picture';

-- Prefixes
ns_pic_pref constant varchar2(3 char) := 'pic';
ns_a_pref constant varchar2(1 char) := 'a';
ns_r_pref constant varchar2(1 char) := 'r';

-- XML
-- g_xml plx_sc.type_xdoc;

-- Tag
-- :pic
t_cNvPr constant plx_sc.normalv2 := 'cNvPr';
t_cNvPicPr constant plx_sc.normalv2 := 'cNvPicPr';
--
t_nvPicPr constant plx_sc.normalv2 := 'nvPicPr';
t_blipFill constant plx_sc.normalv2 := 'blipFill';
t_spPr constant plx_sc.normalv2 := 'spPr';
--
t_pic constant plx_sc.normalv2 := 'pic';

-- :a
t_blip constant plx_sc.normalv2 := 'blip';
t_stretch constant plx_sc.normalv2 := 'stretch';
t_fillRect constant plx_sc.normalv2 := 'fillRect';
t_xfrm constant plx_sc.normalv2 := 'xfrm';
t_off constant plx_sc.normalv2 := 'off';
t_ext constant plx_sc.normalv2 := 'ext';
t_prstGeom constant plx_sc.normalv2 := 'prstGeom';
t_avLst constant plx_sc.normalv2 := 'avLst';
t_gd constant plx_Sc.normalv2 := 'gd';

/******************************************************************/
--Structures

-- CT_NonVisualDrawingProps
type CT_NonVisualDrawingProps is record(
     tag plx_sc.normalv2,
     name plx_sc.normalv2,
     id plx_sc.normalv2
);

-- CT_NonVisualPictureProperties
type CT_NonVisualPictureProperties is record(
     tag plx_sc.normalv2,
     preferRelativeResize plx_sc.normalv2
);

-- CT_PictureNonVisual
type CT_PictureNonVisual is record(
     tag plx_sc.normalv2,
     cNvPr CT_NonVisualDrawingProps,
     cNvPicPr CT_NonVisualPictureProperties
);

-- CT_RelativeRect
type CT_RelativeRect is record(
     tag plx_sc.normalv2,
     l plx_sc.normalv2,
     t plx_sc.normalv2,
     r plx_sc.normalv2,
     b plx_sc.normalv2
);

-- CT_StretchInfoProperties
type CT_StretchInfoProperties is record(
     tag plx_sc.normalv2,
     fillRect CT_RelativeRect
);

-- CT_Blip
type CT_Blip is record(
     tag plx_sc.normalv2,
     cstate plx_sc.normalv2, -- ST_BlipCompression
     embed plx_sc.normalv2
     -- TODO: all child elements
);

-- CT_BlipFillProperties
type CT_BlipFillProperties is record(
     tag plx_sc.normalv2,
     blip CT_Blip,
     stretch CT_StretchInfoProperties
);

-- CT_GeomGuide
type CT_GeomGuide is record(
     tag plx_sc.normalv2,
     fmla plx_sc.normalv2, -- ST_GeomGuidName
     name_ plx_sc.normalv2 -- ST_GeomGuideName
);

-- CT_GeomGuideList
type CT_GeomGuideList is record(
     tag plx_sc.normalv2,
     gd CT_GeomGuide
);

-- CT_PresetGEometry2D
type CT_PresetGeometry2D is record(
     tag plx_sc.normalv2,
     prst plx_sc.normalv2, -- ST_ShapeType
     avLst CT_GeomGuideList
);

-- CT_Point2D
type CT_Point2D is record(
     tag plx_sc.normalv2,
     x plx_sc.normalv2, -- ST_Coordinate
     y plx_sc.normalv2  -- ST_Coordinate
);

-- CT_PositiveSize2D
type CT_PositiveSize2D is record(
     tag plx_sc.normalv2,
     cx plx_sc.normalv2, -- ST_PositiveCoordinate
     cy plx_sc.normalv2 -- ST_PositiveCoordinate
);


-- CT_Transform2D
type CT_Transform2D is record(
     tag plx_sc.normalv2,
     off CT_Point2D,
     ext CT_PositiveSize2D
);


-- CT_ShapeProperties
type CT_ShapeProperties is record(
     tag plx_sc.normalv2,
     bwMode plx_sc.normalv2, -- ST_BlackWhiteMode
     xfrm CT_Transform2D,
     prstGeom CT_PresetGeometry2D
);

-- CT_Picture
type CT_Picture is record(
     tag plx_sc.normalv2,
     nvPicPr CT_PictureNonVisual,
     blipFill CT_BlipFillProperties,
     spPr CT_ShapeProperties
);

/******************************************************************/
-- Tag generators

-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );

-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );

-- pic
procedure startpic(
  p_tag plx_sc.normalv2 default t_pic,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endpic(
  p_tag plx_sc.normalv2 default t_pic,
  p_xml in out plx_sc.type_xdoc
  );

-- nvPicPr
procedure startnvPicPr(
  p_tag plx_sc.normalv2 default t_nvPicPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endnvPicPr(
  p_tag plx_sc.normalv2 default t_nvPicPr,
  p_xml in out plx_sc.type_xdoc
  );

-- blipFill
procedure startblipFill(
  p_tag plx_sc.normalv2 default t_blipFill,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endblipFill(
  p_tag plx_sc.normalv2 default t_blipFill,
  p_xml in out plx_sc.type_xdoc
  );

-- spPr
procedure startspPr(
  p_tag plx_sc.normalv2 default t_spPr,
  p_xml in out plx_sc.type_xdoc,
  p_bwMode varchar2 default null
  );
--
procedure endspPr(
  p_tag plx_sc.normalv2 default t_spPr,
  p_xml in out plx_sc.type_xdoc
  );

-- cNvPr
procedure cNvPr(
  p_tag plx_sc.normalv2 default t_cNvPr,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2,
  p_name varchar2
  );

-- cNvPicPr
procedure cNvPicPr(
  p_tag plx_sc.normalv2 default t_cNvPicPr,
  p_xml in out plx_sc.type_xdoc,
  p_preferRelativeResize varchar2 default null
  );

-----------
-- :a
-----------
-- blip
procedure blip(
  p_tag plx_sc.normalv2 default t_blip,
  p_xml in out plx_sc.type_xdoc,
  p_cstate varchar2 default null,
  p_embed varchar2
  );

-- stretch
procedure startstretch(
  p_tag plx_sc.normalv2 default t_stretch,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endstretch(
  p_tag plx_sc.normalv2 default t_stretch,
  p_xml in out plx_sc.type_xdoc
  );

-- fillRect
procedure fillrect(
  p_tag plx_sc.normalv2 default t_fillRect,
  p_xml in out plx_sc.type_xdoc,
  p_l varchar2 default null,
  p_t varchar2 default null,
  p_r varchar2 default null,
  p_b varchar2 default null
);

-- xfrm
procedure startxfrm(
  p_tag plx_sc.normalv2 default t_xfrm,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endxfrm(
  p_tag plx_sc.normalv2 default t_xfrm,
  p_xml in out plx_sc.type_xdoc
  );

-- ext
procedure ext(
  p_tag plx_sc.normalv2 default t_ext,
  p_xml in out plx_sc.type_xdoc,
  p_cx varchar2,
  p_cy varchar2
  );

-- off
procedure off(
  p_tag plx_sc.normalv2 default t_off,
  p_xml in out plx_sc.type_xdoc,
  p_x varchar2,
  p_y varchar2
  );

-- prstGeom
procedure startprstGeom(
  p_tag plx_sc.normalv2 default t_prstGeom,
  p_xml in out plx_sc.type_xdoc,
  p_prst varchar2
  );
--
procedure endprstGeom(
  p_tag plx_sc.normalv2 default t_prstGeom,
  p_xml in out plx_sc.type_xdoc
  );

-- avLst
procedure startavLst(
  p_tag plx_sc.normalv2 default t_avLst,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endavLst(
  p_tag plx_sc.normalv2 default t_avLst,
  p_xml in out plx_sc.type_xdoc
  );

-- gd
procedure gd(
  p_tag plx_sc.normalv2 default t_gd,
  p_xml in out plx_sc.type_xdoc,
  p_name varchar2,
  p_fmla varchar2
  );

/******************************************************************/
-- cr_ gen_ get_
---------------------------------------------
--cNvPr:CT_NonVisualDrawingProps
--create structure
function cr_cNvPr(
  p_tag plx_sc.normalv2 default t_cNvPr,
  p_name plx_sc.normalv2,
  p_id plx_sc.normalv2
  ) return CT_NonVisualDrawingProps;
--generate xml part
procedure gen_cNvPr(
  p_xml in out plx_sc.type_xdoc,
  p_cNvPr CT_NonVisualDrawingProps
  );
--get from xml
function get_cNvPr(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_NonVisualDrawingProps;
---------------------------------------------
---------------------------------------------
--cNvPicPr:CT_NonVisualPictureProperties
--create structure
function cr_cNvPicPr(
  p_tag plx_sc.normalv2 default t_cNvPicPr,
  p_preferRelativeResize plx_sc.normalv2 default null
  ) return CT_NonVisualPictureProperties;
--generate xml part
procedure gen_cNvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_cNvPicPr CT_NonVisualPictureProperties
  );
--get from xml
function get_cNvPicPr(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_NonVisualPictureProperties;
---------------------------------------------
---------------------------------------------
--nvPicPr:CT_PictureNonVisual
--create structure
function cr_nvPicPr(
  p_tag plx_sc.normalv2 default t_nvPicPr,
  p_cNvPr CT_NonVisualDrawingProps,
  p_cNvPicPr CT_NonVisualPictureProperties
  ) return CT_PictureNonVisual;
--generate xml part
procedure gen_nvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_nvPicPr CT_PictureNonVisual
  );
--get from xml
function get_nvPicPr(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_PictureNonVisual;
---------------------------------------------
---------------------------------------------
--blip:CT_Blip
--create structure
function cr_blip(
  p_tag plx_sc.normalv2 default t_blip,
  p_cstate plx_sc.normalv2,
  p_embed plx_sc.normalv2
  ) return CT_Blip;
--generate xml part
procedure gen_blip(
  p_xml in out plx_sc.type_xdoc,
  p_blip CT_Blip
  );
--get from xml
function get_blip(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_Blip;
---------------------------------------------
---------------------------------------------
--fillRect:CT_RelativeRect
--create structure
function cr_fillRect(
  p_tag plx_sc.normalv2 default t_fillRect,
  p_l plx_sc.normalv2 default null,
  p_t plx_sc.normalv2 default null,
  p_r plx_sc.normalv2 default null,
  p_b plx_sc.normalv2 default null
  ) return CT_RelativeRect;
--generate xml part
procedure gen_fillRect(
  p_xml in out plx_sc.type_xdoc,
  p_fillRect CT_RelativeRect
  );
--get from xml
function get_fillRect(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_RelativeRect;
---------------------------------------------
---------------------------------------------
--stretch:CT_StretchInfoProperties
--create structure
function cr_stretch(
  p_tag plx_sc.normalv2 default t_stretch,
  p_fillRect CT_RelativeRect
  ) return CT_StretchInfoProperties;
--generate xml part
procedure gen_stretch(
  p_xml in out plx_sc.type_xdoc,
  p_stretch CT_StretchInfoProperties
  );
--get from xml
function get_stretch(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_StretchInfoProperties;
---------------------------------------------
---------------------------------------------
--blipFill:CT_BlipFillProperties
--create structure
function cr_blipFill(
  p_tag plx_sc.normalv2 default t_blipFill,
  p_blip CT_Blip,
  p_stretch CT_StretchInfoProperties
  ) return CT_BlipFillProperties;
--generate xml part
procedure gen_blipFill(
  p_xml in out plx_sc.type_xdoc,
  p_blipFill CT_BlipFillProperties
  );
--get from xml
function get_blipFill(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_BlipFillProperties;
---------------------------------------------
---------------------------------------------
--off:CT_Point2D
--create structure
function cr_off(
  p_tag plx_sc.normalv2 default t_off,
  p_x plx_sc.normalv2,
  p_y plx_sc.normalv2
  ) return CT_Point2D;
--generate xml part
procedure gen_off(
  p_xml in out plx_sc.type_xdoc,
  p_off CT_Point2D
  );
--get from xml
function get_off(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_Point2D;
---------------------------------------------
---------------------------------------------
--ext:CT_PositiveSize2D
--create structure
function cr_ext(
  p_tag plx_sc.normalv2 default t_ext,
  p_cx plx_sc.normalv2,
  p_cy plx_sc.normalv2
  ) return CT_PositiveSize2D;
--generate xml part
procedure gen_ext(
  p_xml in out plx_sc.type_xdoc,
  p_ext CT_PositiveSize2D
  );
--get from xml
function get_ext(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_PositiveSize2D;
---------------------------------------------
---------------------------------------------
--xfrm:CT_Transform2D
--create structure
function cr_xfrm(
  p_tag plx_sc.normalv2 default t_xfrm,
  p_off CT_Point2D,
  p_ext CT_PositiveSize2D
  ) return CT_Transform2D;
--generate xml part
procedure gen_xfrm(
  p_xml in out plx_sc.type_xdoc,
  p_xfrm CT_Transform2D
  );
--get from xml
function get_xfrm(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_Transform2D;
---------------------------------------------
---------------------------------------------
--avLst:CT_GeomGuideList
--create structure
function cr_avLst(
  p_tag plx_sc.normalv2 default t_avLst,
  p_gd CT_GeomGuide default null
  ) return CT_GeomGuideList;
--generate xml part
procedure gen_avLst(
  p_xml in out plx_sc.type_xdoc,
  p_avLst CT_GeomGuideList
  );
--get from xml
function get_avLst(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_GeomGuideList;
---------------------------------------------
---------------------------------------------
--prstGeom:CT_PresetGeometry2D
--create structure
function cr_prstGeom(
  p_tag plx_sc.normalv2 default t_prstGeom,
  p_prst plx_sc.normalv2,
  p_avLst CT_GeomGuideList
  ) return CT_PresetGeometry2D;
--generate xml part
procedure gen_prstGeom(
  p_xml in out plx_sc.type_xdoc,
  p_prstGeom CT_PresetGeometry2D
  );
--get from xml
function get_prstGeom(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_PresetGeometry2D;
---------------------------------------------
---------------------------------------------
--spPr:CT_ShapeProperties
--create structure
function cr_spPr(
  p_tag plx_sc.normalv2 default t_spPr,
  p_bwMode plx_sc.normalv2,
  p_xfrm CT_Transform2D,
  p_prstGeom CT_PresetGeometry2D
  ) return CT_ShapeProperties;
--generate xml part
procedure gen_spPr(
  p_xml in out plx_sc.type_xdoc,
  p_spPr CT_ShapeProperties
  );
--get from xml
function get_spPr(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_ShapeProperties;
---------------------------------------------
---------------------------------------------
--pic:CT_Picture
--create structure
function cr_pic(
  p_tag plx_sc.normalv2 default t_pic,
  p_nvPicPr CT_PictureNonVisual,
  p_blipFill CT_BlipFillProperties,
  p_spPr CT_ShapeProperties
  ) return CT_Picture;
--generate xml part
procedure gen_pic(
  p_xml in out plx_sc.type_xdoc,
  p_pic CT_Picture
  );
--get from xml
function get_pic(
  p_xml dbms_xmldom.DOMDocument
  ) return CT_Picture;
---------------------------------------------
end ploffx_picture;
/

