create or replace package ploffx_numbering
authid current_user is
--v5.9
-- Namespace
ns_wpc constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
ns_o constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:office';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_m constant plx_sc.normalv2  := 'http://schemas.openxmlformats.org/officeDocument/2006/math';
ns_v constant plx_sc.normalv2 :=  'urn:schemas-microsoft-com:vml';
ns_wp14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing';
ns_wp constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing';
ns_w10 constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:word';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_wpg constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingGroup';
ns_wpi constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingInk';
ns_wne constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2006/wordml';
ns_wps constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingShape';
ns_ve constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
ns_a constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/main'; --v1.3.0

--Prefixes
ns_wpc_pref constant varchar2(3 char) := 'wpc';
ns_mc_pref constant varchar2(2 char) := 'mc';
ns_o_pref constant varchar2(1 char) := 'o';
ns_r_pref constant varchar2(1 char) := 'r';
ns_m_pref constant varchar2(1 char) := 'm';
ns_v_pref constant varchar2(1 char) := 'v';
ns_wp14_pref constant varchar2(4 char) := 'wp14';
ns_wp_pref constant varchar2(2 char) := 'wp';
ns_w10_pref constant varchar2(3 char) := 'w10';
ns_w_pref constant varchar2(1 char) := 'w';
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_wpg_pref constant varchar2(3 char) := 'wpg';
ns_wpi_pref constant varchar2(3 char) := 'wpi';
ns_wne_pref constant varchar2(3 char) := 'wne';
ns_wps_pref constant varchar2(3 char) := 'wpe';
ns_ve_pref constant varchar2(2 char) := 've';
-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_numbering constant plx_sc.normalv2 := 'numbering'; --
t_abstractNum constant plx_sc.normalv2 := 'abstractNum'; --
t_num constant plx_sc.normalv2 := 'num'; --
t_numIdMacAtCleanup constant plx_sc.normalv2 := 'numIdMacAtCleanUp';
t_numPicBullet constant plx_sc.normalv2 := 'numPicBullet';
t_lvl constant plx_sc.normalv2 := 'lvl'; --
t_multiLevelType constant plx_sc.normalv2 := 'multiLevelType'; --
t_name constant plx_sc.normalv2 := 'name'; --
t_nsid constant plx_sc.normalv2 := 'nsid'; --
t_styleLink constant plx_sc.normalv2 := 'styleLink';
t_numStyleLink constant plx_sc.normalv2 := 'numStyleLink';
t_tmpl constant plx_sc.normalv2 := 'tmpl'; --
t_abstractNumId constant plx_sc.normalv2 := 'abstractNumId'; --
t_lvlOverride constant plx_sc.normalv2 := 'lvlOverride';
t_pict constant plx_sc.normalv2 := 'pict';
t_control constant plx_sc.normalv2 := 'control';
t_movie constant plx_sc.normalv2 := 'movie';
t_startOverride constant plx_sc.normalv2 := 'startOverride';
t_isLgl constant plx_sc.normalv2 := 'isLgl';
t_suff constant plx_sc.normalv2 := 'suff';
t_legacy constant plx_sc.normalv2 := 'legacy';
t_lvlJc constant plx_sc.normalv2 := 'lvlJc'; --
t_lvlText constant plx_sc.normalv2 := 'lvlText'; --
t_lvlPicBulletId constant plx_sc.normalv2 := 'lvlPicBulletId';
t_lvlRestart constant plx_sc.normalv2 := 'lvlRestart';
t_start constant plx_sc.normalv2 := 'start'; --
t_pStyle constant plx_sc.normalv2 := 'pStyle';
t_numFmt constant plx_sc.normalv2 := 'numFmt'; --

-- Constants
c_filename constant plx_sc.normalv2 := 'word/numbering.xml';

/************************************************************/
--Structures

type CT_Jc is record (
  tag plx_sc.normalv2,
  val ploffx_document_type.ST_Align
  );

---- CT_LevelText
type CT_LevelText is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2, -- ST_String
     null_ plx_sc.normalv2 -- ST_OnOff
     );

---- CT_NumFmt
type CT_NumFmt is record(
     tag plx_sc.normalv2,
     val ploffx_document_type.ST_NumberFormat
     );

subtype ST_MultiLevelType is ploffx_util.t_string;
c_hybridMultilevel constant ST_MultiLevelType := 'hybridMultilevel';
c_multilevel constant ST_MultiLevelType := 'multilevel';
c_singleLevel constant ST_MultiLevelType := 'singleLevel';

---- CT_MultiLevelType
type CT_MultiLevelType is record(
     tag plx_sc.normalv2,
     val ST_MultiLevelType
     );

---- CT_LevelSuffix
type CT_LevelSuffix is record(
     tag plx_sc.normalv2,
     val ploffx_document_type.ST_LevelSuffix
     );

---- CT_LvlLegacy
type CT_LvlLegacy is record(
     tag plx_sc.normalv2,
     legacy plx_sc.normalv2,
     legacySpace plx_sc.normalv2,
     legacyIndent plx_sc.normalv2
     );

---- CT_Lvl
type CT_Lvl is record(
     tag plx_sc.normalv2,
     lvlrestart ploffx_document_type.CT_DecimalNumber,
     pStyle ploffx_document_type.CT_String,
     isLgl ploffx_document_type.CT_OnOff,
     suff CT_LevelSuffix,
     lvlPicBulletId ploffx_document_type.CT_DecimalNumber,
     legacy CT_LvlLegacy,
     start_ ploffx_document_type.CT_DecimalNumber,
     numFmt CT_NumFmt,
     lvlText CT_LevelText,
     lvlJc CT_Jc,
     pPr ploffx_document_type.CT_pPr,
     rPr ploffx_document_type.CT_rpr,
     ilvl plx_sc.normalv2, -- ST_DecimalNumber
     tplc plx_sc.normalv2, -- ST_LongHexNumber
     tentative plx_sc.normalv2 -- ST_OnOff
     );

type t_lvl_ is table of CT_Lvl;
v_lvl_empty t_lvl_ := t_lvl_();

---- CT_AbstractNum
type CT_AbstractNum is record(
     tag plx_sc.normalv2,
     name_ ploffx_document_type.CT_String,
     styleLink ploffx_document_type.CT_String,
     numStyleLink ploffx_document_type.CT_String,
     nsid ploffx_document_type.CT_LongHexNumber,
     multiLevelType CT_MultiLevelType,
     tmpl ploffx_document_type.CT_LongHexNumber,
     lvl t_lvl_,
     abstractNumId plx_sc.normalv2
     );

type t_abstractNum_ is table of CT_AbstractNum;
v_abstractNum_empty t_abstractNum_ := t_abstractNum_();

---- CT_NumLvl
type CT_NumLvl is record(
     tag plx_sc.normalv2,
     lvl CT_Lvl,
     startOverride ploffx_document_type.CT_DecimalNumber,
     ilvl plx_sc.normalv2
     );

type t_numLvl_ is table of CT_NumLvl;
v_numLvl_empty t_numLvl_ := t_numLvl_();

---- CT_Num
type CT_Num is record(
     tag plx_sc.normalv2,
     lvlOverride t_numLvl_,
     abstractNumId ploffx_document_type.CT_DecimalNumber,
     numId plx_sc.normalv2
     );

type t_num_ is table of CT_Num;
v_num_empty t_num_ := t_num_();

type CT_Control is record(
     tag plx_sc.normalv2,
     id plx_sc.normalv2,
     name_ plx_sc.normalv2,
     shapeid plx_sc.normalv2
     );

type CT_Picture is record(
     tag plx_sc.normalv2,
     control CT_Control,
     movie ploffx_document_type.CT_Rel --
     );

---- CT_NumPicBullet
type CT_NumPicBullet is record(
     tag plx_sc.normalv2,
     pict CT_Picture,
     numPicBulletId plx_sc.normalv2
     );

---- CT_Numbering
type CT_Numbering is record(
     tag plx_sc.normalv2,
     numPicBullet CT_NumPicBullet,
     numIdMacAtCleanup ploffx_document_type.CT_DecimalNumber,
     abstractNum t_abstractNum_,
     num t_num_
     );

/************************************************************/
-- abstractNum
procedure startabstractNum(
  p_tag varchar2 default t_abstractNum,
  p_xml in out plx_sc.type_xdoc,
  p_abstractNumId varchar2
  );
--
procedure endabstractNum(
  p_tag varchar2 default t_abstractNum,
  p_xml in out plx_sc.type_xdoc
  );

-- abstractNumId
procedure abstractNumId(
  p_tag varchar2 default t_abstractNumId,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- isLgl

procedure isLgl(
  p_tag varchar2 default t_isLgl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

-- lvl
procedure startlvl(
  p_tag varchar2 default t_lvl,
  p_xml in out plx_sc.type_xdoc,
  p_ilvl varchar2,
  p_tplc varchar2 default null,
  p_tentative varchar2 default null
  );
--
procedure endlvl(
  p_tag varchar2 default t_lvl,
  p_xml in out plx_sc.type_xdoc
  );

-- lvlJc
procedure lvlJc(
  p_tag varchar2 default t_lvlJc,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- lvlPicBulletId

procedure lvlPicBulletId(
  p_tag varchar2 default t_lvlPicBulletId,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- lvlRestart

procedure lvlRestart(
  p_tag varchar2 default t_lvlRestart,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- lvlOverride

procedure startlvlOverride(
  p_tag varchar2 default t_lvlOverride,
  p_xml in out plx_sc.type_xdoc,
  p_ilvl varchar2
  );
--
procedure endlvlOverride(
  p_tag varchar2 default t_lvlOverride,
  p_xml in out plx_sc.type_xdoc
  );


-- lvlText
procedure lvlText(
  p_tag varchar2 default t_lvlText,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null,
  p_null varchar2 default null
  );

-- multiLevelType
procedure multiLevelType(
  p_tag varchar2 default t_multiLevelType,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- name
procedure name(
  p_tag varchar2 default t_name,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- nsid
procedure nsid(
  p_tag varchar2 default t_nsid,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- num
procedure startnum(
  p_tag varchar2 default t_num,
  p_xml in out plx_sc.type_xdoc,
  p_numId varchar2
  );
--
procedure endnum(
  p_tag varchar2 default t_num,
  p_xml in out plx_sc.type_xdoc
  );

-- numbering
procedure startnumbering(
  p_tag varchar2 default t_numbering,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endnumbering(
  p_tag varchar2 default t_numbering,
  p_xml in out plx_sc.type_xdoc
  );

-- numFmt
procedure numFmt(
  p_tag varchar2 default t_numFmt,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- numIdMacAtCleanUp

procedure numIdMacAtCleanUp(
  p_tag varchar2 default t_numIdMacAtCleanup,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- numPicBullet

procedure startnumPicBullet(
  p_tag varchar2 default t_numPicBullet,
  p_xml in out plx_sc.type_xdoc,
  p_numPicBulletId varchar2
  );
--
procedure endnumPicBullet(
  p_tag varchar2 default t_numPicBullet,
  p_xml in out plx_sc.type_xdoc
  );

-- numStyleLink
procedure numStyleLink(
  p_tag varchar2 default t_numStyleLink,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- pict

procedure startpict(
  p_tag varchar2 default t_pict,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endpict(
  p_tag varchar2 default t_pict,
  p_xml in out plx_sc.type_xdoc
  );

-- control

procedure control(
  p_tag varchar2 default t_control,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null,
  p_name varchar2 default null,
  p_shapeid varchar2 default null
  );

-- movie

procedure movie(
  p_tag varchar2 default t_movie,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2
  );

-- pStyle
procedure pStyle(
  p_tag varchar2 default t_pStyle,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- start
procedure start_2(
  p_tag varchar2 default t_start,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- startOverride

procedure startOverride(
  p_tag varchar2 default t_startOverride,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- suff

procedure suff(
  p_tag varchar2 default t_suff,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- tmpl
procedure tmpl(
  p_tag varchar2 default t_tmpl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- legacy

procedure legacy(
  p_tag varchar2 default t_legacy,
  p_xml in out plx_sc.type_xdoc,
  p_legacy varchar2 default null,
  p_legacySpace varchar2 default null,
  p_legacyIndent varchar2 default null
  );

-- styleLink
procedure styleLink(
  p_tag varchar2 default t_styleLink,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
/************************************************************/
-- Create structure
----------------------------------------------
--Numbering:CT_Numbering
--create structure
function cr_numbering(
  p_tag varchar2 default t_numbering,
  p_numPicBullet CT_NumPicBullet default null,
  p_numIdMacAtCleanup ploffx_document_type.CT_DecimalNumber default null,
  p_abstractNum t_abstractNum_ default null,
  p_num t_num_ default null
  ) return CT_Numbering;

---------------------------------------------
--abstractNum:CT_AbstractNum
--create structure
function cr_abstractNum(
  p_tag varchar2 default t_abstractNum,
  p_name ploffx_document_type.CT_String default null,
  p_styleLink ploffx_document_type.CT_String default null,
  p_numStyleLink ploffx_document_type.CT_String default null,
  p_nsid ploffx_document_type.CT_LongHexNumber default null,
  p_multiLevelType CT_MultiLevelType default null,
  p_tmpl ploffx_document_type.CT_LongHexNumber default null,
  p_lvl t_lvl_ default null,
  p_abstractNumId plx_sc.normalv2
  ) return CT_AbstractNum;
-- abstractNum:t_abstractNum_
procedure add_AbstractNum(
  p_table in out t_abstractNum_,
  p_abstractNum CT_AbstractNum
  );
--- lvl:t_lvl_
procedure add_Lvl(
  p_table in out t_lvl_,
  p_lvl CT_Lvl
  );
---------------------------------------------
--num:CT_Num
--create structure
function cr_num(
  p_tag varchar2 default t_num,
  p_lvlOverride t_numLvl_ default null,
  p_abstractNumId ploffx_document_type.CT_DecimalNumber default null,
  p_numId plx_sc.normalv2
  ) return CT_Num;
-- num:t_num_
procedure add_Num(
  p_table in out t_num_,
  p_Num CT_Num
  );

---------------------------------------------
--numIdMacAtCleanup:CT_DecimalNumber
--create structure
function cr_numIdMacAtCleanup(
  p_tag varchar2 default t_numIdMacAtCleanup,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--numPicBullet:CT_NumPicBullet
--create structure
function cr_numPicBullet(
  p_tag varchar2 default t_numPicBullet,
  p_pict CT_Picture default null
  ) return CT_NumPicBullet;
----------------------------------------
--lvlText:CT_LevelText
--create structure
function cr_lvlText(
  p_tag varchar2 default t_lvlText,
  p_val varchar2 default null,
  p_null varchar2 default null
  ) return CT_LevelText;
---------------------------------------------
--lvl:CT_Lvl
--create structure
function cr_lvl(
  p_tag varchar2 default t_lvl,
  p_lvlrestart ploffx_document_type.CT_DecimalNumber default null,
  p_pStyle ploffx_document_type.CT_String default null,
  p_isLgl ploffx_document_type.CT_OnOff default null,
  p_suff CT_LevelSuffix default null,
  p_lvlPicBulletId ploffx_document_type.CT_DecimalNumber default null,
  p_legacy CT_LvlLegacy default null,
  p_start_ ploffx_document_type.CT_DecimalNumber default null,
  p_numFmt CT_NumFmt default null,
  p_lvlText CT_LevelText default null,
  p_lvlJc CT_Jc default null,
  p_pPr ploffx_document_type.CT_pPr default null,
  p_rPr ploffx_document_type.CT_rpr default null,
  p_ilvl plx_sc.normalv2 default null, -- ST_DecimalNumber
  p_tplc plx_sc.normalv2 default null, -- ST_LongHexNumber
  p_tentative plx_sc.normalv2 default null -- ST_OnOff
  ) return CT_Lvl;
----------------------------------------
--multiLevelType:CT_MultiLevelType
--create structure
function cr_multiLevelType(
  p_tag varchar2 default t_multiLevelType,
  p_val ST_MultiLevelType
  ) return CT_MultiLevelType;
---------------------------------------------
--name_:CT_String
--create structure
function cr_name(
  p_tag varchar2 default t_name,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
--------------------------------------
--nsid:CT_LongHexNumber
--create structure
function cr_nsid(
  p_tag varchar2 default t_nsid,
  p_val varchar2
  ) return ploffx_document_type.CT_LongHexNumber;
--styleLink:CT_String
--create structure
function cr_styleLink(
  p_tag varchar2 default t_styleLink,
  p_val varchar2
  ) return ploffx_document_type.CT_String;
----------------------------------------
--numStyleLink:CT_String
--create structure
function cr_numStyleLink(
  p_tag varchar2 default t_numStyleLink,
  p_val varchar2
  ) return ploffx_document_type.CT_String;
----------------------------------------
--tmpl:CT_LongHexNumber
--create structure
function cr_tmpl(
  p_tag varchar2 default t_tmpl,
  p_val varchar2
  ) return ploffx_document_type.CT_LongHexNumber;
---------------------------------------------
--abstractNumId:CT_DecimalNumber
--create structure
function cr_abstractNumId(
  p_tag varchar2 default t_abstractNumId,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--startOverride:CT_DecimalNumber
--create structure
function cr_startOverride(
  p_tag varchar2 default t_startOverride,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--control:CT_Control
--create structure
function cr_control(
  p_tag varchar2 default t_control,
  p_id plx_sc.normalv2,
  p_name plx_sc.normalv2,
  p_shapeid plx_sc.normalv2
  ) return CT_Control;
---------------------------------------------
--movie:CT_Rel
--create structure
function cr_movie(
  p_tag varchar2 default t_movie,
  p_id plx_sc.normalv2
  ) return ploffx_document_type.CT_Rel;
---------------------------------------------
--pict:CT_Picture
--create structure
function cr_pict(
  p_tag varchar2 default t_pict,
  p_control CT_Control default null,
  p_movie ploffx_document_type.CT_Rel default null
  ) return CT_Picture;
---------------------------------------------
--lvlOverride:CT_NumLvl
--create structure
function cr_lvlOverride(
  p_tag varchar2 default t_lvlOverride,
  p_lvl CT_Lvl,
  p_startOverride ploffx_document_type.CT_DecimalNumber,
  p_ilvl plx_sc.normalv2
  ) return CT_NumLvl;
---------------------------------------------
--isLgl:CT_OnOff
--create structure
function cr_isLgl(
  p_tag varchar2 default t_isLgl,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--suff:CT_LevelSuffix
--create structure
function cr_suff(
  p_tag varchar2 default t_suff,
  p_val ploffx_document_type.ST_LevelSuffix
  ) return CT_LevelSuffix;
---------------------------------------------
--legacy:CT_LvlLegacy
--create structure
function cr_legacy(
  p_tag varchar2 default t_legacy,
  p_legacy plx_sc.normalv2,
  p_legacySpace plx_sc.normalv2,
  p_legacyIndent plx_sc.normalv2
  ) return CT_LvlLegacy;
----------------------------------------
--lvlJc:CT_Jc
--create structure
function cr_lvlJc(
  p_tag varchar2 default t_lvlJc,
  p_val ploffx_document_type.ST_Align  --ST_Jc
  ) return CT_Jc;
---------------------------------------------
--lvlPicBulletId:CT_DecimalNumber
--create structure
function cr_lvlPicBulletId(
  p_tag varchar2 default t_lvlPicBulletId,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--lvlRestart:CT_DecimalNumber
--create structure
function cr_lvlRestart(
  p_tag varchar2 default t_lvlRestart,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_DecimalNumber;
----------------------------------------
--start:CT_DecimalNumber
--create structure
function cr_start_2(
  p_tag varchar2 default t_start,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--pStyle:CT_String
--create structure
function cr_pStyle(
  p_tag varchar2 default t_pStyle,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
----------------------------------------
--numFmt:CT_NumFmt
--create structure
function cr_numFmt(
  p_tag varchar2 default t_numFmt,
  p_val ploffx_document_type.ST_NumberFormat
  ) return CT_NumFmt;
---------------------------------------------

-- t_abstractNum_
function abstractNum_count(
  p_abstractNum_ t_abstractNum_
  ) return pls_integer;
---------------------------------------------

-- t_num_
function num_count(
  p_num_ t_num_
  ) return pls_integer;
/************************************************************/
-- Generate XML parts
----------------------------------------------
--Numbering:CT_Numbering
--generate xml part
procedure gen_numbering(
  p_xml in out plx_sc.type_xdoc,
  p_numbering CT_Numbering
  );
---------------------------------------------
--abstractNum:CT_AbstractNum
--generate xml part
procedure gen_abstractNum(
  p_xml in out plx_sc.type_xdoc,
  p_abstractNum CT_AbstractNum
  );
---------------------------------------------
--num:CT_Num
--generate xml part
procedure gen_num(
  p_xml in out plx_sc.type_xdoc,
  p_num CT_Num
  );
---------------------------------------------
--numIdMacAtCleanup:CT_DecimalNumber
--generate xml part
procedure gen_numIdMacAtCleanup(
  p_xml in out plx_sc.type_xdoc,
  p_numIdMacAtCleanup ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--numPicBullet:CT_NumPicBullet
--generate xml part
procedure gen_numPicBullet(
  p_xml in out plx_sc.type_xdoc,
  p_numPicBullet CT_NumPicBullet
  );
---------------------------------------------
--lvl:CT_Lvl
--generate xml part
procedure gen_lvl(
  p_xml in out plx_sc.type_xdoc,
  p_lvl CT_Lvl
  );
----------------------------------------
--multiLevelType:CT_MultiLevelType
--generate xml part
procedure gen_multiLevelType(
  p_xml in out plx_sc.type_xdoc,
  p_multiLevelType CT_MultiLevelType
  );
---------------------------------------------
--generate xml part
procedure gen_name(
  p_xml in out plx_sc.type_xdoc,
  p_name ploffx_document_type.CT_String
  );
----------------------------------------
--nsid:CT_LongHexNumber
--generate xml part
procedure gen_nsid(
  p_xml in out plx_sc.type_xdoc,
  p_nsid ploffx_document_type.CT_LongHexNumber
  );
----------------------------------------
--styleLink:CT_String
--generate xml part
procedure gen_styleLink(
  p_xml in out plx_sc.type_xdoc,
  p_styleLink ploffx_document_type.CT_String
  );
----------------------------------------
--numStyleLink:CT_String
--generate xml part
procedure gen_numStyleLink(
  p_xml in out plx_sc.type_xdoc,
  p_numStyleLink ploffx_document_type.CT_String
  );
----------------------------------------
--tmpl:CT_LongHexNumber
--generate xml part
procedure gen_tmpl(
  p_xml in out plx_sc.type_xdoc,
  p_tmpl ploffx_document_type.CT_LongHexNumber
  );
---------------------------------------------
--abstractNumId:CT_DecimalNumber
--generate xml part
procedure gen_abstractNumId(
  p_xml in out plx_sc.type_xdoc,
  p_abstractNumId ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--lvlOverride:CT_NumLvl
--generate xml part
procedure gen_lvlOverride(
  p_xml in out plx_sc.type_xdoc,
  p_lvlOverride CT_NumLvl
  );
---------------------------------------------
--pict:CT_Picture
--generate xml part
procedure gen_pict(
  p_xml in out plx_sc.type_xdoc,
  p_pict CT_Picture
  );
---------------------------------------------
--control:CT_Control
--generate xml part
procedure gen_control(
  p_xml in out plx_sc.type_xdoc,
  p_control CT_Control
  );
---------------------------------------------
--movie:CT_Rel
--generate xml part
procedure gen_movie(
  p_xml in out plx_sc.type_xdoc,
  p_movie ploffx_document_type.CT_Rel
  );
---------------------------------------------
--startOverride:CT_DecimalNumber
--generate xml part
procedure gen_startOverride(
  p_xml in out plx_sc.type_xdoc,
  p_startOverride ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--isLgl:CT_OnOff
--generate xml part
procedure gen_isLgl(
  p_xml in out plx_sc.type_xdoc,
  p_isLgl ploffx_document_type.CT_OnOff
  );
---------------------------------------------
--suff:CT_LevelSuffix
--generate xml part
procedure gen_suff(
  p_xml in out plx_sc.type_xdoc,
  p_suff CT_LevelSuffix
  );
---------------------------------------------
--legacy:CT_LvlLegacy
--generate xml part
procedure gen_legacy(
  p_xml in out plx_sc.type_xdoc,
  p_legacy CT_LvlLegacy
  );
----------------------------------------
--lvlJc:CT_Jc
--generate xml part
procedure gen_lvlJc(
  p_xml in out plx_sc.type_xdoc,
  p_lvlJc CT_Jc
  );
----------------------------------------
--lvlText:CT_LevelText
--generate xml part
procedure gen_lvlText(
  p_xml in out plx_sc.type_xdoc,
  p_levelText CT_LevelText
  );
---------------------------------------------
--lvlPicBulletId:CT_DecimalNumber
--generate xml part
procedure gen_lvlPicBulletId(
  p_xml in out plx_sc.type_xdoc,
  p_lvlPicBulletId ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--lvlRestart:CT_DecimalNumber
--generate xml part
procedure gen_lvlRestart(
  p_xml in out plx_sc.type_xdoc,
  p_lvlRestart ploffx_document_type.CT_DecimalNumber
  );
----------------------------------------
--start:CT_DecimalNumber
--generate xml part
procedure gen_start_2(
  p_xml in out plx_sc.type_xdoc,
  p_start ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--pStyle:CT_String
--generate xml part
procedure gen_pStyle(
  p_xml in out plx_sc.type_xdoc,
  p_pStyle ploffx_document_type.CT_String
  );
----------------------------------------
--numFmt:CT_NumFmt
--generate xml part
procedure gen_numFmt(
  p_xml in out plx_sc.type_xdoc,
  p_numFmt CT_NumFmt
  );

-- GEN_XML
procedure gen_xml(
  p_numbering CT_Numbering
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse
-- v3.0.0
function parse(
  p_file clob
  ) return CT_Numbering;


procedure docx_numbering_init(
  p_numbering in out CT_Numbering
);
-- v3.0.0
function docx_numbering_init_symbol(
    p_startValue pls_integer,
    p_abstractNumId pls_integer
  ) return CT_AbstractNum;
-- v3.0.0
function docx_numbering_init_arabic(
    p_startValue pls_integer,
    p_abstractNumId pls_integer
  ) return CT_AbstractNum;
-- v3.0.0
function docx_numbering_init_multilevel(
    p_startValue pls_integer,
    p_abstractNumId pls_integer
  ) return CT_AbstractNum;

end ploffx_numbering;
/

