create or replace package ploffx_headerfooter
authid current_user is
--v5.9
--
-- Namespace
ns_ve constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
ns_o constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:office';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_m constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/math';
ns_v constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:vml';
ns_wp constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing';
ns_w10 constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:word';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_wne constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2006/wordml';

-- Prefixes
ns_ve_pref constant varchar2(3 char) := 've';
ns_o_pref constant varchar2(3 char) := 'o';
ns_r_pref constant varchar2(3 char) := 'r';
ns_m_pref constant varchar2(3 char) := 'm';
ns_v_pref constant varchar2(3 char) := 'v';
ns_wp_pref constant varchar2(3 char) := 'wp';
ns_w10_pref constant varchar2(3 char) := 'w10';
ns_w_pref constant varchar2(3 char) := 'w';
ns_wne_pref constant varchar2(3 char) := 'wne';

-- XML
g_xml_header_default plx_sc.type_xdoc;
g_xml_header_even plx_sc.type_xdoc;
g_xml_header_first plx_sc.type_xdoc;
g_xml_footer_default plx_sc.type_xdoc;
g_xml_footer_even plx_sc.type_xdoc;
g_xml_footer_first plx_sc.type_xdoc;

-- Tag
t_hdr constant plx_sc.normalv2 := 'hdr';
t_ftr constant plx_sc.normalv2 := 'ftr';
t_p constant plx_sc.normalv2 := 'p';

-- Constants

/************************************************************/
--Structures
-- v1.3.0

-- CT_HdrFtr
type CT_HdrFtr is record(
  tag plx_sc.normalv2,
  blocks ploffx_document_type.t_blocks,
  filename plx_sc.normalv2
  );


-- XT_hdrftrs
type XT_HdrFtr is record(
  header_default CT_HdrFtr, -- ploffx_document_type.t_blocks,
  header_even CT_HdrFtr, -- ploffx_document_type.t_blocks,
  header_first CT_HdrFtr, -- ploffx_document_type.t_blocks,
  --
  footer_default CT_HdrFtr, -- ploffx_document_type.t_blocks,
  footer_even CT_HdrFtr, -- ploffx_document_type.t_blocks,
  footer_first CT_HdrFtr -- ploffx_document_type.t_blocks
  );

-- XT_hdrftrs
type XT_HdrFtrs is table of XT_HdrFtr;
v_hdrftrs_empty XT_HdrFtrs := XT_HdrFtrs();

--subtype CT_HdrFtr is ploffx_document_type.t_blocks;
-- original: v_contents_empty CT_HdrFtr := ploffx_document_type.t_blocks();
v_contents_empty ploffx_document_type.t_blocks := ploffx_document_type.v_blocks_empty;

--
/************************************************************/

-- start_
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end_
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );

-- hdr
procedure starthdr(
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endhdr(
  p_xml in out plx_sc.type_xdoc
  );

-- ftr
procedure startftr(
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endftr(
  p_xml in out plx_sc.type_xdoc
  );

/************************************************************/
-- Create structure

---------------------------------------------
--hdr:CT_HdrFtr
--v1.3.0
function cr_hdr(
  p_tag varchar2 default t_hdr,
  p_blocks ploffx_document_type.t_blocks
  ) return CT_HdrFtr;

---------------------------------------------
--ftr:CT_HdrFtr
--v1.3.0
function cr_ftr(
  p_tag varchar2 default t_ftr,
  p_blocks ploffx_document_type.t_blocks
  ) return CT_HdrFtr;


/************************************************************/
-- Generate XML parts

---------------------------------------------
--hdr:CT_HdrFtr
--v3.0.0
procedure gen_hdr(
  p_xml in out plx_sc.type_xdoc,
  p_hdr CT_HdrFtr
  );

---------------------------------------------
--ftr:CT_HdrFtr
--v3.0.0
procedure gen_ftr(
  p_xml in out plx_sc.type_xdoc,
  p_ftr CT_HdrFtr
  );

-- GEN_XML
/*procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_header boolean,
  p_hdrftr CT_HdrFtr
  );*/

-- GEN_XML
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_hdrftr CT_HdrFtr
  );

-- GEN_HEADER_FOOTER
procedure gen_header_footer(
  p_xml in out plx_sc.type_xdoc,
  p_headerfooters XT_HdrFtrs
  );

/************************************************************/
-- Parse and preprocessed parts

--
end ploffx_headerfooter;
/

