create or replace package ploffx_fonttable
authid current_user is
--v5.9
--
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';

-- Prefixes
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_w_pref constant varchar2(1 char) := 'w';
ns_r_pref constant varchar2(1 char) := 'r';
ns_mc_pref constant varchar2(2 char) := 'mc';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_charset constant plx_sc.normalv2 := 'charset';
t_family constant plx_sc.normalv2 := 'family';
t_font constant plx_sc.normalv2 := 'font';
t_fonts constant plx_sc.normalv2 := 'fonts';
t_notTrueType constant plx_sc.normalv2 := 'notTrueType';
t_panose1 constant plx_sc.normalv2 := 'panose1';
t_pitch constant plx_sc.normalv2 := 'pitch';
t_sig constant plx_sc.normalv2 := 'sig';

-- Constants
c_filename constant plx_sc.normalv2 := 'word/fontTable.xml';

/******************************************************************/
--Structures
--v1.3.0

-- CT_Panose
type CT_Panose is record (
     tag plx_sc.normalv2,
     val plx_sc.normalv2 --hexBinary
);

-- ST_Charset
subtype ST_Charset is ploffx_util.t_string;
c_00 constant ST_Charset := '00'; -- 0x00: Specifies the ANSI character set.
c_01 constant ST_Charset := '01'; -- 0x01: Specifies the default character set.
c_02 constant ST_Charset := '02'; -- 0x02: Specifies the Symbol character set.
c_4D constant ST_Charset := '4D'; -- 0x4D: Specifies a Macintosh (Standard Roman) character set.
c_80 constant ST_Charset := '80'; -- 0x80: Specifies the JIS character set.
c_81 constant ST_Charset := '81'; -- 0x81: Specifies the Hangul character set.
c_82 constant ST_Charset := '82'; -- 0x82: Specifies a Johab character set.
c_86 constant ST_Charset := '86'; -- 0x86: Specifies the GB-2312 character set.
c_88 constant ST_Charset := '88'; -- 0x88: Specifies the Chinese Big Five character set.
c_A1 constant ST_Charset := 'A1'; -- 0xA1: Specifies a Greek character set.
c_A2 constant ST_Charset := 'A2'; -- 0xA2: Specifies a Turkish character set.
c_A3 constant ST_Charset := 'A3'; -- 0xA3: Specifies a Vietnamese character set.
c_B1 constant ST_Charset := 'B1'; -- 0xB1: Specifies a Hebrew character set.
c_B2 constant ST_Charset := 'B2'; -- 0xB2: Specifies an Arabic character set.
c_BA constant ST_Charset := 'BA'; -- 0xBA: Specifies a Baltic character set.
c_CC constant ST_Charset := 'CC'; -- 0xCC: Specifies a Russian character set.
c_DE constant ST_Charset := 'DE'; -- 0xDE: Specifies a Thai character set.
c_EE constant ST_Charset := 'EE'; -- 0xEE: Specifies an Eastern European character set.
c_FF constant ST_Charset := 'FF'; -- 0xFF: Specifies an OEM character set not defined by this Office Open XML Standard.
-- Any other value Application-defined, may be ignored.

-- CT_Charset
type CT_Charset is record (
  tag plx_sc.normalv2,
  val ST_Charset
  );

-- ST_FontFamily
subtype ST_FontFamily is ploffx_util.t_string;
c_decorative constant ST_FontFamily := 'decorative'; --Specifies the Novelty font family.
c_modern constant ST_FontFamily := 'modern'; --Specifies a monospace font with or without serifs
c_roman constant ST_FontFamily := 'roman'; --Specifies a proportional font with serifs.
c_script constant ST_FontFamily := 'script'; --Specifies a script font designed to mimic the appearance of handwriting.
c_swiss constant ST_FontFamily := 'swiss'; --Specifies a proportional font without serifs.
c_auto constant ST_FontFamily := 'auto'; --Specifies that information about a font's font family does not exist.

-- CT_FontFamily
type CT_FontFamily is record (
  tag plx_sc.normalv2,
  val ST_FontFamily
  );

-- ST_Pitch
subtype ST_Pitch is ploffx_util.t_string;
c_fixed constant ST_FontFamily := 'fixed'; --Specifies that this is a fixed width font.
c_variable constant ST_FontFamily := 'variable'; --Specifies that this is a proportional width font.
c_default constant ST_FontFamily := 'default'; -- Specifies that no information is available about the pitch of a font.

-- CT_Pitch
type CT_Pitch is record (
  tag plx_sc.normalv2,
  val ST_Pitch
  );

-- CT_FontSig
type CT_FontSig is record (
  tag plx_sc.normalv2,
  usb0 plx_sc.normalv2, --First 32 Bits of Unicode Subset Bitfield - ST_LongHexNumber
  usb1 plx_sc.normalv2, --Seconf 32 Bits of Unicode Subset Bitfield - ST_LongHexNumber
  usb2 plx_sc.normalv2, --Third 32 Bits of Unicode Subset Bitfield - ST_LongHexNumber
  usb3 plx_sc.normalv2, --Fourth 32 Bits of Unicode Subset Bitfield - ST_LongHexNumber
  csb0 plx_sc.normalv2, -- Lower 32 Bits of Code Page Bit Field - ST_LongHexNumber
  csb1 plx_sc.normalv2  -- Upper 32 Bits of Code Page Bit Field - ST_LongHexNumber
  );

-- CT_FontRel
type CT_FontRel is record (
  tag plx_sc.normalv2,
  fontKey plx_sc.normalv2, -- Embedded Font Obfuscation Key
  id plx_sc.normalv2, -- Relationship to Part -- CT_Rel
  subsetted plx_sc.normalv2 -- Embedded Font Is Subsetted
  );

-- CT_Font
type CT_Font is record (
  tag plx_sc.normalv2,
  name plx_sc.normalv2, -- Primary Font Name - s:ST_String
  altName ploffx_document_type.CT_String, --Alternate Names for Font
  panose1 CT_Panose, --Pansose-1 Typeface Classification Number
  charset CT_Charset, --Character Set Supported By Font
  family CT_FontFamily, --Font Family
  notTrueType ploffx_document_type.CT_OnOff, --Raster or Vector Font
  pitch CT_Pitch, --Font Pitch
  sig CT_FontSig, --Supported Unicode Subranges and Code Pages
  embedRegular CT_FontRel, --Regular Font Style Embedding
  embedBold CT_FontRel, --Bold Style Font Style Embedding
  embedItalic CT_FontRel, --Italic Font Style Embedding
  embedBoldItalic CT_FontRel --Bold Italic Font Style Embedding
  );
-- t_fonts_
type t_fonts_ is table of CT_Font;
v_fonts_empty t_fonts_ := t_fonts_();


-- CT_FontsList
type CT_FontsList is record(
  tag plx_sc.normalv2,
  font t_fonts_
  );

/************************************************************/

-- start
procedure start_;
-- end
procedure end_;

-- charset
procedure charset(
  p_tag varchar2 default t_charset,
  p_val varchar2
  );

-- family
procedure family(
  p_tag varchar2 default t_family,
  p_val varchar2
  );

-- font
procedure startfont(
  p_tag varchar2 default t_font,
  p_name varchar2
  );
--
procedure endfont;

-- fonts
procedure startfonts;
--
procedure endfonts;

-- notTrueType
procedure notTrueType(
  p_tag varchar2 default t_notTrueType,
  p_val varchar2 default null
  );

-- panose1
procedure panose1(
  p_tag varchar2 default t_panose1,
  p_val varchar2
  );

-- pitch
procedure pitch(
  p_tag varchar2 default t_pitch,
  p_val varchar2
  );

-- sig
procedure sig(
  p_tag varchar2 default t_sig,
  p_usb0 varchar2 default null,
  p_usb1 varchar2 default null,
  p_usb2 varchar2 default null,
  p_usb3 varchar2 default null,
  p_csb0 varchar2 default null,
  p_csb1 varchar2 default null
  );

/************************************************************/
-- Create structure
--v1.3.0

---------------------------------------------
--panose1:CT_Panose
-- v1.3.0
function cr_panose1(
  p_tag varchar2 default t_panose1,
  p_val varchar2 default null
  ) return CT_Panose;

---------------------------------------------
--charset:CT_Charset
-- v1.3.0
function cr_charset(
  p_tag varchar2 default t_charset,
  p_val varchar2 default null
  ) return CT_Charset;

---------------------------------------------
--family:CT_FontFamily
-- v1.3.0
function cr_family(
  p_tag varchar2 default t_family,
  p_val varchar2 default null
  ) return CT_FontFamily;

---------------------------------------------
--notTrueType:CT_OnOff
-- v1.3.0
function cr_notTrueType(
  p_tag varchar2 default t_notTrueType,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;

---------------------------------------------
--pitch:CT_Pitch
-- v1.3.0
function cr_pitch(
  p_tag varchar2 default t_pitch,
  p_val varchar2 default null
  ) return CT_Pitch;

---------------------------------------------
--sig:CT_FontSig
-- v1.3.0
function cr_sig(
  p_tag varchar2 default t_sig,
  p_usb0 varchar2 default null,
  p_usb1 varchar2 default null,
  p_usb2 varchar2 default null,
  p_usb3 varchar2 default null,
  p_csb0 varchar2 default null,
  p_csb1 varchar2 default null
  ) return CT_FontSig;

---------------------------------------------
--font:CT_Font
-- v1.3.0
function cr_font(
  p_tag varchar2 default t_font,
  p_name varchar2 default null,
  -- altName
  p_panose1 CT_Panose default null,
  p_charset CT_Charset default null,
  p_family CT_FontFamily default null,
  -- notTrueType
  p_pitch CT_Pitch default null,
  p_sig CT_FontSig default null
  -- embedRegular CT_FontRel
  -- embedBold CT_FontRel
  -- embedItalic CT_FontRel
  -- embedBoldItalic CT_FontRel
  ) return CT_Font;

---------------------------------------------
--fonts:CT_FontsList
-- v1.3.0
function cr_fonts(
  p_tag varchar2 default t_fonts,
  p_font t_fonts_ default null
  ) return CT_FontsList;


/************************************************************/
-- Generate XML parts

---------------------------------------------
--panose1:CT_Panose
-- v1.3.0
procedure gen_panose1(
  p_panose1 CT_Panose
  );

---------------------------------------------
--charset:CT_Charset
-- v1.3.0
procedure gen_charset(
  p_charset CT_Charset
  );

---------------------------------------------
--family:CT_FontFamily
-- v1.3.0
procedure gen_family(
  p_family CT_FontFamily
  );

---------------------------------------------
--notTrueType:CT_OnOff
-- v1.3.0
procedure gen_notTrueType(
  p_notTrueType ploffx_document_type.CT_OnOff
  );

---------------------------------------------
--pitch:CT_Pitch
-- v1.3.0
procedure gen_pitch(
  p_pitch CT_Pitch
  );

---------------------------------------------
--sig:CT_FontSig
-- v1.3.0
procedure gen_sig(
  p_sig CT_FontSig
  );

---------------------------------------------
--font:CT_Font
-- v1.3.0
procedure gen_font(
  p_font CT_Font
  );

---------------------------------------------
--fonts:CT_FontsList
-- v1.3.0
procedure gen_fonts(
  p_fonts CT_FontsList
  );

-- add_fonts
procedure add_fonts(
  p_table in out t_fonts_,
  p_font CT_Font
  );

-- GEN_XML
procedure gen_xml(
  p_fonts CT_FontsList
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse
--v1.3.0
function parse(
  p_file clob
  ) return ploffx_fonttable.CT_FontsList;

--v1.3.0
procedure docx_fontTable_init(
  p_fonts in out CT_FontsList
  );

--
end ploffx_fonttable;
/

