create or replace package ploffx_drawing
authid current_user is
--v5.9
--
--Namespaces
ns_xdr constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing';
ns_a constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';

-- Prefixes
ns_xdr_pref constant varchar2(3 char) := 'xdr';
ns_a_pref   constant varchar2(1 char) := 'a';
ns_r_pref   constant varchar2(1 char) := 'r';

-- Tag
t_absoluteAnchor constant plx_sc.normalv2 := 'absoluteAnchor';
t_blipFill constant plx_sc.normalv2 := 'blipFill';
t_clientData constant plx_sc.normalv2 := 'clientData';
t_cNvCxnSpPr constant plx_sc.normalv2 := 'cNvCxnSpPr';
t_cNvGraphicFramePr constant plx_sc.normalv2 := 'cNvGraphicFramePr';
t_cNvGrpSpPr constant plx_sc.normalv2 := 'cNvGrpSpPr';
t_cNvPicPr constant plx_sc.normalv2 := 'cNvPicPr';
t_cNvPr constant plx_sc.normalv2 := 'cNvPr';
t_cNvSpPr constant plx_sc.normalv2 := 'cNvSpPr';
t_col constant plx_sc.normalv2 := 'col';
t_colOff constant plx_sc.normalv2 := 'colOff';
t_cxnSp constant plx_sc.normalv2 := 'cxnSp';
t_ext constant plx_sc.normalv2 := 'ext';
t_from constant plx_sc.normalv2 := 'from';
t_gd constant plx_sc.normalv2 := 'gd';
t_graphicFrame constant plx_sc.normalv2 := 'graphicFrame';
t_grpSP constant plx_sc.normalv2 := 'grpSP';
t_grpSpPr constant plx_sc.normalv2 := 'grpSpPr';
t_nvCxnSpPr constant plx_sc.normalv2 := 'nvCxnSpPr';
t_nvGraphicFramePr constant plx_sc.normalv2 := 'nvGraphicFramePr';
t_nvGrpSpPr constant plx_sc.normalv2 := 'nvGrpSpPr';
t_nvPicPr constant plx_sc.normalv2 := 'nvPicPr';
t_nvSpPr constant plx_sc.normalv2 := 'nvSpPr';
t_oneCellAnchor constant plx_sc.normalv2 := 'oneCellAnchor';
t_pic constant plx_sc.normalv2 := 'pic';
t_pos constant plx_sc.normalv2 := 'pos';
t_row constant plx_sc.normalv2 := 'row';
t_rowOff constant plx_sc.normalv2 := 'rowOff';
t_sp constant plx_sc.normalv2 := 'sp';
t_spPr constant plx_sc.normalv2 := 'spPr';
t_style constant plx_sc.normalv2 := 'style';
t_to constant plx_sc.normalv2 := 'to';
t_twoCellAnchor constant plx_sc.normalv2 := 'twoCellAnchor';
t_txBody constant plx_sc.normalv2 := 'txBody';
t_wsDr constant plx_sc.normalv2 := 'wsDr';
t_xfrm constant plx_sc.normalv2 := 'xfrm';
t_picLocks constant plx_sc.normalv2 := 'picLocks';
t_blip constant plx_sc.normalv2 := 'blip';
t_stretch constant plx_sc.normalv2 := 'stretch';
t_fillRect constant plx_sc.normalv2 := 'fillRect';
t_off constant plx_sc.normalv2 := 'off';
t_prstGeom constant plx_sc.normalv2 := 'prstGeom';
t_avLst constant plx_sc.normalv2 := 'avLst';

-- XML
g_xml plx_sc.type_xdoc;

/******************************************************************/
--Structures

-- ST_BlipCompression
subtype ST_BlipCompression is plx_sc.normalv2;
c_email constant ST_BlipCompression := 'email';
c_screen constant ST_BlipCompression := 'screen';
c_print constant ST_BlipCompression := 'print';
c_hqprint constant ST_BlipCompression := 'hqprint';
c_none constant ST_BlipCompression := 'none';

-- ST_ShapeType
subtype ST_ShapeType is plx_sc.normalv2;
--line
--lineInv
--triangle
--rtTriangle
c_rect constant ST_ShapeType := 'rect';
--diamond
---....

-- ST_EditAs
subtype ST_EditAs is plx_sc.normalv2;
c_twoCell constant ST_EditAs := 'twoCell';
c_oneCell constant ST_EditAs := 'oneCell';
c_absolute constant ST_EditAs := 'absolute';

-- CT_Normalv2 (logical type)
type CT_Normalv2 is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );

-- CT_Marker (anchor point)
type CT_Marker is record (
  tag plx_sc.normalv2,
  col CT_Normalv2, --ST_ColID -- pls_integer,
  colOff CT_Normalv2, --ST_Coordinate --  number, --Column Offset
  row CT_Normalv2, --ST_RowID --  pls_integer,
  rowOff CT_Normalv2 --ST_Coordinate --  number
  );

-- CT_PictureLocking
type CT_PictureLocking is record (
  tag plx_sc.normalv2,
  --extLst
  --noAdjustHandles
  --noChangeArrowheads
  noChangeAspect plx_sc.normalv2 -- xsd:boolean
  --noChangeShapeType
  --noCrop
  --noEditPoints
  --noGrp
  --noMove
  --noResize
  --noRot
  --noSelect
  );

-- CT_NonVisualPictureProperties
type CT_NonVisualPictureProperties is record (
  tag plx_sc.normalv2,
  -- extLst
  picLocks CT_PictureLocking
  --preferRelativeResize xsd:boolean
  );


-- CT_NonVisualDrawingProps
type CT_NonVisualDrawingProps is record (
  tag plx_sc.normalv2,
  --extLst
  --hlinkClick
  --hlinkHover
  descr plx_sc.maxv2, --string
  --hidden
  id plx_sc.normalv2,
  name plx_sc.normalv2
  );

-- CT_PictureNonVisual
type CT_PictureNonVisual is record (
  tag plx_sc.normalv2,
  cNvPicPr CT_NonVisualPictureProperties,
  cNvPr CT_NonVisualDrawingProps
  );

-- CT_Blip
type CT_Blip is record (
  tag plx_sc.normalv2,
  --alphaBiLevel
  --alphaCeiling
  --alphaFloor
  --alphaInv
  --alphaMod
  --alphaModFix
  --alphaRepl
  --biLevel
  --blur
  --clrChange
  --clrRepl
  --duotone
  --extLst
  --fillOverlay
  --grayscl
  --hsl
  --lum
  --tint
  cstate ST_BlipCompression,
  embed plx_sc.normalv2 --ST_RelationshipId
  );

-- CT_RelativeRect
type CT_RelativeRect is record (
  tag plx_sc.normalv2,
  b plx_sc.normalv2, --ST_Percentage
  l plx_sc.normalv2, --ST_Percentage
  r plx_sc.normalv2, --ST_Percentage
  t plx_sc.normalv2 --ST_Percentage
  );

-- CT_StretchInfoProperties
type CT_StretchInfoProperties is record (
  tag plx_sc.normalv2,
  fillRect CT_RelativeRect
  );

-- CT_BlipFillProperties
type CT_BlipFillProperties is record (
  tag plx_sc.normalv2,
  blip CT_Blip,
  --srcRect
  stretch CT_StretchInfoProperties
  --tile
  --dpi
  --rotWithShape
  );

-- CT_Point2D
type CT_Point2D is record (
  tag plx_sc.normalv2,
  x plx_sc.normalv2, --ST_Coordinate
  y plx_sc.normalv2  --ST_Coordinate
  );

-- CT_PositiveSize2D
type CT_PositiveSize2D is record (
  tag plx_sc.normalv2,
  cx plx_sc.normalv2, --ST_PositiveCoordinate
  cy plx_sc.normalv2 --ST_PositiveCoordinate
  );

-- CT_Transform2D
type CT_Transform2D is record (
  tag plx_sc.normalv2,
  ext CT_PositiveSize2D,
  off CT_Point2D
  --flipH
  --flipV
  --rot
  );

-- CT_GeomGuide
type CT_GeomGuide is record (
  tag plx_sc.normalv2,
  fmla plx_sc.normalv2,
  name_ plx_sc.normalv2
  );
-- t_gd_
type t_gd_ is table of CT_GeomGuide;
v_gd_empty t_gd_ := t_gd_();


-- CT_GeomGuideList
type CT_GeomGuideList is record (
  tag plx_sc.normalv2,
  gd CT_GeomGuide
  );

-- CT_PresetGeometry2D
type CT_PresetGeometry2D is record (
  tag plx_sc.normalv2,
  avLst CT_GeomGuideList,
  prst ST_ShapeType
  );

-- CT_ShapeProperties
type CT_ShapeProperties is record (
  tag plx_sc.normalv2,
  --blipFill
  --custGeom
  --effectDag
  --effectLst
  --extLst
  --gradFill
  --grpFill
  --ln
  --noFill
  --pattFill
  prstGeom CT_PresetGeometry2D,
  --scene3d
  --solidFill
  --sp3d
  xfrm CT_Transform2D
  --bwMode
  );

-- CT_Picture
type CT_Picture is record (
  tag plx_sc.normalv2,
  blipFill CT_BlipFillProperties,
  nvPicPr CT_PictureNonVisual,
  spPr CT_ShapeProperties
  --style
  --fPublished
  --macro
  );

-- CT_AnchorClientData
type CT_AnchorClientData is record (
  tag plx_sc.normalv2,
  fLocksWithSheet plx_sc.normalv2, --boolean
  fPrintsWithSheet plx_sc.normalv2 --boolean
  );

-- CT_TwoCellAnchor
type CT_TwoCellAnchor is record (
  tag plx_sc.normalv2,
  clientData CT_AnchorClientData,
  -- cxnSp
  from_ CT_Marker,
  -- graphicFrame
  -- grpSp
  pic CT_Picture,
  -- sp
  to_ CT_Marker,
  editAs ST_EditAs
  );

-- EG_Anchor
type EG_Anchor is record (
  -- absoluteAnchor
  -- oneCellAnchor
  twoCellAnchor CT_TwoCellAnchor
  );

-- EG_Anchors
type EG_Anchors is table of EG_Anchor;
v_anchors_empty EG_Anchors := EG_Anchors();

-- CT_Drawing (wsDr)
type CT_Drawing is record (
  tag plx_sc.normalv2, --wsDr
  anchors EG_Anchors
  -- image blob,
  -- name varchar2(255 char), -- with extension
  -- width number,
  -- height number,
  -- descr varchar2(255 char)
  );

-- type t_drawings is table of CT_drawing;
--v_drawings_empty t_drawings := t_drawings();

/******************************************************************/
-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );

-- absoluteAnchor
procedure startabsoluteAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_absoluteAnchor
  );
--
procedure endabsoluteAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_absoluteAnchor
  );

--blipFill
procedure startblipFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_blipFill,
  p_dpi  varchar2 default null,
  p_rotWithShape  varchar2 default null
  );
--
procedure endblipFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_blipFill
  );

--clientData
procedure clientData(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_clientData,
  p_fLocksWithSheet varchar2 default null,
  p_fPrintsWithSheet varchar2 default null
  );

--cNvCxnSpPr
procedure startcNvCxnSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvCxnSpPr
  );
--
procedure endcNvCxnSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvCxnSpPr
  );

--cNvGraphicFramePr
procedure startcNvGraphicFramePr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvGraphicFramePr
  );
--
procedure endcNvGraphicFramePr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvGraphicFramePr
  );

-- cNvGrpSpPr
procedure startcNvGrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvGrpSpPr
  );
--
procedure endcNvGrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvGrpSpPr
  );

-- cNvPicPr
procedure startcNvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvPicPr,
  p_preferRelativeResize varchar2 default null
  );
--
procedure endcNvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvPicPr
  );

-- cNvPr
procedure cNvPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvPr,
  p_descr varchar2  default null,
  p_hidden varchar2 default null,
  p_id varchar2,
  p_name varchar2
  );

-- cNvSpPr
procedure startcNvSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvSpPr,
  p_txBox varchar2 default null
  );
--
procedure endcNvSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cNvSpPr
  );

-- col
procedure startcol(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_col
  );
--
procedure endcol(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_col
  );

-- colOff
procedure startcolOff(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_colOff
  );
--
procedure endcolOff(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_colOff
  );

--cxnSp
procedure startcxnSp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cxnSp,
  p_fPublished varchar2 default null,
  p_macro varchar2 default null
  );
--
procedure endcxnSp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cxnSp
  );

-- ext
procedure ext(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ext,
  p_cx varchar2,
  p_cy varchar2
  );

-- from
procedure startfrom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_from
  );
--
procedure endfrom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_from
  );

-- graphicFrame
procedure startgraphicFrame(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_graphicFrame,
  p_fPublished varchar2 default null,
  p_macro varchar2 default null
  );
--
procedure endgraphicFrame(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_graphicFrame
  );

-- grpSP
procedure startgrpSP(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_grpSP
  );
--
procedure endgrpSP(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_grpSP
  );

-- grpSpPr
procedure startgrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_grpSpPr,
  p_bwMode varchar2 default null
  );
--
procedure endgrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_grpSpPr
  );

-- nvCxnSpPr
procedure startnvCxnSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvCxnSpPr
  );
--
procedure endnvCxnSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvCxnSpPr
  );

-- nvGraphicFramePr
procedure startnvGraphicFramePr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvGraphicFramePr
  );
--
procedure endnvGraphicFramePr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvGraphicFramePr
  );

-- nvGrpSpPr
procedure startnvGrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvGrpSpPr
  );
--
procedure endnvGrpSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvGrpSpPr
  );

-- nvPicPr
procedure startnvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvPicPr
  );
--
procedure endnvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvPicPr
  );

-- nvSpPr
procedure startnvSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvSpPr
  );
--
procedure endnvSpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_nvSpPr
  );

-- oneCellAnchor
procedure startoneCellAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_oneCellAnchor
  );
--
procedure endoneCellAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_oneCellAnchor
  );

-- pic
procedure startpic(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pic,
  p_fPublished varchar2 default null,
  p_macro varchar2 default null
  );
--
procedure endpic(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pic
  );

-- pos
procedure pos(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pos,
  p_x varchar2,
  p_y varchar2
  );

-- row
procedure startrow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_row
  );
--
procedure endrow(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_row
  );

-- rowOff
procedure startrowOff(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_rowOff
  );
--
procedure endrowOff(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_rowOff
  );

-- sp
procedure startsp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_sp,
  p_fLocksText varchar2 default null,
  p_fPublished varchar2 default null,
  p_macro varchar2 default null,
  p_textlink varchar2 default null
  );
--
procedure endsp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_sp
  );

-- spPr
procedure startspPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_spPr,
  p_bwMode varchar2 default null
  );
--
procedure endspPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_spPr
  );

-- style
procedure startstyle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_style
  );
--
procedure endstyle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_style
  );

-- to
procedure startto(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_to
  );
--
procedure endto(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_to
  );

-- txBody
procedure starttxBody(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_txBody
  );
--
procedure endtxBody(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_txBody
  );

-- wsDr
procedure startwsDr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_wsDr
  );
--
procedure endwsDr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_wsDr
  );

-- xfrm
procedure startxfrm(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xfrm,
  p_flipH varchar2 default null,
  p_flipV varchar2 default null,
  p_rot varchar2 default null
  );
--
procedure endxfrm(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xfrm
  );

-- twoCellAnchor
procedure starttwoCellAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_twoCellAnchor,
  p_editAs varchar2 default null
  );
--
procedure endtwoCellAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_twoCellAnchor
  );

-- picLocks
procedure picLocks(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_picLocks,
  p_noAdjustHandles varchar2 default null,
  p_noChangeArrowheads varchar2 default null,
  p_noChangeAspect varchar2 default null,
  p_noChangeShapeType varchar2 default null,
  p_noCrop varchar2 default null,
  p_noEditPoints varchar2 default null,
  p_noGrp varchar2 default null,
  p_noMove varchar2 default null,
  p_noResize varchar2 default null,
  p_noRot varchar2 default null,
  p_noSelect varchar2 default null
  );

-- blip
procedure blip(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_blip,
  p_cstate varchar2 default null,
  p_embed varchar2 default null,
  p_link varchar2 default null
  );

-- stretch
procedure startstretch(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_stretch
  );
--
procedure endstretch(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_stretch
  );

-- fillRect
procedure fillRect(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_fillRect,
  p_l varchar2 default null,
  p_t varchar2 default null,
  p_r varchar2 default null,
  p_b varchar2 default null
  );

-- off
procedure off(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_off,
  p_x varchar2,
  p_y varchar2
  );

-- prstGeom
procedure startprstGeom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_prstGeom,
  p_prst varchar2 default null
  );
--
procedure endprstGeom(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_prstGeom
  );

-- avLst
procedure avLst(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_avLst
  );

/******************************************************************/
-- Create structure

------------------------------------------
--  picLocks: CT_PictureLocking
function cr_picLocks(
  p_tag plx_sc.normalv2 default t_picLocks,
  p_noChangeAspect plx_sc.normalv2 default null
  ) return CT_PictureLocking;

------------------------------------------
-- cNvPr: CT_NonVisualDrawingProps
function cr_cNvPr(
  p_tag plx_sc.normalv2 default t_cNvPr,
  p_descr plx_sc.maxv2 default null,
  p_id plx_sc.normalv2 default null,
  p_name plx_sc.normalv2 default null
  ) return CT_NonVisualDrawingProps;

------------------------------------------
-- cNvPicPr: CT_NonVisualPictureProperties
function cr_cNvPicPr(
   p_tag plx_sc.normalv2 default t_cNvPicPr,
   p_picLocks CT_PictureLocking default null
   ) return CT_NonVisualPictureProperties;

------------------------------------------
-- fillRect: CT_RelativeRect
function cr_fillRect(
   p_tag plx_sc.normalv2 default t_fillRect,
   p_b plx_sc.normalv2 default null,
   p_l plx_sc.normalv2 default null,
   p_r plx_sc.normalv2 default null,
   p_t plx_sc.normalv2 default null
  ) return CT_RelativeRect;

------------------------------------------
-- stretch: CT_StretchInfoProperties
function cr_stretch(
   p_tag plx_sc.normalv2 default t_stretch,
   p_fillRect CT_RelativeRect default null
   ) return  CT_StretchInfoProperties;


------------------------------------------
-- blip: CT_Blip
function cr_blip(
     p_tag plx_sc.normalv2 default t_blip,
     p_cstate ST_BlipCompression default null,
     p_embed plx_sc.normalv2 default null
     ) return CT_Blip;


------------------------------------------
-- off: CT_Point2D
function cr_off(
     p_tag plx_sc.normalv2 default t_off,
     p_x plx_sc.normalv2 default null,
     p_y plx_sc.normalv2 default null
     ) return CT_Point2D;

------------------------------------------
-- ext: CT_PositiveSize2D
function cr_ext(
         p_tag plx_sc.normalv2 default t_ext,
         p_cx plx_sc.normalv2 default null,
         p_cy plx_sc.normalv2 default null
         ) return CT_PositiveSize2D;

------------------------------------------
-- gd: CT_GeomGuide
function cr_gd(
         p_tag plx_sc.normalv2 default t_gd,
         p_fmla plx_sc.normalv2 default null,
         p_name plx_sc.normalv2 default null
         ) return CT_GeomGuide;

------------------------------------------
-- avLst: CT_GeomGuideList
function cr_avLst(
         p_tag plx_sc.normalv2 default t_avLst,
         p_gd CT_GeomGuide default null
         ) return CT_GeomGuideList;

------------------------------------------
-- xfrm: CT_Transform2D
function cr_xfrm(
         p_tag plx_sc.normalv2 default t_xfrm,
         p_ext CT_PositiveSize2D default null,
         p_off CT_Point2D default null
         ) return CT_Transform2D;

------------------------------------------
-- prstGeom: CT_PresetGeometry2D
function cr_prstGeom(
         p_tag plx_sc.normalv2 default t_prstGeom,
         p_avLst CT_GeomGuideList default null,
         p_prst ST_ShapeType default null
         ) return CT_PresetGeometry2D;

------------------------------------------
-- spPr: CT_ShapeProperties
function cr_spPr(
         p_tag plx_sc.normalv2 default t_spPr,
         p_prstGeom CT_PresetGeometry2D default null,
         p_xfrm CT_Transform2D default null
         ) return CT_ShapeProperties;

------------------------------------------
-- nvPicPr: CT_PictureNonVisual
function cr_nvPicPr(
         p_tag plx_sc.normalv2 default t_nvPicPr,
         p_cNvPicPr CT_NonVisualPictureProperties default null,
         p_cNvPr CT_NonVisualDrawingProps default null
         ) return CT_PictureNonVisual;
-- blipFill: CT_BlipFillProperties
function cr_blipFill (
         p_tag plx_sc.normalv2 default t_blipFill,
         p_blip CT_Blip default null,
         p_stretch CT_StretchInfoProperties default null
         ) return CT_BlipFillProperties;
-- col: CT_Normalv2
function cr_col(
  p_tag plx_sc.normalv2 default t_col,
  p_val plx_sc.normalv2 default null
  ) return CT_Normalv2;
-- colOff: CT_Normalv2
function cr_colOff(
  p_tag plx_sc.normalv2 default t_colOff,
  p_val plx_sc.normalv2 default null
  ) return CT_Normalv2;
-- row: CT_Normalv2
function cr_row(
  p_tag plx_sc.normalv2 default t_row,
  p_val plx_sc.normalv2 default null
  ) return CT_Normalv2;
-- rowOff: CT_Normalv2
function cr_rowOff(
  p_tag plx_sc.normalv2 default t_rowOff,
  p_val plx_sc.normalv2 default null
  ) return CT_Normalv2;
-- to: CT_Marker
function cr_to (
  p_tag plx_sc.normalv2 default t_to,
  p_col CT_Normalv2 default null,
  p_colOff CT_Normalv2 default null,
  p_row CT_Normalv2 default null,
  p_rowOff CT_Normalv2 default null
  ) return CT_Marker;
-- pic: CT_Picture
function cr_pic (
         p_tag plx_sc.normalv2 default t_pic,
         p_blipFill CT_BlipFillProperties default null,
         p_NvPicPr CT_PictureNonVisual default null,
         p_spPr CT_ShapeProperties default null
         ) return CT_Picture;
-- from: CT_Marker
function cr_from (
         p_tag plx_sc.normalv2 default t_from,
         p_col CT_Normalv2 default null,
         p_colOff CT_Normalv2 default null,
         p_row CT_Normalv2 default null,
         p_rowOff CT_Normalv2 default null
         ) return CT_Marker;
-- clientData: CT_AnchorClientData
function cr_clientData(
         p_tag plx_sc.normalv2 default t_clientData,
         p_fLocksWithSheet plx_sc.normalv2 default null,
         p_fPrintsWhithSheet plx_sc.normalv2 default null
         ) return CT_AnchorClientData;
-- anchor: EG_Anchor
procedure add_anchor(
  p_table in out EG_Anchors,
  p_anchor EG_Anchor
  );
-- twoCellAnchor: CT_TwoCellAnchor
function cr_twoCellAnchor (
         p_tag plx_sc.normalv2 default t_twoCellAnchor,
         p_clientData CT_AnchorClientData default null,
         p_from CT_Marker default null,
         p_pic CT_Picture default null,
         p_to CT_Marker default null,
         p_editAs ST_EditAs default null
         ) return CT_TwoCellAnchor;
--
-- Generate XML part
--
-- picLocks: CT_PictureLocking
procedure gen_picLocks(
  p_xml in out plx_sc.type_xdoc,
  p_picLocks CT_PictureLocking
  );
-- cNvPr: CT_NonVisualDrawingProps
procedure gen_cNvPr(
  p_xml in out plx_sc.type_xdoc,
  p_cNvPr CT_NonVisualDrawingProps
  );
-- cNvPicPr: CT_NonVisualPictureProperties
procedure gen_cNvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_cNvPicPr CT_NonVisualPictureProperties
  );
-- fillRect: CT_RelativeRect
procedure gen_fillRect(
  p_xml in out plx_sc.type_xdoc,
  p_fillRect CT_RelativeRect
  );
-- stretch: CT_StretchInfoProperties
procedure gen_stretch(
  p_xml in out plx_sc.type_xdoc,
  p_stretch CT_StretchInfoProperties
  );
-- blip: CT_Blip
procedure gen_blip(
  p_xml in out plx_sc.type_xdoc,
  p_blip CT_Blip
  );
-- off: CT_Point2D
procedure gen_off(
  p_xml in out plx_sc.type_xdoc,
  p_off CT_Point2D
  );
-- ext: CT_PositiveSize2D
procedure gen_ext(
  p_xml in out plx_sc.type_xdoc,
  p_ext CT_PositiveSize2D
  );
-- gd: CT_GeomGuide
procedure gen_gd(
  p_xml in out plx_sc.type_xdoc,
  p_gd CT_GeomGuide
  );
-- avLst: CT_GeomGuideList
procedure gen_avLst(
  p_xml in out plx_sc.type_xdoc,
  p_avLst CT_GeomGuideList
  );
-- xfrm: CT_Transform2D
procedure gen_xfrm(
  p_xml in out plx_sc.type_xdoc,
  p_xfrm CT_Transform2D
  );
-- prstGeom: CT_PresetGeometry2D
procedure gen_prstGeom(
  p_xml in out plx_sc.type_xdoc,
  p_prstGeom CT_PresetGeometry2D
  );
-- spPr: CT_ShapeProperties
procedure gen_spPr(
  p_xml in out plx_sc.type_xdoc,
  p_spPr CT_ShapeProperties
  );
-- nvPicPr: CT_PictureNonVisual
procedure gen_nvPicPr(
  p_xml in out plx_sc.type_xdoc,
  p_nvPicPr CT_PictureNonVisual
  );
-- blipFill: CT_BlipFillProperties
procedure gen_blipFill(
  p_xml in out plx_sc.type_xdoc,
  p_blipFill CT_BlipFillProperties
  );
-- col: CT_Normalv2
procedure gen_col(
  p_xml in out plx_sc.type_xdoc,
  p_col CT_Normalv2
  );
-- colOff: CT_Normalv2
procedure gen_colOff(
  p_xml in out plx_sc.type_xdoc,
  p_colOff CT_Normalv2
  );
-- row: CT_Normalv2
procedure gen_row(
  p_xml in out plx_sc.type_xdoc,
  p_row CT_Normalv2
  );
-- rowOff: CT_Normalv2
procedure gen_rowOff(
  p_xml in out plx_sc.type_xdoc,
  p_rowOff CT_Normalv2
  );
-- to: CT_Marker
procedure gen_to(
  p_xml in out plx_sc.type_xdoc,
  p_to CT_Marker
  );
-- pic: CT_Picture
procedure gen_pic(
  p_xml in out plx_sc.type_xdoc,
  p_pic CT_Picture
  );
-- from: CT_Marker
procedure gen_from(
  p_xml in out plx_sc.type_xdoc,
  p_from CT_Marker
  );
-- clientData: CT_AnchorClientData
procedure gen_clientData(
  p_xml in out plx_sc.type_xdoc,
  p_clientData CT_AnchorClientData
  );
-- twoCellAnchor: CT_TwoCellAnchor
procedure gen_twoCellAnchor(
  p_xml in out plx_sc.type_xdoc,
  p_twoCellAnchor CT_TwoCellAnchor
  );
-- EG_Anchor: EG_Anchor
procedure gen_anchor(
  p_xml in out plx_sc.type_xdoc,
  p_anchor EG_Anchor
  );
-- wsDr: CT_Drawing
procedure gen_wsDr(
  p_xml in out plx_sc.type_xdoc,
  p_wsDr CT_Drawing
  );
-- GEN_XML
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_drawing CT_drawing
  );
-- PARSE_XML
function parse(
  p_file clob
  ) return CT_Drawing;
--
end ploffx_drawing;
/

