create or replace package ploffx_docx_styles
authid current_user is
--v5.9
--
-- Namespaces
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';

-- Prefixes
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_w_pref constant varchar2(1 char) := 'w';
ns_r_pref constant varchar2(1 char) := 'r';
ns_mc_pref constant varchar2(2 char) := 'mc';

-- XML
g_xml plx_sc.type_xdoc;

-- Constants
c_filename constant plx_sc.normalv2 := 'word/styles.xml';
c_stylesWithEffect_filename constant plx_sc.normalv2 := 'word/stylesWithEffects.xml';

-- Tag
t_styles constant plx_sc.normalv2 := 'styles';
t_docDefaults constant plx_sc.normalv2 := 'docDefaults';
t_latentStyles constant plx_sc.normalv2 := 'latentStyles';
t_style constant plx_sc.normalv2 := 'style';
t_pPrDefault constant plx_sc.normalv2 := 'pPrDefault';
t_rprDefault constant plx_sc.normalv2 := 'rPrDefault';
t_lsdException constant plx_sc.normalv2 := 'lsdException';
t_basedOn constant plx_sc.normalv2 := 'basedOn';
t_next constant plx_sc.normalv2 := 'next'; --v4.8.0
t_hidden constant plx_sc.normalv2 := 'hidden';
t_link constant plx_sc.normalv2 := 'link';
t_name constant plx_sc.normalv2 := 'name';
t_qFormat constant plx_sc.normalv2 := 'qFormat';
t_rsid constant plx_sc.normalv2 := 'rsid';
t_semiHidden constant plx_sc.normalv2 := 'semiHidden';
t_uiPriority constant plx_sc.normalv2 := 'uiPriority';
t_unhideWhenUsed constant plx_sc.normalv2 := 'unhideWhenUsed';
/******************************************************************/
-- Structures
----
type CT_LsdException is record(
  tag plx_sc.normalv2,
  name plx_sc.normalv2, --ST_String
  locked plx_sc.normalv2, --ST_OnOff
  uiPriority plx_sc.normalv2, --ST_DecimalNumber
  semiHidden plx_sc.normalv2, --ST_OnOff
  unhideWhenUsed plx_sc.normalv2, --ST_OnOff
  qFormat plx_sc.normalv2 --ST_OnOff
  );
----
type t_lsdexception_ is table of CT_LsdException;
v_lsdexception_empty t_lsdexception_ := t_lsdexception_();

----Default Run Properties
type CT_RPrDefault is record(
  tag plx_sc.normalv2,
  rPr ploffx_document_type.CT_RPr
  );
---- Default Paragraph Properties
type CT_PPrDefault is record(
     tag plx_sc.normalv2,
     pPr ploffx_document_type.CT_PPr
);
----Style Definition
type CT_Style is record(
  tag plx_sc.normalv2,
  name ploffx_document_type.CT_String,
  -- aliases CT_String
  basedOn ploffx_document_type.CT_String,
  next ploffx_document_type.CT_String,
  link ploffx_document_type.CT_String,
  -- autoRedefine --ploffx_document.CT_OnOff
  -- hidden --ploffx_document.CT_OnOff
  uiPriority ploffx_document_type.CT_DecimalNumber,
  semiHidden ploffx_document_type.CT_OnOff,
  unhideWhenUsed ploffx_document_type.CT_OnOff,
  qFormat ploffx_document_type.CT_OnOff,
  -- locked --ploffx_document.CT_OnOff
  -- personal --ploffx_document.CT_OnOff
  -- personalCompose  --ploffx_document.CT_OnOff
  -- personalReply --ploffx_document.CT_OnOff
  rsid ploffx_document_type.CT_LongHexNumber,
  pPr ploffx_document_type.CT_PPr,
  rPr ploffx_document_type.CT_RPr,
  tblPr ploffx_document_type.CT_TblPr,
  trPr ploffx_document_type.CT_TrPr,
  tcPr ploffx_document_type.CT_TcPr,
  tblStylePr ploffx_document_type.CT_TblStylePr, --v4.9.3
  type ploffx_document_type.ST_StyleType,
  styleId plx_sc.normalv2, --ST_String
  default_ plx_sc.normalv2, --ST_OnOff
  customStyle plx_sc.normalv2--ST_OnOff
);
--table of the styles
type t_styles_ is table of CT_Style;
v_styles_empty t_styles_ := t_styles_();

----
type CT_LatentStyles is record(
  tag plx_sc.normalv2,
  lsdException t_lsdexception_,
  defLockedState plx_sc.normalv2, --ST_OnOff
  defUIPriority plx_sc.normalv2, --ST_DecimalNumber
  defSemiHidden plx_sc.normalv2, --ST_OnOff
  defUnhideWhenUsed plx_sc.normalv2, -- ST_OnOff
  defQFormat plx_sc.normalv2, --ST_OnOff
  count plx_sc.normalv2 --ST_DecimalNumber
  );

----Document Default Paragraph and Run Properties
type CT_DocDefaults is record(
     tag plx_sc.normalv2,
     rPrDefault CT_RPrDefault,
     pPrDefault CT_PPrDefault
);

-- CT_Style Style Definitions
type CT_Styles is record(
     tag plx_sc.normalv2,
     docDefaults  CT_DocDefaults,
     latentStyles CT_LatentStyles,
     style t_styles_
);
/******************************************************************/
-- start
procedure start_;
-- end
procedure end_;
-- styles
procedure startstyles(
  p_tag varchar2 default t_styles,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endstyles(
  p_tag varchar2 default t_styles,
  p_xml in out plx_sc.type_xdoc
  );
-- docDefaults
procedure startdocDefaults(
  p_tag varchar2 default t_docDefaults,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure enddocDefaults(
  p_tag varchar2 default t_docDefaults,
  p_xml in out plx_sc.type_xdoc
  );
-- latentStyles
procedure startlatentStyles(
  p_tag varchar2 default t_latentStyles,
  p_xml in out plx_sc.type_xdoc,
  p_count varchar2 default null,
  p_defLockedState varchar2 default null,
  p_defQFormat varchar2 default null,
  p_defSemiHidden varchar2 default null,
  p_defUIPriority varchar2 default null,
  p_defUnhideWhenUsed varchar2 default null
  );
--
procedure endlatentStyles(
  p_tag varchar2 default t_latentStyles,
  p_xml in out plx_sc.type_xdoc
  );
-- style
procedure startstyle(
  p_tag varchar2 default t_style,
  p_xml in out plx_sc.type_xdoc,
  p_customStyle varchar2 default null,
  p_default varchar2 default null,
  p_styleId varchar2 default null,
  p_type varchar2 default null
  );
--
procedure endstyle(
  p_tag varchar2 default t_style,
  p_xml in out plx_sc.type_xdoc
  );

-- pPrDefault
procedure startpPrDefault(
  p_tag varchar2 default t_pPrDefault,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endpPrDefault(
  p_tag varchar2 default t_pPrDefault,
  p_xml in out plx_sc.type_xdoc
  );
-- rPrDefault
procedure startrPrDefault(
  p_tag varchar2 default t_rPrDefault,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endrPrDefault(
  p_tag varchar2 default t_rPrDefault,
  p_xml in out plx_sc.type_xdoc
  );

-- lsdException
procedure lsdException(
  p_tag varchar2 default t_lsdException,
  p_xml in out plx_sc.type_xdoc,
  p_locked varchar2 default null,
  p_name varchar2,
  p_qFormat varchar2 default null,
  p_semiHidden varchar2 default null,
  p_UIPriority varchar2 default null,
  p_unhideWhenUsed varchar2 default null
  );
-- basedOn
procedure basedOn(
  p_tag varchar2 default t_basedOn,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- next
procedure next(
  p_tag varchar2 default t_next,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
--hidden
procedure hidden(
  p_tag varchar2 default t_hidden,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- link
procedure link(
  p_tag varchar2 default t_link,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- name
procedure name(
  p_tag varchar2 default t_name,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- qFormat
procedure qFormat(
  p_tag varchar2 default t_qFormat,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );
-- rsid
procedure rsid(
  p_tag varchar2 default t_rsid,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- semiHidden
procedure semiHidden(
  p_tag varchar2 default t_semiHidden,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );
-- uiPriority
procedure uiPriority(
  p_tag varchar2 default t_uiPriority,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- unhideWhenUsed
procedure unhideWhenUsed(
  p_tag varchar2 default t_unhideWhenUsed,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );
/************************************************************/
-- Create structure

---------------------------------------------
--name_:CT_String
--create structure
function cr_name(
  p_tag varchar2 default t_name,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--basedOn:CT_String
--create structure
function cr_basedOn(
  p_tag varchar2 default t_basedOn,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
--next
function cr_next(
  p_tag varchar2 default t_next,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--link:CT_String
--create structure
function cr_link(
  p_tag varchar2 default t_link,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--uiPriority:CT_DecimalNumber
--create structure
function cr_uiPriority(
  p_tag varchar2 default t_uiPriority,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--semiHidden:ploffx_document_type.CT_OnOff
--create structure
function cr_semiHidden(
  p_tag varchar2 default t_semiHidden,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--unhideWhenUsed: CT_Onff
--create structure
function cr_unhideWhenUsed(
  p_tag varchar2 default t_unhideWhenUsed,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--qFormat:ploffx_document_type.CT_OnOff
--create structure
function cr_qFormat(
  p_tag varchar2 default t_qFormat,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_OnOff;
----------------------------------------------
--rPrDefault:CT_RPrDefault
--create structure
function cr_rPrDefault(
  p_tag varchar2 default t_rPrDefault,
  p_rPr ploffx_document_type.CT_RPr
  ) return CT_RPrDefault;
---------------------------------------------
--pPrDefault:CT_pPrDefault
--create structure
function cr_pPrDefault(
  p_tag varchar2 default t_pPrDefault,
  p_ppr ploffx_document_type.CT_PPr
  ) return CT_PPrDefault;
 ---------------------------------------------
--docDefaults:CT_DocDefaults
--create structure
function cr_docDefaults(
  p_tag varchar2 default t_docDefaults,
  p_rPrDefault CT_RPrDefault,
  p_pPrDefault CT_PPrDefault
  ) return CT_DocDefaults;
---------------------------------------------
--lsdException:CT_lsdException
--create structure
function cr_lsdException(
  p_tag varchar2 default t_lsdException,
  p_name plx_sc.normalv2 default null,
  p_locked plx_sc.normalv2 default null,
  p_uiPriority plx_sc.normalv2 default null,
  p_semiHidden plx_sc.normalv2 default null,
  p_unhideWhenUsed plx_sc.normalv2 default null,
  p_qFormat plx_sc.normalv2 default null
  ) return CT_LsdException;
---------------------------------------------
--t_lsdException_
procedure add_LsdException(
  p_table in out t_lsdexception_,
  p_lsdException CT_LsdException
  );
---------------------------------------------
--latentStyles:CT_latentStyles
--create structure
function cr_latentStyles(
  p_tag varchar2 default t_latentStyles,
  p_lsdException t_lsdexception_ default null,
  p_defLockedState plx_sc.normalv2 default null,
  p_defUIPriority plx_sc.normalv2 default null,
  p_defSemiHidden plx_sc.normalv2 default null,
  p_defUnhideWhenUsed plx_sc.normalv2 default null,
  p_defQFormat plx_sc.normalv2 default null,
  p_count plx_sc.normalv2 default null
  ) return CT_LatentStyles;
---------------------------------------------
--rsid:CT_LongHexNumber
--create structure
function cr_rsid(
  p_tag varchar2 default t_rsid,
  p_val plx_sc.normalv2
  ) return ploffx_document_type.CT_LongHexNumber;
---------------------------------------------
--Style:CT_Style
--create structure
function cr_Style(
  p_tag varchar2 default t_Style,
  p_name ploffx_document_type.CT_String default null,
  p_basedOn ploffx_document_type.CT_String default null,
  p_next ploffx_document_type.CT_String default null,
  p_link ploffx_document_type.CT_String default null,
  p_uiPriority ploffx_document_type.CT_DecimalNumber default null,
  p_semiHidden ploffx_document_type.CT_OnOff default null,
  p_unhideWhenUsed ploffx_document_type.CT_OnOff default null,
  p_qFormat ploffx_document_type.CT_OnOff default null,
  p_rsid ploffx_document_type.CT_LongHexNumber default null,
  p_pPr ploffx_document_type.CT_PPr default null,
  p_rPr ploffx_document_type.CT_rPr default null,
  p_tblPr ploffx_document_type.CT_TblPr default null,
  p_trPr ploffx_document_type.CT_TrPr default null,
  p_tcPr ploffx_document_type.CT_TcPr default null,
  p_tblStylePr ploffx_document_type.CT_TblStylePr default null, --v4.9.3
  p_type ploffx_document_type.ST_StyleType default null,
  p_styleId plx_sc.normalv2 default null,
  p_default plx_sc.normalv2 default null,
  p_customStyle plx_sc.normalv2 default null
  ) return CT_Style;
---------------------------------------------
--Styles:CT_Styles
--create structure
function cr_Styles(
  p_tag varchar2 default t_Styles,
  p_docDefaults CT_DocDefaults,
  p_latentStyles CT_LatentStyles,
  p_style t_styles_
  ) return CT_Styles;
--t_styles_
procedure add_Style(
  p_table in out t_styles_,
  p_Style CT_Style
  );
---------------------------------------------
--hidden:CT_OnOff
--create structure
function cr_hidden(
  p_tag varchar2 default t_hidden,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;
/************************************************************/
-- Generate XML parts
----------------------------------------------
--rPrDefault:CT_RPrDefault
--generate xml part
procedure gen_rPrDefault(
  p_xml in out plx_sc.type_xdoc,
  p_rpr CT_RPrDefault
  );
---------------------------------------------
--pPrDefault:CT_pPrDefault
--generate xml part
procedure gen_pPrDefault(
  p_xml in out plx_sc.type_xdoc,
  p_pprDefault CT_PPrDefault
  );
---------------------------------------------
--docDefaults:CT_DocDefaults
--generate xml part
procedure gen_docDefaults(
  p_xml in out plx_sc.type_xdoc,
  p_docDefaults CT_DocDefaults
  );
---------------------------------------------
--lsdException:CT_lsdException
--generate xml part
procedure gen_lsdException(
  p_xml in out plx_sc.type_xdoc,
  p_lsdException CT_LsdException
  );
---------------------------------------------
--latentStyles:CT_latentStyles
--generate xml part
procedure gen_latentStyles(
  p_xml in out plx_sc.type_xdoc,
  p_latentStyles CT_LatentStyles
  );
---------------------------------------------
--generate xml part
procedure gen_name(
  p_xml in out plx_sc.type_xdoc,
  p_name ploffx_document_type.CT_String
  );
---------------------------------------------
--generate xml part
procedure gen_basedOn(
  p_xml in out plx_sc.type_xdoc,
  p_basedOn ploffx_document_type.CT_String
  );
---------------------------------------------
--next
procedure gen_next(
  p_xml in out plx_sc.type_xdoc,
  p_next ploffx_document_type.CT_String
  );
---------------------------------------------
--generate xml part
procedure gen_link(
  p_xml in out plx_sc.type_xdoc,
  p_link ploffx_document_type.CT_String
  );
---------------------------------------------
--generate xml part
procedure gen_uiPriority(
  p_xml in out plx_sc.type_xdoc,
  p_uiPriority ploffx_document_type.CT_DecimalNumber
  );
---------------------------------------------
--generate xml part
procedure gen_semiHidden(
  p_xml in out plx_sc.type_xdoc,
  p_semiHidden ploffx_document_type.CT_OnOff
  );
---------------------------------------------
--generate xml part
procedure gen_unhideWhenUsed(
  p_xml in out plx_sc.type_xdoc,
  p_unhideWhenUsed ploffx_document_type.CT_OnOff
  );
---------------------------------------------
--generate xml part
procedure gen_qFormat(
  p_xml in out plx_sc.type_xdoc,
  p_qFormat ploffx_document_type.CT_OnOff
  );
---------------------------------------------
--rsid:CT_LongHexNumber
--generate xml part
procedure gen_rsid(
  p_xml in out plx_sc.type_xdoc,
  p_rsid ploffx_document_type.CT_LongHexNumber
  );
---------------------------------------------
--Style:CT_Style
--generate xml part
procedure gen_Style(
  p_xml in out plx_sc.type_xdoc,
  p_Style CT_Style
  );
---------------------------------------------
--Styles:CT_Styles
--generate xml part
procedure gen_Styles(
  p_xml in out plx_sc.type_xdoc,
  p_Styles CT_Styles
  );
---------------------------------------------
--hidden:CT_OnOff
--generate xml part
procedure gen_hidden(
  p_xml in out plx_sc.type_xdoc,
  p_hidden ploffx_document_type.CT_OnOff
  );
-- GEN_XML
procedure gen_xml(
  p_Styles CT_Styles
  );

/************************************************************/
-- Parse and preprocessed parts
-- Parse
function parse(
  p_file clob
  ) return CT_Styles;
--
procedure docx_styles_init(
  p_styles in out CT_Styles
  );
--
end ploffx_docx_styles;
/

