create or replace package ploffx_docx
authid current_user is

/**
 <config>
  <pck-name>PL/OFFX_DOCX</pck-name>
  <pck-title>DOCX processor and generator</pck-title>
  <pck-version>v5.19</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>

 </config>
*/

/**
 <h1>Introduction</h1>
 <br/>
 <p>
 PL/OFFX_DOCX is a PL/SQL based DOCX document generator from Oracle databases.
 Use PL/OFFX_DOCX to quickly and easily develop applications with dynamic content but also quality presentation and printing capabilities.
 </p>
 <br/>
 <h2>Links</h2>
 <p>Overview of the XML file formats in Office 2010: <a>http://technet.microsoft.com/en-us/library/cc179190.aspx</a></p>
 <p>XML Wordprocessing document structrue: <a>http://msdn.microsoft.com/en-us/library/office/gg278308(v=office.15).aspx</a></p>
 <br/>
 <h2>Installation</h2>
 <p>
 System requirements: Oracle 11g RDBMS Release 2 or higher. Oracle 11g Express Edition is supported.
 </p>
 <p>
 PL/OFFX_DOCX is a collection of PL/SQL packages. Before using PL/OFFX_DOCX, make sure that the steps described in the Installation
  Guide were completed.
 </p>
 <br/>
 <h2>Using PL/OFFX_DOCX</h2>
 <p>
 Essentially, PL/OFFX_DOCX is a series of calls to PL/OFFX_DOCX procedures and functions from a PL/SQL script, package, procedure or function.
 If you are not familiar with the PL/SQL programming language, study the Oracle documentation.
 </p>
 <br/>
 <h2>Contact</h2>
 <p>
 Contact us at: <a>mailto:info@plpdf.com</a>
 </p>
 <newpage/>
*/


/**
 <name>Init</name>
 <type>procedure</type>
 <desc>
 Initializes generator program variables.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_unit varchar2 default 'mm'</param-def>
   <param-desc>Default measurement unit</param-desc>
  </param>
  <param>
   <param-def>p_orientation ploffx_document_type.ST_PageOrientation default ploffx_document_type.c_portrait</param-def>
   <param-desc>Page orientation</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure init(
  p_unit varchar2 default 'mm',
  p_orientation ploffx_document_type.ST_PageOrientation default ploffx_document_type.c_portrait
  );

--v4.10
function getProducer
  return varchar2;

--v4.10
procedure setProducer(
  p_producer varchar2
  );

--v4.10
procedure setTitle(
  p_title varchar2
  );
--v4.10
procedure setSubject(
  p_subject varchar2
  );
--v4.10
procedure setKeywords(
  p_keywords varchar2
  );
--v4.10
procedure setDescription(
  p_description varchar2
  );

--v4.10
procedure setCompany(
  p_company varchar2
  );

--v4.10
procedure setManager(
  p_manager varchar2
  );

/**
 <name>getScaleFactor</name>
 <type>function</type>
 <desc>
 Gets the scale multiplicator between user OUM and internal point.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>-</param>
 </params>
 <return>
   <return-def>number</return-def>
   <return-desc>The multiplicator</return-desc>
 </return>
*/
function getScaleFactor
  return number;

/**
 <name>setPageSize</name>
 <type>procedure</type>
 <desc>
 Set page size setting.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_w number</param-def>
   <param-desc>Page width</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>Page height</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPageSize(
   p_w number,
   p_h number
  );

--v5.7
procedure setpaperSrc(
   p_first pls_integer, 
   p_other pls_integer 
  );

--v4.11
procedure setPageMargins(
  p_header number default null,
  p_footer number default null,
  p_left number default null,
  p_right number default null,
  p_bottom number default null,
  p_top number default null,
  p_gutter number default null
  );

--v4.9.3
function crParagraphProperties(
  p_bidi boolean default null,
  p_contextualSpacing boolean default null,
  p_ind ploffx_document_type.CT_Ind default null,
  p_alignment varchar2 default null,
  p_keepLines boolean default null,
  p_keepNext boolean default null,
  p_numPr ploffx_document_type.CT_NumPr default null, --v4.11
  p_outlineLvl varchar2 default null,
  p_pageBreakBefore boolean default null,
  p_border ploffx_document_type.CT_PBdr default null,
  p_pStyle varchar2 default 'Normal', --v5.18
  p_spacing ploffx_document_type.CT_Spacing default null,
  p_suppressAutoHyphens boolean default null,
  p_suppressLineNumbers boolean default null,
  p_textAlignment varchar2 default null,
  p_widowControl boolean default null
  ) return ploffx_document_type.CT_PPr;

--v4.9.3
function crParagraph(
  p_PPr ploffx_document_type.CT_PPr
  ) return pls_integer;

/**
 <name>crParagraph</name>
 <type>function</type>
 <desc>
 Create empty paragraph for content.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_bidi boolean default null</param-def>
   <param-desc>Right to Left Paragraph Layout</param-desc>
 </param>
 <param>
   <param-def>p_contextualSpacing boolean default null</param-def>
   <param-desc>Ignore Spacing Above and Below When Using Identical Styles</param-desc>
 </param>
 <param>
   <param-def>p_ind ploffx_document_type.CT_Ind default null</param-def>
   <param-desc>Set paragraph indentation </param-desc>
 </param>
 <param>
   <param-def>p_alignment varchar2 default null</param-def>
   <param-desc>Paragraph horizontal alignment (left, center, right, justify)</param-desc>
 </param>
 <param>
   <param-def>p_numPr ploffx_document_type.CT_NumPr default null</param-def>
   <param-desc>Numbering properties</param-desc>
 </param>
 <param>
   <param-def>p_pageBreakBefore boolean default null</param-def>
   <param-desc>Start Paragraph on Next Page</param-desc>
 </param>
 <param>
   <param-def>p_border ploffx_document_type.CT_PBdr default null</param-def>
   <param-desc>Paragraph Borders </param-desc>
 </param>
 <param>
   <param-def>p_pStyle varchar2 default 'Normal'</param-def>
   <param-desc>Referenced Paragraph Style</param-desc>
 </param>
 <param>
   <param-def>p_spacing ploffx_document_type.CT_Spacing default null</param-def>
   <param-desc>Spacing Between Lines and Above/Below Paragraph</param-desc>
 </param>
 <param>
   <param-def>p_suppressAutoHyphens boolean default null</param-def>
   <param-desc>Suppress Hyphenation for Paragraph</param-desc>
 </param>
 <param>
   <param-def>p_suppressLineNumbers boolean default null</param-def>
   <param-desc>Suppress Line Numbers for Paragraph</param-desc>
 </param>
 <param>
   <param-def>p_textAlignment varchar2 default null</param-def>
   <param-desc>Vertical Character Alignment on Line</param-desc>
 </param>
 <param>
   <param-def>p_widowControl boolean default null</param-def>
   <param-desc>Allow First/Last Line to Display on a Separate Page</param-desc>
 </param>
 </params>
 <return>
 <return-def>pls_integer</return-def>
  <return-desc>Index of the created paragraph</return-desc>
 </return>
*/
function crParagraph(
  p_bidi boolean default null,
  p_contextualSpacing boolean default null,
  p_ind ploffx_document_type.CT_Ind default null,
  p_alignment varchar2 default null,
  p_numPr ploffx_document_type.CT_NumPr default null, --v4.11
  p_pageBreakBefore boolean default null,
  p_border ploffx_document_type.CT_PBdr default null,
  p_pStyle varchar2 default 'Normal', --v5.18
  p_spacing ploffx_document_type.CT_Spacing default null,
  p_suppressAutoHyphens boolean default null,
  p_suppressLineNumbers boolean default null,
  p_textAlignment varchar2 default null,
  p_widowControl boolean default null
  ) return pls_integer;

/**
 <name>crSectionParagraph</name>
 <type>function</type>
 <desc>
 Create section paragraph for content.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_cols_space varchar2 default null</param-def>
   <param-desc>Column Definitions</param-desc>
 </param>
 <param>
   <param-def>p_docgrid_linePitch varchar2 default null</param-def>
   <param-desc>Document Grid</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_bottom varchar2 default null</param-def>
   <param-desc>Page Margins Bottom</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_footer varchar2 default null</param-def>
   <param-desc>Page MArgins Footer</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_gutter varchar2 default null</param-def>
   <param-desc>Page Margins Gutter</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_header varchar2 default null</param-def>
   <param-desc>Page Margins Header</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_left varchar2 default null</param-def>
   <param-desc>Page Margins Left</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_right varchar2 default null</param-def>
   <param-desc>Page Margins Right</param-desc>
 </param>
 <param>
   <param-def>p_pgmar_top varchar2 default null</param-def>
   <param-desc>Page Margins Top</param-desc>
 </param>
 <param>
   <param-def>p_pgSz_w varchar2 default null</param-def>
   <param-desc>Page Size Width</param-desc>
 </param>
 <param>
   <param-def>p_pgSz_h varchar2 default null</param-def>
   <param-desc>Page Size Height</param-desc>
 </param>
 <param>
   <param-def>p_pgSz_orient varchar2 default null</param-def>
   <param-desc>Page Size Orientation</param-desc>
 </param>
 </params>
 <return>
 <return-def>pls_integer</return-def>
  <return-desc>Index of the created paragraph</return-desc>
 </return>
*/
function crSectionParagraph(
  p_cols_space varchar2 default null,
  p_docgrid_linePitch varchar2 default null,
  p_pgmar_bottom varchar2 default null,
  p_pgmar_footer varchar2 default null,
  p_pgmar_gutter varchar2 default null,
  p_pgmar_header varchar2 default null,
  p_pgmar_left varchar2 default null,
  p_pgmar_right varchar2 default null,
  p_pgmar_top varchar2 default null,
  p_pgSz_w varchar2 default null,
  p_pgSz_h varchar2 default null,
  p_pgSz_orient varchar2 default null
  ) return pls_integer;

/**
 <name>addParagraph</name>
 <type>procedure</type>
 <desc>
 Add paragraph to the document
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Existing paragraph ID</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure addParagraph(
  p_paragraph_id pls_integer
  );

/**
 <name>addParagraph</name>
 <type>function</type>
 <desc>
 Add paragraph to document
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Existing paragraph ID</param-desc>
  </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the new paragraph</return-desc>
 </return>
*/
function addParagraph(
  p_paragraph_id pls_integer
  ) return pls_integer;

/**
 <name>addText</name>
 <type>procedure</type>
 <desc>
 Add text to an existing paragraph.
 </desc>
 <version>v4.10</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Specifies the value of this text.</param-desc>
 </param>
 <param>
   <param-def>p_bold boolean default null</param-def>
   <param-desc>Bold text.</param-desc>
 </param>
 <param>
   <param-def>p_border ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies text border properties</param-desc>
 </param>
 <param>
   <param-def>p_case varchar2 default null</param-def>
   <param-desc>Specifies U(pper) or L(ower) case</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies text color in hexadecimal format</param-desc>
 </param>
 <param>
   <param-def>p_fitText number default null</param-def>
   <param-desc>Display text in fix width.</param-desc>
 </param>
 <param>
   <param-def>p_highlight varchar2 default null</param-def>
   <param-desc>Specifies highlight color around the text.</param-desc>
 </param>
 <param>
   <param-def>p_italic boolean default null</param-def>
   <param-desc>Italic text.</param-desc>
 </param>
 <param>
   <param-def>p_vertPosition number default null</param-def>
   <param-desc>Specifies the amount to be raised or lowered the text relation to the default baseline of the</param-desc>
 </param>
 <param>
   <param-def>p_FontName varchar2 default null</param-def>
   <param-desc>Specifies font family</param-desc>
 </param>
 <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the text style</param-desc>
 </param>
 <param>
   <param-def>p_spacing number default null</param-def>
   <param-desc>Specifies the character spacing.</param-desc>
 </param>
 <param>
   <param-def>p_strikeout number default null</param-def>
   <param-desc>Strikeout.</param-desc>
 </param>
 <param>
   <param-def>p_FontSize number default null</param-def>
   <param-desc>Specifies the font size.</param-desc>
 </param>
 <param>
   <param-def>p_underline ploffx_document_type.CT_Underline default null</param-def>
   <param-desc>Specifies the underline properties.</param-desc>
 </param>
 <param>
   <param-def>p_vertAlign varchar2 default null</param-def>
   <param-desc>Specifies the vertical alignment of the text.</param-desc>
    <param-ul>
       <param-li>baseline</param-li>
       <param-li>subscirpt</param-li>
       <param-li>superscritp</param-li>
   </param-ul>
 </param>
  <param>
   <param-def>p_w number default null</param-def>
   <param-desc>This element specifies the amount by which each character shall be expanded. </param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addText(
  p_paragraph_id pls_integer,
  p_text varchar2,
  p_bold boolean default null,
  p_border ploffx_document_type.CT_Border default null,
  p_upperCase boolean default null,
  p_smallCaps boolean default null,
  p_color varchar2 default null,
  p_fitText number default null,
  p_highlight ploffx_document_type.ST_HighlightColor default null,
  p_italic boolean default null,
  p_vertPosition number default null,
  p_FontName ploffx_document_type.XT_FontName default null,
  p_style varchar2 default null,
  p_spacing number default null,
  p_strikeout boolean default null,
  p_FontSize number default null,
  p_underline ploffx_document_type.CT_Underline default null,
  p_vertAlign varchar2 default null,
  p_w number default null --
  );

/**
 <name>addText</name>
 <type>function</type>
 <desc>
 Add text to an existing paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Specifies the value of this text.</param-desc>
 </param>
 <param>
   <param-def>p_bold boolean default null</param-def>
   <param-desc>Bold text.</param-desc>
 </param>
 <param>
   <param-def>p_border ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies text border properties</param-desc>
 </param>
 <param>
   <param-def>p_case varchar2 default null</param-def>
   <param-desc>Specifies U(pper) or L(ower) case</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies text color in hexadecimal format</param-desc>
 </param>
 <param>
   <param-def>p_fitText number default null</param-def>
   <param-desc>Display text in fix width.</param-desc>
 </param>
 <param>
   <param-def>p_highlight varchar2 default null</param-def>
   <param-desc>Specifies highlight color around the text.</param-desc>
 </param>
 <param>
   <param-def>p_italic boolean default null</param-def>
   <param-desc>Italic text.</param-desc>
 </param>
 <param>
   <param-def>p_vertPosition number default null</param-def>
   <param-desc>Specifies the amount to be raised or lowered the text relation to the default baseline of the</param-desc>
 </param>
 <param>
   <param-def>p_FontName varchar2 default nul</param-def>
   <param-desc>Specifies font family</param-desc>
 </param>
 <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the text style</param-desc>
 </param>
 <param>
   <param-def>p_spacing number default null</param-def>
   <param-desc>Specifies the character spacing.</param-desc>
 </param>
 <param>
   <param-def>p_strikeout number default null</param-def>
   <param-desc>Strikeout.</param-desc>
 </param>
 <param>
   <param-def>p_FontSize number default null</param-def>
   <param-desc>Specifies the font size.</param-desc>
 </param>
 <param>
   <param-def>p_underline ploffx_document_type.CT_Underline default null</param-def>
   <param-desc>Specifies the underline properties.</param-desc>
 </param>
 <param>
   <param-def>p_vertAlign varchar2 default null</param-def>
   <param-desc>Specifies the vertical alignment of the text.</param-desc>
    <param-ul>
       <param-li>baseline</param-li>
       <param-li>subscirpt</param-li>
       <param-li>superscritp</param-li>
   </param-ul>
 </param>
  <param>
   <param-def>p_w number default null</param-def>
   <param-desc>This element specifies the amount by which each character shall be expanded. </param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the text object</return-desc>
 </return>
*/
function addText(
  p_paragraph_id pls_integer,
  p_text varchar2,
  p_bold boolean default null,
  p_border ploffx_document_type.CT_Border default null,
  p_upperCase boolean default null,
  p_smallCaps boolean default null,
  p_color varchar2 default null,
  p_fitText number default null,
  p_highlight ploffx_document_type.ST_HighlightColor default null,
  p_italic boolean default null,
  p_vertPosition number default null,
  p_FontName ploffx_document_type.XT_FontName default null,
  p_style varchar2 default null,
  p_spacing number default null,
  p_strikeout boolean default null,
  p_FontSize number default null,
  p_underline ploffx_document_type.CT_Underline default null,
  p_vertAlign varchar2 default null,
  p_w number default null --
  ) return pls_integer;

--v5.0
function addText(
  p_r in out ploffx_document_type.CT_R,
  p_text varchar2
  ) return pls_integer;

/**
 <name>addInstrText</name>
 <type>function</type>
 <desc>
 Adds Field Code to an existing paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_instrText varchar2</param-def>
   <param-desc>Specifies the value of this field code.</param-desc>
 </param>
 <param>
   <param-def>p_RPr ploffx_document_type.CT_RPr default null</param-def>
   <param-desc>the field code run properties</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the text object</return-desc>
 </return>
*/
function addInstrText(
  p_paragraph_id pls_integer,
  p_instrText varchar2,
  p_RPr ploffx_document_type.CT_RPr default null
  ) return pls_integer;

/**
 <name>addfldChar</name>
 <type>function</type>
 <desc>
 Adds Complex Field Char to an existing paragraph.
 </desc>
 <version>v4.8.2</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_fldCharType varchar2</param-def>
   <param-desc>Specifies the value of this field char.</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the text object</return-desc>
 </return>
*/
function addfldChar(
  p_paragraph_id pls_integer,
  p_fldCharType varchar2
  ) return pls_integer;

--INTERNAL
--v2.0.0
-- Create Run properties
function crRunProperties(
  p_bold boolean default null,
  p_bCs boolean default null,
  p_bdr ploffx_document_type.CT_Border default null,
  p_caps boolean default null,
  p_color varchar2 default null,
  p_cs boolean default null,
  p_dstrike boolean default null,
  p_effect varchar2 default null,
  p_em varchar2 default null,
  p_emboss boolean default null,
  p_fitText number default null,
  p_highlight varchar2 default null,
  p_italic boolean default null,
  p_iCs boolean default null,
  p_imprint boolean default null,
  p_kern varchar2 default null,
  p_noProof boolean default null,
  p_oMath boolean default null,
  p_outline boolean default null,
  p_position number default null,
  p_FontName varchar2 default null,
  p_rStyle varchar2 default null,
  p_rtl boolean default null,
  p_shadow boolean default null,
  p_smallCaps boolean default null,
  p_snapToGrid boolean default null,
  p_spacing number default null,
  p_specVanish boolean default null,
  p_strike boolean default null,
  p_FontSize number default null,
  p_CsFontSize pls_integer default null,
  p_underline ploffx_document_type.CT_Underline default null,
  p_vanish boolean default null,
  p_vertAlign varchar2 default null,
  p_w number default null,
  p_webHidden boolean default null
  ) return ploffx_document_type.CT_rPr;

/**
 <name>crRun</name>
 <type>function</type>
 <desc>
 Creates text run structure from text and run properties.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>The text as string</param-desc>
 </param>
 <param>
   <param-def>p_RPr ploffx_document_type.CT_RPr</param-def>
   <param-desc>The run properties</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal structure of the created object</return-desc>
 </return>
*/
function crRun(
  p_text varchar2,
  p_RPr ploffx_document_type.CT_RPr
  ) return ploffx_document_type.CT_R;

--v5.0
function crRun(
  p_RPr ploffx_document_type.CT_RPr
  ) return ploffx_document_type.CT_R;

/**
 <name>addRun</name>
 <type>function</type>
 <desc>
 Adds Run as a structure to an existing paragraph.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_run ploffx_document_type.CT_R</param-def>
   <param-desc>The run as internal structure</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the run object</return-desc>
 </return>
*/
function addRun(
  p_paragraph_id pls_integer,
  p_run ploffx_document_type.CT_R
  ) return pls_integer;

/**
 <name>addRun</name>
 <type>procedure</type>
 <desc>
 Adds Run as a structure to an existing paragraph.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_run ploffx_document_type.CT_R</param-def>
   <param-desc>The run as internal structure</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addRun(
  p_paragraph_id pls_integer,
  p_run ploffx_document_type.CT_R
  );

/**
 <name>addBR</name>
 <type>function</type>
 <desc>
 Adds Break to an existing paragraph.
 </desc>
 <version>v4.5.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_clear varchar2 default null</param-def>
   <param-desc>Restart Location For Text Wrapping Break</param-desc>
 </param>
 <param>
   <param-def>p_type varchar2 default null</param-def>
   <param-desc>Break Type, see ploffx_document_type.ST_BrType</param-desc>
   <param-ul>
    <param-li>column: Column Break</param-li>
    <param-li>page: Page Break</param-li>
    <param-li>textWrapping: Line Break</param-li>
</param-ul>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the run object</return-desc>
 </return>
*/
function addBR(
  p_paragraph_id pls_integer,
  p_clear varchar2 default null,
  p_type varchar2 default null
  ) return pls_integer;

/**
 <name>addBR</name>
 <type>procedure</type>
 <desc>
 Adds Break to an existing paragraph.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_clear varchar2 default null</param-def>
   <param-desc>Restart Location For Text Wrapping Break</param-desc>
 </param>
 <param>
   <param-def>p_type varchar2 default null</param-def>
   <param-desc>Break Type, see ploffx_document_type.ST_BrType</param-desc>
   <param-ul>
    <param-li>column: Column Break</param-li>
    <param-li>page: Page Break</param-li>
    <param-li>textWrapping: Line Break</param-li>
</param-ul>
 </param>
 </params>
 <return>-</return>
*/
procedure addBR(
  p_paragraph_id pls_integer,
  p_clear varchar2 default null,
  p_type varchar2 default null
  );

--v4.5.0
function addBR(
  p_r in out ploffx_document_type.CT_R,
  p_clear varchar2,
  p_type varchar2
  ) return pls_integer;

--v5.0
function addTab(
  p_paragraph_id pls_integer
  ) return pls_integer;

--v5.0
procedure addTab(
  p_paragraph_id pls_integer
  );


--v5.0
function addTab(
  p_r in out ploffx_document_type.CT_R
  ) return pls_integer;


/**
 <name>setListLevel</name>
 <type>procedure</type>
 <desc>
 Set paragraph to a list element.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
  </param>
  <param>
   <param-def>p_level pls_integer default 0</param-def>
   <param-desc>Specifies the list level.</param-desc>
  </param>
  <param>
   <param-def>p_numId pls_integer default 1</param-def>
   <param-desc>Specifies a reference to the list.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setListLevel(
  p_paragraph_id pls_integer,
  p_level pls_integer default 0,
  p_numId pls_integer default 1
  );

/**
 <name>AddHeader</name>
 <type>procedure</type>
 <desc>
 Add paragraph to the document header.
 </desc>
 <version>v3.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_type ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default</param-def>
   <param-desc>Specifies the header type</param-desc>
   <param-ul>
       <param-li>default</param-li>
       <param-li>even</param-li>
       <param-li>first</param-li>
   </param-ul>
 </param>
 </params>
 <return>
 </return>
*/
procedure AddHeader(
  p_paragraph_id pls_integer,
  p_type ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default
  );

/**
 <name>AddFooter</name>
 <type>procedure</type>
 <desc>
 Add paragraph to the document footer.
 </desc>
 <version>v3.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_type ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default</param-def>
   <param-desc>Specifies the footer type</param-desc>
   <param-ul>
       <param-li>default</param-li>
       <param-li>even</param-li>
       <param-li>first</param-li>
   </param-ul>
 </param>
 </params>
 <return>
 </return>
*/
procedure AddFooter(
  p_paragraph_id pls_integer,
  p_type ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default
  );

/**
 <name>crTable</name>
 <type>function</type>
 <desc>
 Create table.
 </desc>
 <version>v4.8.1</version>
 <params>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the table width.</param-desc>
 </param>
 <param>
   <param-def>p_alignment varchar2 default ploffx_document_type.c_left</param-def>
   <param-desc>Specifies the table alignment.</param-desc>
 </param>
 <param>
   <param-def>p_tblStyle  varchar2 default null</param-def>
   <param-desc>Specifies the table style.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the created table</return-desc>
 </return>
*/
function crTable(
  p_width number default null,
  p_alignment ploffx_document_type.ST_Align default ploffx_document_type.c_left,
  p_tblStyle  varchar2 default null
  ) return pls_integer;


--v5.8
procedure setFloatingTableProperties(
  p_table_id pls_integer,
  p_tblpPr ploffx_document_type.CT_TblPPr
  );

/**
 <name>addTable</name>
 <type>function</type>
 <desc>
 Add previously defined table to the document.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the created table.</return-desc>
 </return>
*/
function addTable(
  p_table_id pls_integer
  ) return pls_integer;

/**
 <name>addTable</name>
 <type>procedure</type>
 <desc>
 Add previously defined table to the document.
 </desc>
 <version>v4.8.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addTable(
  p_table_id pls_integer
  );

/**
 <name>setTableBorders</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table border properties.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableBorders(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null,
  p_width number default null,
  p_space number default null,
  p_color ploffx_document_type.ST_HexColor default null
  );

/**
 <name>setTableTopBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table top border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableTopBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>setTableBottomBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table bottom border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableBottomBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>setTableLeftBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table left border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableLeftBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>setTableRightBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table right border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableRightBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>setTableInsideBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table InsideH border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableinsideHBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>setTableInsideVBorder</name>
 <type>procedure</type>
 <desc>
 Customize a previously defined table InsideV border properties.
 </desc>
 <version>v4.7.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the border style.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the border width.</param-desc>
 </param>
 <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the border and the content.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies the border color.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setTableinsideVBorder(
  p_table_id pls_integer,
  p_style ploffx_document_type.ST_Border default null, --val
  p_width number default null, --sz
  p_space number default null, --space
  p_color ploffx_document_type.ST_HexColor default null --color
  );

/**
 <name>AddRow</name>
 <type>function</type>
 <desc>
 Add row to a previously defined table.
 </desc>
 <version>v4.5.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 <param>
   <param-def>p_alignment varchar2 default null</param-def>
   <param-desc>Specifies the alignment of the row.</param-desc>
 </param>
 <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Specifies the height of the row.</param-desc>
 </param>
 <param>
   <param-def>p_tblheader boolean default null</param-def>
   <param-desc>Repeat table row on every new page.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the created row.</return-desc>
 </return>
*/
function AddRow(
  p_table_id pls_integer,
  p_alignment varchar2 default null,
  p_height number default null,
  p_tblheader boolean default null
  ) return pls_integer;

/**
 <name>AddCell</name>
 <type>function</type>
 <desc>
 Add cell to a previously defined table row.
 </desc>
 <version>v4.9.7</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 <param>
   <param-def>p_row_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined row.</param-desc>
 </param>
  <param>
   <param-def>p_noWrap boolean default null</param-def>
   <param-desc>NoWrap.</param-desc>
 </param>
 <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the width of the cell.</param-desc>
 </param>
 <param>
   <param-def>p_gridSpan pls_integer default null</param-def>
   <param-desc>This element specifies the number of grid columns which shall be spanned by the current cell.</param-desc>
 </param>
 <param>
   <param-def>p_vMerge ploffx_document_type.CT_VMerge default null</param-def>
   <param-desc>This element specifies that this cell is part of a vertically merged set of cells in a table.</param-desc>
 </param>
 <param>
   <param-def>p_cellBorder ploffx_document_type.CT_TcBorders default null</param-def>
   <param-desc>Specifies the border of the cell.</param-desc>
 </param>
 <param>
   <param-def>p_background ploffx_document_type.ST_HexColor default null</param-def>
   <param-desc>Specifies the background color of the cell.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the created cell.</return-desc>
 </return>
*/
function AddCell(
  p_table_id pls_integer,
  p_row_id pls_integer,
  p_noWrap boolean default null,
  p_width number default null,
  p_gridSpan pls_integer default null,
  p_vMerge ploffx_document_type.CT_VMerge default null,
  p_cellBorder ploffx_document_type.CT_TcBorders default null,
  p_background ploffx_document_type.ST_HexColor default null
  ) return pls_integer;



/**
 <name>TableaddParagraph</name>
 <type>procedure</type>
 <desc>
 Add previously defined paragraph to a cell of table.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 <param>
   <param-def>p_row_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined row.</param-desc>
 </param>
  <param>
   <param-def>p_cell_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined cell.</param-desc>
 </param>
   <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 </params>
*/
procedure TableaddParagraph(
  p_table_id pls_integer,
  p_row_id pls_integer,
  p_cell_id pls_integer,
  p_paragraph_id pls_integer
  );

/**
 <name>TableaddParagraph</name>
 <type>function</type>
 <desc>
 Add previously defined paragraph to a cell of table.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_table_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined table.</param-desc>
 </param>
 <param>
   <param-def>p_row_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined row.</param-desc>
 </param>
  <param>
   <param-def>p_cell_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined cell.</param-desc>
 </param>
   <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>The internal index of the paragraph</return-desc>
 </return>
*/
function TableaddParagraph(
  p_table_id pls_integer,
  p_row_id pls_integer,
  p_cell_id pls_integer,
  p_paragraph_id pls_integer
  ) return pls_integer;

--v4.8.0
--INTERNAL
procedure TableaddXhtmlText(
  p_cell_id pls_integer,
  p_text varchar2
  );

/**
 <name>addInlineImage</name>
 <type>procedure</type>
 <desc>
 Add inline image to a paragraph.
 </desc>
 <version>v4.9.1</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Specifies the image name.</param-desc>
 </param>
  <param>
   <param-def>p_file in out nocopy blob</param-def>
   <param-desc>Specifies a reference to the image source blob.</param-desc>
 </param>
   <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the image width.</param-desc>
 </param>
 <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Specifies the image height.</param-desc>
 </param>
 </params>
*/
procedure addInlineImage(
  p_paragraph_id pls_integer,
  p_name varchar2 default null,
  p_file in out nocopy blob,
  p_width number default null,
  p_height number default null
  );

--v4.9.3
procedure addInlineImage2(
  p_paragraph_id pls_integer,
  p_name varchar2 default null,
  p_file blob,
  p_width number default null,
  p_height number default null
  );

/**
 <name>addInlineImage</name>
 <type>function</type>
 <desc>
 Add inline image to a paragraph.
 </desc>
 <version>v4.9.1</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Specifies the image name.</param-desc>
 </param>
  <param>
   <param-def>p_file in out nocopy blob</param-def>
   <param-desc>Specifies a reference to the image source blob.</param-desc>
 </param>
   <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the image width.</param-desc>
 </param>
 <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Specifies the image height.</param-desc>
 </param>
 </params>
 <return>
   <return-def>pls_integer</return-def>
   <return-desc>tThe internal index of the image</return-desc>
 </return>
*/
function addInlineImage(
  p_paragraph_id pls_integer,
  p_name varchar2 default null,
  p_file in out nocopy blob,
  p_width number default null,
  p_height number default null
  ) return pls_integer;

--v4.9.3
function addInlineImage2(
  p_paragraph_id pls_integer,
  p_name varchar2 default null,
  p_file blob,
  p_width number default null,
  p_height number default null
  ) return pls_integer;

/**
 <name>SetBackground</name>
 <type>procedure</type>
 <desc>
 Change the background color of document.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_backcolor varchar2</param-def>
   <param-desc>Specifies the background color of document, in hexadecimal RGB code.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure SetBackground(
  p_backcolor ploffx_document_type.ST_HexColor

  );

/**
 <name>addTabStop</name>
 <type>procedure</type>
 <desc>
 Add tab stop to a selected paragraph
 </desc>
 <version>v2.0.0</version>
 <params>
   <param>
     <param-def>p_paragraph_id pls_integer</param-def>
     <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
   </param>
   <param>
     <param-def>p_val ploffx_document_type.ST_TabJc</param-def>
     <param-desc>Specifies the type of tab stop.</param-desc>
   </param>
   <param>
     <param-def>p_pos number</param-def>
     <param-desc>Specifies the position of tab stop.</param-desc>
   </param>
   <param>
     <param-def>p_leader ploffx_document_type.ST_TabTlc default ploffx_document_type.c_none_Tlc</param-def>
     <param-desc>Specifies the character which shall be used to fill in the space created by a tab which ends at this custom tab stop</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure addTabStop(
  p_paragraph_id pls_integer,
  p_val ploffx_document_type.ST_TabJc,
  p_pos number,
  p_leader ploffx_document_type.ST_TabTlc default ploffx_document_type.c_none
  );

/**
 <name>addImage</name>
 <type>function</type>
 <desc>
 Add inline image to a paragraph.
 </desc>
 <version>v4.9.1</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Specifies the image name.</param-desc>
 </param>
  <param>
   <param-def>p_file in out nocopy blob</param-def>
   <param-desc>Specifies a reference to the image source blob.</param-desc>
 </param>
   <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the image width.</param-desc>
 </param>
 <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Specifies the image height.</param-desc>
 </param>
 <param>
   <param-def>p_x number</param-def>
   <param-desc>Specifies the image x coordinate of position.</param-desc>
 </param>
 <param>
   <param-def>p_y number</param-def>
   <param-desc>Specifies the image y coordinate of position.</param-desc>
 </param>
 <param>
   <param-def>p_textWrap varchar2 default 'wrapSquare'</param-def>
   <param-desc>Specifies the text wrap around the image.</param-desc>
 </param>
 <param>
   <param-def>p_relativeFromH varchar2 default 'column'</param-def>
   <param-desc>This element specifies the horizontal positioning of the image.</param-desc>
 </param>
 <param>
   <param-def>p_relativeFromV varchar2 default 'paragraph'</param-def>
   <param-desc>This element specifies the vertical positioning of the image.</param-desc>
 </param>
 <param>
   <param-def>p_locked boolean default false</param-def>
   <param-desc>Lock the image location when an application edits the document.</param-desc>
 </param>
 <param>
   <param-def>p_layoutInCell boolean default true</param-def>
   <param-desc>Specifies how image shall behave when its anchor is located in a table cell.</param-desc>
 </param>
 <param>
   <param-def>p_allowOverlap boolean default true</param-def>
   <param-desc>Specifies how image shall behave when its anchor is located in a table cell display time shall be allowed to overlap the contents of the other image.</param-desc>
 </param>
 <param>
   <param-def>p_behindDoc varchar2 default 'false'</param-def>
   <param-desc>Specifes the image to be displayed behind or above of the content.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added image.</return-desc>
 </return>
*/
function addImage(
  p_paragraph_id pls_integer,
  p_name varchar2,
  p_file in out nocopy blob,
  p_width number default null,
  p_height number default null,
  p_x number,
  p_y number,
  p_textWrap varchar2 default 'wrapSquare',
  p_relativeFromH varchar2 default 'column',
  p_relativeFromV varchar2 default 'paragraph',
  p_locked boolean default false,
  p_layoutInCell boolean default true,
  p_allowOverlap boolean default true,
  p_behindDoc varchar2 default 'false'
  ) return pls_integer;

/**
 <name>addImage</name>
 <type>procedure</type>
 <desc>
 Add inline image to a paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Specifies the image name.</param-desc>
 </param>
  <param>
   <param-def>p_file in out nocopy blob</param-def>
   <param-desc>Specifies a reference to the image source blob.</param-desc>
 </param>
   <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the image width.</param-desc>
 </param>
 <param>
   <param-def>p_height number default null</param-def>
   <param-desc>Specifies the image height.</param-desc>
 </param>
 <param>
   <param-def>p_x number</param-def>
   <param-desc>Specifies the image x coordinate of position.</param-desc>
 </param>
 <param>?
   <param-def>p_y number</param-def>
   <param-desc>Specifies the image y coordinate of position.</param-desc>
 </param>
 <param>
   <param-def>p_textWrap varchar2 default 'wrapSquare'</param-def>
   <param-desc>Specifies the text wrap around the image.</param-desc>
 </param>
 <param>
   <param-def>p_relativeFromH varchar2 default 'column'</param-def>
   <param-desc>This element specifies the horizontal positioning of the image.</param-desc>
 </param>
 <param>
   <param-def>p_relativeFromV varchar2 default 'paragraph'</param-def>
   <param-desc>This element specifies the vertical positioning of the image.</param-desc>
 </param>
 <param>
   <param-def>p_locked boolean default false</param-def>
   <param-desc>Lock the image location when an application edits the document.</param-desc>
 </param>
 <param>
   <param-def>p_layoutInCell boolean default true</param-def>
   <param-desc>Specifies how image shall behave when its anchor is located in a table cell.</param-desc>
 </param>
 <param>
   <param-def>p_allowOverlap boolean default true</param-def>
   <param-desc>Specifies how image shall behave when its anchor is located in a table cell display time shall be allowed to overlap the contents of the other image.</param-desc>
 </param>
 <param>
   <param-def>p_behindDoc varchar2 default 'false'</param-def>
   <param-desc>Specifes the image to be displayed behind or above of the content.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addImage(
  p_paragraph_id pls_integer,
  p_name varchar2,
  p_file in out nocopy blob,
  p_width number default null,
  p_height number default null,
  p_x number,
  p_y number,
  p_textWrap varchar2 default 'wrapSquare',
  p_relativeFromH varchar2 default 'column',
  p_relativeFromV varchar2 default 'paragraph',
  p_locked boolean default false,
  p_layoutInCell boolean default true,
  p_allowOverlap boolean default true,
  p_behindDoc varchar2 default 'false'
  );

/**
 <name>AddSectionP</name>
 <type>function</type>
 <desc>
 Add section for paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
  <param>
   <param-def>p_num number default null</param-def>
   <param-desc>Specifies the number of columns.</param-desc>
 </param>
  <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the columns.</param-desc>
 </param>
  <param>
   <param-def>p_type ploffx_document_type.ST_SectionMark</param-def>
   <param-desc>Specifies the type of the break point.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added section.</return-desc>
 </return>
*/
function AddSectionP(
  p_paragraph_id pls_integer default null,
  p_num number default null,
  p_space number default null,
  p_type ploffx_document_type.ST_SectionMark
  ) return pls_integer;

/**
 <name>AddSectionB</name>
 <type>function</type>
 <desc>
 Add section for body.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer default null</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. If null, then will be create a new paragraph.</param-desc>
 </param>
  <param>
   <param-def>p_num number default null</param-def>
   <param-desc>Specifies the number of columns.</param-desc>
 </param>
  <param>
   <param-def>p_space number default null</param-def>
   <param-desc>Specifies the space between the columns.</param-desc>
 </param>
  <param>
   <param-def>p_type ploffx_document_type.ST_SectionMark</param-def>
   <param-desc>Specifies the type of the break point.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added section.</return-desc>
 </return>
*/
function AddSectionB(
  p_paragraph_id pls_integer default null,
  p_num number default null,
  p_space number default null,
  p_type ploffx_document_type.ST_SectionMark
  ) return pls_integer;

/**
 <name>setSectPrPg</name>
 <type>procedure</type>
 <desc>
 Set section properties.
 </desc>
 <version>v2.0.0</version>
 <params>
   <param>
     <param-def>p_section_id pls_integer default 0</param-def>
     <param-desc>Specifies a reference to a previously defined section.</param-desc>
   </param>
   <param>
     <param-def>p_w plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the page width.</param-desc>
   </param>
   <param>
     <param-def>p_h plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the page height.</param-desc>
   </param>
   <param>
     <param-def>p_orient ploffx_util.t_string default null</param-def>
     <param-desc>Specifies the page orientation.</param-desc>
   </param>
   <param>
     <param-def>p_code plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies a printer-specific paper code.</param-desc>
   </param>
   <param>
     <param-def>p_bottom plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance  between the bottom of the text margins for the main document and the bottom of the page for all pages in this section.</param-desc>
   </param>
   <param>
     <param-def>p_footer plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance from the bottom edge of the page to the bottom edge of the footer.</param-desc>
   </param>
   <param>
     <param-def>p_gutter plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the page gutter for each page in the current section.</param-desc>
   </param>
   <param>
     <param-def>p_header plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance from the top edge of the page to the top edge of the header.</param-desc>
   </param>
   <param>
     <param-def>p_left plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance between the left edge of the page and the left edge of the text extents for this document</param-desc>
   </param>
   <param>
     <param-def>p_right plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance between the right edge of the page and the right edge of the text extents for this document.</param-desc>
   </param>
   <param>
     <param-def>p_top plx_sc.normalv2 default null</param-def>
     <param-desc>Specifies the distance between the top of the text margins for the main document and the top of the page for all pages in this section.</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure setSectPrPg(
  p_section_id pls_integer default 0,
  p_w plx_sc.normalv2 default null,
  p_h plx_sc.normalv2 default null,
  p_orient ploffx_util.t_string default null,
  p_code plx_sc.normalv2 default null,
  p_bottom plx_sc.normalv2 default null,
  p_footer plx_sc.normalv2 default null,
  p_gutter plx_sc.normalv2 default null,
  p_header plx_sc.normalv2 default null,
  p_left plx_sc.normalv2 default null,
  p_right plx_sc.normalv2 default null,
  p_top plx_sc.normalv2 default null
  );

/**
 <name>addSectionColumn</name>
 <type>procedure</type>
 <desc>
 Add section column to a previously created section.
 </desc>
 <version>v2.0.0</version>
 <params>
   <param>
     <param-def>p_section_id pls_integer default 0</param-def>
     <param-desc>Specifies a reference to a previously defined section.</param-desc>
   </param>
   <param>
     <param-def>p_num number</param-def>
     <param-desc>Number of columns.</param-desc>
   </param>
   <param>
     <param-def>p_space number</param-def>
     <param-desc>Space between columns.</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure addSectionColumn(
  p_section_id pls_integer default 0,
  p_num number,
  p_space number
  );

/**
 <name>addPageNumField</name>
 <type>function</type>
 <desc>
 Add page number to a header or footer paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. If null, then will be create a new paragraph.</param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default '  \* Arabic '</param-def>
   <param-desc>Specifies the format of the page number. In default case it use the arabic numbers.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added page number.</return-desc>
 </return>
*/
function addPageNumField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic '
  )return pls_integer;

/**
 <name>addPageNumField</name>
 <type>procedure</type>
 <desc>
 Add page number to a header or footer paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. If null, then will be create a new paragraph.</param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default '  \* Arabic '</param-def>
   <param-desc>Specifies the format of the page number. In default case it use the arabic numbers.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addPageNumField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic '
  );

--v4.9.8
function addPageNumComplexField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic ',
  p_rPr ploffx_document_type.CT_rPr default null
  ) return pls_integer;

--v4.9.8
procedure addPageNumComplexField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic ',
  p_rPr ploffx_document_type.CT_rPr default null
  );

--v4.9.8
function addNumberOfPagesField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic '
  ) return pls_integer;

--v4.9.8
procedure addNumberOfPagesField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic '
  );

--v4.9.8
function addNumberOfPagesComplexField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic ',
  p_rPr ploffx_document_type.CT_rPr default null
  ) return pls_integer;

--v4.9.8
procedure addNumberOfPagesComplexField(
  p_paragraph_id pls_integer,
  p_format varchar2 default '  \* Arabic ',
  p_rPr ploffx_document_type.CT_rPr default null
  );

/**
 <name>addDateField</name>
 <type>function</type>
 <desc>
 Add date field to a paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default ' \@ yyyy-MM-dd'</param-def>
   <param-desc>Specifies the date format.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added date field.</return-desc>
 </return>
*/
function addDateField(
  p_paragraph_id pls_integer,
  p_format varchar2 default ' \@ yyyy-MM-dd'
  )return pls_integer;

/**
 <name>addDateField</name>
 <type>procedure</type>
 <desc>
 Add date field to a paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default ' \@ yyyy-MM-dd'</param-def>
   <param-desc>Specifies the date format.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addDateField(
  p_paragraph_id pls_integer,
  p_format varchar2 default ' \@ yyyy-MM-dd'
  );

/**
 <name>addAuthorField</name>
 <type>function</type>
 <desc>
 Add author field to a previously defined paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default null</param-def>
   <param-desc>Specifies the date format.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added author field.</return-desc>
 </return>
*/
function addAuthorField(
  p_paragraph_id pls_integer,
  p_format varchar2 default null
  ) return pls_integer;

/**
 <name>addAuthorField</name>
 <type>procedure</type>
 <desc>
 Add author field to a previously defined paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
  <param>
   <param-def>p_format varchar2 default null</param-def>
   <param-desc>Specifies the date format.</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addAuthorField(
  p_paragraph_id pls_integer,
  p_format varchar2 default null
  );

/**
 <name>addHyperLink</name>
 <type>procedure</type>
 <desc>
 Add hyperlink to a previously defined paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>The hyperlink text.</param-desc>
 </param>
 <param>
   <param-def>p_url varchar2</param-def>
   <param-desc>The hyperlink URL</param-desc>
 </param>
 <param>
   <param-def>p_bold boolean default null</param-def>
   <param-desc>Bold text.</param-desc>
 </param>
 <param>
   <param-def>p_border ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies hyperlink border.</param-desc>
 </param>
 <param>
   <param-def>p_case varchar2 default null</param-def>
   <param-desc>U(pper)/L(ower)case.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies hyperlink text color.</param-desc>
 </param>
 <param>
   <param-def>p_fitText number default null</param-def>
   <param-desc>Display text in fix width.</param-desc>
 </param>
 <param>
   <param-def>p_highlight varchar2 default null</param-def>
   <param-desc>Specifies highlight color around the text.</param-desc>
 </param>
 <param>
   <param-def>p_italic boolean default null</param-def>
   <param-desc>Italic text.</param-desc>
 </param>
 <param>
   <param-def>p_vertPosition number default null</param-def>
   <param-desc>Specifies the amount to be raised or lowered the text relation to the default baseline of the</param-desc>
 </param>
 <param>
   <param-def>p_FontName varchar2 default nul</param-def>
   <param-desc>Specifies font family</param-desc>
 </param>
 <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the text style</param-desc>
 </param>
 <param>
   <param-def>p_spacing number default null</param-def>
   <param-desc>Specifies the character spacing.</param-desc>
 </param>
 <param>
   <param-def>p_strikeout number default null</param-def>
   <param-desc>Strikeout.</param-desc>
 </param>
 <param>
   <param-def>p_FontSize number default null</param-def>
   <param-desc>Specifies the font size.</param-desc>
 </param>
 <param>
   <param-def>p_underline ploffx_document_type.CT_Underline default null</param-def>
   <param-desc>Specifies the underline properties.</param-desc>
 </param>
 <param>
   <param-def>p_vertAlign varchar2 default null</param-def>
   <param-desc>Specifies the vertical alignment of the text.</param-desc>
    <param-ul>
       <param-li>baseline</param-li>
       <param-li>subscirpt</param-li>
       <param-li>superscritp</param-li>
   </param-ul>
 </param>
  <param>
   <param-def>p_w number default null</param-def>
   <param-desc>This element specifies the amount by which each character shall be expanded. </param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>The internal index of the hyperlink object.</return-desc>
</return>
*/
procedure addHyperLink(
 p_paragraph_id pls_integer,
  p_text varchar2,
  p_url varchar2,
  p_bold boolean default null,
  p_border ploffx_document_type.CT_Border default null,
  p_case varchar2 default null,
  p_color varchar2 default null,
  p_fitText number default null,
  p_highlight varchar2 default null,
  p_italic boolean default null,
  p_vertPosition number default null,
  p_FontName varchar2 default null,
  p_style varchar2 default null,
  p_spacing number default null,
  p_strikeout boolean default null,
  p_FontSize number default null,
  p_underline ploffx_document_type.CT_Underline default null,
  p_vertAlign varchar2 default null,
  p_w number default null
  );
/**
 <name>addHyperLink</name>
 <type>function</type>
 <desc>
 Add hyperlink to a previously defined paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>The hyperlink text.</param-desc>
 </param>
 <param>
   <param-def>p_url varchar2</param-def>
   <param-desc>The hyperlink URL</param-desc>
 </param>
 <param>
   <param-def>p_bold boolean default null</param-def>
   <param-desc>Bold text.</param-desc>
 </param>
 <param>
   <param-def>p_border ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies hyperlink border.</param-desc>
 </param>
 <param>
   <param-def>p_case varchar2 default null</param-def>
   <param-desc>U(pper)/L(ower)case.</param-desc>
 </param>
 <param>
   <param-def>p_color varchar2 default null</param-def>
   <param-desc>Specifies hyperlink text color.</param-desc>
 </param>
 <param>
   <param-def>p_fitText number default null</param-def>
   <param-desc>Display text in fix width.</param-desc>
 </param>
 <param>
   <param-def>p_highlight varchar2 default null</param-def>
   <param-desc>Specifies highlight color around the text.</param-desc>
 </param>
 <param>
   <param-def>p_italic boolean default null</param-def>
   <param-desc>Italic text.</param-desc>
 </param>
 <param>
   <param-def>p_vertPosition number default null</param-def>
   <param-desc>Specifies the amount to be raised or lowered the text relation to the default baseline of the</param-desc>
 </param>
 <param>
   <param-def>p_FontName varchar2 default nul</param-def>
   <param-desc>Specifies font family</param-desc>
 </param>
 <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Specifies the text style</param-desc>
 </param>
 <param>
   <param-def>p_spacing number default null</param-def>
   <param-desc>Specifies the character spacing.</param-desc>
 </param>
 <param>
   <param-def>p_strikeout number default null</param-def>
   <param-desc>Strikeout.</param-desc>
 </param>
 <param>
   <param-def>p_FontSize number default null</param-def>
   <param-desc>Specifies the font size.</param-desc>
 </param>
 <param>
   <param-def>p_underline ploffx_document_type.CT_Underline default null</param-def>
   <param-desc>Specifies the underline properties.</param-desc>
 </param>
 <param>
   <param-def>p_vertAlign varchar2 default null</param-def>
   <param-desc>Specifies the vertical alignment of the text.</param-desc>
    <param-ul>
       <param-li>baseline</param-li>
       <param-li>subscirpt</param-li>
       <param-li>superscritp</param-li>
   </param-ul>
 </param>
  <param>
   <param-def>p_w number default null</param-def>
   <param-desc>This element specifies the amount by which each character shall be expanded. </param-desc>
 </param>
 </params>
*/
function addHyperLink(
  p_paragraph_id pls_integer,
  p_text varchar2,
  p_url varchar2,
  p_bold boolean default null,
  p_border ploffx_document_type.CT_Border default null,
  p_case varchar2 default null,
  p_color varchar2 default null,
  p_fitText number default null,
  p_highlight varchar2 default null,
  p_italic boolean default null,
  p_vertPosition number default null,
  p_FontName varchar2 default null,
  p_style varchar2 default null,
  p_spacing number default null,
  p_strikeout boolean default null,
  p_FontSize number default null,
  p_underline ploffx_document_type.CT_Underline default null,
  p_vertAlign varchar2 default null,
  p_w number default null
  ) return pls_integer;

/**
 <name>addTableOfContent</name>
 <type>function</type>
 <desc>
 Add table of content to a previously defined paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added table of content.</return-desc>
 </return>
*/
function addTableOfContent(
  p_paragraph_id pls_integer
  )return pls_integer;

/**
 <name>addTableOfContent</name>
 <type>procedure</type>
 <desc>
 Add table of content to a previously defined paragraph.
 </desc>
 <version>v4.9.4</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph. </param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure addTableOfContent(
  p_paragraph_id pls_integer
  );

/**
 <name>addField</name>
 <type>function</type>
 <desc>
 Add field to a perviously defined paragraph.
 </desc>
 <version>v2.0.0</version>
 <params>
 <param>
   <param-def>p_paragraph_id pls_integer</param-def>
   <param-desc>Specifies a reference to a previously defined paragraph.</param-desc>
 </param>
 <param>
   <param-def>p_code varchar2</param-def>
   <param-desc>Specifies the field codes for the simple field.</param-desc>
 </param>
 </params>
 <return>
  <return-def>pls_integer</return-def>
  <return-desc>Index of the added field.</return-desc>
 </return>
*/
function addField(
  p_paragraph_id pls_integer,
  p_code varchar2
  )return pls_integer;

--v4.11
procedure AddChart(
  p_paragraph_id pls_integer,
  p_chart_id pls_integer,
  p_chart ploffx_chart.CT_ChartSpace,
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null
  );

--v1.3.0
procedure addFile(
  p_filename varchar2,
  p_filedata blob
  );

/**
 <name>getDoc</name>
 <type>procedure</type>
 <desc>
 Returns the generated document. The document is closed and then returned.
 </desc>
 <version>v2.0.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure getDoc(
  p_blob_file IN OUT blob
  );

/**
 <name>parseDoc</name>
 <type>Processing docx files.</type>
 <desc>
 </desc>
 <version>v2.0.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure parseDoc(
  p_blob_file in out blob
  );

/**
 <name>crList</name>
 <type>function</type>
 <desc>
   Returns the ID of the created list.
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_startValue pls_integer default 1</param-def>
   <param-desc>Specifies the starting number for the listing.</param-desc>
  </param>
  <param>
   <param-def>p_symbol XT_NUMBERING default numbering_symbol</param-def>
   <param-desc>Specifies the style of the list.</param-desc>
  </param>
 </params>
 <return>pls_integer</return>
*/
function crList(
  p_startValue pls_integer default 1,
  p_symbol ploffx_document_type.XT_Numbering default ploffx_document_type.c_symbol
  ) return pls_integer;

/**
 <name>AddListElement</name>
 <type>procedure</type>
 <desc>
   Adds an element to a list
 </desc>
 <version>v3.0.0</version>
 <params>
   <param>
     <param-def>p_paragraph_id pls_integer</param-def>
     <param-desc>Specifies the paragraph of the element that will be added to the list</param-desc>
   </param>
   <param>
     <param-def>p_level pls_integer default 0</param-def>
     <param-desc>Specifies the level of the element(0-8)</param-desc>
   </param>
   <param>
    <param-def>p_list pls_integer default 1</param-def>
    <param-desc>Specifies the list for the element to be added to.</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure AddListElement(
  p_paragraph_id pls_integer,
  p_level pls_integer default 0,
  p_list pls_integer default 1 -- v2.0.0
  );

--v5.9
procedure addNumLevel(
  p_numbering_id pls_integer,
  p_lvl pls_integer default 0,
  p_start number default 1,
  p_numFmt varchar2 default 'bullet',
  p_lvlText varchar2 default '?',
  p_FontName varchar2 default 'Symbol',
  p_FontSize number default 11,
  p_style varchar2 default null,
  p_ind_hang pls_integer default 360,
  p_ind_left pls_integer default 1440
  );

/**
 <name>crParagraphBorder</name>
 <type>function</type>
 <desc>
   Creates a paragraph border
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_top ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the top border of the paragraph</param-desc>
  </param>
  <param>
   <param-def>p_bottom ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the bottom border of the paragraph</param-desc>
  </param>
  <param>
   <param-def>p_left ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the left border of the paragraph</param-desc>
  </param>
  <param>
   <param-def>p_right ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the right border of the paragraph</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_PBdr</return-def>
   <return-desc>Returns a paragraph border which can be passed to crParagraph function </return-desc>
 </return>
*/
function crParagraphBorder(
  p_top ploffx_document_type.CT_Border default null,
  p_bottom ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border default null
) return ploffx_document_type.CT_PBdr;

/**
 <name>crBorder</name>
 <type>function</type>
 <desc>
   Creates a paragraph border
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_style ploffx_document_type.ST_Border default null</param-def>
   <param-desc>Specifies the style of the border</param-desc>
  </param>
  <param>
   <param-def>p_color ploffx_document_type.ST_HexColor default null</param-def>
   <param-desc>Specifies the color of the border</param-desc>
  </param>
  <param>
   <param-def>p_width number default null</param-def>
   <param-desc>Specifies the width of the border in points</param-desc>
  </param>
  <param>
   <param-def>p_spacing number default null</param-def>
   <param-desc>Specifies the spacing between the border and the area</param-desc>
  </param>
  <param>
   <param-def>p_shadow boolean default null</param-def>
   <param-desc>Specifies the border has shadow</param-desc>
  </param>
  <param>
   <param-def>p_frame boolean default null</param-def>
   <param-desc>Specifies the border has frame</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_Border</return-def>
   <return-desc>Returns a border which can be passed to crParagraphBorder function or AddText procedure </return-desc>
 </return>
*/
function crBorder(
  p_style ploffx_document_type.ST_Border default null,
  p_color ploffx_document_type.ST_HexColor default null,
  p_width number default null,
  p_spacing number default null,
  p_shadow boolean default null,
  p_frame boolean default null
) return ploffx_document_type.CT_Border;

/**
 <name>crIndentation</name>
 <type>function</type>
 <desc>
   Creates an identation
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_left number default null</param-def>
   <param-desc>Specifies the left identation of the paragraph in units</param-desc>
  </param>
  <param>
   <param-def>p_right number default null</param-def>
   <param-desc>Specifies the right identation of the paragraph in units</param-desc>
  </param>
  <param>
   <param-def>p_hanging number default null</param-def>
   <param-desc>Specifies the hanging identation in units</param-desc>
  </param>
  <param>
   <param-def>p_firstLine number default null</param-def>
   <param-desc>Specifies the identation of the first of the paragraph in units</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_PBdr</return-def>
   <return-desc>Returns an identation which can be passed to crParagraph function </return-desc>
 </return>
*/
function crIndentation(
  p_left number default null,
  p_right number default null,
  p_hanging number default null,
  p_firstLine number default null
) return ploffx_document_type.CT_Ind;

/**
 <name>crSpacing</name>
 <type>function</type>
 <desc>
   Creates a paragraph spacing
 </desc>
 <version>v3.0.0</version>
 <params>
  <param>
   <param-def>p_before number default null</param-def>
   <param-desc>Specifies the spacing before the paragraph in points</param-desc>
  </param>
  <param>
   <param-def>p_after number default null</param-def>
   <param-desc>Specifies the spacing after the paragraph in points</param-desc>
  <param>
  </param>
   <param-def>p_linespace number default null</param-def>
   <param-desc>Specifies the line spacing of the paragraph in lines</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_Spacing</return-def>
   <return-desc>Returns a paragraph spacing which can be passed to crParagraph function </return-desc>
 </return>
*/
function crSpacing(
  p_before number default null,
  p_after number default null,
  p_linespace number default null
  ) return ploffx_document_type.CT_Spacing;


--v4.11
function crNumPr(
  p_ilvl pls_integer default null,
  p_numId pls_integer default null
  ) return ploffx_document_type.CT_NumPr;

/**
 <name>crCellBorder</name>
 <type>function</type>
 <desc>
   Creates a table cell border
 </desc>
 <version>v3.5.0</version>
 <params>
  <param>
   <param-def>p_top ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the top side border</param-desc>
  </param>
  <param>
   <param-def>p_bottom ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the bottom side border</param-desc>
  </param>
  <param>
   <param-def>p_left ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the left side border</param-desc>
  </param>
  <param>
   <param-def>p_right ploffx_document_type.CT_Border default null</param-def>
   <param-desc>Specifies the right side border</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_TcBorders</return-def>
   <return-desc>Returns a border which can be passed to crCell function </return-desc>
 </return>
*/
function crCellBorder(
  p_top ploffx_document_type.CT_Border default null,
  p_bottom ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border default null
  ) return ploffx_document_type.CT_TcBorders;

/*v4.11 AddChart remove*/

/**
 <name>getDocument</name>
 <type>function</type>
 <desc>
   Get the full docx document structure.
 </desc>
 <version>v3.6.0</version>
 <params>-</params>
 <return>-</return>
*/
function getDocument
  return ploffx_docx_type.t_docx;


/**
 <name>crUnderline</name>
 <type>function</type>
 <desc>
   Create underline line type.
 </desc>
 <version>v3.6.0</version>
 <params>
  <param>
   <param-def>p_type ploffx_document_type.ST_Underline</param-def>
   <param-desc>Create underline type.</param-desc>
  </param>
 </params>
 <return>
   <return-def>ploffx_document_type.CT_Underline</return-def>
   <return-desc>Return a line type which using to underline.</return-desc>
 </return>
*/
function crUnderline(
  p_type ploffx_document_type.ST_Underline
  ) return ploffx_document_type.CT_Underline;


/**
 <name>AddToHeader</name>
 <type>procedure</type>
 <desc>
   Add an existing element to the document header.
 </desc>
 <version>v3.0.0</version>
 <params>
   <param>
     <param-def>p_header ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default_hfr</param-def>
     <param-desc>Specifies the header type</param-desc>
   </param>
   <param>
     <param-def>p_element_id pls_integer</param-def>
     <param-desc>Specifies the element id.</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure AddToHeader(
  p_header ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default,
  p_element_id pls_integer
  );

/**
 <name>AddToFooter</name>
 <type>procedure</type>
 <desc>
   Add an existing element to the document footer.
 </desc>
 <version>v3.0.0</version>
 <params>
   <param>
     <param-def>p_footer ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default_hfr</param-def>
     <param-desc>Specifies the header type</param-desc>
   </param>
   <param>
     <param-def>p_element_id pls_integer</param-def>
     <param-desc>Specifies the element id.</param-desc>
   </param>
 </params>
 <return>-</return>
*/
procedure AddToFooter(
  p_footer ploffx_document_type.ST_HdrFtr default ploffx_document_type.c_default,
  p_element_id pls_integer
  );

--v4.9.3
procedure addParagraphStyle(
  p_styleId varchar2,
  p_name varchar2,
  p_basedOn varchar2 default null,
  p_pPr ploffx_document_type.CT_PPr default null,
  p_rPr ploffx_document_type.CT_RPr default null
  );

--INTERNAL
function AddCell(
  p_row_id pls_integer,
  p_noWrap boolean default null,
  p_width number default null,
  p_cellBorder ploffx_document_type.CT_TcBorders default null,
  p_background ploffx_document_type.ST_HexColor default null
  ) return pls_integer;
--INTERNAL
procedure TableaddParagraph(
  p_cell_id pls_integer,
  p_paragraph_id pls_integer
  );
--INTERNAL
function getRun(
  p_paragraph pls_integer,
  p_text pls_integer
  ) return ploffx_document_type.CT_R;
--INTERNAL
procedure setRun(
  p_text pls_integer,
  p_run ploffx_document_type.CT_R
  );
--v4.8.0
--INTERNAL
procedure setStyleCustomXML(
  p_xml clob
  );
--v4.8.2
--INTERNAL
function crSdt(
  p_id varchar2 default null
  ) return pls_integer;
--v4.8.2
--INTERNAL
procedure addParagraphToSdt(
  p_sdt_id pls_integer,
  p_paragraph_id pls_integer
  );
--v4.8.2
--INTERNAL
procedure setTitlePg(
  p_val boolean default null
  );
--v4.8.2
--INTERNAL
procedure setEvenAndOddHeaders(
  p_val boolean default null
  );
--v5.8
procedure setWatermark(
  p_text varchar2,
  p_FontName ploffx_document_type.XT_FontName default null,
  p_angle pls_integer default null,
  p_transparency number default null,
  p_color varchar2 default null,
  p_width number default null,
  p_height number default null
  );
--
--
--  
end ploffx_docx;
/

