create or replace package ploffx_document_type
authid current_user is
--v5.9
--
--Structures
--
--v3.0.0
--CT_Empty
type CT_Empty is record(
  tag plx_sc.normalv2
  );
--v4.2.0
subtype ST_OnOff is ploffx_util.t_string;
--
c_0 constant ST_OnOff := '0';
c_1 constant ST_OnOff := '1';
c_no constant ST_OnOff := 'no';
c_yes constant ST_OnOff := 'yes';
c_false constant ST_OnOff := 'false';
c_true constant ST_OnOff := 'true';

type CT_OnOff is record(
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2 --ST_OnOff
  );
-- CT_LongHexNumber
type CT_LongHexNumber is record(
     tag plx_sc.normalv2, --v1.3.0
     val plx_sc.normalv2 --ST_LongHexNumber
);
--v4.9.3
-- CT_Cnf
type CT_Cnf is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2 --ST_Cnf: '101000000100' max 12
);
--
type CT_DecimalNumber is record(
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2 --ST_DecimalNumber
  );
/*
CT_Bookmark
v3.0.6
*/
type CT_Bookmark is record(
  tag plx_sc.normalv2, --
  id plx_sc.normalv2, -- ST_DecimalNumber
  name_ plx_sc.normalv2 -- ST_String
  -- displacedByCustomXml
  -- colFirst
  -- colLast
  );
/*
CT_MarkupRange
v3.0.6
*/
type CT_MarkupRange is record(
  tag plx_sc.normalv2,
  id plx_sc.normalv2 -- ST_DecimalNummber
  -- displacedByCustomXml
  );
--ST_TextDirection
subtype ST_TextDirection is ploffx_util.t_string;
--v2.0.0
c_tb constant ST_TextDirection := 'tb';
c_rl constant ST_TextDirection := 'rl';
c_lr constant ST_TextDirection := 'lr';
c_tbV constant ST_TextDirection := 'tbV';
c_rlV constant ST_TextDirection := 'rlV';
c_lrV constant ST_TextDirection := 'lrV';
--
type CT_TextDirection is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TextDirection
  );
--ST_VerticalJc
subtype ST_VerticalJc is ploffx_util.t_string;
--v2.0.0
c_top constant ST_VerticalJc :='top';
c_center constant ST_VerticalJc :='center';
c_both constant ST_VerticalJc :='both';
c_bottom constant ST_VerticalJc :='bottom';
--
type CT_VerticalJc is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_VerticalJc
  );
---- ST_NumberFormat
subtype ST_NumberFormat is ploffx_util.t_string;
--v2.0.0
c_aiueo constant ST_NumberFormat:= 'aiueo';
c_aiueoFullWidth constant ST_NumberFormat := 'aiueoFullWidth';
c_arabicAbjad constant ST_NumberFormat := 'arabicAbjad';
c_arabicAlpha constant ST_NumberFormat := 'arabicAlpha';
c_bullet constant ST_NumberFormat := 'bullet';
c_cardinalText constant ST_NumberFormat := 'cardinalText';
c_chicago constant ST_NumberFormat := 'chicago';
c_chineseCounting constant ST_NumberFormat := 'chineseCounting';
c_chineseCountingThousand constant ST_NumberFormat := 'chineseCountingThousand';
c_chineseLegalSimplified constant ST_NumberFormat := 'chineseLegalSimplified';
c_chosung constant ST_NumberFormat := 'chosung';
c_decimal constant ST_NumberFormat := 'decimal';
c_decimalEnclosedCircle constant ST_NumberFormat := 'decimalEnclosedCircle';
c_decimalEnclosedCircleChinese constant ST_NumberFormat := 'decimalEnclosedCircleChinese';
c_decimalEnclosedFullstop constant ST_NumberFormat := 'decimalEnclosedFullstop';
c_decimalEnclosedParen constant ST_NumberFormat := 'decimalEnclosedParen';
c_decimalFullWidth constant ST_NumberFormat := 'decimalFullWidth';
c_decimalFullWidth2 constant ST_NumberFormat := 'decimalFullWidth2';
c_decimalHalfWidth constant ST_NumberFormat := 'decimalHalfWidth';
c_decimalZero constant ST_NumberFormat := 'decimalZero';
c_ganada constant ST_NumberFormat := 'ganada';
c_hebrew constant ST_NumberFormat := 'hebrew';
c_hebrew2 constant ST_NumberFormat := 'hebrew2';
c_hex constant ST_NumberFormat := 'hex';
c_hindiConsonants constant ST_NumberFormat := 'hindiConsonants';
c_hindiCounting constant ST_NumberFormat := 'hindiCounting';
c_hindiNumbers constant ST_NumberFormat := 'hindiNumbers';
c_hindiVowels constant ST_NumberFormat := 'hindiVowels';
c_ideographDigital constant ST_NumberFormat := 'ideographDigital';
c_ideographEnclosedCircle constant ST_NumberFormat := 'ideographEnclosedCircle';
c_ideographLegalTraditional constant ST_NumberFormat := 'ideographLegalTraditional';
c_ideographTraditional constant ST_NumberFormat := 'ideographTraditional';
c_ideographZodiac constant ST_NumberFormat := 'ideographZodiac';
c_ideographZodiacTradicional constant ST_NumberFormat := 'ideographZodiacTradicional';
c_iroha constant ST_NumberFormat := 'iroha';
c_irohaFullWidth constant ST_NumberFormat := 'irohaFullWidth';
c_japaneseCounting constant ST_NumberFormat := 'japaneseCounting';
c_japaneseDigitalTenThousand constant ST_NumberFormat := 'japaneseDigitalTenThousand';
c_japaneseLegal constant ST_NumberFormat := 'japaneseLegal';
c_koreanCounting constant ST_NumberFormat := 'koreanCounting';
c_koreanDigital constant ST_NumberFormat := 'koreanDigital';
c_koreanDigital2 constant ST_NumberFormat := 'koreanDigital2';
c_koreanLegal constant ST_NumberFormat := 'koreanLegal';
c_lowerLetter constant ST_NumberFormat := 'lowerLetter';
c_lowerRoman constant ST_NumberFormat := 'lowerRoman';
c_none constant ST_NumberFormat := 'none';
c_numberInDash constant ST_NumberFormat := 'numberInDash';
c_ordinal constant ST_NumberFormat := 'ordinal';
c_ordinalText constant ST_NumberFormat := 'ordinalText';
c_russianLower constant ST_NumberFormat := 'russianLower';
c_russianUpper constant ST_NumberFormat := 'russianUpper';
c_taiwaneseCounting constant ST_NumberFormat := 'taiwaneseCounting';
c_taiwaneseCountingThousand constant ST_NumberFormat := 'taiwaneseCountingThousand';
c_taiwaneseDigital constant ST_NumberFormat := 'taiwaneseDigital';
c_thaiCounting constant ST_NumberFormat := 'thaiCounting';
c_thaiLetters constant ST_NumberFormat := 'thaiLetters';
c_thaiNumbers constant ST_NumberFormat := 'thaiNumbers';
c_upperLetters constant ST_NumberFormat := 'upperLetters';
c_upperRoman constant ST_NumberFormat := 'upperRoman';
c_vietnameseCounting constant ST_NumberFormat := 'vietnameseCounting';
---- CT_NumFmt
type CT_NumFmt is record(
     tag plx_sc.normalv2, --v1.3.0
     val ST_NumberFormat
     );
---- CT_Ind
type CT_Ind is record(
     tag plx_sc.normalv2, --v1.3.0
     left plx_sc.normalv2, -- ST_SignedTwipsMeasure
     leftChars plx_sc.normalv2, -- ST_DecimalNumber
     right plx_sc.normalv2, -- ST_SignedTwipsMeasure
     rightChars plx_sc.normalv2, -- ST_DecimalNumber
     hanging plx_sc.normalv2, -- ST_TwipsMeasure,
     hangingChars plx_sc.normalv2, -- ST_DecimalNumber
     firstLine plx_sc.normalv2, -- ST_TwipsMeasure
     firstLineChars plx_sc.normalv2 -- ST_DecimalNumber
     );
---- ST_ThemeColor
subtype ST_ThemeColor is ploffx_util.t_string;
--v2.0.0
c_dark1 constant ST_ThemeColor := 'dark1';
c_light1 constant ST_ThemeColor := 'light1';
c_dark2 constant ST_ThemeColor := 'dark2';
c_light2 constant ST_ThemeColor := 'light2';
c_accent1 constant ST_ThemeColor := 'accent1';
c_accent2 constant ST_ThemeColor := 'accent2';
c_accent3 constant ST_ThemeColor := 'accent3';
c_accent4 constant ST_ThemeColor := 'accent4';
c_accent5 constant ST_ThemeColor := 'accent5';
c_accent6 constant ST_ThemeColor := 'accent6';
c_hyperlink constant ST_ThemeColor := 'hyperlink';
c_followedHyperlink constant ST_ThemeColor := 'followedHyperlink';
--c_none constant ST_ThemeColor := 'none'; duplicated
c_background1 constant ST_ThemeColor := 'background1';
c_text1 constant ST_ThemeColor := 'text1';
c_background2 constant ST_ThemeColor := 'backgorund2';
c_text2 constant ST_ThemeColor := 'text2';
--
type CT_Color is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2, --ST_HexColor
  themeColor ST_ThemeColor,
  themeTint plx_sc.normalv2, --ST_UcharHexNumber
  themeShade plx_sc.normalv2 --ST_UcharHexNumber
  );
----ST_Lang
subtype ST_Lang is ploffx_util.t_string;
--values?
type CT_Language is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Lang,
  eastAsia ST_Lang,
  bidi ST_Lang
  );
---- ST_Hint
subtype ST_Hint is ploffx_util.t_string;
--v2.0.0
c_default constant ST_Hint := 'default';
c_eastAsia constant ST_Hint := 'eastAsia';
c_cs constant ST_Hint := 'cs';
---- ST_Theme
subtype ST_Theme is ploffx_util.t_string;
--v2.0.0
c_majorEastAsia_te constant ST_Theme := 'majorEastAsia';
c_majorBidi_te constant ST_Theme := 'majorBidi';
c_majorAscii_te constant ST_Theme := 'majorAscii';
c_majorHAnsi_te constant ST_Theme := 'majorHAnsi';
c_minorEastAsia_te constant ST_Theme := 'minorEastAsia';
c_minorBidi_te constant ST_Theme := 'minorBidi';
c_minorAscii_te constant ST_Theme := 'minorAscii';
c_minorHAnsi_te constant ST_Theme := 'minorHAnsi';
----Run Fonts
type CT_Fonts is record(
  tag plx_sc.normalv2, --v1.3.0
  hint ST_Hint,
  ascii plx_sc.normalv2,
  hAnsi plx_sc.normalv2,
  eastAsia plx_sc.normalv2,
  cs plx_sc.normalv2,
  asciiTheme ST_Theme,
  hAnsiTheme ST_Theme,
  eastAsiaTheme ST_Theme,
  csTheme ST_Theme
  );
--
type CT_HpsMeasure is record(
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2 --ST_HpsMeasure
  );
--
subtype ST_Underline is ploffx_util.t_string;
--v2.0.0
c_single constant ST_Underline := 'single';
c_words constant ST_Underline := 'words';
c_double constant ST_Underline := 'double';
c_thick constant ST_Underline := 'thick';
c_dotted constant ST_Underline := 'dotted';
c_dottedHeavy constant ST_Underline := 'dottedHeavy';
c_dash constant ST_Underline := 'dash';
c_dashedHeavy constant ST_Underline := 'dashedHeavy';
c_dashLong constant ST_Underline := 'dasLong';
c_dashLongHeavy constant ST_Underline := 'dashLongHeavy';
c_dotDash constant ST_Underline := 'dotDash';
c_dashDotHeavy constant ST_Underline := 'dashDotHeavy';
c_dotDotDash constant ST_Underline := 'dotDotDash';
c_dashDotDotHeavy constant ST_Underline := 'dashDotDotHeavy';
c_wave constant ST_Underline := 'wave';
c_wavyHeavy constant ST_Underline := 'wavyHeavy';
c_wavyDouble constant ST_Underline := 'wavyDouble';
-- c_none constant ST_Underline := 'none'; duplicated
--
type CT_Underline is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Underline,
  color plx_sc.normalv2, --ST_HexColor
  themeColor ST_ThemeColor,
  themeTint plx_sc.normalv2, --ST_UcharHexNumber
  themeShade plx_sc.normalv2 --ST_UcharHexNumber
  );
---- ST_Border
subtype ST_Border is ploffx_util.t_string;
--v2.0.0
c_nil   constant ST_Border :='nil';
--c_none   constant ST_Border :='none'; --duplicated
--c_single   constant ST_Border :='single'; --duplicated
--c_thick   constant ST_Border :='thick'; --duplicated
--c_double   constant ST_Border :='double'; --duplicated
--c_dotted   constant ST_Border :='dotted'; --duplicated
c_dashed   constant ST_Border :='dashed';
--c_dotDash   constant ST_Border :='dotDash'; --duplicated
--c_dotDotDash   constant ST_Border :='dotDotDash'; --duplicated
c_triple   constant ST_Border :='triple';
c_thinThickSmallGap   constant ST_Border :='thinThickSmallGap';
c_thickThinSmallGap   constant ST_Border :='thickThinSmallGap';
c_thinThickThinSmallGap   constant ST_Border :='thinThickThinSmallGap';
c_thinThickMediumGap   constant ST_Border :='thinThickMediumGap';
c_thickThinMediumGap   constant ST_Border :='thickThinMediumGap';
c_thinThickThinMediumGap   constant ST_Border :='thinThickThinMediumGap';
c_thinThickLargeGap   constant ST_Border :='thinThickLargeGap';
c_thickThinLargeGap   constant ST_Border :='thickThinLargeGap';
c_thinThickThinLargeGap   constant ST_Border :='thinThickThinLargeGap';
--c_wave   constant ST_Border :='wave'; --duplicated
c_doubleWave   constant ST_Border :='doubleWave';
c_dashSmallGap   constant ST_Border :='dashSmallGap';
c_dashDotStroked   constant ST_Border :='dashDotStroked';
c_threeDEmboss   constant ST_Border :='threeDEmboss';
c_threeDEngrave   constant ST_Border :='threeDEngrave';
c_outset   constant ST_Border :='outset';
c_inset   constant ST_Border :='inset';
c_apples   constant ST_Border :='apples';
c_archedScallops   constant ST_Border :='archedScallops';
c_babyPacifier   constant ST_Border :='babyPacifier';
c_babyRattle   constant ST_Border :='babyRattle';
c_balloons3Colors   constant ST_Border :='balloons3Colors';
c_balloonsHotAir   constant ST_Border :='balloonsHotAir';
c_basicBlackDashes   constant ST_Border :='basicBlackDashes';
c_basicBlackDots   constant ST_Border :='basicBlackDots';
c_basicBlackSquares   constant ST_Border :='basicBlackSquares';
c_basicThinLines   constant ST_Border :='basicThinLines';
c_basicWhiteDashes   constant ST_Border :='basicWhiteDashes';
c_basicWhiteDots   constant ST_Border :='basicWhiteDots';
c_basicWhiteSquares   constant ST_Border :='basicWhiteSquares';
c_basicWideInline   constant ST_Border :='basicWideInline';
c_basicWideMidline   constant ST_Border :='basicWideMidline';
c_basicWideOutline   constant ST_Border :='basicWideOutline';
c_bats   constant ST_Border :='bats';
c_birds   constant ST_Border :='birds';
c_birdsFlight   constant ST_Border :='birdsFlight';
c_cabins   constant ST_Border :='cabins';
c_cakeSlice   constant ST_Border :='cakeSlice';
c_candyCorn   constant ST_Border :='candyCorn';
c_celticKnotwork   constant ST_Border :='celticKnotwork';
c_classicalWave   constant ST_Border :='classicalWave';
c_clocks   constant ST_Border :='clocks';
c_compass   constant ST_Border :='compass';
c_confetti   constant ST_Border :='confetti';
c_confettiGrays   constant ST_Border :='confettiGrays';
c_confettiOutline   constant ST_Border :='confettiOutline';
c_confettiStreamers   constant ST_Border :='confettiStreamers';
c_confettiWhite   constant ST_Border :='confettiWhite';
c_cornerTriangles   constant ST_Border :='cornerTriangles';
c_couponCutoutDashes   constant ST_Border :='couponCutoutDashes';
c_couponCutoutDots   constant ST_Border :='couponCutoutDots';
c_crazyMaze   constant ST_Border :='crazyMaze';
c_creaturesButterfly   constant ST_Border :='creaturesButterfly';
c_creaturesFish   constant ST_Border :='creaturesFish';
c_creaturesInsects   constant ST_Border :='creaturesInsects';
c_creaturesLadyBug   constant ST_Border :='creaturesLadyBug';
c_crossStitch   constant ST_Border :='crossStitch';
c_cup   constant ST_Border :='cup';
c_decoArch   constant ST_Border :='decoArch';
c_decoArchColor   constant ST_Border :='decoArchColor';
c_decoBlocks   constant ST_Border :='decoBlocks';
c_diamondsGray   constant ST_Border :='diamondsGray';
c_doubleD   constant ST_Border :='doubleD';
c_doubleDiamonds   constant ST_Border :='doubleDiamonds';
c_earth1   constant ST_Border :='earth1';
c_earth2   constant ST_Border :='earth2';
c_eclipsingSquares1   constant ST_Border :='eclipsingSquares1';
c_eclipsingSquares2   constant ST_Border :='eclipsingSquares2';
c_eggsBlack   constant ST_Border :='eggsBlack';
c_fans   constant ST_Border :='fans';
c_film   constant ST_Border :='film';
c_firecrackers   constant ST_Border :='firecrackers';
c_flowersBlockPrint   constant ST_Border :='flowersBlockPrint';
c_flowersDaisies   constant ST_Border :='flowersDaisies';
c_flowersModern1   constant ST_Border :='flowersModern1';
c_flowersModern2   constant ST_Border :='flowersModern2';
c_flowersPansy   constant ST_Border :='flowersPansy';
c_flowersRedRose   constant ST_Border :='flowersRedRose';
c_flowersRoses   constant ST_Border :='flowersRoses';
c_flowersTeacup   constant ST_Border :='flowersTeacup';
c_flowersTiny   constant ST_Border :='flowersTiny';
c_gems   constant ST_Border :='gems';
c_gingerbreadMan   constant ST_Border :='gingerbreadMan';
c_gradient   constant ST_Border :='gradient';
c_handmade1   constant ST_Border :='handmade1';
c_handmade2   constant ST_Border :='handmade2';
c_heartBalloon   constant ST_Border :='heartBalloon';
c_heartGray   constant ST_Border :='heartGray';
c_hearts   constant ST_Border :='hearts';
c_heebieJeebies   constant ST_Border :='heebieJeebies';
c_holly   constant ST_Border :='holly';
c_houseFunky   constant ST_Border :='houseFunky';
c_hypnotic   constant ST_Border :='hypnotic';
c_iceCreamCones   constant ST_Border :='iceCreamCones';
c_lightBulb   constant ST_Border :='lightBulb';
c_lightning1   constant ST_Border :='lightning1';
c_lightning2   constant ST_Border :='lightning2';
c_mapPins   constant ST_Border :='mapPins';
c_mapleLeaf   constant ST_Border :='mapleLeaf';
c_mapleMuffins   constant ST_Border :='mapleMuffins';
c_marquee   constant ST_Border :='marquee';
c_marqueeToothed   constant ST_Border :='marqueeToothed';
c_moons   constant ST_Border :='moons';
c_mosaic   constant ST_Border :='mosaic';
c_musicNotes   constant ST_Border :='musicNotes';
c_northwest   constant ST_Border :='northwest';
c_ovals   constant ST_Border :='ovals';
c_packages   constant ST_Border :='packages';
c_palmsBlack   constant ST_Border :='palmsBlack';
c_palmsColor   constant ST_Border :='palmsColor';
c_paperClips   constant ST_Border :='paperClips';
c_papyrus   constant ST_Border :='papyrus';
c_partyFavor   constant ST_Border :='partyFavor';
c_partyGlass   constant ST_Border :='partyGlass';
c_pencils   constant ST_Border :='pencils';
c_people   constant ST_Border :='people';
c_peopleWaving   constant ST_Border :='peopleWaving';
c_peopleHats   constant ST_Border :='peopleHats';
c_poinsettias   constant ST_Border :='poinsettias';
c_postageStamp   constant ST_Border :='postageStamp';
c_pumpkin1   constant ST_Border :='pumpkin1';
c_pushPinNote2   constant ST_Border :='pushPinNote2';
c_pushPinNote1   constant ST_Border :='pushPinNote1';
c_pyramids   constant ST_Border :='pyramids';
c_pyramidsAbove   constant ST_Border :='pyramidsAbove';
c_quadrants   constant ST_Border :='quadrants';
c_rings   constant ST_Border :='rings';
c_safari   constant ST_Border :='safari';
c_sawtooth   constant ST_Border :='sawtooth';
c_sawtoothGray   constant ST_Border :='sawtoothGray';
c_scaredCat   constant ST_Border :='scaredCat';
c_seattle   constant ST_Border :='seattle';
c_shadowedSquares   constant ST_Border :='shadowedSquares';
c_sharksTeeth   constant ST_Border :='sharksTeeth';
c_shorebirdTracks   constant ST_Border :='shorebirdTracks';
c_skyrocket   constant ST_Border :='skyrocket';
c_snowflakeFancy   constant ST_Border :='snowflakeFancy';
c_snowflakes   constant ST_Border :='snowflakes';
c_sombrero   constant ST_Border :='sombrero';
c_southwest   constant ST_Border :='southwest';
c_stars   constant ST_Border :='stars';
c_starsTop   constant ST_Border :='starsTop';
c_stars3d   constant ST_Border :='stars3d';
c_starsBlack   constant ST_Border :='starsBlack';
c_starsShadowed   constant ST_Border :='starsShadowed';
c_sun   constant ST_Border :='sun';
c_swirligig   constant ST_Border :='swirligig';
c_tornPaper   constant ST_Border :='tornPaper';
c_tornPaperBlack   constant ST_Border :='tornPaperBlack';
c_trees   constant ST_Border :='trees';
c_triangleParty   constant ST_Border :='triangleParty';
c_triangles   constant ST_Border :='triangles';
c_tribal1   constant ST_Border :='tribal1';
c_tribal2   constant ST_Border :='tribal2';
c_tribal3   constant ST_Border :='tribal3';
c_tribal4   constant ST_Border :='tribal4';
c_tribal5   constant ST_Border :='tribal5';
c_tribal6   constant ST_Border :='tribal6';
c_twistedLines1   constant ST_Border :='twistedLines1';
c_twistedLines2   constant ST_Border :='twistedLines2';
c_vine   constant ST_Border :='vine';
c_waveline   constant ST_Border :='waveline';
c_weavingAngles   constant ST_Border :='weavingAngles';
c_weavingBraid   constant ST_Border :='weavingBraid';
c_weavingRibbon   constant ST_Border :='weavingRibbon';
c_weavingStrips   constant ST_Border :='weavingStrips';
c_whiteFlowers   constant ST_Border :='whiteFlowers';
c_woodwork   constant ST_Border :='woodwork';
c_xIllusions   constant ST_Border :='xIllusions';
c_zanyTriangles   constant ST_Border :='zanyTriangles';
c_zigZag   constant ST_Border :='zigZag';
c_zigZagStitch   constant ST_Border :='zigZagStitch';
--v4.7.0
subtype ST_HexColor is varchar2(8 char); --argb
c_Black constant ST_HexColor := '000000';
c_Navy constant ST_HexColor := '000080';
c_Dark_blue constant ST_HexColor := '00008B';
c_Medium_blue constant ST_HexColor := '0000CD';
c_Blue constant ST_HexColor := '0000FF';
c_Dark_green constant ST_HexColor := '006400';
c_Green constant ST_HexColor := '008000';
c_Teal constant ST_HexColor := '008080';
c_Dark_cyan constant ST_HexColor := '008B8B';
c_Deep_sky_blue constant ST_HexColor := '00BFFF';
c_Dark_turquoise constant ST_HexColor := '00DED1';
c_Medium_spring_green constant ST_HexColor := '00FA9A';
c_Lime constant ST_HexColor := '00FF00';
c_Spring_green constant ST_HexColor := '00FF7F';
c_Cyan constant ST_HexColor := '00FFFF';
c_Midnight_blue constant ST_HexColor := '191970';
c_Dodger_blue constant ST_HexColor := '1E90FF';
c_Light_seagreen constant ST_HexColor := '20B2AA';
c_Forest_green constant ST_HexColor := '228B22';
c_Sea_green constant ST_HexColor := '2E8B57';
c_Dark_slate_gray constant ST_HexColor := '2F4F4F';
c_Lime_green constant ST_HexColor := '32CD32';
c_Medium_sea_green constant ST_HexColor := '3CB371';
c_Turquoise constant ST_HexColor := '40E0D0';
c_Royal_blue constant ST_HexColor := '4169E1';
c_Steelblue constant ST_HexColor := '4682B4';
c_Dark_slate_blue constant ST_HexColor := '483D8B';
c_Medium_turquoise constant ST_HexColor := '48D1CC';
c_Indigo constant ST_HexColor := '4B0082';
c_Dark_olive_green constant ST_HexColor := '556B2F';
c_Cadet_blue constant ST_HexColor := '5F9EA0';
c_Cornflower_blue constant ST_HexColor := '6495ED';
c_Medium_aquamarine constant ST_HexColor := '66CDAA';
c_Dim_gray constant ST_HexColor := '696969';
c_Slate_blue constant ST_HexColor := '6A5ACD';
c_Olive_drab constant ST_HexColor := '6B8E23';
c_Light_slate_gray constant ST_HexColor := '778899';
c_Medium_slate_blue constant ST_HexColor := '7B68EE';
c_Lawngreen constant ST_HexColor := '7CFC00';
c_Chartreuse constant ST_HexColor := '7FFF00';
c_Aquamarine constant ST_HexColor := '7FFFD4';
c_Maroon constant ST_HexColor := '800000';
c_Purple constant ST_HexColor := '800080';
c_Gray constant ST_HexColor := '808080';
c_Sky_blue constant ST_HexColor := '87CEEB';
c_Light_sky_blue constant ST_HexColor := '87CEFA';
c_Blue_violet constant ST_HexColor := '8A2BE2';
c_Dark_red constant ST_HexColor := '8B0000';
c_Dark_magenta constant ST_HexColor := '8B008B';
c_Saddle_brown constant ST_HexColor := '8B4513';
c_Dark_seagreen constant ST_HexColor := '8DBC8F';
c_Light_green constant ST_HexColor := '90EE90';
c_Medium_purple constant ST_HexColor := '9370DB';
c_Dark_violet constant ST_HexColor := '9400D3';
c_Pale_green constant ST_HexColor := '98FB98';
c_Dark_orchid constant ST_HexColor := '9932CC';
c_Yellow_green constant ST_HexColor := '9ACD32';
c_Sienna constant ST_HexColor := 'A0522D';
c_Brown constant ST_HexColor := 'A52A2A';
c_Dark_gray constant ST_HexColor := 'A9A9A9';
c_Light_blue constant ST_HexColor := 'ADD8E6';
c_Green_yellow constant ST_HexColor := 'ADFF2F';
c_Pale_turquoise constant ST_HexColor := 'AFEEEE';
c_Light_steel_blue constant ST_HexColor := 'B0C4DE';
c_Powder_blue constant ST_HexColor := 'B0E0E6';
c_Firebrick constant ST_HexColor := 'B22222';
c_Dark_goldenrod constant ST_HexColor := 'B8860B';
c_Medium_orchid constant ST_HexColor := 'BA55D3';
c_Rosy_brown constant ST_HexColor := 'BC8F8F';
c_Dark_khaki constant ST_HexColor := 'BDB76B';
c_Silver constant ST_HexColor := 'C0C0C0';
c_Medium_violet_red constant ST_HexColor := 'C71585';
c_Indian_red constant ST_HexColor := 'CD5C5C';
c_Peru constant ST_HexColor := 'CD853F';
c_Chocolate constant ST_HexColor := 'D2691E';
c_Tan constant ST_HexColor := 'D2B48C';
c_Light_grey constant ST_HexColor := 'D3D3D3';
c_Thistle constant ST_HexColor := 'D8BFD8';
c_Orchid constant ST_HexColor := 'DA70D6';
c_Goldenrod constant ST_HexColor := 'DAA520';
c_Pale_violet_red constant ST_HexColor := 'DB7093';
c_Crimson constant ST_HexColor := 'DC143C';
c_Gainsboro constant ST_HexColor := 'DCDCDC';
c_Plum constant ST_HexColor := 'DDA0DD';
c_Burlywood constant ST_HexColor := 'DEB887';
c_Mauve constant ST_HexColor := 'E0B0FF';
c_Light_cyan constant ST_HexColor := 'E0FFFF';
c_Lavender constant ST_HexColor := 'E6E6FA';
c_Dark_salmon constant ST_HexColor := 'E9967A';
c_Violet constant ST_HexColor := 'EE82EE';
c_Pale_goldenrod constant ST_HexColor := 'EEE8AA';
c_Light_coral constant ST_HexColor := 'F08080';
c_Khaki constant ST_HexColor := 'F0E68C';
c_Alice_blue constant ST_HexColor := 'F0F8FF';
c_Honeydew constant ST_HexColor := 'F0FFF0';
c_Azure constant ST_HexColor := 'F0FFFF';
c_Sandy_brown constant ST_HexColor := 'F4A460';
c_Wheat constant ST_HexColor := 'F5DEB3';
c_Beige constant ST_HexColor := 'F5F5DC';
c_Whitesmoke constant ST_HexColor := 'F5F5F5';
c_Mint_cream constant ST_HexColor := 'F5FFFA';
c_Ghost_white constant ST_HexColor := 'F8F8FF';
c_Salmon constant ST_HexColor := 'FA8072';
c_Antique_white constant ST_HexColor := 'FAEBD7';
c_Linen constant ST_HexColor := 'FAF0E6';
c_Light_goldenrod_yellow constant ST_HexColor := 'FAFAD2';
c_Old_lace constant ST_HexColor := 'FDF5E6';
c_Red constant ST_HexColor := 'FF0000';
c_Magenta constant ST_HexColor := 'FF00FF';
c_Deep_pink constant ST_HexColor := 'FF1493';
c_Orange_red constant ST_HexColor := 'FF4500';
c_Tomato constant ST_HexColor := 'FF6347';
c_Hot_pink constant ST_HexColor := 'FF69B4';
c_Coral constant ST_HexColor := 'FF7F50';
c_Dark_orange constant ST_HexColor := 'FF8C00';
c_Light_salmon constant ST_HexColor := 'FFA07A';
c_Orange constant ST_HexColor := 'FFA500';
c_Light_pink constant ST_HexColor := 'FFB6C1';
c_Pink constant ST_HexColor := 'FFC8CB';
c_Gold constant ST_HexColor := 'FFD700';
c_Peach_puff constant ST_HexColor := 'FFDAB9';
c_Navajo_white constant ST_HexColor := 'FFDEAD';
c_Moccasin constant ST_HexColor := 'FFE4B5';
c_Bisque constant ST_HexColor := 'FFE4C4';
c_Misty_rose constant ST_HexColor := 'FFE4E1';
c_Blanched_almond constant ST_HexColor := 'FFEBCD';
c_Papaya_whip constant ST_HexColor := 'FFEFD5';
c_Lavender_blush constant ST_HexColor := 'FFF0F5';
c_Sea_shell constant ST_HexColor := 'FFF5EE';
c_Cornsilk constant ST_HexColor := 'FFF8DC';
c_Lemon_chiffon constant ST_HexColor := 'FFFACD';
c_Floral_white constant ST_HexColor := 'FFFAF0';
c_Snow constant ST_HexColor := 'FFFAFA';
c_Yellow constant ST_HexColor := 'FFFF00';
c_Light_yellow constant ST_HexColor := 'FFFFE0';
c_Ivory constant ST_HexColor := 'FFFFF0';
c_White constant ST_HexColor := 'FFFFFF';
---- Border
type CT_Border is record(
  tag plx_sc.normalv2, --v1.3.0
  val ST_Border,
  color ST_HexColor, --ST_HexColor
  themeColor ST_ThemeColor,
  themeTint plx_sc.normalv2, --ST_UcharHexNumber
  themeShade plx_sc.normalv2, --ST_UcharHexNumber
  sz plx_sc.normalv2, --ST_EighthPointMeasure
  space plx_sc.normalv2, --ST_PointMeasure
  shadow plx_sc.normalv2, --ST_OnOff
  frame plx_sc.normalv2 --ST_OnOff
  );
-- ST_CombineBrackets
subtype ST_CombineBrackets is ploffx_util.t_string;
--v2.0.0
--c_none constant ST_CombineBrackets := 'none';
c_round constant ST_CombineBrackets := 'round';
c_square constant ST_CombineBrackets := 'square';
c_angle constant ST_CombineBrackets := 'angle';
c_curly constant ST_CombineBrackets := 'curly';
--CT_EastAsianLayout: eastAsianLayout (East Asian Typography Settings)
type CT_EastAsianLayout is record (
  tag plx_sc.normalv2, --v1.3.0
  id plx_sc.normalv2, --ST_DecimalNumber
  combine ST_OnOff,
  combineBrackets ST_CombineBrackets,
  vert ST_OnOff,
  vertCompress ST_OnOff
  );
--ST_TextEffect
subtype ST_TextEffect is ploffx_util.t_string;
--v2.0.0
c_blinkBackground constant ST_TextEffect := 'blinkBackground';
c_lights constant ST_TextEffect := 'lights';
c_antsBlack constant ST_TextEffect := 'antsBlack';
c_antsRed constant ST_TextEffect := 'antsRed';
c_shimmer constant ST_TextEffect := 'shimmer';
c_sparkle constant ST_TextEffect := 'sparkle';
--c_none constant ST_TextEffect := 'none'; --duplicated
--
--CT_TextEffect: Animated Text Effect
type CT_TextEffect is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TextEffect
  );
--ST_Em
subtype ST_Em is ploffx_util.t_string;
--v2.0.0
--c_none constant ST_Em := 'none'; --duplicated
c_dot constant ST_Em := 'dot';
c_comma constant ST_Em := 'comma';
c_circle constant ST_Em := 'circle';
c_underDot constant ST_Em := 'underDot';
--
type CT_Em is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Em
  );
--
type CT_FitText is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2, -- ST_TwipsMeasure
  id plx_sc.normalv2 --ST_DecimalNumber
  );
--ST_HighlightColor
subtype ST_HighlightColor is ploffx_util.t_string;
--v2.0.0
c_black_ constant ST_HighlightColor := 'black';
c_blue_ constant ST_HighlightColor := 'blue';
c_cyan_ constant ST_HighlightColor := 'cyan';
c_green_ constant ST_HighlightColor := 'green';
c_magenta_ constant ST_HighlightColor := 'magenta';
c_red_ constant ST_HighlightColor := 'red';
c_yellow_ constant ST_HighlightColor := 'yellow';
c_white_ constant ST_HighlightColor := 'white';
c_darkBlue constant ST_HighlightColor := 'darkBlue';
c_darkCyan constant ST_HighlightColor := 'darkCyan';
c_darkGreen constant ST_HighlightColor := 'darkGreen';
c_darkMagenta constant ST_HighlightColor := 'darkMagenta';
c_darkRed constant ST_HighlightColor := 'darkRed';
c_darkYellow constant ST_HighlightColor := 'darkYellow';
c_darkGray constant ST_HighlightColor := 'darkGray';
c_lightGray constant ST_HighlightColor := 'lightGray';
-- c_none constant ST_HighlightColor := 'none'; duplicated
--
type CT_Highlight is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_HighlightColor
  );
--
type CT_SignedHpsMeasure is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2
  );
--
type CT_String is record(
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.maxv2 --v4.7.0
  );
--ST_Shd
subtype ST_Shd is ploffx_util.t_string;
--v2.0.0
--c_nil constant ST_Shd := 'nil'; --duplicated
c_clear constant ST_Shd := 'clear';
c_solid constant ST_Shd := 'solid';
c_horzStripe constant ST_Shd := 'horzStripe';
c_vertStripe constant ST_Shd := 'vertStripe';
c_reverseDiagStripe constant ST_Shd := 'reverseDiagStripe';
c_diagStripe constant ST_Shd := 'diagStripe';
c_horzCross constant ST_Shd := 'horzCross';
c_diagCross constant ST_Shd := 'diagCross';
c_thinHorzStripe constant ST_Shd := 'thinHorzStripe';
c_thinVertStripe constant ST_Shd := 'thinVertStripe';
c_thinReverseDiagStripe constant ST_Shd := 'thinReverseDiagStripe';
c_thinDiagStripe constant ST_Shd := 'thinDiagStripe';
c_thinHorzCross constant ST_Shd := 'thinHorzCross';
c_thinDiagCross constant ST_Shd := 'thinDiagCross';
c_pct5 constant ST_Shd := 'pct5';
c_pct10 constant ST_Shd := 'pct10';
c_pct12 constant ST_Shd := 'pct12';
c_pct15 constant ST_Shd := 'pct15';
c_pct20 constant ST_Shd := 'pct20';
c_pct25 constant ST_Shd := 'pct25';
c_pct30 constant ST_Shd := 'pct30';
c_pct35 constant ST_Shd := 'pct35';
c_pct37 constant ST_Shd := 'pct37';
c_pct40 constant ST_Shd := 'pct40';
c_pct45 constant ST_Shd := 'pct45';
c_pct50 constant ST_Shd := 'pct50';
c_pct55 constant ST_Shd := 'pct55';
c_pct60 constant ST_Shd := 'pct60';
c_pct62 constant ST_Shd := 'pct62';
c_pct65 constant ST_Shd := 'pct65';
c_pct70 constant ST_Shd := 'pct70';
c_pct75 constant ST_Shd := 'pct75';
c_pct80 constant ST_Shd := 'pct80';
c_pct85 constant ST_Shd := 'pct85';
c_pct87 constant ST_Shd := 'pct87';
c_pct90 constant ST_Shd := 'pct90';
c_pct95 constant ST_Shd := 'pct95';
--
type CT_Shd is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Shd,
  color plx_sc.normalv2, --ST_HexColor,
  themeColor ST_ThemeColor,
  themeTint plx_sc.normalv2, --ST_UcharHexNumber,
  themeShade plx_sc.normalv2, --ST_UcharHexNumber,
  fill plx_sc.normalv2, --ST_HexColor,
  themeFill ST_ThemeColor,
  themeFillTint plx_sc.normalv2, --ST_UcharHexNumber,
  themeFillShade plx_sc.normalv2 --ST_UcharHexNumber
  );
--CT_SignedTwipsMeasure
type CT_SignedTwipsMeasure is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2
  );
--ST_VerticalAlignRun
subtype ST_VerticalAlignRun is ploffx_util.t_string;
--v2.0.0
c_baseline constant ST_VerticalAlignRun := 'baseline';
c_superscript constant ST_VerticalAlignRun := 'superscript';
c_subscript constant ST_VerticalAlignRun := 'subscript';
-- CT_VerticalAlignRun
type CT_VerticalAlignRun is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_VerticalAlignRun
  );
--CT_TextScale
type CT_TextScale is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2 --ST_TextScale
  );
----Run Properties
type CT_RPr is record (
  tag plx_sc.normalv2, --v1.3.0
  b CT_OnOff, -- b: Bold
  bCs CT_OnOff, -- bCs: Complex Script Bold
  bdr CT_Border, -- bdr: Text Border
  caps CT_OnOff, -- caps: Display All Characters As Capital Letters
  color CT_Color, --color
  cs CT_OnOff, --cs: Use Complex Script Formatting on Run
  dstrike CT_OnOff, --dstrike: Double Strikethrough
  eastAsianLayout CT_EastAsianLayout, --eastAsianLayout: East Asian Typography Settings
  effect CT_TextEffect, --effect: Animated Text Effect
  em CT_Em, --em: Emphasis Mark
  emboss CT_OnOff, --emboss: Embossing
  fitText CT_FitText, --fitText: Manual Run Width
  highlight CT_Highlight, --highlight: Text Highlighting
  i CT_OnOff, --i: Italics
  iCs CT_OnOff, --iCs: Complex Script Italics
  imprint CT_OnOff, --imprint: Imprinting
  kern CT_HpsMeasure, --kern: Font Kerning
  lang CT_Language, --lang: Languages for Run Content
  noProof CT_OnOff, --noProof: Do Not Check Spelling or Grammar
  oMath CT_OnOff, --oMath: Office Open XML Math
  outline CT_OnOff, --outline: Display Character Outline
  position CT_SignedHpsMeasure, --position: Vertically Raised or Lowered Text
  rFonts CT_Fonts, --rFonts: Run Fonts
  --rPrChange --rPrChange: Revision Information for Run Properties
  rStyle CT_String, --rStyle: Referenced Character Style
  rtl CT_OnOff, --rtl: Right To Left Text
  shadow CT_OnOff, --shadow: Shadow
  shd CT_Shd, --shd: Run Shading
  smallCaps CT_OnOff, --smallCaps: Small Caps
  snapToGrid CT_OnOff, --snapToGrid: Use Document Grid Settings For Inter-Character Spacing
  spacing CT_SignedTwipsMeasure, --spacing: Character Spacing Adjustment
  specVanish CT_OnOff, --specVanish: Paragraph Mark Is Always Hidden
  strike CT_OnOff, --strike: Single Strikethrough
  sz CT_HpsMeasure, --sz: Font Size
  szCs CT_HpsMeasure, --szCs: Complex Script Font Size
  u CT_Underline, --u: Underline
  vanish CT_OnOff, --vanish: Hidden Text
  vertAlign CT_VerticalAlignRun, --vertAlign: Subscript/Superscript Text
  w CT_TextScale, --w: Expanded/Compressed Text
  webHidden CT_OnOff --webHidden: Web Hidden Text
  );
--
subtype ST_PageOrientation is ploffx_util.t_string;
--v2.0.0
c_portrait  constant ST_PageOrientation := 'portrait';
c_landscape constant ST_PageOrientation := 'landscape';
--
type CT_Background is record (
  tag plx_sc.normalv2, --v1.3.0
  color plx_sc.normalv2, -- ST_HexColor
  themeColor ST_ThemeColor,
  themeShade plx_sc.normalv2, -- ST_UcharHexNumber,
  themeTint plx_sc.normalv2 -- ST_UcharHexNumber
  );
--
type CT_Text is record (
  tag plx_sc.normalv2, --v1.3.0
  xml_space plx_sc.normalv2,
  text plx_sc.maxv2
  );
--------------------------------------------------------
--drawing
--v1.3.0
type CT_Point2D is record (
  tag plx_sc.normalv2, --v1.3.0
  x plx_sc.normalv2, --ST_Coordinate
  y plx_sc.normalv2  --ST_Coordinate
  );
--v4.7.0
subtype ST_Align is ploffx_util.t_string;
--v1.3.0
subtype ST_AlignH is ploffx_util.t_string;
--v2.0.0
c_left constant ST_AlignH := 'left';
c_right constant ST_AlignH := 'right';
--c_center constant ST_AlignH := 'center'; --duplicated
c_inside constant ST_AlignH := 'inside';
c_outside constant ST_AlignH := 'outside';
--v1.3.0
subtype ST_RelFromH is ploffx_util.t_string;
--v2.0.0
c_margin constant ST_RelFromH := 'margin';
c_page constant ST_RelFromH := 'page';
c_column constant ST_RelFromH := 'column';
c_character constant ST_RelFromH := 'character';
c_leftMargin constant ST_RelFromH := 'leftMargin';
c_rightMargin constant ST_RelFromH := 'rightMargin';
c_insideMargin constant ST_RelFromH := 'insideMargin';
c_outsideMargin constant ST_RelFromH := 'outsideMargin';
--v1.3.0
type CT_PosH is record (
  tag plx_sc.normalv2, --v1.3.0
  posh_type varchar2(255 char), --align, posOffset
  align ST_AlignH,
  posOffset plx_sc.normalv2, --ST_PositionOffset xsd:int
  relativeFrom ST_RelFromH
  );
--v1.3.0
subtype ST_AlignV is ploffx_util.t_string;
--v2.0.0
-- c_top constant ST_AlignV := 'top'; --duplicated
-- c_bottom constant ST_AlignV := 'bottom'; --duplicated
-- c_center constant ST_AlignV := 'center'; --duplicated
--c_inside constant ST_AlignV := 'inside'; --duplicated
--c_outside constant ST_AlignV := 'outside'; --duplicated
--v1.3.0
subtype ST_RelFromV is ploffx_util.t_string;
--v2.0.0
-- c_margin constant ST_RelFromV := 'margin'; --duplicated
-- c_page constant ST_RelFromV := 'page'; --duplicated
c_paragraph constant ST_RelFromV := 'paragraph';
c_line constant ST_RelFromV := 'line';
c_topMargin constant ST_RelFromV := 'topMargin';
c_bottomMargin constant ST_RelFromV := 'bottomMargin';
-- c_insideMargin constant ST_RelFromV := 'insideMargin'; --dupli
-- c_outsideMargin constant ST_RelFromV := 'outsideMargin'; --dupli
--v1.3.0
type CT_PosV is record (
  tag plx_sc.normalv2, --v1.3.0
  posv_type varchar2(255 char), --align, posOffset
  align ST_AlignV,
  posOffset plx_sc.normalv2, --ST_PositionOffset xsd:int
  relativeFrom ST_RelFromV
  );
--v1.3.0
type CT_PositiveSize2D is record (
  tag plx_sc.normalv2, --v1.3.0
  cx plx_sc.normalv2, --ST_PositiveCoordinate
  cy plx_sc.normalv2 --ST_PositiveCoordinate
  );
--
type CT_EffectExtent is record (
  tag plx_sc.normalv2, --v1.3.0
  l plx_sc.normalv2, --ST_Coordinate
  t plx_sc.normalv2, --ST_Coordinate
  r plx_sc.normalv2, --ST_Coordinate
  b plx_sc.normalv2 --ST_Coordinate
  );
--v1.3.0
subtype CT_WrapNone is boolean; --true means write tag
--v1.3.0
subtype ST_WrapText is ploffx_util.t_string;
--v2.0.0
c_bothSides constant ST_WrapText := 'bothSides';
--c_left constant ST_WrapText := 'left'; --dupli
--c_right constant ST_WrapText := 'right'; --dupli
c_largest constant ST_WrapText := 'largest';
--v1.3.0
type CT_WrapSquare is record (
  tag plx_sc.normalv2, --v1.3.0
  effectExtent CT_EffectExtent,
  wrapText ST_WrapText,
  distT plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distB plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distL plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distR plx_sc.normalv2 --ST_WrapDistance xsd:unsignedInt
  );
--v1.3.0
type t_Point2Ds is table of CT_Point2D;
--v1.3.0
type CT_WrapPath is record (
  tag plx_sc.normalv2, --v1.3.0
  start_ CT_Point2D,
  lineTos t_Point2Ds,
  edited plx_sc.normalv2 --xsd:boolean
  );
--v1.3.0
type CT_WrapTight is record (
  tag plx_sc.normalv2, --v1.3.0
  wrapPolygon CT_WrapPath,
  wrapText ST_WrapText,
  distL plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distR plx_sc.normalv2 --ST_WrapDistance xsd:unsignedInt
  );
--v1.3.0
type CT_WrapThrough is record (
  tag plx_sc.normalv2, --v1.3.0
  wrapPolygon CT_WrapPath,
  wrapText ST_WrapText,
  distL plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distR plx_sc.normalv2 --ST_WrapDistance xsd:unsignedInt
  );
--v1.3.0
type CT_WrapTopBottom is record (
  tag plx_sc.normalv2, --v1.3.0
  effectExtent CT_EffectExtent,
  distT plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distB plx_sc.normalv2 --ST_WrapDistance xsd:unsignedInt
  );
--v1.3.0
type CT_EmbeddedWAVAudioFile is record (
  tag plx_sc.normalv2, --v1.3.0
  embed plx_sc.normalv2, --ref="r:embed"
  name plx_sc.normalv2
  );
--v1.3.0
subtype t_ext is plx_sc.normalv2; --TODO: Any element from any namespace
--v1.3.0
type CT_OfficeArtExtensionList is table of t_ext;
v_OfficeArtExtensionList_empty CT_OfficeArtExtensionList := CT_OfficeArtExtensionList();
--v1.3.0
type CT_Hyperlink is record (
  tag plx_sc.normalv2, --v1.3.0
  snd CT_EmbeddedWAVAudioFile,
  extLst CT_OfficeArtExtensionList,
  id plx_sc.normalv2, --ref="r:id"
  invalidUrl plx_sc.normalv2,
  action plx_sc.normalv2,
  tgtFrame plx_sc.normalv2,
  tooltip plx_sc.normalv2,
  history plx_sc.normalv2, --xsd:boolean
  highlightClick plx_sc.normalv2, --xsd:boolean
  endSnd plx_sc.normalv2 --xsd:boolean
  );
--v1.3.0
type CT_NonVisualDrawingProps is record (
  tag plx_sc.normalv2, --v1.3.0
  hlinkClick CT_Hyperlink,
  hlinkHover CT_Hyperlink,
  extLst CT_OfficeArtExtensionList,
  id plx_sc.normalv2, --ST_DrawingElementId, xsd:unsignedInt
  name plx_sc.normalv2,
  descr plx_sc.normalv2,
  hidden plx_sc.normalv2, --xsd:boolean
  title plx_sc.normalv2
  );
--v1.3.0
type CT_GraphicalObjectFrameLocking is record (
  tag plx_sc.normalv2, --v1.3.0
  extLst CT_OfficeArtExtensionList,
  noGrp plx_sc.normalv2, --xsd:boolean
  noDrilldown plx_sc.normalv2, --xsd:boolean
  noSelect plx_sc.normalv2, --xsd:boolean
  noChangeAspect plx_sc.normalv2, --xsd:boolean
  noMove plx_sc.normalv2, --xsd:boolean
  noResize plx_sc.normalv2 --xsd:boolean
  );
--v1.3.0
type CT_NonVisualGraphicFrameProps is record (
  tag plx_sc.normalv2, --v1.3.0
  graphicFrameLocks CT_GraphicalObjectFrameLocking,
  extLst CT_OfficeArtExtensionList
  );
--v1.3.0
type t_any_graphicData is record (
  tag plx_sc.normalv2, --v1.3.0
  any_type varchar2(255 char), --'pic'
  pic ploffx_picture.CT_Picture --pic
  );
-- v3.6.0
type t_chart_rel is record(
  tag plx_sc.normalv2,
  r_id varchar2(255) default null
  );
--v1.3.0
type CT_GraphicalObjectData is record (
  tag plx_sc.normalv2, --v1.3.0
  pic ploffx_picture.CT_Picture, --any
  uri plx_sc.normalv2,--xsd:token
  chart t_chart_rel
  );
--v1.3.0
type CT_GraphicalObject is record (
  tag plx_sc.normalv2, --v1.3.0
  graphicData CT_GraphicalObjectData
  );
--v1.3.0
type CT_Anchor is record (
  tag plx_sc.normalv2, --v1.3.0
  simplePos CT_Point2D,
  positionH CT_PosH,
  positionV CT_PosV,
  extent CT_PositiveSize2D,
  effectExtent CT_EffectExtent,
  --EG_WrapType
  wrapNone CT_WrapNone,
  wrapSquare CT_WrapSquare,
  wrapTight CT_WrapTight,
  wrapThrough CT_WrapThrough,
  wrapTopAndBottom CT_WrapTopBottom,
  --
  docPr CT_NonVisualDrawingProps,
  cNvGraphicFramePr CT_NonVisualGraphicFrameProps, --CT_NonVisualGraphicFrameProperties
  graphic CT_GraphicalObject,
  distT plx_sc.normalv2, --ST_WrapDistance, xsd:unsignedInt
  distB plx_sc.normalv2, --plx_sc.normalv2, --ST_WrapDistance, xsd:unsignedInt
  distL plx_sc.normalv2, --ST_WrapDistance, xsd:unsignedInt
  distR plx_sc.normalv2, --ST_WrapDistance, xsd:unsignedInt
  simplePos_ plx_sc.normalv2, --xsd:boolean
  relativeHeight plx_sc.normalv2, --xsd:unsignedInt
  behindDoc plx_sc.normalv2, --xsd:boolean
  locked plx_sc.normalv2, --xsd:boolean
  layoutInCell plx_sc.normalv2, --xsd:boolean
  hidden plx_sc.normalv2, --xsd:boolean
  allowOverlap plx_sc.normalv2 --xsd:boolean
  );
--v1.3.0
type CT_Inline is record (
  tag plx_sc.normalv2, --v1.3.0
  extent CT_PositiveSize2D,
  effectExtent CT_EffectExtent,
  docPr CT_NonVisualDrawingProps,
  cNvGraphicFramePr CT_NonVisualGraphicFrameProps, --CT_NonVisualGraphicFrameProperties
  graphic CT_GraphicalObject,
  distT plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distB plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distL plx_sc.normalv2, --ST_WrapDistance xsd:unsignedInt
  distR plx_sc.normalv2 --ST_WrapDistance xsd:unsignedInt
  );
--v3.0.2
type CT_Drawing is record (
  tag plx_sc.normalv2, --v1.3.0
  drawing_type varchar2(255 char), --anchor,inline
  anchor CT_Anchor, --(Anchor for Floating DrawingML Object)
  inline CT_Inline --(Inline DrawingML Object)
  );
--v3.0.6
subtype ST_BrType is ploffx_util.t_string;
--v3.0.6
--c_page constant ST_BrType := 'page'; --dupli
--c_column constant ST_BrType := 'column'; --dupli
c_textWrapping constant ST_BrType := 'textWrapping';
--v3.0.6
subtype ST_BrClear is ploffx_util.t_string;
--v3.0.6
--c_none constant ST_BrClear := 'none'; duplicated
--c_left constant ST_BrClear := 'left';
--c_right constant ST_BrClear := 'right';
c_all constant ST_BrClear := 'all';
-- CT_Br
-- v3.0.6
type CT_Br is record (
  tag plx_sc.normalv2, -- v3.0.6
  type_ ST_BrType,
  clear ST_BrClear
  );
--v3.0.7
subtype ST_FldCharType is ploffx_util.t_string;
c_begin constant ST_FldCharType := 'begin';
c_separate constant ST_FldCharType := 'separate';
c_end constant ST_FldCharType := 'end';
--
type CT_FldChar is record (
  tag plx_sc.normalv2,  --v3.0.7
  fldCharType ST_FldCharType,
  fldLock ST_OnOff,
  dirty ST_OnOff
  );
--  
--v5.8
type CT_Picture is record (
  tag plx_sc.normalv2,
  shapetype ploffx_vmldrawing.CT_Shapetype,
  shape ploffx_vmldrawing.CT_shape
  );  
---------------------------------------------------------
type t_rinnercontent is record (
  tag plx_sc.normalv2, --v1.3.0
  rinnercontent_type plx_sc.normalv2,
  -- annotationRef --Comment Information Block
  br CT_Br,
  -- commentReference --Comment Content Reference Mark
  -- continuationSeparator --Continuation Separator Mark
  -- cr --Carriage Return
  -- dayLong --Date Block - Long Day Format
  -- dayShort --Date Block - Short Day Format
  -- delInstrText --Deleted Field Code
  -- delText --Deleted Text
  drawing CT_Drawing, --DrawingML Object
  -- endnoteRef --Endnote Reference Mark
  -- endnoteReference --Endnote Reference
  fldChar CT_FldChar, --Complex Field Character
  -- footnoteRef --Footnote Reference Mark
  -- footnoteReference --Footnote Reference
  instrText CT_Text,
  -- lastRenderedPageBreak --Position of Last Calculated Page Break
  -- monthLong --Date Block - Long Month Format
  -- monthShort --Date Block - Short Month Format
  -- noBreakHyphen --Non Breaking Hyphen Character
  -- object --Inline Embedded Object
  -- pgNum --Page Number Block
  pict CT_Picture,--VML Object
  -- ptab --Absolute Position Tab Character
  -- ruby --Phonetic Guide
  -- separator --Footnote/Endnote Separator Mark
  -- softHyphen --Optional Hyphen Character
  -- sym --Symbol Character
  t CT_Text, --Text
  tab CT_Empty --Tab Character
  -- yearLong --Date Block - Long Year Format
  -- yearShort --Date Block - Short Year Format
  );
--
type t_rinnercontents is table of t_rinnercontent;
v_rinnercontents_empty t_rinnercontents := t_rinnercontents();
--
type CT_R is record (
  tag plx_sc.normalv2, --v1.3.0
  rPr CT_RPr,--Run Properties
  rinnercontents t_rinnercontents,
  rsidRPr plx_sc.normalv2, --ST_LongHexNumber
  rsidDel plx_sc.normalv2, --ST_LongHexNumber
  rsidR plx_sc.normalv2 --ST_LongHexNumber
  );
--v1.3.0
type CT_Attr is record (
  tag plx_sc.normalv2, --v1.3.0
  uri plx_sc.normalv2,
  name plx_sc.normalv2,
  val plx_sc.normalv2
  );
--v1.3.0
type t_attrs is table of CT_Attr;
--v1.3.0
type CT_CustomXmlPr is record (
  placeholder plx_sc.normalv2,
  attr t_attrs
  );
--
type t_pcontents is table of pls_integer; --block_item_ref
v_pcontents_empty t_pcontents := t_pcontents();
--v1.3.0
type CT_CustomXmlRun is record (
  customXmlPr CT_CustomXmlPr,
  pcontent t_pcontents, --EG_PContent
  uri plx_sc.normalv2,
  element plx_sc.normalv2
  );
--v2.0.0
type CT_SimpleField is record(
  tag plx_sc.normalv2,
  instr plx_sc.normalv2,
  fldLock ST_OnOff,
  dirty ST_OnOff
  );
--v2.0.0
type CT_Hyperlink_W is record(
  tag plx_sc.normalv2,
  id plx_sc.normalv2,
  tgtFrame plx_sc.normalv2,
  tooltip plx_sc.normalv2,
  docLocation plx_sc.normalv2,
  history ST_OnOff,
  anchor plx_sc.normalv2,
  text t_pcontents -- inner run
);
--
type t_pcontent is record (
  tag plx_sc.normalv2, --v1.3.0
  pcontent_type varchar2(255 char),
  bookmarkEnd CT_MarkupRange, --Bookmark End
  bookmarkStart CT_Bookmark, --Bookmark Start
  -- commentRangeEnd --Comment Anchor Range End
  -- commentRangeStart --Comment Anchor Range Start
  customXml CT_CustomXmlRun, --Inline-Level Custom XML Element
  -- customXmlDelRangeEnd --Custom XML Markup Deletion End
  -- customXmlDelRangeStart --Custom XML Markup Deletion Start
  -- customXmlInsRangeEnd --Custom XML Markup Insertion End
  -- customXmlInsRangeStart --Custom XML Markup Insertion Start
  -- customXmlMoveFromRangeEnd --Custom XML Markup Move Source End
  -- customXmlMoveFromRangeStart --Custom XML Markup Move Source Start
  -- customXmlMoveToRangeEnd --Custom XML Markup Move Destination Location End
  -- customXmlMoveToRangeStart --Custom XML Markup Move Destination Location Start
  -- del --Deleted Run Content
  fldSimple CT_SimpleField, -- v2.0.0
  hyperlink CT_Hyperlink_W, --v2.0.0
  -- ins --Inserted Run Content
  -- moveFrom --Move Source Run Content
  -- moveFromRangeEnd --Move Source Location Container - End
  -- moveFromRangeStart --Move Source Location Container - Start
  -- moveTo --Move Destination Run Content
  -- moveToRangeEnd --Move Destination Location Container - End
  -- moveToRangeStart --Move Destination Location Container - Start
  -- oMath --Office Math
  -- oMathPara --Math Paragraph
  -- permEnd --Range Permission End
  -- permStart --Range Permission Start
  -- proofErr --Proofing Error Anchor
  r CT_R, -- Text Run
  sdt ploffx_document_type.CT_Sdt -- sdt --Inline-Level Structured Document Tag
  -- smartTag --Inline-Level Smart Tag
  -- subDoc --Anchor for Subdocument Location
  );
--
type t_pcontent_items is table of t_pcontent;
v_pcontent_items_empty t_pcontent_items := t_pcontent_items();
--
subtype ST_Jc is ploffx_util.t_string;
--v2.0.0
--c_left constant ST_Jc := 'left'; --dupli
--c_center constant ST_Jc := 'center'; --dupli
--c_right constant ST_Jc := 'right'; --dupli
--c_both constant ST_Jc := 'both'; --dupli
c_mediumKashida constant ST_Jc := 'mediumKashida';
c_distribute constant ST_Jc := 'distribute';
c_numTab constant ST_Jc := 'numTab';
c_highKashida constant ST_Jc := 'highKashida';
c_lowKashida constant ST_Jc := 'lowKashida';
c_thaiDistribute constant ST_Jc := 'thaiDistribute';
--
type CT_Jc is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Jc
  );
--
type CT_TrackChangeNumbering is record (
  tag plx_sc.normalv2, --v1.3.0
  author plx_sc.normalv2, --ST_String
  date plx_sc.normalv2, --ST_DateTime
  id plx_sc.normalv2, --ST_DecimalNumber
  original plx_sc.normalv2 --ST_String
  );
--
type CT_TrackChange is record (
  tag plx_sc.normalv2, --v1.3.0
  author plx_sc.normalv2, --ST_String
  date plx_sc.normalv2, --ST_DateTime
  id plx_sc.normalv2 --ST_DecimalNumber
  );
--
type CT_NumPr is record (
  tag plx_sc.normalv2, --v1.3.0
  ilvl CT_DecimalNumber,
  numId CT_DecimalNumber,
  numberingChange CT_TrackChangeNumbering,
  ins CT_TrackChange
  );
--v1.3.0
type CT_Rel is record(
  tag plx_sc.normalv2, --v1.3.0
  id plx_sc.normalv2 -- r:id
);
---- ST_LineSpacingRule
subtype ST_LineSpacingRule is ploffx_util.t_string;
--v2.0.0
c_auto constant ST_LineSpacingRule := 'auto';
c_exact constant ST_LineSpacingRule := 'exact';
c_atLeast constant ST_LineSpacingRule := 'atLeast';
--
type CT_Spacing is record(
  tag plx_sc.normalv2, --v1.3.0
  before plx_sc.normalv2, --ST_TwipsMeasure
  beforeLines plx_sc.normalv2, --ST_DecimalNumber
  beforeAutospacing plx_sc.normalv2, --ST_OnOff
  after plx_sc.normalv2, --ST_TwipsMeasure
  afterLines plx_sc.normalv2, --ST_DecimalNumber
  afterAutospacing plx_sc.normalv2, --ST_OnOff
  line plx_sc.normalv2, --ST_SignedTwipsMeasure
  lineRule ST_LineSpacingRule -- ST_LineSpacingRule
  );
--
subtype ST_DropCap is ploffx_util.t_string;
--v2.0.0
-- c_none constant ST_DropCap := 'none'; --dupli
c_drop constant ST_DropCap := 'drop';
-- c_margin constant ST_DropCap := 'margin'; --duplicated
--
subtype ST_Wrap is ploffx_util.t_string;
--v2.0.0
--c_auto constant ST_Wrap := 'auto'; --dupli
c_notBeside constant ST_Wrap := 'notBeside';
c_around constant ST_Wrap := 'around';
c_tight constant ST_Wrap := 'tight';
c_through constant ST_Wrap := 'through';
-- c_none constant ST_Wrap := 'none'; --dupli
--
subtype ST_Anchor is ploffx_util.t_string;
--
subtype ST_HAnchor is ploffx_util.t_string;
--v2.0.0
c_text constant ST_HAnchor := 'text';
-- c_margin constant ST_HAnchor := 'margin';  --duplicated
-- c_page constant ST_HAnchor := 'page'; --dupli
--
subtype ST_VAnchor is ploffx_util.t_string;
--v2.0.0
-- c_text constant ST_VAnchor := 'text'; --dupli
-- c_margin constant ST_VAnchor := 'margin'; --duplicated
-- c_page constant ST_VAnchor := 'page'; --dupli
--
subtype ST_XAlign is ploffx_util.t_string;
--v2.0.0
-- c_left constant ST_XAlign := 'left'; --dupli
-- c_center constant ST_XAlign := 'center'; --dupli
-- c_right constant ST_XAlign := 'right'; --dupli
-- c_inside constant ST_XAlign := 'inside'; --dupli
-- c_outside constant ST_XAlign := 'outside'; --dupli
--
subtype ST_YAlign is ploffx_util.t_string;
--v2.0.0
c_inline constant ST_YAlign := 'inline';
-- c_top constant ST_YAlign := 'top'; --dupli
-- c_center constant ST_YAlign := 'center'; --dupli
-- c_bottom constant ST_YAlign := 'bottom'; --dupli
-- c_inside constant ST_YAlign := 'inside';  --dupli
-- c_outside constant ST_YAlign := 'outside';  --dupli
--
subtype ST_Rule is ploffx_util.t_string;
--
subtype ST_HeightRule is ploffx_util.t_string;
--v2.0.0
-- c_auto constant ST_HeightRule := 'auto'; --dupli
-- c_exact constant ST_HeightRule := 'exact'; --dupli
-- c_atLeast constant ST_HeightRule := 'atLeast'; --dupli
--
--CT_FramePr
type CT_FramePr is record (
  tag plx_sc.normalv2, --v1.3.0
  dropCap ST_DropCap,
  lines plx_sc.normalv2, --ST_DecimalNumber
  w plx_sc.normalv2, --ST_TwipsMeasure
  h plx_sc.normalv2, --ST_TwipsMeasure
  vSpace plx_sc.normalv2, --ST_TwipsMeasure
  hSpace plx_sc.normalv2, --ST_TwipsMeasure
  wrap ST_Wrap,
  hAnchor ST_HAnchor,
  vAnchor ST_VAnchor,
  x plx_sc.normalv2, --ST_SignedTwipsMeasure
  xAlign ST_XAlign,
  y plx_sc.normalv2, --ST_SignedTwipsMeasure
  yAlign ST_YAlign,
  hRule ST_HeightRule,
  anchorLock ST_OnOff
  );
--CT_PBdr
type CT_PBdr is record (
  tag plx_sc.normalv2, --v1.3.0
  top CT_Border,
  left CT_Border,
  bottom CT_Border,
  right CT_Border,
  between_ CT_Border,
  bar CT_Border
  );
-- ST_HdrFtr (Header or Footer Type)
subtype ST_HdrFtr is ploffx_util.t_string;
-- c_default constant ST_HdrFtr := 'default'; --dupli
c_even constant ST_HdrFtr := 'even';
c_first constant ST_HdrFtr := 'first';
--
type CT_HdrFtrRef is record(
  tag plx_sc.normalv2, --v1.3.0
  id plx_sc.normalv2,
  type_ ST_HdrFtr
  );
type t_HdrFtrRef_ is table of CT_HdrFtrRef;
v_HdrFtrRef_empty t_HdrFtrRef_ := t_HdrFtrRef_();
--
type CT_PageSz is record (
  tag plx_sc.normalv2, --v1.3.0
  w plx_sc.normalv2, --ST_TwipsMeasure
  h plx_sc.normalv2, --ST_TwipsMeasure
  orient ST_PageOrientation,
  code plx_sc.normalv2 --ST_DecimalNumber
  );
--v1.3.0
type CT_Column is record (
     tag plx_sc.normalv2, --v1.3.0
     w plx_sc.normalv2,
     space plx_sc.normalv2
     );
--
type t_col_ is table of CT_Column;
v_col_empty t_col_ := t_col_();
--v1.3.0
type CT_Columns is record (
  tag plx_sc.normalv2, --v1.3.0
  equalWidth plx_sc.normalv2,
  num plx_sc.normalv2,
  sep plx_sc.normalv2,
  space plx_sc.normalv2,
  col t_col_
  );
--v1.3.0
subtype ST_DocGrid is ploffx_util.t_string;
--v2.0.0
--c_default constant ST_DocGrid := 'default'; --dupli
c_lines constant ST_DocGrid := 'lines';
c_linesAndChars constant ST_DocGrid := 'linesAndChars';
c_snapToChars constant ST_DocGrid := 'snapToChars';
--v1.3.0
type CT_DocGrid is record(
  tag plx_sc.normalv2, --v1.3.0
  charSpace plx_sc.normalv2,
  linePitch plx_sc.normalv2,
  type_ ST_DocGrid
  );
--v1.3.0
subtype ST_RestartNumber is ploffx_util.t_string;
--v2.0.0
c_continous constant ST_RestartNumber := 'continous';
c_eachPage constant ST_RestartNumber := 'eachPage';
c_eachSect constant ST_RestartNumber := 'eachSect';
--v1.3.0
type CT_NumRestart is record(
  tag plx_sc.normalv2, --v1.3.0
  val ST_RestartNumber
  );
--v1.3.0
subtype ST_EdnPos is ploffx_util.t_string;
--v2.0.0
c_docEnd constant ST_EdnPos := 'docEnd';
c_sectEnd constant ST_EdnPos := 'sectEnd';
--v1.3.0
type CT_EdnPos is record(
  tag plx_sc.normalv2, --v1.3.0
  val ST_EdnPos
  );
--v1.3.0
type CT_EdnProps is record(
  tag plx_sc.normalv2, --v1.3.0
  numFmt CT_NumFmt,
  numRestart CT_NumRestart,
  numStart CT_DecimalNumber,
  pos CT_EdnPos
  );
--v1.3.0
subtype ST_FtnPos is ploffx_util.t_string;
--v2.0.0
c_beneathText constant ST_FtnPos := 'beneathText';
-- c_docEnd constant ST_FtnPos := 'docEnd'; --dupli
c_pageBottom constant ST_FtnPos := 'pageBottom';
-- c_sectEnd constant ST_FtnPos := 'sectEnd'; --dupli
--v1.3.0
type CT_FtnPos is record(
  tag plx_sc.normalv2, --v1.3.0
  val ST_FtnPos
  );
--v1.3.0
type CT_FtnProps is record(
  tag plx_sc.normalv2, --v1.3.0
  numFmt CT_NumFmt,
  numRestart CT_NumRestart,
  numStart CT_DecimalNumber,
  pos CT_FtnPos
  );
--v1.3.0
type CT_LineNumber is record(
  tag plx_sc.normalv2, --v1.3.0
  countBy plx_sc.normalv2,
  distance plx_sc.normalv2,
  restart plx_sc.normalv2,
  start_ plx_sc.normalv2
  );
--
type CT_PaperSource is record(
  tag plx_sc.normalv2, --v1.3.0
  first_ plx_sc.normalv2,
  other plx_sc.normalv2
  );
--v1.3.0
subtype ST_PageBorderDisplay is ploffx_util.t_string;
--v2.0.0
c_allPages constant ST_PageBorderDisplay := 'allPages';
c_firstPage constant ST_PageBorderDisplay := 'firstPage';
c_noFirstPage constant ST_PageBorderDisplay := 'noFirstPage';
--v1.3.0
subtype ST_PageBorderOffset is ploffx_util.t_string;
--v.2.0.0
--c_page constant ST_PageBorderOffset := 'page'; --dupli
--c_text constant ST_PageBorderOffset := 'text'; --dupli
--v1.3.0
subtype ST_PageBorderZOrder is ploffx_util.t_string;
--v2.0.0
c_back constant ST_PageBorderZOrder := 'back';
c_front constant ST_PageBorderZOrder := 'front';
--v1.3.0
type CT_PageBorders is record(
  tag plx_sc.normalv2, --v1.3.0
  display ST_PageBorderDisplay,
  offsetFrom ST_PageBorderOffset,
  zOrder ST_PageBorderZOrder,
  top CT_Border,
  left CT_Border,
  right CT_Border,
  bottom CT_Border
  );
--v1.3.0
type CT_PageMar is record(
  tag plx_sc.normalv2, --v1.3.0
  bottom plx_sc.normalv2,
  footer plx_sc.normalv2,
  gutter plx_sc.normalv2,
  header plx_sc.normalv2,
  left plx_sc.normalv2,
  right plx_sc.normalv2,
  top plx_sc.normalv2
  );
--v1.3.0
type CT_PageNumber is record(
  tag plx_sc.normalv2, --v1.3.0
  chapSep plx_sc.normalv2,
  chapStyle plx_sc.normalv2,
  fmt plx_sc.normalv2,
  start_p plx_sc.normalv2
  );
--v1.3.0
type CT_SectPrChange is record(
  tag plx_sc.normalv2, --v1.3.0
  author plx_sc.normalv2,
  date_ plx_sc.normalv2,
  id plx_sc.normalv2
  -- sectPr
  );
--v1.3.0
subtype ST_SectionMark is ploffx_util.t_string;
--v2.0.0
-- c_continous constant ST_SectionMark :='continous'; --dupli
c_evenPage constant ST_SectionMark := 'evenPage';
c_nextColumn constant ST_SectionMark := 'nextColumn';
c_nextPage constant ST_SectionMark := 'nextPage';
c_oddPage constant ST_SectionMark := 'oddPage';
--v1.3.0
type CT_SectType is record(
  tag plx_sc.normalv2, --v1.3.0
  val ST_SectionMark
  );
--v1.3.0
type CT_SectPr is record (
  tag plx_sc.normalv2, --v1.3.0
  rsidDel plx_sc.normalv2, --ST_LongHexNumber
  rsidR plx_sc.normalv2, --ST_LongHexNumber
  rsidRPr plx_sc.normalv2, --ST_LongHexNumber
  rsidSect plx_sc.normalv2, --ST_LongHexNumber
  bidi CT_OnOff, --Right to Left Section Layou
  cols CT_Columns, --Column Definitions
  docGrid CT_DocGrid, --Document Grid
  endnotePr CT_EdnProps, --Section-Wide Endnote Properties
  footerReference t_HdrFtrRef_, --
  footerReference_default CT_HdrFtrRef, --Footer Reference
  footerReference_even CT_HdrFtrRef,
  footerReference_first CT_HdrFtrRef,
  footnotePr CT_FtnProps, --Section-Wide Footnote Properties
  formProt CT_OnOff, --Only Allow Editing of Form Fields
  headerReference t_HdrFtrRef_,
  headerReference_default CT_HdrFtrRef, --Header Reference
  headerReference_even CT_HdrFtrRef,
  headerReference_first CT_HdrFtrRef,
  lnNumType CT_LineNumber, --Line Numbering Settings
  noEndnote CT_OnOff, --Suppress Endnotes In Document
  paperSrc CT_PaperSource, --Paper Source Information
  pgBorders CT_PageBorders, --Page Borders
  pgMar CT_PageMar, --Page Margins
  pgNumType CT_PageNumber, --Page Numbering Settings
  pgSz CT_PageSz, --Page Size
  printerSettings CT_Rel, --Reference to Printer Settings Data
  rtlGutter CT_OnOff, --Gutter on Right Side of Page
  sectPrChange CT_SectPrChange, --Revision Information for Section Properties
  textDirection CT_TextDirection, --Text Flow Direction
  titlePg CT_OnOFf,--Different First Page Headers and Footers
  type_ CT_SectType, --Section Type
  vAlign CT_VerticalJc --Vertical Text Alignment on Page
  );
--ST_TabJc
subtype ST_TabJc is ploffx_util.t_string;
--v5.0
-- c_clear constant ST_TabJc := 'clear'; --dupli
--c_start constant ST_TabJc := 'start'; --dupli
--c_center constant ST_TabJc := 'center'; --dupli
-- c_end constant ST_TabJc := 'end'; --dupli
-- c_decimal constant ST_TabJc := 'decimal'; --dupli
c_bar constant ST_TabJc := 'bar';
c_num constant ST_TabJc := 'num';
--ST_TabTlc
subtype ST_TabTlc is ploffx_util.t_string;
--v2.0.0
-- c_none constant ST_TabTlc := 'none'; --dupli
-- c_dot constant ST_TabTlc := 'dot'; --dupli
c_hyphen constant ST_TabTlc := 'hyphen';
c_underscore constant ST_TabTlc := 'underscore';
c_heavy constant ST_TabTlc := 'heavy';
c_middleDot constant ST_TabTlc := 'middleDot';
--
type CT_TabStop is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TabJc,
  leader ST_TabTlc,
  pos plx_sc.normalv2 --ST_SignedTwipsMeasure
  );
--
type CT_Tabs is table of CT_TabStop;
v_tabs_empty CT_Tabs := CT_Tabs();
--ST_TextAlignment
subtype ST_TextAlignment is ploffx_util.t_string;
--v2.0.0
-- c_top constant ST_TextAlignment := 'top'; --dupli
-- c_center constant ST_TextAlignment := 'center'; --dupli
c_baseline_tat constant ST_TextAlignment := 'baseline';
-- c_bottom constant ST_TextAlignment := 'bottom'; --dupli
-- c_auto constant ST_TextAlignment := 'auto'; --dupli
--
type CT_TextAlignment is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TextAlignment
  );
--ST_TextboxTightWrap
subtype ST_TextboxTightWrap is ploffx_util.t_string;
--v2.0.0
-- c_none constant ST_TextboxTightWrap := 'none'; --dupli
c_allLines constant ST_TextboxTightWrap := 'allLines';
c_firstAndLastLine constant ST_TextboxTightWrap := 'firstAndLastLine';
c_firstLineOnly constant ST_TextboxTightWrap := 'firstLineOnly';
c_lastLineOnly constant ST_TextboxTightWrap := 'lastLineOnly';
--
type CT_TextboxTightWrap is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TextboxTightWrap
  );
--
type CT_PPr is record (
  tag plx_sc.normalv2, --v1.3.0
  adjustRightInd CT_OnOff, --Automatically Adjust Right Indent When Using Document Grid
  autoSpaceDE CT_OnOff, --Automatically Adjust Spacing of Latin and East Asian Text
  autoSpaceDN CT_OnOff, --Automatically Adjust Spacing of East Asian Text and Numbers
  bidi CT_OnOff, --Right to Left Paragraph Layout
  cnfStyle CT_Cnf, --Paragraph Conditional Formatting
  contextualSpacing CT_OnOff, --Ignore Spacing Above and Below When Using Identical Styles
  divId CT_DecimalNumber, --Associated HTML div ID
  framePr CT_FramePr, --Text Frame Properties
  ind CT_Ind,
  jc CT_Jc, --Paragraph Alignment
  keepLines CT_OnOff, --Keep All Lines On One Page
  keepNext CT_OnOff, --Keep Paragraph With Next Paragraph
  kinsoku CT_OnOff, --Use East Asian Typography Rules for First and Last Character per Line
  mirrorIndents CT_OnOff, --Use Left/Right Indents as Inside/Outside Indents
  numPr CT_NumPr, --Numbering Definition Instance Reference
  outlineLvl CT_DecimalNumber, --Associated Outline Level
  overflowPunct CT_OnOff, --Allow Punctuation to Extent Past Text Extents
  pageBreakBefore CT_OnOff, --Start Paragraph on Next Page
  pBdr CT_PBdr, --Paragraph Borders
  -- pPrChange --Revision Information for Paragraph Properties
  pStyle CT_String,--Referenced Paragraph Style
  rPr CT_rPr, --v2.0.0 Run Properties for the Paragraph Mark
  sectPr CT_SectPr, --Section Properties
  shd CT_Shd,--Paragraph Shading
  snapToGrid CT_OnOff, --Use Document Grid Settings for Inter-Line Paragraph Spacing
  spacing CT_Spacing, --Spacing Between Lines and Above/Below Paragraph
  suppressAutoHyphens CT_OnOff, --Suppress Hyphenation for Paragraph
  suppressLineNumbers CT_OnOff, --Suppress Line Numbers for Paragraph
  suppressOverlap CT_OnOff, --Prevent Text Frames From Overlapping
  tabs CT_Tabs, --Set of Custom Tab Stops
  textAlignment CT_TextAlignment, --Vertical Character Alignment on Line
  textboxTightWrap CT_TextboxTightWrap, --Allow Surrounding Paragraphs to Tight Wrap to Text Box Contents
  textDirection CT_TextDirection, --Paragraph Text Flow Direction
  topLinePunct CT_OnOff, --Compress Punctuation at Start of a Line
  widowControl CT_OnOff, --Allow First/Last Line to Display on a Separate Page
  wordWrap CT_OnOff --Allow Line Breaking At Character Level
  );
--
type CT_P is record (
  tag plx_sc.normalv2, --v1.3.0
  pPr CT_PPr, --Paragraph Properties
  pcontent t_pcontents,
  rsidRPr plx_sc.normalv2, --ST_LongHexNumber
  rsidR plx_sc.normalv2, --ST_LongHexNumber
  rsidDel plx_sc.normalv2, --ST_LongHexNumber
  rsidP plx_sc.normalv2, --ST_LongHexNumber
  rsidRDefault plx_sc.normalv2 --ST_LongHexNumber
  );
---- ST_LevelSuffix
subtype ST_LevelSuffix is ploffx_util.t_string;
--v2.0.0
c_tab constant ST_LevelSuffix := 'tab';
c_nothing constant ST_LevelSuffix := 'nothing';
c_space constant ST_LevelSuffix := 'space';
---- ST_TblWidth
subtype ST_TblWidth is ploffx_util.t_string;
--v2.0.0
--c_nil constant ST_TblWidth := 'nil'; duplicated
c_pct constant ST_TblWidth := 'pct';
c_dxa constant ST_TblWidth := 'dxa';
-- c_auto constant ST_TblWidth := 'auto'; --dupli
type CT_TblWidth is record(
  tag plx_sc.normalv2, --v1.3.0
  w plx_sc.normalv2, --ST_DecimalNumber
  type_ ST_TblWidth
  );
--Table Borders Exceptions
type CT_TblBorders is record(
  tag plx_sc.normalv2, --v1.3.0
  top CT_Border,
  left CT_Border,
  bottom CT_Border,
  right CT_Border,
  insideH CT_Border,
  insideV CT_Border
  );
--
subtype ST_TblOverlap  is ploffx_util.t_string;
--v2.0.0
c_never   constant ST_TblOverlap :='never';
c_overlap   constant ST_TblOverlap :='overlap';
--
type CT_TblOverlap is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TblOverlap
  );
--
subtype ST_JcTable is ploffx_util.t_string;
--v2.0.0
-- c_center   constant ST_JcTable :='center'; --dupli
-- c_end   constant ST_JcTable :='end'; --dupli
c_start   constant ST_JcTable :='start';
--
type CT_JcTable is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_JcTable
  );
----Table Cell Margin Defaults
type CT_TblCellMar is record(
     tag plx_sc.normalv2, --v1.3.0
     top CT_TblWidth,
     left CT_TblWidth,
     bottom CT_TblWidth,
     right CT_TblWidth
);
--CT_TblPPr
type CT_TblPPr is record (
   tag plx_sc.normalv2, --v1.3.0
   leftFromText plx_sc.normalv2, --ST_TwipsMeasure
   rightFromText plx_sc.normalv2, --ST_TwipsMeasure
   topFromText plx_sc.normalv2, --ST_TwipsMeasure
   bottomFromText plx_sc.normalv2, --ST_TwipsMeasure
   vertAnchor ST_VAnchor,
   horzAnchor ST_HAnchor,
   tblpXSpec ST_XAlign,
   tblpX plx_sc.normalv2, --ST_SignedTwipsMeasure
   tblpYSpec ST_YAlign,
   tblpY plx_sc.normalv2 --ST_SignedTwipsMeasure
  );
--ST_TblLayoutType
subtype ST_TblLayoutType is ploffx_util.t_string;
--v2.0.0
c_fixed constant ST_TblLayoutType :='fixed';
c_autofit constant ST_TblLayoutType :='autofit';
--CT_TblLayoutType
type CT_TblLayoutType is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_TblLayoutType
  );
--
type CT_TblLook is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2
  );
--
type CT_TblPr is record (
  tag plx_sc.normalv2, --v1.3.0
  tblStyle CT_String,
  tblpPr CT_TblPPr,
  tblOverlap CT_TblOverlap,
  bidiVisual CT_OnOff,
  tblStyleRowBandSize CT_DecimalNumber,
  tblStyleColBandSize CT_DecimalNumber,
  tblW CT_TblWidth,
  jc CT_JcTable,
  tblCellSpacing CT_TblWidth,
  tblInd CT_TblWidth,
  tblBorders CT_TblBorders,
  shd CT_Shd,
  tblLayout CT_TblLayoutType,
  tblCellMar CT_TblCellMar,
  tblLook CT_TblLook,
  tblCaption CT_String,
  tblDescription CT_String
  -- tblPrChange CT_TblPrChange
  );
--ST_HMerge
subtype ST_HMerge is ploffx_util.t_string;
--v2.0.0
c_continue constant ST_HMerge :='continue';
c_restart constant ST_HMerge :='restart';
--
type CT_HMerge is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_HMerge
  );
--
type CT_TcBorders is record (
  tag plx_sc.normalv2, --v1.3.0
  top CT_Border,
  left CT_Border,
  bottom CT_Border,
  right CT_Border,
  insideH CT_Border,
  insideV CT_Border,
  tl2br CT_Border,
  tr2bl CT_Border
  );
--
type CT_TcMar is record (
  tag plx_sc.normalv2, --v1.3.0
  top CT_TblWidth,
  left CT_TblWidth,
  bottom CT_TblWidth,
  right CT_TblWidth
  );
--ST_Merge
subtype ST_Merge is ploffx_util.t_string;
--v2.0.0
-- c_continue constant ST_Merge :='continue'; --dupli
-- c_restart constant ST_Merge :='restart'; --dupli
--
type CT_VMerge is record (
  tag plx_sc.normalv2, --v1.3.0
  val ST_Merge
  );
--
type CT_TcPr is record (
  tag plx_sc.normalv2, --v1.3.0
  -- cellDel
  -- cellIns
  -- cellMerge
  cnfStyle CT_Cnf,
  gridSpan CT_DecimalNumber,
  hideMark CT_OnOff,
  hMerge CT_HMerge,
  noWrap CT_OnOff,
  shd CT_Shd,
  tcBorders CT_TcBorders,
  tcFitText CT_OnOff,
  tcMar CT_TcMar,
  -- tcPrChange CT_TcPrChange
  tcW CT_TblWidth,
  textDirection CT_TextDirection,
  vAlign CT_VerticalJc,
  vMerge CT_VMerge
  );
--
type t_blocks is table of pls_integer; --block_item_ref
v_blocks_empty t_blocks := t_blocks();
--
type CT_tc is record (
  tag plx_sc.normalv2, --v1.3.0
  tcPr CT_TcPr,
  blocks t_blocks -- EG_BlockLevelElts
  );
--
type t_cellcontents is table of pls_integer; --cell_item_ref
v_cellcontents_empty t_cellcontents := t_cellcontents();
--v1.3.0
type CT_CustomXmlCell is record (
  customXmlPr CT_CustomXmlPr,
  cellcontents  t_cellcontents,
  uri plx_sc.normalv2,
  element plx_sc.normalv2
  );
--
type t_cellcontent is record (
  cellcontent_type varchar2(255 char),
  tc CT_tc,
  bookmarkEnd CT_MarkupRange, --Bookmark End
  bookmarkStart CT_Bookmark, --Bookmark Start
  customXml CT_CustomXmlCell,
  sdt ploffx_document_type.CT_Sdt -- sdt CT_SdtCell
  -- EG_RunLevelElts
  );
--
type t_cellcontent_items is table of t_cellcontent;
v_cellcontent_items_empty t_cellcontent_items := t_cellcontent_items();
--
type CT_Height is record (
  tag plx_sc.normalv2, --v1.3.0
  val plx_sc.normalv2, --ST_TwipsMeasure
  hRule ST_HeightRule
  );

type CT_TrPr is record (
  tag plx_sc.normalv2, --v1.3.0
  cnfStyle CT_Cnf,
  divId CT_DecimalNumber,
  gridBefore CT_DecimalNumber,
  gridAfter CT_DecimalNumber,
  wBefore CT_TblWidth,
  wAfter CT_TblWidth,
  cantSplit CT_OnOff,
  trHeight CT_Height,
  tblHeader CT_OnOff,
  tblCellSpacing CT_TblWidth,
  jc CT_JcTable,
  hidden CT_OnOff
  -- ins CT_TrackChange
  -- del CT_TrackChange
  -- trPrChange CT_TrPrChange
  );
--
type CT_Row is record (
  tag plx_sc.normalv2, --v1.3.0
  -- tblPrEx CT_TblPrEx,
  trPr CT_TrPr,
  cellcontents  t_cellcontents, -- EG_ContentCellContent
  rsidRPr plx_sc.normalv2, -- ST_LongHexNumber
  rsidR plx_sc.normalv2, -- ST_LongHexNumber
  rsidDel plx_sc.normalv2, -- ST_LongHexNumber
  rsidTr plx_sc.normalv2 -- ST_LongHexNumber
  );
--
type t_rowcontents is table of pls_integer; --row_item_ref
v_rowcontents_empty t_rowcontents := t_rowcontents();
--v1.3.0
type CT_CustomXmlRow is record (
  customXmlPr CT_CustomXmlPr,
  rowcontents t_rowcontents,
  uri plx_sc.normalv2,
  element plx_sc.normalv2
  );
--
type t_rowcontent is record (
  rowcontect_type varchar2(255 char),
  bookmarkEnd CT_MarkupRange, --Bookmark End
  bookmarkStart CT_Bookmark, --Bookmark Start
  tr CT_Row,
  customXml CT_CustomXmlRow,
  sdt ploffx_document_type.CT_Sdt -- sdt CT_SdtRow,
  -- EG_RunLevelElts
  );
--
type t_rowcontent_items is table of t_rowcontent;
v_rowcontent_items_empty t_rowcontent_items := t_rowcontent_items();
--
type CT_TblGridCol is record (
  tag plx_sc.normalv2, --v1.3.0
  w plx_sc.normalv2 --ST_TwipsMeasure
  );
--
type t_gridCols is table of CT_TblGridCol;
v_gridCols_empty t_gridCols := t_gridCols();
--
type CT_TblGrid is record (
  tag plx_sc.normalv2, --v1.3.0
  gridCols t_gridCols
  -- tblGridChange
  );
--
type CT_Tbl is record(
  tag plx_sc.normalv2, --v1.3.0
  tblGrid CT_TblGrid, --(Table Grid)
  tblPr CT_TblPr, -- (Table Properties)
  rowcontents t_rowcontents --EG_ContentRowContent
  -- EG_RangeMarkupElements
  );
--v1.3.0
type CT_CustomXmlBlock is record (
  tag plx_sc.normalv2, --v1.3.0
  customXmlPr CT_CustomXmlPr,
  blocks t_blocks,
  uri plx_sc.normalv2,
  element plx_sc.normalv2
  );
-- v3.0.0
-- CT_SdtListItem
type CT_SdtListItem is record(
     tag plx_sc.normalv2,
     displayText plx_sc.normalv2, -- ST_String
     value_ plx_sc.normalv2 -- ST_String
);
-- v3.0.0
-- t_SdtListItem
type t_SdtListItem is table of CT_SdtListItem;
v_sdtlistitem_empty t_SdtListItem := t_SdtListItem();
-- v3.0.0
-- CT_SdtComboBox
type CT_SdtComboBox is record(
     tag plx_sc.normalv2,
     lastValue plx_sc.normalv2, -- ST_String
     listItem t_SdtListItem
);
-- v3.0.0
-- ST_SdtDateMappingType
subtype ST_SdtDateMappingType is ploffx_util.t_string;
c_date constant ST_SdtDateMappingType := 'date';
c_dateTime constant ST_SdtDateMappingType := 'dateTime';
-- c_text constant ST_SdtDateMappingType := 'text'; --dupli
-- v3.0.0
-- CT_SdtDateMappingType
type CT_SdtDateMappingType is record(
     tag plx_sc.normalv2,
     val ST_SdtDateMappingType
);
-- v3.0.0
-- ST_CalendarType
subtype ST_CalendarType is ploffx_util.t_string;
c_gregorian constant ST_CalendarType := 'gregorian';
c_gregorianXlitEnglish constant ST_CalendarType := 'gregorianXlitEnglish';
c_gregorianXlitFrench constant ST_CalendarType := 'gregorianXlitFrench';
c_hebrew constant ST_CalendarType := 'hewbrew';
c_hijri constant ST_CalendarType := 'hijri';
c_japan constant ST_CalendarType := 'japan';
c_korea constant ST_CalendarType := 'korea';
c_saka constant ST_CalendarType := 'saka';
c_taiwan constant ST_CalendarType := 'taiwan';
c_thai constant ST_CalendarType := 'thai';
-- v3.0.0
-- CT_CalendarType
type CT_CalendarType is record(
     tag plx_sc.normalv2,
     val ST_CalendarType
);
-- v3.0.0
-- CT_Lang
type CT_Lang is record(
     tag plx_sc.normalv2,
     val ST_Lang
);
-- v3.0.0
-- CT_SdtDate
type CT_SdtDate is record(
     tag plx_sc.normalv2,
     fullDate plx_sc.normalv2, -- ST_DateTime
     dateFormat CT_String,
     lid CT_Lang,
     storeMappedDataAs CT_SdtDateMappingType,
     calendar CT_CalendarType
);
-- v3.0.0
-- CT_SdtDropDownList
type CT_SdtDropDownList is record(
     tag plx_sc.normalv2,
     lastValue plx_sc.normalv2, -- ST_String
     listItem t_SdtListItem
);
-- v3.0.0
-- CT_Placeholder
type CT_Placeholder is record(
     tag plx_sc.normalv2,
     docPart CT_String
);
-- v3.0.0
-- CT_SdtText
type CT_SdtText is record(
     tag plx_sc.normalv2,
     multiLine ST_OnOff
);
-- v3.0.0
-- CT_SdtPr
type CT_SdtPr is record(
     tag plx_sc.normalv2,
     alias CT_String,
     -- bibliography
     -- citation
     comboBox CT_SdtComboBox,
     -- dataBinding
     date_ CT_SdtDate,
     -- docPartList
     -- docPartObj
     dropDownList CT_SdtDropDownList,
     -- equation
     -- group
     tag_ CT_String,
     id CT_DecimalNumber,
     -- lock
     picture CT_Empty,
     placeholder CT_Placeholder,
     richText CT_Empty,
     rpr CT_RPr,
     -- showingPlcHdr
     -- temporary
     text CT_SdtText
);
--v3.2.0
-- t_sdtConent
type t_sdtContent is record(
     tag plx_sc.normalv2,
     sdtContentType plx_sc.normalv2,
     bookmarkEnd CT_MarkupRange, --Bookmark End
     bookmarkStart CT_Bookmark, --Bookmark Start
     fldSimple pls_integer,
     -- commentRangeEnd
     -- commentRangeStart
     -- del
     -- ins
     -- moveFrom
     -- moveFromRangeEnd
     -- moveFromRangeStart
     -- moveTo
     -- moveToRangeEnd
     -- moveToRangeStart
     -- oMath
     -- oMathPara
     r pls_integer,
     p pls_integer,
     -- permEnd
     -- permStart
     -- proofErr
     sdt pls_integer,
     tbl pls_integer,
     tc pls_integer,
     tr pls_integer

);
--
type t_sdtContents is table of t_sdtContent;
v_sdtContents_empty t_sdtContents := t_sdtContents();
--v3.2.0
-- CT_SdtContent
type CT_SdtContent is record(
     tag plx_sc.normalv2,
     sdtContents t_sdtContents
);
--v3.0.0
-- CT_Sdt
type CT_Sdt is record(
     tag plx_sc.normalv2,
     sdtPr CT_SdtPr,
     sdtContent CT_SdtContent
     -- sdtEndPr CT_SdtEndPr
);
--v3.0.0
-- t_SdtItems
type t_SdtItems is table of CT_Sdt;
-- t_block_item
type t_block_item is record (
  block_type varchar2(255 char),
  -- altChunk --Anchor for Imported External Content
  bookmarkEnd CT_MarkupRange, --Bookmark End
  bookmarkStart CT_Bookmark, --Bookmark Start
  -- commentRangeEnd --Comment Anchor Range End
  -- commentRangeStart --Comment Anchor Range Start
  customXml CT_CustomXmlBlock, --Block-Level Custom XML Element
  -- customXmlDelRangeEnd --Custom XML Markup Deletion End
  -- customXmlDelRangeStart --Custom XML Markup Deletion Start
  -- customXmlInsRangeEnd --Custom XML Markup Insertion End
  -- customXmlInsRangeStart --Custom XML Markup Insertion Start
  -- customXmlMoveFromRangeEnd --Custom XML Markup Move Source End
  -- customXmlMoveFromRangeStart --Custom XML Markup Move Source Start
  -- customXmlMoveToRangeEnd --Custom XML Markup Move Destination Location End
  -- customXmlMoveToRangeStart --Custom XML Markup Move Destination Location Start
  -- del --Deleted Run Content
  -- ins --Inserted Run Content
  -- moveFrom --Move Source Run Content
  -- moveFromRangeEnd --Move Source Location Container - End
  -- moveFromRangeStart --Move Source Location Container - Start
  -- moveTo --MpEnd --Move Destination Location Container - End
  -- moveToRangeStart --Move Destination Location Container - Start
  -- oMath --Office Math
  -- oMathPara --Math Paragraph
  p CT_P, --Paragraph
  -- permEnd --Range Permission End
  -- permStart --Range Permission Start
  -- proofErr --Proofing Error Anchor
  sdt CT_Sdt, -- sdt --Block-Level Structured Document Tag
  tbl CT_Tbl --Table
  );
--
type t_block_items is table of t_block_item;
v_block_items_empty t_block_items := t_block_items();
--
type CT_Body is record (
  tag plx_sc.normalv2, --v1.3.0
  blocks t_blocks, --EG_BlockLevelElts
  sectPr CT_SectPr --Section properties
  );
--
type CT_Document is record (
  tag plx_sc.normalv2, --v1.3.0
  background CT_Background,
  body CT_Body
  );
---- ST_StyleType
subtype ST_StyleType is ploffx_util.t_string;
--v2.0.0
--c_paragraph constant ST_StyleType := 'paragraph'; --dupli
--c_character constant ST_StyleType := 'character'; --dupli
c_table constant ST_StyleType := 'table';
c_numbering constant ST_StyleType := 'numbering';
--
--Previous Table Properties
type CT_TblPrBase is record (
  tag plx_sc.normalv2, --v1.3.0
  -- tblStyle --CT_String
  -- tblpPr --CT_TblPPr
  -- tblOverlap --CT_TblOverlap
  -- bidiVisual -- ploffx_document.CT_OnOff
  -- tblStyleRowBandSize --CT_DecimalNumber
  -- tblStyleColBandSize --CT_DecimalNumber
  -- tblW --CT_TblWidth
  -- jc --CT_Jc
  -- tblCellSpacing --CT_TblWidth
  tblInd CT_TblWidth,
  tblBorders CT_TblBorders,
  -- shd --CT_Shd
  -- tblLayout --CT_TblLayoutType
  tblCellMar CT_TblCellMar
  -- tblLook --CT_ShortHexNumber
  );
--
--ST_TblStyleOverrideType
subtype ST_TblStyleOverrideType is ploffx_util.t_string; ---v4.9.3
c_wholeTable constant ST_TblStyleOverrideType :='wholeTable';
c_firstRow constant ST_TblStyleOverrideType :='firstRow';
c_lastRow constant ST_TblStyleOverrideType :='lastRow';
c_firstCol constant ST_TblStyleOverrideType :='firstCol';
c_lastCol constant ST_TblStyleOverrideType :='lastCol';
c_band1Vert constant ST_TblStyleOverrideType :='band1Vert';
c_band2Vert constant ST_TblStyleOverrideType :='band2Vert';
c_band1Horz constant ST_TblStyleOverrideType :='band1Horz';
c_band2Horz constant ST_TblStyleOverrideType :='band2Horz';
c_neCell constant ST_TblStyleOverrideType :='neCell';
c_nwCell constant ST_TblStyleOverrideType :='nwCell';
c_seCell constant ST_TblStyleOverrideType :='seCell';
c_swCell constant ST_TblStyleOverrideType :='swCell';
--
--CT_TblStylePr
type CT_TblStylePr is record( --v4.9.3
  type_ ST_TblStyleOverrideType,
  tag plx_sc.normalv2,
  pPr CT_PPr,
  rPr CT_RPr,
  tblPr CT_TblPrBase,
  trPr CT_TrPr,
  tcPr CT_TcPr
  );
--
--
subtype XT_Date is ploffx_util.t_string;
c_yyyyMMd constant XT_Date := ' \@ yyyy.mmmm.d.';
c_yyMMMd constant XT_Date := ' \@ yy.MMMd. ';
c_ddddyyMMMMd constant XT_Date := ' \@ dddd,\ yyyy.\ MMMM\ d.';
c_yyyyMMMMd constant XT_Date := ' \@ yyyy.\ MMMM\ d. ';
c_yyyyMMMd constant XT_Date := ' \@ yyyy.MMMd. ';
c_yyyyMMdd constant XT_Date := ' \@ yyyy-MM-d';
--
subtype XT_Author is ploffx_util.t_string;
c_caps constant XT_Author := ' \* Caps';
c_firstcap constant XT_Author := ' \* FirstCap';
c_lower constant XT_Author := ' \* Lower';
c_upper constant XT_Author := ' \* Upper';
--
subtype XT_Numbering is ploffx_util.t_string;
c_symbol constant XT_Numbering := 'symbol';
c_arabic constant XT_Numbering := 'arabic';
--multilevel constant XT_Numbering := 'multilevel'; dupli
--
subtype XT_FontName is ploffx_util.t_string;
c_Calibri constant XT_FontName := 'Calibri';
c_Verdana constant XT_FontName := 'Verdana';
c_TimesNewRoman constant XT_FontName := 'Times New Roman';
c_Arial constant XT_FontName := 'Arial';
c_Cambria constant XT_FontName := 'Cambria';
c_Garamond constant XT_FontName := 'Garamond';
c_Georgia constant XT_FontName := 'Georgia';
c_TrebuchetMS constant XT_FontName := 'Trebuchet MS';
/*
  PageHeight
*/
c_pageHeight_A4 constant varchar2(10) := '16838';
/*
  PageWidth
*/
c_pageWidth_A4 constant varchar2(10) := '11906';
--
/******************************************************************/
end ploffx_document_type;
/

